# This is perl script to make Japanese NLS DLLsfor tcsh-win32
# run under nls directory

# version 6.08.03-01 1999/02/13 (nayuta@is.s.u-tokyo.ac.jp)

# This needs:
#	perl.exe
#	nkf.exe
#	Visual C++  ( cl.exe rc.exe etc.)

$CC     = "cl -W3 -MT -c";	# compiler
$RC     = "rc /r";		# resource compiler
$NKFin  = "nkf -e";		# nkf (in)
$NKFout = "nkf -E -s";		# nkf (out)
$LINK = "link -machine:ix86 -dll -nodefaultlib libcmt.lib kernel32.lib -out:";

select(STDOUT); $| = 1;

### make stubdll.obj
$stub = "stubdll";
open(OUT, ">$stub.c");
print OUT <<"EOF;";
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
BOOL WINAPI DllEntryPoint(HINSTANCE hdll,DWORD dwreason,LPVOID ignore) {
    return 1;
}
EOF;
close(OUT);
system("$CC $stub.c > nul 2> nul");
unlink("$stub.c");

### make tcsh$nls.dll
while ($nls = <ja.*>) {
    print "making tcsh$nls.dll ... ";
    
    ### make tcsh$nls.rc
    open(OUT, "|$NKFout >tcsh$nls.rc");
    
    print OUT "#include <windows.h>\n";
    print OUT "STRINGTABLE DISCARDABLE\n";
    print OUT "BEGIN\n";
    
    for ($i = 1; $i < 32; $i ++) {
	
	$filename = "$nls/set$i";
	if (! -e $filename) {
	    next;
	}
	print "$i ";
	
 	open(IN, "$NKFin $filename |");
 	while (<IN>) {
 	    chop $_;
 	    if (/^\$/) {
 		print OUT "//$_\n";
 	    }
 	    else {
 		s/\"/\"\"/g;	# escape "
 		($num, $line) = split(' ', $_, 2);
 		print OUT ($i * 10000 + $num);
 		print OUT " \"$line\"\n";
 	    }
 	}
    }
    print OUT "END\n";
    close(OUT);
    print "\n";
    
    ### make tcsh$nls.res
    system("$RC tcsh$nls.rc") && next;
    unlink("tcsh$nls.rc");

    ### make tcsh$nls.dll
    system($LINK . "tcsh$nls.dll tcsh$nls.res $stub.obj > nul");
    unlink("tcsh$nls.res");
}

unlink("$stub.obj");
