# Tamito KAJIYAMA <18 February 2002>
# $Id: seriko.py,v 1.2 2004/01/26 02:08:59 shy Exp $

import re
import string
import sys
import whrandom

def print_error(message):
    sys.stderr.write(message + "\n")

class Actor:
    def __init__(self, id, interval):
        self.id = id
        self.interval = interval
        self.patterns = []
        self.last_method = None
        self.exclusive = 0
    def set_exclusive(self):
        self.exclusive = 1
    def get_id(self):
        return self.id
    def get_interval(self):
        return self.interval
    def get_patterns(self):
        return self.patterns
    def add_pattern(self, surface, interval, method, args):
        self.patterns.append((surface, interval, method, args))
    def invoke(self):
        pass
    def update(self, window):
        pass
    def terminate(self):
        pass
    def show_pattern(self, window, surface, method, args):
        if self.last_method in ["overlay", "overlayfast"]:
            window.remove_overlay(self)
        if method == "move":
            window.move_surface(args[0], args[1])
        elif method in ["overlay", "overlayfast"]:
            window.add_overlay(self, surface, args[0], args[1])
        elif method == "base":
            window.surface_id = self.surface_id # This is kluge.
            window.set_surface(surface, reset=0)
        elif method == "start":
            window.invoke(args[0])
        elif method == "alternativestart":
            window.invoke(whrandom.choice(args))
        else:
            raise RuntimeError, "should not reach here"
        self.last_method = method

class ActiveActor(Actor): # always
    def __init__(self, id, interval):
        Actor.__init__(self, id, interval)
        self.wait = 0
        self.pattern = 0
    def update(self, window):
        self.wait = self.wait - 1
        if self.wait > 0:
            return
        if self.pattern == 0:
            self.surface_id = window.get_surface()
        surface, interval, method, args = self.patterns[self.pattern]
        self.wait = interval
        self.pattern = self.pattern + 1
        if self.pattern == len(self.patterns):
            self.pattern = 0
        self.show_pattern(window, surface, method, args)

class RandomActor(Actor): # sometimes, rarely, randome
    def __init__(self, id, interval, wait_min, wait_max):
        Actor.__init__(self, id, interval)
        self.wait_min = wait_min
        self.wait_max = wait_max
        self.reset()
    def reset(self):
        self.wait = whrandom.randint(self.wait_min, self.wait_max)
        self.pattern = 0
    def invoke(self):
        self.wait = 0
        self.pattern = 0
    def update(self, window):
        self.wait = self.wait - 1
        if self.wait > 0:
            return
        if self.pattern == 0:
            self.surface_id = window.get_surface()
        surface, interval, method, args = self.patterns[self.pattern]
        self.pattern = self.pattern + 1
        if self.pattern < len(self.patterns):
            self.wait = interval
        else:
            self.reset()
        self.show_pattern(window, surface, method, args)
    def terminate(self):
        self.reset()

class OneTimeActor(Actor): # runone
    def __init__(self, id, interval):
        Actor.__init__(self, id, interval)
        self.wait = -1
        self.pattern = 0
    def invoke(self):
        self.wait = 0
        self.pattern = 0
    def update(self, window):
        if self.wait < 0:
            return
        self.wait = self.wait - 1
        if self.wait > 0:
            return
        if self.pattern == 0:
            self.surface_id = window.get_surface()
        surface, interval, method, args = self.patterns[self.pattern]
        self.pattern = self.pattern + 1
        if self.pattern < len(self.patterns):
            self.wait = interval
        else:
            self.wait = -1 # done
        self.show_pattern(window, surface, method, args)
    def terminate(self):
        self.wait = -1

class PassiveActor(Actor): # never, yen-e, talk
    def __init__(self, id, interval):
        Actor.__init__(self, id, interval)
        self.wait = -1
    def invoke(self):
        self.wait = 0
        self.pattern = 0
    def update(self, window):
        if self.wait < 0:
            return
        self.wait = self.wait - 1
        if self.wait > 0:
            return
        if self.pattern == 0:
            self.surface_id = window.get_surface()
        surface, interval, method, args = self.patterns[self.pattern]
        self.pattern = self.pattern + 1
        if self.pattern < len(self.patterns):
            self.wait = interval
        else:
            self.wait = -1 # done
        self.show_pattern(window, surface, method, args)
    def terminate(self):
        self.wait = -1

re_interval = re.compile("^([0-9]+)interval$")
re_interval_value = re.compile("^(sometimes|rarely|random,[0-9]+|always|runonce|yesn-e|talk,[0-9]+|never)$")
re_pattern = re.compile(r"^([0-9]+|-[12])\s*,\s*([+-]?[0-9]+)\s*,\s*(overlay|overlayfast|base|move|start|alternativestart|)\s*,?\s*([+-]?[0-9]+)?\s*,?\s*([+-]?[0-9]+)?\s*,?\s*(\[[0-9]+(\.[0-9]+)*\])?$")

def get_actors(config):
    buffer = []
    for key, value in config.items():
        match = re_interval.match(key)
        if not match or not re_interval_value.match(value):
            continue
        buffer.append((int(match.group(1)), value))
    actors = []
    for id, interval in buffer:
        if interval == "always":
            actor = ActiveActor(id, interval)
        elif interval == "sometimes":
            actor = RandomActor(id, interval, 0, 1000) # 0 to 10 seconds
        elif interval == "rarely":
            actor = RandomActor(id, interval, 2000, 6000)
        elif interval[:6] == "random":
            actor = RandomActor(id, interval, 0, 100 * int(interval[7]))
        elif interval == "runonce":
            actor = OneTimeActor(id, interval)
        elif interval == "yen-e":
            actor = PassiveActor(id, interval)
        elif interval[:4] == "talk":
            actor = PassiveActor(id, interval)
        elif interval == "never":
            actor = PassiveActor(id, interval)
        key = str(id) + 'option'
        if config.has_key(key) and config[key] == 'exclusive':
            actor.set_exclusive()
        try:
            for n in range(128): # up to 128 patterns (0 - 127)
                key = str(id) + "pattern" + str(n)
                if not config.has_key(key):
                    key = str(id) + "patturn" + str(n)
                    if not config.has_key(key):
                        break
                pattern = config[key]                
                match = re_pattern.match(pattern)
                if not match:
                    raise ValueError, "unsupported pattern: %s" % pattern
                surface = str(int(match.group(1)))
                interval = abs(int(match.group(2)))
                method = match.group(3)
                if method == "":
                    method = "base"
                if method == "start":
                    group = match.group(4)
                    if group is None:
                        raise ValueError, "syntax error: %s" % pattern
                    args = [int(group)]
                elif method == "alternativestart":
                    list = match.group(6)
                    if list is None:
                        raise ValueError, "syntax error: %s" % pattern
                    args = map(int, string.split(list[1:-1], "."))
                else:
                    if surface in ["-1", "-2"]:
                        x = 0
                        y = 0
                    else:
                        x = int(match.group(4) or 0)
                        y = int(match.group(5) or 0)
                    args = [x, y]
                actor.add_pattern(surface, interval, method, args)
        except ValueError, error:
            print_error("seriko.py: " + str(error))
            continue
        if not actor.get_patterns():
            print_error("seriko.py: animation group #%d has no pattern (ignored)" % id)
            continue
        actors.append(actor)
    actors.sort(lambda a1, a2: cmp(a1.get_id(), a2.get_id()))
    return actors

# find ~/.ninix -name 'surface*a.txt' | xargs python seriko.py
def test():
    import sys
    import ninix.config
    if len(sys.argv) == 1:
        print "Usage:", sys.argv[0], "[surface??a.txt ...]"
    for file in sys.argv[1:]:
        print "Reading", file, "..."
        for actor in get_actors(ninix.config.open(file)):
            print "#%d" % actor.get_id(),
            print actor.__class__.__name__,
            print "(%s)" % actor.get_interval()
            print "number of patterns =", len(actor.get_patterns())
            for pattern in actor.get_patterns():
                print "surface=%s, interval=%d, method=%s, args=%s" % pattern

if __name__ == "__main__":
    test()
