#
#  lettuce.py - a LETTUCE compatible Saori module for ninix
#  Copyright (C) 2002, 2003 by Shyouzou Sugitani <shy@debian.or.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#  $Id: lettuce.py,v 1.3 2003/07/21 11:43:52 shy Exp $
#

import os
import re
import string
import StringIO
import signal
import socket
import time

class Saori:
    module_name = 'LETTUCE'
    dll_name = 'lettuce.dll'
    def __init__(self):
	self.loaded = 0
        self.files = {}
        self.sstpport = None
        self.sakura = None
    def use_sakura(self, sakura):
        self.sakura = sakura
    def load(self, dir=os.curdir):
        self.dir = dir
        result = 0
        if self.loaded:
	    result = 2
        elif self.sakura != None:
            signal.signal(signal.SIGCHLD, self.signal_handler)
            self.loaded = 1
            result = 1
	return result
    def unload(self):
        #for name in self.files.keys():
        #    pid = self.files[name]['pid']
        #    if pid:
        #        os.kill(pid, 9)
        #        os.waitpid(pid, 0)
        self.files = {}
        self.loaded = 0
        return 1
    def signal_handler(self, signum, frame):
        for name in self.files.keys():
            pid = self.files[name]['pid']
            if not pid:
                continue
            result = os.waitpid(pid, os.WNOHANG)
            if result:
                if os.WIFSTOPPED(result[1]):
                    self.files[name]['status'] = 'pause'
                else:
                    self.files[name]['pid'] = None
                    self.files[name]['status'] = 'stop'
                    ### send SSTP message ###
                    if os.WIFEXITED(result[1]) and self.sstpport:
                        address = ("", int(self.sstpport))
                        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                        try:
                            s.connect(address)
                        except socket.error:
                            sys.stderr.write("%s: cannot connect to the SSTP server\n" % self.module_name)
                            return
                        s.send("SEND SSTP/1.1\r\n"
                               "Sender: %s\r\n" % self.module_name + \
                               "Event: OnApplicationOperationFinish\r\n"
                               "Reference0: %s\r\n" % self.dll_name + \
                               "Reference1: play.finished\r\n"
                               "Reference2: %s\r\n" % name + \
                               "Charset: ASCII\r\n\r\n")
                        s.recv(1024)
                        s.close()
    def request(self, req):
        type, argument = self.evaluate_request(req)
        header = StringIO.StringIO(req)
        line = header.readline()
        if not type:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        elif type == 'GET Version':
            return 'SAORI/1.0 200 OK\r\n\r\n'
        elif type == 'EXECUTE':
            if len(argument) == 0:
                return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            command = argument[0]
            result = 0
            if command == 'set.hwnd':
                if len(argument) < 2:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                else:
                    self.sstpport = argument[1]
                    result = 1
            elif command == 'play':
                if len(argument) < 2:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                else:
                    name = string.replace(argument[1], '\\', '/') ## FIXME: Shiori -> filename
                    name = string.lower(name)
                    filepath = os.path.join(self.dir, './'+name+'ogg')
                if self.files.has_key(name):
                    pid = self.files[name]['pid']
                    if pid and self.files[name]['status'] == 'play':
                        try:
                            os.kill(-pid, 9)
                            os.waitpid(pid, 0)
                        except:
                            pass
                        self.files[name]['pid'] = 0
                else:
                    self.files[name] = {}
                if filepath:
                    pid = os.fork()
                    self.files[name]['pid'] = pid
                    if pid == 0:
                        os.setsid()
                        if os.path.isfile(filepath):
                            for regex, command in self.sakura.helpers:
                                if regex.search(filepath):
                                    self.execute_command(command, filepath)
                        os._exit(0)
                    self.files[name]['status'] = 'play'
                    result = 1
            elif command == 'play.ex':
                pass # FIXME
            elif command == 'stop':
                if len(argument) < 2:
                    for name in self.files.keys():
                        pid = self.files[name]['pid']
                        if pid:
                            try:
                                os.kill(-pid, 9)
                                os.waitpid(pid, 0)
                            except:
                                pass
                            self.files[name]['pid'] = 0
                    result = 1
                else:
                    name = string.replace(argv[1], '\\', '/')
                    name = string.lower(filename)
                    if self.files.has_key(name):
                        pid = self.files[name]['pid']
                        if pid:
                            try:
                                os.kill(-pid, 9)
                                os.waitpid(pid, 0)                        
                            except:
                                pass
                            self.files[name]['pid'] = 0
                        result = 1
            elif command == 'pause':
                pass # FIXME
            elif command == 'set.loop':
                pass # FIXME
            elif command == 'reset.loop':
                pass # FIXME
            return 'SAORI/1.0 200 OK\r\nResult: %s\r\n\r\n' % result
    def execute_command(self, command, arg):
        pos = string.find(command, "%s")
        if pos < 0:
            sys.stderr.write("cannot execute command (%s missing)\n")
            return
        os.system(command[:pos] + arg + command[pos+2:])
    def evaluate_request(self, req):
        type = None
        argument = []
        header = StringIO.StringIO(req)
        line = header.readline()
        if not line:
            return type, argument
        if line[-1] == '\n':
            line = line[:-1]
        line = string.strip(line)
        if not line:
            return type, argument
        for request in ['EXECUTE', 'GET Version']:
            if line[:len(request)] == request:
                type = request
                break
        while 1:
            line = header.readline()
            if not line:
                break # EOF
            if line[-1] == '\n':
                line = line[:-1]
            line = string.strip(line)
            if not line:
                continue
            colon = string.find(line, ':')
            if colon >= 0:
                key = string.strip(line[:colon])
                value = string.strip(line[colon+1:])
                if key[:8] == 'Argument':
                    argument.append(value)
                else:
                    continue
        return type, argument
