<?PHP

/*
* W-AGORA 4.1
* -----------
* $Id: admin_fr.inc,v 1.68 2005/02/09 15:20:15 mdruilhe Exp $
* Usage: Administration localized strings constant
* Description: This script is used to define strings used by the administration part of the application
* Author: Alexandre GHEZ (aghez@decan.fr)
*/

///////////////////
// file setup.php3
///////////////////
define ('ERROR_SETUP_ALREADY_DONE', 'w-Agora semble dj install,<br>Le fichier de configuration principal (<tt>%s</tt>) existe dj ,<br> Vous devez le supprimer manuellement (ainsi que les tables correspondantes) afin de r-installer w-agora.<br><br>Sinon, pressez le bouton ci-dessous si vous souhaitez crer un nouveau site');
define ('ERROR_MISSING_ADMIN_NAME', 'Vous devez indiquer le nom de l\'administrateur systme');
define ('ERROR_MISSING_ADMIN_EMAIL', 'Veuillez donner une adresse email valide pour l\'administrateur systme');
define ('ERROR_MISSING_DB_ACCESS', 'Vous devez indiquer le type d\'accs  la base de donnes');
define ('ERROR_BAD_PASSWORD', 'Vous devez donner un mot de passe et le saisir 2 fois  l\'identique pour contrle, merci de vrifier');
define ('ERROR_MISSING_DB_NAME', 'Veuillez fournir le nom de la base de donnes');
define ('ERROR_SF_CREATE_FILE', 'Impossible de crer un fichier dans le rpertoire <u>%s</u>, Veuillez vrifier les permissions, ou lire les instructions concernant l\'installation en SAFE MODE dans le fichier <a href="doc/INSTALL.txt">INSTALL.txt</a>');
define ('ERROR_COPY_FILE', 'Impossible de copier le fichier vers <u>%s</u>');
define ('ERROR_OPEN_DB', 'Connexion  la base de donnes <u>%s</u> impossible avec les paramtres suivant: serveur=<u>%s</u>, n port=<u>%s</u>, utilisateur=<u>%s</u>)');
define ('ERROR_CREATE_CONFIG_FILE', 'Impossible de crer le fichier de configuration<u>%s</u>, vrifiez les droits');
define ('LABEL_SETUP_DONE', 'w-agora a t install avec succs');
define ('LABEL_SETUP_AGORA', 'Installation de w-agora');

define ('CAPTION_DB_PARAMETERS', 'Paramtres de la base de donnes (pour la gestion des sites)');
define ('CAPTION_DEFAULT_PARAMETERS', 'Paramtres par dfaut pour les configuration de sites');
define ('CAPTION_ADMIN_INFO', 'Donnes utilisateur pour l\'administrateur systme (login : <u>admin</u>)');

define ('LABEL_ADMIN_NAME', 'Nom');
define ('LABEL_ADMIN_ADDRESS', 'adresse email');
define ('LABEL_ADMIN_PASSWORD1', 'Mot de passe');
define ('LABEL_ADMIN_PASSWORD2', 'Rptez le mot de passe (pour validation)');
define ('BUTTON_INSTALL', 'Installer');

/////////////////////
//File Init_Admin.inc
/////////////////////

// function display_header
define ('ADMINISTRATION_TITLE', "Administration de w-agora");

// function list_forums
define ('COLUMN_FORUM_ADMIN', "Grer le forum");
define ('COLUMN_EDIT', "Editer");
define ('COLUMN_DELETE', "Supprimer");
define ('COLUMN_CREATE', "Crer");
define ('COLUMN_ORDER', "Ordre");

define ('MSG_ADMINISTRATE_FORUM', "Grer le forum");
define ('ALT_DELETE_FORUM', "Supprimer le forum : %s");
define ('ALT_EDIT_FORUM', "Editer les proprits du forum: %s");

define ('ERROR_SITE_EMPTY', "Vous devez prciser un site pour accder  cette fonctionnalit.");
define ('ERROR_NO_CONFIG_FILE', "Impossible de lire le fichier de configuration ");
define ('ERROR_NO_ROOT', "Dsol mais vous devez tre connect en tant que super administrateur pour accder  cette fonctionnalit. Merci de vous reconnecter.");
define ('ERROR_NO_ADMIN', "Dsol mais vous devez tre connect en tant qu'administrateur pour accder  cette fonctionnalit. Merci de vous reconnecter.");
define ('ERROR_NO_MODERATOR', "Dsol mais vous devez tre connect en tant que modrateur pour accder  cette fonctionnalit. Merci de vous reconnecter.");

define ('TITLE_ADMINISTRATION_LOGIN', "Connexion  l'administration");
define ('TITLE_INVALID_LOGIN', "Identifiant invalide. Merci de vous reconnecter");

define ('ERROR_NO_DATABASE', "Impossible de se connecter  la base de donnes. Vrifiez les paramtres de connexions.");

//Function List User
define ('COLUMN_USER_ID', "Identifiant");
define ('COLUMN_USER_NAME', "Utilisateur");
define ('COLUMN_USER_PRIVILEGE', "Privilge");
define ('COLUMN_USER_REGISTERED', "Enregistr le");
define ('COLUMN_USER_LOGIN_COUNT', "# Connections");
define ('COLUMN_USER_LAST_LOGIN', "Dernire connection");
define ('COLUMN_USER_POST_COUNT', "# Messages");
define ('COLUMN_USER_LAST_POST', "Dernier message");
define ('COLUMN_ACTION', "Action");

define ('LABEL_REG_NO_CONTROL',"Enregistrement automatique");
define ('LABEL_REG_CHALLENGE_RESPONSE',"RFU");	
define ('LABEL_REG_ADMIN_APPROVAL',"Approbation pralable par l'administrateur");

/////////////////////
//File Create_Site.php3
/////////////////////
define ('FORM_NO_SITE', "Vous devez prciser un nom de site");
define ('FORM_NO_DESCRIPTION', "Veuillez prciser une description pour ce site");
define ('FORM_NO_DBACCESS', "Vous devez prciser un type de base de donnes");
define ('FORM_NO_DBNAME', "Vous devez prciser un nom de base de donnes");
define ('FORM_NO_DIRECTORY', "Vous devez prciser un nom de rpertoire");
define ('FORM_SITE_LONG', "Le nom du site est trop long, choisissez en un plus court");

define ('CHECK_SITE_EXISTS', "Le site {SITE} existe dj, vous devez soit le supprimer manuellement, soit choisir un autre nom");
define ('CHECK_CONFIG_EXISTS', "Le fichier de configuration (<tt>%s</tt>) existe dj, vous devez soit le supprimer manuellement, soit choisir un autre nom");

define ('ERROR_SAFE_MODE', "La directive PHP Safe Mode est active, vous devez crer manuellement le rpertoire : {DIRECTORY}");
define ('ERROR_CREATE_DIR', "Impossible de crer le rpertoire : {DIRECTORY}.");
define ('ERROR_NO_PERMISSIONS', "Vrifiez les permissions sur les fichiers");

define ('ERROR_ADMIN_NOT_FOUND', "Impossible de lire les proprits de l'utilisateur '{USER}' du site agora");

define ('ERROR_DB_DBM_EXISTS', "La base de donnes du site {SITE} existe dj, <br> Vous devez supprimer le fichier DBM : <em>dbm/{SITE}/{DATABASE}</em><br> [et le fichier .lck] manuellement");
define ('ERROR_DB_EXISTS', "La table du site {SITE} existe dj dans la base de donnes {DATABASE}, Vous devez d'abord supprimer cette table manuellement");
define ('ERROR_FILESYSTEM', "Problmes d'accs, vrifier l'espace disponible et les permissions sur les fichiers");
define ('ERROR_DB_ACCESS', "Problme d'accs, assurez-vous d'avoir cr une base de donnes {DATABASE} et vrifiez les droits d'accs");

define ('ERROR_CREATE_SITE', "Impossible de crer le site : {SITE}.");

define ('ERROR_TABLE_EXISTS', "La table ({TABLE}) existe dj dans la base de donnes {DATABASE}, vous devez d'abord la supprimer manuellement.");

define ('ERROR_CREATE_ADMIN', "Impossible de crer l'utilisateur {USER} dans le nouveau site");
define ('ERROR_CREATE_USER', "Impossible de crer l'utilisateur {USER} dans la table {TABLE}");
define ('ERROR_NO_ADD_SITE', "Impossible d'ajouter le site dans la base de donnes principale");

define ('LABEL_BACK', "Prcdent");
define ('LABEL_CREATE_SITE_DONE', "La cration du site {SITE} s'est droule avec succs.<BR><BR>&nbsp;&nbsp;Vous pouvez maintenant");
define ('LABEL_CREATE_FORUM', "Crer un forum");
define ('LABEL_CREATE_SITE', "Crer un site");
define ('LABEL_CREATE_THIS_SITE', "Crer ce site");
define ('LABEL_CREATE_NEW_SITE', "Crer un nouveau site");
define ('LABEL_CREATE_ANOTHER_SITE', "Crer un autre site");
define ('LABEL_ADMINISTRATE_SITE', "Grer ce site");
define ('LABEL_SITE_MANAGEMENT', "Grer les sites");
define ('CREATE_SITE_DONE', "La cration du site {SITE} s'est droule avec succs.");

define ('LABEL_SITE_NAME', "Entrez le nom du site");
define ('LABEL_SITE_TITLE', "Titre (courte description)");
define ('LABEL_SITE_DESCRIPTION', "Description");
define ('LABEL_DB_PARAMETERS', "Paramtres de la base de donnes");
define ('LABEL_DB_TYPE', "Type de la base");
define ('LABEL_DB_NAME', "Nom de la base");

define ('LABEL_DB_USER', "Utilisateur de la base");
define ('LABEL_DB_PASSWORD', "Mot de passe");

define ('LABEL_DB_ADMIN_USER', "Administrateur de la base (si vide, utiliser l'utilisateur de la base)");
define ('LABEL_DB_ADMIN_PASSWORD', "Mot de passe admin");
define ('LABEL_DB_SERVER_NAME', "Nom du serveur");
define ('LABEL_DB_SERVER_PORT', "Port TCP du serveur");
define ('LABEL_DB_USER_SOURCE', "Gestion des utilisateurs");

define ('LABEL_FORUMS_CONFIGURATION', "Configuration des forums");

define ('LABEL_FORUM_DIRECTORY', "Rpertoire d'installation des forums");
define ('LABEL_SEARCH_ENGINE', "Moteur de recherche");
define ('LABEL_DEFAULT_THEME', "Thme par dfaut");
define ('NOTICE_SAFEMODE', "La directive SAFE MODE de PHP est active");
define ('NOTICE_MANUAL_INSTALL', "Vous devez crer manuellement les rpertoires suivants avant de valider cette page");

/////////////////////
//File Admin.php3
/////////////////////
define ('TITLE_SITE_MANAGEMENT', "Gestion des sites");
define ('LABEL_SITES_OUTLINE', "Liste des sites");
define ('COLUMN_SITE_TITLE', "Sujet (titre)");

define ('ALT_DELETE_SITE', "Supprimer le site: %s");
define ('ALT_EDIT_SITE', "Editer les proprits du site : %s");
define ('ERROR_NO_SITE', "Aucun site n'est disponible.<br>Cliquez sur le bouton 'OK' pour crer un nouveau site.");

/////////////////////
//File Delete_Site.php3
/////////////////////
define ('TITLE_SITE_DELETE', "Suppression d'un site");
define ('ERROR_NO_DELETE', "Impossible de supprimer toutes les tables/fichiers du site {SITE}");
define ('ERROR_NO_DELETE_AGORA', "Impossible de supprimer l'entre pour le site {SITE} dans la base de donnes Agora");
define ('LABEL_FILE_REMOVING', "Suppression du fichier : ");
define ('LABEL_DIRECTORY_REMOVING', "Suppression du rpertoire : ");
define ('LABEL_SITE_REMOVING', "Le site {SITE}  t supprim avec succs.");
define ('LABEL_SITE_CONTENT', "Ce site contient les forums suivants :");
define ('LABEL_SITE_NO_CONTENT', "Ce site ne contient pas de forums");
define ('LABEL_SITE_DELETE_CONFIRMATION',"Etes-vous certain de vouloir supprimer le site '{SITE}' ?");
define ('LABEL_DELETE_THIS_SITE', "Supprimer ce site");

/////////////////////
//File Edit_Site.php3
/////////////////////
define ('TITLE_SITE_EDIT', "Edition des proprits du site");
define ('ERROR_NO_READ_SITE_PROPERTIES', "Impossible de lire les proprits du site {SITE}.");
define ('ERROR_NO_UPDATE_SITE_PROPERTIES',"Impossible de modifier les proprits du site {SITE}.");
define ('LABEL_SITE_EDITING', "Edition du site : ");
define ('LABEL_SITE_PROPERTIES', "Informations sur le site");
define ('LABEL_CHANGE_SITE_ADMINISTRATOR',"Slectionnez/modifiez l'utilisateur qui deviendra l'administrateur principal de ce site");
define ('COLUMN_SITE_REGISTRATION_MODE',"Mode d'enregistrement des utilisateurs");
define ('COLUMN_SITE_PASSWORD_HANDLING',"Mode de cration des mots de passe");

/////////////////////
//File editList.php3
/////////////////////
define ('NOTICE_DEFAULT_FILE', "Ce fichier est le fichier par dfaut de l'installation");
define ('ERROR_NO_CURRENT_FILE', "Pas de fichier courant");
define ('ERROR_OPEN_FILE', "Impossible d'ouvrir le fichier {FILE}");

define ('LABEL_MAXTHREADS', "Nombre maximum de discussions par page :");
define ('LABEL_PAD', "Motif de remplissage pour l'indentation des messages (utiliser la variable {pad}) :");
define ('LABEL_DEPTH_LIMIT', "Limitation de la profondeur d'affichage des discussions :");
define ('LABEL_BEFORE_LINE', "Script excut avant chaque ligne:");
define ('LABEL_SORT', "Ordre par dfaut:");
define ('LABEL_HOT_COLOR', "(messages trs rcents) Initialiser {date_color} avec:" );
define ('LABEL_NEW_COLOR', "(messages rcents) Initialiser {date_color} avec : " );
define ('LABEL_NORMAL_COLOR', "(messages anciens) Initialiser {date_color} avec : ");
define ('LABEL_HOT_AGE', "Age des messages les plus rcents (moins de, en secondes):" );
define ('LABEL_NEW_AGE', "Age des messages rcents (moins de, en secondes) :");
define ('LABEL_HOT_THRESHOLD', "Nombre de messages constituant un sujet <i>brlant</i> (0 = pas de limite) :");
define ('LABEL_TYPE_FILENAME', "Saisissez le nom du fichier");
define ('TITLE_SITE_OUTLINE', "Edition de la liste des sites");
define ('TITLE_FORUM_OUTLINE', "Edition de la liste des forums");
define ('TITLE_MESSAGE_OUTLINE', "Edition de la liste des messages");
define ('LABEL_FILE_EDITING', "Edition du fichier ");
define ('LABEL_THREAD_FIRSTLINE_ODD', "Premire ligne du fil (pair)");
define ('LABEL_THREAD_FIRSTLINE_EVEN', "Premire ligne du fil (impair)");
define ('LABEL_LEVEL_START', "Commencer un nouveau niveau avec");
define ('LABEL_LEVEL_END', "Finir le niveau avec");
define ('LABEL_LINE_CONTENT_ODD', "Contenu d'une ligne paire");
define ('LABEL_LINE_CONTENT_EVEN', "Contenu d'une ligne impaire");
define ('LABEL_THREAD_END', "Finir la discussion avec");
define ('LABEL_LIST_END', "Finir la liste avec");

define ('LABEL_GLOBAL_FORMAT', "Paramtres gnraux de la liste");
define ('LABEL_DEFAULT_ORDER', "Ordre par dfaut (en mode non arborescent)");
define ('LABEL_USE_COLOR', "Utiliser la couleur");
define ('LABEL_NEWEST_MESSAGE', "Derniers messages");
define ('LABEL_NEW_MESSAGE', "Nouveaux messages");
define ('LABEL_OLD_MESSAGE', "Anciens messages");
define ('LABEL_MESSAGES_NEWER_THAN', "Pour les messages de moins de ");
define ('LABEL_FORUM_OUTLINE', "Mise en page de la liste des forums");
define ('LABEL_HEAD_LISTING', "Entte de la liste");
define ('LABEL_CATEGORY_LINE', "Ligne catgorie");

define ('LABEL_SITE_OUTLINE', "Mise en page de la liste des sites");
define ('LABEL_SITE_LINE_ODD', "Ligne d'un site (pair)");
define ('LABEL_SITE_LINE_EVEN', "Ligne d'un site (impair)");

define ('LABEL_FORUM_LINE_ODD', "Ligne d'un forum (pair)");
define ('LABEL_FORUM_LINE_EVEN', "Ligne d'un forum (impair)");
define ('LABEL_BOTTOM_LISTING', "Fin de la liste");

define ('EDIT_THREAD_LIST', "Editer la liste des discussions (en mode LISTE) : ");
define ('LABEL_EDIT_SEARCH_LISTING' , "Edition de la liste des rsultats de la RECHERCHE : ");
define ('LABEL_SEARCH_FORM_TITLE', "Titre du forum (en recherche multi-forums)");

define ('EDIT_THREAD_VIEW', "Editer la liste des discussions (en mode VISUALISATION) : ");
define ('LABEL_FIRST_THREAD', "Premier message dans le fil");
define ('EDIT_THREAD_DOWNLOAD', "Editer la liste des discussions (en mode TELECHARGEMENT)");

/////////////////////
//File admin_site.php3
/////////////////////
define ('LABEL_AGORA_WEBSITE', 'Site Web de W-Agora');
define ('TITLE_SITE_ADMINISTRATION', 'Administration du site');
define ('LABEL_RELOGIN', 'S\'identifier  nouveau (changer d\'utilisateur)');
define ('LABEL_SITES', 'Liste des sites');
define ('LABEL_ADMINISTRATION_MAIN', 'Retourner  la page principale d\'administration');
define ('ALT_STATS', 'Voir les statistiques d\'activit du site %s');
define ('LABEL_ACCESS_THIS_SITE', 'Accder  ce site');
define ('ALT_ACCESS_SITE', 'Visualiser le site %s');

define ('LABEL_CATEGORIES', "Catgories");
define ('COLUMN_ADMIN_USERS', "Grer les utilisateurs");
define ('COLUMN_INACTIVE_USERS', "Lister les inactifs");
define ('COLUMN_MAIL_USERS', "Envoyer un e-mail");

define ('ALT_USER_EDIT', "Lister / Editer les utilisateurs enregistrs");
define ('ALT_USER_ADMIN', "Administrer les utilisateurs enregistrs");
define ('ALT_USER_ADD', "Ajouter un utilisateur");
define ('ALT_USER_DELETE',"Supprimer les utilisateurs enregistrs de ce site");
define ('ALT_INACTIVE_USERS',"Lister / Supprimer les utilisateurs inactifs");
define ('ALT_MAIL_USERS', "Envoyer un e-mail  tous les utilisateurs de ce site");
define ('ALT_CATEGORY_CREATE', "Ajouter une catgorie");
define ('ALT_CATEGORY_EDIT', "Editer une catgorie");

define ('COLUMN_MANAGE_FORUM', "Grer les forums");
define ('COLUMN_CHANGE_ORDER', "Changer l'ordre");

define ('ALT_FORUM_MANAGE', "Choisissez un forum  grer, Editer, Supprimer");
define ('ALT_FORUM_CREATE', "Cre un nouveau forum");
define ('ALT_FORUM_ORDER', "Change l'ordre d'affichage des forums");

define ('LABEL_FORUM_LAYOUT', "Mise en page de la liste des forums");

define ('LABEL_SITECONF', 'Configuration');
define ('LABEL_STYLESHEET', 'Feuille de style');
define ('LABEL_HEADER', 'Entte');
define ('LABEL_FORUM_LIST', 'Liste des forums');
define ('LABEL_FOOTER', 'Pied de page');
define ('LABEL_MESSAGES', 'Messages');

define ('ALT_SITECONF', 'Modifier les parametres gnraux (BODY, format date, ...)');
define ('ALT_MODIFY_STYLESHEET', 'Modifier le fichier CSS');
define ('ALT_HEADER', 'Editer l\'entte de la liste des forums');
define ('ALT_FOOTER', 'Editer le pied de page de la liste des forums');
define ('ALT_FORUM_LIST', 'Editer la mise en page de la liste des forums');
define ('ALT_MESSAGES', 'Editer les textes, messages et images affich dans la liste des forums');

define ('LABEL_DEFAULT_TEMPLATES', "Gabarit par dfaut du site");

define ('COLUMN_PROFILE', "Afficher le profil");
define ('COLUMN_LOGIN', "Formulaire d'identification");
define ('COLUMN_REGISTER', "Formulaire d'inscription");
define ('COLUMN_CHANGE_PASSWORD', "Formulaire de changement du mot de passe");
define ('COLUMN_FORGOT_PASSWORD'," Formulaire d'oubli du mot de passe");
define ('COLUMN_MAIL', "Configuration des emails");
define ('COLUMN_SUBSCRIBING', "Formulaire d'abonnement");

define ('ALT_PROFILE_FORM', "Editer le modle de profil par dfaut");
define ('ALT_LOGIN_FORM', "Editer le formulaire d'identification");
define ('ALT_REGISTER_FORM', "Editer le formulaire d'inscription");
define ('ALT_CHANGE_PASSWORD_FORM', "Editer le formulaire de changement de mot de passe");
define ('ALT_FORGOT_PASSWORD_FORM',"Editer le formulaire d'oubli du mot de passe");
define ('ALT_MAIL_TEMPLATE', "Editer la configuration de la messagerie et les modles d'emails");
define ('ALT_SUBSCRIBE_FORM', "Editer le formulaire d'abonnement");

define ('LABEL_USER_TEMPLATES', "Gabarits pour la gestion des utilisateurs");
define ('COLUMN_USER_FIELDS', "Champs utilisateurs");
define ('ALT_USER_FIELDS', "Dfinir les champs du profil utilisateur");

/////////////////////
//File admin_Forum.php3
/////////////////////
define ('TITLE_FORUM_ADMINISTRATION', "Administration des forums (Site: %s)");
define ('LABEL_CHOOSE_FORUM', "Slectionnez le forum que vous souhaitez grer / Editer / Supprimer");
define ('ERROR_NO_FORUM_ADMIN', "Aucun forum n'est disponible pour le site '%s'.<br>Cliquez sur le bouton 'OK' pour crer un nouveau forum.");
define ('ERROR_NO_FORUM', "Il n'existe pas de forums que vous pouvez administrer dans le site '{SITE}'.");
define ('LABEL_FORUM_ADMINISTRATION', "Administration du forum ");
define ('LABEL_SITE', "Site");
define ('LABEL_FORUM', "Forum");
define ('LABEL_FORUM_ACCESS', "Accder au forum ");
define ('LABEL_ACCESS_THIS_FORUM', "Accder  ce forum");
define ('ALT_ADMINISTRATION_SITE', "Retourner  la page d'administration du site %s");

define ('TITLE_NOTES_MANAGEMENT',"Gestion des messages");
define ('LABEL_EDIT_NOTES', "Grer les messages");
define ('LABEL_MANAGE_THREADS', "Grer les discussions");
define ('LABEL_POST_MSG', "Poster un message");

define ('ALT_EDIT_NOTES', "Supprimer/Modifier les messages");
define ('ALT_MANAGE_THREADS', "Supprimer - Copier - Dplacer des discussions");
define ('ALT_POST', "Poster un message");

define ('LABEL_ADD_USER', "Ajouter  ce forum");
define ('COLUMN_SHOWEDIT', "Lister / Modifier");
define ('ALT_USER_SHOWEDIT', "Lister / Modifier les utilisateurs enregistrs / en attente de ce forum");
define ('ALT_USER_CREATE', "Crer un nouvel utilisateur");

define ('LABEL_CONFIGURATION', "Configuration");
define ('LABEL_BASIC', "Simplifie");
define ('LABEL_ADVANCED', "Avance");
define ('LABEL_PROPERTIES', "Caractristiques");

define ('ALT_BASIC', "Editer les paramtres de configuration de base");
define ('ALT_ADVANCED', "Editer les paramtres de configuration avans ");
define ('ALT_PROPERTIES', "Editer les proprits de ce forum");

define ('LABEL_LAYOUT', "Mise en page / Modles");

define ('COLUMN_NOTES_LISTING', "Liste des notes");
define ('COLUMN_FORM',"Formulaire");
define ('COLUMN_MAIL_FORM',"Formulaire mail priv");
define ('COLUMN_FIELDS',"Champs");
define ('COLUMN_TEMPLATE', "Gabarit de note");
define ('COLUMN_SEARCH_FORM', "Formulaire de recherche");
define ('COLUMN_INCLUDED', "Script inclus");
define ('COLUMN_PROFILE_FORM', "Formulaire de profil");
define ('ALT_INCLUDED', "Script PHP  inclure avant l'affichage de chaque page");
define ('ALT_TEMPLATE', "Editer la mise en page du modle de message");
define ('ALT_FIELDS', "Modifier / Editer les champs de la base de donnes");
define ('ALT_SEARCH_FORM', "Editer le formulaire de recherche");
define ('ALT_FORM', "Editer le formulaire d'edition/envoi de messages");
define ('ALT_MAIL_FORM', "Editer le formulaire d'envoi de mail priv");
define ('ALT_NOTES_LISTING',"Editer la liste des notes");
define ('ALT_AGORA_MESSAGES',"Editer les diffrents messages utiliss");

define('LABEL_MASS_EDIT_FORUMS_DONE', "La mise a jour a t effectue sur tous les forums!");
define('TITLE_MASS_EDIT_FORUMS', "Edition rapide des caractristiques des forums");
define('MSG_MASS_EDIT_FORUMS', "Ce formulaire permet de modifier certaines caractristiques, pour tous les forums, en une seule opration");
define('LABEL_MASS_EDIT_FORUM_STATE', "Etat des forums");
define('LABEL_MASS_EDIT_FORUM_ACCESS', "Type d'accs");
define('LABEL_MASS_EDIT_FORUM_MODERATED', "Forums modrs ( priori)");
define('BUTTON_UPDATE_ALL_FORUMS', "Apliquer  tous les forums du site");

/////////////////////
//File Moderate_Notes.php3
/////////////////////
define ('TITLE_MODERATE_NOTES', 'Validation des messages en attente');
define ('ERROR_NO_INCOMING', 'Il n\'existe pas de messages en attente de validation pour ce forum');
define ('LABEL_MESSAGE_DELETE_CONFIRMATION', 'Etes-vous certain de vouloir supprimer ce message ?');
define ('CAPTION_VALIDATE_DELETE_MESSAGE', 'Cliquez sur le message que vous souhaitez valider ou supprimer');
define ('CAPTION_MESSAGE_ACTION', 'Que souhaitez-vous faire avec ce message ?');
define ('LABEL_VALIDATE', 'Valider');
define ('LABEL_DELETE', 'Supprimer');

/////////////////////
//Admin_Notes.php3
/////////////////////
define ('LABEL_DELETE_FOL_NOTES', "Les messages suivants seront supprims");
define ('LABEL_NOTES_IN_FORUM', "Messages du forum <font color=red>%s</font>");
define ('LABEL_NO_FORM', "Aucun formulaire n'est dfini pour ce forum");
define ('LABEL_EDIT_NOTE', "Edition d'un message:");
define ('LABEL_DISPLAY_NOTES', "Afficher les messages");
define ('LABEL_ALL_NOTES', "Tous les messages");
define ('LABEL_HIDDEN', "Cachs");
define ('LABEL_VISIBLE', "Visibles"); 
define ('COLUMN_SHOW_NOTE', "Montrer");
define ('COLUMN_HIDE_NOTE', "Cacher");
define ('ALT_DELETE_NOTE', "Supprimer ce message");
define ('ALT_EDIT_NOTE', "Modifier ce message");
define ('ALT_POPUP', "Pop-up");

define ('LABEL_COPY_FOL_NOTES', "Les messages suivants (et leurs rponses) seront copis/dplacs");
define ('ACTION_MESSAGES_DELETE', "Supprimer les messages slectionns");
define ('ACTION_MESSAGES_COPY', "Copier les messages slectionns dans une autre discussion du forum: ");
define ('ACTION_MESSAGES_MOVE', "[Dplacer les messages]");
define ('LABEL_SELECT_DEST_THREAD', "Slectionner la discussion  laquelle rattacher ce(s) message(s)");
define ('ERROR_COPY_NOTE', "Impossible de copier le message {NOTE} dans le forum {FORUM}");
define ('ERROR_DELETE_NOTE', "Impossible de supprimer le message {NOTE} du forum {FORUM}");
define ('ERROR_NO_DEST_FORUM', "Erreur: vous devez spcifier un forum destination.");
define ('TITLE_COPY_NOTES', "Copie/dplacement de messages");
define ('OPEN_NEW_THREAD', "Crer une nouvelle discussion");

/////////////////////
//Delete_Notes.php3
/////////////////////
define ('TITLE_DELETE_NOTES', "Suppression des messages");
define ('CAPTION_SELECT_NOTES', "Slectionnez un ou plusieurs messages");
define ('LABEL_DELETE_THIS', "Suppression de");
define ('CAPTION_SELECT_NOTES_DELETED', "Slectionnez les messages qui doivent tre supprims");

/////////////////////
//Delete_Threads.php3
/////////////////////
define ('ERROR_INCORRECT_DATES', "Les dates saisies ne sont pas correctes");
define ('ERROR_NO_PERIOD', "Merci de slectionner un nombre de jours, semaines ou mois");
define ('ERROR_NO_NOTES_OLDER', "Aucun message de plus de {NUMBER} {UNIT} n'a t trouv.");
define ('CONFIRM_THREAD_MOVE', "Etes-vous certain de vouloir dplacer les discussions vers le forum \"{FORUM}\" ?");
define ('CONFIRM_THREAD_COPY', "Etes-vous certain de vouloir copier les discussions dans le forum \"{FORUM}\" ?");
define ('CONFIRM_DELETE_THREAD', '%s discussions seront supprimes, tes vous sr ? ');
define ('CONFIRM_DELETE_THREAD_DATE', 'Etes-vous sr de supprimer toutes les discussions du %s au %s ? ');
define ('ERROR_NO_THREAD', "Aucune discussion n'a t slectionne");
define ('LABEL_COPYING_NOTES', "Copie des messages dans le forum {FORUM} en cours...");

define ('ERROR_PARENT_NOT_FOUND', "Erreur d'insertion du message, le parent n'a pas t trouv");
define ('ERROR_COPY_THREAD', "La discussion (thread) {THREAD} n'a pas pu tre copie dans le forum {FORUM}");
define ('ERROR_DELETE_THREAD', "Impossible de supprimer la discussion {THREAD} du forum {FORUM}");
define ('ERROR_INSERT_ATTTACHMENT', "Impossible d'insrer la pice jointe '{NAME}' pour le message '{CLE}' dans le forum '{FORUM}'");

define ('TITLE_MANAGE_THREADS', "Supression / Copie / Dplacement des messages");
define ('CAPTION_SELECT_THREAD', "Aucun sujet slectionn");
define ('LABEL_SELECT_THREAD', "Selectionnez les sujets que vous souhaitez supprimer / copier dplacer dans un autre forum");
define ('LABEL_SELECT_THREAD_OR_DATE', "Slectionnez des sujets ou choississez une plage de dates");
define ('LABEL_SELECT_INDIVIDUAL_THREAD', "Selectionnez l'un des sujets ci-dessous");
define ('LABEL_EXECUTE', "Executer");
define ('LABEL_THREAD_BETWEEN', "Selectionnez les sujets entre le");
define ('LABEL_THREAD_OLDER', "Selectionnez les sujets de plus de :");
define ('LABEL_SELECT_ACTION', "Choisissez l'action  raliser");
define ('ACTION_THREAD_DELETE', "Supprimer les sujets slectionns");
define ('ACTION_THREAD_MOVE', "Dplacer les sujets dans le forum (supprimer les messages une fois copis) :");
define ('ACTION_THREAD_COPY', "Copier les sujets dans le forum :");
define ('LABEL_REPLIES', "rponses");

/////////////////////
//Admin_User.php3
/////////////////////
define ('TITLE_SITE_USER_ADMIN', "Administrer les utilisateurs du site \"{SITE}\"");
define ('TITLE_FORUM_USER_ADMIN', "Administrer les utilisateurs du forum \"{FORUM}\"");
define ('TITLE_SELECT_USERS', "Choisissez les utilisateurs  administrer");
define ('TITLE_MAIL_USERS', "Rdigez le mail  envoyer  <font color=blue>%s</font>");
define ('LABEL_CHOOSE_USERID_INIT', "Choisissez une initiale");
define ('LABEL_CHOOSE_USERID_PATTERN', "Ou bien entrez les premiers caractres");
define ('LABEL_BY_NAME', " <b>Par rapport au nom</b>");
define ('LABEL_BY_ACTIVITY', " <b>Par rapport  l'activit</b>");
define ('LABEL_SHOW_NO_POST', "Afficher les utilisateurs qui n'ont jamais envoy de messages...");
define ('LABEL_SHOW_NO_LOGIN', "Afficher les utilisateurs qui ne se sont jamais connects...");
define ('LABEL_SHOW_DIDNT_POST', "Afficher les utilisateurs qui n'ont pas envoy de messages depuis...");
define ('LABEL_SHOW_DIDNT_LOGIN', "Afficher les utilisateurs qui ne se sont pas connects depuis...");
define ('LABEL_SHOW_IN_STATE', "Afficher les utilisateurs dans cet tat: ");
define ('LABEL_NOT_REGISTERED', "Non inscrits");
define ('LABEL_USERS_IN_STATE', "Utilisateurs dans l'tat <font color=blue>%s</font> ");
define ('LABEL_USERS_BEGINING', "Utilisateurs dont l'ID ou le nom commencent par <font color=blue>%s</font> ");
define ('LABEL_USERS_NEVER_POST', "Utilisateurs qui n'ont jamais envoy de messages ");
define ('LABEL_USERS_NEVER_LOGIN', "Utilisateurs qui ne se sont jamais connects ");
define ('LABEL_USERS_DIDNT_POST', "Utilisateurs qui n'ont pas envoy de messages depuis <font color=blue>%s %s</font> ");
define ('LABEL_USERS_DIDNT_LOGIN', "Utilisateurs qui ne se sont pas connects depuis <font color=blue>%s %s</font> ");
define ('LABEL_REG_USERS_FORUM', "dans le forum <font color=red>%s</font>");
define ('LABEL_REG_USERS_SITE', "dans le site <font color=red>%s</font>");
define ('LABEL_CONFIRM_USER_DELETE', "Etes-vous certain de vouloir supprimer ces utilisateurs?");
define ('LABEL_DELETE_THESE_USERS', "Supprimer ces utilisateurs");
define ('LABEL_USER_CONFIRM_DELETE', "L'utilisateur <font color=blue>%s</font>  t supprim");
define ('LABEL_RETURN_LIST', "Retour  la liste des utilisateurs");
define ('LABEL_EDIT_MAIL_PROFILE', "Envoyer  l'utilisateur <font color=blue>%s</font> son profil par mail");
define ('LABEL_TO', "Destinataire");
define ('LABEL_SEND', "Envoyer le mail");
define ('LABEL_REG_USER_FORUM', "Vous tes inscrit");
define ('LABEL_NO_REG_USER_FORUM', "Vous n'tes pas inscrit");
define ('LABEL_MAIL_USER_OK', "Le mail a t envoy (aux) l'utilisateur(s) <font color=blue>%s</font>");
define ('LABEL_MAIL_USER_NO_OK', "Le mail n'a pas pu tre envoy (aux) l'utilisateur(s) <font color=blue>%s</font>");
define ('ERROR_NO_USER_MATCHING', "Aucun utilisateur ne correspond  votre recherche (<font color=blue>%s</font>)");
define ('ERROR_NO_REMOVE_PRIVILEGE', "Vous n'avez pas les privilges ncessaires pour supprimer l'utilisateur <font color=blue>%s</font>");
define ('ERROR_NO_EDIT_PRIVILEGE', "Vous n'avez pas les privilges ncessaires pour diter l'utilisateur <font color=blue>%s</font>");
define ('ERROR_NO_REMOVE_PERMISSION', "L'utilisateur <font color=blue>%s</font> a accs  un forum (%s) pour lequel vous n'tes pas modrateur, vous ne pouvez pas supprimer cet utilisateur");
define ('ERROR_SITE_USER_DELETE', "Impossible de supprimer l'utilisateur <font color=blue>%s</font> dans le site %s");
define ('LABEL_STATUS', "Statut");
define ('ERROR_NO_MATCHING_USERS', "Aucun utilisateur ne rpond aux critres ");
define ('ERROR_NO_MATCHING_USER', "L'utilisateur %s n'existe pas dans ce site");
define ('ERROR_NO_OWNER_UPDATE', "Impossible de mettre  jour le propritaire du forum %s dans le site %s");
define ('ERROR_NO_SITE_USER_UPDATE', "Impossible de mettre  jour l'utilisateur {USER} pour le site {SITE}");
define ('TITLE_EDITING_USER', "Edition de l'utilisateur ");
define ('LABEL_IN_SITE', "dans le site");
define ('COLUMN_USER_EMAIL', "E-mail");
define ('COLUMN_USER_WEBPAGE', "Page Web");
define ('COLUMN_USER_DESCRIPTION', "Description");
define ('COLUMN_USER_LASTLOGIN', "Dernire connexion");
define ('COLUMN_USER_MAILOK', "Accepte les e-mails");
define ('COLUMN_USER_COUNTRY', "Pays");
define ('LABEL_UNSELECT', "Dslectionner"); 
define ('LABEL_SELECT_ALL', "Tout slectionner"); 
define ('LABEL_WITH_SELECTED', "Pour la slection :"); 
define ('LABEL_MAIL_USER', "Envoyer un e-mail"); 
define ('LABEL_REMOVE_ACCESS', "Supprimer l'accs a ce forum"); 

define ('ALT_CHANGE_PASSWORD', "Modifier le mot de passe de cet utilisateur");
define ('CAPTION_USER_PRIVILEGE', "Privilge de l'utilisateur: ");
define ('LABEL_USER_SITE_STATUS', "Statut de l'utilisateur dans le site: ");
define ('LABEL_CHANGE_USER_PRIVILEGE', "Changer le privilge de cet utilisateur en : ");
define ('LABEL_CHANGE_STATUS' , "Changer le statut en : ");
define ('LABEL_USER_CONFIRM_STATUS' , "L'utilisateur <font color=blue>%s</font> est dsormais %s."); //$userid, $user_states[$user_state]
define ('LABEL_MAIL_USER_STATUS' , "Envoyer le nouveau statut des utilisateurs par mail");
define ('LABEL_MAIL_STATUS_SUBJECT' , "Modification de votre profil dans le site %s"); //$site
define ('LABEL_MAIL_STATUS_BODY' , "Bonjour,\nl'administrateur du site %s a modifi l'tat de votre compte. Votre compte est maintenant %s."); // $site, $user_state
define ('ERROR_NO_ADMIN_CHANGE_PRIVILEGE', "Les privilges de l'utilisateur 'Admin' ne peuvent pas tre modifis");
define ('ERROR_NO_ADMIN_CHANGE_STATUS', "Le statut de l'utilisateur 'Admin' ne peut pas tre modifi"); 
define ('ERROR_NO_USER_STATUS', "Impossible de changer le statut de l'utilisateur %s dans le site %s"); //$userid
define ('CAPTION_CHANGE_USER_FORUM_PRIVILEGES', "Dfinir les privilges pour les forums disponibles pour cet utilisateur");
define ('LABEL_AS', "en tant que ");
define ('LABEL_GRANT_PRIVILEGES', " choisissez les privilges que vous souhaitez autoriser  l'utilisateur ");
define ('COLUMN_CAN_LIST', "Lister");
define ('COLUMN_CAN_READ', "Lire");
define ('COLUMN_CAN_WRITE', "Ecrire");
define ('COLUMN_SITE', "site");
define ('LABEL_ADD_FORUM', "Ajouter un forum : ");
define ('LABEL_MAIL_USER_PROFILE', "Envoyer  l'utilisateur son nouveau profil par mail ");
define ('LABEL_SHOW', "Afficher");

define ('ERROR_NO_ADD_PRIVILEGES', "Impossible d'ajouter des privilges  l'utilisateur %s dans le forum %s");

define ('COLUMN_MAIL_SUBSCRIBED_USERS', "Mail abonns");
define ('ALT_MAIL_SUBSCRIBED_USERS', "Envoyer un mail aux abonns au forum");
define ('LABEL_SEND_FORUM_SUBSCRIBED_EMAIL', "Envoyer un messages aux utilisateurs abonns au forum $bn_name");
define ('TITLE_SELECT_SUBSCRIBED_USERS', "Choisissez les abonns  administrer");
define ('LABEL_NO_SUBSCRIBED_USERS', "Pas d'utilisateur abonn  ce forum");
define ('LABEL_IN_FORUM', "dans le forum");
define ('LABEL_SUBSCRIBE_USER', "Abonner un nouvel utilisateur");
define ('LABEL_SUBSCRIBE', "Abonner");
define ('LABEL_UNSUBSCRIBE', "Dsabonner");
define ('LABEL_CONFIRM_USER_UNSUBSCRIBE', "Etes-vous certain de vouloir dsabonner ces utilisateur ?");
define ('LABEL_CONFIRM_USER_SUBSCRIBE', "Etes-vous certain de vouloir abonner ces utilisateur ?");
define ('ERROR_NO_MATCHING_ADDRESS', "Abonn %s introuvable dans le forum %s");
define ('COLUMN_USER_NEW_EMAIL', "Nouvelle adresse :");
define ('LABEL_EDIT_MAIL_SUBSCRIBE', "Envoyer  l'utilisateur <font color=blue>%s</font> sa nouvelle addresse par mail");
define ('LABEL_MAIL_USER_SUBSCRIBE', "Prvenir le(s) utilisateur(s) par email...");
define ('COLUMN_ADMIN_SUBSCRIBED_USERS', "Abonns");
define ('ALT_ADMIN_SUBSCRIBED_USERS', "Administrer les utilisateurs abonns  ce forum");
define ('TITLE_FORUM_SUBSCRIBED_USER_ADMIN', "Administrer les utilisateurs abonns au forum \"{FORUM}\"");
define ('LABEL_USER_CONFIRM_UNSUBSCRIBE', "L'utilisateur <font color=blue>%s</font>  t dsabonn");
define ('LABEL_USER_CONFIRM_SUBSCRIBE', "L'utilisateur <font color=blue>%s</font>  t abonn");
define ('LABEL_KEEP_THREADS', "Conserver les abonnements aux discussions");
define ('LABEL_MAIL_SUBSCRIBE_SUBJECT', "Votre abonnement au forum %s");
define ('LABEL_MAIL_SUBSCRIBE_BODY_YES', "Vous avez t abonn au forum %s. Vous recevrez tous les messages par mail.");
define ('LABEL_MAIL_SUBSCRIBE_BODY_NO', "Votre abonnement au forum %s a t supprim. Vous ne recevrez plus les messages par mail.");
define ('LABEL_SUBSCRIBED_USERS', "Utilisateurs abonns");
define ('LABEL_UNSUBSCRIBED_USERS', "Utilisateurs non abonns");

/////////////////////
//Add_User.php3
/////////////////////
define ('TITLE_ADD_USER', "Ajouter un utilisateur");
define ('ERROR_NO_ADD_USER', "Impossible d'ajouter l'utilisateur %s dans la table %s_userforum");
define ('WARNING_USER_ADDED', "L'utilisateur '%s'  t ajout au forum '%s'");
define ('LABEL_RETRIEVING_USERS', "Rcupration de la liste des utilisateurs du site...");
define ('WARNING_NO_USER_TO_ADD', "Aucun utilisateur  ajouter");
define ('LABEL_ADD_FORUM_USER', "Ajout d'un utilisateur au forum <em><FONT color=#FF6633>%s</FONT></em>");
define ('LABEL_CHOOSE_USER_ADD', "Choisissez un utilisateur  ajouter");
define ('LABEL_USER_GRANT_PRIVILEGES', "<b>Choisissez les privilges que vous souhaitez autoriser  cet utilisateur pour le forum <FONT color=#FF6633>%s</font></b><br>");
define ('LABEL_ACTIVE', "Actif");
define ('LABEL_FORM_SELECT', "&lt;-- Choisissez un lment --&gt;");
define ('LABEL_ENTER_EMAILS_TO_ADD', 'Saisissez ici les adresses email  ajouter');
define ('LABEL_CHOOSE_EMAILS_FILE', 'Choisissez ici le fichier contenant les adresses  ajouter');

/////////////////////
//Create_User.php3
/////////////////////
define ('TITLE_NEW_USER', "Cration d'un utilisateur");
define ('ERROR_NO_PASSWORD', "Le mot de passe doit tre saisi 2 fois, merci de vrifier");
define ('ERROR_NO_SITE_ADD_USER', "Impossible d'ajouter l'utilisateur %s dans la table %s_users");
define ('LABEL_USER_ADDED', "L'utilisateur '%s'  t cr");
define ('LABEL_USER_SENT_FOR_APPROVAL', "Toutefois, son compte ne sera actif qu'une fois valid par les administrateurs du site."); 
define ('LABEL_CREATE_ANOTHER_USER', "Crer un nouvel utilisateur");
define ('LABEL_EDIT_THIS_USER', "Modifier cet utilisateur");
define ('ALT_EDIT_THIS_USER', "Modifier les proprits de cet utilisateur");
define ('LABEL_SITE_CREATE_NEW_USER', "Cration d'un nouvel utilisateur dans le site ");
define ('LABEL_USER_INFORMATIONS', "Proprits de l'utilisateur");
define ('COLUMN_USER_PASSWORD', "Mot de passe");
define ('COLUMN_USER_CONFIRM_PASSWORD', "Confirmation du mot de passe");
define ('LABEL_ADD_MAILING_LIST', "Ajouter cet utilisateur  la liste de diffusion ?");
define ('LABEL_CREATE_USER', "Crer l'utilisateur");
define ('LABEL_USER_PRIVILEGE', "Type d'utilisateur");

/////////////////////
//Mail_Users.php3
/////////////////////
define ('LABEL_SEND_SITE_EMAIL', "Envoyer un messages aux utilisateurs du site ");
define ('LABEL_SEND_FORUM_EMAIL', "Envoyer un messages aux utilisateurs du forum ");
define ('LABEL_NO_ACTIVE_USERS', "Aucun utilisateur actif n'a t trouv");
define ('LABEL_MAIL_USERS', "Le message sera envoy  %s utilisateur(s)");
define ('LABEL_USER_MAILED', "Message envoy  <em> %s </em> <tt>&lt; %s &gt;</tt>.<br>");
define ('LABEL_USER_NOT_MAILED', "%s &lt; %s &gt;  choisi de ne pas recevoir de messages.<br>");
define ('LABEL_MAIL_FILL_FORM', "Remplissez le formulaire suivant pour envoyer un message");
define ('LABEL_SEND_TO_ALL', 'Envoyer  tous');
define ('COLUMN_TO', 'Destinataires :');
define ('COLUMN_FROM', "Expditeur :");
define ('COLUMN_REPLY_TO', "Rpondre  :");
define ('COLUMN_MESSAGE', "Message :");
define ('LABEL_SEND_MAIL', "Envoyer le message");

/////////////////////
//Editconf.php3
/////////////////////
define ('ERROR_NO_WRITE_CONFIGURATION', "Impossible de mettre  jour le fichier de configuration, vrifiez les permissions sur les fichiers");
define ('ERROR_FILE_UPLOAD_DISABLED', "l'upload de fichiers est dsactiv sur ce serveur, vrifier la configuration (php.ini) ou contacter votre hbergeur!!");
define ('LABEL_CHANGE_CONFIG_DONE', "Modifications effectues sur ");
define ('LABEL_SETTINGS_RESTORED', "Les paramtres par dfaut ont ts rtablis");
define ('LABEL_FORUM_CONFIGURATION', "Configuration %s du forum");
define ('LABEL_EDITING_FILE', "Edition du fichier ");
define ('TITLE_GENERAL_SETTINGS', "Paramtres gnraux");
define ('COLUMN_BODY', "Arrire plan");
define ('ALT_BODY', "Paramtres supplmentaires de la balise &lt;BODY&gt;");
define ('COLUMN_DATE_FORMAT', "Format de la date");
define ('ALT_DATE_FORMAT', "format d'affichage des dates (voir la documentation de PHP)");
define ('COLUMN_TIME_OFFSET',"Dcalage horaire");
define ('ALT_TIME_OFFSET', "dcalage horaire par rapport  l'heure locale (en heures)");
define ('COLUMN_USE_COOKIE', "Utiliser les cookies");
define ('ALT_USE_COOKIE', "utiliser les cookie pour stocker les coordonnes de l'utilisateur et pour grer les nouveaux messages");
define ('COLUMN_ALLOW_MODIFICATION', "Autoriser la modification des messages");
define ('ALT_ALLOW_MODIFICATION', "Autoriser les utilisateurs  modifier les messages, un mot de passe est ncssaire");
define ('COLUMN_ALLOW_DELETE', "Autoriser la suppression des messages");
define ('ALT_ALLOW_DELETE', "Autoriser les utilisateurs  supprimer des messages, un mot de passe est ncssaire");

define ('TITLE_MESSAGE_FORMATING', "Format des messages");
define ('COLUMN_ALLOW_HTML', "Autoriser le code HTML");
define ('ALT_ALLOW_HTML', "Autoriser la saisie de balises HTML");
define ('COLUMN_TAGS_ALLOWED', "Balises autorises :");
define ('ALT_TAGS_ALLOWED', "Saisissez les balises HTML qui peuvent tre autorises lors de la rdaction des messages, spars par des espaces, virgules ou point-virgule (n'insrez pas < et > )");
define ('COLUMN_TAGS_DISALLOWED', "Balises interdites :");
define ('ALT_TAGS_DISALLOWED', "Saisissez les balises HTML qui doivent tre supprimes des messages, spars par des espaces, virgules ou point-virgule (n'insrez pas < et > ). Utilis seulement si 'Balises autorises' est vide");
define ('COLUMN_USE_SMILEY', "Utililiser les smileys");
define ('ALT_USE_SMILEY', "Convertir les smileys en icnes (fonctionne uniquement dans les champs qui acceptent des balises HTML)");
define ('COLUMN_CONVERT_URL', "Convertir les adresses URL");
define ('ALT_CONVERT_URL', "Convertit automatiquement les adresses en liens (fonctionne uniquement dans les champs qui acceptent des balises HTML)");

define ('TITLE_LAMER_FILTER', "Filtrage des utilisateurs");
define ('COLUMN_DISALLOW_IP', "Exclure les adresses IP suivantes :");
define ('ALT_DISALLOW_IP', "inscrivez les adresses IP  exclure lors de la rdaction des messages, spars par des espaces, virgules ou point-virgule");

define ('TITLE_FILE_UPLOAD', "Envoi de fichiers");
define ('COLUMN_FILE_UPLOAD', "Prise en compte de l'envoi de fichiers");
define ('ALT_FILE_UPLOAD', "autoriser les utilisateurs  envoyer des fichiers (en pice jointe) vers votre serveur");
define ('COLUMN_MAX_FILE_SIZE', "Taille maximale des fichiers (en octets)");
define ('ALT_MAX_FILE_SIZE', "limiter la taille des fichiers envoys");

define ('COLUMN_ALLOW_EXTENSION', "Autoriser seulement les extensions : ");
define ('ALT_ALLOW_EXTENSION', "saisissez les extensions de fichiers (ex : .gif) que vous souhaitez autoriser pour l'envoi des fichiers, spars par des espaces, virgules ou point-virgule");
define ('COLUMN_DENY_EXTENSION', "Refuser les extensions :");
define ('ALT_DENY_EXTENSION', "saisissez les extensions de fichiers (ex : .gif) que vous souhaitez refuser lors de l'envoi des fichiers, spars par des espaces, virgules ou point-virgule. (utilis seulement si 'autoriser les extensions' est vide)");

define ('COLUMN_ALLOW_MIME', "Autoriser seulement les types MIME : ");
define ('ALT_ALLOW_MIME', "saisissez les types MIME (ex : image/gif, text/*) que vous souhaitez autoriser pour l'envoi des fichiers, spars par des espaces, virgules ou point-virgule");
define ('COLUMN_DENY_MIME', "Refuser les types MIME :");
define ('ALT_DENY_MIME', "saisissez les types MIME (ex : image/gif, text/*) que vous souhaitez refuser lors de l'envoi des fichiers, spars par des espaces, virgules ou point-virgule. (utilis seulement si 'autoriser les types MIME' est vide)");

define ('TITLE_SEARCH', "Recherche");
define ('COLUMN_SEARCH_SUPPORT', "Prise en compte de la recherche");
define ('ALT_SEARCH_SUPPORT', "Autoriser les utilisateurs  rechercher dans des messages");
define ('COLUMN_SEARCH_ENGINE', "Moteur de recherche");
define ('COLUMN_PATH_NAME', "Chemin d'accs");
define ('ALT_PATH_NAME', "Chemin d'accs du programme de recherche");
define ('TITLE_SEND_MAIL', "Envoi des e-mails");
define ('COLUMN_MAIL_MODERATOR', "Envoyer un e-mail au modrateur");
define ('ALT_MAIL_MODERATOR', "informe le modrateur quand un message est cr ou modifi");
define ('COLUMN_ALLOW_MAIL_SUBSCRIPTION', "Autoriser l'envoi des rponses par e-mail");
define ('ALT_ALLOW_MAIL_SUBSCRIPTION', "autorise les utilisateurs  recevoir les rponses par e-mail");
define ('COLUMN_ALLOW_PRIVATE_MAIL', "Autoriser l'envoi de mails privs");
define ('ALT_ALLOW_PRIVATE_MAIL', "autorise les utilisateurs  envoyer un mail priv  l'auteur d'un message");
define ('COLUMN_MAIL_ATTACHMENT', "Fichiers en pice jointe");
define ('ALT_MAIL_ATTACHMENT', "Joint les fichiers attachs en pice jointe au mail");
define ('LABEL_DEFAULT', "Paramtres par dfaut");

define ('LABEL_FRAMES', "Cadres");
define ('COLUMN_USE_FRAMES', "Utiliser les cadres");
define ('ALT_USE_FRAMES', "les anciens navigateurs sont quand mme pris en compte si ce paramtre est coch");
define ('COLUMN_FRAMESET_PARAMETER', "Paramtres de la balise frameset :");
define ('ALT_FRAMESET_PARAMETER', "paramtre additionnels de la balise &lt;frameset&gt;");
define ('COLUMN_HEADER_FRAME_PARAMETER', "Paramtres de la balise frame de l'entte :");
define ('ALT_HEADER_FRAME_PARAMETER', "paramtre additionnels de la balise &lt;frame&gt;");
define ('COLUMN_FOOTER_FRAME_PARAMETER', "Paramtres de la balise frame du pied de page :");

define ('TITLE_POST_MESSAGES', "Envoi des messages");
define ('COLUMN_POST_POPUP', "ouvrir une nouvelle fentre pour la rdaction d'un message");
define ('ALT_POST_POPUP', "ouverture d'une fentre spare pour le formulaire de rdaction des messages");
define ('COLUMN_NO_BUTTON_BAR', "Ne pas afficher la barre de boutons");
define ('ALT_NO_BUTTON_BAR', "ne pas afficher la barre des boutons ainsi que les options au bas du formulaire de rdaction des messages");
define ('COLUMN_NO_THANKS', "ne pas afficher le message de remerciement");
define ('ALT_NO_THANKS', "affiche la page suivante aprs un envoi/modification sans faire apparaitre le message de remerciement");
define ('COLUMN_AFTER_POSTING', "Aprs la rdaction d'un message, retourner vers");
define ('ALT_AFTER_POSTING', "page qui sera affiche aprs l'envoi d'un message");
define ('COLUMN_NEWLY_POSTED',"Dernier message envoy");
define ('COLUMN_MESSAGE_LIST', "Liste des messages");
define ('COLUMN_FIRST_MESSAGE',"Premier message");

define ('TITLE_INCLUDE_FILES', "Fichiers inclus (tous ces fichiers sont dans le rpertoire %s ), laissez les champs vide pour utiliser les fichiers par dfaut");

define ('COLUMN_CSS_FILE', "Fichier de feuille de style (CSS) :");
define ('ALT_CSS_FILE', "fichier css inclus dans la balise &lt;head&gt;");
define ('COLUMN_HEADER_FILE', "Fichier d'entte");
define ('ALT_HEADER_FILE', "Fichier d'entte inclus");
define ('COLUMN_FOOTER_FILE', "Fichier de pied de page");
define ('ALT_FOOTER_FILE', "Fichier de pied de page inclus");
define ('COLUMN_LISTING_OUTLINE', "Prsentation de la liste");
define ('ALT_LISTING_OUTLINE', "Liste des messages");
define ('COLUMN_INCLUDE_MESSAGES', "Messages");
define ('ALT_INCLUDE_MESSAGES', "fichier d'affichage des messages et des images");
define ('COLUMN_FORM_FILE', "Formulaire");
define ('ALT_FORM_FILE', "formulaire utilis pour la rdaction des messages");
define ('COLUMN_MAIL_FORM_FILE', "Formulaire de mail priv");
define ('ALT_MAIL_FORM_FILE', "formulaire utilis pour la rdaction de messages privs");
define ('COLUMN_FILE_SEARCH', "Formulaire de recherche");
define ('ALT_FILE_SEARCH', "Formulaire de recherche");
define ('COLUMN_TEMPLATE_FILE', "Modle");
define ('ALT_TEMPLATE_FILE', "modle du message");
define ('COLUMN_FIELDS_NAME', "Nom des champs");
define ('ALT_FIELDS_NAME', "dfinition des noms des champs (variables)");
define ('COLUMN_PHP_INCLUDE', "Fichier PHP inclus avant l'accs");
define ('ALT_PHP_INCLUDE', "fichier PHP optionnel qui est excut avant l'accs  la page");
define ('COLUMN_FILE_LOGIN', "Formulaire d'identification");
define ('ALT_FILE_LOGIN', "Formulaire d'identification de l'utilisateur");
define ('COLUMN_REGISTER_FORM', "Formulaire d'inscription");
define ('ALT_FILE_REGISTER', "Formulaire d'inscription de l'utilisateur");
define ('COLUMN_SHOW_PROFILE', "Formulaire du profil de l'utilisateur");
define ('ALT_FILE_SHOW_PROFILE', "Formulaire d'affichage du profil de l'utilisateur");
define ('COLUMN_FILE_CHANGE_PASSWORD', "Formulaire de changement du mot de passe");
define ('ALT_FILE_CHANGE_PASSWORD', "Formulaire de changement du mot de passe d'un utilisateur");
define ('COLUMN_FILE_FORGOT_PASSWORD', "Formulaire d'oubli du mot de passe");
define ('ALT_FILE_FORGOT_PASSWORD', "Formulaire d'oubli du mot de passe d'un utilisateur");
define ('COLUMN_FILE_MAIL_TEMPLATE', "Modles d'e-mails");
define ('ALT_FILE_MAIL_TEMPLATE', "configuration de la messagerie et modles d'e-mail");
define ('COLUMN_SUBSCRIBE_FORM_TEMPLATE', "Formulaire d'abonnement");
define ('ALT_FILE_SUBSCRIBE_FORM', "modle utilis pour le formulaire d'abonnement aux forums");

define ('TITLE_DISCUSSION_BOARD', "Forum de discussion");
define ('COLUMN_ALLOW_REPLIES', "Autoriser les rponses (discussions)");
define ('ALT_ALLOW_REPLIES', "autoriser l'utilisateur  rpondre  un message");

define ('TITLE_DISPLAYED_MESSAGE', "Messages affichs");
define ('COLUMN_NO_TOOLBAR', "Pas de barre d'outils dans les messages");
define ('ALT_NO_TOOLBAR', "Ne pas afficher la barre d'outils (Rpondre|Modifier|Supprimer|Liste)  la fin des messages affichs");
define ('COLUMN_NO_NAVIGATION_BAR', "Pas de barre de navigation dans les messages");
define ('ALT_NO_NAVIGATION_NAR', "ne pas afficher la barre de navigation (suivant|prcdent) dans les messages");
define ('COLUMN_NO_THREAD', "Pas de discussion dans les messages");
define ('ALT_NO_THREAD', "Ne pas afficher la discussion dans le message affich");
define ('COLUMN_APPEND_MESSAGE', "Ajouter le formulaire de rponse aprs le message affich");
define ('ALT_APPEND_MESSAGE', "Affiche le formulaire de rponse aprs le message");

define ('TITLE_MESSAGE_LISTING', "Liste des messages");
define ('COLUMN_MESSAGE_NO_NAVIGATION_BAR', "Pas de barre de navigation dans la liste des messages");
define ('ALT_MESSAGE_NO_NAVIGATION_NAR', "ne pas afficher la barre de navigation (suivant|prcdent) dans la liste des messages");
define ('COLUMN_GUESTBOOK', "Afficher le formulaire de message aprs la liste des messages");
define ('ALT_GUESTBOOK', "affiche le formulaire de rdaction d'un message  la fin de la liste (mode livre d'or)");

define ('TITLE_BROWSE_SERVER', "Ajout de fichiers sur le serveur");
define ('COLUMN_BROWSE_SERVER', "Autoriser le parcours des rpertoires du serveur");
define ('ALT_BROWSE_SERVER', "permet aux utilisateurs de joindre des fichiers situs sur votre serveur");
define ('COLUMN_BASE_DIRECTORY', "Rpertoire de dpart");
define ('ALT_BASE_DIRECTORY', "dfinit l'arborescence de dpart ou les utilisateurs peuvent parcourir les documents  joindre  leur message");

/////////////////////
//Edit_Forum.php3
/////////////////////
define ('LABEL_EDIT_FORUM', "Edition des caractristiques du forum");
define ('LABEL_SITE_EDIT_FORUM', "Choisissez le forum  modifier pour le site %s");
define ('ERROR_NO_FORUM_UPDATE', "Impossible de mettre  jour le forum %s du site %s");
define ('ERROR_NO_NEW_MODERATOR', "Impossible d'affecter le privilge de modrateur  l'utilisateur %s pour le forum %s");
define ('LABEL_EDIT_FORUM_SHORT', "Edition du forum : ");
define ('LABEL_FORUM_INFORMATION', "Informations sur le forum");
define ('COLUMN_STATE', "Etat");
define ('COLUMN_CATEGORY', "Catgorie");
define ('LABEL_PRIVACY_INFORMATION', "Paramtres d'accs");
define ('LABEL_CHANGE_ACCESS', "Changer le mode d'accs de ce forum");
define ('LABEL_MODERATED', "modr");
define ('LABEL_UPDATE_THIS_FORUM' , "Mettre  jour ce forum");
define ('LABEL_CHOOSE_MODERATOR', "Choisissez/modifier l'utilisateur qui deviendra le modrateur principal de ce forum");

/////////////////////
//admin_categories.php3
/////////////////////
define ('LABEL_EDIT_CATEGORIES', "Editer les catgories pour le site ");
define ('LABEL_ADD_CATEGORY', "Ajouter une catgorie");
define ('COLUMN_EDIT_CATEGORY', "Modifier la catgorie ");
define ('COLUMN_DELETE_CATEGORY', "Supprimer la catgorie ");
define ('COLUMN_CAT_TITLE', "Titre de la catgorie");
define ('LABEL_UPDATE_ORDER', "Mettre  jour l'ordre");
define ('LABEL_ADD_NEW_CATEGORY',"Ajouter une nouvelle catgorie");
define ('LABEL_ADD_THIS_CATEGORY',"Ajouter cette catgorie");
define ('LABEL_EDIT_CATEGORY', "Modification d'une catgorie");
define ('LABEL_UPDATE_THIS_CATEGORY', "Mettre  jour");

/////////////////////
//Create_Forum.php3
/////////////////////
define ('TITLE_CREATE_FORUM', "Cration d'un forum");
define ('ERROR_FORUM_NAME_TO_LONG', "Le nom du forum est trop long, choisissez en un plus court.");
define ('ERROR_CONFIG_FILE_EXISTS', "Le fichier de configuration (%s) existe dj, vous devez le supprimer manuellement ou choisir un autre nom");
define ('ERROR_NO_FILE_COPY', "Impossible de copier le fichier %s");

define ('ERROR_FORUM_DB_DBM_EXISTS', "La base de donnes du site %s existe dj, <br> Vous devez supprimer le fichier DBM : <em>dbm/%s/%s</em><br> [et le fichier .lck] manuellement");
define ('ERROR_FORUM_DB_EXISTS', "La table du site %s existe dj dans la base de donnes %s, Vous devez d'abord supprimer cette table manuellement");

define ('ERROR_FORUM_DB_DBM_ACCESS', "Problme d'accs, Impossible de crer le fichier DBM (<em>%s</em>), vrifiez l'espace disque disponible et les permissions sur les fichiers");
define ('ERROR_FORUM_DB_ACCESS', "Problme d'accs, impossible de crer la table <em>%s</em>, vrifiez si vous avez cr une base de donnes nomme '%s' et vrifiez ses droits d'accs");
define ('ERROR_NO_CREATE_FORUM', "Impossible de crer le forum :");
define ('ERROR_NO_FORUM_INSERT', "Impossible de crer le forum %s dans le site %s");
define ('LABEL_FORUM_CREATED', "Le forum '<em>%s</em>'  t cr dans le site %s<BR><BR>&nbsp;&nbsp;Vous pouvez maintenant :");
define ('LABEL_CREATE_ANOTHER_FORUM', "Crer un autre forum");
define ('ALT_ACCESS_FORUM', "Sortir du module d'administration pour accder au forum");
define ('LABEL_ADMINISTRATE_FORUM', "Administrer le forum");
define ('ALT_ADMINISTRATE_FORUM', "Configurer plus d'options pour ce forum");
define ('LABEL_EDIT_THIS_FORUM', "Editer ce forum");
define ('ALT_EDIT_THIS_FORUM', "Editer les caractristiques de ce forum");
define ('LABEL_SITE_ADMINISTRATION', "Retourner  l'administration du site");
define ('LABEL_FORUM_CREATED_SUCCESSFULLY', "Le forum %s  t cr avec succs");
define ('LABEL_INSTALL_FORUM', "Installer un nouveau forum dans le site : ");
define ('COLUMN_GIVE_FORUM_NAME', "Nom interne du forum");
define ('COLUMN_FORUM_TEMPLATE', "Choississez un modle (thme)");
define ('LABEL_SET_ACCESS', "Mode d'accs de ce forum");
define ('LABEL_CREATE_THIS_FORUM', "Crer ce forum");
define ('LABEL_NAME_OF_FORUM', "(nom interne que vous avez donn au forum)");
define ('LABEL_CHOOSE_FIRST_MODERATOR', "Choisissez l'utilisateur qui deviendra le modrateur principal de ce forum :");

/////////////////////
//Reorder_Forum.php3
/////////////////////
define ('TITLE_REORDER_FORUM', "Changer l'ordre d'affichage des forums pour le site : ");
define ('LABEL_CHANGE_FORUM_ORDER', "Vous pouvez modifier ci dessous l'ordre d'affichage des forums. Affecter  chaque forum un numro unique  partir de 1. En affectant la valeur 0, le forum ne sera pas affich");


/////////////////////
//editform.php3
/////////////////////
define ('LABEL_NEW_FILE_EDITING', "Edition du nouveau fichier ");
define ('WARNING_EDITING_DEFAULT', "Attention : Ce fichier est le fichier par dfaut pour ce site, les modifications effectues affecteront tous les forums qui utilisent la configuration par dfaut du site.");
define ('LABEL_SPECIFIC_TEMPLATE', "Si vous souhaitez utiliser un modle spcifique, vous pouvez le choisir dans <a href='%s'>le formulaire de configuration</a>");

/////////////////////
//editmsg.php3
/////////////////////
define ('TITLE_EDITING_MESSAGES', "Edition des messages");
define ('ERROR_NO_CREATE_MESSAGE', "Impossible de crer le fichier de messages : Vrifiez les permissions sur les fichiers");

/////////////////////
//editfields.php3
/////////////////////
define ('TITLE_EDITING_FIELDS', 'Edition des champs');
define ('LABEL_NAME', 'Nom');
define ('LABEL_SIZE', 'Taille');
define ('LABEL_REQUIRED', 'Obligatoire');
define ('LABEL_LISTED', 'List');
define ('LABEL_ACCEPT_HTML', 'HTML accept / conversion smileys');
define ('LABEL_SAVE_COOKIE', 'Enregistr dans un cookie permanent');
define ('LABEL_DELETE_FIELD', 'Supprimer');
define ('LABEL_USER_VARIABLES', 'Variables utilisateurs');
define ('LABEL_LISTED_VARIABLES', 'Variables listes');
define ('LABEL_REQUIRED_VARIABLES', 'Variables obligatoires');
define ('LABEL_VARIABLES_ACCEPT_HTML', 'Variables acceptent le HTML');
define ('LABEL_VARIABLES_COOKIE', 'Variables stockes dans des cookies permanents');
define ('LABEL_CONFIRM_DELETE_FIELD', 'Voulez-vous supprimer le champ');
define ('ALT_DELETE_FIELD', 'Supprimer le champ : %s');
define ('ALT_ADD_FIELD', 'Ajouter un champ');
define ('ERROR_UNDEFINED_VARNAME', 'Veuillez prciser le nom de la variable  ajouter');
define ('ERROR_UNDEFINED_VARSIZE', 'Vous devez spcifier une taille (ou un type) pour la variable  ajouter [xxx|int|text]');
define ('ERROR_VARNAME_ALREADY_DEFINED', 'Ce nom de variable est dj utilis');

/////////////////////
//edittemplate.php3
/////////////////////
define ('TITLE_EDITING_TEMPLATE', "Edition des gabarits");
define ('LABEL_DEFINE_DOCUMENT_GENERATION', "Choisissez la mthode de gnration des documents ( partir du gabarit)");
define ('LABEL_STATIC', "<b>Statique</b><i> (un fichier HTML est cr quand un message est envoy)</i>");
define ('LABEL_ONTHEFLY', "<b>A la vole</b><i> (Pas de fichier HTML, le message est gnr dynamiquement quand un utilisateur y accde)</i>");
define ('LABEL_NO_DOCUMENTS', "<b>Sans fichiers</b><i> (seule la base de donnes est liste)</i>");
define ('LABEL_EDIT_TEMPLATE', "Edition du gabarit des documents : ");

/////////////////////
//editmail.php3
/////////////////////
define ('TITLE_EDITING_MAIL', "Configuration des emails");
define ('LABEL_OVERWRITE_MAIL_FILE', "Fichier de configuration des emails (<font color=red>ATTENTION!</font> ce choix crasera le fichier actuel)");
define ('LABEL_SEND_OUT_EMAILS', "Envoyer les emails avec comme adresse d'expditeur (From)");
define ('LABEL_USER_EMAIL', "L'adresse e-mail de l'utilisateur");
define ('LABEL_THIS_EMAIL', "Cette e-mail");
define ('LABEL_FIRST_RECIPIENT', "Destinataire (To)");
define ('LABEL_RETURN_PATH', "Adresse d'erreur (Return-Path)");
define ('LABEL_REPLY_TO', "Rpondre  (Reply-To)");
define ('LABEL_BEFORE_MAIL', "Script excut avant l'envoi des e-mails");
define ('LABEL_NO_MAIL_SUBJECT' , "Sujet de l'email si le sujet du message est vide");
define ('LABEL_MAIL_SUBJECT' , "Sujet de l'email");
define ('LABEL_MAIL_APPROVAL', "Message envoy aux modrateurs pour l'approbation des messages (forums modrs)");
define ('LABEL_MAIL_POSTED', "E-mail envoy lorsqu'un nouveau message est post");
define ('LABEL_MAIL_MODIFIED', "E-mail envoy lorsqu'un message est modifi");
define ('LABEL_MAIL_BODY', "Corps de l'e-mail");
define ('LABEL_MAIL_REGISTRATION', "email envoy aux utilisateurs aprs demande d'inscription");
define ('LABEL_MAIL_CONFIRM_REGISTRATION', "email envoy aux utilisateurs aprs modification du profil par l'administrateur");
define ('LABEL_MAIL_USER_APPROVAL', "email envoy aux modrateurs pour la validation d'une inscription");
define ('LABEL_MAIL_USER_MODIFICATION', "email envoy aux modrateurs lors de la modification d'un utilisateur");
define ('LABEL_MAIL_FORGOT_PASSWORD', "email envoy aux utilisateurs qui ont oubli leur mot de passe");

/////////////////////
//delete_Forum.php3
/////////////////////
define ('TITLE_DELETE_FORUM', "Suppression d'un forum");
define ('TITLE_DELETE_FORUM_IN_SITE', 'Supprimer le %s dans le site %s');

define ('ERROR_MUST_BE_ADMIN_TO_REMOVE_FORUM', 'Vous devez tre connect en tant qu\'administrateur pour pouvoir supprimer un forum');
define ('ERROR_NO_AVAILABLE_FORUM', 'Aucun forum  supprimer dans le site %s,<br>');
define ('ERROR_FORUM_DOESNT_EXIST', 'Le forum %s n\'existe pas dans ce site');
define ('ERROR_CANT_REMOVE_FORUM', 'Impossible de supprimer le forum %s dans le site %s');

define ('LABEL_CHOOSE_FORUM_TO_DELETE', 'Slectionnez le forum que vous souhaitez supprimer dans le site %s');
define ('LABEL_FORUM_DELETED', 'Le forum %s a t supprim');

define ('CAPTION_DELETE_FORUM', '<B>Etes-vous sr de vouloir supprimer ce forum :</B>');
define ('LABEL_FORUM_TITLE', 'Titre (thme): ');
define ('LABEL_FORUM_DESCR', 'Description: ');
define ('LABEL_FORUM_OWNER', 'Propritaire: ');
define ('LABEL_FORUM_TYPE', 'Type: ');
define ('LABEL_FORUM_MODER', 'Modr: ');
define ('LABEL_FORUM_STATE', 'Etat: ');
define ('LABEL_DELETE_THIS_FORUM', 'Supprimer ce forum');
?>
