<?php

/*
 *	W-AGORA 4.1
 *	-----------
 *	$Id: init_admin.inc,v 1.76 2005/03/11 11:41:27 mdruilhe Exp $
 *	Usage:	Initialization file (for administration stuff)
 *	Author:	Marc Druilhe <mdruilhe@w-agora.net>
 */
	
	require ('globals.inc');

	if (file_exists("$lang_dir/admin_$lang.inc") ) {
		include ("$lang_dir/admin_$lang.inc");
	} else {
		include ("$lang_dir/admin_${default_lang}.inc");
	}
	require ("$inc_dir/misc_func.$ext");

	$formated_date = date ($bn_date_format, $now+($bn_tz_offset*3600) );

# Define labels associated with the different values
# --------------------------------------------------
	$user_states =array(
		"0" =>USER_STATE_LOCKED,
		"1" =>USER_STATE_ACTIVE,
		"P" =>USER_STATE_PENDING
	);

	$forum_types = array (
		"pub"=>FORUM_TYPE_PUBLIC,
		"reg"=>FORUM_TYPE_REGISTERED,
		"rest"=>FORUM_TYPE_RESTRICTED,
		"priv"=>FORUM_TYPE_PRIVATE
	);

	$forum_states = array (
		"0"=>FORUM_STATE_INACTIVE,
		"1"=>FORUM_STATE_ACTIVE,
		"L"=>FORUM_STATE_LOCKED,
		"C"=>FORUM_STATE_CLOSED
	);

	$registration_modes = array (
		'0' => LABEL_REG_NO_CONTROL,
	//	'1' => LABEL_REG_CHALLENGE_RESPONSE,
		'2' => LABEL_REG_ADMIN_APPROVAL
	);

# Displays the HTML headers
# ---------------------------
function display_header ($title="", $css_base="") {

	global $icon_dir, $img_dir, $bn_charset, $lang, $bn_html_dir;

	echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Frameset//EN">';
	$dir = (isset($GLOBALS['bn_html_dir']) ) ? $GLOBALS['bn_html_dir'] : 'ltr';
	echo "\n<html lang=\"$lang\" dir=\"$dir\">\n<head>\n<title>" . strip_tags(ADMINISTRATION_TITLE);
	if(!empty($title)) {
		echo ' &raquo; '. strip_tags($title);
	}
	echo "</title>\n";
	if (!empty($bn_charset)) {
		printf ("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=%s\">\n", $bn_charset);
	}

	if(empty($css_base)) {
		$css = "style.css";
		$admin_css = "admin_style.css";
	} else {
		$css = "$css_base/style.css";
		$admin_css = "$css_base/admin_style.css";
	}
	echo "<link rel=\"stylesheet\" href=\"$css\">\n";
	echo "<link rel=\"stylesheet\" href=\"$admin_css\">\n";
	echo "<script language=\"javascript\">function changeclass (objet, myClass) {objet.className=myClass;}</script>";
	echo '</head><body>';
	if (!empty($title) ) {
		echo "\n<h2 align=\"center\">$title</h2>";
	}

}

function display_footer() {
	echo "</p></body></html>\n";
	exit;
}

function frameset($left_url, $right_url) {
	global $bn_html_dir;
	
	if ( $bn_html_dir == 'rtl' ) {
		echo "<frameset cols=\"*,250\" frameborder=\"no\" border=\"0\">\n";
		echo "<frame src=\"$right_url\" name=\"edit_frame\" marginheight=\"0\">\n";
		echo "<frame src=\"$left_url\" name=\"menu_frame\" marginheight=\"0\" marginwidth=\"0\" noresize scrolling=\"auto\">\n";
	} else {
		echo "<frameset cols=\"250,*\" frameborder=\"no\" border=\"0\">\n";
		echo "<frame src=\"$left_url\" name=\"menu_frame\" marginheight=\"0\" marginwidth=\"0\" noresize scrolling=\"auto\">\n";
		echo "<frame src=\"$right_url\" name=\"edit_frame\" marginheight=\"0\">\n";
	}
	echo "</frameset>\n";
	return;
}

function left_menu_header ($title) {
	echo "<div class=\"left_menu\">\n";
	echo " <div class=\"left_menu_header_l\"></div><div class=\"left_menu_header\">$title</div><div class=\"left_menu_header_r\"></div>\n";
	echo " <ul class=\"left_menu_list\">\n";
}

function left_menu_item ($url, $target, $item, $alt) {

	echo "  <li class=\"left_menu_item\"> ".anchor($url, $target, $item, $alt, "left_menu_item")."</li>\n";
}

function left_menu_footer () {
	print " </ul>\n</div>\n";
}

function table_header ($title, $width="95%") {
	echo "<div style=\"text-align: center\"><table class=\"admintable\" width=\"$width\">\n";
	echo "<tr><td class=\"admintabletitle\">$title</td></tr><tr><td class=\"admintabledata\">\n";
}

function table_footer () {
	echo "</td></tr></table></div>\n";
}

# Displays selected forums
# ------------------------
function list_forums ($forums, $title, $target="", $action="") {
	global $site, $db, $WA_SELF, $ext, $bn_date_format, $bn_tz_offset, $bn_frames;
	global $forum_types, $forum_states;
	global $icon_dir, $img_dir;

	if (empty($action) ) {
		$action = $WA_SELF;
	}

	if (is_array($forums)) {
		table_header($title);
		echo "<table border=\"0\" width=\"100%\" cellpadding=\"4\" cellspacing=\"1\">\n";
		echo "<tr><th></th><td class=\"label\">" . COLUMN_FORUM_ADMIN  . "</td><td class=\"label\" width=\"20\">" . COLUMN_EDIT . "</td><td class=\"label\" width=\"20\">" . COLUMN_DELETE . "</td><td class=\"label\">" . COLUMN_FORUM_STATE . "</td><td class=\"label\">" . COLUMN_FORUM_ACCESS . "</td><td class=\"label\">" . COLUMN_FORUM_MODERATED . "</td><td class=\"label\">" . COLUMN_FORUM_MODERATORS . "</td><td class=\"label\">" . COLUMN_FORUM_THREADS  . "</td><td class=\"label\">" . COLUMN_FORUM_POSTS . "</td><td class=\"label\">" . COLUMN_FORUM_ATTACHMENTS . "</td><td class=\"label\">" . COLUMN_FORUM_LAST_POST . "</td></tr>\n";
		$curcat = 0;
		reset($forums);
		while (list($name, $forum) = each($forums)) {
			$type = $forum_types[$forum["type"]];
			$state = $forum_states[$forum["state"]];
			switch ($forum["state"]) {
			 case "0":
				$alt_state_label = ALT_INACTIVE_FORUM;
				$state_icon=msg(130,"<img src=\"images/inactive_thread.gif\" alt=\"$alt_state_label\">");
				break;
			 case "L":
				$alt_state_label = ALT_LOCKED_FORUM;
				$state_icon=msg(131,"<img src=\"images/locked_thread.gif\" alt=\"$alt_state_label\">");
				break;
			 case "C":
				$alt_state_label = LABEL_CLOSED_FORUM;
				$state_icon=msg(146, "<img src=\"images/closed_thread.gif\" alt=\"$alt_state_label\">");
				break;
			 case "1":
				$alt_state_label = ALT_ACTIVE_FORUM;
				$state_icon=msg(132,"<img src=\"images/thread.gif\" alt=\"$alt_state_label\">");
				break;
			}

			$mod = ($forum["moderated"] == 1) ? LABEL_YES : LABEL_NO;
			$bn = $forum["bn_name"];
			$rank = $forum["rank"];
			$lastpost = ($forum["lastnote"]>0) ? date ($bn_date_format, $forum["lastnote"]+($bn_tz_offset*3600)) : "&nbsp;";

			$moders = "";

			$admins = $db->getAdministrators($site);
			if (is_array($admins) ) {
				reset ($admins);
				while (list (, $m) = each ($admins) )  {
					if ($forum["owner"] == $m["userid"]) {
						$moders .= "<font color=\"red\">". $m[userid] . "</font><br />";
					} else {
						$moders .= $m["userid"] . "<br />";
					}
				}
			}

			$mods = $db->getModerators($site, $bn);
			if (is_array($mods) ) {
				reset ($mods);
				while (list (, $m) = each ($mods) )  {
					if ($forum["owner"] == $m["userid"]) {
						$moders .= "<font color=\"red\">". $m[userid] . "</font><br />";
					} else {
						$moders .= $m["userid"] . "<br />";
					}
				}
			}

			$att_size = pretty_size($forum["att_size"]);
			$action_url = anchor ("$action?site=$site&bn=$bn", $target, $name, MSG_ADMINISTRATE_FORUM . " " . $bn);
			$delete_url = anchor ("delete_forum.${ext}?site=$site&bn=$bn", "", "<img src=\"$icon_dir/delete.gif\" align=\"absmiddle\" border=\"0\" alt=\"" . sprintf (ALT_DELETE_FORUM, $name). "\">", sprintf (ALT_DELETE_FORUM, $name) );
			$edit_url = anchor ("edit_forum.${ext}?site=$site&bn=$bn", "", "<img src=\"$icon_dir/edit.gif\" align=\"absmiddle\" border=\"0\" alt=\"" . sprintf (ALT_EDIT_FORUM, $name) . "\">", sprintf (ALT_EDIT_FORUM, $name) );
			if ($forum["parent"] != $curcat) {
				// new category
				$curcat = $forum["parent"];
				$cat = $db->getCategory ($site, $forum["parent"]);
				printf ("\n<tr><td bgcolor=\"#e0eaf6\" colspan=\"12\"><font color=\"black\">%s</font></td></tr>", $cat["cat_title"]);
			}

			printf ("\n<tr valign=\"top\"><td>$state_icon</td><td class=\"label\">%s<br /><font size=\"1\">%s</font></td><td align=\"center\">%s</td><td align=\"center\">%s</td><td class=\"label\">%s</td><td class=\"label\">%s</td><td class=\"label\">%s</td><td class=\"label\">%s</td><td align=\"right\" class=\"label\">%s</td><td align=\"right\" class=\"label\">%s</td><td align=\"center\" class=\"label\"><font size=\"1\">%s<br />(%s)</font></td><td nowrap=\"nowrap\" class=\"label\">%s</td></tr>\n", $action_url, $forum["bn_title"], $edit_url, $delete_url, $state, $type, $mod, $moders, $forum["totalthreads"], $forum["totalnotes"], $forum["att_count"], $att_size, $lastpost);
		}
		table_footer();
	}
}

# ----------------------------------------------------------------------------
#	set configuration file variables:
#	$cfg_file:	forum configuration file
#	$site_cfg_file: site configuration file
#   if either site or forum is not defined, then redirect to admin entry point
# -----------------------------------------------------------------------------
	if (!empty($bn)) {
		$bn=trim(basename($bn));
		$site = strtok($bn, "_");
		$forum_name = strtok('_');
		$cfg_file = "${cfg_dir}/$bn.$ext";
		if (!file_exists($cfg_file) ) {
			msgForm (sprintf (ERROR_FORUM_DOESNT_EXIST, $bn), "admin_site.$ext?site=$site", "", "_top");
			exit;
		}
	} else {
		$bn = "";
		$site=trim(basename($site));
		if (empty($site)) {
			$site = "agora";
		}
		$cfg_file = "${cfg_dir}/site_${site}.$ext";
		if (!file_exists($cfg_file) ) {
			if ($site == "agora") {
				@header("Location: setup.$ext");			
			} else {
				@header("Location: admin.$ext");
			}
			exit;
		}
	}

	$site_cfg_file = "${cfg_dir}/site_${site}.$ext";

# Set core variables (managed by w-agora)
# ---------------------------------------
	$bn_var = array (
		'unixdate',		// timestamp (creation date)
		'userid',		// user ID
		'mod_date',		// modification date
		'mod_userid',	// userid of modifier
		'password',		// MD5 encoded password
		'filename',		// name of HTML note
		'att_size',		// total attachments size
		'mail_reply',	// set to '1' if replies to this note must be sent by email
		'hidden',		// set to 1 if note must be approved by the moderator
		'hits',			// hits count
		'closed',		// closed thread (RFU)
		'ip'			// logged IP address of sender
	);

	if (!isset($bn_var_size) ) {
		$bn_var_size = array ();
	}

	$bn_var_size['unixdate']	= 'INT';
	$bn_var_size['userid']		= '32';
	$bn_var_size['mod_date']	= 'INT';
	$bn_var_size['mod_userid']	= '32';
	$bn_var_size['password']	= '32';
	$bn_var_size['filename']	= '64';
	$bn_var_size['att_size']	= 'INT';
	$bn_var_size['mail_reply']	= '1';
	$bn_var_size['hidden']		= 'INT';
	$bn_var_size['hits']		= 'INT';
	$bn_var_size['closed']		= 'INT';
	$bn_var_size['ip']			= '32';

# force w-agora variables to be listed
# ------------------------------------
	reset ($bn_var);
	while ( list(, $var) = each($bn_var) ) {
		$list_var[$var] = 1;
	}

# -----------------------------------------------------------
#	Get DB access type, create a DB object and open database
# -----------------------------------------------------------
	$site_dbparam = getDBaccess($site);
	$site_access = $site_dbparam['bn_access'];
	$site_dbname = $site_dbparam['dbname'];
	$site_dbhost = $site_dbparam['dbhost'];
	$site_dbport = $site_dbparam['dbport'];
	$site_dbuser = $site_dbparam['dbuser'];
	$site_dbpassword = $site_dbparam['dbpassword'];
	$site_dbadmuser = $site_dbparam['dbadmuser'];
	$site_dbadmpassword = $site_dbparam['dbadmpassword'];

	include ("$inc_dir/$site_access.$ext");
	$db_class = "${site_access}_access";
	$db =& new $db_class;
	$ret = $db->openDB($site_dbhost, $site_dbport, $site_dbadmuser, $site_dbadmpassword, $site_dbname, $site);
	if ($ret != 0) {
		include "$site_cfg_file";
		include "$bn_dir/$bn_msgs";
		MsgForm (sprintf(ERROR_DATABASE, $ret), "$WA_SELF?site=$site", ""); /* access PB */
		exit;
	}

	$db->setDebug($debug);

# -----------------------------------------------------------------------------------
#	Now authenticate the user
# -----------------------------------------------------------------------------------
	$usersource = $site_dbparam['usersource'];
	include ("$user_dir/$usersource.$ext");
	$auth_class = "${usersource}_source";
	$auth =& new $auth_class;

# force user to re-login
# ----------------------
	if (isset($force_login)) {
		include "$site_cfg_file";
		$auth->logout($site);
		display_header (TITLE_ADMINISTRATION_LOGIN);
		$auth->login($site, '', '', "$tmpl_dir/admin/login_form.$ext");
		exit;
	}

	if (!defined("no_auth_required")) {
		$is_authenticated = $auth->authenticate();
		if ($is_authenticated) {
# user is authenticated, we check permissions & exit if is not an admin user
			$is_administrator = ($auth->level >= ADMIN);
			$is_moderator = ($auth->level >= MODER);
			if ($auth->level < MODER) {
				msgForm (ERROR_NO_MODERATOR, "$WA_SELF?force_login=1", "", "_top");
				exit;
			}
			if (empty($bn) )  {
				$is_owner = ($auth->level >= ADMIN);
			} else {
			 	$is_owner = $auth->havePermission($bn, "M");
				if (! $is_owner) {
					msgForm (ERROR_NO_MODERATOR, "$WA_SELF?force_login=1", "", "_top");
					exit;
				}
			}
		} else {
# user is not authenticated
			include "$site_cfg_file";
			if (isset($loginform)) {
				$auth->logout($site);
				display_header (TITLE_INVALID_LOGIN);
			} else {
				display_header (TITLE_ADMINISTRATION_LOGIN);
			}
			$auth->login($site, '', '', "$tmpl_dir/admin/login_form.$ext");
			exit;
		}
	}

	require ("$inc_dir/config.$ext");

?>
