<H4>Seal and open</H4>

     <?php
     $data = "Follow the white rabbit";

     // Get certificate into a string
     // this file comes with OpenSSL 0.9.6
     $fp = fopen("/site/src/www/openssl-0.9.6/demos/maurice/cert.pem", "r");
     $cert = fread($fp, 8192);
     fclose($fp);
     // get public key from certificate
     $pk1 = openssl_get_publickey($cert);
     // $pk1 is an encryption key resource id if success, else false
     // Repeat if want public keys for multiple parties

     $fp = fopen("/site/src/www/openssl-0.9.6/demos/sign/cert.pem", "r");
     $cert = fread($fp, 8192);
     fclose($fp);
     $pk2 = openssl_get_publickey($cert);

     // seal data, only owners of $pk1 and $pk2 can decrypt $sealed with keys
     // $ekeys[0] and $ekeys[1] respectively.
     openssl_seal($data, $sealed, $ekeys, array($pk1,$pk2));
     openssl_free_key($pk1);
     openssl_free_key($pk2);

     // now we try to decrypt data for one of the recipients
     $fp = fopen("/site/src/www/openssl-0.9.6/demos/sign/key.pem", "r");
     // Get PEM coded key into $pkey 
     $pkey = fread($fp, 8192);
     fclose($fp);
     // $key will be resource id for unpacked $pkey
     $key = openssl_get_privatekey($pkey);

     openssl_open($sealed, $open, $ekeys[1], $key);
     openssl_free_key($key);
     echo "$open\n";
     ?>


<H4>Sign and verify</H4>

     <?php
     $data = "Follow the white rabbit";

     // First we need to have a string containing the private key in PEM format
     // this file comes with OpenSSL 0.9.6
     $fp = fopen("/site/src/www/openssl-0.9.6/demos/sign/key.pem", "r");
     $pkey = fread($fp, 8192);
     fclose($fp);

     // get private key from the PEM format
     // $key is an encr key resource id if success, else false
     $key = openssl_get_privatekey($pkey);

     // calculate signature
     openssl_sign($data, $signature, $key);
     openssl_free_key($key);

     // recipient verifies signature
     // read certificate
     $fp = fopen("/site/src/www/openssl-0.9.6/demos/sign/cert.pem", "r");
     $cert = fread($fp, 8192);
     fclose($fp);

     // Get public key from the certificate
     $pubkey = openssl_get_publickey($cert);

     // state whether signature is okay or not
     echo openssl_verify($data, $signature, $pubkey) == 1 ? "ok\n" : "bad\n";

     // free key
     openssl_free_key($pubkey);
     ?>
