<?php
/*
 *	PHPgSQL
 *	-------
 *	 File:		_rows.php
 *	 Usage:		display every rows from pgsql
 *	 date:		2001-09-23
 *	 version:	4.2.1
 *	 Author:	Jun Kuwamura <juk@yokohama.email.ne.jp>
 *
 *	2002-05-03 Rename. register_globals=Off for php-4.2.0
 *	2001-09-23 Use show_source() for php-4.0.6
 *      2000-08-16 4.0
 */
require_once("phpgsql_func.php");

$dbhost = $_GET['DB_HOST'];
$dbport = $_GET['DB_PORT'];
$dbname = $_GET['DB_NAME'];
$dbuser = $_GET['DB_USER'];
$dbpass = $_GET['DB_PASS'];
$tblname = $_GET['TBL_NAME'];
$rowlimit = $_GET['row_limit'];
$optdebug = $_GET['opt_debug'];
$numrows = $_GET['num_rows'];
$pagenum = $_GET['page_num'];
$condition = $_GET['q_condition'];
$sortorder = $_GET['s_order'];

?>

<HTML>
<HEAD><TITLE>Rows@PHP+PostgreSQL</TITLE></HEAD>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=shift-jis">
<BODY BGCOLOR=#DDFFFF FOREGROUND=#000000>

<TABLE><TR>
<TD>  <b>Rows@PHP+PostgreSQL</b>  </TD>
<TD>  <? include "phpgsql_srcbutton.php" ?>  </TD>
</TR></TABLE>

<H3>DB.Table: <? echo "{$dbname}.{$tblname}" ?></H3>

<?
  if ($dbhost && $dbname && $dbuser && $dbpass) {
    if ($optdebug == "on") {
	echo "host=$dbhost port=$dbport dbname=$dbname user=$dbuser password=$dbpass<br>";
    }
    $conn = pg_Connect("host=$dbhost port=$dbport dbname=$dbname user=$dbuser password=$dbpass");
  } else {
    if ($optdebug == "on") {
	echo "host=$dbhost port=$dbport dbname=$dbname<br>";
    }
    $conn = pg_Connect($dbhost, $dbport, "", "", $dbname);
  }
  if (!$conn) {
    echo "An error($conn) occured to Connect DB($dbname) on $dbhost through $dbport.\n";
    exit;
  }

  if (! empty($condition) ) {
    $condition = StripSlashes($condition);
    echo "<BLOCKQUOTE>\n";
    echo "Condition: $condition<br>\n";
    echo "</BLOCKQUOTE>\n";
  }

  if (! isset($numrows) ) {
	$query = "select count(*) from $tblname $condition";
        if ($optdebug == "on") {
             echo "query = $query<br>";
        }
	$result = pg_Exec($conn, $query);
	if (!$result) {
	    echo "An error occured to Exec query($query).\n";
	    exit;
	}
	$numrows=pg_Result($result, 0, 0);
  }
  if ( $rowlimit > 0) {
    $numpages = (int)( ($numrows+$rowlimit-1)/$rowlimit ); 
    $tcursor = $rowlimit*$pagenum;
    $query = "select oid,* from $tblname $condition $sortorder LIMIT $rowlimit OFFSET $tcursor";
  } else {
    $query = "select oid,* from $tblname $condition $sortorder";
  }
    if ($optdebug == "on") {
	echo "rowlimit = $rowlimit<br>";
	echo "numrows = $numrows<br>";
	echo "numpages = $numpages<br>";
	echo "tcursor = $tcursor<br>";
	echo "pagenum = $pagenum<br>";
    }
  Page_Indices($_SERVER['PHP_SELF'], $dbhost,$dbport,$dbname,$dbuser,$dbpass,$tblname, $rowlimit,$numrows,$numpages,$pagenum,$condition,$sortorder);


  $result = pg_Exec($conn, $query);

  if ($optdebug == "on") {
      echo "query = $query<br>";
  }

  if (!$result) {
    echo "An error occured to Exec query($query).\n";
    exit;
  }

  $nf = pg_NumFields($result);
  echo "<TABLE CELLPADDING=2 BORDER=1 BGCOLOR=#FFFFFF>";

  echo "<TR>";
  $j = 0;
    $fldname[] = pg_FieldName($result, $j);
    echo "<TH bgcolor=#DDDDDD>";
    echo "Edit ";
    echo "$fldname[$j]";
    echo "</TH>";
  $j = 1;
  while ($j < $nf) {
    $fldname[] = pg_FieldName($result, $j);
    echo "<TH bgcolor=#00DDDD>";
    echo "$fldname[$j]";
    echo "</TH>";
    $j++;
  }
  echo "</TR><p>";

  $nr = pg_NumRows($result);
  $i = 0;
  while ($i < $nr) {
    echo "<TR>";
    $j = 0;
      echo "<TD bgcolor=#999999>";
      $oid = pg_Result($result, $i, $j);
?>
    <FORM METHOD="GET" ACTION="_change.php">
      <INPUT TYPE="hidden" NAME="DB_HOST"   VALUE="<? echo $dbhost    ?>">
      <INPUT TYPE="hidden" NAME="DB_PORT"   VALUE="<? echo $dbport    ?>">
      <INPUT TYPE="hidden" NAME="DB_NAME"   VALUE="<? echo $dbname    ?>">
      <INPUT TYPE="hidden" NAME="DB_USER"   VALUE="<? echo $dbuser    ?>">
      <INPUT TYPE="hidden" NAME="DB_PASS"   VALUE="<? echo $dbpass    ?>">
      <INPUT TYPE="hidden" NAME="TBL_NAME"  VALUE="<? echo $tblname   ?>">
      <INPUT TYPE="hidden" NAME="row_limit" VALUE="<? echo $rowlimit ?>">
      <INPUT TYPE="hidden" NAME="opt_debug" VALUE="<? echo $optdebug ?>">
      <INPUT TYPE="hidden" NAME="OBJ_ID"    VALUE="<? echo $oid       ?>">
      <INPUT TYPE="hidden" NAME="q_condition" VALUE="<? echo $condition?>">
      <INPUT TYPE="hidden" NAME="s_order"   VALUE="<? echo $sortorder?>">
      <INPUT TYPE="SUBMIT" VALUE="<? echo $oid ?>">
    </FORM>
<?
      echo "</TD>";
    $j = 1;
    while ($j < $nf) {
      echo "<TD>";
      echo pg_Result($result, $i, $j);
      echo "</TD>";
      $j++;
    }
    echo "</TR>\n";
    $i++;
  }
  echo "</TABLE>";

  put_last_query ( $conn, $query, $result );

  pg_FreeResult($result);
  pg_Close($conn);

  Page_Indices($_SERVER['PHP_SELF'], $dbhost,$dbport,$dbname,$dbuser,$dbpass,$tblname, $rowlimit,$numrows,$numpages,$pagenum,$condition,$sortorder);
?>

<FORM METHOD="GET" ACTION="_change.php">
  <INPUT TYPE="hidden" NAME="DB_HOST"   VALUE="<? echo $dbhost    ?>">
  <INPUT TYPE="hidden" NAME="DB_PORT"   VALUE="<? echo $dbport    ?>">
  <INPUT TYPE="hidden" NAME="DB_NAME"   VALUE="<? echo $dbname    ?>">
  <INPUT TYPE="hidden" NAME="DB_USER"   VALUE="<? echo $dbuser    ?>">
  <INPUT TYPE="hidden" NAME="DB_PASS"   VALUE="<? echo $dbpass    ?>">
  <INPUT TYPE="hidden" NAME="TBL_NAME"  VALUE="<? echo $tblname   ?>">
  <INPUT TYPE="hidden" NAME="row_limit" VALUE="<? echo $rowlimit ?>">
  <INPUT TYPE="hidden" NAME="opt_debug" VALUE="<? echo $optdebug ?>">
  <INPUT TYPE="hidden" NAME="OBJ_ID"    VALUE="<? echo $oid       ?>">
  <INPUT TYPE="hidden" NAME="q_condition" VALUE="<? echo $condition?>">
  <INPUT TYPE="hidden" NAME="s_order"   VALUE="<? echo $sortorder?>">
  <INPUT TYPE="SUBMIT" NAME="OPT" VALUE="ADD NEW ROW">
</FORM>

</BODY>
</HTML>
