<?php
/*
 *	PHPgSQL
 *	-------
 *	 File:		_result.php
 *	 Usage:		display result from pgsql
 *	 date:		2001-09-23
 *	 version:	4.2.1
 *	 Author:	Jun Kuwamura <juk@yokohama.email.ne.jp>
 *
 *	2002-05-03 Rename. register_globals=Off for php-4.2.0
 *	2001-09-23 Use show_source() for php-4.0.6
 *	2001-02-12 4.1
 */
require_once("phpgsql_func.php");

$dbhost = $_GET['DB_HOST'];
$dbport = $_GET['DB_PORT'];
$dbname = $_GET['DB_NAME'];
$dbuser = $_GET['DB_USER'];
$dbpass = $_GET['DB_PASS'];
$rowlimit = $_GET['row_limit'];
$optdebug = $_GET['opt_debug'];
$condition = $_GET['q_condition'];
?>

<HTML>
<HEAD><TITLE>Result@PHP+PostgreSQL</TITLE></HEAD>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=x-euc-jp">
<BODY BGCOLOR=#DDFFFF FOREGROUND=#000000>

<TABLE><TR>
<TD>  <b>Result@PHP+PostgreSQL</b>  </TD>
<TD>  <? include "phpgsql_srcbutton.php" ?>  </TD>
</TR></TABLE>

<H3>DB.Table: <? echo "{$dbname}.{$tblname}"; ?></H3>

<?
  $sqlcmd = "select ";
  // Gather field specifications.
  reset ($COL_SELE);
  while (list ($key, $val) = each ($COL_SELE)) {
    if ($val != "NON" ) {
	$cols[]=$key;
    }
  }
  if (! empty($cols) ) {
	$cols = implode(", ", $cols);
  } else {
	$cols = " * ";
  }

  if ($optdebug === "on") {
	echo "cols = $cols<br>";
  }

  // Gather conditions.
  $j = 0;
  $condition = "";
  while ($j < $NCOLS) {
    if ($COND[$j] != "" ) {
      if ($condition == "" ) {
         $condition = " WHERE ";
	 echo "Condition: <BR><BLOCKQUOTE><SMALL>";
      } else {
         $condition .= " AND ";
      }
      $condition .= "$COL_NAME[$j] $COND[$j]";
      echo "$COL_NAME[$j] $COND[$j]<BR>";
    }
    $j++;
  }

  if ( $OTHER_CONDITIONS != "" ) {
    echo "Other conditions: $OTHER_CONDITIONS <br>";
    if ($condition == "" ) {
      $condition = " WHERE $OTHER_CONDITIONS";
    } else {
      $condition .= " AND $OTHER_CONDITIONS";
    }
  }

  if ($condition != "" ) {
    $condition = StripSlashes($condition);
    echo "</SMALL></BLOCKQUOTE>\n";
    echo "\n";
  }

  if ( $ORDERS != "" ) {
    echo "Sort order: $ORDERS <br>";
    $orderby = " ORDER BY $ORDERS";
  }
  $sqlcmd .= "$cols FROM $tblname";
  $sqlcmd .= $condition;
  $sqlcmd .= $orderby;

  if ($row_limit > 0) {
    $sqlcmd .= " LIMIT $row_limit";
    echo "(Limited $row_limit row".($row_limit==1 ? '' : 's');
  }

  if ($optdebug === "on") {
	echo "\nExec query($sqlcmd).<br>";
  }

  if ($dbhost && $dbname && $dbuser && $dbpass) {
    if ($optdebug == "on") {
	echo "host=$dbhost port=$dbport dbname=$dbname user=$dbuser password=$dbpass<br>";
    }

    $conn = pg_Connect("host=$dbhost port=$dbport dbname=$dbname user=$dbuser password=$dbpass");
  } else {
    if ($optdebug == "on") {
	echo "host=$dbhost port=$dbport dbname=$dbname<br>";
    }
    $conn = pg_Connect($dbhost, $dbport, "", "", $dbname);
  }
  if (!$conn) {
    echo "An error($conn) occured to Connect DB($dbname) on $dbhost through $dbport.\n";
    exit;
  }

  if ($row_limit > 0) {
    $quel = "select count(*) from $TBL_NAME $condition";
    $res = pg_Exec($conn, $quel);
    if (!$res) {
      echo "An error occured to Exec query(count).\n";
      exit;
    }
    $last = pg_Result($res, 0, 0);
    pg_FreeResult($res);
    echo " / $last rows)";
  }


  $result = pg_Exec($conn, $sqlcmd);
  if (!$result) {
    echo "An error occured to Exec query($sqlcmd).\n";
    exit;
  }

  $nf = pg_NumFields($result);
  $nr = pg_NumRows($result);
	// echo "(nr,nf) = ($nr, $nf)<br>\n";

  echo "<TABLE CELLPADDING = 2 BORDER = 1>\n";

  echo "<TR>";
  $j = 0;
  while ($j < $nf) {
	//  echo "$j-$nf<br>\n";
    $fldname[] = pg_FieldName($result, $j);
    echo "<TH BGCOLOR=#00DDDD>";
    echo $fldname[$j];
    echo "</TH>  ";
    $summ[$j]=0.0;
    $j++;
  }
  echo "</TR>\n";

  $i = 0;
  while ($i < $nr) {
    echo "<TR>";
    $j = 0;
    while ($j < $nf) {
      switch ($TYP_NAME[$fldname[$j]]) {
        case "int":
        case "money":
          echo "<TD ALIGN=RIGHT>";
          break;
        default:
          echo "<TD>";
      }
      $pgres = pg_Result($result, $i, $j);
      echo "$pgres";

      switch ($COL_SELE[$fldname[$j]]) {
        case "SUM":
	case "AVG":
	case "AGGR":
	  $summ[$j] += doubleval(ereg_replace("[\$,]","",$pgres));
	  break;
	default:
	  break;
      }

      echo "</TD>  ";
      $j++;
    }
    echo "</TR>\n";
    $i++;
  }


  // Proccess Aggrigation
  $naggv=0;
  reset($COL_SELE);
  while ( $aggr = current( $COL_SELE ) ) {
      if ( $aggr == "AGGR" || $aggr == "SUM" || $aggr == "AVG" ) {
        $naggv += 1;
      }
      next( $COL_SELE );
  }
  if ($optdebug === "on") {
	echo "naggv = $naggv<br>\n";
  }

  if ( $naggv ) {
    // Add Aggrigation ROW
    echo "<TR>";
    $j=0;
    while ($j < $nf) {
      echo "<TD BGCOLOR=#EEEE99>";
      $fnam=$fldname[$j];
	//echo "debug:$j: TYP_NAME: $TYP_NAME[$fnam], ";
      switch ( $TYP_NAME[$fnam] ) {
        case "int2":
          $fmt = "%d";
          break;
        case "int4":
          $fmt = "%d";
          break;
        case "int":
          $fmt = "%d";
          break;
        case "float":
          $fmt = "%f";
          break;
        case "money":
          $fmt = "%.2f";
          break;
        default:
          $fmt = "%s";
      }
	//echo " COL_SELE: $COL_SELE[$fnam]<br>";
      switch ( $COL_SELE[$fnam] ) {
        case "SUM":
          echo "S: ";
          echo sprintf("$fmt", $summ[$j]);
          break;
        case "AVG":
          echo "A: ";
          $avrg = $summ[$j]/$nr;
          echo sprintf("$fmt", $avrg);
          break;
        case "AGGR":
          echo "A/S: ";
          $avrg = $summ[$j]/$nr;
          echo sprintf("$fmt/$fmt", $avrg, $summ[$j]);
          break;
        default:
          echo "-";
        }
      echo "</TD>  ";
      $j++;
    }
    echo "</TR>\n";
  }

  echo "</TABLE>\n";

  put_last_query ( $conn, $sqlcmd, $result );

  pg_FreeResult($result);
  pg_Close($conn);
?>

<FORM METHOD="get" ACTION="phpgsql_rows.php">
<INPUT TYPE="hidden" NAME="DB_HOST" VALUE="<? echo $dbhost ?>">
<INPUT TYPE="hidden" NAME="DB_PORT" VALUE="<? echo $dbport ?>">
<INPUT TYPE="hidden" NAME="DB_NAME" VALUE="<? echo $dbname ?>">
<INPUT TYPE="hidden" NAME="DB_USER" VALUE="<? echo $dbuser ?>">
<INPUT TYPE="hidden" NAME="DB_PASS" VALUE="<? echo $dbpass ?>">
<INPUT TYPE="hidden" NAME="TBL_NAME" VALUE="<? echo $tblname ?>">
<INPUT TYPE="hidden" NAME="row_limit" VALUE="<?echo $rowlimit?>">
<INPUT TYPE="hidden" NAME="opt_debug" VALUE="<?echo $optdebug?>">
<INPUT TYPE="hidden" NAME="q_condition" VALUE="<?echo $condition?>">
<INPUT TYPE="hidden" NAME="s_order" VALUE="<?echo $orderby?>">
<INPUT TYPE="submit" VALUE="Retrieve Everything with the Same Conditins">
</FORM>

</BODY>
</HTML>
