<!--  
    PDFץ륳 
    PHPޥ˥奢(pdfclock)
 -->
<HTML>
<HEAD><TITLE>PDF Sample</TITLE></HEAD>
<BODY>

 <?php

   // pdflib Υ⥸塼
   if(!extension_loaded('pdf')){
      if(!dl("pdf.so")){
         echo 'error';
         exit;
      }
   }

 $pdffilename = "tmp/clock.pdf";
 $radius = 200;
 $margin = 20;
 $pagecount = 40;

 $fp = fopen($pdffilename, "w");
 $pdf = pdf_open($fp);
 pdf_set_info($pdf, "Creator", "pdf_clock.php3");
 pdf_set_info($pdf, "Author", "Uwe Steinmann");
 pdf_set_info($pdf, "Title", "Analog Clock");

 while($pagecount-- > 0) {
     pdf_begin_page($pdf, 2 * ($radius + $margin), 2 * ($radius + $margin));

     pdf_set_parameter($pdf, "transition", "wipe");
     pdf_set_value($pdf, "duration", 0.5);
   
     pdf_translate($pdf, $radius + $margin, $radius + $margin);
     pdf_save($pdf);
     pdf_setrgbcolor($pdf, 0.0, 0.0, 1.0);

     /* 1ʬߤ */
     pdf_setlinewidth($pdf, 2.0);
     for ($alpha = 0; $alpha < 360; $alpha += 6) {
         pdf_rotate($pdf, 6.0);
         pdf_moveto($pdf, $radius, 0.0);
         pdf_lineto($pdf, $radius-$margin/3, 0.0);
         pdf_stroke($pdf);
     }

     pdf_restore($pdf);
     pdf_save($pdf);

     /* 5ʬߤ */
     pdf_setlinewidth($pdf, 3.0);
     for ($alpha = 0; $alpha < 360; $alpha += 30) { 
         pdf_rotate($pdf, 30.0);
         pdf_moveto($pdf, $radius, 0.0);
         pdf_lineto($pdf, $radius-$margin, 0.0);
         pdf_stroke($pdf);
     }

     $ltime = getdate();

     /* ˤ */
     pdf_save($pdf);
     pdf_rotate($pdf,-(($ltime['minutes']/60.0)+$ltime['hours']-3.0)*30.0);
     pdf_moveto($pdf, -$radius/10, -$radius/20);
     pdf_lineto($pdf, $radius/2, 0.0);
     pdf_lineto($pdf, -$radius/10, $radius/20);
     pdf_closepath($pdf);
     pdf_fill($pdf);
     pdf_restore($pdf);

     /* ʬˤ */
     pdf_save($pdf);
     pdf_rotate($pdf,-(($ltime['seconds']/60.0)+$ltime['minutes']-15.0)*6.0);
     pdf_moveto($pdf, -$radius/10, -$radius/20);
     pdf_lineto($pdf, $radius * 0.8, 0.0);
     pdf_lineto($pdf, -$radius/10, $radius/20);
     pdf_closepath($pdf);
     pdf_fill($pdf);
     pdf_restore($pdf);

     /* ÿˤ */
     pdf_setrgbcolor($pdf, 1.0, 0.0, 0.0);
     pdf_setlinewidth($pdf, 2);
     pdf_save($pdf);
     pdf_rotate($pdf, -(($ltime['seconds'] - 15.0) * 6.0));
     pdf_moveto($pdf, -$radius/5, 0.0);
     pdf_lineto($pdf, $radius, 0.0);
     pdf_stroke($pdf);
     pdf_restore($pdf);

     /* 濴˾ʱߤ */
     pdf_circle($pdf, 0, 0, $radius/30);
     pdf_fill($pdf);

     pdf_restore($pdf);

     pdf_end_page($pdf);
 }

 $pdf = pdf_close($pdf);
 fclose($fp);

 echo "<A HREF=pdf-get.php?filename=".$pdffilename.">finished</A>";
 ?>
</BODY>
</HTML>
