<?php
/*
 *  siteconfig
 *  --------------------
 *   File:    siteconfig.php
 *   Usage:   configuration form.
 *   Date:    2005-01-31
 *   Auther:  Jun Kuwamura <juk@yokohama.email.ne.jp>
 *   Version: 0.5
 *   History:
 *    2005-02-28 JuK add filepermision setting by myfilemode()
 *    2005-02-28 JuK add FILE_MODE for permission for new files
 *    2005-02-20 JuK add admin/password
 *    2005-02-01 JuK mod devided from install.php
 */

// ιϥե(HTML_QuickForm Ȥ)
require_once "HTML/QuickForm.php";
$form = new HTML_QuickForm();

// ͤΥå
$form->setDefaults( $default_param );

// եǤɲ			 
$form->addElement('text', 'SITE_TITLE', 'ȤΥȥ');
$form->addElement('text', 'SITE_DESCRIPTION', 'Ȥ');
$form->addElement('text', 'SERVER_NAME', '̾');
$form->addElement('text', 'ROOT_DIRECTORY_PATH', '롼ȥǥ쥯ȥ');
$form->addElement('text', 'ROOT_DIRECTORY_URI', '롼ȥURI');
$form->addElement('text', 'DATA_FOLDER', 'ǡե̾');
$form->addElement('text', 'LIST_FILE', 'ꥹȥե̾');
$form->addElement('text', 'AUTH_DSN', 'ǧDBDSN');
$form->addElement('text', 'FILE_MODE', 'եΥѡߥå');
$form->addElement('text', 'ADMIN_USER', '桼̾');
$form->addElement('password', 'ADMIN_PASS', 'ѥ');
$form->addElement('hidden', 'CONFIG_FILE');
$form->addElement('submit', 'SAVE', '');

// 롼Ͽ
$form->registerRule('check_data_folder', 'function', 'check_data_folder');
$form->registerRule('check_file_mode', 'function', 'check_file_mode');

// ͤθڥ롼
$form->addRule('SITE_TITLE', 'ȤΥȥϤƤ', 'required');
$form->addRule('SITE_DESCRIPTION', 'ȤϤƤ', 'required');
$form->addRule('SERVER_NAME', '̾ϤƤ', 'required');
$form->addRule('ROOT_DIRECTORY_PATH', '١ǥ쥯ȥΥѥϤƤ', 'required');
$form->addRule('ROOT_DIRECTORY_URI', 'WebΤΥ١ȤʤURIϤƤ', 'required');
$form->addRule('DATA_FOLDER', '᡼եǼǡե̾ϤƤ', 'required');
$form->addRule('DATA_FOLDER', '񤭹߲ǽʥեˤƤ', 'check_data_folder', 'w');
$form->addRule('LIST_FILE', '᡼եΥꥹȤ¸ե̾ϤƤ', 'required');
$form->addRule('AUTH_DSN', 'ǧѥǡ١DSN(DataSet Name)ϤƤ', 'required');
$form->addRule('FILE_MODE', 'ǽʥ⡼ɤ 0646 ޤ 0664 Ǥ', 'check_file_mode', '0666');
$form->addRule('ADMIN_USER', '᡼եδѥ桼̾ϤƤ', 'required');
$form->addRule('ADMIN_PASS', '᡼եδѥ桼ΥѥɤϤƤ', 'required');

if ($form->validate()) {
    $form->process('save_config');
} else {
    $form->display();
}


// form->process ˤϿ륳Хåؿ
function save_config($form_data) {
    require_once 'config_util.php';

    $user = $form_data['ADMIN_USER'];
    $pass = $form_data['ADMIN_PASS'];
    $form_data['ADMIN_PASS'] = md5($pass);
    $fmode = octdec($form_data['FILE_MODE']);
    myfilemode($fmode);

    require_once 'mydb.php';
    if (! create_usertbl ($form_data['AUTH_DSN'], $user, $pass) ) {
        Error( "ѥɤν˼Ԥޤ", __LINE__, __FILE__);
        exit;
    }

    write_config($form_data);
    $param = read_config($form_data['CONFIG_FILE']);
    echo "<pre>"; var_export($param); echo "</pre>";
    if ( (is_array($param)?count($param):0) == 0 ) {
        Error( "ѥ᡼եɤ߹ߤ˼Ԥޤ", __LINE__, __FILE__);
        exit;
    }

    // եꥹȤν
    if (! file_exists($param['LIST_FILE']) ) {
	$title	  = ".\t".$param['SITE_TITLE']."\n";
	$abstruct = "+\t".$param['SITE_DESCRIPTION']."\n";
	//write_file_lock($param['LIST_FILE'], $title, $abstruct);
        require_once "filetable.php";
        $ft = new FileTable( $param['LIST_FILE'] );
        if ( $ft->addrow($title) === false ) {
          Error("᡼ꥹȥեؤΥȥϤԤޤ(". $ft->geterr(). ")", __LINE__, __FILE__);
        }
        if ( $ft->addrow($abstruct) === false ) {
          Error("᡼ꥹȥեؤγ׽ϤԤޤ(". $ft->geterr(). ")", __LINE__, __FILE__);
        }
        
	if ( file_exists($param['LIST_FILE']) ) {
	    echo 'եꥹ "'.$param['LIST_FILE'].'" եĤޤ<br>';
	} else {
	    echo '<font color="red">եꥹ "'.$param['LIST_FILE'].'ɥեκ˼Ԥޤ</font><br>';
	}
    }

    echo '󥹥ȡλˤϰʲκȤԤʤäƤ:';
    echo '<font color="red"><li>ե "install.php" äƤ</font></li>';
    echo '<font color="gray"><li>Ǥ顢<a href="imagelist.php">imagelist.php</a>˥Ƥ</font></li>';

}

function check_data_folder ($param_name, $param_value, $dummy)
{
    if ( file_exists($param_value) ) {
	if ( is_dir($param_value) && is_writeable($param_value) ) {
	    return true;
	} else {
	    return false;
	}
    } else {
	return false;
    }
}

function check_file_mode ($param_name, $param_value, $dummy)
{
    if ( trim($param_value) == '0646' || trim($param_value) == '0664' ) {
	    return true;
	} else {
	    return false;
	}
}

?>
