<?php
//   Kanji Image Output Functions
//
//   Originaly created for Japanese version of PHP/FI compatibility
// by Jun Kuwamura <juk@yokohama.email.ne.jp>.
//
// (TTF available version of GD is required for PHP module.)
//
// 2002-03-04 JuK font path modified for RHL and Plamo Linux
// 2002-02-17 JuK modified for imagelist program
//

// The following fonts settings should be modified accordingly.
$mincho_font = "/usr/share/fonts/TrueType/mika-p.ttf";
$gothic_font = "/usr/share/fonts/TrueType/mika.ttf";
$font_file = "/usr/share/fonts/TrueType/mika.ttf";
if ( is_dir("/usr/share/fonts/TrueType") ) {
  $TTF_JA_FONTPATH="/usr/share/fonts/TrueType";
} elseif ( is_dir("/usr/X11R6/lib/X11/fonts/TrueType") ) {
  $TTF_JA_FONTPATH="/usr/X11R6/lib/X11/fonts/TrueType";
}
if ( ! empty($TTF_JA_FONTPATH) ) {
  $mincho_font = "$TTF_JA_FONTPATH/FS-Mincho-gs.ttf";
  $gothic_font = "$TTF_JA_FONTPATH/FS-Gothic-gs.ttf";
  $font_file = "$TTF_JA_FONTPATH/FS-Gothic-gs.ttf";
}

///////////////////////////////////////
// Check GD module and load it if not
///////////////////////////////////////
if(!extension_loaded('gd')){
  if(!dl('gd.so')){
    echo 'error failed to lord gd.so';
    exit;
  }
}

//////////////////////////////////////////////
// Check MB_String module and load it if not
//////////////////////////////////////////////
if(!extension_loaded('mbstring')){
  if(!dl('mbstring.so')){
    echo 'error failed to lord mbstring.so';
    exit;
  }
}

//////////////////////////////////////
// Set output encoding for http text
// (ASCII, JIS, UTF-8, EUC-JP, SJIS)
//////////////////////////////////////
function SetKanjiOutput( $code ) {
  mb_http_output($code);
}

//////////////////////////////////////
// Set output kanji font
// (goth, min)
//////////////////////////////////////
function ImageSetKanjiFont( $font ) {
  global $mincho_font;
  global $gothic_font;
  global $font_file;

  if ( $font == "goth" ) {
    $font_file = $gothic_font;
  } else if ( $font == "min" ) {
		$font_file = $mincho_font;
  } else if ( is_file( $font ) ) {
    $font_file = $font;
  }
}

////////////////////////////////////////////////////////////////////////
// Kanji output to internal GD image in horizontal direction
//	$im: internal image
//	$size: font size(1,2,3)
//	$x: horizontal location from left
//	$y: virtical location from top
//	$text: test strings to output
//	$col: font color
////////////////////////////////////////////////////////////////////////
function ImageKanji ($im, $size, $x, $y, $text, $col) {
  global $font_file;

  $angle = 0;
  $size = $size * 4;
  $x-=$size;
  $y+=$size;
  ImageTTFText($im, $size, $angle, $x, $y, $col, $font_file, $text);
  $x++;
  ImageTTFText($im, $size, $angle, $x, $y, $col, $font_file, $text);
  $y--;
  ImageTTFText($im, $size, $angle, $x, $y, $col, $font_file, $text);
  $x--;
  ImageTTFText($im, $size, $angle, $x, $y, $col, $font_file, $text);
}

////////////////////////////////////////////////////////////////////////
// Kanji output to internal GD image in virtical direction
//	$im: internal image
//	$size: font size(1,2,3)
//	$x: horizontal location from left
//	$y: virtical location from top
//	$text: test strings to output
//	$col: font color
////////////////////////////////////////////////////////////////////////
function ImageKanjiUp ($im, $size, $x, $y, $text, $col) {
  global $font_file;

  $angle = 90;
  $size = $size * 4;
  $x+=$size;
  $y-=$size;
  ImageTTFText($im, $size, $angle, $x, $y, $col, $font_file, $text);
  $x++;
  ImageTTFText($im, $size, $angle, $x, $y, $col, $font_file, $text);
  $y--;
  ImageTTFText($im, $size, $angle, $x, $y, $col, $font_file, $text);
  $x--;
  ImageTTFText($im, $size, $angle, $x, $y, $col, $font_file, $text);
}
?>
