<?
//
// XY-Plot
//

require("../inc/imagekanji.php");

    define( "MAX_D", 1.79769313486231470e+308);
    define( "MIN_D", 4.94065645841256544e-324);
//    echo MIN_D, MAX_D;
//    $a =  MAX_D * 2;
//    $b =  MIN_D * 2;
//    echo "  $a, $b<p>";


// ScaleOrder->ida:
//            1    2    3    4    5    6    7    8    9   10   11   12   13   14
$tic1=array( .02, .05, .05, 0.1, 0.1, 0.1, 0.2, 0.2, 0.2, 0.5, 0.5, 0.5, 0.5, 0.5);
$tic2=array( 0.1, .25, 0.5, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
$tic3=array( 0.2, 0.5, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0);
$grid=array( 0.2, 0.5, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0);


function SimpleOrder( &$amin, &$amax, &$aso, &$da)
/*
 * arguments:
 *      float   *amin   : min. val. which will be replaced by ordered val.  
 *      float   *amax   : max. val. which will be replaced by ordered val.  
 *      float   *aso    : order for min or max values(10^iaso).
 *      float   *da     : difference between ordered min. and ordered max.
 * note:
 *      must be ($amax > $amin > 0).
 *      $amin will be set to 0.0.
 */
{
  global $DEBUG;

  $lmin = (int)log10($amin);
  $lmax = (int)log10($amax);
  if ($DEBUG) {
	printf( "SimpleOrder: *lmin=%f, *lmax=%f<br>\n", $lmin, $lmax);
  }
  $amin=0.0;
  $aso=pow(10.0,$lmax);
  $amax=Ceil($amax/$aso);
  $da = $amax - $amin;
  if ($DEBUG) {
	printf( "SimpleOrder: *amax=%f, *aso=%f, *da=%f<br>\n",
	       $amax, $aso, $da);
  }
}

function ScaleOrder( &$amin, &$amax, &$iaso, &$aso, &$da, &$isd, &$sd) 
/*
 * decimal order for scale.
 *
 * arguments:
 *      float   *amin   : min. val. which will be replaced by ordered val.  
 *      float   *amax   : max. val. which will be replaced by ordered val.  
 *      int     *iaso   : order for min or max values.
 *      float   *aso    : 10^iaso
 *      float   *da     : difference between ordered min. and ordered max.
 *      int     *isd    : order for difference of min. and max.
 *      float   *sd     : 10^isd
 */
//Usage:
//  ScaleOrder( $amin, $amax, $iaso, $aso, $da, $isd, $sd) ;
//  if ($DEBUG) {
//	printf( "ScaleOrder'd: *iaso=%d, *aso=%f, *da=%f, *isd=%d, *sd=%f<br>\n",
//	       $iaso, $aso, $da, $isd, $sd);
//	printf( "ScaleOrder'd: *amin=%f, *amax=%f<br>\n", $amin, $amax);
//  }
{
    global $DEBUG;
    $amin = (float)$amin;
    $amax = (float)$amax;

    $one = 1.0;
    $dec = 10.0;

    /* get maximum range */
    $am = $amax;
    if ($am < ($ab = abs($amin))) $am = $ab;
    if ($am < ($ad = ($amax - $amin))) $am = $ad;

    /*
     * get unit range and its order
     */
    $ao = $one;
    $iaso = 0;
    while ($am > $dec) {
	$am /= $dec;
	$ao *= $dec;
	$iaso++;
    }
    while ($am <= $one) {
	$am *= $dec;
	$ao /= $dec;
	$iaso--;
    }
    $amin /= $ao;
    $amax /= $ao;
    $omin = $amin;		/* unit minimum */
    $omax = $amax;		/* unit muximum */
    $da = $amax - $amin;	/* unit range */

    /*
     * ajust range order
     */
    $sd = $one;
    $isd = 0;
    while($da <= $one) {
	$da *= $dec;
	$sd /= $dec;
	$isd--;
    }
    while( $da > $dec) {
	$da /= $dec;
	$sd *= $dec;
	$isd++;
    }
    $one *= $sd;		/* ajusted unit order */

    $sd10 = $sd/$dec;
    $amin =(float)((int)($amin/$sd10)) * $sd10; /* round min. at order with diff. */
    $amax =(float)((int)($amax/$sd10)) * $sd10; /* round max. at order with diff. */
    if ($amin>$omin) $amin-=(1.0/$dec);
    if ($amax<$omax) $amax+=(1.0/$dec);
    $ida =(int)(($amax - $amin)/$sd + 0.4999);	/* range at unit order */

    $aso = pow((double)$dec, (double)$iaso);
    $sd = pow((double)$dec, (double)$isd);

    if ($DEBUG)
	printf( "ScaleOrder: *iaso=%d, *aso=%f, *da=%f, *isd=%d, *sd=%f<br>\n",
	       $iaso, $aso, $da, $isd, $sd );

} /* ScaleOrder() */

function ScaleLogar( &$amin, &$amax, &$imin, &$imax, &$ida, &$nra)
/*
 * Scaling for Logarithm scale
 *
 * arguments:
 *      float   *amin   : min. val. which will be replaced by ordered val.  
 *      float   *amax   : max. val. which will be replaced by ordered val.  
 *      int     *imin   : log10(*amin)
 *      float   *imax   : log10(*amax)
 *      float   *ida    : *imax - *imin;
 *      int     *nra    : -1 if negative values
 */
//Usage:
//  ScaleLogar( $amin, $amax, $imin, &$imax, $ida, $nra);
//  if ($DEBUG) {
//	printf( "ScaleLogar: *imin=%d, *imax=%d, *ida=%d, *nra=%d<br>\n",
//	       $imin, $imax, $ida, $nra );
//  }
{
    global $DEBUG;
    $MAXFLOAT =   (float) 3.40282347e+38;
    $MINFLOAT =   (float) 1.40129846e-45;

    $amin = (float)$amin;
    $amax = (float)$amax;

    $nra = 1;
    if (abs($amax) < abs($amin)) {
	$nra = -1;
	$a = abs($amin);
	$amin = abs($amax);
	$amax = $a;
    }
    if ($DEBUG) echo "max = $amax ,  min= $amin , ($MINFLOAT, $MAXFLOAT);<br>";
    if ($amax > $MAXFLOAT) $amax = $MAXFLOAT; 
    if ($amin < $MINFLOAT) $amin = $MINFLOAT; 
    $imax = (int)(log10($amax) +.4999);
    $imin = (int)(log10($amin));
    $ida = $imax - $imin;
    if ($ida == 0)
 	$imax += 1;
    $ida = $imax - $imin;
    if ($DEBUG)
	printf( "ScaleLogar: *imin=%d, *imax=%d, *ida=%d, *nra=%d<br>\n",
	      $imin, $imax, $ida, $nra );
} /* ScaleLogar() */

function ScaleShift(&$amin, &$amax, &$ida, $omin, $omax, $sd, $dec, $one)
{
    /*
     * shift order in some case
     */
    $mda = $ida % 2;	 /* even or odd ? */
    if ($omin < $amin) { /* when lower boarder shifted to greater */
	if ($ida > 10 && $mda == 0)
	    $amin -= $one*2.0;	/* even val. greater than 7 */
	else if (($ida <= 5) && (abs((($amin) - $omin)) < ( $ad = $one/2.0)) )
	    $amin -= $ad; /* less than one-half shifted val. less than / equal 2 */
	else
	    $amin -= $one;
    }

    if ($omax > $amax) { /* when upper boarder shifted to less */
	if ($ida > 10 && $mda == 0)
	    $amax += ($one*2.0);	/* even val. greater than 7 */
	else if (($ida <= 5) && (abs($amax - $omax) < ( $ad = $one/2.0)) )
	    $amax += $ad; /* less than one-half shifted val. less than / equal 2 */
	else
	    $amax += $one;
    }
    $da = $amax - $amin;
    $ida =(int)(($amax - $amin)/$sd + 0.4999);
}



function PlotAxisMonthPollX( &$im, $x0, $y0, $y9, $dw, $th, $nr, $months, $years, $color, $size)
//	&$im		: image pointer
//	$x0		: start x coordinate value
//	$y0		: y coordinate value for X axis
//	$dw		: actual plot area width on canvas
//	$th		: actual vertical tick unit length
//	$nr		: number of months in a array
//	$months		: month array
//	$years		: year array
//	$color		: color
//	$size		: font size
{
  $fh = ImageFontHeight($fs);
  $fw = ImageFontWidth($fs);
  if ($th<0) $fh = -($fh);

  $dx = $dw / $nr;	// delta x
  $x = $x0;		// x coordinate value for start posision
  $xl1= $x0 + ($dx - $fw)/2;
  $xl2= $xl1;
  $yl1 = $y0 - $th*2;		// y coordinate value for month strings
  $yl2 = $yl1 - $fh;	// y coordinate value for year strings

  // Plot year and month under X axis
  $lm = 0;
  for ($i=0; $i<$nr; $i++) {
    // Plot year and month under X axis
    ImageString($im, 1, $xl1, $yl1, $months[$i], $fg);		// month
    if ( $lm == 12 ) {
      ImageString($im, 1, $xl1, $yl2, $years[$i], $fg);	// year
      ImageDashedLine($im, $x, $y0, $x, $y9, $fg);		// grid
    }
    $lm=$months[$i];
    // Plot tick(0)
    ImageLine($im, $lx, $y0, $lx, $y0-$th, $fg);		// tick
    // Next
    $lx=$x;
    $ly=$y;
    $xl1+=$dx;
    $x+=$dx;
  }
}


function PlotAxisMonthX( &$im, $x0, $y0, $y9, $dw, $th, $nr, $months, $years, $color, $size)
//	&$im		: image pointer
//	$x0		: start x coordinate value
//	$y0		: y coordinate value for X axis
//	$dw		: actual plot area width on canvas
//	$th		: actual vertical tick unit length
//	$nr		: number of months in a array
//	$months		: month array
//	$years		: year array
//	$color		: color
//	$size		: font size
{
  $fh = ImageFontHeight($fs);
  $fw = ImageFontWidth($fs);
  if ($th<0) $fh = -($fh);

  $dx = $dw / ($nr - 1);	// delta x
  $x = $x0;		// x coordinate value for start posision
  $xl1= $x0 - $fw/2;
  $xl2= $xl1;
  $yl1 = $y0 - $th*2;		// y coordinate value for month strings
  $yl2 = $yl1 - $fh;	// y coordinate value for year strings

  // Plot year and month under X axis
  ImageString($im, 1, $xl1, $yl1, $months[0], $fg);
  ImageString($im, 1, $xl2, $yl2, $years[0], $fg);
  $lm = 0;
  for ($i=1; $i<$nr; $i++) {
    $lx=$x;
    $ly=$y;
    $xl1+=$dx;
    $x+=$dx;
    // Plot year and month under X axis
    ImageString($im, 1, $xl1, $yl1, $months[$i], $fg);		// month
    if ( $lm == 12 ) {
      ImageString($im, 1, $xl1, $yl2, $years[$i], $fg);	// year
      ImageDashedLine($im, $x, $y0, $x, $y9, $fg);		// grid
    }
    $lm=$months[$i];
    // Plot tick(0)
    ImageLine($im, $lx, $y0, $lx, $y0-$th, $fg);		// tick
  }
}

function PlotAxisY( &$im, $amin, $amax, $aso, $x0, $y0, $dh, $tw, $color, $name, $size, $right=0)
//	&$im		: image pointer
//	$amin,$amax	: minimum value,maximum value
//	           	: ( -10 < $amin < $amax < 10 )
//      $aso		: unit value
//	$x0		: x coordinate value for Y axis
//	$y0		: start y coordinate value
//	$dh		: actual plot area height on canvas
//	$tw		: actual horizontal tick unit length
//	$color		: color
//	$name		: label leading name
//	$size		: font size
//	$right		: tick right side(=1)
{
  global $DEBUG;
  global $tic1, $tic2, $tic3;

  $amin=Floor($amin);
  $amax=Ceil($amax);
  $da=$amax-$amin;
  $ida=(int)$da;

  $tic[1] = $tic1[$ida];
  $tic[2] = $tic2[$ida];
  $tic[3] = $tic3[$ida];
  if ($right>0) $tw=-($tw);
  for ($j=1; $j<=3; $j++) {
    $nt = $da / $tic[$j];
    $dy = $dh / $nt;	// delta y
    $y = $y0;		// y coordinate value for start posision
    for ($i=0; $i<=$nt; $i++, $y+=$dy) {
      ImageLine($im, $x0, $y, $x0+$tw*$j, $y, $color);	// tick
    }
  }
  $fh = ImageFontHeight($size);
  $fw = ImageFontWidth($size);
  $fhw = $fw;
  if ($right>0) {
	$fw=-$fw;
  } else {
	$fw=$fw*2;
  }
  $xl1 = ($x0-$fw) + ($tw*3);	// x coordinate value for value strings
  $y = $y0 - $fh/2;		// y coordinate value for start posision
  $val = $amin;		// start value
  for ($i=0; $i<=$nt; $i++, $y+=$dy, $val+=$tic[3]) {
      ImageString($im, $size, $xl1, $y, $val, $color);		// number
  }
  // Axis label
  if ($aso == 0.0) {
    $val = $name;
  } else {
    $unit = "x".(int)$aso;
    if (! strpos( $name, "%" ) ) {
      $name .= " [%s]";
    }
    $val = sprintf("$name", $unit);
  }
  if ($DEBUG) {
    echo "aso=$aso, pos=$pos, name=$name, val=$val<br>\n";
  }
  $len = Strlen($val);
  $xl2 = $xl1-$fw*1.5;				// x coordinate value for it
  $yl2 = ($dh + ($len * $fhw) - $fw)*.5 + $y0;	// y coordinate value for it
  ImageStringUp($im, $size, $xl2, $yl2, $val, $color);	// name
}

function PlotPollY( &$im, $x0, $y0, $x9, $y9, $nr, $values, $aso, $da, $color, $num, $idx)
//	&$im		: image pointer
//	($x0,$y0),($x9, $y9)	: diagonal line on actual  plot area
//      $nr		: number of datum points
//	$values		: data value array
//	$color		: color
//	$aso		: order for min or max values.
//	$da		: difference between ordered min. and ordered max.
//	$color		: color
//	$num		: number of polls for each column
//	$idx		: index number of poll in the column
{
  $dw = $x9 - $x0;
  $dh = $y9 - $y0;
  $da = Ceil($da);
  $sc = $dh / ($aso * $da);
  $dx = $dw / $nr;	// delta x
  $width = $dx / $num;
  $offset = $width * ($idx - 1);

  $x  = $x0 + $offset;		// x coordinate value for start posision
  $ny = $y0;
  for ($i=0; $i<$nr; $i++) {
    $nx = $x + $width;
    $y =($values[$i] * $sc) + $y0;
    ImageFilledRectangle($im, $x, $y, $nx, $ny, $color);	// poll
    $x+= $dx;
  }
}

function PlotDataY( &$im, $x0, $y0, $x9, $y9, $nr, $values, $aso, $da, $color)
//	&$im		: image pointer
//	($x0,$y0),($x9, $y9)	: diagonal line on actual  plot area
//      $nr		: number of datum points
//	$values		: data value array
//	$color		: color
//	$aso		: order for min or max values.
//	$da		: difference between ordered min. and ordered max.
//	$color		: line color
{
  $dw = $x9 - $x0;
  $dh = $y9 - $y0;
  $da = Ceil($da);
  $sc = $dh / ($aso * $da);
  $x  = $x0;		// x coordinate value for start posision
  $dx = $dw / ($nr - 1);	// delta x
  $y  = ($values[0] * $sc) + $y0;
  for ($i=1; $i<$nr; $i++) {
    $lx=$x;
    $ly=$y;
    // Plot graph(0)
    $x+= $dx;
    $y =($values[$i] * $sc) + $y0;
    ImageLine($im, $lx, $ly, $x, $y, $color);		// graf
  }
}

function PlotLegend( &$im, $size, &$x, &$y, $th, $tw, $name, $color )
{
  $fh = ImageFontHeight($size);
  $fw = ImageFontWidth($size);
  if ($th<0) $fh = -($fh);
  $x1 = $x;
  $x2 = $x1 + $tw*3;
  ImageLine($im, $x1, $y, $x2, $y, $color);
  $x2 += $tw;
  $y2 = $y + $fh*0.5;
  ImageString($im, $size, $x2, $y2, $name, $color);
  $y-=$fh;
}

function PlotTitle( &$im, $size, $w, $h, $title, $color )
{
  global $DEBUG;
  $fh = ImageFontHeight($size);
  $fw = ImageFontWidth($size);
  $l = Strlen($title);
  $x=($w-$fw*$l)/2;
  $y=($h-$fh)/2;
  if ($DEBUG) {
    echo "ImageString($im, $size, $x, $y, $title, $color)<br>\n";
  } else {
    ImageSetKanjiFont("goth");
    ImageString($im, $size, $x, $y, $title, $color);
  }
}

?>
