<?
//
// Image Processing
//
require("../inc/xyplot.php");
for ($j=0; $j<$nf; $j++) {
    $max[$j]=max($value[$j]);
    $min[$j]=min($value[$j]);
}

// Initialize Image
if (! $DEBUG) {
  mb_http_output("pass");
  header("Content-type: image/png");
} else {
  // DEBUG
  echo "min-max<br>";
  for ($j=0; $j<$nf; $j++) {
    echo $min[$j]."-".$max[$j]." | ";
  }
  // $allmax=max($max);
  echo "<br>\n";
}

$w=640;			// screen width
$h=480;			// screen height
$fs=2;			// font size( 1, 2, 3, 4 or 5 )

$im = ImageCreate($w, $h);

$black = ImageColorAllocate($im, 0,   0,   0  );
$white = ImageColorAllocate($im, 255, 255, 255);
$red   = ImageColorAllocate($im, 255, 0,   0  );
$dred  = ImageColorAllocate($im, 135, 0,   0  );
$green = ImageColorAllocate($im, 0,   255, 0  );
$dgreen= ImageColorAllocate($im, 0,   135, 0  );
$blue  = ImageColorAllocate($im, 0,   0,   255);
$dblue = ImageColorAllocate($im, 0,   0,   135);
$yellow= ImageColorAllocate($im, 250, 215, 0  );
$orange= ImageColorAllocate($im, 250, 165, 0  );
$bg=$white;
$fg=$black;

if ( ! $COLORS[0] ) $COLORS[0] = $bg;
if ( ! $COLORS[1] ) $COLORS[1] = $fg;
if ( ! $COLORS[2] ) $COLORS[2] = $orange;
if ( ! $COLORS[3] ) $COLORS[3] = $dred;
if ( ! $COLORS[4] ) $COLORS[4] = $dblue;
if ( ! $COLORS[5] ) $COLORS[5] = $dgreen;
if ( ! $COLORS[6] ) $COLORS[6] = $black;

// Fill background with a $bg color
ImageFilledRectangle($im, 0, 0, $w, $h, $bg);

$xoff = $w / 10;
$yoff = $h / 10;
$x0 = $xoff;
$y0 = $h - $yoff;
if ( $LEGEND_POSISION == 1 ) {
  $x9 = $w - $xoff*2;
} else {
  $x9 = $w - $xoff;
}
$y9 = $yoff;

// Title Label
PlotTitle( $im, 4, $w, $yoff, $PLOT_TITLE, $fg);

// Plot area frame
ImageRectangle($im, $x0, $y0, $x9, $y9, $fg);

// Plot Graf
$dw = ($x9 - $x0);	// box width
$tw = ($dw+100)/100;	// horizontal tick unit length
$dh = ($y9 - $y0);	// box height
$th = ($dh+100)/100;	// vertical tick unit length

PlotAxisMonthX( $im, $x0, $y0, $y9, $dw, $th, $nr, $value[1], $value[0], $fg, $fs);

//
// Plot Y axis(0)
//	(using general procedure functions)
$nf1 = $nf-1;
$amin = $min[$nf1];
$amax = $max[$nf1];
SimpleOrder( $amin, $amax, $aso, $da);
if ($DEBUG) {
	printf( "SimpleOrder'd: *amax=%f, *aso=%f, *da=%f<br>\n",
		$amax, $aso, $da);
}
if ( ! IsSet($YLABEL) ) $YLABEL = $fldname[$nf1];
PlotAxisY( $im, $amin, $amax, $aso, $x0, $y0, $dh, $th, $fg, $YLABEL, $fs, 0);
PlotDataY( $im, $x0, $y0, $x9, $y9, $nr, $value[$nf1], $aso, $da, $COLORS[$nf1]);

//
// Plot Y axis(1,2,3...)
//	(using general procedure functions)
$amin = $min[$nf1];
$amax = $max[$nf1];
for ($j=2; $j<$nf1; $j++) {
  $amin = Min( $amin, $min[$j] );
  $amax = Max( $amax, $max[$j] );
}
if ($DEBUG) {
	printf( "nf=%d, nf1=%d, amin=%d, amax=%d<br>\n",
		$nf, $nf1, $amin, $amax );
}

SimpleOrder( $amin, $amax, $aso, $da);
if ($DEBUG) {
	printf( "SimpleOrder'd: *amax=%f, *aso=%f, *da=%f<br>\n",
		$amax, $aso, $da);
}
if ( ! IsSet($YLABEL1) ) $YLABEL1 = $fldname[$nf1];
PlotAxisY( $im, $amin, $amax, $aso, $x9, $y0, $dh, $th, $dgreen, $YLABEL1, $fs, 1);

// Plot Legends
$fh = ImageFontHeight($fs);
$fw = ImageFontWidth($fs);
if ( $LEGEND_POSISION == 1 ) {
  $x = $x9 + $tw*4 + $fw*2;
  $y = $y9 + $fh*2;
} else {
  $x = $x0 + $fw*2;
  $y = $y9 + $fh*2;
}

for ($i=2; $i<$nf; $i++ ) {
  PlotDataY( $im, $x0, $y0, $x9, $y9, $nr, $value[$i], $aso, $da, $COLORS[$i]);
  if ( ! $LEGENDS[$i] ) {
	$LEGENDS[$i] = $fldname[$i];
  }
  PlotLegend($im, $fs, $x, $y, $th, $tw, $LEGENDS[$i], $COLORS[$i]);
}

if (! $DEBUG) {
  ImagePNG($im);
}
ImageDestroy($im);

?>			  
