<?
//
// Image Processing
//
require("../inc/xyplot.php");

for ($j=0; $j<$nf; $j++) {
    $max[$j]=max($value[$j]);
    $min[$j]=min($value[$j]);
}

// Initialize Image
if (! $DEBUG) {
  mb_http_output("pass");
  header("Content-type: image/png");
} else {
  // DEBUG
  echo "min-max<br>";
  for ($j=0; $j<$nf; $j++) {
    echo $min[$j]."-".$max[$j]." | ";
  }
  // $allmax=max($max);
  echo "<br>\n";
}


$w=640;			// screen width
$h=480;			// screen height
$fs=2;			// font size( 1, 2, 3, 4 or 5 )

$im = ImageCreate($w, $h);

$black = ImageColorAllocate($im, 0,   0,   0  );
$white = ImageColorAllocate($im, 255, 255, 255);
$red   = ImageColorAllocate($im, 255, 0,   0  );
$dred  = ImageColorAllocate($im, 135, 0,   0  );
$green = ImageColorAllocate($im, 0,   255, 0  );
$dgreen= ImageColorAllocate($im, 0,   135, 0  );
$blue  = ImageColorAllocate($im, 0,   0,   255);
$dblue = ImageColorAllocate($im, 0,   0,   135);
$yellow= ImageColorAllocate($im, 250, 215, 0  );
$orange= ImageColorAllocate($im, 240, 155, 0  );
$bg=$white;
$fg=$black;
$color[2]=$orange;
$color[3]=$dgreen;
$color[4]=$dblue;
$color[5]=$dred;
$color[6]=$green;
$color[7]=$blue;
$color[8]=$red;

// Fill background with a $bg color
ImageFilledRectangle($im, 0, 0, $w, $h, $bg);

$xoff = $w / 10;
$yoff = $h / 10;
$x0 = $xoff;
$y0 = $h - $yoff;
if ( $LEGEND_POSISION == 1 ) {
  $x9 = $w - $xoff*2;
} else {
  $x9 = $w - $xoff;
}
$y9 = $yoff;

// Title Label
PlotTitle( $im, 4, $w, $yoff, $PLOT_TITLE, $fg);

// Plot area frame
ImageRectangle($im, $x0, $y0, $x9, $y9, $fg);

// Plot Graf
$dw = ($x9 - $x0);	// box width
$tw = ($dw+100)/100;	// horizontal tick unit length
$dh = ($y9 - $y0);	// box height
$th = ($dh+100)/100;	// vertical tick unit length

PlotAxisMonthPollX( $im, $x0, $y0, $y9, $dw, $th, $nr, $value[1], $value[0], $fg, $fs);

//
// Plot Y axis
//
$aminl=1.e37;
$aminr=1.e37;
$amaxl=-1.e37;
$amaxr=-1.e37;
for ($i=2; $i<=$MAXFLD; $i++ ) {
  if ( ! $YAXISR[$i] ) {
      $aminl = Min( $aminl, $min[$i] );
      $amaxl = Max( $amaxl, $max[$i] );
  } else {
      $aminr = Min( $aminr, $min[$i] );
      $amaxr = Max( $amaxr, $max[$i] );
  }
}

SimpleOrder( $aminl, $amaxl, $asol, $dal);
if ($DEBUG) {
	printf( "SimpleOrder'd: *amaxl=%f, *asol=%f, *dal=%f<br>\n",
	       $amaxl, $asol, $dal);
}
if ( ! IsSet($YLABEL) ) $YLABEL = $fldname[2];
PlotAxisY( $im, $aminl, $amaxl, $asol, $x0, $y0, $dh, $th, $color[2], $YLABEL, $fs, 0);

SimpleOrder( $aminr, $amaxr, $asor, $dar);
if ($DEBUG) {
	printf( "SimpleOrder'd: *amaxr=%f, *asor=%f, *dar=%f<br>\n",
	       $amaxr, $asor, $dar);
}
if ( ! IsSet($YLABEL1) ) $YLABEL1 = $fldname[$MAXFLD];
PlotAxisY( $im, $aminr, $amaxr, $asor, $x9, $y0, $dh, $th, $color[$MAXFLD], $YLABEL1, $fs, 1);

$num = $MAXFLD - 1;
for ($i=2; $i<=$MAXFLD; $i++ ) {
  $idx = $i - 1;
  if (! $YAXISR[$i] ) {
    PlotPollY( $im, $x0, $y0, $x9, $y9, $nr, $value[$i], $asol, $dal, $color[$i], $num, $idx);
  } else {
    PlotPollY( $im, $x0, $y0, $x9, $y9, $nr, $value[$i], $asor, $dar, $color[$i], $num, $idx);
  }
  if ( $DEBUG ) {
    printf( "%d : %d<br>", $i, $YAXISR[$i]);
  }
}

// Plot Legends
$fh = ImageFontHeight($fs);
$fw = ImageFontWidth($fs);
if ( $LEGEND_POSISION == 1 ) {
  $x = $x9 + $tw*4 + $fw*2;
 $y = $y9 + $fh*2;
} else {
  $x = $x0 + $fw*2;
  $y = $y9 + $fh*2;
}
for ($i=2; $i<=$MAXFLD; $i++ ) {
  if ( ! $LEGENDS[$i] ) {
	$LEGENDS[$i] = $fldname[$i];
  }
  PlotLegend($im, $fs, $x, $y, $th, $tw, $LEGENDS[$i], $color[$i]);
}

if (! $DEBUG) {
  ImagePNG($im);
}
ImageDestroy($im);

?>			  
