<?php
function librarylist($pg, $name, $val, $dis)
{
	$sql = "SELECT title FROM videolib";
	$res = $pg->query($sql);
	$n = $pg->num_rows($res);
	for($i=0; $i<$n; $i++) {
		$row = $pg->fetch_assoc($res, $i);
		$llist[$i] = $row["title"];
	}
	
	print "<SELECT NAME=$name $dis>\n";
	for($i=0; $i<$n; $i++) {
		print "<OPTION VALUE=\"$llist[$i]\"";
		if($llist[$i] === $val) {
			print " SELECTED>\n";
		} else {
			print ">\n";
		}
		print "$llist[$i]</OPTION>\n";
	}
	print "</SELECT>\n";
	return($llist);
}

function channellist($pg, $name, $val, $dis)
{
	$sql = "SELECT channel,bcasname FROM bstation ORDER by channel";
	$res = $pg->query($sql);
	$n = $pg->num_rows($res);
	for($i=0; $i<$n; $i++) {
		$row = $pg->fetch_assoc($res, $i);
		$clist[$row["channel"]] = $row["bcasname"];
	}
	print "<SELECT NAME=$name $dis>\n";
	foreach($clist as $i=>$c) {
		print "<OPTION VALUE=\"$i\"\n";
		if($i == $val) {
			print " SELECTED>\n";
		} else {
			print ">\n";
		}
		print "$c</OPTION>\n";
	}
	print "</SELECT>\n";
	return($clist);
}

function qualitylist($pg, $name, $val, $dis)
{
	$sql = "SELECT bitrate,name FROM quality";
	$res = $pg->query($sql);
	$n = $pg->num_rows($res);
	for($i=0; $i<$n; $i++) {
		$row = $pg->fetch_assoc($res, $i);
		$qlist[$row["bitrate"]] = $row["name"];
	}
	print "<SELECT NAME=$name $dis>\n";
	foreach($qlist as $i=>$q) {
		print "<OPTION VALUE=\"$i\"\n";
		if($i == $val) {
			print " SELECTED>\n";
		} else {
			print ">\n";
		}
		print "$q</OPTION>\n";
	}
	print "</SELECT>\n";
	return($qlist);
}

function dimensionlist($pg, $name, $val, $dis)
{
	$sql = "SELECT id,name FROM dimension";
	$res = $pg->query($sql);
	$n = $pg->num_rows($res);
	for($i=0; $i<$n; $i++) {
		$row = $pg->fetch_assoc($res, $i);
		$dlist[$row["id"]] = $row["name"];
	}
	print "<SELECT NAME=$name $dis>\n";
	foreach($dlist as $i=>$d) {
		print "<OPTION VALUE=\"$i\"\n";
		if($i == $val) {
			print " SELECTED>\n";
		} else {
			print ">\n";
		}
		print "$d</OPTION>\n";
	}
	print "</SELECT>\n";
	return($dlist);
}

function multiplexlist($pg, $name, $val, $dis)
{
	$sql = "SELECT id,name FROM multiplex";
	$res = $pg->query($sql);
	$n = $pg->num_rows($res);
	for($i=0; $i<$n; $i++) {
		$row = $pg->fetch_assoc($res, $i);
		$mlist[$row["id"]] = $row["name"];
	}
	print "<SELECT NAME=$name $dis>\n";
	foreach($mlist as $i=>$m) {
		print "<OPTION VALUE=\"$i\"\n";
		if($i == $val) {
			print " SELECTED>\n";
		} else {
			print ">\n";
		}
		print "$m</OPTION>\n";
	}
	print "</SELECT>\n";
	return($mlist);
}

function reccmd($encoder, $spool, $v)
{
	if(!is_executable($encoder)) return(-1);
	$e = explode(":", $v["duration"]);
	if(count($e) == 2) {
		$endpos = $e[0] . ":" . $e[1] . ":00";
	} else {
		$endpos = $v["duration"];
	}
	$libdir = $spool . "/" . $v["title"] . "/";
	$enc = 'export PATH=$PATH:/usr/local/bin; export HOME=/root; ';
	$enc .= "$encoder tv://" . $v["channel"] . " ";
	$enc .= "-tv driver=v4l:width=768:height=480:norm=NTSC:chanlist=japan-bcast:alsa ";
	$enc .= "-ovc lavc -lavcopts vcodec=mpeg4:vbitrate=" . $v["quality"] . ":mbd=1 ";
//	$enc .= "-oac mp3lame -lameopts cbr:br=96:vol=0 ";
	$enc .= "-oac lavc ";
	$enc .= "-vop scale=" . $v["dimension"] . " "; 
	$enc .= "-o " . $libdir . $v["filename"] . " -endpos $endpos";
	$d = date("H:i m/d/Y", strtotime($v["recdate"] . " " . $v["rectime"]));
	$cmd = "/bin/echo \"$enc >/dev/null 2>/dev/null\" | /usr/bin/at $d 2>&1";
//	print $cmd;
	$ret = exec($cmd);
	$o = explode(" ", $ret);
	if($o[0] == "job") {
		$atno = $o[1];
	} else {
		$atno = -1;
	}
	return($atno);
}

function cancmd($atno)
{
	exec("/usr/bin/atrm $atno");
}

function thumbcmd($pg, $player, $spool, $avifile, $dim, $keys, $quotes)
{
	if(!is_executable($player) || !is_file("$spool/$avifile")) return(-1);
	$cmd = "export PATH=$PATH:/usr/local/bin; export HOME=/root; ";
	$cmd .= "cd $spool; $player -vo png -vop scale=$dim -ao null -ss 3 -frames 1 -z 4 $avifile";
//	print $cmd;
	exec($cmd);
	$file = "$spool/00000001.png";
	$file2 ="$spool/00000002.png";
	if(is_file($file)) {
		$pg->query("begin");
		$oid = $pg->lo_create();
		$lo = $pg->lo_open($oid, "w");
		$fd = fopen($file, "r");
		$im = fread($fd, filesize($file));
		fclose($fd);
		$sz = $pg->lo_write($lo, $im);
		//		print "$sz $oid<br>";
		$pg->lo_close($lo);
		if($sz != filesize($file)) {
			$pg->query("rollback");
			return(-1);
		}
		$vars = array("thumb" => $oid,
				"avisize" => filesize("$spool/$avifile")
				  );
		$quotes["thumb"] = "";
		$quotes["avisize"] = "";
		$res = $pg->update("record", $keys, $vars, $quotes);
		if($res) {
			$pg->query("end");
		} else {
			$pg->query("rollback");
			return(-1);
		}
	} else {
		//can not create thumbnail
		return(-1);
	}
	unlink($file);
	if(is_file($file2)) {
		unlink($file2);
	}
	return($oid);
}

function playcmd($player, $spool, $v)
{
	if(!is_executable($player)) return(-1);
	$libdir = $spool . "/" . $v["title"] . "/";
	$play = 'export PATH=$PATH:/usr/local/bin; export HOME=/root; ';
	$play .= "export DISPLAY=unix:0; $player $libdir" . $v['filename'];
	$play .= ">/dev/null 2>/dev/null &";
//	$cmd = "/bin/echo \"$play >/dev/null 2>/dev/null\" | /usr/bin/at +1 minutes 2>&1";
//	print $play;
	system($play);
//	print $cmd;
//	$ret = exec($cmd);
//	$o = explode(" ", $ret);
//	if($o[0] == "job") {
//		$atno = $o[1];
//	} else {
//		$atno = -1;
//	}
	return(0);
}

function tvoncmd($tv, $v)
{
	if(!is_executable($tv)) return(-1);
	if(basename($tv) == "mplayer") {
		$tvon = "$tv tv://" . $v["channel"] . " ";
		$tvon .= "-tv driver=v4l:width=768:height=480:norm=NTSC:chanlist=japan-bcast:alsa";
	} else if(basename($tv) == "xawtv") {
		$tvon = "$tv -f " . $v["bcasname"];
	}
	$play = 'export PATH=$PATH:/usr/local/bin; export HOME=/root; ';
	$play .= "export DISPLAY=unix:0; $tvon";
	$play .= ">/dev/null 2>/dev/null &";
//	$cmd = "/bin/echo \"$play >/dev/null 2>/dev/null\" | /usr/bin/at now 2>&1";
	exec($play);
//	print $cmd;
//	$ret = exec($cmd);
//	$o = explode(" ", $ret);
//	if($o[0] == "job") {
//		$atno = $o[1];
//	} else {
//		$atno = -1;
//	}
	return(0);
}

function dvdplaycmd($dvdplay, $v)
{
	if(!is_executable($dvdplay)) return(-1);
	$dvd = "$dvdplay dvd://" . $v["title"] . " ";
	$dvd .= "-alang " . $v["alang"] . " ";
	$dvd .= "-slang " . $v["slang"] . " ";
	$dvd .= $v["dev"];
	$play = 'export PATH=$PATH:/usr/local/bin; export HOME=/root; ';
	$play .= "export DISPLAY=unix:0; $dvd >/dev/null 2>/dev/null &";
//	$cmd = "/bin/echo \"$play >/dev/null 2>/dev/null\" | /usr/bin/at now 2>&1";
	system($play);
//	print $play;
//	$ret = exec($cmd);
//	$o = explode(" ", $ret);
//	if($o[0] == "job") {
//		$atno = $o[1];
//	} else {
//		$atno = -1;
//	}
	return(0);
}
?>
