#!/bin/sh

SWNAME=x11iraf
SWVERSION=1.3.2

PREFIX=/opt/iraf

PLAMOARCH=i386
PLAMOVER=P1
DOCDIR=/usr/share/doc

set_irafenv() {
  # see unix/portkit/README and unix/hlib/irafuser.csh
  iraf=${PREFIX}/iraf/
  MACH=linux
  IRAFARCH=$MACH
  export iraf MACH IRAFARCH
  #
  HOSTID=unix
  host=${iraf}unix/
  hlib=${iraf}unix/hlib/
  hbin=${iraf}unix/bin.$MACH/
  tmp=/tmp/
  export HOSTID host hlib hbin tmp
  #
  CC_IOPT="-I${PREFIX}/iraf/include"

  CC="gcc"
  F77="$hlib/f77.sh"
  F2C=$hbin/f2c.e
  RANLIB=ranlib
  export CC F77 F2C RANLIB
  #
  HSI_CF="$CC_IOPT -O -DLINUX -DPOSIX -DSYSV -w -Wunused"
  HSI_XF="-Inolibc -w -/Wunused"
  HSI_FF="$CC_IOPT -O"
  HSI_LF=""
  HSI_F77LIBS=""
  HSI_LFLAGS=""
  HSI_OSLIBS=""
  mkzflags="'lflags=-Nxz -/Wl,-Bstatic'"
  #
  HSI_CF="$HSI_CF -DNOVOS"
  HSI_LIBS="${iraf}unix/bin/libboot.a ${iraf}unix/bin/libos.a"
  export HSI_CF HSI_XF HSI_FF HSI_LF HSI_F77LIBS HSI_LFLAGS HSI_OSLIBS mkzflags HSI_LIBS

  XC_CFLAGS=$CC_IOPT
  XC_FFLAGS=$CC_IOPT
  export XC_CFLAGS XC_FFLAGS

  # see tables/lib/zzsetenv.def
  tables=${PREFIX}/iraf/tables/
  tablesbin=${tables}/bin.generic/
  tableslib=${tables}/lib/
  export tables tablesbin tableslib

  # see noao/lib/zzsetenv.def
  noao=${PREFIX}/iraf/noao/
  noaobin=${noao}/bin.generic/
  noaolib=${noao}/lib/
  export noao noaobin noaolib

  pkglibs=${noao}/bin.generic/,${noao}/lib/,${tables}/bin.generic/,${tables}/lib/
  export pkglibs

  PATH=${PREFIX}/iraf/local/bin:/usr/X11R6/bin:$PATH
}


#wget http://iraf.nao.ac.jp/iraf/ftp/iraf/x11iraf/x11iraf-v1.3.1-src.tar.gz
#wget ftp://iraf.noao.edu/pub/fitz/x11iraf-v1.3.2-src.tar.gz
	
rm -rf ${SWNAME}-${SWVERSION}
mkdir ${SWNAME}-${SWVERSION}
cd ${SWNAME}-${SWVERSION}
tar zxf ../${SWNAME}-v${SWVERSION}-src.tar.gz
patch -p1 < ../x11iraf-1.3.1-obm-stdarg.patch
patch -p1 < ../x11iraf-1.3.1-errno.patch
patch -p1 < ../x11iraf-1.3.1-xgterm-ad.patch
patch -p1 < ../x11iraf-1.3.1-xgterm-numlock.patch
patch -p1 < ../x11iraf-1.3.2-skip-xpm_xaw3d-build.patch

set_irafenv

xmkmf
make World

rm -rf ../pkg
mkdir -p ../pkg/usr/X11R6/bin
mkdir -p ../pkg/usr/X11R6/lib
mkdir -p ../pkg/usr/X11R6/lib/X11/app-defaults
mkdir -p ../pkg/usr/X11R6/include
mkdir -p ../pkg/usr/X11R6/man/man1
mkdir -p ../pkg/${DOCDIR}/${SWNAME}-${SWVERSION}

cd bin
cp -p * ../../pkg/usr/X11R6/bin/.
cd ..
cp -p lib/libcdl.a ../pkg/usr/X11R6/lib/.
cp -p lib/libobm.a ../pkg/usr/X11R6/lib/.
cp -p app-defaults/* ../pkg/usr/X11R6/lib/X11/app-defaults/.
cp -pR include/Obm* ../pkg/usr/X11R6/include/.
cp -pR include/cdl* ../pkg/usr/X11R6/include/.
cp -p include/widget.h ../pkg/usr/X11R6/include/.
cd man
cp -p * ../../pkg/usr/X11R6/man/man1/.
cd ..
gzip ../pkg/usr/X11R6/man/man1/*.1

cp -p ../PlamoBuild.sh ../*.patch ../pkg/${DOCDIR}/${SWNAME}-${SWVERSION}/.
cp -pR Notes* README* Revisions doc ../pkg/${DOCDIR}/${SWNAME}-${SWVERSION}/.
gzip ../pkg/${DOCDIR}/${SWNAME}-${SWVERSION}/doc/*.ps

cd ../pkg
chown -R root:root usr
makepkg ${SWNAME}-${SWVERSION}-${PLAMOARCH}-${PLAMOVER}.tgz <<EOF
y
EOF
