#!/bin/sh

SWNAME=guile-1.6.4
INFODIR=/usr/share/info
DOCDIR=/usr/share/doc
ARCH=i386
BUILD=P1
PKG=${SWNAME}-${ARCH}-${BUILD}.tgz

rm -rf $SWNAME
tar zxf ${SWNAME}.tar.gz
cd $SWNAME
./configure --prefix=/usr --infodir=$INFODIR
make

P=`pwd`/../pkg
rm -rf $P
mkdir -p ${P}${DOCDIR}/${SWNAME}

make install-strip DESTDIR=$P
cp -p ../`basename $0` A* B* C* G* H* I* N* R* S* T* ${P}${DOCDIR}/${SWNAME}/.
chown -R root:root ${P}${DOCDIR}/${SWNAME}
rm ${P}${INFODIR}/dir
gzip ${P}${INFODIR}/*.info-?
gzip ${P}${INFODIR}/*.info-??

cd $P
/sbin/makepkg $PKG <<EOF
y
y
EOF

mkdir -p install
cat >> install/doinst.sh <<EOF
#%% begin initialize $SWNAME
if [ -x /usr/bin/install-info ] ; then
 /usr/bin/install-info --info-dir=${INFODIR} ${INFODIR}/guile.info
 /usr/bin/install-info --info-dir=${INFODIR} ${INFODIR}/guile-tut.info
 /usr/bin/install-info --info-dir=${INFODIR} ${INFODIR}/goops.info
 /usr/bin/install-info --info-dir=${INFODIR} ${INFODIR}/r5rs.info
elif [ -x /usr/sbin/install-info ] ; then
 /usr/sbin/install-info --info-dir=${INFODIR} ${INFODIR}/guile.info
 /usr/sbin/install-info --info-dir=${INFODIR} ${INFODIR}/guile-tut.info
 /usr/sbin/install-info --info-dir=${INFODIR} ${INFODIR}/goops.info
 /usr/sbin/install-info --info-dir=${INFODIR} ${INFODIR}/r5rs.info
fi
#%% end
EOF
tar zcf $PKG usr install
