if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

cd $ROOT/

if [ ! -f /etc/default/login ]; then
  mkdir -p /etc/default
  cp $ROOT/usr/athena/etc/default.login $ROOT/etc/default/login
  echo "$ROOT/etc/default/login file created."
fi

if ! fgrep "joda Exp" $ROOT/etc/inetd.conf 1> /dev/null 2>&1; then
  cat $ROOT/usr/athena/etc/inetd.conf.changes >> $ROOT/etc/inetd.conf
  echo "extra entries are added in $ROOT/etc/inetd.conf."
fi
if ! fgrep "assar Exp" $ROOT/etc/services 1> /dev/null 2>&1; then
  cat $ROOT/usr/athena/etc/services.append >> $ROOT/etc/services
  echo "extra services are appended in $ROOT/etc/services."
fi

if ! fgrep "/usr/athena/lib" $ROOT/etc/ld.so.conf 1> /dev/null 2>&1; then
  echo "/usr/athena/lib" >> $ROOT/etc/ld.so.conf
else
  echo "Entry /usr/athena/lib is already in $ROOT/etc/ld.so.conf."
fi
if [ "$ROOT" != "" ] ; then
  /sbin/ldconfig
fi

kill -HUP `pidof inetd`

echo "  You have to configure files: "
echo "	  $ROOT/etc/krb.conf"
echo "	  $ROOT/etc/krb.realms"
echo "	  ..."
echo "You can find sample files in $ROOT/usr/athena/etc/ directory."
echo "  You need farther installation work to create Kerberos database"
echo "if you want to make a Kerberos server.  See documents:"
echo "	  # info -d /usr/athena/info/"
echo ""

if [ -d $ROOT/usr/info ]; then
  INF_DIR=$ROOT/usr/info
else
  if [ -d $ROOT/usr/share/info ]; then
    INF_DIR=$ROOT/usr/share/info
  else
    if [ -d $ROOT/usr/local/info ]; then
      INF_DIR=$ROOT/usr/local/info
    fi
  fi
fi
if [ ."$INF_DIR" != ."" ]; then
  if  ! fgrep "Kerberos-IV" $ROOT/$INF_DIR/dir 1> /dev/null 2>&1; then
    cat >> $ROOT/$INF_DIR/dir <<__EOL__

Kerberos-IV from KTH.
=====================
* KTH-KRB: (kth-krb).	The Kerberos IV by KTH (English).
* KTH-KRB-JA: (kth-krb-ja).	The Kerberos IV by KTH (Japanese).
__EOL__
  fi
  cp -p $ROOT/usr/athena/info/kth-krb.info $ROOT/$INF_DIR/
  cp -p $ROOT/usr/athena/info/kth-krb-ja.info $ROOT/$INF_DIR/
  echo "kth-krb.info installed in $ROOT/$INF_DIR/"
fi
( cd usr/athena/lib ; rm -rf libroken.so.16 )
( cd usr/athena/lib ; ln -sf libroken.so.16.0 libroken.so.16 )
( cd usr/athena/lib ; rm -rf libroken.so )
( cd usr/athena/lib ; ln -sf libroken.so.16.0 libroken.so )
( cd usr/athena/lib ; rm -rf libcom_err.so.2 )
( cd usr/athena/lib ; ln -sf libcom_err.so.2.1 libcom_err.so.2 )
( cd usr/athena/lib ; rm -rf libcom_err.so )
( cd usr/athena/lib ; ln -sf libcom_err.so.2.1 libcom_err.so )
( cd usr/athena/lib ; rm -rf libkrb.so.2 )
( cd usr/athena/lib ; ln -sf libkrb.so.2.1 libkrb.so.2 )
( cd usr/athena/lib ; rm -rf libkrb.so )
( cd usr/athena/lib ; ln -sf libkrb.so.2.1 libkrb.so )
( cd usr/athena/lib ; rm -rf libkdb.so.1 )
( cd usr/athena/lib ; ln -sf libkdb.so.1.11 libkdb.so.1 )
( cd usr/athena/lib ; rm -rf libkdb.so )
( cd usr/athena/lib ; ln -sf libkdb.so.1.11 libkdb.so )
( cd usr/athena/lib ; rm -rf libkadm.so.1 )
( cd usr/athena/lib ; ln -sf libkadm.so.1.11 libkadm.so.1 )
( cd usr/athena/lib ; rm -rf libkadm.so )
( cd usr/athena/lib ; ln -sf libkadm.so.1.11 libkadm.so )
( cd usr/athena/lib ; rm -rf libacl.so.1 )
( cd usr/athena/lib ; ln -sf libacl.so.1.0 libacl.so.1 )
( cd usr/athena/lib ; rm -rf libacl.so )
( cd usr/athena/lib ; ln -sf libacl.so.1.0 libacl.so )
( cd usr/athena/lib ; rm -rf libkafs.so.3 )
( cd usr/athena/lib ; ln -sf libkafs.so.3.5 libkafs.so.3 )
( cd usr/athena/lib ; rm -rf libkafs.so )
( cd usr/athena/lib ; ln -sf libkafs.so.3.5 libkafs.so )
( cd usr/athena/lib ; rm -rf libsl.so.1 )
( cd usr/athena/lib ; ln -sf libsl.so.1.2 libsl.so.1 )
( cd usr/athena/lib ; rm -rf libsl.so )
( cd usr/athena/lib ; ln -sf libsl.so.1.2 libsl.so )
( cd usr/athena/lib ; rm -rf libss.so.1 )
( cd usr/athena/lib ; ln -sf libss.so.1.4 libss.so.1 )
( cd usr/athena/lib ; rm -rf libss.so )
( cd usr/athena/lib ; ln -sf libss.so.1.4 libss.so )
( cd usr/athena/lib ; rm -rf libotp.so.1 )
( cd usr/athena/lib ; ln -sf libotp.so.1.3 libotp.so.1 )
( cd usr/athena/lib ; rm -rf libotp.so )
( cd usr/athena/lib ; ln -sf libotp.so.1.3 libotp.so )
