#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>
#include <WSCvlabel.h>
//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------

//the label which indicates the result.
extern WSCvlabel* newvlab_001;

void numbtnep(WSCbase* object){
  //Get the number of button from WSNlabelString
  WSCvariant val = object->getProperty(WSNlabelString);

  //Store the number to the indicator label.
  //Check the last input is the number.
  long numpushed = (long)newvlab_001->getUserData("num-input");

  //Check the dot mode (floating mode).
  long dotpushed = (long)newvlab_001->getUserData("dot-input");

  //Get the last indicated string.
  WSCvariant val2 = newvlab_001->getProperty(WSNlabelString);

  //Cancel the input when the string is too long.
  if (strlen((char*)val2) > 13){
    return;
  }

  //The input is number, add it to indicator.
  if (numpushed == 1){ 
    double value = val2;
    if (value == (double)0){
      WSCstring tmp;
      if (dotpushed == 1){
        tmp << "0." << val;
      }else{
        tmp << val;
      }
      newvlab_001->setProperty(WSNlabelString,(char*)tmp);
    }else{
      WSCstring tmp = val2;
      if (dotpushed == 1){
        if (tmp.isExist(".") == -1){
          tmp << ".";
        }
      }
      tmp << val;
      newvlab_001->setProperty(WSNlabelString,(char*)tmp);
    }
  }else{
    WSCstring tmp;
    if (dotpushed == 1){
      tmp << "0.";
    }
    tmp << val;
    newvlab_001->setProperty(WSNlabelString,tmp);
  }
  //Store that the number button is pushed.
  newvlab_001->setUserData("num-input",(void*)1);

}
static WSCfunctionRegister  op("numbtnep",(void*)numbtnep);
