//
// Copyright (C) 1999-2003 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDKEYBOARD_H
#define WSDKEYBOARD_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSkeysym.h>
#include <WSCstring.h>
class WSDdev;
class WSCballoonHelp;

typedef WSCbool (*WSDkeyProc)(long,WSCbool );
typedef void (*WSDfocusKeyProc)(void*,WSCbool );
typedef void (*WSDloseFocusProc)(void*);

class WSDkeyboard :public WSCroot{

  protected:
    WSCstring _select_str;
    void (*_normal_proc1)(void*,WSDkeyboard*,WSCbool);
    void (*_normal_proc2)(void*);
    WSCbool (*_special_proc)(void*,WSDkeyboard*,WSCbool);
    WSCbool (*_global_proc)(long,WSCbool);
    void* _normal_ptr;
    void* _special_ptr;
    long  _key;
    WSCstring _text;
    unsigned  _with_shift:1;
    unsigned  _with_lock:1;
    unsigned  _with_alt:1;
    unsigned  _with_cntl:1;
    unsigned  _is_cursor:1;
    unsigned  _is_function:1;
    unsigned  _is_tty_function:1;
    unsigned  _enable_fep:1;
    unsigned  _fep_on:1;
    unsigned  _is_pressed:1;

    static WSCballoonHelp*  _status_win;
    static void _mode_win_move(WSCbase*);

    void setVisibleModeWindow(WSCbool fl);
    void setPositionModeWindow(short x,short y);
    void setModeString(char*);

  public:
    WSDkeyboard();

    virtual long initialize();
    virtual void setKey(long);
    virtual void setEnableFep(WSDdev*,WSCbool);

    long    getKey();
    WSCbool isPressed();
    WSCbool withShift();
    WSCbool withLock();
    WSCbool withCntl();
    WSCbool withAlt();
    WSCbool isCursorKey();
    WSCbool isFuncKey();
    WSCbool isTtyFunction();
    WSCbool getFepStatus();
    WSCbool executeHandler(WSCbool press);
    WSCbool getEnableFep();

    void setWithShift(WSCbool fl);
    void setWithLock(WSCbool fl);
    void setWithCntl(WSCbool fl);
    void setWithAlt(WSCbool fl);
    void setIsCursorKey(WSCbool fl);
    void setIsFuncKey(WSCbool fl);
    void setIsTtyFunction(WSCbool fl);
    void setIsPressed(WSCbool fl);

    virtual long startKanji(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    virtual long startAscii(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    virtual long setFepPos(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    virtual long resetFep(WSDdev*);

    WSCstring* getTextString();
    char*  getText(long encode = WS_EN_DEFAULT);
    void   setText(char*,long encode = WS_EN_DEFAULT);    
    static void setCreateInstanceHandler( WSDkeyboard* (*hd)() );

    void setFocusInputWorkProc( void (*)(void*,WSDkeyboard*, WSCbool), void (*)(void*),void* ); 
    void resetFocusInputWorkProc();
    void setSpecialInputWorkProc( WSCbool (*)(void* ptr, WSDkeyboard*,WSCbool ), void* ptr );
    void resetSpecialInputWorkProc();
    void setGlobalKeyHook( WSCbool (*)(long,WSCbool) ); 
    virtual void setSelectedString(char*,long encode = WS_EN_DEFAULT);
    virtual char* getSelectedString(long encode = WS_EN_DEFAULT);

    WSMFclassDef(WSDkeyboard,WSCroot);
};
extern WSDLEX WSDkeyboard* WSGIappKeyboard();
#endif
