//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCFONTSET_H
#define WSCFONTSET_H

#include <WScom.h>
#include <WSDfont.h>
#include <WSClistData.h>

class WSCstring;
#define WS_DEFAULT_FONT_NO 0

class WSCfontSet{

 protected:
    WSClistData _font_list;
    WSDfont*  (*_create_handler)();
    long   (*_setup_handler)(WSDfont*,char*);
    long   (*_default_init_handler)(WSCfontSet*);
    short   _default_font;
   
 public:
   WSCfontSet();
   virtual ~WSCfontSet();

   long     addFont(WSDfont* );
   WSDfont* getFont(short no);
   long     getStringWidth(short no,WSCstring*);
   long     getStringHeight(short no,WSCstring*);
   long     getStringWidth(short no,char*,long en = WS_EN_DEFAULT);
   long     getStringHeight(short no,char*,long en = WS_EN_DEFAULT);
   long     initializeDefault();
   void     setDefaultFont(short no);
   void     setCreateHandler(WSDfont* (*)());
   void     setSetupHandler(long (*)(WSDfont*,char*));
   void     setDefaultInitializeHandler(long (*)(WSCfontSet* ));
   WSDfont* getDefaultFont();
   short    getDefaultFontNo();
};
extern WSDLEX WSCfontSet*  WSGIappFontSet();
#endif
