/*
  Image Compression/Decompression Methods.
*/
#ifndef _MAGICK_COMPRESS_H
#define _MAGICK_COMPRESS_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern MagickExport MagickBooleanType
  HuffmanDecodeImage(Image *),
  HuffmanEncodeImage0(const ImageInfo *,Image *,int),
  HuffmanEncodeImage(const ImageInfo *,Image *),
  Huffman2DEncodeImage0(const ImageInfo *,Image *,int),
  Huffman2DEncodeImage(const ImageInfo *,Image *),
  JPEGEncodeImage0(const ImageInfo *,Image *,int),
  JPEGEncodeImage(const ImageInfo *,Image *),
  LZWEncodeImage0(Image *,const size_t,unsigned char *,int),
  LZWEncodeImage(Image *,const size_t,unsigned char *),
  PackbitsEncodeImage0(Image *,const size_t,unsigned char *,int),
  PackbitsEncodeImage(Image *,const size_t,unsigned char *),
  ZLIBEncodeImage0(Image *,const size_t,const unsigned long,unsigned char *,int),
  ZLIBEncodeImage(Image *,const size_t,const unsigned long,unsigned char *);

extern MagickExport void
  Ascii85Encode(Image *,const unsigned char),
  Ascii85Flush(Image *),
  Ascii85Initialize(Image *);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
