# image2.tcl --
#
# This demonstration script creates a simple collection of widgets
# that allow you to select and view images in a Tk label.
#
# RCS: @(#) $Id: image2.tcl,v 1.1 1999/03/31 15:08:33 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

# loadDir --
# This procedure reloads the directory listbox from the directory
# named in the demo's entry.
#
# Arguments:
# w -			Name of the toplevel window of the demo.

proc loadDir w {
    global dirName

    $w.f.list delete 0 end
    foreach i [lsort [glob [file join $dirName *]]] {
	$w.f.list insert end [file tail $i]
    }
}

# loadImage --
# Given the name of the toplevel window of the demo and the mouse
# position, extracts the directory entry under the mouse and loads
# that file into a photo image for display.
#
# Arguments:
# w -			Name of the toplevel window of the demo.
# x, y-			Mouse position within the listbox.

proc loadImage {w x y} {
    global dirName

    set file [file join $dirName [$w.f.list get @$x,$y]]
    image2a configure -file $file
}

set w .image2
catch {destroy $w}
toplevel $w
wm title $w "Image Demonstration #2"
wm iconname $w "Image2"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"This demonstration allows you to view images using a Tk \"photo\" image.  First type a directory name in the listbox, then type Return to load the directory into the listbox.  Then double-click on a file name in the listbox to see that image." \
"$B$3$N%G%b$G$O(BTk $B$N(Bphoto image $B$r;HMQ$7$F2hA|$r8+$k$3$H$,$G$-$^$9!#:G=i$K%(%s%H%jFb$K%G%#%l%/%H%jL>$rF~$l$F2<$5$$!#<!$K2<$N%j%9%H%\%C%/%9$K$3$N%G%#%l%/%H%j$r%m!<%I$9$k$?$a!"%j%?!<%s$r2!$7$F$/$@$5$$!#$=$N8e!"2hA|$rA*Br$9$k$?$a$K%j%9%H%\%C%/%9$NCf$N%U%!%$%kL>$r%@%V%k%/%j%C%/$7$F2<$5$$!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

label $w.dirLabel -text [langSel "Directory:" "$B%G%#%l%/%H%j(B:"]
set dirName [file join $tk_library demos.jp images]
entry $w.dirName -width 30 -textvariable dirName
bind $w.dirName <Return> "loadDir $w"
frame $w.spacer1 -height 3m -width 20
label $w.fileLabel -text [langSel "File:" "$B%U%!%$%k(B:"]
frame $w.f
pack $w.dirLabel $w.dirName $w.spacer1 $w.fileLabel $w.f -side top -anchor w

listbox $w.f.list -width 20 -height 10 -yscrollcommand "$w.f.scroll set"
scrollbar $w.f.scroll -command "$w.f.list yview"
pack $w.f.list $w.f.scroll -side left -fill y -expand 1
$w.f.list insert 0 earth.gif earthris.gif teapot.ppm
bind $w.f.list <Double-1> "loadImage $w %x %y"

catch {image delete image2a}
image create photo image2a
frame $w.spacer2 -height 3m -width 20
label $w.imageLabel -text [langSel "Image:" "$B2hA|(B:"]
label $w.image -image image2a
pack $w.spacer2 $w.imageLabel $w.image -side top -anchor w
