# check.tcl --
#
# This demonstration script creates a toplevel window containing
# several checkbuttons.
#
# RCS: @(#) $Id: check.tcl,v 1.1 1999/03/31 15:08:26 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .check
catch {destroy $w}
toplevel $w
wm title $w "Checkbutton Demonstration"
wm iconname $w "check"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"Three checkbuttons are displayed below.  If you click on a button, it will toggle the button's selection state and set a Tcl variable to a value indicating the state of the checkbutton.  Click the \"See Variables\" button to see the current values of the variables." \
"$B2<$K$O(B 3 $B$D$N%A%'%C%/%\%?%s$,I=<($5$l$F$$$^$9!#%/%j%C%/$9$k$H%\%?%s$NA*Br>uBV$,JQ$o$j!"(BTcl $BJQ?t$K$=$N%\%?%s$N>uBV$r<($9CM$r@_Dj$7$^$9!#8=:_$NJQ?t$NCM$r8+$k$K$O!VJQ?t;2>H!W%\%?%s$r%/%j%C%/$7$F$/$@$5$$!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
button $w.buttons.vars -text [langSel "See Variables" "$BJQ?t;2>H(B"]  \
	-command "showVars $w.dialog wipers brakes sober"
pack $w.buttons.dismiss $w.buttons.code $w.buttons.vars -side left -expand 1

checkbutton $w.b1 -text [langSel "Wipers OK" "$B%o%$%Q!<(B OK"] -variable wipers -relief flat
checkbutton $w.b2 -text [langSel "Brakes OK" "$B%V%l!<%-(B OK"] -variable brakes -relief flat
checkbutton $w.b3 -text [langSel "Driver Sober" "$B%I%i%$%P!<AGLL(B"] -variable sober -relief flat
pack $w.b1 $w.b2 $w.b3 -side top -pady 2 -anchor w
