# bind.tcl --
#
# This demonstration script creates a text widget with bindings set
# up for hypertext-like effects.
#
# RCS: @(#) $Id: bind.tcl,v 1.1 1999/03/31 15:08:25 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .bind
catch {destroy $w}
toplevel $w
wm title $w "Text Demonstration - Tag Bindings"
wm iconname $w "bind"
positionWindow $w

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

text $w.text -yscrollcommand "$w.scroll set" -setgrid true \
	-width 60 -height 24 -font $font -wrap word
scrollbar $w.scroll -command "$w.text yview"
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both

# Set up display styles.

if {[winfo depth $w] > 1} {
    set bold "-background #43ce80 -relief raised -borderwidth 1"
    set normal "-background {} -relief flat"
} else {
    set bold "-foreground white -background black"
    set normal "-foreground {} -background {}"
}

# Add text to widget.

$w.text insert 0.0 [langSel {\
The same tag mechanism that controls display styles in text widgets can also be used to associate Tcl commands with regions of text, so that mouse or keyboard actions on the text cause particular Tcl commands to be invoked.  For example, in the text below the descriptions of the canvas demonstrations have been tagged.  When you move the mouse over a demo description the description lights up, and when you press button 1 over a description then that particular demonstration is invoked.

} {\
$B%F%-%9%H(Bwidget$B$NI=<(%9%?%$%k$r@)8f$9$k$N$HF1$8%?%0$N%a%+%K%:%`$r;H$C$F!"%F%-%9%H$K(BTcl$B$N%3%^%s%I$r3d$jEv$F$k$3$H$,$G$-$^$9!#$3$l$K$h$j!"%^%&%9$d%-!<%\!<%I$N%"%/%7%g%s$GFCDj$N(BTcl$B$N%3%^%s%I$,<B9T$5$l$k$h$&$K$J$j$^$9!#Nc$($P!"2<$N%-%c%s%P%9$N%G%b%W%m%0%i%`$K$D$$$F$N@bL@J8$K$O$=$N$h$&$J%?%0$,$D$$$F$$$^$9!#%^%&%9$r@bL@J8$N>e$K;}$C$F$$$/$H@bL@J8$,8w$j!"%\%?%s(B1$B$r2!$9$H$=$N@bL@$N%G%b$,;O$^$j$^$9!#(B

}]
$w.text insert end \
[langSel {1. Samples of all the different types of items that can be created in canvas widgets.} \
{1. $B%-%c%s%P%9(B widget $B$K:n$k$3$H$N$G$-$k%"%$%F%`$N<oN`A4$F$K4X$9$k%5%s%W%k!#(B}] d1
$w.text insert end \n\n
$w.text insert end \
[langSel {2. A simple two-dimensional plot that allows you to adjust the positions of the data points.} \
{2. $B4JC1$J(B 2$B<!85$N%W%m%C%H!#%G!<%?$rI=$9E@$rF0$+$9$3$H$,$G$-$k!#(B}] d2
$w.text insert end \n\n
$w.text insert end \
[langSel {3. Anchoring and justification modes for text items.} \
{3. $B%F%-%9%H%"%$%F%`$N%"%s%+!<$H9TB7$(!#(B}] d3
$w.text insert end \n\n
$w.text insert end \
[langSel {4. An editor for arrow-head shapes for line items.} \
{4. $B%i%$%s%"%$%F%`$N$?$a$NLp0u$NF,$N7A$N%(%G%#%?!#(B}] d4
$w.text insert end \n\n
$w.text insert end \
[langSel {5. A ruler with facilities for editing tab stops.} \
{5. $B%?%V%9%H%C%W$rJQ99$9$k$?$a$N5!G=$D$-$N%k!<%i!<!#(B}] d5
$w.text insert end \n\n
$w.text insert end \
[langSel {6. A grid that demonstrates how canvases can be scrolled.} \
{6. $B%-%c%s%P%9$,$I$&$d$C$F%9%/%m!<%k$9$k$N$+$r<($9%0%j%C%I!#(B}] d6

# Create bindings for tags.

foreach tag {d1 d2 d3 d4 d5 d6} {
    $w.text tag bind $tag <Any-Enter> "$w.text tag configure $tag $bold"
    $w.text tag bind $tag <Any-Leave> "$w.text tag configure $tag $normal"
}
$w.text tag bind d1 <1> {source [file join $tk_library demos.jp items.tcl]}
$w.text tag bind d2 <1> {source [file join $tk_library demos.jp plot.tcl]}
$w.text tag bind d3 <1> {source [file join $tk_library demos.jp ctext.tcl]}
$w.text tag bind d4 <1> {source [file join $tk_library demos.jp arrow.tcl]}
$w.text tag bind d5 <1> {source [file join $tk_library demos.jp ruler.tcl]}
$w.text tag bind d6 <1> {source [file join $tk_library demos.jp cscroll.tcl]}

$w.text mark set insert 0.0
$w.text configure -state disabled
