/* This file fixes __FD_ZERO bug for glibc-1.x. */
#ifndef _POSIX_TYPES_H_WRAPPER
#include <features.h>
#include_next <asm/posix_types.h>

#if defined(__FD_ZERO) && !defined(__GLIBC__)
#undef __FD_ZERO
#define __FD_ZERO(fdsetp) \
  do { \
    int __d0, __d1; \
		__asm__ __volatile__("cld ; rep ; stosl" \
			: "=&c" (__d0), "=&D" (__d1) \
			: "a" (0), "0" (__FDSET_LONGS), \
			  "1" ((__kernel_fd_set *) (fdsetp)) :"memory"); \
  } while (0)
#endif

#define _POSIX_TYPES_H_WRAPPER
#endif /* _POSIX_TYPES_H_WRAPPER */
