/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Encoder - Lower Sampling Frequency Extension
 *
 * $Id: l3psy.c,v 1.2 1998/10/05 17:06:48 larsi Exp $
 *
 * $Log: l3psy.c,v $
 * Revision 1.2  1998/10/05 17:06:48  larsi
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1998/10/05 14:47:18  larsi
 *
 * Revision 1.2  1997/01/19 22:28:29  rowlands
 * Layer 3 bug fixes from Seymour Shlien
 *
 * Revision 1.1  1996/02/14 04:04:23  rowlands
 * Initial revision
 *
 * Received from Mike Coleman
 **********************************************************************/
/**********************************************************************
 *   date   programmers         comment                               *
 * 2/25/91  Davis Pan           start of version 1.0 records          *
 * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         *
 * 7/10/91  Earle Jennings      Ported to MsDos.                      *
 *                              replace of floats with FLOAT          *
 * 2/11/92  W. Joseph Carter    Fixed mem_alloc() arg for "absthr".   *
 * 3/16/92  Masahiro Iwadare	Modification for Layer III            *
 * 17/4/93  Masahiro Iwadare    Updated for IS Modification           *
 **********************************************************************/

#include "util.h"
#include "globalflags.h"
#include "encoder.h"
#include "psymodel.h"
#include "l3side.h"
#include <assert.h>
#include "gtkanal.h"
#include "tables.h"
#include "fft.h"

#ifdef M_LN10
#define		LN_TO_LOG10		(M_LN10/10)
#else
#define         LN_TO_LOG10             0.2302585093
#endif

#define maximum(x,y) ( (x>y) ? x : y )
#define minimum(x,y) ( (x<y) ? x : y )

/* some different types of adaptive window switching */


/* This mode will turn on short_blocks if there is a localized surge in energy */
#define ENER_AWS  

static int switch_pe=1800;

static double s3_l[CBANDS][CBANDS]; /* needed global static by sprdngfs */

void L3para_read( double sfreq, int numlines[CBANDS],int numlines_s[CBANDS], int partition_l[HBLKSIZE],
		  double minval[CBANDS], double qthr_l[CBANDS], double norm_l[CBANDS],
		  double s3_l[CBANDS][CBANDS],  double s3_s[CBANDS][CBANDS], 
                  int partition_s[HBLKSIZE_s], double qthr_s[CBANDS],
		  double norm_s[CBANDS], double SNR_s[CBANDS],
		  int cbw_l[SBMAX_l], int bu_l[SBMAX_l], int bo_l[SBMAX_l],
		  double w1_l[SBMAX_l], double w2_l[SBMAX_l],
		  int cbw_s[SBMAX_s], int bu_s[SBMAX_s], int bo_s[SBMAX_s],
		  double w1_s[SBMAX_s], double w2_s[SBMAX_s] );
									








void L3psycho_energy( short int *buffer, 
    FLOAT energy[HBLKSIZE],
    FLOAT ax[HBLKSIZE], FLOAT bx[HBLKSIZE],
    FLOAT energy_s[3][HBLKSIZE_s],
    FLOAT ax_s[3][HBLKSIZE_s], FLOAT bx_s[3][HBLKSIZE_s],
     int chn,int gr_out , layer * info)
{
  static short int savebuffer[2][WINDELAY+576];
  static int sync_flush,flush,syncsize;
  static FLOAT scalefac;
  static FLOAT window_s[BLKSIZE_s];
  static FLOAT window[BLKSIZE];
  static int firstcall=1;

#ifdef HAVEGTK
  static FLOAT energy_save[4][HBLKSIZE];
#endif

  int i,j,k,sblock;
  
  FLOAT wsamp_r[BLKSIZE];
  FLOAT wsamp_rs[256];
  
  if(firstcall) {
    firstcall=0;
    memset((char *) savebuffer, 0, sizeof(savebuffer));    
    sync_flush=WINDELAY; flush=576; syncsize=WINDELAY+576;
    
    scalefac=1.0;
    if (force_ms) scalefac=SQRT2;
    
    /* calculate HANN window coefficients */
    /* note: ISO DOCS use i-.5 because their i starts at 1, not 0 */
    for(i=0;i<BLKSIZE;i++)  window[i]  =0.5*(1-cos(2.0*PI*(i+0.5)/BLKSIZE));
    for(i=0;i<BLKSIZE_s;i++)window_s[i]=0.5*(1-cos(2.0*PI*(i+0.5)/BLKSIZE_s));

  }

  /**********************************************************************
   *  compute FFTs
   **********************************************************************/
  if (chn<2) { /* the most common option */
    for ( j = 0; j < sync_flush; j++ ) /* for long window samples */
      savebuffer[chn][j] = savebuffer[chn][j+flush];
    for ( j = sync_flush; j < syncsize; j++ )
      savebuffer[chn][j] = buffer[j-sync_flush];

    for ( j = 0; j < BLKSIZE; j++ ) 
      wsamp_r[j] = window[j] * savebuffer[chn][j] * scalefac;

  } else
    if (chn==2) {
      for ( j = 0; j < BLKSIZE; j++ )
        wsamp_r[j] = window[j] * (savebuffer[0][j] + savebuffer[1][j] )/SQRT2;
    } else /* if (chn==3)   */
      {
        for ( j = 0; j < BLKSIZE; j++ )
          wsamp_r[j] = window[j] * (savebuffer[0][j] - savebuffer[1][j] )/SQRT2;
      }

  fft( wsamp_r, energy, ax, bx, 1024 );
  /* mt 7/99
    Note: fft_side() can be used to compute energy, ax & bx for the
    mid and side channels (chn=2,3) without calling additional FFTs. 
    But it requires wsamp_r to be saved from channels 0 and 1.  
    My tests show that the FFT is so fast that this gives no savings.
    Probably the extra memory hurts the cache performance.
  */

  
#ifdef HAVEGTK
  if(gtkflag) {
    for (j=0; j<HBLKSIZE ; j++) {
      pinfo->energy[gr_out][chn][j]=energy_save[chn][j];
      energy_save[chn][j]=energy[j];
    }
  }
#endif
  for ( sblock = 0; sblock < 3; sblock++ ) {
    int shlen = 192;
    int shoff = 1;
    if (chn<2) 
      for ( j = 0, k = shlen * (shoff + sblock); j < 256; j++, k++ ) 
        wsamp_rs[j] = window_s[j]* savebuffer[chn][k]*scalefac;
    if (chn==2) 
      for ( j = 0, k = shlen * (shoff + sblock); j < 256; j++, k++ ) 
        wsamp_rs[j] = window_s[j] *
((savebuffer[0][k]+savebuffer[1][k])/2)*SQRT2;
    if (chn==3) 
      for ( j = 0, k = shlen * (shoff + sblock); j < 256; j++, k++ ) 
        wsamp_rs[j] = window_s[j] *
((savebuffer[0][k]-savebuffer[1][k])/2)*SQRT2;

    fft( wsamp_rs, energy_s[sblock], ax_s[sblock], bx_s[sblock], 256 );
  }


}




 



 

void L3psycho_anal( short int *buffer[2], int stereo,
		    int gr_out , layer * info,
		    double sfreq, 
		    int check_ms_stereo, double *ms_ener_ratio,
		    double ratio_d[4][21], double ratio_ds[4][12][3],
		    double percep_energy[4], int blocktype_d[2])
{
  static double pe[4]={0,0,0,0};
  static double ms_ratio_s_old=0,ms_ratio_l_old=0;

  static double ratio[4][SBMAX_l];
  static double ratio_s[4][SBMAX_s][3];
#ifdef HAVEGTK
  static double pe_save[4];
  static double ers_save[4];
#endif
  static double thm_save[4][SBMAX_l];
  static double en_save[4][SBMAX_l];
  static double thm_s_save[4][SBMAX_s][3];
  static double en_s_save[4][SBMAX_s][3];


  int blocktype[2],uselongblock[2],chn;
  int numchn;
  unsigned int   b, i, j, k;
  double ms_ratio_l=0,ms_ratio_s=0;
  double estot[4][3];


  double   thr[CBANDS];
  FLOAT ax[HBLKSIZE], bx[HBLKSIZE];
  FLOAT energy[HBLKSIZE];
  FLOAT energy_s[3][HBLKSIZE_s];
  FLOAT ax_s[3][HBLKSIZE_s], bx_s[3][HBLKSIZE_s]; /* 256 samples not 129. */

  static float mld_l[SBMAX_l],mld_s[SBMAX_s];
  

  

/* The static variables "r", "phi_sav", "new", "old" and "oldest" have    */
/* to be remembered for the unpredictability measure.  For "r" and        */
/* "phi_sav", the first index from the left is the channel select and     */
/* the second index is the "age" of the data.                             */
 static int     sfreq_idx;
 static double 	cw[HBLKSIZE], eb[CBANDS];
 static double 	ctb[CBANDS];
 static double	SNR_l[CBANDS], SNR_s[CBANDS];
 static double	minval[CBANDS],qthr_l[CBANDS],norm_l[CBANDS];
 static double	qthr_s[CBANDS],norm_s[CBANDS];
 static double	nb_1[4][CBANDS], nb_2[4][CBANDS];
 static double  s3_s[CBANDS][CBANDS];

/* Scale Factor Bands */
 static int	cbw_l[SBMAX_l],bu_l[SBMAX_l],bo_l[SBMAX_l] ;
 static int	cbw_s[SBMAX_s],bu_s[SBMAX_s],bo_s[SBMAX_s] ;
 static double	w1_l[SBMAX_l], w2_l[SBMAX_l];
 static double	w1_s[SBMAX_s], w2_s[SBMAX_s];
 static double	en[SBMAX_l],   thm[SBMAX_l] ;
 static int	blocktype_old[2] ;
 int	sb,sblock;
 static int	partition_l[HBLKSIZE],partition_s[HBLKSIZE_s];
 static int numCBANDS,numCBANDS_s;
 static int num_part,num_part_s;

 static int      s3ind[CBANDS][2];
 static int      s3ind_s[CBANDS][2];


 static FLOAT   nb[CBANDS], cb[CBANDS], ecb[CBANDS];
 static	int	numlines_s[CBANDS] ;
 static	int	numlines_l[CBANDS];
 static FLOAT   ax_sav[4][2][HBLKSIZE], bx_sav[4][2][HBLKSIZE],rx_sav[4][2][HBLKSIZE];

 if((frameNum==0) && (gr_out==0)){

     i = sfreq + 0.5;
     switch(i){
        case 32000: sfreq_idx = 0; break;
        case 44100: sfreq_idx = 1; break;
        case 48000: sfreq_idx = 2; break;
        case 16000: sfreq_idx = 3; break;
        case 22050: sfreq_idx = 4; break;
        case 24000: sfreq_idx = 5; break;
        default:    fprintf(stderr,"error, invalid sampling frequency: %d Hz\n",i);
	  exit(-1);
     }

/* reset states used in unpredictability measure */
	memset (rx_sav,0, sizeof(rx_sav));
	memset (ax_sav,0, sizeof(ax_sav));
	memset (bx_sav,0, sizeof(bx_sav));
 


    /* setup stereo demasking thresholds */
    /* formula reverse enginerred from plot in paper */
    for ( sb = 0; sb < SBMAX_s; sb++ ) {
      double mld = 1.25*(1-cos(3.14159*sb/SBMAX_s))-2.5;
      mld_s[sb] = pow(10.0,mld);
    }
    for ( sb = 0; sb < SBMAX_l; sb++ ) {
      double mld = 1.25*(1-cos(3.14159*sb/SBMAX_l))-2.5;
      mld_l[sb] = pow(10.0,mld);
    }

    for (i=0;i<HBLKSIZE;i++) partition_l[i]=-1;
    for (i=0;i<HBLKSIZE_s;i++) partition_s[i]=-1;


     L3para_read( sfreq,numlines_l,numlines_s,partition_l,minval,qthr_l,norm_l,s3_l,s3_s,
		  partition_s,qthr_s,norm_s,SNR_s,
		  cbw_l,bu_l,bo_l,w1_l,w2_l, cbw_s,bu_s,bo_s,w1_s,w2_s );


     /* num_part   = number of partition bands before convolution */
     /* numCBANDS  = number of partition bands after convolution */
     num_part=0; num_part_s=0;
     for (i=0;i<HBLKSIZE;i++) 
       if (partition_l[i]>num_part) num_part=partition_l[i];
     for (i=0;i<HBLKSIZE_s;i++) 
       if (partition_s[i]>num_part_s) num_part_s=partition_s[i];
     num_part++;
     num_part_s++;

     numCBANDS=bo_l[SBMAX_l-1]+1;
     numCBANDS_s=bo_s[SBMAX_s-1]+1;

     for (i=0; i<num_part; i++) {
       for (j = 0; j < num_part; j++) {
	 if (s3_l[i][j] != 0.0)
	   break;
       }
       s3ind[i][0] = j;
       
       for (j = num_part; j > 0; j--) {
	 if (s3_l[i][j] != 0.0)
	   break;
       }
       s3ind[i][1] = j;
     }


     for (i=0; i<num_part_s; i++) {
       for (j = 0; j < num_part_s; j++) {
	 if (s3_s[i][j] != 0.0)
	   break;
       }
       s3ind_s[i][0] = j;
       
       for (j = num_part_s; j > 0; j--) {
	 if (s3_s[i][j] != 0.0)
	   break;
       }
       s3ind_s[i][1] = j;
     }
     
#define NEWS3XX
#ifdef NEWS3     
     // compute norm_l, norm_s instead of relying on table data 
     for ( b = 0;b < numCBANDS; b++ ) {
       double norm=0;
       for ( k = s3ind[b][0]; k <= s3ind[b][1]; k++ ) {
	 norm += s3_l[b][k];
       }
       norm_l[b] = 1/norm;
       //printf("%i  norm=%f  norm_l=%f \n",b,1/norm,norm_l[b]);
     }
     for ( b = 0;b < numCBANDS_s; b++ ) {
       double norm=0;
       for ( k = s3ind_s[b][0]; k <= s3ind_s[b][1]; k++ ) {
	 norm += s3_s[b][k];
       }
       norm_s[b] = 1/norm;
       //printf("%i  norm=%f  norm_s=%f \n",b,1/norm,norm_l[b]);
     }
#endif

     /* MPEG1 SNR_s data is given in db, convert to energy */
     if (info->version == MPEG_AUDIO_ID) {
       for ( b = 0;b < numCBANDS_s; b++ ) {
	 SNR_s[b]=exp( (double) SNR_s[b] * LN_TO_LOG10 );
       }
     }
 }
/************************* End of Initialization *****************************/





 numchn=stereo;
 if (highq && (info->mode == MPG_MD_JOINT_STEREO)) numchn=4;
 for (chn=0; chn<numchn; chn++) {
 
 for ( j = 0; j < 21; j++ )
   ratio_d[chn][j] = ratio[chn][j];
 for ( j = 0; j < 12; j++ )
   for ( i = 0; i < 3; i++ )
     ratio_ds[chn][j][i] = ratio_s[chn][j][i];
 percep_energy[chn] = pe[chn]; 
 
/**********************************************************************
*  compute FFTs
**********************************************************************/
 L3psycho_energy( buffer[chn%2], energy, ax, bx, energy_s, ax_s, bx_s,
		  chn,gr_out,info);


/**********************************************************************
*    compute unpredicatability of first six spectral lines            * 
**********************************************************************/
 for ( j = 0; j < 6; j++ )
   {	 /* calculate unpredictability measure cw */
     double an, a1, a2;
     double bn, b1, b2;
     double rn, r1, r2;
     double numre, numim, den;

     a2 = ax_sav[chn][1][j];
     b2 = bx_sav[chn][1][j];
     r2 = rx_sav[chn][1][j];
     a1 = ax_sav[chn][1][j] = ax_sav[chn][0][j];
     b1 = bx_sav[chn][1][j] = bx_sav[chn][0][j];
     r1 = rx_sav[chn][1][j] = rx_sav[chn][0][j];
     an = ax_sav[chn][0][j] = ax[j];
     bn = bx_sav[chn][0][j] = bx[j];
     rn = rx_sav[chn][0][j] = sqrt(energy[j]);

     { /* square (x1,y1) */
       if( r1 != 0.0 ) {
	 numre = (a1*b1);
	 numim = (a1*a1-b1*b1)*0.5;
	 den = r1*r1;
       } else {
	 numre = 1.0;
	 numim = 0.0;
	 den = 1.0;
       }
     }

     { /* multiply by (x2,-y2) */
       if( r2 != 0.0 ) {
	 double tmp2 = (numim+numre)*(a2+b2)*0.5;
	 double tmp1 = -a2*numre+tmp2;
	 numre =       -b2*numim+tmp2;
	 numim = tmp1;
	 den *= r2;
       } else {
	 /* do nothing */
       }
     }

     { /* r-prime factor */
       double tmp = (2.0*r1-r2)/den;
       numre *= tmp;
       numim *= tmp;
     }

     if( (den=rn+fabs(2.0*r1-r2)) != 0.0 ) {
       numre = (an+bn)/2.0-numre;
       numim = (an-bn)/2.0-numim;
       cw[j] = sqrt(numre*numre+numim*numim)/den;
     } else {
       cw[j] = 0.0;
     }

   }
                                                                                  
/**********************************************************************
*     compute unpredicatibility of next 200 spectral lines            *
**********************************************************************/ 
 for ( j = 6; j < 206; j += 4 )
   {/* calculate unpredictability measure cw */
     double rn, r1, r2;
     double numre, numim, den;

     k = (j+2) / 4; 

     { /* square (x1,y1) */
       r1 = sqrt((double)energy_s[0][k]);
       if( r1 != 0.0 ) {
	 double a1 = ax_s[0][k];
	 double b1 = bx_s[0][k];
	 numre = (a1*b1);
	 numim = (a1*a1-b1*b1)*0.5;
	 den = r1*r1;
       } else {
	 numre = 1.0;
	 numim = 0.0;
	 den = 1.0;
       }
     }


     { /* multiply by (x2,-y2) */
       r2 = sqrt((double)energy_s[2][k]);
       if( r2 != 0.0 ) {
	 double a2 = ax_s[2][k];
	 double b2 = bx_s[2][k];

	 double tmp2 = (numim+numre)*(a2+b2)*0.5;
	 double tmp1 = -a2*numre+tmp2;
	 numre =       -b2*numim+tmp2;
	 numim = tmp1;

	 den *= r2;
       } else {
	 /* do nothing */
       }
     }

     { /* r-prime factor */
       double tmp = (2.0*r1-r2)/den;
       numre *= tmp;
       numim *= tmp;
     }

     rn = sqrt((double)energy_s[1][k]);
     if( (den=rn+fabs(2.0*r1-r2)) != 0.0 ) {
       double an = ax_s[1][k];
       double bn = bx_s[1][k];
       numre = (an+bn)/2.0-numre;
       numim = (an-bn)/2.0-numim;
       cw[j] = sqrt(numre*numre+numim*numim)/den;
     } else {
       cw[j] = 0.0;
     }

     cw[j+1] = cw[j+2] = cw[j+3] = cw[j];
   }

 



/**********************************************************************
*    Set unpredicatiblility of remaining spectral lines to 0.4  206..513 *
**********************************************************************/
 for ( j = 206; j < HBLKSIZE; j++ )
   cw[j] = 0.4;
	


#if 0
 for ( j = 14; j < HBLKSIZE-4; j += 4 )
   {/* calculate energy from short ffts */
     double tot,ave;
     k = (j+2) / 4; 
     for (tot=0, sblock=0; sblock < 3; sblock++)
       tot+=energy_s[sblock][k];
     ave = energy[j+1]+ energy[j+2]+ energy[j+3]+ energy[j];
     ave /= 4.;
     /*
       printf("energy / tot %i %5.2f   %e  %e\n",j,ave/(tot*16./3.),
       ave,tot*16./3.);
     */
     energy[j+1] = energy[j+2] = energy[j+3] =  energy[j]=tot;
   }
#endif
 







/**********************************************************************
*    Calculate the energy and the unpredictability in the threshold   *
*    calculation partitions                                           *
**********************************************************************/
 for ( b = 0; b < CBANDS; b++ )
   {
     eb[b] = 0.0;
     cb[b] = 0.0;
   }
 for ( j = 0; j < HBLKSIZE; j++ )
   {
     int tp = partition_l[j];
     if ( tp >= 0 )
       {
	 eb[tp] += energy[j];
	 cb[tp] += cw[j] * energy[j];
       }
   }


/**********************************************************************
*      convolve the partitioned energy and unpredictability           *
*      with the spreading function, s3_l[b][k]                        *
******************************************************************** */
 for ( b = 0; b < CBANDS; b++ )
   {
     ecb[b] = 0.0;
     ctb[b] = 0.0;
   }
   for ( b = 0;b < numCBANDS; b++ )
       for ( k = s3ind[b][0]; k <= s3ind[b][1]; k++ )
	 {
	   ecb[b] += s3_l[b][k] * eb[k];	/* sprdngf for Layer III */
	   ctb[b] += s3_l[b][k] * cb[k];
	 }


 /* calculate the tonality of each threshold calculation partition */
 /* calculate the SNR in each threshhold calculation partition */

 for ( b = 0; b < numCBANDS; b++ )
   {
     double cbb,tbb;
     if (ecb[b] != 0.0 )
       {
	 cbb = ctb[b]/ecb[b];
	 if (cbb <0.01) cbb = 0.01;
	 cbb = log( cbb);
       }
     else
       cbb = 0.0 ;
     tbb = -0.299 - 0.43*cbb;  /* conv1=-0.299, conv2=-0.43 */
     tbb = minimum( 1.0, maximum( 0.0, tbb) ) ;  /* 0<tbb<1 */
     SNR_l[b] = maximum( minval[b], 29.0*tbb+6.0*(1.0-tbb) );


   }	/* TMN=29.0,NMT=6.0 for all calculation partitions */
 
 for ( b = 0; b < numCBANDS; b++ ) /* calculate the threshold for each partition */
   nb[b] = ecb[b] * norm_l[b] * exp( -SNR_l[b] * LN_TO_LOG10 );


 
 for ( b = 0; b < numCBANDS; b++ )
   { /* pre-echo control */
     double temp_1; /* BUG of IS */
     int rpelev=2; int rpelev2=16; 
     temp_1 = minimum( nb[b], minimum(rpelev*nb_1[chn][b],rpelev2*nb_2[chn][b]) );
     thr[b] = maximum( qthr_l[b], temp_1 );/* rpelev=2.0, rpelev2=16.0 */
     nb_2[chn][b] = nb_1[chn][b];
     nb_1[chn][b] = nb[b];
   }

 /* note: all surges in PE are because of the above pre-echo formula
  * for temp_1.  it this is not used, PE is always around 600
  */

 pe[chn] = 0.0;		/*  calculate percetual entropy */
 for ( b = 0; b < numCBANDS; b++ )
   {
     double tp = log((thr[b]+1.0) / (eb[b]+1.0) );
     tp = minimum( 0.0, tp ) ;  /*not log*/
     pe[chn] -= numlines_l[b] * tp ;


   }	/* thr[b] -> thr[b]+1.0 : for non sound portition */



 /*************************************************************** 
  * Check to see if we also need to compute long block thresholds
  ***************************************************************/
 if (voice_mode){
   uselongblock[chn]=1;
 } else {
   double mn,mx;
   uselongblock[chn] = (pe[chn] < switch_pe);

   for (sblock=0; sblock < 3; sblock++)
       estot[chn][sblock]=0;
   for ( j = HBLKSIZE_s/2; j < HBLKSIZE_s; j ++)
     for (sblock=0; sblock < 3; sblock++)
       estot[chn][sblock]+=energy_s[sblock][j];
   mn = minimum(estot[chn][0],estot[chn][1]);
   mn = minimum(mn,estot[chn][2]);
   mx = maximum(estot[chn][0],estot[chn][1]);
   mx = maximum(mx,estot[chn][2]);
#ifdef HAVEGTK
   if (gtkflag) {
     pinfo->ers[gr_out][chn]=ers_save[chn];
     ers_save[chn]=mx/(1e-12+mn);
     pinfo->pe[gr_out][chn]=pe_save[chn];
     pe_save[chn]=pe[chn];
   }
#endif
#ifdef ENER_AWS
   if (chn<2)  {
     uselongblock[chn] = 1;
     
     /* tuned for t1.wav.  doesnt effect most other samples */
     if (pe[chn] > 3000) uselongblock[chn]=0; 
     
     /* big surge of energy - always use short blocks */
     if (  mx > 30*mn) uselongblock[chn] = 0;
     
     /* medium surge, medium pe - use short blocks */
     if ((mx > 10*mn) && (pe[chn] > 1000))  uselongblock[chn] = 0; 
#endif
   }
 }
 
 
 
 /*************************************************************** 
  * compute masking thresholds for both short and long blocks
  ***************************************************************/
 /* threshold calculation (part 2) */
 for ( sb = 0; sb < SBMAX_l; sb++ )
   {
     en[sb] = w1_l[sb] * eb[bu_l[sb]] + w2_l[sb] * eb[bo_l[sb]];
     thm[sb] = w1_l[sb] *thr[bu_l[sb]] + w2_l[sb] * thr[bo_l[sb]];
     for ( b = bu_l[sb]+1; b < bo_l[sb]; b++ )
       {
	 en[sb]  += eb[b];
	 thm[sb] += thr[b];
       }
     if ( en[sb] != 0.0 )
       ratio[chn][sb] = thm[sb]/en[sb];
     else
       ratio[chn][sb] = 0.0;
   }
#ifdef HAVEGTK
 if (gtkflag) {
   for (sb=0; sb< SBMAX_l; sb ++ ) {
     pinfo->thr[gr_out][chn][sb]=thm_save[chn][sb];
     pinfo->en[gr_out][chn][sb]=en_save[chn][sb];
     thm_save[chn][sb]=thm[sb];
     en_save[chn][sb]=en[sb];
   }
 }
#endif
 for (sb=0; sb< SBMAX_l; sb ++ ) {
   thm_save[chn][sb]=thm[sb];
   en_save[chn][sb]=en[sb];
 }
 
 /* threshold calculation for short blocks */
 for ( sblock = 0; sblock < 3; sblock++ )    {
   for ( b = 0; b < CBANDS; b++ )
     {
       eb[b] = 0.0;
       ecb[b] = 0.0;
     }
   for ( j = 0; j < HBLKSIZE_s; j++ ) {
     if (partition_s[j]>=0) eb[partition_s[j]] += energy_s[sblock][j];
   }
   for ( b = 0; b < numCBANDS_s; b++ )
     for ( k = s3ind_s[b][0]; k <= s3ind_s[b][1]; k++ ) 
          ecb[b] += s3_s[b][k] * eb[k];


   for ( b = 0; b < numCBANDS_s; b++ )
     {
       //       nb[b] = ecb[b] * norm_s[b] * exp( (double) SNR_s[b] * LN_TO_LOG10 );
       nb[b] = ecb[b] * norm_s[b] * SNR_s[b];
       thr[b] = maximum (qthr_s[b],nb[b]);
     }

   for ( sb = 0; sb < SBMAX_s; sb++ )
     {
       en[sb] = w1_s[sb] * eb[bu_s[sb]] + w2_s[sb] * eb[bo_s[sb]];
       thm[sb] = w1_s[sb] *thr[bu_s[sb]] + w2_s[sb] * thr[bo_s[sb]];
       for ( b = bu_s[sb]+1; b < bo_s[sb]; b++ )
	 {
	   en[sb] += eb[b];
	   thm[sb] += thr[b];
	 }
       if ( en[sb] != 0.0 ) 
	 ratio_s[chn][sb][sblock] = thm[sb]/en[sb];
       else
	 ratio_s[chn][sb][sblock] = 0.0;
#ifdef HAVEGTK
       if (gtkflag) {
	 pinfo->thr_s[gr_out][chn][3*sb+sblock]=thm_s_save[chn][sb][sblock];
	 pinfo->en_s[gr_out][chn][3*sb+sblock]=en_s_save[chn][sb][sblock];
       }
#endif
       thm_s_save[chn][sb][sblock]=thm[sb];
       en_s_save[chn][sb][sblock]=en[sb];


     }
   
 } 

 
 /* compute M/S thresholds from Johnston & Ferreira 1992 ICASSP paper */
#define JOHNSTON
#ifdef JOHNSTON
 if ((force_ms && (chn==1)) || (chn==3)) {
   double rside,rmid,mld;
   int ch0,ch1; 
   ch0=chn-1;
   ch1=chn;
   
   for ( sb = 0; sb < SBMAX_l; sb++ ) {
     /* use this fix if L & R masking differs by 2db or less */
     /* if db = 10*log10(x2/x1) < 2 */
     /* if (x2 < 1.58*x1) { */
     if ((chn==1) || (ratio[0][sb] <= 1.58*ratio[1][sb]) ) {
       mld = mld_l[sb];
       rmid = Max(ratio[ch0][sb],Min(ratio[ch1][sb],mld));
       rside = Max(ratio[ch1][sb],Min(ratio[ch0][sb],mld));
       ratio[ch0][sb]=rmid;
       ratio[ch1][sb]=rside;
     }
   }
   for ( sblock = 0; sblock < 3; sblock++ ){
     for ( sb = 0; sb < SBMAX_s; sb++ ) {
       if ((chn==1) || (ratio_s[0][sb][sblock] <= 1.58*ratio_s[1][sb][sblock]) ) {
	 mld = mld_s[sb];
	 rmid = Max(ratio_s[ch0][sb][sblock],Min(ratio_s[ch1][sb][sblock],mld));
	 rside = Max(ratio_s[ch1][sb][sblock],Min(ratio_s[ch0][sb][sblock],mld));
	 ratio_s[ch0][sb][sblock]=rmid;
	 ratio_s[ch1][sb][sblock]=rside;
       }
     }
   }
 }
#endif
 } /* end loop over chn */



 if (check_ms_stereo)  {
 /* determin ms_ratio from masking thresholds*/
 /* use ms_stereo (ms_ratio < .35) if average thresh. diff < 5 db */
 { double db,x1,x2,sidetot=0,tot=0;
 for (sb= SBMAX_l/4 ; sb< SBMAX_l; sb ++ ) {
   x1 = minimum(thm_save[0][sb],thm_save[1][sb]);
   x2 = maximum(thm_save[0][sb],thm_save[1][sb]);
   /* thresholds difference in db */
   if (x2 >= 1000*x1)  db=30;
   else db = 10*log10(x2/x1);  
   sidetot += db;
   tot++;
 }
 ms_ratio_l= .35*(sidetot/tot)/5.0;
 
 sidetot=0; tot=0;
 for ( sblock = 0; sblock < 3; sblock++ )
   for ( sb = SBMAX_s/4; sb < SBMAX_s; sb++ ) {
     x1 = minimum(thm_s_save[0][sb][sblock],thm_s_save[1][sb][sblock]);
     x2 = maximum(thm_s_save[0][sb][sblock],thm_s_save[1][sb][sblock]);
     /* thresholds difference in db */
     if (x2 >= 1000*x1)  db=30;
     else db = 10*log10(x2/x1);  
     sidetot += db;
     tot++;
   }
 ms_ratio_s = .35*(sidetot/tot)/5.0;
 }
 }



 /*************************************************************** 
  * determin final block type
  ***************************************************************/
 if (force_ms) {
   /* Forced ms_stereo mode.  */
   /* ch=0 (mid) blocktype determines ch=1 (side) blocktype */
   uselongblock[1] = uselongblock[0];
 }


 for (chn=0; chn<stereo; chn++) {
   blocktype[chn] = NORM_TYPE;
 }

 if (!allow_diff_short)
 if (info->mode==MPG_MD_JOINT_STEREO) {
   /* force both channels to use the same block type */
   /* this is necessary if the frame is to be encoded in ms_stereo.  */
   /* But even without ms_stereo, FhG  does this */
   int bothlong= (uselongblock[0] && uselongblock[1]);
   if (!bothlong) {
     uselongblock[0]=0;
     uselongblock[1]=0;
   }
 }




 /* update the blocktype of the previous granule, since it depends on what
  * happend in this granule */
 for (chn=0; chn<stereo; chn++) {
 if ( uselongblock[chn])
   {				/* no attack : use long blocks */
     switch( blocktype_old[chn] ) 
       {
       case NORM_TYPE:
       case STOP_TYPE:
	 blocktype[chn] = NORM_TYPE;
	 break;
       case SHORT_TYPE:
	 blocktype[chn] = STOP_TYPE; 
	 break;
       case START_TYPE:
	 fprintf( stderr, "Error in block selecting\n" );
	 abort();
	 break; /* problem */
       }
   } else   {
     /* attack : use short blocks */
     blocktype[chn] = SHORT_TYPE;
     if ( blocktype_old[chn] == NORM_TYPE ) {
       blocktype_old[chn] = START_TYPE;
     }
     if ( blocktype_old[chn] == STOP_TYPE ) {
       blocktype_old[chn] = SHORT_TYPE ;
     }
   }

 
 blocktype_d[chn] = blocktype_old[chn];  /* value returned to calling program */
 blocktype_old[chn] = blocktype[chn];    /* save for next call to l3psy_anal */
 }

 if (blocktype_d[0]==2)
   *ms_ener_ratio = ms_ratio_s_old;
 else
   *ms_ener_ratio = ms_ratio_l_old;
 ms_ratio_s_old = ms_ratio_s;
 ms_ratio_l_old = ms_ratio_l;



}






void L3para_read(double sfreq, int *numlines_l,int *numlines_s, int *partition_l, double *minval,
double *qthr_l, double *norm_l, double (*s3_l)[63], double s3_s[CBANDS][CBANDS],
int *partition_s, double *qthr_s, double *norm_s, double *SNR, 
int *cbw_l, int *bu_l, int *bo_l, double *w1_l, double *w2_l, 
int *cbw_s, int *bu_s, int *bo_s, double *w1_s, double *w2_s)
{
  double freq_tp;
  static double bval_l[CBANDS], bval_s[CBANDS];
  int   cbmax=0, cbmax_tp;
  //  static double s3_s[CBANDS][CBANDS];
  double *p = psy_data;

  int  sbmax ;
  int  i,j,k,k2,loop, part_max ;

  /* Read long block data */

  for(loop=0;loop<6;loop++)
    {
      freq_tp = *p++;
      cbmax_tp = (int) *p++;
      cbmax_tp++;

      if (sfreq == freq_tp )
	{
	  cbmax = cbmax_tp;
	  for(i=0,k2=0;i<cbmax_tp;i++)
	    {
	      j = (int) *p++;
	      numlines_l[i] = (int) *p++;
	      minval[i] = *p++;
	      qthr_l[i] = *p++;
	      norm_l[i] = *p++;
	      bval_l[i] = *p++;
	      if (j!=i)
		{
		  fprintf(stderr,"1. please check \"psy_data\"");
		  exit(-1);
		}
	      for(k=0;k<numlines_l[i];k++)
		partition_l[k2++] = i ;
	    }
	}
      else
	p += cbmax_tp * 6;
    }

#define NEWBARKXX
#ifdef NEWBARK
  /* compute bark values of each critical band */
  for(i=0;i<cbmax;i++) {
    for (j=0;(i != partition_l[j]);j++);
    { double ji = j + (numlines_l[i]-1)/2.0;
    double freq = sfreq*ji/1024000.0;
    double bark = 13*atan(.76*freq) + 3.5*atan(freq*freq/(7.5*7.5));
    printf("%i %i bval_l = %f  %f  %f \n",i,j,bval_l[i],freq,bark);
    bval_l[i]=bark;
    }
  }
#endif

  /************************************************************************
   * Now compute the spreading function, s[j][i], the value of the spread-*
   * ing function, centered at band j, for band i, store for later use    *
   ************************************************************************/
  part_max = cbmax ;
  for(i=0;i<part_max;i++)
    {
      double tempx,x,tempy,temp;
      for(j=0;j<part_max;j++)
	{
	  //tempx = (bval_l[i] - bval_l[j])*1.05;
	  if (j>=i) tempx = (bval_l[i] - bval_l[j])*3.0;
	  else    tempx = (bval_l[i] - bval_l[j])*1.5;
	  /*             if (j>=i) tempx = (bval_l[j] - bval_l[i])*3.0;
			 else    tempx = (bval_l[j] - bval_l[i])*1.5; */


	  if(tempx>=0.5 && tempx<=2.5)
	    {
	      temp = tempx - 0.5;
	      x = 8.0 * (temp*temp - 2.0 * temp);
	    }
	  else x = 0.0;
	  tempx += 0.474;
	  tempy = 15.811389 + 7.5*tempx - 17.5*sqrt(1.0+tempx*tempx);

#ifdef NEWS3
	  if (j>=i) tempy = (bval_l[j] - bval_l[i])*(-15);
	  else    tempy = (bval_l[j] - bval_l[i])*25;
	  x=0; 
#endif
	  /*
	  if ((i==part_max/2)  && (fabs(bval_l[j] - bval_l[i])) < 3) {
	    printf("bark=%f   x+tempy = %f  \n",bval_l[j] - bval_l[i],x+tempy);
	    //printf("i,j %i %i   bark=%f  %f \n",i,j,bval_l[j],j/(.001+bval_l[j]));
	  }
	  */

	  if (tempy <= -60.0) s3_l[i][j] = 0.0;
	  else                s3_l[i][j] = exp( (x + tempy)*LN_TO_LOG10 ); 
	}
    }

  /* Read short block data */

  for(loop=0;loop<6;loop++)
    {
      freq_tp = *p++;
      cbmax_tp = (int) *p++;
      cbmax_tp++;

      if (sfreq == freq_tp )
	{
	  cbmax = cbmax_tp;
	  for(i=0,k2=0;i<cbmax_tp;i++)
	    {
	      j = (int) *p++;
	      numlines_s[i] = (int) *p++;
	      qthr_s[i] = *p++;         
	      norm_s[i] = *p++;         
	      SNR[i] = *p++;            
	      bval_s[i] = *p++;
	      if (j!=i)
		{
		  fprintf(stderr,"3. please check \"psy_data\"");
		  exit(-1);
		}
	      for(k=0;k<numlines_s[i];k++) 
		partition_s[k2++] = i ;
	    }
	}
      else
	p += cbmax_tp * 6;
    }


#ifdef NEWBARK
  /* compute bark values of each critical band */
  for(i=0;i<cbmax;i++) {
    for (j=0;(i != partition_s[j]);j++);
    { double ji = j + (numlines_s[i]-1)/2.0;
    double freq = sfreq*ji/256000.0;
    double bark = 13*atan(.76*freq) + 3.5*atan(freq*freq/(7.5*7.5));
    printf("%i %i bval_s = %f  %f  %f \n",i,j,bval_s[i],freq,bark);
    bval_s[i]=bark;
    }
  }
#endif



  /************************************************************************
   * Now compute the spreading function, s[j][i], the value of the spread-*
   * ing function, centered at band j, for band i, store for later use    *
   ************************************************************************/
  part_max = cbmax ;
  for(i=0;i<part_max;i++)
    {
      double tempx,x,tempy,temp;
      for(j=0;j<part_max;j++)
	{
	  // tempx = (bval_s[i] - bval_s[j])*1.05;
	  if (j>=i) tempx = (bval_s[i] - bval_s[j])*3.0;
	  else    tempx = (bval_s[i] - bval_s[j])*1.5;
	  if(tempx>=0.5 && tempx<=2.5)
	    {
	      temp = tempx - 0.5;
	      x = 8.0 * (temp*temp - 2.0 * temp);
	    }
	  else x = 0.0;
	  tempx += 0.474;
	  tempy = 15.811389 + 7.5*tempx - 17.5*sqrt(1.0+tempx*tempx);
#ifdef NEWS3
	  if (j>=i) tempy = (bval_s[j] - bval_s[i])*(-15);
	  else    tempy = (bval_s[j] - bval_s[i])*25;
	  x=0; 
#endif
	  if (tempy <= -60.0) s3_s[i][j] = 0.0;
	  else                s3_s[i][j] = exp( (x + tempy)*LN_TO_LOG10 );
	}
    }
  /* Read long block data for converting threshold calculation 
     partitions to scale factor bands */

  for(loop=0;loop<6;loop++)
    {
      freq_tp = *p++;
      sbmax =  (int) *p++;
      sbmax++;

      if (sfreq == freq_tp)
	{
	  for(i=0;i<sbmax;i++)
	    {
	      j = (int) *p++;
	      cbw_l[i] = (int) *p++;
	      bu_l[i] = (int) *p++;
	      bo_l[i] = (int) *p++;
	      w1_l[i] = (double) *p++;
	      w2_l[i] = (double) *p++;
	      if (j!=i)
		{ fprintf(stderr,"30:please check \"psy_data\"\n");
		exit(-1);
		}

	      if (i!=0)
		if ( (bo_l[i] != (bu_l[i]+cbw_l[i])) ||
		     (fabs(1.0-w1_l[i]-w2_l[i-1]) > 0.01 ) )
		  {
		    fprintf(stderr,"31l: please check \"psy_data.\"\n");
		    exit(-1);
		  }
	    }
	}
      else
	p += sbmax * 6;
    }

  /* Read short block data for converting threshold calculation 
     partitions to scale factor bands */

  for(loop=0;loop<6;loop++)
    {
      freq_tp = *p++;
      sbmax = (int) *p++;
      sbmax++;

      if (sfreq == freq_tp)
	{
	  for(i=0;i<sbmax;i++)
	    {
	      j = (int) *p++;
	      cbw_s[i] = (int) *p++;
	      bu_s[i] = (int) *p++;
	      bo_s[i] = (int) *p++;
	      w1_s[i] = *p++;
	      w2_s[i] = *p++;
	      if (j!=i)
		{ fprintf(stderr,"30:please check \"psy_data\"\n");
		exit(-1);
		}

	      if (i!=0)
		if ( (bo_s[i] != (bu_s[i]+cbw_s[i])) ||
		     (fabs(1.0-w1_s[i]-w2_s[i-1]) > 0.01 ) )
		  { fprintf(stderr,"31s: please check \"psy_data.\"\n");
		  exit(-1);
		  }
	    }
	}
      else
	p += sbmax * 6;
    }

}
