#!/bin/sh

DGROOT=`../src/delegated -Fdump DGROOT`
echo "#### DGROOT=$DGROOT"
set -x
LIBDIR=$DGROOT/lib
ETCDIR=$DGROOT/etc
SUBINDIR=$DGROOT/subin

if [ ! -d "$LIBDIR" ]; then mkdir "$LIBDIR"; fi
if [ ! -d "$SUBINDIR" ]; then mkdir "$SUBINDIR"; fi

if [ -d $LIBDIR ]; then
	cp -p /etc/resolv.conf $ETCDIR
	cp -p /lib/ld*so* $LIBDIR
	cp -p /lib/libc.so.* $LIBDIR
	cp -p /lib/libnsl.so.* $LIBDIR
	(cd $SUBINDIR; rm -f $*)
	mv $* $SUBINDIR
	cd $SUBINDIR
	su root -c "chown root $*; chmod 6550 $*"
fi
