/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1999 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
//////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	vaddr.h
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

	Virtual and Universal Address for Applications.

History:
	991116	created
//////////////////////////////////////////////////////////////////////#*/
#ifndef _VADDR_H
#define _VADDR_H

#ifndef _VSOCKET_H
/* virtual socket address intended to be 32 bytes */
typedef struct {
	int	s_int[8];
} VSAddr;
#endif

/* virtual application address intended to be 128 bytes */
typedef struct {
 VSAddr		a_vsa;		/* union of socket addresses types */
 unsigned char	a_type;
 unsigned char	a_flags;
 unsigned short	a_port;		/* (socket) port number */
 struct {
 unsigned int	a_int[4];	/* IP address in host byte order */
 } a_ints;
 char		a_name[74];	/* symbolic (host) name */
} VAddr;

#define VA_REMOTE	0x00001

extern VAddr AddrZero;
extern VAddr AddrNull;
extern VAddr MaskZero;

#define CLASS_MASK	0 /* mask determind by the default class of address */
#define HEURISTIC_MASK	1 /* mask determined by heuristics */

#define I0	a_ints.a_int[0]
#define I1	a_ints.a_int[1]
#define I2	a_ints.a_int[2]
#define I3	a_ints.a_int[3]

#define AddrEQ(a,b) ( \
	   a.I0 == b.I0 \
	&& a.I1 == b.I1 \
	&& a.I2 == b.I2 \
	&& a.I3 == b.I3 )

#define AddrAND(r,a,b) { \
	r.I0 = a.I0 & b.I0; \
	r.I1 = a.I1 & b.I1; \
	r.I2 = a.I2 & b.I2; \
	r.I3 = a.I3 & b.I3; }

#define	AddrInvalid(a)	(AddrEQ((a),AddrZero) || AddrEQ((a),AddrNull))

typedef struct {
	char	i_user[64];
	char	i_pass[64];
	char	i_syst[60];
	int	i_stat;
	VAddr	i_addr;
} AuthInfo;

/*
#define IDENT_NOTYET	 0
#define IDENT_GOT	 1
*/
#define AUTH_SET	 2

#define i_Port	i_addr.a_port
#define i_Host	i_addr.a_name

typedef struct {
	double	ri_timeout;
	short	ri_server;
	short	ri_client;
	int	ri_rcvd;
	int	ri_sent;
} RidentEnv;
extern RidentEnv ridentEnv;
#define RIDENT_TIMEOUT	ridentEnv.ri_timeout
#define RIDENT_SERVER	ridentEnv.ri_server
#define RIDENT_CLIENT	ridentEnv.ri_client
#define RIDENT_RCVD	ridentEnv.ri_rcvd
#define RIDENT_SENT	ridentEnv.ri_sent

#endif
