/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	svport.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	961006	extracted from delegated.c
	961120	moved stuffs about DELEGATE_HOST/PORT from {conf,service}.c
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include "ystring.h"
#include "yselect.h" /* FD_SETSIZE */
#include "delegate.h" /* Connection */

extern int DELEGATE_LISTEN;

typedef struct {
	int	 sv_sock;
	char	*sv_host;
	int	 sv_port;
	int	 sv_udp;
	int	 sv_keep; /* keep bound, but don't use to accept */
	char	*sv_vsap; /* accepting via VSAP */
} ServerPort;

typedef struct {
	int    pid;
	int    ppid;
	int    time;
} CloseOnTime;

typedef struct {
	char   *se_serverHostPort;   /* my (maybe pseudo) host:port */
	char	se_serverHostPortV[128];/* serverHostPort set by DELEGATE */
	char	se_serverHost1[128]; /* host of primary port */
	int	se_serverPort1;      /* primary port (std I/O by default) */
	int	se_serverPort1Fix;
	ServerPort se_SVPorts[FD_SETSIZE];
	int	se_SVPortN;
	struct {
		int	port;
		int	sock;
	} se_portsV[128];
	int	se_portsX;
	int	se_Tio[2];
	CloseOnTime se_cot;
} ServPorts;
static ServPorts *servPorts;
#define serverHostPort	servPorts->se_serverHostPort
#define serverHostPortV	servPorts->se_serverHostPortV
#define serverHost1	servPorts->se_serverHost1
#define serverPort1	servPorts->se_serverPort1
#define serverPort1Fix	servPorts->se_serverPort1Fix
#define SVPorts		servPorts->se_SVPorts
#define SVPortN		servPorts->se_SVPortN
#define portsV		servPorts->se_portsV
#define portsX		servPorts->se_portsX
#define Tio		servPorts->se_Tio
#define cot		servPorts->se_cot
minit_ports()
{
	if( servPorts == 0 ){
		servPorts = NewStruct(ServPorts);
		SVPorts[0].sv_sock = -1;
	}
}

#define SvSock(n)	SVPorts[n].sv_sock
#define SvPort(n)	SVPorts[n].sv_port
#define SvUDP(n)	SVPorts[n].sv_udp
#define SvHost(n)	SVPorts[n].sv_host
#define SvHostStr(n)	((SvHost(n) && SvHost(n)[0]) ? SvHost(n) : "")
#define SvKeep(n)	SVPorts[n].sv_keep
#define SvRoute(n)	SVPorts[n].sv_vsap
#define SvRouteStr(n)	(SvRoute(n) == 0 ? "" : SvRoute(n))

static scanServPort0(host,port,udp,sock,route)
	char *host;
	char *route;
{	int sx;
	int keep;
	int wasactive;
	int fix; 

	if( fix = host[0] == '-' ){
		/* -P-host:port ... use the port as is for ${PORT} */
		host = host + 1;
	}

	if( port < 0 ){
		port = -port;
		keep = 1;
	}else	keep = 0;

	for( sx = 0; sx < SVPortN; sx++ )
		if( strcmp(SvHostStr(sx),host) == 0 )
		if( SvPort(sx) == port )
		if( SvUDP(sx) == udp )
			break;
	if( sx == SVPortN )
		SVPortN++;

	/* private-MASTER, exec on SIGHUP, from inetd */
	if( 0 <= sock )
		port = sockPort(sock);

	if( sx == 0 ){
		if( host[0] != 0 )
			sethostnameIF(host);
		if( serverPort1Fix == 0 ){
		if( 0 <= port )
			serverPort1 = port;
		}
		if( fix )
			serverPort1Fix = 1;
	}

	if( SvHost(sx) )
	{
		free(SvHost(sx));
		wasactive = 1;
	}else	wasactive = 0;

	SvHost(sx) = stralloc(host);
	SvPort(sx) = port;
	SvUDP(sx) = udp;
	SvKeep(sx) = keep;
	SvRoute(sx) = stralloc(route);

	if( wasactive )
	if( 0 <= SvSock(sx) )
		close(SvSock(sx));
	SvSock(sx) = sock;
	return 0;
}

scanServPort1(portspec)
	char *portspec;
{	int sx;
	char host[128];
	char portname[128];
	char ports[128];
	char mod[128];
	int port1,port2,port;
	int udp;
	int sock;
	int route[128];

	if( streq(portspec,"-") ){
		serverPort1 = 0;
		return 0;
	}

	portname[0] = 0;
	route[0] = 0;
	host[0] = 0;
	mod[0] = 0;
	ports[0] = 0;
	udp = 0;
	sock = -1;

	if( portspec[0] == ':' )
		portspec++;

	sscanf(portspec,"%[^@]@%s",portname,route);
	if( strchr(portname,':') )
		sscanf(portname,"%[^:]:%[^/]/%s",host,ports,mod);
	else	sscanf(portname,"%[^/]/%s",ports,mod);

	if( mod[0] ){
		if( strcmp(mod,"udp") == 0 )
			udp = 1;
		else	sock = atoi(mod);
	}

	if( route[0] ){
		char vsap[256];
		sprintf(vsap,"%s/ACCEPT",route);
		scan_VSAP(NULL,vsap);
	}

	port1 = port2 = 0;
	if( sscanf(ports,"%d-%d",&port1,&port2) == 1 )
		port2 = port1;
	for( port = port1; port <= port2; port++ )
		scanServPort0(host,port,udp,sock,route);
	return 0;
}

scanServPort(portspecs)
	char *portspecs;
{
	SVPortN = 0;
	scan_commaList(portspecs,0,scanServPort1);
}

printServPort(port,prefix,whole)
	char *prefix,*port;
{	int sx;
	char *pp;

	port[0] = 0;

	pp = port;
	if( prefix ){
		strcpy(pp,prefix);
		pp += strlen(pp);
	}

	for( sx = 0; sx < SVPortN; sx++ ){
		if( 0 < sx ){
			*pp++ = ',';
			*pp = 0;
		}

		if( SvHostStr(sx)[0] ){
			sprintf(pp,"%s:",SvHost(sx));
			pp += strlen(pp);
		}

		if( SvKeep(sx) )
			sprintf(pp,"%d",-SvPort(sx));
		else	sprintf(pp,"%d",SvPort(sx));
		pp += strlen(pp);

		if( SvRouteStr(sx)[0] ){
			sprintf(pp,"@%s",SvRoute(sx));
			pp += strlen(pp);
		}

		if( !whole )
			break;

		if( 0 < whole )
		if( 0 <= SvSock(sx) ){
			sprintf(pp,"/%d",SvSock(sx));
			pp += strlen(pp);
		}
	}

	return SVPortN;
}

setServUDP()
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ )
		SvUDP(sx) = 1;
}

openServPorts()
{	int sx;
	char msg[1024];
	int listen;

	for( sx = 0; sx < SVPortN; sx++ ){
		if( 0 <= SvSock(sx) )
			continue;

		if( SvHostStr(sx)[0] ){
			int fd;
			fd = nextFD();
			IsResolvable(SvHost(sx)); /* enter it to the cache */
			usedFD(fd);
		}

/* check ACTDIR/delegate/pid/PORT and kill if it exist ...
 * by trying fopen "r+" and lock exclusive
 */

		if( SvUDP(sx) )
			listen = -1;
		else	listen = DELEGATE_LISTEN;

/*
		SvSock(sx) = server_open("delegate",
				SvHostStr(sx),SvPort(sx),listen);
*/
		SvSock(sx) = findopen_port("delegate",
				SvHostStr(sx),SvPort(sx),listen);

		if( SvSock(sx) < 0 ){
			sprintf(msg,"cannot open server port %s:%d",
				SvHostStr(sx),SvPort(sx));
			ERRMSG("DeleGate: %s\n",msg);
			Exit(-1,"DeleGate: %s\n",msg);
		}
	}
}

closeServPorts()
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ ){
		close(SvSock(sx));
		SvSock(sx) = -1;
		SvPort(sx) = 0;
		if( SvHost(sx) )
		SvHost(sx)[0] = 0;
	}
	SVPortN = 0;
}

makeEntrance(){
	/*
	if( serverPort1 ){
	*/
	if( 0 < SVPortN ){
		openServPorts();
	}else{
		Socketpair(Tio); /* dummy */
		SvSock(0) = Tio[0];
		SVPortN = 1;
		sv1log("TeleportTunnel[%d]\n",SvSock(0));
	}
}

getServPorts(sc,sv)
	int sv[];
{	int sx,sn;

	sn = 0;
	for( sx = 0; sx < sc && sx < SVPortN; sx++ ){
		sv[sn] = SvSock(sx);
		sn++;
	}
	return sn;
}
pollServPort(timeout,rsockv,udpv,optv)
	int *rsockv,*udpv,*optv;
{	int sx,sxa,rsx;
	int ssockv[FD_SETSIZE],readyv[FD_SETSIZE],nready;
	int sock;

	sxa = 0;
	for( sx = 0; sx < SVPortN; sx++ ){
		if( !SvKeep(sx) ){
			ssockv[sxa] = SvSock(sx);
			readyv[sxa] = 0;
			sxa++;
		}
	}
	if( optv ){
		for( sx = 0; 0 <= optv[sx]; sx++ ){
			ssockv[sxa] = optv[sx];
			readyv[sxa] = 0;
			sxa++;
		}
	}

	nready = PollIns(timeout,sxa,ssockv,readyv);
	if( nready <= 0 )
		return nready;

	rsx = 0;
	for( sx = 0; sx < sxa; sx++ ){
		if( 0 < readyv[sx] ){
			rsockv[rsx] = ssockv[sx];
			udpv[rsx] = SvUDP(sx);
			rsx++;
		}
	}
	return nready;
}

inetdServPort()
{	int sock,port,osock,oport;

	sock = dup(0);
	setsockREUSE(sock,1);
	port = sockPort(sock);
	oport = SvPort(0);
	osock = SvSock(0);
	svlog("fromInetd/SVsock: %d/%d <= %d/%d\n",port,sock,oport,osock);
	setsid();

	if( oport != port || osock < 0 ){
		LOG_deletePortFile();
		LOG_closeall();
		closeServPorts();
		scanServPort0("",port,isUDPsock(sock),sock,"");
	}
	else	close(sock);
}

static isNotServPort(host,port)
	char *host;
{	int sx;

	if( SVPortN == 0 ){
		/* can be cleared by with -x or in OnetimeServer or ...
		 * thus cannot determine by -PportList
		 */
		return 0;
	}
	for( sx = 0; sx < SVPortN; sx++ )
		if( SvPort(sx) == port ){
			if( SvKeep(sx) )
				return 1;
			else	return 0;
		}

	return 1;
}

ServSockOf(host,port)
	char *host;
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ )
		if( SvPort(sx) == port )
			return SvSock(sx);
	return -1;
}

activeServPort()
{	int nactive,sx;

	nactive = 0;
	for( sx = 0; sx < SVPortN; sx++ )
		if( 0 <= SvSock(sx) )
			if( !SvKeep(sx) )
				nactive++;
	return nactive;
}

ServSock()
{
	return SvSock(0);
}

isServSock(sock)
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ ){
		if( SvSock(sx) == sock )
			return 1;
	}
	return 0;
}

/*
 *	close a file descriptor (parallel server's socket for accept)
 *	(1) on specified timeout
 *	(2) after fork
 *	(3) after the death of the parent
 */
setCloseOnTimeout(timeout)
{
	cot.time = time(0) + timeout;
	cot.ppid = getppid();
	cot.pid = getpid();
}
static checkCloseOnTimeout(checktime)
{
	if( cot.time == 0 )
		return 1;

	if( getpid() == cot.pid )
	if( getppid() == cot.ppid )
	if( checktime && time(0) < cot.time )
		return 0;

	closeServPorts();
	sv1log("ClosedOnTimeout(%d): time=%d/%d ppid=%d/%d pid=%d/%d\n",
		checktime,
		time(0),cot.time,
		getppid(),cot.ppid,
		getpid(),cot.pid);

	bzero(&cot,sizeof(cot));
	return 1;
}
/*
int (*CheckClose)() = checkCloseOnTimeout;
*/
int (*CheckClosed)() = checkCloseOnTimeout;


/*
 *
 */
sethostnameIF(host)
	char *host;
{
	strcpy(serverHost1,host);
	if( serverHostPort != NULL )
		free(serverHostPort);
	serverHostPort = stralloc(host);
}
gethostnameIFIF(host,size)
	char *host;
{
	if( serverHost1[0] ){
		strncpy(host,serverHost1,size);
		return 0;
	}
	host[0] = 0;
	return -1;
}
gethostnameIF(host,size)
	char *host;
{
	if( gethostnameIFIF(host,size) == 0 )
		return 0;
	else	return GetHostname(host,size);
}
Myhostport(myhp,size)
	char *myhp;
{
	gethostnameIF(myhp,size);
	sprintf(myhp+strlen(myhp),":%d",serverPort1);
}

char *gethostaddr();
CTX_myhostport(Conn,myhost,size)
	Connection *Conn;
	char *myhost;
{	char *delegate;
	int myport;
	char *addr;

	myport = serverPort1;
	if( delegate = serverHostPort )
		sscanf(delegate,"%[^:]:%d",myhost,&myport);
	else	gethostnameIF(myhost,size);

	if( delegate == 0 || use_numaddress(Conn) ){
		if( addr = gethostaddr(myhost) )
			strcpy(myhost,addr);
	}
	return myport;
}

forcedIF_H(Conn,host)
	Connection *Conn;
	char *host;
{	int port;

	if( Conn->my_vbase.u_host ){
		strcpy(host,Conn->my_vbase.u_host);
		return Conn->my_vbase.u_port;
	}
	if( serverHostPort == serverHostPortV ){
		port = serverPort1;
		sscanf(serverHostPort,"%[^:]:%d",host,&port);
		return port;
	}
	return 0;
}
forcedIF_HP(Conn,hostport)
	Connection *Conn;
	char *hostport;
{
	if( Conn->my_vbase.u_host ){
		sprintf(hostport,"%s:%d",
			Conn->my_vbase.u_host,Conn->my_vbase.u_port);
		return 1;
	}
	if( serverHostPort == serverHostPortV ){
		strcpy(hostport,serverHostPort);
		return 1;
	}
	return 0;
}

VA_HostPortIFclnt(Conn,clsock,name,addr,Vaddr)
	Connection *Conn;
	char *name,*addr;
	VAddr *Vaddr;
{	char addrb[32];

	if( !AddrEQ(Conn->cl_sockHOST,AddrZero) )
		goto EXIT;

	VA_gethostNAME(clsock,&Conn->cl_sockHOST);
	VA_inetNtoah(&Conn->cl_sockHOST,addrb);

	Verbose("-- SockHost: [%s] %s:%d\n",
		addrb, Conn->cl_sockHOST.a_name,
		Conn->cl_sockHOST.a_port);

EXIT:
	if( name ) strcpy(name,Conn->cl_sockHOST.a_name);
	if( addr ) VA_inetNtoah(&Conn->cl_sockHOST,addr);
	if( Vaddr ) *Vaddr = Conn->cl_sockHOST;
	return Conn->cl_sockHOST.a_port;
}

static _clientIF(Conn,hostport,host,clsock,byaddr)
	Connection *Conn;
	char *hostport,*host;
{	char hostb[256],addr[256];
	int port;

	if( host == NULL )
		host = hostb;

	if( serverHostPort )
		port = CTX_myhostport(Conn,host,sizeof(host));
	else{
		port = VA_HostPortIFclnt(Conn,clsock,host,addr,NULL);
		if( byaddr && addr[0] != 0 )
			strcpy(host,addr);
	}
	if( hostport != NULL )
		sprintf(hostport,"%s:%d",host,port);

	return port;
}
ClientIF_addr(Conn,clsock,addr)
	Connection *Conn;
	char *addr;
{
	return _clientIF(Conn,NULL,addr,clsock,1);
}
ClientIF_name(Conn,clsock,name)
	Connection *Conn;
	char *name;
{
	return _clientIF(Conn,NULL,name,clsock,0);
}
ClientIF_HPname(Conn,hostport)
	Connection *Conn;
	char *hostport;
{
	return _clientIF(Conn,hostport,NULL,ClientSock,0);
}
ClientIF_HP(Conn,hostport)
	Connection *Conn;
	char *hostport;
{
	return _clientIF(Conn,hostport,NULL,ClientSock,1);
}
ClientIF_H(Conn,host)
	Connection *Conn;
	char *host;
{
	return _clientIF(Conn,NULL,host,ClientSock,1);
}

ServerIF_name(Conn,host)
	Connection *Conn;
{
	if( 0 < ToS )
		gethostNAME(ToS,host);
	else	gethostname(host,256);
}

static isme(myhost,myport,rhost,rport)
	char *myhost,*rhost;
{	int myhosti,rhosti;

	if( rport != myport )
		return 0;

	if( strcasecmp(myhost,rhost) == 0 )
		return 1;

	myhosti = gethostintMin(myhost);
	rhosti = gethostintMin(rhost);

	if( myhosti == -1 || rhosti == -1 )
		return 0; /* maybe safer (resolver seems wrong) */

	if( myhosti == rhosti )
		return 1;

	if( serverHost1[0] != 0 ) /* if interface host is limited */
		return 0;

	return IsMyself(rhost);
}

extern char *VSA_hostlocal();
Ismyself(Conn,rproto,rhost,rport)
	Connection *Conn;
	char *rproto,*rhost;
{	char myhost[256];
	int myport;

	/* Local path cannot be the procol between client / DeleGate ...
	 * (this was temporary patch to avoid being treated as a internal
	 *  URL at httpd.c:HttpToMyself() ...
	 */
	if( localPathProto(rproto) )
		return 0;

	if( isMYSELF(rhost) )
		return 1;

	/*
	 * "sock.dir.af-local" for AF_UNIX "/dir/sock" with port number 0xFFFF
	 *  means that port number must not be cared
	 */
	if( strtailstr(rhost,VSA_hostlocal()) ){
		myport = VA_HostPortIFclnt(Conn,ClientSock,myhost,NULL,NULL);
		if( myport == 0xFFFF ){
			return isme(myhost,0,rhost,0);
		}
	}

	/*
	 * A virtual address can be given by DELEGATE parameter and is set
	 * to serverHostPort.  The address can be one of followings:
	 *   1. (one of) physical address of myself
	 *   2. (one of) physical address of another server's host:port
	 *   3. pseudo address bound to myself
	 */
	if( serverHostPort != NULL ){
		myport = CTX_myhostport(Conn,myhost,sizeof(myhost));
		if( isme(myhost,myport,rhost,rport) )
			return 1;
	}

	/*
	 * In physicall address matching, the server port of the
	 * delegated is one of real ports specified in -Pp1,p2,...
	 */
	if( isNotServPort(rhost,rport) )
		return 0;
	myport = VA_HostPortIFclnt(Conn,ClientSock,myhost,NULL,NULL);
	return isme(myhost,myport,rhost,rport);
}

scan_DELEGATE(Conn,dhps)
	Connection *Conn;
	char *dhps;
{	char hostport[1024],host[1024];
	int port;
	char proto[1024],dst[1024],src[1024];
	int ni;

	if( dhps == NULL )
		return;

	host[0] = 0;
	port = 0;
	proto[0] = dst[0] = src[0] = 0;
	ni = sscanf(dhps,"%[^:]:%d:%[^:]:%[^:]:%s",host,&port,proto,dst,src);

	if( isMYSELF(host) && Conn != NULL )
		gethostAddr(ClientSock,host);
	if( port == 0 )
		port = serverPort1;
	if( proto[0] )
		scan_CALLBACK(proto);

	sprintf(hostport,"%s:%d",host,port);
	/*
	dhps = stralloc(hostport);
	*/
	wordScan(hostport,serverHostPortV);
	dhps = serverHostPortV;
	xmem_push(&serverHostPort,sizeof(serverHostPort),"DELEGATE",NULL);
	serverHostPort = dhps;
}

printPrimaryPort(port)
	char *port;
{
	if( serverHost1[0] )
		sprintf(port,"%s:%d",serverHost1,serverPort1);
	else	sprintf(port,"%d",serverPort1);
}

connectToMyself(what)
	char *what;
{	int sock;

	if( serverHost1[0] )
		sock = client_open(what,"delegate",serverHost1,serverPort1);
	else	sock = client_open(what,"delegate","localhost",serverPort1);
	return sock;
}

SERVER_PORT()
{
	return serverPort1;
}
setSERVER_PORT(host,port,sock)
	char *host;
{
	if( 0 <= sock )
		scanServPort0(host,port,isUDPsock(sock),sock,"");
	else	scanServPort0(host,port,0,-1,"");
}



static scanports(hostport)
	char *hostport;
{	char host[256];
	int port1,port2,port;
	int sock;
	int pi;

	host[0] = 0;
	port1 = 0;
	port2 = 0;
	if( strchr(hostport,':') )
		sscanf(hostport,"%[^:]:%d-%d",host,&port1,&port2);
	else	sscanf(hostport,"%d-%d",&port1,&port2);
	if( port2 == 0 )
		port2 = port1;

	for( port = port1; port <= port2; port++ ){
		sock = findopen_port("reservePORT",host,port,DELEGATE_LISTEN);
		if( sock < 0 ){
			fprintf(stderr,"CANNOT BIND PORT %d\r\n",port);
			exit(1);
		}
		portsV[portsX].port = port;
		portsV[portsX].sock = sock;
		portsX++;
	}
	return 0;
}
scan_PORT(Conn,ports)
	Connection *Conn;
	char *ports;
{
	scan_commaList(ports,0,scanports);
}
getReservedPorts(pv,sv)
	int pv[],sv[];
{	int sx;

	for( sx = 0; sx < portsX; sx++ ){
		pv[sx] = portsV[sx].port;
		sv[sx] = portsV[sx].sock;
	}
	return sx;
}
sendReservedPorts()
{	int sx,si;

	si = 0;
	for( sx = 0; sx < portsX; sx++ ){
		if( portsV[sx].port ){
			setrsvdsock(si++,portsV[sx].sock);
		}
	}
}
ReservedPortSock(host,port)
	char *host;
{	int sx;

	for( sx = 0; sx < portsX; sx++ )
		if( portsV[sx].port == port )
			return portsV[sx].sock;
	return -1;
}
closeNonReservedPortSock(sock)
{	int sx;

	for( sx = 0; sx < portsX; sx++ )
		if( portsV[sx].sock == sock )
			return 0;
	close(sock);
}
closeReservedPorts()
{	int sx;

	for( sx = 0; sx < portsX; sx++ ){
		if( portsV[sx].port ){
			close(portsV[sx].sock);
			portsV[sx].port = 0;
			portsV[sx].sock = 0;
		}
	}
	portsX = 0;
}
