/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Yutaka Sato
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ssi.c (SSI and META processor)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

	<META HTTP-EQUIV="Status" content=status-line> ... for CGI compati.
	<!--#include file=requeste/response> ... for CFI

	original-SSI = http://hoohoo.ncsa.uiuc.edu/docs/tutorials/includes.html
	SSI+ = http://www.carleton.ca/~dmcfet/html/ssi3.html
	SPML = http://www.apache.org/docs/mod/mod_include.html

History:
	990802	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "ystring.h"
#include <ctype.h>
#include "url.h"
#define MY_HTTPVER "1.1"

extern FILE *TMPFILE();
extern char *html_nextTagAttr();
extern char *getv();
extern FILE *CTX_URLget();

extern int TAGCONV_SSI;
extern int TAGCONV_META;
extern char *TIMEFORM_RFC822;

typedef struct {
	char	f_timefmt[64];
	char	f_sizefmt[32];
	char	h_status[1024];
	char	h_contype[128];
	char	h_header[4096];
	FILE   *m_body;
} Mssg;

#define ssi_timefmt (mssg->f_timefmt[0]?mssg->f_timefmt:TIMEFORM_RFC822)
#define ssi_sizefmt mssg->f_sizefmt

/*
static struct {
} SSIenvs[] = {
};
*/

static struct {
	char	*n_ssi;
	char	*n_cgi;
} cgi_equiv[] = {
	{"REFERRER",		"HTTP_REFERER"	},
	{"DOCUMENT_NAME",	"SCRIPT_NAME"	},
	{"DOCUMENT_URI",	"REQUEST_URI"	},
	0,
};

SSI_config(ctx,ev,tag,type,fmt,htfp,mssg)
	void *ctx;
	char *ev[];
	char *tag,*type;
	char *fmt;
	FILE *htfp;
	Mssg *mssg;
{
	if( strcaseeq(type,"timefmt") )
		lineScan(fmt,mssg->f_timefmt);
	else
	if( strcaseeq(type,"sizefmt") )
		lineScan(fmt,mssg->f_sizefmt);
	else{
		fprintf(mssg->m_body,"(SSI-UNKNOWN-config-%s)",type);
	}
}
static SSI_getenv(ctx,ev,tag,type,ename,htfp,mssg,buff,size)
	void *ctx;
	char *ev[];
	char *tag,*type;
	char *ename;
	FILE *htfp;
	Mssg *mssg;
	char *buff;
{	char *sname,*cname,*eval;
	int ni;

	buff[0] = 0;
	if( strcaseeq(ename,"DATE_GMT") ){
		StrftimeGMT(buff,size,ssi_timefmt,time(0));
	}else
	if( strcaseeq(ename,"DATE_LOCAL") ){
		StrftimeLocal(buff,size,ssi_timefmt,time(0));
	}else
	if( strcaseeq(ename,"LAST_MODIFIED") ){
		StrftimeGMT(buff,size,ssi_timefmt,file_mtime(fileno(htfp)));
	}else
	if( strcaseeq(ename,"PAGE_COUNT") ){
		strcpy(buff,"(SSI-NOTSUPPORTED-ENV-PAGE_COUNT)");
	}else
	if( strcaseeq(ename,"TOTAL_HITS") ){
		strcpy(buff,"(SSI-NOTSUPPORTED-TOTAL_HITS)");
	}else
	if( eval = getv(ev,ename) ){
		linescanX(eval,buff,size);
	}else{
		cname = 0;
		for( ni = 0; sname = cgi_equiv[ni].n_ssi; ni++ ){
			if( strcaseeq(ename,sname) ){
				cname = cgi_equiv[ni].n_cgi;
				break;
			}
		}
		if( cname ){
			if( eval = getv(ev,cname) )
				linescanX(eval,buff,size);
		}else{
			sprintf(buff,"(SSI-UNKNOWN-ECHO-%s)",ename);
			sv1tlog("SSI ECHO ERROR: unknown <%s>\n",ename);
		}
	}
	return strlen(buff);
}
SSI_echo(ctx,ev,tag,type,ename,htfp,mssg)
	void *ctx;
	char *ev[];
	char *tag,*type;
	char *ename;
	FILE *htfp;
	Mssg *mssg;
{	char buf[1024];
	char *eval;
	FILE *body = mssg->m_body;

	if( strcaseeq(ename,"*") ){
		int ei;
		for( ei = 0; eval = ev[ei]; ei++ )
			fprintf(body,"%s\r\n",ev[ei]);
		return 1;
	}

	SSI_getenv(ctx,ev,tag,type,ename,htfp,mssg,buf,sizeof(buf));
	fputs(buf,body);
	return 2;
}
static basedir(path)
	char *path;
{	char *tp;

	for( tp = path+strlen(path)-1; path < tp; tp-- ){
		if( *tp == '/' )
			break;
		else	*tp = 0;
	}
}
SSI_file(ctx,ev,tag,type,file,htfp,mssg)
	void *ctx;
	char *ev[];
	char *tag,*type,*file;
	FILE *htfp;
	Mssg *mssg;
{	char url[URLSZ],lurl[URLSZ],temp[URLSZ],root[URLSZ];
	char *base;
	FILE *body = mssg->m_body;
	FILE *fp;
	int fsize,mtime,direct,xoff,exec;

	syslog_DEBUG("## SSI %s %s=\"%s\"\n",tag,type,file);

	if( streq(type,"file")
	 || streq(type,"virtual") ){
	}else{
		fprintf(body,"(SSI-MISSING-virtual)");
		return;
	}

	lineScan(file,url);
	if( url[0] != '/' && !isFullURL(url) ){
		lineScan(url,temp);
		if( base = getv(ev,"SCRIPT_NAME") ){
			lineScan(base,url);
		}else
		if( base = getv(ev,"REQUEST_URI") ){
			url[0] = '/';
			decomp_absurl(base,NULL,NULL,url+1,sizeof(url));
		}
		if( base ){
			basedir(url);
			chdir_cwd(url,temp,0);
		}
	}
	strcpy(lurl,url);
	CTX_mount_url_to(ctx,NULL,"GET",lurl);
	if( strncmp(lurl,"file://localhost/",17) == 0 ){
		if( isFullpath(lurl+17) )
			file = lurl+17;
		else	file = lurl+16;
	}else	file = lurl;

	/*
	 * return meta information if the target is a local file
	 */
	exec = isExecutableURL(file);
	syslog_DEBUG("## exec=%d %s [%s]\n",exec,file,url);

	if( strcaseeq(tag,"fsize") ){
		if( !exec )
		if( 0 <= (fsize = File_size(file)) ){
			fprintf(body,"%d",fsize);
			return;
		}
	}else
	if( strcaseeq(tag,"flastmod") ){
		if( !exec )
		if( 0 <= (mtime = File_mtime(file)) ){
			StrftimeLocal(temp,sizeof(temp),ssi_timefmt,mtime);
			fprintf(body,"%s",temp);
			return;
		}
	}else
	if( strcaseeq(tag,"include") ){
	}else{
		fprintf(body,"(SSI-UNKNOWN-%s)",tag);
		return;
	}

	/*
	 * open target (possibly remote) data
	 */
	fp = NULL;
	if( !exec )
		fp = fopen(file,"r");
	if( fp == NULL ){
		fflush(body);  /* necessary not to duplicate buffered data
				* in fork() in responseFilter()
				* for CTX_URLget()
				*/
		xoff = ftell(htfp);
		fp = CTX_URLget(ctx,1,url,0,NULL);
		if( ftell(htfp) != xoff ){
			/* On Solaris2, the offset is moved mysteriously,
			 * in wait(0) for fork()ed responseFilter()
			 * which do exit() (not _exit()) at the end.
			 * This causes duplicated SHTML reading...
			 */
			sv1log("## fseeked ? %d -> %d\n",xoff,ftell(htfp));
			fseek(htfp,xoff,0);
		}
	}
	if( fp == NULL ){
		fprintf(body,"(SSI-UNKNOWN-%s-%s)",tag,url);
		return;
	}

	if( strcaseeq(tag,"fsize") ){
		fsize = file_size(fileno(fp)) - ftell(fp);
		fprintf(body,"%d",fsize);
	}else
	if( strcaseeq(tag,"flastmod") ){
		fseek(fp,0,0);
		mtime = HTTP_getLastModInCache(temp,sizeof(temp),fp,"(tmp)");
		StrftimeLocal(temp,sizeof(temp),ssi_timefmt,mtime);
		fprintf(body,"%s",temp);
	}else
	if( strcaseeq(tag,"include") ){
		copyfile1(fp,body);
	}
	fclose(fp);
}
SSI_exec(ctx,ev,tag,type,command,htfp,mssg)
	void *ctx;
	char *ev[];
	char *tag,*type,*command;
	FILE *htfp;
	Mssg *mssg;
{	FILE *body = mssg->m_body;

	if( streq(type,"cmd") ){
	}else
	if( streq(type,"cgi") ){
	}else
	if( streq(type,"virtual") ){
	}else{
		fprintf(body,"(SSI-UNKNOWN-%s-%s)",tag,type);
	}
}
static eval_paramvalue(ctx,ev,tagp,type,fname,htfp,mssg,str,val,siz)
	void *ctx;
	char *ev[];
	char *tagp,*type,*fname;
	FILE *htfp;
	Mssg *mssg;
	char *str,*val;
{	FILE *body = mssg->m_body;
	int off,rcc;
	char fc,*fp,*vp,*xp,*tp;
	char fmt[256],xtag[256],xtype[256],xval[256];

	valuescanX(str,fmt,sizeof(fmt));
	vp = val;
	xp = val + siz - 1;
	for( fp = fmt; vp < xp && (fc = *fp); ){
		xtag[0] = 0;
		if( fc == '$' && strncmp(fp,"${",2) == 0 ){
			tp = wordscanY(fp+2,fmt,sizeof(fmt),"^}");
			if( *tp == '}' ){
				if( strchr(fmt,':') ){
					scan_field1(fmt,xtag,sizeof(xtag),
						xval,sizeof(xval));
					strcpy(xtype,"virtual");
				}else{
					strcpy(xtag,"echo");
					strcpy(xtype,"var");
					strcpy(xval,fmt);
				}
			}
		}else
		if( fc == '<' && strncmp(fp,"<!--#",5) == 0 ){
			tp = wordscanY(fp+5,fmt,sizeof(fmt),"^>");
			if( *tp == '>' ){
				xp = wordScan(fmt,xtag);
				while( isspace(*xp) ) xp++;
				xp = wordscanY(xp,xtype,sizeof(xtype),"^=");
				if( *xp == '=' ) xp++;
				xp = valuescanX(xp,xval,sizeof(xval));
			}
		}
		if( xtag[0] ){
			if( strcaseeq(xtag,"echo") ){
				SSI_getenv(ctx,ev,tagp,type,xval,
					htfp,mssg,vp,siz-(vp-val));
			}else
			if( strcaseeq(xtag,"fsize")
			 || strcaseeq(xtag,"flastmod")
			 || strcaseeq(xtag,"include") ){
				off = ftell(body);
				SSI_file(ctx,ev,xtag,xtype,xval,htfp,mssg);
				fseek(body,off,0);
				rcc = fread(vp,1,siz-(vp-val),body);
				vp[rcc] = 0;
				fseek(body,off,0);
				Ftruncate(body,off,0);
			}
			fp = tp + 1;
			vp += strlen(vp);
		}else{
			*vp++ = *fp++;
		}
	}
	*vp = 0;
}

/*
 * <META HTTP-EQUIV=Date content="${DATE_GMT}">
 * <META HTTP-EQUIV=Date content="${flastmod:URL}">
 * <META HTTP-EQUIV=Content-Length content="<!--#fsize virtual=URL -->">
 */
META_eval(ctx,ev,tagp,type,fname,htfp,mssg)
	void *ctx;
	char *ev[];
	char *tagp,*type,*fname;
	FILE *htfp;
	Mssg *mssg;
{	char *cp,fvalue[256],fc,*sp,*dp;

	if( !strcaseeq(type,"HTTP-EQUIV") ){
		return;
	}

	fvalue[0] = 0;
	if( cp = strcasestr(tagp,"content=") ){
		cp += 8;
		eval_paramvalue(ctx,ev,tagp,type,fname,htfp,mssg,
			cp,fvalue,sizeof(fvalue));
	}

	dp = fvalue;
	for( sp = fvalue; fc = *sp; sp++ ){
		if( fc == '\r' || fc == '\n' ){
			*dp++ = ' ';
			while( isspace(sp[1]) )
				sp++;
		}else	*dp++ = fc;
	}
	*dp = 0;

	if( strcaseeq(fname,"Status") )
		sprintf(mssg->h_status,"%s\r\n",fvalue);
	else
	if( strcaseeq(fname,"Content-Type") )
		sprintf(mssg->h_contype,"%s\r\n",fvalue);
	else	sprintf(mssg->h_header+strlen(mssg->h_header),"%s: %s\r\n",
			fname,fvalue);
}

scan_metahttp(ctx,line,func,a1,a2,a3)
	void *ctx;
	char *line;
	char *(*func)();
	void *a1,*a2,*a3;
{	int uconv;
	char *sp,*np,*ep;
	char *tag,*attr,*cont,attrb[32],contb[128];

	sp = line;
	while( sp ){
		uconv = TAGCONV_META;
		np = html_nextTagAttr(sp,"",NULL,&tag,&attr,&uconv);
		if( np == NULL )
			break;

		if( ep = strpbrk(np,">") )	sp = ep + 1; else
		if( ep = strpbrk(np," \t\r\n"))	sp = ep + 1; else
			sp = np;

		if( tag && strncasecmp(tag,"<META",5) == 0 )
		if( attr && strncasecmp(attr,"HTTP-EQUIV=",11) == 0 )
		if( cont = strcasestr(np,"content=") ){
			valuescanX(attr+11,attrb,sizeof(attrb));
			valuescanX(cont+ 8,contb,sizeof(contb));
			sp = (*func)(ctx,attrb,contb,tag,attr,sp);
			continue;
		}

		if( sp == np )
			break;
	}
}

static char *seekeot(tagp,np,ignspace)
	char *tagp,*np;
{	char *sp,sc,*xp;

	xp = NULL;
	for( sp = np; sc = *sp; sp++ ){
		if( sc == '"' ){
			for( sp++; *sp && *sp != '"'; sp++ );
			if( *sp == 0 )
				break;
			continue;
		}
		if( sc == '-' && strncmp(sp,"-->",3) == 0 )
				 { xp = sp + 3; break; }
		if( sc == '>'   ){ xp = sp + 1; break; }
		if( isspace(sc) ){ xp = sp + 1; }
	}
	if( xp == NULL )
		xp = np;

	if( ignspace ){
		while( isspace(*xp) )
			xp++;
	}
	return xp;
}
exec_metassi(ctx,av,ev,fc,tc,htfp)
	void *ctx;
	char *av[],*ev[];
	FILE *fc,*tc,*htfp;
{	int leng;
	char line[1024],xline[0x10000];
	char *sp,*np,*xp;
	char *tagp,*attrp;
	char tag[256],aname[256],avalue[1024];
	int uconv0,uconv;
	char Status[256],Header[2048];
	int ignspace;
	Mssg mssg;
	int cleng;

	sv1log("## eval META & SSI\n");
	leng = 0;

	uconv0 = TAGCONV_SSI | TAGCONV_META;

	strcpy(mssg.f_timefmt,TIMEFORM_RFC822);
	mssg.h_status[0] = 0;
	mssg.h_contype[0] = 0;
	mssg.h_header[0] = 0;
	mssg.m_body = TMPFILE("SSI");

	while( fgets(line,sizeof(line),htfp) != NULL ){
		sp = line;
		xp = xline;
		for(;;){
			uconv = uconv0;
			np = html_nextTagAttr(sp,"",NULL,&tagp,&attrp,&uconv);
			if( np == NULL )
				break;

			if( tagp == NULL ){
				fwrite(sp,1,np-sp,mssg.m_body);
				sp = np;
				continue;
			}

			fwrite(sp,1,tagp-sp,mssg.m_body);
			ignspace = 0;

			wordScan(tagp,tag);
			aname[0] = 0;
			wordscanY(attrp,aname,sizeof(aname),"^=");
			if( np[-1] == '"' ){
				np = valuescanX(np-1,avalue,sizeof(avalue));
				if( *np == '"' )
					np++;
			}else	np = valuescanX(np,avalue,sizeof(avalue));

			if( strcaseeq(tag,"<!--#echo") ){
				SSI_echo(ctx,ev,tag+5,aname,avalue,htfp,&mssg);
			}else
			if( strcaseeq(tag,"<!--#config") ){
				SSI_config(ctx,ev,tag+5,aname,avalue,htfp,&mssg);
			}else
			if( strcaseeq(tag,"<!--#include")
			 || strcaseeq(tag,"<!--#fsize")
			 || strcaseeq(tag,"<!--#flastmod")
			){
				SSI_file(ctx,ev,tag+5,aname,avalue,htfp,&mssg);
			}else
			if( strcaseeq(tag,"<!--#exec") ){
				SSI_exec(ctx,ev,tag+5,aname,avalue,htfp,&mssg);
			}else
			if( strcaseeq(tag,"<META") ){
				ignspace = 1;
				META_eval(ctx,ev,tagp+1,aname,avalue,htfp,&mssg);
			}

			sp = seekeot(tagp,np,ignspace);
		}
		strcpy(xp,sp);
		fputs(xline,mssg.m_body);
		leng += strlen(xline);
	}

	fflush(mssg.m_body);
	cleng = ftell(mssg.m_body);
	fseek(mssg.m_body,0,0);

	fprintf(tc,"HTTP/%s ",MY_HTTPVER);
	if( mssg.h_status[0] == 0 )
		fprintf(tc,"200 OK\r\n");
	else	fputs(mssg.h_status,tc);

	if( getKeepAlive(ctx,line) )
		fprintf(tc,"%s",line);
	else	fprintf(tc,"Connection: close\r\n");

	fprintf(tc,"Content-Type: ");
	if( mssg.h_contype[0] == 0 )
		fprintf(tc,"text/html\r\n");
	else	fputs(mssg.h_contype,tc);

	fprintf(tc,"Content-Length: %d\r\n",cleng);

	fputs(mssg.h_header,tc);
	fputs("\r\n",tc);
	copyfile1(mssg.m_body,tc);
	fclose(mssg.m_body);

	sv1log("SSI %do / %di\n",cleng,leng);
	return cleng;
}
