/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Yutaka Sato
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	shutter.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	991209	extracted from delegated.c
//////////////////////////////////////////////////////////////////////#*/
#include "vsignal.h"
#include "delegate.h"
#include <errno.h>

#define SHUTOUT	"${ADMDIR}/shutout"
int SHUTOUT_TIMEOUT = 30*60;

static FILE *stopServ(what,mode,host)
	char *what,*mode,*host;
{	char path[1024];
	FILE *fp;

	if( host == 0 )
		return 0;

	sprintf(path,"%s/%s",SHUTOUT,host);
	DELEGATE_substfile(path,"",NULL,NULL,NULL);
	fp = dirfopen(what,path,mode);
	if( fp == NULL )
		return 0;
	daemonlog("F","#### %s [%s]\n",what,path);
	return fp;
}

static struct {
	int	cl_sock;
	char   *cl_addr;
	int	cl_port;
    Connection *cl_Conn;
} curClient;

static FILE *setStopService(addr)
	char *addr;
{
	daemonlog("F","####! EMERGENCY STOP !####\n");
	return stopServ("setStopService","a",addr);
}
static getStopService(Conn,addr)
	Connection *Conn;
	char *addr;
{	FILE *fp;
	int mtime,now;

	fp = stopServ("getStopService","r",addr); 
	if( fp == NULL )
		return 0;
	mtime = file_mtime(fileno(fp));
	fclose(fp);
	if( SHUTOUT_TIMEOUT ){
		now = time(NULL);
		if( SHUTOUT_TIMEOUT < now-mtime ){
			daemonlog("F","#### getStopService: expired = %d > %d\n",
				now-mtime,SHUTOUT_TIMEOUT);
			return 0;
		}
	}
	return 1;
}
/*
 * hold the connection untill closed by the intruder
 * behaving like /bin/sh ...
 */
static holder(log)
	FILE *log;
{	FILE *fc,*tc;
	char line[256],com[256];
	char date[64];

	fc = fdopen(curClient.cl_sock,"r");
	tc = fdopen(curClient.cl_sock,"w");
	while( 0 < fPollIn(fc,0) ){
		if( fgets(line,sizeof(line),fc) == NULL )
			break;
		if( log ){
			StrftimeLocal(date,sizeof(date),TIMEFORM_mdHMS,time(0));
			fprintf(log,"%s: %s",date,line);
			fflush(log);
		}
		wordScan(line,com);
		fprintf(tc,"%s: not found\n",com);
		fflush(tc);
		sleep(1);
	}
}

static char *introFATAL = "\
To administrator:\n\
  Remove this file to restart the service for \"%s\"\n\
This file was created on a fatal error detected in DeleGate,\n\
which COULD BE the result of an ATTACK from the host.\n\
More likely, it can be a usual bug in DeleGate.\n\
See LOGDIR/abort/%s, and consult with the author if necessary.\n\
(You can specify the varidity of shutout like TIMEOUT=shutout:60s)\n\
--\n";

static logFATAL(log,reason,clnt,serv)
	FILE *log;
	char *reason,*clnt,*serv;
{	Connection *Conn = curClient.cl_Conn;
	char date[64],port[256];

	printPrimaryPort(port);
	fprintf(log,introFATAL,clnt,port);
	fflush(log);
	StrftimeLocal(date,sizeof(date),TIMEFORM_mdHMS,time(0));
	fprintf(log,"%s: [%d] reason=%s src=%s dst=%s\n",date,getpid(),
		reason,clnt,serv);
	fflush(log);
	fprintf(log,"%s: [%d] SERVER=%s\n",date,getpid(),DST_PROTO);
	if( DST_HOST[0] ){
		fprintf(log,"%s: [%d] SERVER=%s://%s:%d\n",date,getpid(),
			DST_PROTO,DST_HOST,DST_PORT);
		fflush(log);
	}
	fflush(log);
}
static int exiting;
void exitFATAL(sig)
{	FILE *clog,*slog;
	char reason[32];
	char *clnt,serv[256],*dp;
	int servport;
	Connection *Conn = curClient.cl_Conn;
	Connection ConnBuf;

	if( exiting != 0 )
		return;
	exiting = 1;

	signal(sig,SIG_DFL);

	sprintf(reason,"SIG%s",sigsym(sig));
	if( Conn == NULL ){
		Conn = &ConnBuf;
		bzero(Conn,sizeof(Conn));
	}

	if( sig == SIGSEGV && errno == ENOMEM ){
		syslog_ERROR("#### EXIT on insufficient memory, exceeded data or stack limitation, or exausted swap space. ####\n");
		Finish(-1);
	}

	serv[0] = 0;
	if( 0 < ToS && IsConnected(ToS,NULL) ){
		if( getpeerName(ToS,serv,"%A:%P") ){
			dp = strchr(serv,':');
			*dp++ = 0;
			servport = atoi(dp);
		}
	}

	clnt = curClient.cl_addr;
	clog = setStopService(clnt);
	if( clog )
		logFATAL(clog,reason,clnt,serv);

	if( serv[0] && (slog = setStopService(serv)) ){
		logFATAL(slog,reason,clnt,serv);
		fclose(slog);
	}
	notify_ADMIN(Conn,reason);

	if( curClient.cl_sock < 0 ){
		DELEGATE_sigFATAL(sig);
		Finish(-1);
	}
	ProcTitle(Conn,"INTRUDER !? %s",reason);
	if( Fork("FATAL") == 0 ){
		DELEGATE_sigFATAL(sig);
		Finish(-1);
	}
	wait(0);
	/* send mail to ADMIN ... */
	holder(clog);
	ProcTitle(Conn,"INTRUDER !? disconnected");
	sleep(60);
	Finish(0);
}

static putStopInfo(Conn)
	Connection *Conn;
{	char mssg[1024];

	mssg[0] = 0;
	/* set protocol dependent header */
	sprintf(mssg+strlen(mssg),
"Services for your host[%s] are suspended now on a suspicion of intruder.\r\n",
		curClient.cl_addr);

	if( source_permitted(Conn) )
	sprintf(mssg+strlen(mssg),
"Ask your administrator <%s> to check %s/%s\r\n",
		getADMIN1(),SHUTOUT,curClient.cl_addr);

	write(curClient.cl_sock,mssg,strlen(mssg));
}

extern int execGeneralist1();
execGeneralist(Conn,fromC,toC,svsock)
	Connection *Conn;
{	char addrport[256],*dp;
	int port,rcode;

	randenv();
/*
	if( getpeerName(fromC,addrport,"%A:%P") ){
*/
	if( getpeerName(ClientSock,addrport,"%A:%P") ){
		dp = strchr(addrport,':');
		*dp++ = 0;
		curClient.cl_sock = toC;
		Strdup(&curClient.cl_addr,addrport);
		curClient.cl_port = atoi(dp);
		curClient.cl_Conn = Conn;
		if( getStopService(Conn,curClient.cl_addr) ){
			putStopInfo(Conn);
			return -1;
		}
	}else{
	}
	signal(SIGILL, exitFATAL);
	signal(SIGTRAP,exitFATAL);
	signal(SIGEMT, exitFATAL);
	signal(SIGFPE, exitFATAL);
	signal(SIGSEGV,exitFATAL);
	signal(SIGBUS, exitFATAL);
	rcode = randstack_call(SB_CONN,execGeneralist1,Conn,fromC,toC,svsock);
	curClient.cl_sock = -1;
	return rcode;
}

abort()
{
	exitFATAL(SIGQUIT);
	sleep(1);
	Kill(getpid(),SIGQUIT);
	_exit(0);
}
