/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	shio.o (sh I/O)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

	Usage:	shio scriptfile
		shio scriptfile:label

MASTER=${MASTER}
TUNNEL=type:script
TUNNEL=tty7:/usr/local/etc/delegate.login

History:
	940730	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <signal.h>
#include <string.h>
char *getenv();

int shio_debug = 0;

static Dprintf(fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{
	if( shio_debug )
		fprintf(stderr,fmt,a,b,c,d,e,f,g);
}
static Fprintf(fp,fmt,a,b,c)
	FILE *fp;
	char *fmt,*a,*b,*c;
{
	fprintf(fp,fmt,a,b,c);
	fflush(fp);
	Dprintf("<= ");
	Dprintf(fmt,a,b,c);
}

/*
if( env = getenv("MASTER") )
sprintf(args+strlen(args)," MASTER=%s",env);
*/

static char **script_buf;

shiobar(script, id)
	char *script;
	char *id;
{	FILE *Script;
	int si;
	char line[1024],dline[1024];
	char *sp,*dp;
	char *malloc();
	char xscript[1024];

	if( fullpathLIB(script,"r",xscript) )
		script = xscript;
	Script = fopen(script,"r");
	if( Script == NULL ){
		fprintf(stderr,"cannot open:%s\n",script);
		exit(-1);
	}

	if( script_buf == NULL )
		script_buf = (char**)calloc(512,sizeof(char*));

	si = 0;
	while( fgets(line,sizeof(line),Script) != NULL ){
		if( *line == '#' || *line == '\n' )
			continue;
		if( *line == ':' )
			continue;

		dp = dline;
		for( sp = line; *sp; sp++ ){
			if( *sp == '\n' && sp[1] == 0 )
				break;
			if( *sp == '\\' ){
				switch( sp[1] ){
					case 'n':  *dp++ = '\n'; break;
					case 'r':  *dp++ = '\r'; break;
					default:   *dp++ = sp[1]; break;
				}
				sp += 1;
			}else	*dp++ = *sp;
		}
		*dp = 0;
		script_buf[si++] = strcpy(malloc(strlen(dline)+1),dline);
	}
	shiobar1(script_buf);
}

shiobar1(script)
	char *script[];
{	int tocu[2],fromcu[2];

	if( script[0][0] == 'c' ){
		char host[256];
		int port,sock;
		port = scan_hostport1X(script[0]+2,host,sizeof(host));
		sock = OpenServer("SHIO","tcprelay",host,port);
		loginproc(&script[1],sock,sock);
		return;
	}

	pipe(tocu);
	pipe(fromcu);
	if( vfork() == 0 ){
		close(fromcu[0]);
		close(tocu[1]);

		dup2(fromcu[1],2);
		dup2(fromcu[1],1);
		dup2(tocu[0],0);

		execl("/bin/sh","sh",0);
		exit(-1);
	}

	close(fromcu[1]);
	close(tocu[0]);
	loginproc(script,fromcu[0],tocu[1]);
}

static put_file(out,file)
	FILE *out;
	char *file;
{	FILE *fp;
	char buff[1024];
	int rc;

	if( fp = fopen(file,"r") ){
		while( rc = fread(buff,1,sizeof(buff),fp) )
			fwrite(buff,1,rc,out);
	}
}
static relay_blocks(in,out,size)
{	char buff[1024];
	int rc;

	if( fork() == 0 ){
		while( rc = read(in,buff,sizeof(buff)) ){
			fwrite(buff,1,rc,stdout);
			fflush(stdout);
		}
	}else{
		FILE *Out;
		Out = fdopen(out,"w");
		while( 0 < (rc = read(fileno(stdin),buff,sizeof(buff))) ){
			fwrite(buff,1,rc,Out);
			fflush(Out);
		}
	}
}
loginproc(script,in,out)
	char *script[];
{	int si;
	char *sl,*cp;
	int ch;
	int len;
	int ilen;
	char inbuf[256];
	FILE *In,*Out;

	In = fdopen(dup(in),"r");
	setbuf(In,NULL);
	Out = fdopen(dup(out),"w");
	setbuf(Out,NULL);

	Dprintf(">> ");
	for(si = 0; sl = script[si]; si++){
		switch( sl[0] ){
			case 'b':
				relay_blocks(dup(in),dup(out),atoi(&sl[2]));
				break;

			case '=':
fclose(In);
fclose(Out);
				frelay(0,in,fileno(stdout),fileno(stdin),out,NULL);
exit(0);
				break;

			case 'o':
				if( si == 0 )
					Dprintf("%s",sl+2);
				fputs(sl+2,Out);
				break;
			case 'p':
				put_file(Out,sl+2);
				break;

			case 'm':
				msleep(atoi(sl+2));
				break;
			case 's':
				sleep(atoi(sl+2));
				break;

			case 'i':
			len = strlen(sl+2);
			ilen = 0;
			for(;;){
				ch = fgetc(In);
				if( ch == '\r' )
					Dprintf("^M");
				else	Dprintf("%c",ch);

				if( ch == '\n' )
					Dprintf(">> ");
				if( ch == EOF )
					break;

				if( len <= ilen ){
					strcpy(inbuf,inbuf+1);
					inbuf[ilen-1] = ch;
				}else	inbuf[ilen++] = ch;
				inbuf[ilen] = 0;

if( 2 <= shio_debug ){
Dprintf("[");
xputs(sl+1);
Dprintf("][");
xputs(inbuf);
Dprintf("]\n");
}
				if( len == ilen )
				if( strcmp(inbuf,sl+2) == 0 )
					break;
			}
			break;

			case '$':
				/* skip untill EOL */
				break;
		}
	}
}


xputs(s)
	char *s;
{
	while(*s){
		if(*s < 0x20)
			Dprintf(stderr,"^%c",*s+0x40);
		else	Dprintf(stderr,"%c",*s);
		s++;
	}
}

void gotsig(sig)
{
	fprintf(stderr,"(%d done)\n",getpid());
/*
	Killpg(getpid(),SIGTERM);
*/
	killpg(getpid(),SIGTERM);
	exit(0);
}
shio_main(ac,av)
	char *av[];
{	int ai;
	char *arg;
	char *script = 0;

	signal(SIGINT,gotsig);
	signal(SIGTERM,gotsig);

	if( isatty(0) )
		shio_debug = 1;

	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		if( strncmp(arg,"-d",2) == 0 ){
			if( (shio_debug = atoi(arg+2)) == 0 )
				shio_debug = 1;
		}else	script = arg;
	}
	if( script == 0 ){
		fprintf(stderr,"Usage: %s script-file\n",av[0]);
		exit(-1);
	}
	shiobar(script);
}
