/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Yutaka Sato
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose and
without fee is hereby granted, provided that the above copyright notice
and this permission notice appear in all copies.
//////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	rident.c (remote ident)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	971217	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "vsocket.h"

#define RIDENT_SIZE	64
#define RIDENT_MAGIC		"RIDENT/"
#define RIDENT_MAGIC_LEN	(sizeof(RIDENT_MAGIC)-1)
#define RIDENT_VER		"0.9"

#include "vaddr.h"
RidentEnv ridentEnv = {1.0,0,0};

static rident1(spec)
	char *spec;
{
	if( *spec == 'c' ) RIDENT_CLIENT = 1;
	else
	if( *spec == 's' ) RIDENT_SERVER = 1;
	else
	{
		sv1tlog("ERROR: unknown RIDENT=%s\n",spec);
	}
	return 0;
}
/*
scan_RIDENT(specs)
*/
scan_RIDENT(Conn,specs)
	void *Conn;
	char *specs;
{
	if( specs != NULL )
	{
		xmem_push(&ridentEnv,sizeof(RidentEnv),"RIDENT",NULL);
		scan_commaListL(specs,0,rident1);
	}
}

static char *username;
RIDENT_sendX(sock,sockname,peername,ident)
	char *sockname,*peername;
	char *ident;
{	char rident[128];
	int wcc;

	if( ident == NULL ){
		if( username == 0 )
			username = (char*)StructAlloc(128);
		if( username[0] == 0 )
			getUsername(getuid(),username);
		ident = username;
	}
	sprintf(rident,"%s%s %s %s %s %64s",RIDENT_MAGIC,RIDENT_VER,
		sockname,peername,ident," ");
	strcpy(rident+62,"\r\n");
	wcc = write(sock,rident,RIDENT_SIZE);
	RIDENT_SENT = wcc;
	return wcc;
}
RIDENT_send(sock,sockname,peername,ident)
	char *sockname,*peername;
	char *ident;
{
	if( RIDENT_SERVER == 0 )
		return 0;
	return RIDENT_sendX(sock,sockname,peername,ident);
}
RIDENT_recv(clsock,sockname,peername)
	char *sockname,*peername;
{	unsigned char rident[128],ver[128],user[128];
	int rcc;
	int ready;
	int timeout;

	if( RIDENT_CLIENT == 0 ){
		getpairName(clsock,sockname,peername);
		return 0;
	}

	rident[0] = 0;
	timeout = (int)(RIDENT_TIMEOUT*1000);
	if( timeout <= 0 )
		timeout = 1;
	ready = PollIn(clsock,timeout);
	if( ready <= 0 ){
		sv1log("####[%d] getRIDENT TIMEOUT(%dms)\n",clsock,timeout);
/*
		close(clsock);
		return -1;
*/
		goto EXIT;
	}
	rcc = recv(clsock,rident,RIDENT_SIZE,MSG_PEEK);
	RIDENT_RCVD = rcc;

	if( RIDENT_MAGIC_LEN <= rcc )
	if( strncmp(rident,RIDENT_MAGIC,RIDENT_MAGIC_LEN) == 0 ){
		rcc = read(clsock,rident,RIDENT_SIZE);
		sockname[0] = peername[0] = user[0] = 0;
		if( rcc == RIDENT_SIZE )
		if( 3 <= sscanf(rident+RIDENT_MAGIC_LEN,"%s %s %s %s",
			ver,sockname,peername,user) )
		if( strcmp(ver,RIDENT_VER) == 0 ){
			sv1log("#### getRIDENT %d[%s][%s][%s]\n",
				rcc,sockname,peername,user);
			return 1;
		}
		sv1log("#### getRIDENT Version/Syntax Error\n");
		return -1;
	}
EXIT:
	getpairName(clsock,sockname,peername);
	return 0;
}
