/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Yutaka Sato
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	notify.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

    category
	emergent
	infomational
	periodical report
	...

History:
	991207	created
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
extern char *TIMEFORM_RFC822;
extern char *DELEGATE_verdate();
extern FILE *TMPFILE();
extern int START_TIME;
extern char *getADMIN1();

notify_ADMIN(xConn,what)
	Connection *xConn;
	char *what;
{
	notify_ADMINX(xConn,getADMIN1(),what,"");
}
notify_ADMINX(xConn,admin,what,body)
	Connection *xConn;
	char *admin;
	char *what;
	char *body;
{	FILE *tmp;
	FILE *bt;
	Connection ConnBuff,*Conn = &ConnBuff;
	char head[1024],me[128],date[128],load[128];
	char cwd[1024];
	char uname[128];
	int now;
	char *bugbox = "bugs@delegate.org";

	if( strncasecmp(what,"sig",3) != 0 )
	if( strncasecmp(what,"modified",8) != 0 )
	if( strncasecmp(what,"approved",8) != 0 )
	if( strncasecmp(what,"detected",8) != 0 )
		return;

	if( admin == NULL || *admin == 0 )
		admin = getADMIN1();

	now = time(NULL);
	if( xConn )
		*Conn = *xConn;
	else	bzero(Conn,sizeof(Connection));
	tmp = TMPFILE("NOTIFY");

	head[0] = 0;
	if( gethostname(me,sizeof(me)) != 0 )
		strcpy(me,"?");
	StrftimeLocal(date,sizeof(date),TIMEFORM_RFC822,now);
	sprintf(head+strlen(head),"Subject: DeleGate-Report: %s\r\n",what);
	sprintf(head+strlen(head),"From: [%d]@%s\r\n",getuid(),me);
	sprintf(head+strlen(head),"Reply-To: %s\r\n",bugbox);
	sprintf(head+strlen(head),"Date: %s\r\n",date);
	fprintf(tmp,"%s\r\n",head);
	fprintf(tmp,"PLEASE FORWARD THIS MESSAGE TO <%s>.\r\n",bugbox);
	fprintf(tmp,"IT WILL BE HELPFUL FOR DEBUGGING.\r\n");
	fprintf(tmp,"\r\n");
	fprintf(tmp,"%s",head);
	fprintf(tmp,"Event: %s\r\n",what);
	Uname(uname);
	fprintf(tmp,"Version: %s (%s)\r\n",DELEGATE_verdate(),uname); 
	fprintf(tmp,"Host: %s\r\n",me);
	fprintf(tmp,"Owner: uid=%d/%d, gid=%d/%d\r\n",
		geteuid(),getuid(),getegid(),getgid());
	StrftimeLocal(date,sizeof(date),TIMEFORM_RFC822,START_TIME);
	fprintf(tmp,"Started: %s\r\n",date);
	fprintf(tmp,"Pid: %d\r\n",getpid());
	cwd[0] = 0;
	getcwd(cwd,sizeof(cwd));
	fprintf(tmp,"Cwd: %s\r\n",cwd);
	strfLoadStat(load,sizeof(load),"%L (%l)",now);
	fprintf(tmp,"Load: %s\r\n",load);
	fprintf(tmp,"\r\n");
	fprintf(tmp,"%s\r\n",body);

	if( strncasecmp(what,"sig",3) == 0 ){
		fprintf(tmp,"--AbortLog--begin\r\n");
		putAbortLog(tmp);
		fprintf(tmp,"--AbortLog--end\r\n");

		fprintf(tmp,"\r\n");
		fprintf(tmp,"--BackTrace--begin\r\n");
		fflush(tmp);
		bt = TMPFILE("BackTrace");
		putBackTrace(bt);
		fseek(bt,0,0);
		copyfile1(bt,tmp);
		fclose(bt);
		fprintf(tmp,"\r\n");
		fprintf(tmp,"--BackTrace--end\r\n");
	}

	fflush(tmp);
	fseek(tmp,0,0);
	Conn->co_mask = (CONN_NOPROXY | CONN_NOMASTER); 
	sendmail1(Conn,admin,admin,tmp,NULL);
	fclose(tmp);
}

putBackTrace(out)
	FILE *out;
{	char pid[32];
	int cpid,Cpid,nready,xpid;
	int pipes[2],psync[2];
	char command[128];
	char *path;

	if( INHERENT_fork() == 0 )
		return;

	pipe(psync);
	if( (Cpid = fork()) == 0 ){ /* the clone to be traced */
		close(psync[1]);
		PollIn(psync[0],10*1000);
		_exit(0);
	}

	sprintf(pid,"%d",Cpid);
	sprintf(command,"where\nquit\n");

	pipe(pipes);
	if( (cpid = fork()) == 0 ){
		close(pipes[1]);
		dup2(pipes[0],0);
		dup2(fileno(out),1);
		dup2(fileno(out),2);
		execlp("dbx","dbx","-q",EXEC_PATH,pid,0L);
		execlp("gdb","gdb","-q",EXEC_PATH,pid,0L);
		path = getenv("PATH");
		fprintf(out,"#### error: no dbx nor gdb in PATH=%s\n",
			path?path:"");
		exit(-1);
	}
	close(pipes[0]);
	write(pipes[1],command,strlen(command));
	close(psync[1]);
	nready = PollIn(psync[0],10*1000);
	close(psync[0]);
	close(pipes[1]);
	xpid = NoHangWait();

	Kill(Cpid,9);
	if( nready == 0 || xpid != cpid ){
		fprintf(out,"#### error: nready=%d xpid=%d/%d/%d\n",
			nready,xpid,cpid,Cpid);
	}
}

notify_overflow(what,buf,off)
	char *buf;
{	char msg[1024],*mp,*mx;
	int ci,ch;

	mx = msg + (sizeof(msg)-1);
	mp = msg;
	for( ci = 0; ci < off; ci++ ){
		if( mx <= mp )
			break;
		ch = buf[ci] & 0xFF;
		if( 0x40 <= ch && ch < 0x7F || ch == ' ' ){
			*mp++ = ch;
		}else{
			sprintf(mp,"%%%02X",ch);
			mp += 3;
		}
	}
	*mp = 0;
	daemonlog("F","#### Overflow: %s: %d: %s\n",what,off,msg);
}

