/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	misc.c (miscellaneous functions)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	March94	creatd
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "ystring.h"

/*
 * fclose(FILE *fp) without closing fileno(FILE *fp)
 */
fcloseFILE(fp)
	FILE *fp;
{	int fd,fdsav;

	fd = fileno(fp);
	fdsav = dup(fd);
	fclose(fp);
	close(fd); /* do closesocket() on Win32 */
	dup2(fdsav,fd);
	close(fdsav);
	return fd;
}

extern FILE *NULLFP();
/*
 * close(fileno(FILE *fp)) without closing FILE *fp
 */
closeFDs(ifp,ofp)
	FILE *ifp,*ofp;
{	int xfd,ofd,ifd;

	xfd = dup(fileno(NULLFP()));
	ofd = -1;
	if( ofp != NULL ){
		ofd = fileno(ofp);
		close(ofd);
		dup2(xfd,ofd);
	}
	ifd = -1;
	if( ifp != NULL && fileno(ifp) != ofd ){
		ifd = fileno(ifp);
		close(ifd);
		dup2(xfd,ifd);
	}
	sv1vlog("###### closeFDs(%d/%X,%d/%X) %d\n",
		ifd,ifp,ofd,ofp,xfd);
	close(xfd);
}

copy_file(sfp,dfp,cfp)
	FILE *sfp,*dfp,*cfp;
{	int rcc;
	char buff[1023];
	int totalc;

	totalc = 0;
	for(;;){
		rcc = fread(buff,1,sizeof(buff),sfp);
		if( rcc == 0 )
			break;
		totalc += rcc;
		if( cfp ){ if(fwrite(buff,1,rcc,cfp)==0) break; }
		if( dfp ){ if(fwrite(buff,1,rcc,dfp)==0) break; }
		if( dfp && ready_cc(sfp) == 0 )
			if( fflushTIMEOUT(dfp) == EOF )
				break;
	}
	if( dfp ) fflush(dfp);
	if( cfp ) fflush(cfp);
	return totalc;
}
copy_fileTIMEOUT(sfp,dfp,cfp)
	FILE *sfp,*dfp,*cfp;
{	int rcc;
	char buff[1024];
	int totalc;

	totalc = 0;
	for(;;){
		if( feof(sfp) )
			break;
		rcc = freadTIMEOUT(buff,1,sizeof(buff),sfp);
		if( rcc == 0 )
			break;
		totalc += rcc;
		if( dfp ){ if(fwriteTIMEOUT(buff,1,rcc,dfp)==0) break; }
		if( dfp ){ if(fflushTIMEOUT(dfp) == EOF) break; }
		if( cfp ){ if(fwriteTIMEOUT(buff,1,rcc,cfp)==0) break; }
	}
	if( dfp ) fflushTIMEOUT(dfp);
	if( cfp ) fflushTIMEOUT(cfp);
	return totalc;
}

Fprintf(fp,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	FILE *fp;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{	char buf[0x10000];

	sprintf(buf,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
	fputs(buf,fp);
	return strlen(buf);
}

static cmpstr(s1p,s2p)
	char **s1p,**s2p;
{
	return strcmp(*s1p,*s2p);
}
static cmpstr_reverse(s1p,s2p)
	char **s1p,**s2p;
{
	return strcmp(*s2p,*s1p);
}

extern FILE *TMPFILE();
sort_file(src,dst,rev)
	FILE *src,*dst;
{	FILE *tmp;
	char line[4096];
	char *lines[0x10000];
	int nlines,li;

	if( src == dst )
		tmp = dst = TMPFILE("SORT");
	else	tmp = NULL;

	fseek(src,0,0);
	for( nlines = 0; fgets(line,sizeof(line),src); nlines++ )
		lines[nlines] = stralloc(line);

	if( rev )
		qsort(lines,nlines,sizeof(char*),cmpstr_reverse);
	else	qsort(lines,nlines,sizeof(char*),cmpstr);

	fseek(dst,0,0);
	for( li = 0; li < nlines; li++ ){
		fputs(lines[li],dst);
		free(lines[li]);
	}
	fflush(dst);

	if( tmp != NULL ){
		fseek(src,0,0);
		fseek(tmp,0,0);
		copy_file(tmp,src,NULL);
		fclose(tmp);
		fflush(src);
	}
}

doXECHO(tc,dp)
	FILE *tc;
	char *dp;
{	char *ip,*op;

	op = dp;
	for( ip = dp; *ip; ip++ ){
		if( *ip == '\\' ){
			switch( ip[1] ){
				case 'r': *op++ = '\r'; ip++; continue;
				case 'n': *op++ = '\n'; ip++; continue;
			}
		}
		if( op != ip )
			*op++ = *ip;
		else	op++;
	}
	if( *op != 0 ) *op = 0;
	fputs(dp,tc);
}
