/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	master.c (routing and access control)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	March94	created
	941002	merged proxy.c(created 940316)
	990824	integrated all routing tables into a single structure
//////////////////////////////////////////////////////////////////////#*/
#include "hostlist.h"
#include "delegate.h"
#include "url.h"
#include "filter.h"
#include "ystring.h"

#define MAXPROTO	64
/* protoV should be realized as a bit-map for screening ... */

extern addHostList1();
extern char **dupv();
extern char *getClientUserC();
#define Ident()	getClientUserC(Conn)
extern AuthInfo *getClientIdentX();
int DO_METHOD_FILTER;

typedef struct {
	char	 *p_name;
	int	  p_portN;
	int	 *p_portV;
	int	  p_negate;
	char	 *p_methods;
} Server;

typedef struct {
	char	 *m_gw_proto;	/* client side protocol of the gateway */
	char	 *m_gw_host;	/* host name of the gateway */
	int	  m_gw_port;	/* port number of the gateway */
	char	 *m_gw_path;	/* base path of the gateway */
	char	 *m_conn;
	Server	 *m_protoV;
	int	  m_protoV_NonHTTP;
	HostList  m_hostlist[2]; /* should be URLs ? */
	int	  m_teleport;
	int	  m_cacheonly;
	char	 *m_owner;
	char	 *m_Version;
	char	 *m_SERVER;
} Route;

#define RX_DST	0
#define RX_SRC	1
#define m_dsts	m_hostlist[RX_DST]
#define m_srcs	m_hostlist[RX_SRC]

#define RT_INCSIZE	16
typedef struct {
	char   *rt_name;
	int	rt_size;
	int	rt_filled;
	int	rt_withsrc;
	Route **rt_routes;
} RouteTab;

static RouteTab routeTabs[] = {
	{ "REMITTABLE"	},
	{ "REACHABLE"	},
	{ "RELIABLE"	},
	{ "USERIDENT"	},
	{ "CMAP"	},
	{ "PERMIT"	},
	{ "MASTER"	},
	{ "CONNECT"	},
	{ "ROUTE"	},
	{ "UCPROXY"	},
	{ "OWNER"	},
	{ "NOTIFYPLTFM"	},
	{ "SRCIF"	},
	{ "REJECT"	},
};
#define R_REMITTABLE	0	/* List of acceptable protocols */
#define R_REACHABLE	1	/* Hosts acceptable as destination */
#define R_RELIABLE	2	/* Hosts acceptable as source */
#define R_USERIDENT	3	/* Hosts with Ident */
#define R_CMAP		4	/* general CMAP */
#define R_PERMIT	5	/* acceptable proto:dst:src */
#define R_MASTER	6	/* route for master */
#define R_CONNECT	7	/* order of connection trials */
#define R_ROUTE		8	/* route for gateways */
#define R_PROXY		9	/* unconditional PROXY */
#define R_OWNER		10	/* changing process owner */
#define R_NOTIFYPLTFM	11	/* notify platform of DeleGate */
#define R_SRCIF		12	/* source address of connection */
#define R_REJECT	13	/* reject proto:dst:src */

#define RT_ROUTE(rtx)	(&routeTabs[rtx])
#define RT_INDEX(rtx)	routeTabs[rtx].rt_filled
#define RT_TABLE(rtx)	routeTabs[rtx].rt_routes

#define RemittableRoute	RT_ROUTE(R_REMITTABLE)
#define RemittableV	RT_ROUTE(R_REMITTABLE)->rt_routes[0]->m_protoV
#define Remittable	RT_ROUTE(R_REMITTABLE)->rt_routes?RemittableV:0

#define MasterRoute	RT_ROUTE(R_MASTER)
#define MasterX		RT_INDEX(R_MASTER)
#define Masters		RT_TABLE(R_MASTER)

#define MapRoute	RT_ROUTE(R_CMAP)
#define MapX		RT_INDEX(R_CMAP)
#define Maps		RT_TABLE(R_CMAP)

#define ForwardRoute	RT_ROUTE(R_ROUTE)
#define ForwardX	RT_INDEX(R_ROUTE)
#define Forwards	RT_TABLE(R_ROUTE)

#define PermitRoute	RT_ROUTE(R_PERMIT)
#define PermitX		RT_INDEX(R_PERMIT)
#define Permits		RT_TABLE(R_PERMIT)

#define ConnectRoute	RT_ROUTE(R_CONNECT)
#define ConnectX	RT_INDEX(R_CONNECT)
#define Connects	RT_TABLE(R_CONNECT)

#define OwnerRoute	RT_ROUTE(R_OWNER)
#define OwnerX		RT_INDEX(R_OWNER)
#define Owners		RT_TABLE(R_OWNER)

#define SrcifRoute	RT_ROUTE(R_SRCIF)
#define SrcifX		RT_INDEX(R_SRCIF)
#define Srcif		RT_TABLE(R_SRCIF)

#define RejectRoute	RT_ROUTE(R_REJECT)
#define RejectX		RT_INDEX(R_REJECT)
#define Rejects		RT_TABLE(R_REJECT)


static newRoute(rt)
	RouteTab *rt;
{	int osize,nsize,nbytes,ri,rx;
	Route **routes;

	if( rt->rt_size <= rt->rt_filled ){
		osize = rt->rt_size;
		nsize = osize + RT_INCSIZE;
		nbytes = nsize * sizeof(Route*);
		routes = (Route**)Malloc(rt->rt_routes,nbytes);
		bzero(&routes[osize],(nsize-osize)*sizeof(Route*));
		rt->rt_routes = routes;
		rt->rt_size = nsize;
	}
	rx = rt->rt_filled++;
	rt->rt_routes[rx] = NewStruct(Route);
	Verbose("#### newRoute[%s] %d/%d\n",rt->rt_name,rx,rt->rt_size);
	return rx;
}

static scanProtoPort(protoport,proto,ports,methods)
	char *protoport,*proto,*ports,*methods;
{	char buf[1024],*pv[4];
	int ne;

	strcpy(buf,protoport);
	if( strchr(buf,':') )
		ne = stoV(buf,3,pv,':');
	else	ne = stoV(buf,3,pv,'/');
	proto[0] = ports[0] = methods[0] = 0;
	if( 1 <= ne ) strcpy(proto,pv[0]);
	if( 2 <= ne ) strcpy(ports,pv[1]);
	if( 3 <= ne ) strcpy(methods,pv[2]);
	return ne;
}
static Server *makeProtoV(protoV,protov)
	Server *protoV;
	char **protov;
{	int ni,np,nj,nn,nx;
	char *proto1,*p1,proto[64],ports[1024];
	char *nprotov[MAXPROTO];
	char methods[512];
	char *portv[MAXPROTO];
	int match,neg;

	for( np = 0; protov[np]; np++);
	if( protoV != NULL ){
		for( nx = 0; protoV[nx].p_name; nx++ );
		nn = 0;
		for( ni = 0; ni < np; ni++ ){
			p1 = protov[ni];
			match = 0;
			for( nj = 0; nj < nx; nj++ ){
				if( strcaseeq(protov[ni],protoV[nj]) ){
					match = 1;
					break;
				}
			}
			if( !match )
				nprotov[nn++] = p1;
		}
		if( nn == 0 )
			return protoV;
		protov = nprotov;
		np = nn;
		protoV = (Server*)realloc(protoV,sizeof(Server)*(nx+nn+1));
	}else{
		protoV = (Server*)calloc(sizeof(Server),np+1);
		nx = 0;
	}

	for( ni = 0; ni < np; ni++ ){
		proto1 = protov[ni];
		if( neg = *proto1 == '-' )
			proto1++;
		scanProtoPort(proto1,proto,ports,methods);
		if( neg ){
			/* remove if in the protoV */
			continue;
		}
		protoV[nx].p_name = StrAlloc(proto);
		if( ports[0] && strcmp(ports,"*") != 0 ){
			if( ports[0] == '{' )
				ovstrcpy(ports,ports+1);
			nn = stoV(ports,MAXPROTO,portv,',');
			protoV[nx].p_portN = nn;
			protoV[nx].p_portV = (int *)calloc(sizeof(int*),nn);
			for( nj = 0; nj < nn; nj++ )
				protoV[nx].p_portV[nj] = atoi(portv[nj]);
		}
		if( methods[0] )
		{
			DO_METHOD_FILTER++;
			protoV[nx].p_methods = StrAlloc(methods);
		}
		if( !neg )
			nx++;
	}
	protoV[nx].p_name = 0;
	return protoV;
}
static sprintProtoV(protoV,protolist)
	Server *protoV;
	char *protolist;
{	int ni,nj,np;
	char *proto1,*pp;
	char *mp;

	*protolist = 0;
	if( protoV == 0 )
		return;

	pp = protolist;
	*pp = 0;
	for( ni = 0; proto1 = protoV[ni].p_name; ni++ ){
		if( 0 < ni )
			*pp++ = ',';

		strcpy(pp,proto1);
		pp += strlen(pp);

		if( np = protoV[ni].p_portN ){
			*pp++ = '/';
			if( 1 < np )
				*pp++ = '{';

			for( nj = 0; nj < protoV[ni].p_portN; nj++ ){
				if( 0 < nj )
					*pp++ = ',';
				sprintf(pp,"%d",protoV[ni].p_portV[nj]);
				pp += strlen(pp);
			}
			if( 1 < np )
				*pp++ = '}';
			*pp = 0;
		}
		if( mp = protoV[ni].p_methods ){
			if( np == 0 ){
				*pp++ = '/';
				*pp++ = '*';
			}
			*pp++ = '/';
			strcpy(pp,mp);
			pp += strlen(pp);
		}
	}
}
static subProto1(pv,proto,ports,portp)
	char *pv[];
	char *proto,*ports,**portp;
{	int pi,px,match0,match;
	char *proto1;
	char ports1[256];
	int len;

	px = 0;
	match0 = 0;
	if( strcmp(proto,"*") == 0 || strcmp(proto,"all") == 0 )
		match0 = 1;
	len = strlen(proto);
	for( pi = 0; proto1 = pv[pi]; pi++ ){
		match = match0;
		if( strncmp(proto,proto1,len) == 0 ){
			if( proto1[len] == 0 )
				match = 1;
			else
			if( proto1[len] == '/' ){
				subSetList(&proto1[len+1],ports,ports1);
				if( *ports1 == 0 )
					match = 1;
				else{
					strcpy(*portp,proto1);
					proto1 = *portp;
					strcpy(&proto1[len+1],ports1);
					*portp += strlen(proto1) + 1;
				}
			}
		}
		if( match )
			continue;
		pv[px++] = proto1;
	}
	pv[px] = 0;
}

static addProto1(protoport,tv,pv,portp,iproto)
	char *protoport;
	char *tv[],*pv[];
	char **portp;
	char *iproto;
{	int pi,ti,px,match0,match;
	char proto[64],ports[256],protoportb[256];
	char methods[512];
	char *proto1;
	int len;

	if( strcmp(protoport,".") == 0 ){
		if( foreach_eqproto(iproto,addProto1,tv,pv,portp,iproto) )
			return 0;
	}

	scanProtoPort(protoport,proto,ports,methods);

	if( proto[0] == '!' || proto[0] == '-' ){
		subProto1(pv,proto+1,ports,portp);
		return 0;
	}

	if( strcmp(proto,".") == 0 )
		strcpy(proto,iproto);

	if( strcmp(proto,"*") == 0 || strcmp(proto,"all") == 0 ){
		px = 0;
		for( ti = 0; tv[ti]; ti++ )
			if( 0 <= serviceport(tv[ti]) ) /* not VPROTO */
				pv[px++] = tv[ti];
		pv[px] = 0;
		return 0;
	}else{
		match = 0;
		for( ti = 0; tv[ti]; ti++ )
			if( match = (strcasecmp(proto,tv[ti])==0) )
				break;

		if( match ){
			for( pi = 0; pv[pi]; pi++);
			pv[pi+1] = 0;

			pv[pi] = *portp;
			strcpy(*portp,proto);
			*portp += strlen(*portp);
			if( ports[0] == 0 && methods[0] )
				strcpy(ports,"*");
			if( ports[0] ){
				sprintf(*portp,"/%s",ports);
				*portp += strlen(*portp);
			}
			if( methods[0] ){
				sprintf(*portp,"/%s",methods);
				*portp += strlen(*portp);
			}
			*portp += 1;
			return 0;
		}
	}
	sv1log("ERROR protocol inhibited: %s\n",proto);
	return 0;
}
static int portMatch(protoV,port)
	Server *protoV;
{	int ni;

	if( protoV->p_portV == NULL )
		return 1;

	for( ni = 0; ni < protoV->p_portN; ni++ )
		if( protoV->p_portV[ni] == port )
			return 1;
	return 0;
}
static Server *protoMatch1(protoV,proto,port)
	Server *protoV;
	char *proto;
{	int px;
	char *aproto;

	for( px = 0; aproto = protoV[px].p_name; px++ ){
		/*
		if( strcasecmp(proto,aproto)==0 )
		*/
		if( *proto=='*' || *aproto=='*' || strcasecmp(proto,aproto)==0 )
			if( portMatch(&protoV[px],port) )
				return &protoV[px];
	}
	return NULL;
}
static protoMatch2(protoV,proto)
	Server *protoV;
	char *proto;
{	int px;
	char *aproto;

	if( protoV == NULL )
		return 1;

	for( px = 0; aproto = protoV[px].p_name; px++ ){
		if( *proto=='*' || *aproto=='*' || strcasecmp(proto,aproto)==0 )
			return 1;
	}
	return 0;
}
static protoMatch3(protoV,proto)
	Server *protoV;
	char *proto;
{	int px;
	char *aproto;

	for( px = 0; aproto = protoV[px].p_name; px++ ){
		if( *proto=='*' || *aproto=='*' || strcasecmp(proto,aproto)==0 )
			return 1;
	}
	return 0;
}
static int methodMatch(Conn,protoV,method)
	Connection *Conn;
	Server *protoV;
	char *method;
{	char *methods = protoV->p_methods;

	if( methods == NULL || *methods == 0 || strcmp(methods,"*") == 0 )
		return 1;

	if( method && streq(method,".REJECT") ){
		/* pseudo method to check the existence of methodList */
		return 0;
	}
	if( strcmp(methods,"readonly") == 0 ){
		/* "readonly" is a pseudo method name which represents any
		 * methods excluding ones for modification.  Since it depends
		 * on each application protocol, it is regarded as permitting
		 * arbitrary methods.
		 */
		return Conn->forreject ? 0 : 1;
	}

	if( method == NULL || *method == 0 ){
		/* empty method means connecting to server,
		 * which should not be rejected without condition,
		 * and should be permitted without condition.
		 */
		return Conn->forreject ? 0 : 1;
	}
	if( method  == NULL || *method  == 0 || strcmp(method, "*") == 0 )
		return 1;
/*
	if( strstr(methods,method) )
*/
	if( isinList(methods,method) )
		return 1;
	return 0;
}

static Route *addRoute1(RT,proto,host,port,path,conn,protov,dstlist,srclist)
	RouteTab *RT;
	char *proto,*host,*path;
	char *conn;
	char **protov,*dstlist,*srclist;
{	char *what;
	int idx;
	Route *Rp;
	char tabid[64];
	char protolist[1024];

	what = RT->rt_name;
	idx = newRoute(RT);
	Rp = RT->rt_routes[idx];
	Rp->m_gw_proto = StrAlloc(proto);
	Rp->m_gw_host = StrAlloc(host);
	Rp->m_gw_port = port;
	Rp->m_gw_path = StrAlloc(path);
	Rp->m_conn = StrAlloc(conn);

	sprintf(tabid,"%s/DST",what);
	Rp->m_dsts.hl_what = StrAlloc(tabid);
	Rp->m_dsts.hl_noIdent = 1;
/* Rp->m_dsts.hl_list = &filterHosts[HostsX]; */
	scan_commaListL(dstlist,STR_ALLOC,addHostList1,&Rp->m_dsts);
/* HostsX += Rp->m_dsts.hl_cnt; */

	sprintf(tabid,"%s/SRC",what);
	Rp->m_srcs.hl_what = StrAlloc(tabid);
/* Rp->m_srcs.hl_list = &filterHosts[HostsX]; */
	scan_commaListL(srclist,STR_ALLOC,addHostList1,&Rp->m_srcs);
/* HostsX += Rp->m_srcs.hl_cnt; */

	if( protov != NULL ){
		protolist[0] = 0;
		Rp->m_protoV = makeProtoV(NULL,protov);
		sprintProtoV(Rp->m_protoV,protolist);
		Verbose("[%d] %s={%s}%s{%s}:{%s}:{%s}\n",
			idx,what,path,host,protolist,dstlist,srclist);
	}else	Verbose("[%d] %s=%s://%s:%d%s-_-{%s}:{%s}\n",
			idx,what,proto,host,port,path,dstlist,srclist);
	return Rp;
}

static HostList *hlist(rtx,srcdst){
	if( routeTabs[rtx].rt_routes == 0 )
		addRoute1(&routeTabs[rtx],"","",0,"","",NULL,"","");
	return &routeTabs[rtx].rt_routes[0]->m_hostlist[srcdst];
}

HostList *ReliableHosts(){	return hlist(R_RELIABLE,RX_SRC); }
HostList *ReachableHosts(){	return hlist(R_REACHABLE,RX_DST); }
HostList *IdentHosts(){		return hlist(R_USERIDENT,RX_SRC); }

scan_RELIABLE(Conn,rels)
	Connection *Conn;
	char *rels;
{
	/* V8.0.1 RELIABLE="" -> RELIABLE="!*" */
	if( *rels == 0 ) rels = "!*";

	scan_commaList(rels,1,addHostList1,ReliableHosts());
	putHostListTab(".RELIABLE",ReliableHosts());
}
scan_REACHABLE(Conn,list)
	Connection *Conn;
	char *list;
{
	/* V8.0.1 REACHABLE="" -> REACHABLE="!*" */
	if( *list == 0 ) list = "!*";

	ReachableHosts()->hl_noIdent = 1;
	scan_commaList(list,1,addHostList1,ReachableHosts());
}
enableClientIdent(host)
	char *host;
{
	Verbose("-- ident: ENABLE{%s}\n",host);
	scan_commaList(host,1,addHostList1,IdentHosts());
}

extern char *NOTIFY_PLATFORM;
HostList *NotifyPltfrmHosts(){
	HostList *hl;

	hl = hlist(R_NOTIFYPLTFM,RX_DST);
	if( hl->hl_cnt == 0 && *NOTIFY_PLATFORM )
		scan_commaList(NOTIFY_PLATFORM,1,addHostList1,hl);
	return hl;
}

static NonHTTP(Rp,proto)
	Route *Rp;
	char *proto;
{
	if( Rp->m_protoV_NonHTTP ){
		if( strncasecmp(proto,"http",4) == 0 )
			return 1;
	}
	return 0;
}

/*
 *	CMAP=output:mapname:protoList:dstHostList:srcHostList
 */
#define M_OUT	0
#define M_NAME	1
#define M_PROTO	2
#define M_DSTH	3
#define M_SRCH	4

static scanmap1(map1,mapv,mapc)
	char *map1;
	char *mapv[];
	int *mapc;
{
	mapv[*mapc] = map1;
	*mapc = *mapc + 1;
	return 0;
}
scan_CMAP(Conn,map)
	Connection *Conn;
	char *map;
{
	scan_CMAPX(Conn,map,0,0);
}
scan_CMAP2(Conn,name,map)
	Connection *Conn;
	char *name,*map;
{	char cmap[1024];

	sprintf(cmap,"%s:%s",name,map);
	scan_CMAPX(Conn,cmap,1,1);
}
scan_CMAPX(Conn,map,reverse,defaultOK)
	Connection *Conn;
	char *map;
{	char mapb[1024],*mapv[8],*map1;
	int mapc,mapi;
	char protoV[32];
	int outx,namex;

	strcpy(mapb,map);
	for( mapi = 0; mapi < 8; mapi++ )
		mapv[mapi] = "";

	mapc = 0;
	scan_ListL(mapb,':',STR_ALLOC,scanmap1,mapv,&mapc);

	if( defaultOK )
	for( mapi = 0; mapi < 8; mapi++ )
		if( mapv[mapi][0] == 0 )
			mapv[mapi] = "*";

	protoV[0] = 0;
	stoV(mapv[M_PROTO],32,protoV,',');

	for( mapi = 0; mapi < mapc; mapi++ ){
		map1 = mapv[mapi];
		if( map1[0] == '{' && strtailchr(map1) == '}' ){
			ovstrcpy(map1,map1+1);
			map1[strlen(map1)-1] = 0;
		}
	}

	if( reverse ){
		namex = M_OUT;
		outx = M_NAME;
	}else{
		namex = M_NAME;
		outx = M_OUT;
	}
	addRoute1(MapRoute,
		"CMAP",mapv[namex],0,mapv[outx],"-",
		protoV, mapv[M_DSTH], mapv[M_SRCH]);
}
/*
find_CMAPXi(map,i,str,proto,dhost,dport,shost,sport,suser)
*/
static find_CMAPXi(map,i,str,proto,dhost,dport,shost,sport,suser,ac,av)
	char *map,*str,*proto,*dhost,*shost,*suser;
	AuthInfo *av[];
{	int mx;
	Route *Rp;
	int nd,ns;

	for( mx = i; mx < MapX; mx++ ){
		Rp = Maps[mx];

		if( strcmp(map,Rp->m_gw_host) != 0 )
			continue;

		if( NonHTTP(Rp,proto) )
			continue;

		if( !protoMatch2(Rp->m_protoV,proto) )
			continue;

		nd = Rp->m_dsts.hl_cnt;
		ns = Rp->m_srcs.hl_cnt;
		/*
		if(!nd || hostIsinList(&Rp->m_dsts,proto,dhost,dport,NULL) )
		if(!ns || hostIsinList(&Rp->m_srcs,ANYP,shost,sport,suser) ){
		*/
		if(!nd || hostIsinListX(&Rp->m_dsts,proto,dhost,dport,NULL,ac,av) )
		if(!ns || hostIsinListX(&Rp->m_srcs,ANYP,shost,sport,suser,ac,av) ){
			strcpy(str,Rp->m_gw_path);
			return mx;
		}
	}
	*str = 0;
	return -1;
}
find_CMAPi(Conn,map,i,str)
	Connection *Conn;
	char *map,*str;
{	char *proto;
	char *dhost,shost[256];
	int dport,sport;
	char *suser;
	int ac;
	AuthInfo *av[4];

/*
	proto = DST_PROTO;
*/
	if( REAL_PROTO[0] )
		proto = REAL_PROTO;
	else
	if( streq(DFLT_PROTO,"http") ){
		/* do not apply destination protocol dependent CFI
		 * before destination server's protocol is recognized.
		 */
		proto = "ANYP";
	}else
	if( DFLT_PROTO[0] )
		proto = DFLT_PROTO;
	else	proto = "ANYP";

	dhost = DST_HOST;
	dport = DST_PORT;
	sport = getClientHostPort(Conn,shost);
	suser = Ident();

	/*
	return find_CMAPXi(map,i,str,proto,dhost,dport,shost,sport,suser);
	*/
	ac = getClientAuthList(Conn,4,av);
	return find_CMAPXi(map,i,str,proto,dhost,dport,shost,sport,suser,ac,av);
}
find_CMAPX(map,str,proto,dhost,dport,shost,sport,suser)
	char *map,*str,*proto,*dhost,*shost,*suser;
{
	/*
	return find_CMAPXi(map,0,str,proto,dhost,dport,shost,sport,suser);
	*/
	return find_CMAPXi(map,0,str,proto,dhost,dport,shost,sport,suser,0,NULL);
}
find_CMAP(Conn,map,str)
	Connection *Conn;
	char *map,*str;
{
	return find_CMAPi(Conn,map,0,str);
}

/*
 *	ROUTE=proto://host:port/path-_-{dstHostList}:{srcHostList}
 */
#define DELMARK	"-_-"
scan_ROUTE(Conn,forward)
	Connection *Conn;
	char *forward;
{	char gateway[256],proto[32],hostport[256],host[256],path[128];
	int port;
	char dstlist[2048],srclist[2048];
	char *dp,*np,*srcp;
	int na;

	if( (dp = strstr(forward,DELMARK)) == 0 )
		goto error;
	strncpy(gateway,forward,dp-forward);
	gateway[dp-forward] = 0;

	path[0] = 0;
	if( sscanf(gateway,"%[^:]://%[^/]%s",proto,hostport,path) < 2 )
		goto error;
	if( sscanf(hostport,"%[^:]:%d",host,&port) < 2 )
		port = serviceport(proto);

	dp += strlen(DELMARK);

	srcp = 0;
	dstlist[0] = srclist[0] = 0;

	if( *dp == '{' ){
		dp++;
		if( (np = strchr(dp,'}')) == 0 )
			goto error;
		strncpy0(dstlist,dp,np-dp);
		switch( np[1] ){
			case 0:	  goto done;
			case ':': srcp = np + 2; break;
			default:  goto error;
		}
	}else{
		if( np = strchr(dp,':') ){
			strncpy0(dstlist,dp,np-dp);
			srcp = np + 1;
		}else{
			strcpy(dstlist,dp);
			goto done;
		}
	}
	if( *srcp == '{' ){
		srcp++;
		if( (np = strchr(srcp,'}')) == 0 )
			goto error;
		strncpy0(srclist,srcp,np-srcp);
	}else{
		strcpy(srclist,srcp);
	}
done:
	addRoute1(ForwardRoute,proto,host,port,path,"",
		NULL,dstlist,srclist);
	return;
error:
	sv1log("ROUTE ? %s\n",forward);
	return;
}
/*
scan_ROUTE(Conn,route)
	Connection *Conn;
	char *route;
{
	scan_FORWARDX(Conn,route,0);
}
*/
scan_FORWARD(Conn,forward)
	Connection *Conn;
	char *forward;
{
	scan_FORWARDX(Conn,forward,1);
}
static conn1(co1,connv,connc)
	char *co1,*connv[];
	int *connc;
{
	if( *co1 )
		connv[*connc] = co1;
	else	connv[*connc] = "*";
	*connc += 1;
	return 0;
}
scan_FORWARDX(Conn,forward,withproto)
	Connection *Conn;
	char *forward;
{	char gateway[256],proto[32],hostport[256],host[256],path[128];
	char portb[32];
	int port;
	char *dp,*cmap;
	int connc;
	char *connv[4],*svproto,*dst,*src,*protoV[MAXPROTO];

	if( dp = strstr(forward,DELMARK) ){
		strncpy(gateway,forward,dp-forward);
		gateway[dp-forward] = 0;
		cmap = dp + strlen(DELMARK);
	}else{
		strcpy(gateway,forward);
		cmap = "";
	}

	decomp_absurl(gateway,proto,hostport,path,sizeof(path));
	if( proto[0] == 0 || hostport[0] == 0 )
		goto error;
	decomp_URL_site(hostport,host,portb);
	port = atoi(portb);
	if( port == 0 )
		port = serviceport(proto);

	connc = 0;
	connv[0] = connv[1] = connv[2] = "*";
	scan_ListL(cmap,':',STR_ALLOC,conn1,connv,&connc);
	if( withproto ){
		svproto = connv[0];
		dst = connv[1];
		src = connv[2];
	}else{
		svproto = "*";
		dst = connv[0];
		src = connv[1];
	}
	sv1log("FORWARD=%s://%s:%d/%s-_-{%s}:{%s}:{%s}\n",proto,host,port,path,
		svproto,dst,src);
	stoV(svproto,MAXPROTO,protoV,',');
	addRoute1(ForwardRoute,proto,host,port,path,"",protoV,dst,src);
	return;
error:
	sv1log("FORWARD ? %s\n",forward);
	return;
}

static findRoute(Conn,routes,startX,endX,proto,dsthost,srchost)
	Connection *Conn;
	Route *routes[];
	char *proto,*dsthost,*srchost;
{	int cx,nd,ns;
	Route *Rp;
	int found = -1;

	CTX_pushClientInfo(Conn);
	for( cx = startX; cx < endX; cx++ ){
		Rp = routes[cx];

		if( NonHTTP(Rp,proto) )
			continue;

		if( !protoMatch3(Rp->m_protoV,proto) )
			continue;

		nd = Rp->m_dsts.hl_cnt;
		ns = Rp->m_srcs.hl_cnt;
		if(!nd || hostIsinList(&Rp->m_dsts,proto,dsthost,0,NULL) )
		if(!ns || hostIsinList(&Rp->m_srcs,ANYP,srchost,0,Ident()))
		{
			found = cx;
			break;
		}
	}
	HL_popClientInfo();
	return found;
}

/*
 *	PERMIT=proto1/{port1,port2}/{com1,com2}:dstHostList:srcHostList
 */
scan_PERMITV(Conn,list,protov)
	Connection *Conn;
	char *list;
	char *protov[];
{	char protoL[2048],dstL[2048],srcL[2048];
	char *protoV[MAXPROTO],*pprotov[MAXPROTO];
	char portb[2048],*portp = portb;
	int pc;
	char *iproto;
	int withsrc;

	protoL[0] = dstL[0] = srcL[0] = 0;
	pc = scan_Listlist(list,':',protoL,dstL,srcL,0);
	iproto = DFLT_PROTO;
	protoV[0] = 0;

	if( !Conn->forreject )
	if( pc <= 1 ){
		char protolist[1024];
		protolist[0] = 0;
		if( Remittable ){
			sprintProtoV(Remittable,protolist);
			if( *protolist && *protoL )
				strcat(protolist,",");
		}
		strcat(protolist,protoL);
		strcpy(protoL,protolist);

		scan_commaListL(protoL,STR_VOLA,addProto1,protov,protoV,&portp,iproto);
		if( Remittable )
			RemittableV = makeProtoV(NULL,protoV);
		else	addRoute1(RemittableRoute,"","",0,"","",protoV,"*","*");
		sprintProtoV(Remittable,protolist);
		InitLog("REMITTABLE = %s\n",protolist);
		return;
	}

	if( Remittable != NULL ){
		int pi;
		for( pi = 0; pprotov[pi] = RemittableV[pi].p_name; pi++ )
			;
		protov = pprotov; /* arary of available protocos */
	}
	scan_commaListL(protoL,STR_VOLA,addProto1,protov,protoV,&portp,iproto);

	withsrc = srcL[0] != 0;
	if( dstL[0] == 0 ) strcpy(dstL,"*");
	if( srcL[0] == 0 ) strcpy(srcL,DELEGATE_RELIABLE);

	if( Conn->forreject ){
		addRoute1(RejectRoute,"","",0,"","",protoV,dstL,srcL);
		RejectRoute->rt_withsrc += withsrc ? 1 : 0;
	}else{
	addRoute1(PermitRoute,"","",0,"","",protoV,dstL,srcL);
	PermitRoute->rt_withsrc += withsrc ? 1 : 0;
	}
}
PERMIT_withSrc(){ return PermitRoute->rt_withsrc; }

notREMITTABLE(proto,port)
	char *proto;
{
	if( Remittable != NULL )
		if( protoMatch1(Remittable,proto,port) == NULL )
			return 1;
	return 0;
}

DELEGATE_rejectM(Conn,proto,method,dsthost,dport,srchost,sport)
	Connection *Conn;
	char *proto,*method,*dsthost,*srchost;
{	int match;

	if( RejectX <= 0 )
		return 0;

	Conn->forreject = 1;
	match = DELEGATE_permitM(Conn,proto,method,dsthost,dport,srchost,sport);
	Conn->forreject = 0;
	return match;
}

static DELEGATE_permitMX();
extern char *hostmatch_ignauth;
DELEGATE_permitM(Conn,proto,method,dsthost,dport,srchost,sport)
	Connection *Conn;
	char *proto,*method,*dsthost,*srchost;
{	char *suser;
	int ac;
	AuthInfo *av[4];

	suser = Ident();
	if( suser == 0 && Conn->no_authcheck )
		suser = hostmatch_ignauth;
	ac = getClientAuthList(Conn,4,av);
	return DELEGATE_permitMX(Conn,proto,method,dsthost,dport,srchost,sport,suser,ac,av);
}
static DELEGATE_permitMX(Conn,proto,method,dsthost,dport,srchost,sport,suser,ac,av)
	Connection *Conn;
	char *proto,*method,*dsthost,*srchost;
	char *suser;
	AuthInfo *av[];
{	Route *Rp;
	int pi;
	Server *pl;
	char *duser = DST_USER;
	char *dstproto = proto;
	
	int permitX;
	Route **permits;

	if( Conn->forreject ){
		if( Conn->no_dstcheck ){
			/* ignore REJECT=prt:dst:src for source_permit() */
			return 0;
		}
		permitX = RejectX;
		permits = Rejects;
	}else{
		permitX = PermitX;
		permits = Permits;
	}

	if( Conn->no_dstcheck_proto
	 && Conn->no_dstcheck_proto == serviceport(proto) )
	{
		/* skip checking destination protocol for MOUNTed server */
		dstproto = "*";
	}

	if( !Conn->forreject )
	if( !Conn->no_dstcheck )
	if( Remittable != NULL ){
		if( (pl = protoMatch1(Remittable,dstproto,dport)) == NULL )
		{
			sprintf(Conn->reject_reason,"'%s' is not REMITTABLE",
				proto);
			return 0;
		}
		if( !methodMatch(Conn,pl,method) )
			return 0;
	}

	if( permitX == 0 )
		return 1;

	for( pi = 0; pi < permitX; pi++ ){
		Rp = permits[pi];
		pl = NULL;

		if( !Conn->no_dstcheck )
		if( Rp->m_protoV )
		if( (pl = protoMatch1(Rp->m_protoV,dstproto,dport)) == NULL )
			continue;

		if( Conn->no_dstcheck
		 || hostIsinList(&Rp->m_dsts,proto,dsthost,dport,duser) )
		if( hostIsinListX(&Rp->m_srcs,ANYP,srchost,sport,suser,ac,av) ){
			if( pl == NULL )
				return 1;
			else	return methodMatch(Conn,pl,method);
		}
	}
	return 0;
}

/*
 *	OWNER=owner:srcHostList
 */
scan_OWNER(Conn,ownerspec)
	Connection *Conn;
	char *ownerspec;
{	char user[1024],from[1024];
	Route *Rp;

	user[0] = from[0] = 0;
	sscanf(ownerspec,"%[^:]:%s",user,from);
	if( from[0] != 0 ){
		Rp = addRoute1(OwnerRoute,"","",0,"","",NULL,"",from);
		Rp->m_owner = StrAlloc(user);
	}
	return 0;
}
set_OWNER(Conn,host,port,user)
	Connection *Conn;
	char *host,*user;
{	int oi;
	Route *Rp;
	char *owner;

	if( OwnerX == 0 )
		return 0;

	owner = 0;
	for( oi = 0; oi < OwnerX; oi++ ){
		Rp = Owners[oi];
		if( hostIsinList(&Rp->m_srcs,ANYP,host,port,user) ){
			owner = Rp->m_owner;
			break;
		}
	}
	if( owner ){
		if( streq(owner,"*") )
			owner = user;
		sv1log("OWNER=%s <= %s@%s:%d\n",owner,user,host,port);
		set_Owner(1,owner,-1); /* Identd doesn't look effective UID ... */
		return 0;
	}
	sv1log("#### set_OWNER: failed <= %s@%s:%d\n",user,host,port);
	return -1;
}
extern char *getusernames();
set_Owner(real,aowner,file)
	char *aowner;
{	char *owner;
	int uid,gid;
	char names[128];

	if( aowner != NULL && strchr(aowner,':') )
		return 0;

	if( (owner = aowner) == NULL )
		owner = DELEGATE_OWNER;

	if( scan_guid(owner,&uid,&gid) != 0 ){
		if( aowner != NULL ){
			ERRMSG("ERROR: Unknown OWNER: %s\n",owner);
			return -1;
		}
	}else{
		if( 0 <= file && !isatty(file) )
		if( INHERENT_fchown() )
			fchown(file,uid,gid);
		/* chown() should be tried if it is available... */

		if( real ){
			if( gid != -1 ) setgid(gid);
			setuid(uid);
		}else{
			if( gid != -1 ) setegid(gid);
			seteuid(uid);
		}
		sv0log("OWNER=%s => OWNER=%s\n",owner,getusernames(names));
	}
	return 0;
}

/*
 * SRCIF=host[:port[:dstProto[:dstHost[:srcHost]]]]
 */
scan_SRCIF(Conn,ifspec)
	Connection *Conn;
	char *ifspec;
{	char specb[1024],*specv[5],*shost,*protov[64];
	int sc,si,sport;
	int p1,p2;

	lineScan(ifspec,specb);
	sc = stoV(specb,5,specv,':');
	for( si = sc; si < 5; si++ )
		specv[si] = "*";
	shost = specv[0];
	if( sscanf(specv[1],"%d-%d",&p1,&p2) == 2 ){
		sport = (p1 << 16) | p2;
	}else
	if( strcmp(specv[1],"0") == 0 )
		sport = 0xFFFF0000;
	else
	sport = atoi(specv[1]);
	stoV(specv[2],64,protov,',');
	addRoute1(SrcifRoute,"",shost,sport,"","",protov,specv[3],specv[4]);
}
set_SRCIF(Conn,proto,host,port)
	Connection *Conn;
	char *proto,*host;
{	char *shost;
	int routex;
	Route *Rp;

	shost = Client_Host;
	routex = findRoute(Conn,Srcif,0,SrcifX,proto,host,shost);
	if( 0 <= routex ){
		Rp = Srcif[routex];
		set_SRCPORT(Rp->m_gw_host,Rp->m_gw_port);
	}else	set_SRCPORT("",0);
}
SRCIFfor(Conn,proto,rhost,rport,lhost,lport)
	Connection *Conn;
	char *proto,*rhost,*lhost;
	int *lport;
{	int routex;
	Route *Rp;
	char ports[32];

	routex = findRoute(Conn,Srcif,0,SrcifX,proto,rhost,Client_Host);
	if( 0 <= routex ){
		Rp = Srcif[routex];
		if( Rp->m_gw_port == 0 )
			strcpy(ports,"*");
		else
		if( Rp->m_gw_port == 0xFFFF0000 )
			strcpy(ports,"0");
		else
		if( Rp->m_gw_port & 0xFFFF0000 )
			sprintf(ports,"%d-%d",
			(Rp->m_gw_port>>16)&0xFFFF,(Rp->m_gw_port)&0xFFFF);
		else	sprintf(ports,"%d",Rp->m_gw_port);
		
		sv1log("SRCIF=%s:%s [%s://%s:%d]\n",Rp->m_gw_host,ports,
			proto,rhost,rport);
		if( lhost && *Rp->m_gw_host != '*' ) strcpy(lhost,Rp->m_gw_host);
		if( lport && Rp->m_gw_port ) *lport = Rp->m_gw_port;
		return 1;
	}
	return 0;
}

/*
 *	cache/expire
 *	direct/socks
 *	master/private
 *	master/socks
 *	proxy/socks
 */

#define C_CACHE		'c'
#define C_ICP		'i'
#define C_FTP		'f'
#define C_SSLTUNNEL	'h'
#define C_MASTER	'm'
#define C_MASTERP	'm'
#define C_PROXY		'p'
#define C_DIRECT	'd'
#define C_VSAP		'v'
#define C_SOCKS		's'
#define C_TELEPORT	't'
#define C_UDP		'u'
#define C_INTERNAL	'l'

typedef struct {
	char	*orders;
	int	 orderx;
	int	*expires;
} connArg; 

static connect1(conn,Conn,Ca)
	char *conn;
	Connection *Conn;
	connArg *Ca;
{	char *expire,*dp;
	int ctype;

	switch( *conn ){
	    case 'c':	enable_cache();
			if( expire = strchr(conn,'/') ){
				expire++;
			}
			ctype = C_CACHE;    break;
	    case 'i':	ctype = C_ICP;      break;
	    case 'd':	ctype = C_DIRECT;   break;
	    case 'f':	ctype = C_FTP;	    break;
	    case 'h':	ctype = C_SSLTUNNEL;break;
	    case 'p':	ctype = C_PROXY;    break;
	    case 'm':	ctype = C_MASTER;
			if( dp = strchr(conn,'/') )
				if( dp[1] == 'p' )
					ctype = C_MASTERP;
			break;
	    case 'v':	ctype = C_VSAP;
			if( dp = strchr(conn,'/') ){
				char vsap[1024];
				sprintf(vsap,"%s/CONNECT",dp+1);
				scan_VSAP(Conn,vsap);
			}
			break;
	    case 's':	ctype = C_SOCKS;    break;
	    case 't':	ctype = C_TELEPORT; break;
	    case 'u':	ctype = C_UDP; break;
	    case 'l':	ctype = C_INTERNAL; break;
	    default:	sv1log("CONNECT=%s ?\n",conn);
			return -1;
	}

	Ca->orders[Ca->orderx++] = ctype;
	return 0;
}
scan_CONNECT(Conn,connlist)
	Connection *Conn;
	char *connlist;
{	char *clist,*proto,*dst,*src,*protoV[MAXPROTO];
	char orders[32];
	int expires[32];
	connArg ca;
	char *connv[4];
	int conni,connc;

	clist = stralloc(connlist);
	for( conni = 0; conni < 4; conni++ )
		connv[conni] = "*";
	connc = 0;
	scan_List(clist,':',STR_OVWR,conn1,connv,&connc);
	proto = connv[1];
	dst = connv[2];
	src = connv[3];

	ca.orders = orders;
	ca.orderx = 0;
	ca.expires = expires;
	if( scan_commaListL(connv[0],STR_VOLA,connect1,Conn,&ca) < 0 ){
		ERRMSG("unknown CONNECT=%s ?\r\n",clist);
		Finish(1);
	}
	ca.orders[ca.orderx] = 0;
	Verbose("CONNECT={%s}:{%s}:{%s}:{%s}\n",orders,proto,dst,src);

	stoV(proto,MAXPROTO,protoV,',');
	addRoute1(ConnectRoute,"","",0,"",orders,protoV,dst,src);
	free(clist);
}
setupConnect(Conn)
	Connection *Conn;
{	int routex;
	char shost[256];
	int sporti;
	Route *Rp;
	char *orders;

	if( ConnectX == 0 )
		return 0;
	if( Conn->co_setup )
		return 1;
	Conn->co_setup = 1;

	if( remote_access(Conn) ){
		sv1log("====> remote access\n");
		ConnectX = 0; /* should set remote access explicitly ? */
		Conn->co_nonet = 0;
		return 0;
	}

	if( Conn->from_myself && !Conn->from_client ){
		shost[0] = 0;
		sporti = 0;
	}else
	if( (sporti = getpeerNAME(ClientSock,shost)) == 0 )
		return 0;
	routex = findRoute(Conn,Connects,0,ConnectX,DST_PROTO,DST_HOST,shost);
	Conn->co_routex = routex;
	if( routex < 0 ){
		Verbose("====> NO CONNECT was specified for: %s:%s\n",
			DST_HOST,shost);
		return 0;
	}

	Rp = Connects[routex];
	orders = Rp->m_conn;

	if( strchr(orders,C_INTERNAL) && orders[0] != C_INTERNAL ){
		Verbose("CONNECTION: NO INTERNAL\n");
		Conn->co_nointernal = 1;
	}
	if( strchr(orders,C_CACHE) == 0 ){
		disable_cache();
	}else{
		enable_cache();
		/*scan_EXPIRE();*/
		if( orders[0] == C_CACHE && orders[1] == 0 )
			Conn->co_nonet = 1;
	}
}
tryCONNECT(Conn,relay_input,svsockp)
	Connection *Conn;
	int *svsockp;
{	int cx,ci,svsock;
	char contype,*order;

	*svsockp = -1;
	Conn->ca_objsize = -1;

	if( ConnectX == 0 )
		return 0;
	if( Conn->co_setup == 0 )
		setupConnect(Conn);
	if( Conn->co_routex < 0 )
		return 0; /* default connection will be tried */
	if( Conn->co_nonet )
		return -1;

	svsock = -1;
	cx = Conn->co_routex;
	order = Connects[cx]->m_conn;

	for( ci = 0; svsock == -1 && order[ci]; ci++ ){
	    contype = order[ci];

	    if( tryProxyOnly )
	    switch( contype ){
	      case C_CACHE:
	      case C_ICP:
	      case C_PROXY:
	      case C_MASTER:
		break;
	      default:
		Verbose("tryProxyOnly:NO. prefer [%c] to proxy\n",contype);
		return -1;
	    }

	    switch( contype ){
	      case C_CACHE:
		Verbose("-[%d,%d]- TRY CACHE ...\n",cx,ci);
		break;
	      case C_ICP:
		Verbose("-[%d,%d]- TRY ICP ...\n",cx,ci);
		svsock = ConnectViaICP(Conn,NULL);
		break;
	      case C_SSLTUNNEL:
		Verbose("-[%d,%d]- TRY SSLtunnel/HTTP ...\n",cx,ci);
		svsock = ConnectViaSSLtunnel(Conn,DST_HOST,DST_PORT);
		break;
	      case C_FTP:
		Verbose("-[%d,%d]- TRY FTP-DATA ...\n",cx,ci);
		svsock = ConnectViaFtp(Conn);
		break;
	      case C_PROXY:
	      case C_MASTER:
		Verbose("-[%d,%d]- TRY PROXY ...\n",cx,ci);
		if( forwardit(Conn,-1,relay_input) ){
			svsock = ToS;
			if( toProxy )
				ConnType = 'p';
			else	ConnType = 'm';
		}
		if( 0 <= svsock || contype == C_PROXY )
			break;
		Verbose("-[%d,%d]- TRY MASTER ...\n",cx,ci);
		svsock = open_master(Conn,1,DST_HOST,DST_PORT,1,relay_input);
		break;
	      case C_DIRECT:
		Verbose("-[%d,%d]- TRY DIRECT ...\n",cx,ci);
/* should get rid of SOCKS access */
		svsock = ConnectToServer(Conn,relay_input);
		break;
	      case C_VSAP:
	      { char sockname[256],peername[256];
		sockname[0] = 0;
		sprintf(peername,"%s:%d",DST_HOST,DST_PORT);
		Verbose("-[%d,%d]- TRY VSAP ...\n",cx,ci);
		svsock = CTX_VSAPconnect(Conn,sockname,peername);
		if( 0 <= svsock )
			ServViaVSAP = 1;
		break;
	      }
	      case C_SOCKS:
		if( GetViaSocks(Conn,DST_HOST,DST_PORT) ){
			Verbose("-[%d,%d]- TRY SOCKS ...\n",cx,ci);
			svsock = ConnectViaSocks(Conn,relay_input);
			if( 0 <= svsock )
				ServViaSocks = 1;
		}else{
			Verbose("-[%d,%d]- DON'T TRY SOCKS (conditional)\n",cx,ci);
			svsock = -1;
		}
		break;
	      case C_UDP:
		svsock = UDP_client_open1("connect",DST_PROTO,DST_HOST,DST_PORT,
			NULL,0);
		break;
	      case C_INTERNAL:
		Verbose("-[%d,%d]- TRY INTERNAL ... not supported\n",cx,ci);
		break;
	      case C_TELEPORT:
		Verbose("-[%d,%d]- TRY TELEPORT ...\n",cx,ci);
/*
		svsock = teleport_open(Conn,DST_HOST,relay_input);
*/
		break;
	    }
	}
	if( 0 <= svsock )
		ConnType = contype;

	*svsockp = svsock;
	return 1;
}
extern int ACC_TIMEOUT;
VSocket(Conn,command,sock,local,remote,options)
	Connection *Conn;
	char *command,*local,*remote,*options;
{	char rhost[256],lhost[256];
	int rport,lport;
	int nlisten,nsock;

char xremote[256];
nonxalpha_escapeX(remote,xremote,sizeof(xremote));
if( strcmp(remote,xremote) != 0 ){
	sv1log("## escape host-name before Vsocket %s: %s\n",
		command,xremote);
	remote = xremote;
}
	if( isinList(options,"self") )
		Conn->from_myself = 1;

	switch( *command ){
	  case 'q':
	  case 'Q':
		*options = 0;
		getpairName(sock,local,remote);
		break;

	/* ACCEPT */
	  case 'a':
	  case 'A':
		nsock = ACCEPT(sock,0,-1,ACC_TIMEOUT);
		sock = nsock;
		if( 0 <= sock )
		{
			gethostName(sock,local,"%A:%P");
			getpeerName(sock,remote,"%A:%P");
		}
		break;

	 /* BIND */
	  case 'b':
	  case 'B':
		rport = 0;
		sscanf(remote,"%[^:]:%d",rhost,&rport);
		lport = 0;
		sscanf(local,"%[^:]:%d",lhost,&lport);
		if( lhost[0] == 0 || lhost[0] == '*' )
		if( rhost[0] != 0 && rhost[0] != '*' )
			hostIFfor(rhost,lhost);
		nlisten = 0;
		if( strstr(options,"protocol=udp") )
			nlisten = -1;
		else
		if( strstr(options,"listen=") )
			sscanf(options,"listen=%d",&nlisten);
		{
		char *proto;
		if( nlisten < 0 )
			proto = "udpbind";
		else	proto = "tcpbind";
		SRCIFfor(Conn,proto,rhost,rport,lhost,&lport);
		}
		if( *lhost == '*' )
			lhost[0] = 0;
		sock = server_open("VSocket",lhost,lport,nlisten);
		if( sock < 0 ){
			sock = ReservedPortSock(lhost,lport);
			if( 0 <= sock ){
				sv1log("VSocket: reserved port [%s:%d]\n",
					lhost,lport);
			}
		}
		if( 0 <= sock )
		{
		char *proto;
			gethostName(sock,local,"%A:%P");
			sscanf(local,"%[^:]:%d",lhost,&lport);
			if( nlisten < 0 )
				proto = "udpbound";
			else	proto = "tcpbound";
			if( SRCIFfor(Conn,proto,rhost,rport,lhost,&lport) )
				sprintf(local,"%s:%d",lhost,lport);
		}
		break;

	/* CONNECT */
	  case 'c':
	  case 'C':
		sscanf(remote,"%[^:]:%d",rhost,&rport);
		set_realserver(Conn,"tcprelay",rhost,rport);
		sock = connect_to_serv(Conn,FromC,ToC,0);
		if( 0 <= sock )
			gethostName(sock,local,"%A:%P");
		break;
	}
	sv1tlog("VSocket %s %s %s %s = %d\n",command,local,remote,options,sock);
	return sock;
}


DELEGATE_forward(Conn,proto,dsthost,dstport,srchost,rproto,rhost,rport,rpath)
	Connection *Conn;
	char *proto,*dsthost,*srchost;
	char **rproto,**rhost;
	int *rport;
	char **rpath;
{	Route *Rp;
	int nd,ns,fi,fj;

	if( ForwardX == 0 )
		return 0;

	for( fi = 0; fi < ForwardX; fi++ ){
	  Rp = Forwards[fi];
	  nd = Rp->m_dsts.hl_cnt;
	  ns = Rp->m_srcs.hl_cnt;
	  if( !nd || hostIsinList(&Rp->m_dsts,proto,dsthost,dstport,NULL) )
	  if( !ns || hostIsinList(&Rp->m_srcs,ANYP,srchost,0,Ident()) )
	    {
		*rproto = Rp->m_gw_proto;
		*rhost  = Rp->m_gw_host;
		*rport  = Rp->m_gw_port;
		*rpath  = Rp->m_gw_path;
		return 1;
	    }
	}
	return 0;
}

TeleportServer(tunnel,invites)
	char *tunnel,*invites;
{	char *host;
	int port;
	int pid;
	int mi;
	Route *Rp;

	pid = 0;
	for( mi = 0; mi < MasterX; mi++ ){
		Rp = Masters[mi];
		if( Rp->m_teleport == 0 )
			continue;

		host = Rp->m_gw_host;
		port = Rp->m_gw_port;
		pid = bindTeleportVehicle(mi+1,NULL,host,port,tunnel,invites);
		sv1log(">>>>>> Teleport[%d] <<<<<< %s:%d\n",pid,host,port);
	}
	return pid;
}

static scan_MASTER0(Conn,host,port,route,filter)
	Connection *Conn;
	char *host,*route,*filter;
{	int mi;
	Route *Rp;
	char *host1;

	for( mi = 0; mi < MasterX; mi++){
		Rp = Masters[mi];
		host1 = Rp->m_gw_host;
		if( streq(host1,host) )
		if( Rp->m_gw_port == port ){
			Verbose("warning MASTER=%s duplicate\n",host);
			/*return;*/
		}
	}

	if( route )
		Verbose("MASTER=%s:%d/%s:%s\n",host,port,route,filter);
	else	Verbose("MASTER=%s:%d:%s\n",host,port,filter);

	mi = newRoute(MasterRoute);
	Rp = Masters[mi];

	if( route[0] ){
		if( strcasecmp(route,"NonHTTP") == 0 ){
			Rp->m_protoV_NonHTTP = 1;
		}else
		if( strcasecmp(route,"teleport") == 0 ){
			Rp->m_teleport = 1;
		}else
		if( strcasecmp(route,"cache") == 0 ){
			Rp->m_cacheonly = 1;
		}else
		sv1log("ERROR MASTER=%s:%d'/%s'?\n",host,port,route);
	}
	Rp->m_dsts.hl_what = StrAlloc("MASTER/FILTER");
	scan_commaListL(filter,STR_ALLOC,addHostList1,&Rp->m_dsts);

	Rp->m_gw_host = StrAlloc(host);
	Rp->m_gw_port = port;

	if( !(Rp->m_teleport && streq(host,"tty7")) )
	if( !IsResolvable(host) )
		sv1log("ERROR unknown host MASTER=%s\n",host);

}
scan_MASTER(Conn,master)
	Connection *Conn;
	char *master;
{	char host[1024],*dp;
	char ports[1024];
	char route[1024];
	char filter[2048];
	int port;

	route[0] = 0;
	filter[0] = 0;
	if( *master == '*' ){
		sscanf(master,"*:%s",filter);
		strcpy(host,"*");
		port = 0;
	}else
	if( sscanf(master,"%[^:]:%[^:]:%s",host,ports,filter) < 2 ){
		sv1log("ERROR MASTER=%s\n",master);
		return;
	}
	if( (dp = strchr(host,'/')) && dp != host ){
		*dp++ = 0;
		strcpy(route,dp);
	}
	if( dp = strchr(ports,'/') ){
		*dp++ = 0;
		strcpy(route,dp);
	}
	port = atoi(ports);
	scan_MASTER0(Conn,host,port,route,filter);
}
scan_DIRECT(Conn,hosts)
	Connection *Conn;
	char *hosts;
{
	scan_MASTER0(Conn,"@",0,"",hosts);
}

extern int FromTeleport;
extern int MASTER_ROUND_ROBIN;
DELEGATE_master(ms,master,mport,teleport,cacheonly)
	char **master;
	int *mport;
	int *teleport;
	int *cacheonly;
{	int mn,mi;
	Route *Rp;

	mn = MasterX;
	if( mn == 0  ) return 0;
	if( mn <= ms ) return 0;

	if( MASTER_ROUND_ROBIN )
		mi = (SERNO() + ms) % mn;
	else	mi = ms % mn;
	Rp = Masters[mi];

/*
FromTeleport should be inherited via exec()
also MASTER_delegated table should be ...
(currently MASTER=tty7/teleport is not inherited, thus the problem will not occur)
	sv1log("FromTeleport:%d [%d]%x\n",FromTeleport,
		Rp->m_teleport);
*/
	if( FromTeleport && Rp->m_teleport ){
		sv1log("DONT LOOPBACK TO Teleport.\n");
		*master = NULL;
	}else
	{
		*master = Rp->m_gw_host;
		*mport  = Rp->m_gw_port;
		*teleport = Rp->m_teleport;
		*cacheonly = Rp->m_cacheonly;
	}
	return mi+1;
}
get_masterenv(mx,version,server)
	char **version,**server;
{	Route *Rp;

	Rp = Masters[mx-1];
	if( Rp->m_Version ){
		*version = Rp->m_Version;
		*server = Rp->m_SERVER;
		return 1;
	}else	return 0;
}
set_masterenv(mx,version,server)
	char *version,*server;
{	Route *Rp;

	Rp = Masters[mx-1];
	Strdup(&Rp->m_Version,version);
	Strdup(&Rp->m_SERVER,server);
}

DELEGATE_Filter(mi,dstproto,dsthost,dstport)
	char *dstproto;
	char *dsthost;
{	HostList *hostlist;
	int rcode;
	Route *Rp;

	Rp = Masters[mi-1];

	if( NonHTTP(Rp,dstproto) )
		return -1;

	hostlist = &Rp->m_dsts;
	if( hostlist->hl_cnt == 0 )
		return 0;

	if( hostIsinList(hostlist,dstproto,dsthost,dstport,NULL) )
		rcode = 0;
	else	rcode = -1;
	Verbose("filter[%d]: %s = %d\n",mi,dsthost,rcode);
	return rcode;
}


/*///////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	proxy.c (client for URL proxy server)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940316	created
//////////////////////////////////////////////////////////////////////#*/

scan_PROXY(Conn,proxy)
	Connection *Conn;
	char *proxy;
{	char *proto,host[256],proxyb[2048];
	char protob[128];
	int port;
	char filter[2048];
	char route[2048];

	if( DFLT_PROTO[0] )
		proto = DFLT_PROTO;
	else	proto = "http";
	if( strstr(proxy,"://") ){
		sscanf(proxy,"%[^:]",protob);
		if( 0 < (port = serviceport(protob)) ){
			proto = protob;
			proxy += strlen(proto) + strlen("://");
			if( strcaseeq(proto,"delegate") ){
				sv1log("MASTER=%s\n",proxy);
				return scan_MASTER(Conn,proxy);
			}
			sv1log("PROXY = [%d/%s] %s\n",port,proto,proxy);
		}
	}

	port = 8080;
	strcpy(filter,"*");
	if( sscanf(proxy,"%[^:]:%d:%s",host,&port,filter) == 0 ){
		syslog_ERROR("PROXY=%s ?\n",proxy);
	}else{
		if( *filter == '{' ){
			int len;
			ovstrcpy(filter,filter+1);
			len = strlen(filter);
			if( 0 < len && filter[len-1] == '}' )
				filter[len-1] = 0;
		}
		sprintf(route,"%s://%s:%d/%s{%s}:{%s}",
			proto,host,port,DELMARK,filter,"*");
		scan_ROUTE(Conn,route);
	}
}

connectToUpper(Conn,where,proto,host,port)
	Connection *Conn;
	char *where,*proto,*host;
{	int routex;
	char *shost = "";
	char *orders;
	int sock;

	shost = Client_Host;
	routex = findRoute(Conn,Connects,0,ConnectX,proto,host,shost);
	if( 0 <= routex ){
		orders = Connects[routex]->m_conn;
		if( strchr(orders,C_SOCKS) ){
			sock = connectViaSocks(Conn,host,port,NULL,NULL);
			sv1log("%s '%s' via SOCKS = %d\n",where,proto,sock);
			return sock;
		}
		if( strchr(orders,C_SSLTUNNEL) ){
			sock = ConnectViaSSLtunnel(Conn,host,port);
			sv1log("%s '%s' via SSLtunnel = %d\n",where,proto,sock);
			return sock;
		}
	}
	return client_open(where,proto,host,port);
}

static char *SSLTUNNEL_HOST;
static int SSLTUNNEL_PORT;
scan_SSLTUNNEL(spec)
	char *spec;
{	char host[256];
	int port;

	port = 8080;
	if( sscanf(spec,"%[^:]:%d",host,&port) < 1 )
		return;
	if( !IsResolvable(host) ){
		sv1log("#### Unknown host -- SSLTUNNEL=%s:%d",host,port);
		return;
	}
	SSLTUNNEL_HOST = StrAlloc(host);
	SSLTUNNEL_PORT = port;
}
ConnectViaSSLtunnel(Conn,host,port)
	Connection *Conn;
	char *host;
{	int sock;
	char msg[1024],resp[4096],ver[1024];
	int wcc,rcc,rcode;

	if( SSLTUNNEL_HOST == NULL || SSLTUNNEL_PORT == 0 )
		return -1;
	sock = client_open("SSLtunnel","http",SSLTUNNEL_HOST,SSLTUNNEL_PORT);
	if( sock < 0 )
		return -1;

	toProxy = 2;
	strcpy(GatewayProto,"http"); /* for makeAuthorization() */

	sprintf(msg,"CONNECT %s:%d HTTP/1.0\r\n\r\n",host,port);
	{	char genauth[1024],auth[1024];
		if( makeAuthorization(Conn,genauth,1) ){
			sprintf(auth,"Proxy-Authorization: %s\r\n",genauth);
			RFC822_addHeaderField(msg,auth);
		}
	}
	sv1log("SSL-TUNNEL<< %s:%d\n",host,port);
	wcc = write(sock,msg,strlen(msg));
	rcc = RecvLine(sock,resp,sizeof(resp));
	if( rcc <= 0 )
		goto ERROR;
	sv1log("SSL-TUNNEL>> %s",resp);
	if( sscanf(resp,"%s %d",ver,&rcode) != 2 )
		goto ERROR;
	if( rcode != 200 )
		goto ERROR;
	for(;;){
		rcc = RecvLine(sock,resp,sizeof(resp));
		if( rcc <= 0 )
			goto ERROR;
		sv1log("SSL-TUNNEL>> %s",resp);
		if( resp[0] == '\r' || resp[0] == '\n' )
			break;
	}
	return sock;

ERROR:
	close(sock);
	return -1;
}

extern char *gethostaddr();
forward_RIDENT(Conn,where,svsock,ident)
	Connection *Conn;
	char *ident;
{	char sockname[512],peername[512];

	if( ServerFlags & PF_RIDENT_OFF )
		return;
	if( RIDENT_SERVER == 0 && (ServerFlags & PF_RIDENT) == 0 )
		return;
	if( ServerFlags & PF_RIDENT_SENT )
		return;
	if( TeleportHost[0] && TeleportPort ){
		sprintf(sockname,"%s:%d",TelesockHost,TelesockPort);
		if( TeleportAddr[0] )
		sprintf(peername,"%s:%d",TeleportAddr,TeleportPort);
		else
		sprintf(peername,"%s:%d",gethostaddr(TeleportHost),TeleportPort);
	}else{
		getpairName(ClientSock,sockname,peername);
	}

	RIDENT_sendX(svsock,sockname,peername,ident);
	ServerFlags |= PF_RIDENT_SENT;
}
connected_to_proxy(Conn,req,clsock)
	Connection *Conn;
	char *req;
{
	forward_RIDENT(Conn,'p',clsock,NULL);

	/* insert_FSERVER can already be done in ICP connect_to_serv()... */
	if( (Conn->xf_filters & XF_SERVER) == 0 )
		insert_FSERVER(Conn,ClientSock);

	if( (Conn->xf_filters & XF_FSV) && streq(DST_PROTO,"https") ){ 
		sv1log("## INSERTED FSV for HTTPS and CONNECT\n");
		return;
	}
	makeProxyRequest(Conn,req,req);
}

redirect_url(Conn,url,durl)
	Connection *Conn;
	char *url,*durl;
{	char turl[2048];
	char myhost[256];
	int myport;
	int len;

	if( DONT_REWRITE || is_redirected_url(url) )
		strcpy(durl,url);
	else{
		if( url == durl ){
			strcpy(turl,url);
			url = turl;
		}

		if( Conn->my_vbase.u_proto ){
			len = CTX_url_rurl(Conn,url,durl,
				Conn->my_vbase.u_proto,
				Conn->my_vbase.u_host,Conn->my_vbase.u_port,
				Conn->my_vbase.u_path,DO_DELEGATE);
		}else{
			myport = HTTP_ClientIF_H(Conn,myhost);
			len = CTX_url_rurl(Conn,url,durl,
				CLNT_PROTO,
				myhost,myport,Conn->cl_baseurl,DO_DELEGATE);
		}

		if( len == 0 )
			strcpy(durl,url);
	}
}

/*
 * translate a gopher selector to a URL
 */
gopherreq_to_URL(req,url)
	char *req,*url;
{	char gtype;
	char sel[1024],search[1024];

	gtype = get_gtype(req,req);
	sprintf(url,"%c%s",gtype,req);

	if( gtype == '7' )
	if( sscanf(url,"%[^\t]\t%[^\t\r\n]",sel,search) == 2 ){
		nonxalpha_escapeX(sel,sel,sizeof(sel));
		nonxalpha_escapeX(search,search,sizeof(search));
		sprintf(url,"%s?%s",sel,search);
	}
}

is_http_method(method)
	char *method;
{
	if( 0 == strcasecmp(method,"GET") )  return 1;
	if( 0 == strcasecmp(method,"PUT") )  return 1;
	if( 0 == strcasecmp(method,"POST") ) return 1;
	if( 0 == strcasecmp(method,"HEAD") ) return 1;
	return 0;
}


service_icp(Conn,sock,port)
	Connection *Conn;
{
	icp_server(sock,port);
}

#define NUMPEER		32
#define IC_PARENT	0x01
#define PX_DELEGATE	0x10
#define PX_ORIGINPROXY	0x20
#define PX_ORIGINSERVER	0x40

extern int ICP_DEBUGLOG;

select_icpconf(Conn,icpconf)
	Connection *Conn;
	char *icpconf;
{	char shost[256],*suser;
	int sport;
	char tmpbuf[1024];

	if( icpconf == NULL )
		icpconf = tmpbuf;

	sport = getClientHostPort(Conn,shost);
	suser = Ident();
	if( icp_selectconf(icpconf,DST_PROTO,DST_HOST,DST_PORT,
		shost,sport,suser) < 0 )
		return 0;
	return 1;
}

ConnectViaICP(Conn,dsturl)
	Connection *Conn;
	char *dsturl;
{	int sock;
	int icptypes[NUMPEER];
	char *icpaddrs[NUMPEER];
	int icpports[NUMPEER];
	int nserv;
	int sx;
	char url[URLSZ];
	char sxaddr[32];
	int sxport;
	char *pxhost;
	int pxport;
	int pxtype,pxtypes[NUMPEER];
	char *pxaddrs[NUMPEER];
	int pxports[NUMPEER];
	double timeout;
	int *objsize;
	char objbuff[URLSZ];
	char icpconf[128];
	int parent;
	char addrbuff[1024];
	char msg[1024];
	double Start,Connect;
	FILE *log = stderr;
	char urlhead[1024];

	if( !strcaseeq(iSERVER_PROTO,"http")
	 && !strcaseeq(iSERVER_PROTO,"nntp")
	 && !strcaseeq(iSERVER_PROTO,"ftp" )
	)	return -1;

	if( !select_icpconf(Conn,icpconf) )
		return -1;

	Start = Time();
	parent = 0;
	nserv = icp_getconf(icpconf,icptypes,icpaddrs,icpports,
		pxaddrs,pxports,&timeout,addrbuff);

	for( sx = 0; sx < nserv; sx++ ){
		if( icptypes[sx] & IC_PARENT )
			parent++;
	}

	if( PragmaNoCache ){
		if( parent == 0 )
			return -1;
		else	objsize = NULL;
	}else{
		if( strcaseeq(DST_PROTO,"http") )
			objsize = &Conn->ca_objsize;
		else	objsize = NULL;
	}

	if( dsturl ){
		strcpy(url,dsturl);
	}else
	if( HTTP_getICPurl(Conn,url) != 0 ){
		if( parent == 0 )
			return -1;
		/* just to select the parent */
		sprintf(url,"%s://",DST_PROTO);
		HostPort(url+strlen(url),DST_PROTO,DST_HOST,DST_PORT);
		objsize = NULL;
	}
	sprintf(urlhead,"%s://",DST_PROTO);
	HostPort(urlhead+strlen(urlhead),DST_PROTO,DST_HOST,DST_PORT);

	sx = icp_select(url,icptypes,icpaddrs,icpports,timeout,log,
		sxaddr,&sxport,1,objsize,objbuff);
	if( sx < 0 ){
		sprintf(msg,"(ICP-FAIL) %5.3f <%s>",Time()-Start,urlhead);
		sv1log("%s\n",msg);
		if( ICP_DEBUGLOG ) fprintf(log,"%s\n",msg);
		return -1;
	}

	if( 0 <= Conn->ca_objsize ){
		int io[2];
		Socketpair(io);
		setsockbuf(io[1],0,Conn->ca_objsize);
		write(io[1],objbuff,Conn->ca_objsize);
		close(io[1]);

		sprintf(msg,"(ICP-HITO) %5.3f [%s:%d] = %d <%s>",
			Time()-Start,
			icpaddrs[sx],icpports[sx],Conn->ca_objsize,urlhead);
		sv1log("%s\n",msg);
		if( ICP_DEBUGLOG ) fprintf(log,"%s\n",msg);
		return io[0];
	}

	if( strcmp(sxaddr,icpaddrs[sx]) == 0 )
		pxhost = pxaddrs[sx];
	else	pxhost = sxaddr;
	pxport = pxports[sx];
	pxtype = icptypes[sx];
	Connect = Time();

	sock = connectToUpper(Conn,"ICP-PROXY",DST_PROTO,pxhost,pxport);

	sprintf(msg,"(ICP-SUCC) %5.3f [%d][%s]>[%s]>%x[%s:%d]>(%d) %5.3f <%s>",
		Connect-Start,sx,icpaddrs[sx],sxaddr,
		pxtype,pxhost,pxport,sock,Time()-Connect,urlhead);
	sv1log("%s\n",msg);
	if( ICP_DEBUGLOG ) fprintf(log,"%s\n",msg);

	if( 0 <= sock ){
		if( pxtype & PX_ORIGINSERVER ){
		}else
		if( pxtype & PX_DELEGATE ){
			toMaster = 1;
		}else{
			setToProxy(Conn,"http",pxhost,pxport);
		}
	}

	return sock;
}
FILE *fopen_ICP(Conn,url,sizep,datep)
	Connection *Conn;
	char *url;
	int *sizep,*datep;
{	int sock;
	FILE *ts,*fs;
	char req[URLSZ],resp[128],*vp;

	sock = ConnectViaICP(Conn,url);

	if( 0 <= sock ){
		ts = fdopen(dup(sock),"w");
		fprintf(ts,"GET %s HTTP/1.0\r\n",url);
		fprintf(ts,"User-Agent: DeleGate/%s\r\n",DELEGATE_ver());
		fprintf(ts,"\r\n");
		fclose(ts);
		/*
		 * fgets() should be used but cannot be used because
		 * client FTP-DeleGate expects returned FILE pointing to
		 * the top of the target FILE and use read(fileno(FILE),...)
		 */
		while( 0 < RecvLine(sock,resp,sizeof(resp)) ){
			if( resp[0] == '\r' || resp[0] == '\n' )
				break;
			if( strncasecmp(resp,"Content-Length:",15) == 0 )
				*sizep = atoi(resp+15);
			else
			if( strncasecmp(resp,"Date:",5) == 0 ){
				vp = resp+5;
				while( *vp == ' ' )
					vp++;
				*datep = scanHTTPtime(vp);
			}
		}
		sv1log("#### fopen_ICP(%s) = [%d] %d %d\n",
			url,sock,*sizep,*datep);

		fs = fdopen(sock,"r");
		return fs;
	}
	return 0;
}
