/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1994-1999 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	inets.c (INET Socket manipulation)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	March94	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "ystring.h"
#include "vsignal.h"
#include "vsocket.h"
#include "vaddr.h"
#include "log.h"

/*
#define CONNECT_POLLOUT
*/

#define NHOSTS 128
typedef struct {
	int	hc_index;
	int	hc_freq;
	int	hc_predef;
	int	hc_mtime;
	int	hc_shuffled; /* initial shuffling done */
 struct hostent	hc_hostent;
} Hostent;

#define NIFTO	32
typedef struct {
	VAddr	if_dest;
	VAddr	if_mask;
	VAddr	if_ifto;
} IfTo;

typedef struct {
	char	ie_inets_errmsg[1024];
	jmp_buf	ie_jmpEnv;
	int	ie_NHosts;
       Hostent *ie_HostsCache[NHOSTS];
	char   *ie_myFQDN;
	char	ie_myFQDN_unknown[32];
	int	ie_ADDRLIST_RR;
	char	ie_inAddrs[8][32];
	int	ie_inAddrx;
	FILE   *ie_res_logf;
	int	ie_gotsig;
	char   *ie_SRCHOST;
	int	ie_SRCPORT;
	IfTo  **ie_iftoV;
	int	ie_iftoN;
	int	ie_CACHE_ONLY;
	int	ie_HOSTS_PREDEF;
	double	ie_resStart;
	int	ie_REUSE;
	int	ie_REUSEPORT;
	int	ie_SHUTDOWN;
	int	ie_DO_SHUFFLE; /* round-robin in the current implementation */
} InetsEnv;
static InetsEnv *inetsEnv;
#define IE	inetsEnv[0]

#define inets_errmsg	IE.ie_inets_errmsg
#define jmpEnv		IE.ie_jmpEnv
#define NHosts		IE.ie_NHosts
#define HostsCache	IE.ie_HostsCache
#define myFQDN		IE.ie_myFQDN
#define myFQDN_unknown	IE.ie_myFQDN_unknown
#define ADDRLIST_RR	IE.ie_ADDRLIST_RR
#define inAddrs		IE.ie_inAddrs
#define inAddrx		IE.ie_inAddrx
#define res_logf	IE.ie_res_logf
#define gotsig		IE.ie_gotsig
#define SRCHOST		IE.ie_SRCHOST
#define SRCPORT		IE.ie_SRCPORT
#define iftoV		IE.ie_iftoV
#define iftoN		IE.ie_iftoN
#define CACHE_ONLY	IE.ie_CACHE_ONLY
#define HOSTS_PREDEF	IE.ie_HOSTS_PREDEF
#define resStart	IE.ie_resStart
#define REUSE		IE.ie_REUSE
#define REUSEPORT	IE.ie_REUSEPORT
#define SHUTDOWN	IE.ie_SHUTDOWN
#define DO_SHUFFLE	IE.ie_DO_SHUFFLE

minit_inets(){
	if( inetsEnv == 0 ){
		inetsEnv = NewStruct(InetsEnv);
		REUSE = 1;
		SHUTDOWN = 1;
	}
}

#define sv1log syslog_ERROR

#define RESOLVERS_SIZ	512

extern char *Sprintf();
extern char **dupv();
extern char *VSA_ntoa();
extern char *VSA_htoa();
extern char *VSA_xtoap();
extern char *VSA_ltoa();
extern char *gethostaddr();
extern double Time();
extern char *resolv_errmsg;

static conf1(conf)
	char *conf;
{	char *name,nameb[32],*val;
	int neg;

	val = wordscanY(conf,nameb,sizeof(nameb),"^:");
	if( *val == ':' )
		val++;
	if( strncasecmp(nameb,"no",2) == 0 ){
		neg = 1;
		name = nameb + 2;
	}else{
		neg = 0;
		name = nameb;
	}
	if( strcaseeq(name,"reuse") ){
		REUSE = !neg;
	}else
	if( strcaseeq(name,"share") ){
		REUSEPORT = !neg;
	}
	else
	if( strcaseeq(name,"shut") ){
		SHUTDOWN = !neg;
	}
	return 0;
}
scan_SOCKOPT(ctx,conf)
	void *ctx;
	char *conf;
{
	scan_commaList(conf,0,conf1);
}


/*###################### LIBRARY BEGIN ################################*/

getFQDN(name,fqdn)
	char *name,*fqdn;
{	char porder[RESOLVERS_SIZ];
	struct hostent *hp;

	/* SPECIAL HOST NAME IN DeleGate */
	if( strcmp(name,"-")==0 || strcmp(name,"-.-")==0 ){
		ovstrcpy(fqdn,name);
		return 0;
	}
	if( strcmp(name,"localhost") == 0 ){
		ovstrcpy(fqdn,name);
		return 1;
	}
	RES_order("D",porder);
	hp = gethostbyname(name);
	RES_order(porder,NULL);
	if( hp != NULL ){
		strcpy(fqdn,hp->h_name);
		return 1;
	}
	if( name != fqdn )
		ovstrcpy(fqdn,name);
	return 0;
}
gethostFQDN(fqdn,size)
	char *fqdn;
{	char host[1024];

	gethostname(host,sizeof(host));
	return getFQDN(host,fqdn);
}
getPrimName(host,prim)
	char *host,*prim;
{	struct hostent *hp;

	/* SPECIAL HOST NAME IN DeleGate */
	if( strcmp(host,"-")==0 || strcmp(host,"-.-")==0 )
		strcpy(prim,host);
	else
	if( hp = gethostbyname(host) )
		strcpy(prim,hp->h_name);
	else	strcpy(prim,host);
}

fshutdown(fp,force)
	FILE *fp;
{
	if( SHUTDOWN == 0 && force == 0 )
		return -1;

	if( !file_ISSOCK(fileno(fp)) )
		return -1;

	fflush(fp);
	shutdown(fileno(fp),1);
	/* close(fileno(fp)); ... to do closesocket() on Win32 */
	return 0;
}

/*###################### LIBRARY END ##################################*/

#ifndef LIBRARY

int LIN_TIMEOUT = 30;
int DNS_TIMEOUT = 10;
int ACC_TIMEOUT = 10;
int CON_TIMEOUT = 10;

int CONNERR_TIMEOUT;
int CONNERR_CANTRESOLV;
int CONNERR_UNREACH;
int CONNERR_REFUSED;

static int HOSTS_CACHE_LIFE_MIN = 10;
static int HOSTS_CACHE_LIFE_MAX = 0;
extern int RES_CACHE_DISABLE;

static void sigALRM(sig){ longjmp(jmpEnv,SIGALRM); }
static void sigPIPE(sig){ longjmp(jmpEnv,SIGPIPE); }

#ifdef CONNECT_POLLOUT
Bconnect(s,name,namelen)
	VSAddr *name;
{	int rcode;
	double Start,Elapse;
	char hp[512];

	Start = Time();
	rcode = connectTO(s,(SAP)name,namelen,CON_TIMEOUT*1000);
	if( rcode != 0 && errno == ETIMEDOUT ){
		Elapse = Time() - Start;
		daemonlog("E","*** CON_TIMEOUT: %4.2f/%ds -> %s\n",
			Elapse,CON_TIMEOUT,VSA_xtoap(name,hp,sizeof(hp)));
	}
	return rcode;
}
#else
Bconnect(s,name,namelen)
	VSAddr *name;
{	int rcode;
	int timer;
	double Start;
	char hp[512];

	if( CON_TIMEOUT ){
		timer = pushTimer("Bconnect",sigALRM,CON_TIMEOUT);
		Start = Time();
		if( setjmp(jmpEnv) != 0 ){
			daemonlog("E","*** CON_TIMEOUT: %4.2f/%ds -> %s\n",
				Time()-Start,CON_TIMEOUT,
				VSA_xtoap(name,hp,sizeof(hp)));
			popTimer(timer);
			CONNERR_TIMEOUT = 1;
			errno = ETIMEDOUT;
			return -1;
		}
	}

	rcode = connect(s,(SAP)name,namelen);

	if( CON_TIMEOUT )
		popTimer(timer);

	return rcode;
}
#endif

int RESOLV_UNKNOWN;
extern int ERROR_RESTART;
struct hostent *Dgethostbyname(name)
	char *name;
{	struct hostent *ht;
	int fd;

	if( name[0] == 0 )
		return NULL;

if( strchr(name,'%') ){
	char xname[512];
	sv1log("## unescape host-name before gethostbyname: %s\n",name);
	nonxalpha_unescape(name,xname,0);
	name = xname;
}

	/*
	if( inet_addrV4(name) != -1 ){
		sv1log("#### simulate INCONSISTENT DNS\n");
		return NULL;
	}
	*/

	/* SPECIAL HOST NAME IN DeleGate */
	if( strcmp(name,"-")==0 || strcmp(name,"-.-")==0 )
		return NULL;

	fd = nextFD();
	ht = NULL;

	if( ht == NULL ){
		Verbose("gethostbyname(%s).\n",name);
		ht = gethostbyname(name);
	}
	if( ht == NULL ){
		RESOLV_UNKNOWN++;
		if( ERROR_RESTART )
		sv1log("eRESTART unknown*%d gethostbyname(%s)\n",
			RESOLV_UNKNOWN,name);
	}
	usedFD(fd);
	return ht;
}
struct hostent *Dgethostbyaddr(addr,len,type)
	char *addr;
{	struct hostent *ht;
	int fd;

	if( *(int*)addr == 0 || *(int*)addr == -1 )
		return NULL;

	fd = nextFD();
	ht = gethostbyaddr(addr,len,type);

	usedFD(fd);
	return ht;
}
static struct hostent *Dgethostbynameaddr(name,addr,len,type)
	char *name,*addr;
{
	if( name != NULL )
		return Dgethostbyname(name);
	else	return Dgethostbyaddr(addr,len,type);
}

extern char *getenv();
static order1(typespec,order,servers)
	char *typespec,*order,*servers[];
{	char type[128],arg[256];

	type[0] = arg[0] = 0;
	sscanf(typespec,"%[^:]:%s",type,arg);

	if( strcasecmp(type,"cache") == 0 )
		strcat(order,"C");
	else
	if( strcasecmp(type,"file") == 0 )
		strcat(order,"F");
	else
	if( strcasecmp(type,"nis") == 0 )
		strcat(order,"N");
	else
	if( strcasecmp(type,"dns") == 0 )
		strcat(order,"D");
	else
	if( strcasecmp(type,"sys") == 0 )
		strcat(order,"S");

	if( arg[0] )
		sprintf(order+strlen(order),":%s,",arg);
	return 0;
}

extern int (*RES_log)();
static res_log(which,byname,name,rv,cname)
	char *name,*rv[],*cname;
{	double Now;

	Now = Time();
	if( which == 0 )
		resStart = Now;
	else{
		fprintf(res_logf,"%.3f %.4f %d %c %s\n",
			Now,Now-resStart,Getpid(),which,name);
		fflush(res_logf);
	}
}

RES_prorder(resolvers,resolv)
	char *resolv;
{	int ri;
	extern char *RES_resolvers();
	char *rp,*res,res1[128],arg[128];

	rp = resolv;
	for( ri = 0; ri = RES_next_res(resolvers,ri,res1,arg); ){
		switch( res1[0] ){
		case 'C': res = "cache"; break;
		case 'F': res = "file"; break;
		case 'N': res = "nis"; break;
		case 'D': res = "dns"; break;
		case 'S': res = "sys"; break;
		default: res = res1; break;
		}
		if( rp != resolv )
			*rp++ = ',';
		strcpy(rp,res);
		rp += strlen(rp);
	}
	*rp = 0;
}
init_resolv(resolv,conf,ns,verify,rr,debug,log)
	char *resolv,*conf,*ns,*verify,*rr,*debug,*log;
{
	if( debug != NULL )
		RES_debug(debug);
	if( rr != NULL )
		RES_roundrobin(rr);

	if( log != NULL ){
		if( res_logf = fopen(log,"a") ){
			setCloseOnExec(fileno(res_logf));
			RES_log = res_log;
		}
	}

	if( resolv != NULL ){
		char order[RESOLVERS_SIZ],porder[RESOLVERS_SIZ];
		order[0] = 0;
		scan_commaList(resolv,0,order1,order);
		RES_order(order,porder);
		if( *resolv == 0 )
			CACHE_ONLY = 1;
	}
	if( conf != NULL )
		RES_conf(conf);
	if( ns != NULL )
		RES_ns(ns);
	if( verify != NULL )
		RES_verify(verify);

	init_myname(resolv);
}

static shuffle_addrlist(hp)
	struct hostent *hp;
{	char *haddr,*haddr0;
	int hi;

	if( hp->h_addr_list[0] == NULL || hp->h_addr_list[1] == NULL )
		return;

	if( ADDRLIST_RR ){
		haddr0 = hp->h_addr_list[0];
		for( hi = 0; haddr = hp->h_addr_list[hi+1]; hi++ )
			hp->h_addr_list[hi] = hp->h_addr_list[hi+1];
		hp->h_addr_list[hi] = haddr0;
	}
}
extern int CHILD_SERNO;
static shift_addrlist(hp)
	struct hostent *hp;
{	int na,sn,si;

	for( na = 0; hp->h_addr_list[na]; na++ )
		;
	if( na < 2 )
		return;
	sn = CHILD_SERNO % na;
	if( sn == 0 )
		return;
	for( si = 0; si < sn; si++ )
		shuffle_addrlist(hp);
}

static findName1(hp,name)
	struct hostent *hp;
	char *name;
{	char *name1;
	int ai;

	if( hp->h_name )
		if( strcasecmp(name,hp->h_name) == 0 )
			return 1;

	if( hp->h_aliases )
	for( ai = 0; name1 = hp->h_aliases[ai]; ai++ )
		if( strcasecmp(name,name1) == 0 )
			return 1;
	return 0;
}
static findAddr1(hp,addr,len,type)
	struct hostent *hp;
	char *addr;
{	int ai;
	char *addr1;

	for( ai = 0; addr1 = hp->h_addr_list[ai]; ai++ )
		if( bcmp(addr,addr1,len) == 0 )
			return 1;
	return 0;
}
static char *dump_HOST1();
static Hostent *findHostCache(name,addr,len,type)
	char *name,*addr;
{	int hi,ai,freq;
	Hostent *Hp;
	struct hostent *hp;

	for( hi = 0; hi < NHosts; hi++ ){
		Hp = HostsCache[hi];
		hp = &Hp->hc_hostent;
		if( name ){
			if( findName1(hp,name) )
				goto found;
		}else{
			if( findAddr1(hp,addr,len,type) )
				goto found;
		}
	}
	return 0;
found:
	freq = Hp->hc_freq += 1;
/*
	if( name )
		Verbose("*** HIT[%d] gethostbyname(%s)\n",freq,name);
	else	Verbose("*** HIT[%d] gethostbyaddr(): %s\n",freq,hp->h_name);
*/
	return Hp;
}
static char **addAliases(hp,aliasesb,name)
	struct hostent *hp;
	char *aliasesb[],*name;
{	int ai;
	char *name1;

	if( name == 0 )
		return hp->h_aliases;
	if( findName1(hp,name) )
		return hp->h_aliases;

	for( ai = 0; name1 = hp->h_aliases[ai]; ai++ )
		aliasesb[ai] = name1;
	aliasesb[ai++] = name;
	aliasesb[ai] = 0;
	return aliasesb;
}

/*
 * TODO: chache should be normalized so that only N to 1 correspondence
 *       (N names to an address) are included, to make update easy ???
 */
static struct hostent *addHostCache(name,aliases,type,len,addrlist)
	char *name,**aliases,**addrlist;
{	struct hostent *chp;
	int na,ai;
	Hostent *He;
	char hosts[2048];

	chp = NULL;

	/*
	 *  chp = first occurence of entry which include
	 *        name, aliases, or addrlist in it, if exists.
	 */

	if( chp == NULL && NHosts < NHOSTS ){
		He = NewStruct(Hostent);
		He->hc_index = NHosts;
		HostsCache[NHosts++] = He;
		He->hc_predef = HOSTS_PREDEF;
		He->hc_mtime = time(NULL);
		chp = &He->hc_hostent;
	}
	if( chp != NULL ){
		chp->h_name = stralloc(name);
		chp->h_aliases = dupv(aliases,0);
		chp->h_addrtype = type;
		chp->h_length = len;
		chp->h_addr_list = dupv(addrlist,len);
		dump_HOST1(hosts,chp);
		Verbose("HOSTS[%d]=%s %s\n",He->hc_index,hosts,He->hc_predef?"(PREDEF)":"");
		return chp;
	}
	return 0;
}
static replaceHostCache(name,addr,len,type, now,Hp,hp)
	char *name,*addr;
	Hostent *Hp;
	struct hostent *hp;
{	char *hname,*addrlistb[2],**addrlist;
	int addrleng;
	struct hostent *chp = &Hp->hc_hostent;
	int replaced;

	if( hp ){
		if( name && hp->h_name )
		if( strcmp(name,hp->h_name) != 0 ){
			sv1log("HOSTS[%d] cache can't be overwritten: %s->%s\n",
				Hp->hc_index,name,hp->h_name);
			Hp->hc_mtime = now;
			return 0;
		}
		hname = hp->h_name;
		addrlist = hp->h_addr_list;
		addrleng = hp->h_length;
	}else{
		addrlist = addrlistb;
		if( name ){
			hname = name;
			addrlist[0] = 0;
			addrleng = 4;
		}else{
			hname = "";
			addrlist[0] = addr;
			addrlist[1] = 0;
			addrleng = len;
		}
	}
	replaced = 0;
	if( name ){
		/*
		if( chp->h_addr_list[0] && addrlist[0] == 0 ){
			sv1log("#### INCONSISTENT but don't clear cache: %s\n",name);
		}else
		*/
		if( cmpv(chp->h_addr_list,addrlist,addrleng) ){
			freev(chp->h_addr_list);
			chp->h_addr_list = dupv(addrlist,addrleng);
			chp->h_length = addrleng;
			replaced = 1;
		}
	}else{
		if( strcmp(chp->h_name,hname) != 0 ){
			free(chp->h_name);
			chp->h_name = stralloc(hname);
			replaced = 1;
		}
	}
	if( replaced ){
		sv1log("HOSTS[%d] cache by-%s of '%s' replaced (age=%d)\n",
			Hp->hc_index,
			name?"name":"addr",name?name:hname,now-Hp->hc_mtime);
	}
	Hp->hc_mtime = now;
	return 1;
}

static struct hostent *addHostCacheOk(hp,name,func,Start)
	struct hostent *hp;
	char *name;
	char *func;
	double Start;
{	char **aliases,*aliasesb[1024];

	daemonlog("D","*** %s: %s / %4.2f secs. has_alias:%d\n",
		func,hp->h_name,Time()-Start,
		(hp->h_aliases[0] ? 1:0));

	aliases = addAliases(hp,aliasesb,name);
	return addHostCache(hp->h_name,aliases,hp->h_addrtype,hp->h_length,hp->h_addr_list);
}
static char *dumpAddr(aaddr,ba)
	char *aaddr;
	unsigned char *ba;
{
	return Sprintf(aaddr,"%d.%d.%d.%d",ba[0],ba[1],ba[2],ba[3]);
}
static char *scanAddr(aaddr,ba)
	char *aaddr;
	unsigned char *ba;
{	int a0,a1,a2,a3;

	if( sscanf(aaddr,"%d.%d.%d.%d",&a0,&a1,&a2,&a3) != 4 )
		return 0;

	ba[0] = a0;
	ba[1] = a1;
	ba[2] = a2;
	ba[3] = a3;
	return (char*)ba;
}

static dumpAddrs(hp,addrlist)
	struct hostent *hp;
	char *addrlist;
{	char *lp,*addr;
	int ai;

	addrlist[0] = 0;
	if( hp->h_addr_list[0] ){
		lp = addrlist;
		if( hp->h_addr_list[1] )
			lp = Sprintf(lp,"{");
		for( ai = 0; addr = hp->h_addr_list[ai]; ai++ ){ 
			if( 0 < ai )
				lp = Sprintf(lp,",");
			lp = dumpAddr(lp,hp->h_addr_list[ai]);
		}
		if( hp->h_addr_list[1] )
			lp = Sprintf(lp,"}");
	}
}
static char *dump_HOST1(hosts,hp)
	char *hosts;
	struct hostent *hp;
{	int ai;
	char *sp;
	char *name;

	sp = hosts;
	if( hp->h_aliases[0] ){
		sp = Sprintf(sp,"{");
		sp = Sprintf(sp,"%s",hp->h_name);
		for( ai = 0; name = hp->h_aliases[ai]; ai++ )
		sp = Sprintf(sp,",%s",name);
		sp = Sprintf(sp,"}");
	}else	sp = Sprintf(sp,"%s",hp->h_name);
	sp = Sprintf(sp,"/");
	dumpAddrs(hp,sp);
	return sp + strlen(sp);
}
dump_HOSTS(hosts)
	char *hosts;
{	char *sp;
	int hi;

	hosts[0] = 0;
	sp = hosts;
	for( hi = 0; hi < NHosts; hi++ ){
		if( 0 < hi )
			sp = Sprintf(sp,",");
		sp = dump_HOST1(sp,&HostsCache[hi]->hc_hostent);
	}
	if( ADDRLIST_RR ){
		if( 0 < NHosts )
			sp = Sprintf(sp,",");
		strcpy(sp,"*/*/RR");
	}
	return NHosts;
}
static find_HOSTS(hosts)
	char *hosts;
{	int hi;
	char hosts1[2048];

	for( hi = 0; hi < NHosts; hi++ ){
		dump_HOST1(hosts1,&HostsCache[hi]->hc_hostent);
		if( strcmp(hosts,hosts1) == 0 )
			return 1;
	}
	return 0;
}
static list2v(slist,vlist,isaddr)
	char *slist,*vlist[];
{	int ni = 0;
	char *np,*dp,*tp;

	if( slist[0] == '{' || strchr(slist,',') ){
		if( slist[0] == '{' ){
			np = slist + 1;
			if( tp = strchr(np,'}') )
				*tp = 0;
		}else	np = slist;

		for(; np; np = dp){
			if( dp = strchr(np,',') )
				*dp++ = 0;
			Verbose("[%d] %s\n",ni,np);
			if( isaddr )
				np = scanAddr(np,np);
			vlist[ni++] = np;

		}
		vlist[ni] = 0;
	}else{
		Verbose("[-] %s\n",slist);
		if( isaddr )
			slist = scanAddr(slist,slist);
		vlist[0] = slist;
		vlist[1] = 0;
		ni = 1;
	}
	return ni;
}

static gethostbyname1(name,addrb)
	char *name,*addrb;
{	struct hostent *hp;

	if( hp = Dgethostbyname(name) ){
		if( *addrb != 0 ){
			addrb += strlen(addrb);
			*addrb++ = ',';
		}
		dumpAddrs(hp,addrb);
	}
	return 0;
}
static gethostbynames(names,addrb)
	char *names,*addrb;
{	char nameb[0x4000];

	addrb[0] = 0;
	strcpy(nameb,names);
	scan_commaListL(nameb,0,gethostbyname1,addrb);
}
static addhost1(nameaddr)
	char *nameaddr;
{	char namesb[512],*names=namesb;
	char *addrs,addrb[512],*opts;
	char *addrlist[64];
	char *namelist[64],**aliases;

	if( find_HOSTS(nameaddr) )
		return 0;

	if( strcmp(nameaddr,"CACHE_ONLY") == 0){
		CACHE_ONLY = 1;
		goto EXIT;
	}

	if( strlen(nameaddr) < sizeof(namesb) )
		strcpy(names,nameaddr);
	else	names = stralloc(nameaddr);

	if( addrs = strchr(names,'/') ){
		*addrs++ = 0;
		if( opts = strchr(addrs+1,'/') )
			*opts++ = 0;
	}else	opts = 0;
	if( strcmp(nameaddr,"*/*/RR") == 0 ){
		ADDRLIST_RR = 1;
		goto EXIT;
	}

	if( addrs == 0 ){
		gethostbynames(names,addrb);
		if( addrb[0] == 0 )
			goto EXIT;
		addrs = addrb;
	}

	if( list2v(names,namelist,0) <= 0 )
		goto EXIT;
	if( list2v(addrs,addrlist,1) <= 0 )
		goto EXIT;

	if( namelist[0] )
		aliases = &namelist[1];
	else	aliases = &namelist[0];
	addHostCache(namelist[0],aliases,AF_INET,4,addrlist,opts);

EXIT:
	if( names != namesb )
		free(names);
	return 0;
}
scan_HOSTS(_,hosts)
	char *_,*hosts;
{
	HOSTS_PREDEF = 1;
	scan_commaList(hosts,0,addhost1);
	HOSTS_PREDEF = 0;
}

static struct hostent *gethostbyNameAddrNocache(name,addr,len,type)
	char *name,*addr;
{	struct hostent *hp;

	if( 0 < RES_timeout(DNS_TIMEOUT) ){
		hp = Dgethostbynameaddr(name,addr,len,type);
	}else{
		void (*sPIPE)();
		int timer;

		sPIPE = Vsignal(SIGPIPE,sigPIPE);
		timer = pushTimer("gethostbyNameAddr",sigALRM,DNS_TIMEOUT);
		if( (gotsig = setjmp(jmpEnv)) == 0 )
			hp = Dgethostbynameaddr(name,addr,len,type);
		else	hp = 0;
		signal(SIGPIPE,sPIPE);
		popTimer(timer);
	}
	return hp;

}
RES_CACHEONLY(flag)
{	int oflag;

	oflag = CACHE_ONLY;
	CACHE_ONLY = flag;
	return oflag;
}

IsInetaddr(addr)
	char *addr;
{
	return addr != NULL && VSA_strisaddr(addr);
}

extern char *VSA_hostlocal();
static struct hostent *gethostbyNameAddr(cache_only,name,aaddr,alen,atype)
	char *name,*aaddr;
{	struct hostent *hp;
	struct hostent *chp;
	Hostent *Hp;
	double Start;
	char func[1024];
	int nocache;
	int now;
	char *addr = aaddr; /* VC++ does not allocate omitted argument */
	int len = alen;
	int type = atype;

	if( name != NULL && *name == 0 ){
		Verbose("gethostbyNameAddr(empty)\n");
		return NULL;
	}
	if( name != NULL && strtailstr(name,VSA_hostlocal()) )
		name = VSA_hostlocal();

	if( name && isinetAddr(name) ){
		VSAddr sab;
		VSA_atosa(&sab,0,name);
		len = VSA_decomp(&sab,&addr,&type,NULL);
		daemonlog("D","*** gethostbyname(%s) -> byaddr(%d,%d)\n",
			name,len,type);
		name = 0;
	}

	nocache = RES_CACHE_DISABLE;
	if( cache_only || CACHE_ONLY )
		nocache = 0;

	now = time(NULL);
	if( Hp = findHostCache(name,addr,len,type) ){
		int expired = 0;
		int age = 0;

		if( !Hp->hc_predef ){
			age = now - Hp->hc_mtime;
			if( nocache ){
				if( HOSTS_CACHE_LIFE_MIN < age )
					expired = 1;
			}else{
				if( HOSTS_CACHE_LIFE_MAX )
				if( HOSTS_CACHE_LIFE_MAX < age )
					expired = 1;
			}
		}
		if( !expired ){
			hp = &Hp->hc_hostent;
			if( hp->h_name[0] == 0 || hp->h_addr_list[0] == 0 )
			{
				hp = NULL;
				goto EXIT;
				/*
				return 0;
				*/
			}
/*
			else	return hp;
*/
			else{
				if( DO_SHUFFLE )
				if( ADDRLIST_RR && Hp->hc_shuffled == 0 )
				{
					shift_addrlist(hp);
					Hp->hc_shuffled = 1;
				}
				/*
				return hp;
				*/
				goto EXIT;
			}
		}
	}
	if( cache_only || CACHE_ONLY )
	{
		/*
		return 0;
		*/
		hp = NULL;
		goto EXIT;
	}

	Start = Time();
	resolv_errmsg[0] = 0;

	hp = gethostbyNameAddrNocache(name,addr,len,type);

	if( name != NULL )
		sprintf(func,"gethostbyname(%s)",name);
	else	sprintf(func,"gethostbyaddr(%s)",VSA_ltoa(addr,len,type));

	if( hp == NULL )
	if( name != NULL && !IsInetaddr(name) || 1 < Time()-Start )
		daemonlog("E","%s unknown[%4.2fs] %s\n",func,
			Time()-Start,resolv_errmsg);

	if( gotsig ){
		if( gotsig == SIGALRM )
			sv1log("*** TIMEOUT %s: %d secs.\n",func,DNS_TIMEOUT);
		else	sv1log("*** SIGPIPE on %s to DNS.\n",func);
/*
endhostent();
hostent_init = 0;
*/
	}else{
		if( Hp && replaceHostCache(name,addr,len,type, now,Hp,hp) )
		{
			/*
			return hp;
			*/
			goto EXIT;
		}

		if( hp == 0 ){
			char *aliases[2],*addrlist[2];
			int addrleng;

			if( name ){
				addrlist[0] = 0;
				addrleng = 4;
			}else{
				addrlist[0] = addr;
				addrleng = len;
				name = "";
			}
			aliases[0] = 0;
			addrlist[1] = 0;
			chp = addHostCache(name,aliases,type,addrleng,addrlist);
		}else{
			chp = addHostCacheOk(hp,name,func,Start);
		}
	}
EXIT:
	if( hp == NULL ){
		CONNERR_CANTRESOLV = 1;
	}
	return hp;
}

static char *satoa(sa,host)
	VSAddr *sa;
	char *host;
{	char *addr;

	if( addr = VSA_ntoa(sa) )
		return strcpy(host,addr);
	else	return strcpy(host,"(AF_UNIX)");
}
static char *saton(sa,host)
	VSAddr *sa;
	char *host;
{	struct hostent *hp;
	char *baddr;
	int blen,btype;

	if( VSA_afunix(sa,host,128) )
		return host;

	blen = VSA_decomp(sa,&baddr,&btype,NULL);
	hp = gethostbyNameAddr(0,NULL,baddr,blen,btype);
	if( hp != 0 )
		return strcpy(host,hp->h_name);
	else	return satoa(sa,host);
}
printSock(sa,sockname,form)
	VSAddr *sa;
	char *sockname,*form;
{	char *addr;
	char *sp,*fp,fc;
	char host[512];

	sp = sockname;
	for( fp = form; fc = *fp; fp++ ){
	    if( fc != '%' ){
		*sp++ = fc;
		continue;
	    }
	    fp++;
	    switch( *fp ){
		default: sp = Sprintf(sp,"%%%c",*fp); break;
		case '%': *sp++ = fc; break;
		case 'A': sp = Sprintf(sp,"%s",satoa(sa,host)); break;
		case 'H': sp = Sprintf(sp,"%s",saton(sa,host)); break;
		case 'P': sp = Sprintf(sp,"%d",VSA_port(sa)); break;
	    }
	}
	*sp = 0;
}

char *gethostbyAddr(addr,host)
	char *addr,*host;
{	VSAddr sab;

	VSA_atosa(&sab,0,addr);
	return saton(&sab,host);
}
static setFIFOaddr(sap)
	VSAddr *sap;
{
	VSA_atosa(sap,1,"127.0.0.1");
}

sockAFUNIX(sock)
{	VSAddr name;
	int leng;

	leng = sizeof(VSAddr);
	if( getsockname(sock,(SAP)&name,&leng) != 0 )
		return 0;
	return VSA_afunix(name,NULL);
}
static xgetpeername(sock,name,lenp)
	VSAddr *name;
	int *lenp;
{	int slen,rcode;

	slen = *lenp;
	rcode = getpeername(sock,(SAP)name,lenp);
	if( rcode == 0 && *lenp <= 2 && VSA_afunix(name,NULL) )
	{
		*lenp = slen;
		rcode = getsockname(sock,(SAP)name,lenp);
	}
	return rcode;
}
#undef getpeername
#define getpeername xgetpeername

static gethostpeerName(sock,sockname,form,func)
	char *sockname;
	char *form;
	int (*func)();
{	VSAddr sab;
	int rcode;
	int addrlen;

	VSA_atosa(&sab,0,"0.0.0.0");
	addrlen = sizeof(VSAddr);

	if( (*func)(sock,&sab,&addrlen) == 0 ){
		if( addrlen == 0 && file_isfifo(sock) )
			setFIFOaddr(&sab);

		printSock(&sab,sockname,form);
		return 1;
	}else{
		strcpy(sockname,"?");
		return 0;
	}
}
VA_gethostpeerNAME(sock,name,Vaddr,func)
	char *name;
	VAddr *Vaddr;
	int (*func)();
{	VSAddr sab;
	int addrlen;

	VSA_atosa(&sab,0,"0.0.0.0");
	addrlen = sizeof(VSAddr);

	if( (*func)(sock,&sab,&addrlen) == 0 ){
		if( addrlen == 0 && file_isfifo(sock) )
			setFIFOaddr(&sab);

		if(Vaddr){
			*Vaddr = AddrZero;
			Vaddr->I3 = VSA_addr(&sab);
			Vaddr->a_port = VSA_port(&sab);
		}
		if(name) printSock(&sab,name,"%H");
		return 1;
	}else{
		sv1tlog("FATAL: get{host|peer}name(%d) failed, errno=%d\n",
			sock,errno);
		if(Vaddr) *Vaddr = AddrNull;
		if(name) strcpy(name,"?");
		return 0;
	}
}
gethostName(sock,sockname,form)
	char *sockname,*form;
{
	return gethostpeerName(sock,sockname,form,getsockname);
}
getpeerName(sock,sockname,form)
	char *sockname,*form;
{	int rcode;
	int sresolv;
	char porder[RESOLVERS_SIZ],torder[RESOLVERS_SIZ];

	RES_order("",porder);
	if( strchr(porder,'D') == 0 ){
		sprintf(torder,"%sD",porder); /* use DNS anyway */
		RES_order(torder,NULL);
	}else	RES_order(porder,NULL);

	rcode = gethostpeerName(sock,sockname,form,getpeername);

	RES_order(porder,NULL);
	return rcode;
}
getpeerAddr(sock,saddr)
	char *saddr;
{	int port;

	if( getpeersNAME(sock,NULL,saddr,&port) )
		return port;
	strcpy(saddr,"255.255.255.255");
	return -1;
}
VA_getpeerNAME(sock,Vaddr)
	VAddr *Vaddr;
{
	return VA_gethostpeerNAME(sock,Vaddr->a_name,Vaddr,getpeername);
}
gethostAddr(sock,saddr)
	char *saddr;
{
	if( gethostName(sock,saddr,"%A") )
		return sockPort(sock);
	else	return 0;
}
VA_gethostNAME(sock,Vaddr)
	VAddr *Vaddr;
{
	return VA_gethostpeerNAME(sock,Vaddr->a_name,Vaddr,getsockname);
}
gethostNAME(sock,name)
	char *name;
{	VAddr addr;

	if( VA_gethostpeerNAME(sock,name,&addr,getsockname) )
		return addr.a_port;
	else	return 0;
}
getpeerNAME(sock,name)
	char *name;
{	int rcode;
	int sresolv;
	char porder[RESOLVERS_SIZ],torder[RESOLVERS_SIZ];
	VAddr addr;

	RES_order("",porder);
	if( strchr(porder,'D') == 0 ){
		sprintf(torder,"%sD",porder); /* use DNS anyway */
		RES_order(torder,NULL);
	}else	RES_order(porder,NULL);

	rcode = VA_gethostpeerNAME(sock,name,&addr,getpeername);

	RES_order(porder,NULL);

	if( rcode )
		return addr.a_port;
	else	return 0;
}
getpeersNAME(sock,name,saddr,portp)
	char *name,*saddr;
	int *portp;
{	int rcode;
	VAddr addr;

	rcode = VA_gethostpeerNAME(sock,name,&addr,getpeername);
	if( rcode ){
		if( portp ) *portp = addr.a_port;
		inetNtoa(htonl(addr.I3),saddr);
	}
	return rcode;
}
VA_inetNtoah(Vaddr,saddr)
	VAddr *Vaddr;
	char *saddr;
{
	inetNtoa(htonl(Vaddr->I3),saddr);
}

static Accept(sock,isServer,lockfd,sockname)
	char *sockname;
{	int clsock;
	VSAddr sab;
	int addrlen;

	addrlen = sizeof(VSAddr);
	clsock =  accept(sock,(SAP)&sab,&addrlen);

	if( 0 <= clsock && addrlen == 0 ){
		sv1log("#### accept addrlen==0 [%d]\n",clsock);
		close(clsock);
		clsock = -1;
	}else
	if( sockname ){
		VSA_xtoap(&sab,sockname,128);
	}
	return clsock;
}
/*
 *	a valid (non-negative) lockfd means that parallel accept() should
 *	be mutually excluded, and accept() should be protected from
 *	(SIGALRM) interrupt.
 */
ACCEPT1(sock,isServer,lockfd,timeout,sockname)
	char *sockname;
{	int clsock;
	int NB;
	char sockport[32];

	if( lockfd < 0 && timeout == 0 )
		return Accept(sock,isServer,lockfd,sockname);

	clsock = -1;
	sprintf(sockport,"[%d]:%d",sock,sockPort(sock));

	if( 0 <= lockfd && lock_exclusiveTO(lockfd,timeout*1000,NULL) != 0 ){
		sv1log("## accept(%s) failed locking, errno=%d\n",sockport,errno);
		goto EXIT;
	}

	if( PollIn(sock,timeout*1000) <= 0 )
		sv1log("## accept(%s) failed polling, errno=%d\n",sockport,errno);
	else{
		clsock = Accept(sock,isServer,lockfd,sockname);
		Verbose("## accept(%s)=%d\n",sockport,clsock);
	}

	if( 0 <= lockfd )
		lock_unlock(lockfd);

EXIT:
	return clsock;
}
ACCEPT(sock,isServer,lockfd,timeout)
{
	return ACCEPT1(sock,isServer,lockfd,timeout,NULL);
}

static newsocket(what,d,t,p)
	char *what;
{	int sock;

	sock = socket(d,t,p);
	if( sock < 0 ){
		sv1tlog("FATAL: socket(%s) failed, errno=%d\n",what,errno);
	}
	return sock;
}

set_SRCPORT(host,port)
	char *host;
{
	SRCHOST = streq(host,"*") ? "" : host;
	SRCPORT = port;
}
bind_SRCPORT(sock)
{	char sockname[256];
	VSAddr Vaddr;

	if( SRCHOST == 0 )
		return;
	if( SRCHOST[0] == 0 && SRCPORT == 0 )
		return;

	setsockREUSE(sock,1);
/*
	bind_insock(sock,SRCHOST,SRCPORT);
*/
	VSA_atosa(&Vaddr,0,*SRCHOST?gethostaddr(SRCHOST):"0.0.0.0");
	bind_inets(sock,&Vaddr,0,SRCPORT);

	gethostName(sock,sockname,"%A:%P");
	sv1log("[%d] source port = %s:%d = %s\n",sock,SRCHOST,SRCPORT,sockname);
	/*
	int on = 1;
	rcode = Setsockopt(sock, SOL_SOCKET, SO_DONTROUTE, &on, sizeof(on));
	Verbose("#### [%s] dontroute = %d\n",sockname,rcode);
	*/
}
double SVHELLO_TIMEOUT;
static sockopen1(asock,sap,what,portname,hostname)
	VSAddr *sap;
	char *what,*portname,*hostname;
{	int sock;
	int rcode;
	char aaddr[256];
	int iport,salen;
	char remote[256],local[256];
	double Time(),Start;

	if( 0 <= asock )
		sock = asock;
	else	sock = newsocket(what,AF_INET,SOCK_STREAM,0);
	if( sock < 0 )
		return -1;

	strcpy(aaddr,VSA_ntoa(sap));
	iport = VSA_port(sap);
	salen = VSA_size(sap);

	Verbose("%s connect %s://%s:%d\n",what,portname,hostname,iport);
	Start = Time();

	bind_SRCPORT(sock);

	rcode = Bconnect(sock,(SAP)sap,salen);
	inets_errmsg[0] = 0;
	if( rcode != 0 ){
		if( errno == ECONNREFUSED) CONNERR_REFUSED = 1;
		if( errno == ENETUNREACH ) CONNERR_UNREACH = 1;
		if( errno == EHOSTUNREACH) CONNERR_UNREACH = 1;
		if( errno == ETIMEDOUT   ) CONNERR_TIMEOUT = 1;
		
		if( errno == EISCONN || errno == EINPROGRESS )
			return sock;
		sprintf(inets_errmsg,
			"[%d] %s connect failed %s:%d [%4.2fs] errno=%d",
			sock,what,aaddr,iport, Time()-Start,errno);
		sv1log("%s\n",inets_errmsg);
		if( sock != asock )
			close(sock);
		return -1;
	}
	getpeerName(sock,remote,"%A:%P");
	gethostName(sock,local,"%A:%P");
	daemonlog("I","%s connected [%d] {%s <- %s} [%4.3fs]\n",
		what,sock,remote,local, Time()-Start);

	if( 0 < SVHELLO_TIMEOUT ){
		int timeout = SVHELLO_TIMEOUT*1000;
		if( timeout == 0 )
			timeout = 1;
		if( PollIn(sock,timeout) <= 0 ){
			close(sock);
			sock = -1;
			daemonlog("E","%s hello from server timedout\n",remote);
		}
	}

	return sock;
}
static sockopens(sock,port,hp,what,portname,hostname)
	struct hostent *hp;
	char *what,*portname,*hostname;
{	int hi;
	VSAddr sab;
	char *haddr;

	shuffle_addrlist(hp);
	for( hi = 0; haddr = hp->h_addr_list[hi]; hi++ ){
		VSA_htosa(&sab,port,hp,hi);
		sock = sockopen1(sock,&sab,what,portname,hostname);
		if( 0 <= sock )
			return sock;
	}
	return -1;
}

gethostintMin(host)
	char *host;
{	struct hostent *hp;
	VSAddr sab;
	char *baddr;
	int btype,bsize;
	int ai;
	unsigned int addr,addr1;

	if( VSA_strisaddr(host) ){
		VSA_atosa(&sab,0,host);
		bsize = VSA_decomp(&sab,&baddr,&btype,NULL);
		hp = gethostbyNameAddr(0,NULL,baddr,bsize,btype);
	}else{
		hp = gethostbyNameAddr(0,host);
	}
	if( hp != NULL ){
		addr = 0xFFFFFFFF;
		for( ai = 0; hp->h_addr_list[ai]; ai++ ){
			VSA_htosa(&sab,0,hp,ai);
			addr1 = VSA_addr(&sab);
			if( addr1 < addr )
				addr = addr1;
		}
		return htonl(addr);
	}
	return -1;
}
static
char *_gethostaddr(host,cache_only)
	char *host;
{	struct hostent *hp;

	if( VSA_strisaddr(host) )
		return host;

	if( hp = gethostbyNameAddr(cache_only,host) )
		return VSA_htoa(hp);

	return 0;
}
char *gethostaddr(host) char *host; {
	return _gethostaddr(host,0);
}
char *gethostaddr_fromcache(host) char *host; {
	return _gethostaddr(host,1);
}
static __gethostint_nbo(cacheonly,host,primname)
	char *host,*primname;
{	struct hostent *hp;
	VSAddr sab;
	int iaddr;

	iaddr = inet_addrV4(host);
	if( iaddr != -1 && primname == NULL )
		return iaddr;

	if( hp = gethostbyNameAddr(cacheonly,host) ){
		if( primname != NULL )
			strcpy(primname,hp->h_name);
		VSA_htosa(&sab,0,hp,0);
		iaddr = htonl(VSA_addr(&sab));
	}
	return iaddr;
}
gethostint_nboV4(host)
	char *host;
{
	return __gethostint_nbo(0,host,NULL);
}
strNetaddr(host,net)
	char *host,*net;
{	VAddr Hosta;
	int hosti;

	VA_gethostint_nbo(host,&Hosta);
	hosti = ntohl(Hosta.I3);
	switch( (hosti >> 24) & 0xC0 ){
		case 0x00: hosti &= 0xFF000000; break;
		case 0x80: hosti &= 0xFFFF0000; break;
		case 0xC0: hosti &= 0xFFFFFF00; break;
	}
	if( net != NULL )
		sprintf(net,"%d.%d.%d.%d",
			0xFF&(hosti>>24),
			0xFF&(hosti>>16),
			0xFF&(hosti>>8),
			0xFF&(hosti));

	return htonl(hosti);
}

/*
 * true only when gethostbyXXX() is OK
 */
hostIsResolvable(host)
	char *host;
{
	return gethostintMin(host) != -1;
}
/*
 * true also when the host name is IP-address string
 */
IsResolvable(host)
	char *host;
{
	return VA_gethostint_nbo(host,NULL);
}
VA_gethostint_nbo(host,Vaddr)
	char *host;
	VAddr *Vaddr;
{	int a1;

	a1 = __gethostint_nbo(0,host,NULL);
	if( a1 == -1 ){
		if( Vaddr )
			*Vaddr = AddrNull;
		return 0;
	}else{
		if( Vaddr ){
			*Vaddr = AddrZero;
			Vaddr->I3 = a1;
		}
		return 1;
	}
}
VA_gethostVAddr(cacheonly,host,primname,Vaddr)
	char *host,*primname;
	VAddr *Vaddr;
{	int a1;

	a1 = __gethostint_nbo(cacheonly,host,primname);
	if( a1 == -1 ){
		if( Vaddr )
			*Vaddr = AddrNull;
		return 0;
	}else{
		if( Vaddr ){
			*Vaddr = AddrZero;
			Vaddr->I3 = ntohl(a1);
		}
		return 1;
	}
}
VA_strtoVAddr(saddr,Vaddr)
	char *saddr;
	VAddr *Vaddr;
{	int a1;

	a1 = inet_addrV4(saddr);
	if( a1 == -1 ){
		if( Vaddr )
			*Vaddr = AddrNull;
		return 0;
	}else{
		if( Vaddr ){
			*Vaddr = AddrZero;
			Vaddr->I3 = ntohl(a1);
		}
		return 1;
	}
}

VA_setVAddr(Vaddr,addr,port,remote)
	VAddr *Vaddr;
	char *addr;
{
	VA_strtoVAddr(addr,Vaddr);
	wordscanX(addr,Vaddr->a_name,sizeof(Vaddr->a_name));
	Vaddr->a_port = port;
	if( remote )
		Vaddr->a_flags |= VA_REMOTE;
}

static ipv4cmp(a1,a2)
	unsigned char *a1,*a2;
{	int ai;

	for( ai = 0; ai < 4; ai++ )
		if( a1[ai] != a2[ai] )
			return 1;
	return 0;
}

/*
 * return non-zero if hp2 includes some element which is not
 * included in hp1.
 */
hostentcmp(hp1,hp2)
	struct hostent *hp1,*hp2;
{	char *a1,*a2;
	int n1,n2;
	int diff;

	for( n1 = 0; hp1->h_addr_list[n1]; n1++ );
	for( n2 = 0; hp2->h_addr_list[n2]; n2++ );
	if( n1 < n2 )
		return 1;

	for( n2 = 0; a2 = hp2->h_addr_list[n2]; n2++ ){
		for( n1 = 0; a1 = hp1->h_addr_list[n1]; n1++ )
			if( ipv4cmp(a2,a1) == 0 )
				break;
		if( a1 == NULL )
			return 1;
	}
	return 0;
}

__connectServer(sock,what,portname,hostname,iport)
	char *what,*portname,*hostname;
{	struct hostent *hp;
	VSAddr sab,*sap = &sab;
	char hostnameb[256],*aaddr;
	char path[1024];

	if( hostlocal2path(hostname,path,sizeof(path)) ){
		sv1log("## connect %s ...\n",path);
		hostname = path;
	}

	if( hostname != NULL && hostname[0] == '/' )
		return client_open_un(what,hostname,0);

/*
	if( sock < 0 && ViaVSAPassociator(-1) && strncmp(portname,"VSAP",4) != 0 ){
		char sockname[256],peername[256];
		sockname[0] = 0;
		sprintf(peername,"%s:%d",hostname,iport);
		sock = VSAPconnect(sockname,peername);
		if( 0 <= sock ){
			sv1log("#### connected via TELEPORT\n");
			return sock;
		}
		sv1log("#### connection via TELEPORT failed.\n");
	}
*/

	VSA_atosa(sap,iport,"0.0.0.0");
	inets_errmsg[0] = 0;

	if( hostname == NULL || hostname[0] == 0 ){
		hostname = hostnameb;
		strcpy(hostnameb,"localhost");
		if( !IsResolvable(hostnameb) )
			gethostname(hostnameb,sizeof(hostnameb));
	}

	if( VSA_strisaddr(hostname) ){
		VSA_atosa(sap,iport,hostname);
		return sockopen1(sock,sap,what,portname,hostname);
	}

/*
	if( hp = gethostbyNameAddr(0,hostname) ){
*/
	DO_SHUFFLE = 1;
	hp = gethostbyNameAddr(0,hostname);
	DO_SHUFFLE = 0;
	if( hp ){
		int nsock;
		struct hostent *nhp;

		nsock = sockopens(sock,iport,hp,what,portname,hostname);
		if( 0 <= nsock )
			return nsock;
/*
if( !nonblocking ){
	nhp = gethostbyNameAddrNocache(hostname);
	if( 0 < hostentcmp(hp,nhp) ){
		nsock = sockopens(sock,iport,nhp,what,portname,hostname);
		sv1log("## connect(%s) retried without hosts cache = %d\n",
			hostname,nsock);
		return nsock;
	}
}
*/
		return -1;
	}else
	if( aaddr = gethostaddr(hostname) ){
		VSA_atosa(sap,iport,aaddr);
		return sockopen1(sock,sap,what,portname,hostname);
	}else{
		CONNERR_CANTRESOLV = 1;
		sprintf(inets_errmsg,"%s unknown host '%s'",what,hostname);
		sv1log( "%s\n",inets_errmsg);
		return -1;
	}
}
connectServer(what,portname,hostname,iport)
	char *what,*portname,*hostname;
{
	return __connectServer(-1,what,portname,hostname,iport);
}
client_open(what,portname,hostname,iport)
	char *what,*portname,*hostname;
{
	return __connectServer(-1,what,portname,hostname,iport);
}

UDP_client_open1(what,portname,hostname,iport,lhost,lport)
	char *what,*portname,*hostname,*lhost;
{	int asock,rsock;

	asock = socket(AF_INET,SOCK_DGRAM,0);
	sv1log("UDP_client_open[%d] %s://%s:%d ...\n",asock,portname,hostname,iport);
	if( 0 <= lport )
		bind_insock(asock,lhost,lport);
	rsock = __connectServer(asock,what,portname,hostname,iport);
	if( rsock < 0 )
		close(asock);
	return rsock;
}
UDP_client_open(what,portname,hostname,iport)
	char *what,*portname,*hostname;
{
	return UDP_client_open1(what,portname,hostname,iport,NULL,-1);
}

hostIFfor(rhost,hostIF)
	char *rhost,*hostIF;
{
	if( hostIFfor1(hostIF,1,"time",rhost,37) )
		return 1;
	if( hostIFfor1(hostIF,0,"time",rhost,37) )
		return 1;
	if( hostIFfor1(hostIF,0,"echo",rhost,7) )
		return 1;
	if( hostIFfor1(hostIF,0,"domain",rhost,53) )
		return 1;
	if( hostIFfor1(hostIF,0,"http",rhost,80) )
		return 1;
	return 0;
}
hostIFfor1(hostIF,udp,proto,rhost,rport)
	char *hostIF,*proto,*rhost;
{	int sock;

	hostIF[0] = 0;
	if( udp )
		sock = UDP_client_open("checkIF-UDP",proto,rhost,rport);
	else	sock = client_open("checkIF-TCP",proto,rhost,rport);

	if( 0 <= sock ){
		gethostNAME(sock,hostIF);
		close(sock);
		if( hostIF[0] && strcmp(hostIF,"0.0.0.0") != 0 )
			return 1;
	}
	return 0;
}

hostIFfor0(hostIF,udp,proto,rhost,rport,dontroute)
	char *hostIF,*proto,*rhost;
{	int sock,on;
	VSAddr sab;
	char *aaddr;
	int alen,got;

	aaddr = gethostaddr(rhost);
	if( aaddr == NULL )
		return 0;
	alen = VSA_atosa(&sab,rport,aaddr);

	got = 0;
	sock = socket(AF_INET,udp?SOCK_DGRAM:SOCK_STREAM,0);

	if( dontroute ){
		on = 1;
		Setsockopt(sock, SOL_SOCKET, SO_DONTROUTE, &on, sizeof(on));
	}
	if( connect(sock,(SAP)&sab,alen) == 0 )
		got = gethostAddr(sock,hostIF);
	close(sock);
	return got;
}

IsConnected(sock,reason)
	char **reason;
{	int nready,rcc;
	char buf[1];

	if( peerPort(sock) < 1 ){
		if(reason) *reason = "cant_getpeername";
		return 0;
	}

if(reason) *reason = "connected";
return 1;

/*
	nready = rPollIn(sock,1);
	if( nready < 0 ){
		if(reason) *reason = "peer_reset";
		return 0;
	}

	if( nready == 0 ){
		if(reason) *reason = "poll_none_ready";
		return 1;
	}

	rcc = recv(sock,buf,1,MSG_PEEK);
	if( rcc == 1 ){
		if(reason) *reason = "recv_ok";
		return 1;
	}

	if(reason) *reason = "cant_recv";
	return 0;
*/
}
IsAlive(sock){
	if( IsConnected(sock,NULL) ){
		if( PollIn(sock,1) == 0 || 0 < Peek1(sock) ) 
			return 1;
		else	sv1log("## left connected but dead [%d]\n",sock);
	}
	return 0;
}

int MAX_BUFF_SOCKSEND = 0x4000;
int MAX_BUFF_SOCKRECV = 0x4000;
std_setsockopt(sock)
{	int bsize;
	int On = 1, No = 0;

	Setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &No, sizeof(No));
	bsize = MAX_BUFF_SOCKRECV;
	Setsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bsize,sizeof(bsize));
	bsize = MAX_BUFF_SOCKSEND;
	Setsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bsize,sizeof(bsize));
}

char *ext_binder = "dgbind";
char *binder_path;

Bind(sock,sap,len)
	VSAddr *sap;
{	char *av[8],ab[256],*ap,*host,path[1024];
	int port,ac,rcode;

	rcode = bind(sock,(SAP)sap,len);
	if( rcode != 0 && errno == EACCES && INHERENT_fork() ){
		if( binder_path == 0 ){
			strcpy(path,ext_binder);
			/*
			fullpathSUCOM(ext_binder,"r",path);
			*/
			if( fullpathSUCOM(ext_binder,"r",path) == 0 ){
				sv1log("## command not found: %s\n",ext_binder);
				return rcode;
			}
			sv1log("## dgbind = %s\n",path);
			binder_path = stralloc(path);
		}

		ac = 0;
		ap = ab;
		host = VSA_ntoa(sap);
		port = VSA_port(sap);
		av[ac++] = ap; strcpy(ap,ext_binder); ap += strlen(ap)+1;
		av[ac++] = ap; sprintf(ap,"%d",sock); ap += strlen(ap)+1;
		av[ac++] = ap; sprintf(ap,"%d",port); ap += strlen(ap)+1;
		av[ac++] = ap; strcpy(ap,host); ap += strlen(ap)+1;
		av[ac] = 0;

		if( fork() == 0 ){
			Execvp("Bind",binder_path,av);
			exit(-1);
		}
		wait(0);
		if( 0 < sockPort(sock) ){
			rcode = 0;
		}
	}
	return rcode;
}
#define bind Bind

static ftp_conndata0(src,dst,laddr,lport)
	VSAddr *src,*dst,*laddr;
{	int sock;
	char sockname[256],peername[256];
	int iport;
	int salen;

	sock = newsocket("ftp-data-con",AF_INET,SOCK_STREAM,0);
	if( sock == -1 ){
		sv1log("ftp_conndata: cannot create socket: %d.\n",errno);
		return -1;
	}

	if( src && (VSA_addr(src) || VSA_port(src)) ){
		setsockREUSE(sock,1);
		setsockSHARE(sock,1);
		salen = VSA_size(src);
		if( laddr == NULL || bind_inets(sock,laddr,0,lport) != 0 )
		if( bind(sock,(SAP)src,salen) != 0 ){
			sv1log("## ftp-conndata: NOT bound#1 err=%d\n",errno);
			VSA_setport(src,0);
			if( bind(sock,(SAP)src,salen) != 0 )
			sv1log("## ftp-conndata: NOT bound#2 err=%d\n",errno);
		}
	}

	printSock(dst,peername,"%H/%A:%P");
	salen = VSA_size(&dst);
	gethostName(sock,sockname,"%A:%P");
	if( Bconnect(sock,(SAP)dst,salen) != 0 ){
		close(sock);
		sv1log("ftp_conndata: connection refused %s->%s, errno=%d\n",
			sockname,peername,errno);
		return -1;
	}
	gethostName(sock,sockname,"%A:%P");
	sv1log("ftp_conndata: connected %s->%s [%d]\n",sockname,peername,sock);
	return sock;
}
static ftp_conndata(src,dst,laddr,lport)
	VSAddr *src,*dst,*laddr;
{	int rcode;

	rcode = ftp_conndata0(src,dst,laddr,lport);
	if( rcode == -1 && src && VSA_port(src) )
	/*if( errno == ECONNREFUSED )*/
	{
		sv1log("ftp_conndata: retry without port# (%d)\n",
			VSA_port(src));
		VSA_setport(src,0);
		rcode = ftp_conndata0(src,dst,laddr,lport);
	}
	return rcode;
}

/*
 *	REUSE ON to restart server immediately.
 */

int S_ADDRNOTAVAIL;
static bind_inet(sock,sap,nlisten)
	VSAddr *sap;
{	int salen,rcode;
	char *msg;
	char hp[512];

	Setsockopt(sock,SOL_SOCKET,SO_REUSEADDR,&REUSE,sizeof(REUSE));
	if( REUSEPORT )
		setsockSHARE(sock,1);
	salen = VSA_size(sap);
	rcode = bind(sock,(SAP)sap,salen);

	S_ADDRNOTAVAIL = 0;
	if( rcode != 0 ){
		switch( errno ){
		case EADDRINUSE: msg = "(the port is used by others)"; break;
		case EACCES:	 msg = "(you are not permitted user)"; break;
		case EADDRNOTAVAIL:
				S_ADDRNOTAVAIL = 1;
				msg = "(not a local port)";
				break;
		default:	 msg = ""; break;
		}
		VSA_xtoap(sap,hp,sizeof(hp));
		svlog("bind_inet(%d,%s) failed: ERRNO=%d %s\n",sock,hp,errno,msg);
		return -1;
	}
	if( nlisten < 0 ) /* UDP bind */
		return rcode;

	if( nlisten == 0 ) /* don't start listen here */
		return 0;

	return set_listenX(sock,nlisten);
}

static bind_inets(sock,sap,nlisten,lport)
	VSAddr *sap;
{	int p1,p2,inc,try;
	int rcode = -1;

	if( lport == 0xFFFF0000 ){
		p1 = p2 = 0;
	}else
	if( lport & 0xFFFF0000 ){
		p1 = (lport >> 16) & 0xFFFF;
		p2 = lport & 0xFFFF;
	}else{
		p1 = p2 = lport;
	}
	inc = p1 < p2 ? 1 : -1;

	for( try = 0; try < 128; try++ ){
		VSA_setport(sap,p1);
		if( (rcode = bind_inet(sock,sap,nlisten)) == 0 )
			return 0;
		if( p1 == p2 )
			break;
		p1 += inc;
	}
	return rcode;
}

set_listenX(sock,nlisten)
{	int rcode;

	if( nlisten <= 0 )
		return -1;

	rcode = listen(sock,nlisten);

	if( rcode == 0 )
		Verbose("listen(%d,%d) OK.\n",sock,nlisten);
	else	svlog("listen(%d,%d) failed: ERRNO=%d\n",sock,nlisten,errno);
	return rcode;
}

bind_insock(sock,host,port)
	char *host;
{	VSAddr sab;
	int rcode;
	char *aaddr;
	int salen;

	if( host != NULL && host[0] != 0 )
		aaddr = gethostaddr(host);
	else	aaddr = NULL;
	if( aaddr == NULL )
		aaddr = "0.0.0.0";

	VSA_atosa(&sab,port,aaddr);
	salen = VSA_size(&sab);
	errno = 0;
	rcode = bind(sock,(SAP)&sab,salen);
	sv1log("bind_insock(%d,%s,%d) = %d, errno=%d\n",sock,host?host:"",port,
		rcode,errno);
	return rcode;
}

connectTimeout(sock,host,port,timeout)
	char *host;
{	struct hostent *hp;
	VSAddr sab;
	int salen;
	int rcode;

	VSA_atosa(&sab,0,"255.255.255.255");
	if( VSA_strisaddr(host) ){
		VSA_atosa(&sab,port,host);
	}else{
		if( hp = gethostbyNameAddr(0,host) )
			VSA_htosa(&sab,port,hp,0);
		else	sv1log("ERROR: connectTimeout(%s) unknown host\n",host);
	}
	if( VSA_isaddr(&sab)  ){
		salen = VSA_size(&sab);
		rcode = connectTO(sock,(SAP)&sab,salen,timeout);
		return rcode;
	}
	close(sock);
	return -1;
}

server_open(portname,hostname,portnum,nlisten)
	char *hostname,*portname;
{	int (*logf)(),sv1log(),sv1vlog();
	int rcode;
	int sock;
	struct hostent *hp;
	VSAddr sab;
	int salen;
	char path[1024];

	if( hostlocal2path(hostname,path,sizeof(path)) ){
		sv1log("## bind %s ...\n",path);
		hostname = path;
	}

	if( hostname != NULL && hostname[0] == '/' )
	{
		if( REUSE )
			unlink(path);
		return server_open_un(portname,hostname,nlisten);
	}

	/* dolog = streq(portname,"RESPDIST"); */
	if( hostname && strcmp(hostname,"localhost") == 0 && portnum == 0 )
		logf = sv1vlog;
	else	logf = sv1log;

	(*logf)("server_open(%s,%s:%d,listen=%d)\n",
		portname,hostname?hostname:"*",portnum,nlisten);

	switch( nlisten ){
		case -1: sock = newsocket(portname,AF_INET,SOCK_DGRAM,0); break;
		default: sock = newsocket(portname,AF_INET,SOCK_STREAM,0);
	}
	if( sock < 0 )
		return -1;

	VSA_atosa(&sab,0,"0.0.0.0");
	if( hostname != NULL && hostname[0] != 0 ){
		if( VSA_strisaddr(hostname) ){
			VSA_atosa(&sab,0,hostname);
			(*logf)("server_open: %s:%d\n",hostname,portnum);
		}else
		if( hp = gethostbyNameAddr(0,hostname) ){
			VSA_htosa(&sab,0,hp,0);
			(*logf)("server_open: %s:%d\n",hostname,portnum);
		}
		else{
			if( !VSA_strisaddr(hostname) ){
				sv1log("ERROR: hostname unknown: %s\n",hostname);
				close(sock);
				return -1;
			}
			VSA_atosa(&sab,0,hostname);
		}
	}
	VSA_setport(&sab,portnum);
	if( bind_inets(sock,&sab,nlisten,portnum) != 0 ){
		close(sock);
		sv1log("server_open() failed\n");
		return -1;
	}
	(*logf)("server_open(%s,%s:%d) BOUND\n",portname,hostname?hostname:"*",portnum);
	return sock;
}

find_openport(what,host,port,nlisten)
	char *what,*host;
{	int fd,portx;
	char hostx[256];
	char *addr,hostb[64];

	if( *host == 0 )
		host = "0.0.0.0";
	else{
		if( addr = gethostaddr(host) ){
			strcpy(hostb,addr);
			host = addr;
		}else	host = "0.0.0.0";
	}
	for( fd = 0; fd < FD_SETSIZE; fd++ ){
		if( (portx = gethostAddr(fd,hostx)) <= 0 )
			continue;

		if( portx == port && hostcmp(host,hostx) == 0 ){
			sv1log("FOUND: %s [%d] %s:%d\n",what,fd,hostx,port);
			return fd;
		}
	}
	return -1;
}
findopen_port(what,host,port,nlisten)
	char *what,*host;
{	int sock;

	sock = find_openport(what,host,port,nlisten);
	if( sock < 0 )
		sock = server_open(what,host,port,nlisten);
	return sock;
}

adduniqlist(names,name1)
	char *names[],*name1;
{	int nx;
	char *cname;

	for( nx = 0; cname = names[nx] ; nx++ )
		if( strcasecmp(cname,name1) == 0 )
			return;

	names[nx++] = stralloc(name1);
	names[nx] = NULL;
}
static adduniqlist_host(names,hp)
	char *names[];
	struct hostent *hp;
{	int nx;

	if( hp->h_name )
		adduniqlist(names,hp->h_name);

	if( hp->h_aliases )
	for( nx = 0; hp->h_aliases[nx]; nx++ )
		adduniqlist(names,hp->h_aliases[nx]);
}

sethostcache(host,mark_predef)
	char *host;
{	VSAddr sab;
	char *aaddr,*baddr;
	int blen,btype;
	struct hostent *chp,*hp;
	char sorder[RESOLVERS_SIZ],porder[RESOLVERS_SIZ];
	char order1[RESOLVERS_SIZ];
	int ox;
	char *aliases[128];
	int found,nx;
	int predef_sav;

	found = -1;
	predef_sav = HOSTS_PREDEF;
	HOSTS_PREDEF = mark_predef;

	aaddr = gethostaddr(host);
	if( aaddr == NULL )
		goto EXIT;
	VSA_atosa(&sab,0,aaddr);
	blen = VSA_decomp(&sab,&baddr,&btype,NULL);

	chp = gethostbyNameAddr(1,NULL,baddr,blen,btype);
	if( chp == NULL )
		goto EXIT;

	aliases[0] = aliases[1] = 0;
	adduniqlist_host(aliases,chp);

	found = 0;
	RES_order("",sorder);

	/*
	 * Try gather host name aliases in all of available resolvers.
	 * Maybe this is necessary to make revese-MOUNT work well...
	 */
	for( ox = 0; ox = RES_next_res(sorder,ox,order1,NULL); ){
		if( order1[0] == 'C' /* cache */ ){
			/* Maybe cache is the first alternative in resolvers
			 * so the result found above is that of the cache ...
			 */
			continue;
		}
		if( order1[0] == 'S' /* sys */ ){
			/* Some system (Windows, Solaris, ...) would block
			 * long time in system's standard gethostbyXXXX() ...
			 */
			continue;
		}

		RES_order(order1,porder);

		hp = gethostbyNameAddrNocache(NULL,baddr,blen,btype);

		if( hp != NULL ){
			adduniqlist_host(aliases,hp);
			found++;
		}
	}

	chp->h_aliases = dupv(&aliases[1],0);

	for( nx = 0; aliases[nx]; nx++ )
		free(aliases[nx]);

	RES_order(sorder,porder);

/*{ char hosts[4096]; dump_HOSTS(hosts); fprintf(stderr,"%s\n",hosts); }*/

EXIT:
	HOSTS_PREDEF = predef_sav;
	return found;
}
sethostcache_predef(name,addr,len,type)
	char *name,*addr;
{	Hostent *Hp;
	char hosts[2048];

	if( Hp = findHostCache(name,addr,len,type) )
	if( !Hp->hc_predef ){
		dump_HOST1(hosts,&Hp->hc_hostent);
		Verbose("HOSTS[%d]=%s marked PREDEF\n",Hp->hc_index,hosts);
		Hp->hc_predef = 1;
	}
}

sockHostport(sock,portp)
	int *portp;
{	int addrlen,addr;
	VSAddr sab;

	addrlen = sizeof(VSAddr);
	bzero(&sab,sizeof(VSAddr));
	if( getsockname(sock,(SAP)&sab,&addrlen) == 0 ){
		if( addrlen == 0 && file_isfifo(sock) )
			setFIFOaddr(&sab);
		if( portp != 0 )
			*portp = VSA_port(&sab);
		addr = VSA_addr(&sab);
		return addr;
	}
	if( portp != 0 )
		*portp = 0;
	return -1;
}
sockPort(sock)
{	int port;

	if( sockHostport(sock,&port) != -1 )
		return port;
	else	return 0;
}
peerHostport(sock,portp)
	int *portp;
{	int addrlen,addr;
	VSAddr sab;

	addrlen = sizeof(VSAddr);
	if( getpeername(sock,(SAP)&sab,&addrlen) == 0 ){
		if( addrlen == 0 && file_isfifo(sock) )
			setFIFOaddr(&sab);
		if( portp != 0 )
			*portp = VSA_port(&sab);
		addr = VSA_addr(&sab);
		return addr;
	}
	return -1;
}
peerPort(sock)
{	int port;

	if( peerHostport(sock,&port) != -1 )
		return port;
	else	return 0;
}
peerHostaddrV4(sock,rhost)
	unsigned char *rhost;
{	int ai;
	int iaddr;

	iaddr = peerHostport(sock,NULL);
	for( ai = 0; ai < 4; ai++ )
		rhost[ai] = (iaddr >> (3-ai)*8) & 0xFF;
}
sockFromMyself(sock)
{
	return sockHostport(sock,NULL) == peerHostport(sock,NULL);
}
flush_socket(fd)
{
	send(fd,"",0,MSG_OOB);  /* push packets before the timeout */
}

/*
 * Data connection should be via Socks if the control connection is via Socks.
 * Source IP address of data connection should be same with that of control
 * connection, and source port number should be be L-1 where the port number
 * of control connection is L.
 */
connect_ftp_data(Conn,port,cntrlsock,lhost,lport)
	void *Conn;
	char *port;
	char *lhost;
{	VSAddr ldata_addr;
	int lsock;
	char hostnam[128];
	int portnum;
	int r_ina,c_ina,trydirect;
	int addrlen;
	VSAddr srcport_buff,*srcport;
	VSAddr laddrb,*laddr;

	VSA_ftptosa(&ldata_addr,port);
	strcpy(hostnam,VSA_ntoa(&ldata_addr));
	portnum = VSA_port(&ldata_addr);

	if( toTunnel(Conn) ){
		lsock = connectViaTunnel(Conn,"ftp-data",hostnam,portnum);
		if( 0 <= lsock ){
			return lsock;
		}
	}

	srcport = NULL;
	if( cntrlsock < 0 ){
		trydirect = 1;
	}else{
		r_ina = inet_addrV4(hostnam);
		c_ina = peerHostport(cntrlsock,NULL);
		if( r_ina == c_ina )
			trydirect = 1;
		else	trydirect = 0; /* maybe via Socks */
/* the control connection can be connected via a proxy other than Socks,
 * for example, via CONNECT/HTTP, thus the data connections should be
 * routed following CONNECT parameter like the routing of control
 * connections. 
 */

		addrlen = sizeof(VSAddr);
		if( getsockname(cntrlsock,(SAP)&srcport_buff,&addrlen) == 0 )
		if( addrlen != 0 ){
			srcport = &srcport_buff;
			VSA_setport(srcport,VSA_port(srcport)-1);
		}
	}

	laddr = NULL;
	if( *lhost != 0 || lport != 0 ){
		laddr = &laddrb;
		if( *lhost ){
			VSA_atosa(laddr,0,gethostaddr(lhost));
		}else
		if( srcport )
			*laddr = *srcport;
		else	VSA_atosa(laddr,0,"0.0.0.0");

		if( lport == 0 && srcport )
			lport = VSA_port(srcport);
	}

	lsock = -1;
	if( lsock == -1 && ViaVSAPassociator(cntrlsock) ){
		char sockname[256],peername[256];
		sockname[0] = 0;

		if( VSAPgetsockname(cntrlsock,sockname) == 0 ){
			char *dp;
			int port;
			if( dp = strchr(sockname,':') ){
				dp++;
				/*if( port = atoi(dp) )
					sprintf(dp,"%d",port-1);
				else*/	sprintf(dp,"0");
			}
			sv1log("## FTP/VSAP CONNECT SOCK=%s\n",sockname);
		}

		sprintf(peername,"%s:%d",hostnam,portnum);
		lsock = CTX_VSAPconnect(Conn,sockname,peername);
	}

	if( lsock == -1 && trydirect )
		lsock = ftp_conndata(srcport,&ldata_addr,laddr,lport);

	if( lsock == -1 && GetViaSocks(Conn,hostnam,portnum) )
		lsock = connectViaSocks(Conn,hostnam,portnum,NULL,NULL);

	if( lsock == -1 && !trydirect )
		lsock = ftp_conndata(srcport,&ldata_addr,laddr,lport);

	return lsock;
}

bind_ftp_data(Conn,mport,server,iport,cntrlsock,PASV,lhost,lport)
	void *Conn;
	char *mport;
	char *server;
	char *lhost;
{	int sock,sREUSE,sREUSEPORT;

	sREUSE = REUSE; REUSE = 0;
	sREUSEPORT = REUSEPORT; REUSEPORT = 0;
	sock = bind_ftp_dataX(Conn,mport,server,iport,cntrlsock,PASV,lhost,lport);
	REUSE = sREUSE;
	REUSEPORT = sREUSEPORT;
	return sock;
}
bind_ftp_dataX(Conn,mport,server,iport,cntrlsock,PASV,lhost,lport)
	void *Conn;
	char *mport;
	char *server;
	char *lhost;
{	int dsock;
	char *aaddr;
	VSAddr svhost,svsock,svpeer,svdata;
	int addrlen;
	char remote[256],local[256];

	if( fromTunnel(Conn,cntrlsock) ){
		VSA_atosa(&svsock,0,"127.0.0.1");
		goto BIND;
	}

	if( ViaVSAPassociator(cntrlsock) ){
		char sockname[256];
		int ax[4],bport;

		sockname[0] = 0;
		if( VSAPgetsockname(cntrlsock,sockname) == 0 ){
			char *dp;
			if( dp = strchr(sockname,':') )
				strcpy(dp+1,"0");
		}
		sv1log("## FTP/VSAP BIND SOCK=%s\n",sockname);
		dsock = CTX_VSAPbind(Conn,sockname,1);
		if( 0 <= dsock ){
			sscanf(sockname,"%d.%d.%d.%d:%d",
				&ax[0],&ax[1],&ax[2],&ax[3],&bport);
			sprintf(mport,"%d,%d,%d,%d,%d,%d",
				ax[0],ax[1],ax[2],ax[3],
				(bport>>8)&0xFF,bport&0xFF);
			return dsock;
		}
	}

	if( aaddr = gethostaddr(server) ){
		VSA_atosa(&svhost,iport,aaddr);
		VSA_xtoap(&svhost,remote,sizeof(remote));
		sv1log("FTP-control-remote: %s\n",remote);
	}

	addrlen = sizeof(VSAddr);
	if( getsockname(cntrlsock,(SAP)&svsock,&addrlen) != 0 || addrlen == 0 ){
		sv1log("cannot make FTP data port: no control conn-1.\n");
		return -1;
	}
	addrlen = sizeof(VSAddr);
	if( getpeername(cntrlsock,(SAP)&svpeer,&addrlen) != 0 || addrlen == 0 ){
		sv1log("cannot make FTP data port: no control conn-2.\n");
		return -1;
	}

	if( VSA_comp(&svhost,&svpeer) != 0 ){
		/* not connected directly */
		VSAddr vlocal;
		if( VSA_getViaSocks(Conn,server,0,&vlocal) )
		{	char bhost[32];
			int bport;
			VSAddr ba;

			dsock = bindViaSocks(Conn,server,iport,bhost,&bport);
			if( 0 <= dsock ){
				if( streq(bhost,"0.0.0.0") ){ /* wild card */
					strcpy(bhost,VSA_ntoa(&vlocal));
					sv1log("BIND 0.0.0.0 -> %s\n",bhost);
				}
				VSA_atosa(&ba,bport,bhost);
				VSA_prftp(&ba,mport);
				return dsock;
			}
		}
	}


BIND:
	dsock = newsocket("ftp-data-acc",AF_INET,SOCK_STREAM,0);
	if( dsock < 0 )
		return -1;
	if( *lhost != 0 || lport != 0 ){
		if( *lhost )
			VSA_atosa(&svdata,0,gethostaddr(lhost));
		else{
			svdata = svsock;
			VSA_setport(&svdata,0);
		}
		if( bind_inets(dsock,&svdata,1,lport) == 0 )
			goto BOUND;
	}
	svdata = svsock;

/*
## BUG ? ###################################
this seems the missunderstanding of specification?
this is capable on FreeBSD,
but repetitive lport usage makes remote server wait timeout...
*/
/* V8.0.0 don't use L-1 for PASV
if( VSA_port(&svdata) != 0 )
if( PASV ){
VSA_setport(&svdata,VSA_port(&svdata)-1);
if( bind_inet(dsock,&svdata,1) == 0 ) goto BOUND;
}
*/
	VSA_setport(&svdata,0);
	if( bind_inet(dsock,&svdata,1) == 0 )
		goto BOUND;

	VSA_atosa(&svdata,0,"0.0.0.0");
	/*
	if( bind_inet(dsock,NULL,1) != 0 ){
	*/
	if( bind_inet(dsock,&svdata,1) != 0 ){
		sv1log("ERROR: Cannot bind.\n");
		close(dsock);
		return -1;
	}
BOUND:
	addrlen = sizeof(VSAddr);
	getsockname(dsock,(SAP)&svdata,&addrlen);
	VSA_setport(&svsock,VSA_port(&svdata));
	VSA_prftp(&svsock,mport);
	VSA_xtoap(&svsock,local,sizeof(local));
	sv1log("FTP-data-local[%d]: %s\n",dsock,local);
	return dsock;
}

UDPaccept(svsock,lockfd,timeout)
{	VSAddr from,svme,xme,peer;
	int salen;
	int clsock;
	int xsock;
	int addrlen,rcc,wcc;
	char buf[0x8000];
	char sfrom[128],speer[128],sme[128];
	int rcode,try,rbind,nsvsock;

	if( 0 <= lockfd && lock_exclusiveTO(lockfd,timeout*1000,NULL) != 0 ){
		sv1log("## UDP accept failed locking [%d]\n",errno);
		return -1;
	}
	if( PollIn(svsock,1) <= 0 ){
		sv1log("## UDP accept failed polling [%d]\n",errno);
		clsock = -1;
		goto EXIT;
	}

	addrlen = sizeof(VSAddr);
	rcc = recvfrom(svsock,buf,sizeof(buf),0,(SAP)&from,&addrlen);
	if( rcc <= 0 ){
		sv1log("## UDP accept failed receiving [%d]\n",errno);
		clsock = -1;
		goto EXIT;
	}

	printSock(&from,sfrom,"%A:%P");
	sv1log("UDP-SV[%d] ready=%d from=%s\n",svsock,rcc,sfrom);

	addrlen = sizeof(VSAddr);
	rcode = getsockname(svsock,(SAP)&svme,&addrlen);
	setsockREUSE(svsock,1);
	close(svsock);

	clsock = socket(AF_INET,SOCK_DGRAM,0);
	if( clsock == svsock ){
		clsock = dup(clsock);
		close(svsock);
	}
	setsockREUSE(clsock,1);

	xme = svme;

	for( try = 0; try < 10; try++ ){
		salen = VSA_size(&xme);
		rcode = bind(clsock,(SAP)&xme,salen);
		if( rcode == 0 )
			break;
		sleep(1);
	}
	if( rcode != 0 ){
		sv1log("UDP accept failed in bind %d\n",errno);
		close(clsock);
		clsock = -1;
		goto EXIT;
	}

	addrlen = sizeof(VSAddr);
	rcode = getsockname(clsock,(SAP)&xme,&addrlen);

	xsock = socket(AF_INET,SOCK_DGRAM,0);
	salen = VSA_size(&xme);
	wcc = sendto(xsock,buf,rcc,0,(SAP)&xme,salen);
	close(xsock);

	salen = VSA_size(&from);
	rcode = connect(clsock,(SAP)&from,salen);
	addrlen = sizeof(VSAddr);
	rcode = getpeername(clsock,(SAP)&peer,&addrlen);
	printSock(&peer,speer,"%A:%P");

	addrlen = sizeof(VSAddr);
	rcc = recvfrom(clsock,buf,sizeof(buf),MSG_PEEK,(SAP)&from,&addrlen);
	sv1log("UDP-CL[%d] ready=%d peer=%s\n",clsock,rcc,speer);

	nsvsock = socket(AF_INET,SOCK_DGRAM,0);
	setsockREUSE(nsvsock,1);
	for( try = 0; try < 10; try++ ){
		errno = 0;
		salen = VSA_size(&svme);
		rbind = bind(nsvsock,(SAP)&svme,salen);
		if( rbind == 0 )
			break;
		sleep(1);
	}
	if( nsvsock != svsock ){
		dup2(nsvsock,svsock);
		close(nsvsock);
	}

	addrlen = sizeof(VSAddr);
	getsockname(svsock,(SAP)&svme,&addrlen);
	printSock(&svme,sme,"%A:%P");
	setsockREUSE(svsock,1);
	sv1log("UDP-SV[%d]: NEW bind=%d %s\n",svsock,rbind,sme);

EXIT:
	if( 0 < lockfd )
		lock_unlock(lockfd);
	return clsock;
}

SOCKS_udpassocsock(sock,lhost,lport,rhost,rport)
	char *rhost;
	int *rport;
{	VSAddr me,rme;
	int melen;
	char *aaddr;

	aaddr = gethostaddr(lhost);
	if( aaddr == NULL )
		return -1;
	VSA_atosa(&me,lport,aaddr);
	if( SOCKS_udpassoc(sock,&me,&rme) != 0 )
		return -1;
	
	strcpy(rhost,VSA_ntoa(&rme));
	*rport = VSA_port(&rme);
	return 0;
}
sendTo(sock,sto,msg,len)
	char *sto,*msg;
{	VSAddr sab;
	int salen;
	char aaddr[64];
	int port;
	int wcc;

	port = 0;
	sscanf(sto,"%[^:]:%d",aaddr,&port);
	if( port == 0 ){
		sv1log("sendTo(%s:%d) ? \n",aaddr,port);
		return -1;
	}

	salen = VSA_atosa(&sab,port,aaddr);
	wcc = sendto(sock,msg,len,0,(SAP)&sab,salen);
	return wcc;
}
peekfrom(sock,sfrom)
	char *sfrom;
{	char buf[2048];
	VSAddr sab;
	int fromlen;
	int rcc;

	strcpy(sfrom,"0.0.0.0:0");
	fromlen = sizeof(VSAddr);
	rcc = recvfrom(sock,buf,sizeof(buf),MSG_PEEK,(SAP)&sab,&fromlen);
	if( rcc <= 0 )
		return rcc;

	printSock(&sab,sfrom,"%A:%P");
	return rcc;
}
readfrom(sock,buff,size,sfrom)
	char *buff,*sfrom;
{	VSAddr sab;
	int fromlen;
	int rcc;

	strcpy(sfrom,"0.0.0.0:0");
	fromlen = sizeof(VSAddr);
	rcc = recvfrom(sock,buff,size,0,(SAP)&sab,&fromlen);
	if( rcc <= 0 )
		return rcc;

	printSock(&sab,sfrom,"%A:%P");
	return rcc;
}

GetHostname(name,size)
	char *name;
{	struct hostent *hp;
	char host[256];

	if( myFQDN == NULL ){
		gethostname(host,sizeof(host));
		if( hp = gethostbyNameAddr(0,host) )
			myFQDN = stralloc(hp->h_name);
		else{
			strcpy(myFQDN_unknown,host);
			myFQDN = myFQDN_unknown;
		}
	}
	strncpy(name,myFQDN,size);
}
IsMyself(host)
	char *host;
{	char myhost[256];
	int hosti;

	hosti = gethostintMin(host);
	if( hosti == -1 )
		return 0;

	if( hosti == gethostintMin("localhost") )
		return 1;

	gethostname(myhost,sizeof(myhost));
	if( hosti == gethostintMin(myhost) )
		return 1;

	return 0;
}

localsocket(sock)
{	int phosti,pporti;
	int mhosti,mporti;

	phosti = peerHostport(sock,&pporti);
	if( phosti == -1 )
		return 1;

	mhosti = sockHostport(sock,&mporti);
	if( mhosti == -1 )
		return 1;

	if( phosti == mhosti )
		return 1;

	return 0;
}

hostismyself(host,sockfp)
	char *host;
	FILE *sockfp;
{	VSAddr sab;
	int salen;
	char *aaddr;
	int sock,rcode;

	if( __gethostint_nbo(0,"localhost",NULL) == __gethostint_nbo(0,host,NULL) )
		return 1;

	if( sockfp != NULL )
		if( localsocket(fileno(sockfp)) )
			return 1;

	aaddr = gethostaddr(host);
	if( aaddr == NULL )
		return 0;

	sock = socket(AF_INET,SOCK_STREAM,0);
	salen = VSA_atosa(&sab,0,aaddr);
	rcode = bind(sock,(SAP)&sab,salen);
	close(sock);

	if( rcode == 0 )
		return 1;

	return 0;
}

hostcmp(host1,host2)
	char *host1,*host2;
{	int hi1,hi2;

	if( strcasecmp(host1,host2) == 0 )
		return 0;

	if( (hi1 = gethostintMin(host1)) != -1 )
	if( (hi2 = gethostintMin(host2)) != -1 )
		if( hi1 == hi2 )
			return 0;
	return 1;
}
hostcmp_incache(host1,host2)
	char *host1,*host2;
{	int co,rcode;

	co = RES_CACHEONLY(1);
	rcode = hostcmp(host1,host2);
	RES_CACHEONLY(co);
	return rcode;
}

char *VA_inAddr(Ia)
	VAddr *Ia;
{	int ia;

	ia = Ia->I3;
	inAddrx = (inAddrx+1) % 8;
	sprintf(inAddrs[inAddrx],"%d.%d.%d.%d",
		0xFF&(ia>>24),0xFF&(ia>>16),0xFF&(ia>>8),0xFF&ia);
	return inAddrs[inAddrx];
}

getpairName(clsock,sockname,peername)
	char *sockname,*peername;
{
	gethostName(clsock,sockname,"%A:%P");
	getpeerName(clsock,peername,"%A:%P");
}

Socket1(what, sock,domain,type,proto, lhost,lport, rhost,rport, nlisten,opts,NB)
	char *what,*domain,*type,*proto,*lhost,*rhost,*opts;
{	int Domain,Type,Proto;

	if( sock < 0 ){
		if( domain && strcasecmp(domain,"unix") == 0
		 || lhost != NULL && lhost[0] == '/'  )
			Domain = AF_UNIX;
		else	Domain = AF_INET;
		if( type && (strcaseeq(type,"udp")||strcaseeq(type,"dgram")||strcaseeq(proto,"udp")) )
			Type = SOCK_DGRAM;
		else	Type = SOCK_STREAM;
		Proto = 0;
		sock = newsocket(what,Domain,Type,Proto);
		if( sock < 0 )
			return -1;
	}
	if( lhost != NULL && lhost[0] == '/' ){
	}else
	if( lhost != NULL || 0 < lport ){
		if( strcmp(lhost,"*") == 0 )
			lhost[0] = 0;
		setsockREUSE(sock,1);
		setsockSHARE(sock,1);
		if( bind_insock(sock,lhost,lport) != 0 ){
			close(sock);
			return -1;
		}
	}
	if( 0 < nlisten ){
		if( listen(sock,nlisten) != 0 ){
			close(sock);
			return -1;
		}
	}
	if( rhost != NULL || 0 < rport
	 || rhost != NULL && rhost[0] == '/' ){
		if( NB ) setNonblockingIO(sock,1);
		if( __connectServer(sock,"Socket",what,rhost,rport) < 0 ){
			if( !NB ){
				close(sock);
				return -1;
			}
		}
	}
else{
/* for non-connect operation */
if( NB ) setNonblockingIO(sock,1);
}
	return sock;
}
Listen(sock,backlog)
{
	return listen(sock,backlog);
}

VA_hostIFto(destp,maskp,Vaddr)
	VAddr *destp,*maskp,*Vaddr;
{	char desthost[128],hostif[128];
	VAddr dest0,dest1,hostaddr;
	VAddr host;
	int ii;

	if( iftoV == NULL ){
		iftoV = (IfTo**)StructAlloc(NIFTO*sizeof(IfTo*));
	}
	AddrAND(dest0,(*destp),(*maskp));
	for( ii = 0; ii < iftoN; ii++ ){
		dest1 = iftoV[ii]->if_dest;
		if( AddrEQ(dest1,dest0) ){
			*Vaddr = iftoV[ii]->if_ifto;
			return 1;
		}
	}
	inet_itoaV4(destp->I3,desthost);

	if( hostIFfor0(hostif,1,"time",desthost,37,0) == 0 ){
		strcpy(hostif,"?");
		host = AddrNull;
	}else{
		host = AddrZero;
		host.I3 = ntohl(inet_addrV4(hostif));
	}

	if( ii < NIFTO ){
		iftoV[ii] = NewStruct(IfTo);
		iftoV[ii]->if_dest = dest0;
		iftoV[ii]->if_ifto = host;
		iftoN = ii+1;
	}
	sv1log("## hostIFto %s < %s (%x)\n",desthost,hostif,maskp->I3);
	*Vaddr = host;
	return 0;
}

make_HOSTS(hosts,hostname,cacheonly)
	char *hosts,*hostname;
{	struct hostent *hp;

	if( hp = gethostbyNameAddr(cacheonly,hostname) ){
		dump_HOST1(hosts,hp);
		return 1;
	}
	return 0;
}

init_myname(RESOLV)
	char *RESOLV;
{	char order[RESOLVERS_SIZ],porder[RESOLVERS_SIZ];
	char dresolv[RESOLVERS_SIZ],env[RESOLVERS_SIZ];
	char myname[256];
	Hostent *Me;
	struct hostent *me;

	scan_HOSTS((void*)0,"localhost/127.0.0.1");

	/* put myname by SYS into HOSTS cache */
	gethostname(myname,sizeof(myname));
	if( Me = findHostCache(myname) )
		me = &Me->hc_hostent;
	else	me = NULL;
	if( me == NULL ){
		me = EX_GETHOSTBYNAME(myname);
		if( me != NULL ){
			me = addHostCacheOk(me,myname,"GETHOSTBYNAME",Time());
		}
	}

	/* V8.0.0 setup default RESOLV */
	if( RESOLV == NULL ){
		RES_order_default(order,myname,me);
		RES_prorder(order,dresolv);
		sprintf(env,"RESOLV=%s",dresolv);
		sv1log("export %s (set by default)\n",env);
		putenv(stralloc(env));
	}
}

extern char *getenv();
RES_order_default(dorder,myname,me)
	char *dorder;
	char *myname;
	struct hostent *me;
{	char order[RESOLVERS_SIZ],porder[RESOLVERS_SIZ],*rp;
	char resolv[RESOLVERS_SIZ],env[RESOLVERS_SIZ],*op;
	char myaddr[64];
	unsigned char *dp;
	struct hostent *me_dns;
	char *name,**ypdomain,*addr;
	int hi,ai;

	strcpy(porder,"");
	op = getenv("RES_ORDER");
	if( op ){
		RES_order(op,porder);
		strcpy(dorder,op);
		return 0;
	}
	sv1log("configuring default RESOLV ...\n");
	me_dns = 0;
	if( me ){
		dumpAddr(myaddr,me->h_addr_list[0]);
		sv1log("... SYS: %s -> %s\n",myname,myaddr);
		RES_order("D",porder);
		for( ai = 0; addr = me->h_addr_list[ai]; ai++ ){
			me_dns = gethostbyaddr(addr,
				me->h_length,me->h_addrtype);
			if( me_dns ){
				dumpAddr(myaddr,addr);
				break;
			}
		}
		RES_order(porder,order);
	}else{
		RES_order(porder,NULL);
	}
	if( me_dns ){
		if( rp = strchr(porder,'S') )
			ovstrcpy(rp,rp+1);
		RES_order(porder,order);
		sv1log("... DNS: %s -> %s\n",myaddr,me_dns->h_name);
		sv1log("... DNS available\n");
	}
	if( yp_get_default_domain(&ypdomain) == 0 && *ypdomain != 0 ){
		sv1log("... NIS domain: %s\n",ypdomain);
	}else{
		if( rp = strchr(porder,'N') )
			ovstrcpy(rp,rp+1);
		RES_order(porder,order);
		sv1log("... NIS not available (no default domain)\n");
	}
	strcpy(dorder,porder);
	sprintf(env,"RES_ORDER=%s",dorder);
	putenv(stralloc(env));
	sv1log("... export %s\n",env);
	return 1;
}
#endif /* !LIBRARY */
