/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1998 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	inetd.c (inetd like server)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
    inetd.conf:
	service-name	"-" or <119> or <host:119>
	socket-type	"-" or "stream" or "dgram"
	protocol	"-" or "tcp" or "udp"
	wait-status	"-" or "wait" or "nowait" (wait is not supported yet)
	uid		"-" or <username> or <8715>
	server-program	"-" or </path/of/the/program>
	server-arguments

EXTENSION:
	service-name	proto://host:port ????
	uid		user/group
	server-program	quotation by <"> like "/Program Files/xxx/yyy.exe"

History:
	980525	created
//////////////////////////////////////////////////////////////////////#*/

#include <stdio.h>
#include "ystring.h"
extern char **dupv();
extern int rescanGlobal;

static char *usage[] = {
"Usage: INETD=\"port stream tcp nowait user path args\"   -- external command",
"       INETD=\"port - - - - - parameters\"  -- exec DeleGate with parameters",
"       INETD=+=/path/of/inetd.conf             -- read config. from a file",
0};

typedef struct {
	char	*i_conf;
	char	*i_host;
	int	 i_port;
	int	 i_udp;
	char	*i_user;
	char	*i_path;
	char	*i_args;
	char   **i_argv;
} InetdConf;

typedef struct {
	InetdConf *ie_inetdtab[32];
	int	ie_inetdN;
} InetdEnv;
static InetdEnv *inetdEnv;
#define inetdtab	inetdEnv->ie_inetdtab
#define inetdN		inetdEnv->ie_inetdN
minit_inetd()
{
	if( inetdEnv == 0 )
		inetdEnv = NewStruct(InetdEnv);
}

func_inetd(Conn,clsock)
	void *Conn;
{	int ix;
	char hostport[256],host[256];
	int port;
	char clhost[256];
	int clport;
	int ai,found;
	InetdConf *ic;
	char *arg;
	char command[1024],argbuf[1024];
	int params;
	int isudp;

	minit_inetd();

	if( inetdN == 0 )
		return 0;

	gethostName(clsock,hostport,"%A:%P");
	isudp = isUDPsock(clsock);
	sscanf(hostport,"%[^:]:%d",host,&port);

	found = 0;
	for( ix = 0; ix < inetdN; ix++ ){
		ic = inetdtab[ix];
		if( ic->i_host[0] == 0 || hostcmp(ic->i_host,host) == 0 )
		if( ic->i_port == port )
		if( ic->i_udp == isudp ){
			found = 1;
			break;
		}
	}

	if( !found ){
		sv1log("### ACCEPT PORT=%s:%d ? NO INETD CONF\n",host,port);
		return 0;
	}

	params = 0;
	for( ai = 0; arg = ic->i_argv[ai]; ai++ ){
		sv1log("INETD PARAM[%d] %s\n",ai,arg);
		DELEGATE_addEnvExt(arg);
		params++;
	}

	if( !streq(ic->i_user,"-") ){
		sprintf(argbuf,"OWNER=%s",ic->i_user);
		DELEGATE_addEnvExt(argbuf);
		params++;
	}

	if( ic->i_path[0] != '-' ){
		DELEGATE_addEnvExt("SERVER=exec");
		packComArg(command,ic->i_path,ic->i_args);
		sprintf(argbuf,"XCOM=%s",command);
		DELEGATE_addEnvExt(argbuf);
		sv1log("SERVER=exec \"%s\"\n",argbuf);
		params++;
	}

	return params;
}

scan_INETD(Conn,confarg)
	void *Conn;
	char *confarg;
{	char servname[128],socktype[128],protocol[128],waitstat[128],uid[128];
	char program[1024],path[1024],args[1024],argb[1024],*av[128];
	char host[256];
	int port;
	char conf[1024],*dp;
	InetdConf *ic;
	int ac,ai;
	int ci;

	minit_inetd();

	if( strncmp(confarg,"+=",2) == 0 )
		return;

	strcpy(conf,confarg);
	if( dp = strchr(conf,'#') )
		*dp = 0;
	for( dp = conf; *dp; dp++ )
		if( *dp != ' ' && *dp != '\t' )
			break;
	if( dp != conf )
		strcpy(conf,dp);
	if( *conf == 0 )
		return;

	/* fprintf(stderr,"INETD=\"%s\"\n",confarg); */

	for( ci = 0; ci < inetdN; ci++ )
		if( streq(inetdtab[ci]->i_conf,conf) )
			return;

	if( sscanf(conf,"%s %s %s %s %s %[^\r\n]",
		servname,socktype,protocol,waitstat,uid,program) < 6 ){
		fprintf(stderr,"WRONG inetd.conf format: INETD=%s\r\n",conf);
		fprintf(stderr,"%s\r\n",usage[0]);
		fprintf(stderr,"%s\r\n",usage[1]);
		fprintf(stderr,"%s\r\n",usage[2]);
		exit(-1);
	}
	if( streq(servname,"-") ) printPrimaryPort(servname);
	if( streq(socktype,"-") ) strcpy(socktype,"stream");
	if( streq(protocol,"-") ) strcpy(protocol,"tcp");
	if( streq(waitstat,"-") ) strcpy(waitstat,"nowait");

	if( streq(protocol,"udp") )
		strcat(servname,"/udp");
	scanServPort1(servname);

	ic = (InetdConf*)calloc(1,sizeof(InetdConf));
	inetdtab[inetdN++] = ic;

	ic->i_conf = stralloc(conf);

	if( strchr(servname,':') ){
		port = 0;
		sscanf(servname,"%[^:]:%d",host,&port);
		ic->i_host = stralloc(host);
		ic->i_port = port;
	}else{
		ic->i_host = stralloc("");
		ic->i_port = atoi(servname);
	}
	ic->i_udp = streq(protocol,"udp");
	ic->i_user = stralloc(uid);

	av[0] = av[1] = "";
	decomp_args(av,2,program,argb);
	ic->i_path = stralloc(av[0]);
if( av[1] == 0 ) av[1] = "";
	ic->i_args = stralloc(av[1]);
	ac = decomp_args(av,128,ic->i_args,argb);
	ic->i_argv = dupv(av,0);
}

