/*////////////////////////////////////////////////////////////////////////
Copyright (c) 2000 Yutaka Sato
Copyright (c) 2000 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	imap.c (IMAP4 RFC2060)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	000616	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "param.h"
#include "delegate.h"
#include "filter.h"
#include "ystring.h"
#define LNSIZE 1024
extern char *fgetsTIMEOUT();
extern char *CTX_mount_url_to();

static imap_change_server(Conn,login)
	Connection *Conn;
	char *login;
{	char *dp,host[LNSIZE];
	char *opts,user[LNSIZE],tmp[LNSIZE];
	int port;

	if( *login == '"' )
		wordscanY(login+1,user,sizeof(user),"^\"");
	else	wordScan(login,user);
	if( dp = strrpbrk(user,"@%") ){
		*dp = 0;
		strcpy(tmp,user);
		wordScan(dp+1,host);
		sprintf(user,"//%s/%s",host,tmp);
	}
	opts = CTX_mount_url_to(Conn,NULL,"GET",user);
	if( strncasecmp(user,"imap://",7) == 0 )
		strcpy(user,user+5);
	if( strncasecmp(user,"imaps://",8) == 0 )
		strcpy(user,user+6);

	if( sscanf(user,"//%[^/]/%s",tmp,user) == 2 ){
		port = scan_hostportX("imap",tmp,host,sizeof(host));
		sprintf(login,"\"%s\"",user);
		goto SWSERV;
	}

	dp = strrpbrk(login,"@%");
	if( dp == 0 )
		return;

	port = scan_hostportX("imap",dp+1,host,sizeof(host));
	if( strtailchr(login) == '"' )
		*dp++ = '"';
	*dp = 0;

SWSERV:
	sv1log("IMAP LOGIN  %s @ %s:%d\n",login,host,port);
	set_realserver(Conn,"imap",host,port);
	connect_to_serv(Conn,FromC,ToC,0);
}

static imaplog(Conn,qcmd,qarg)
	Connection *Conn;
	char *qcmd,*qarg;
{	char clnt[LNSIZE],user[LNSIZE],serv[LNSIZE];

	strfConn(Conn,"%u@%h:%p",clnt);
	if( *qarg == '"' )
		wordscanY(qarg+1,user,sizeof(user),"^\"");
	else	wordScan(qarg,user);
	sprintf(serv,"%s@%s",user,DST_HOST);
	sv1log("%s IMAP-LOGIN FROM %s TO %s\n",
		0<=ToS?"OK":"NO",clnt,serv);
	fputLog(Conn,"Login","%s IMAP-LOGIN; from=%s; to=%s\n",
		0<=ToS?"OK":"NO",clnt,serv);
	LOG_flushall();
}

service_imap(Conn)
	Connection *Conn;
{	FILE *fc,*tc,*ts,*fs;
	FILE *fpv[2];
	int rds[2],idle;
	char *dp,*ap;
	char req[LNSIZE],qtag[LNSIZE],qcmd[LNSIZE],qarg[LNSIZE],qrem[LNSIZE];
	char resp[LNSIZE],rtag[LNSIZE],rstat[LNSIZE];
	char myhost[LNSIZE];

	fc = fdopen(FromC,"r");
	tc = fdopen(ToC,"w");

	if( 0 <= ToS ){
		ts = fdopen(ToS,"w");
		fs = fdopen(FromS,"r");
		if( fgetsTIMEOUT(resp,sizeof(resp),fs) == NULL )
			return;
		sv1log("S: %s",resp);
	}else{
		ts = NULL;
		fs = NULL;
		ClientIF_name(Conn,FromC,myhost);
		sprintf(resp,"* OK %s Proxy IMAP4 server DeleGate/%s\r\n",
			myhost,DELEGATE_ver());
		sv1log("D: %s",resp);
	}
	fputs(resp,tc);

	for(;;){
		fflush(tc);
		if( fgetsTIMEOUT(req,sizeof(req),fc) == NULL ){
			sv1log("C: EOF\n");
			break;
		}
		dp = wordScan(req,qtag);
		ap = wordScan(dp,qcmd);
		dp = wordScan(ap,qarg);
		lineScan(dp,qrem);
		if( strcaseeq(qcmd,"LOGIN") ){
			sv1log("C: %s %s %s ****\n",qtag,qcmd,qarg);
		}else	sv1log("C: %s",req);

		if( method_permitted(Conn,"imap",qcmd,1) == 0 ){
			fprintf(tc,"%s NO (forbidden) %s\r\n",qtag,qcmd);
			fflush(tc);
			continue;
		}

		if( ts == NULL ){
			if( strcaseeq(qcmd,"XECHO") ){
				while( *ap == ' ' || *ap == '\t' )
					ap++;
				fputs(ap,tc);
				continue;
			}
			if( strcaseeq(qcmd,"LOGOUT") ){
				sv1log("D: %s OK %s\r\n",qtag,qcmd);
				fprintf(tc,"%s OK %s\r\n",qtag,qcmd);
				fflush(tc);
				break;
			}
			if( strcaseeq(qcmd,"CAPABILITY") ){
				sv1log("D: %s OK %s\r\n",qtag,qcmd);
				fprintf(tc,"* CAPABILITY IMAP4 AUTH-LOGIN\r\n");
				fprintf(tc,"%s OK %s\r\n",qtag,qcmd);
				continue;
			}
			if( strcaseeq(qcmd,"LOGIN") )
				imap_change_server(Conn,qarg);

			if( ToS < 0 ){
				fprintf(tc,"%s BAD LOGIN user@host first.\r\n",
					qtag);
				sv1log("D: %s BAD LOGIN user@host first.\r\n",
					qtag);
				imaplog(Conn,qcmd,qarg);
				continue;
			}
			ts = fdopen(ToS,"w");
			fs = fdopen(FromS,"r");
			if( fgetsTIMEOUT(resp,sizeof(resp),fs) == NULL )
				return;
			sv1log(">>>> %s",resp);
			sprintf(req,"%s %s %s %s\r\n",qtag,qcmd,qarg,qrem);
			sv1log(">>>> %s %s %s ****\n",qtag,qcmd,qarg);
		}
		fputs(req,ts);
		fflush(ts);

		rstat[0] = 0;
/*
		if( strcaseeq(qcmd,"IDLE") || strcaseeq(qcmd,"APPEND") ){
*/
		if( strcaseeq(qcmd,"IDLE")
		 || strcaseeq(qcmd,"APPEND")
		 || strcaseeq(qcmd,"AUTHENTICATE")
		){
			fpv[0] = fc;
			fpv[1] = fs;
			idle = 1;
		}else	idle = 0;
		for(;;){
			if( idle ){
				fflush(tc);
				if( fPollIns(0,2,fpv,rds) < 0 )
					break;
				if( 0 < rds[0] ){
					if( fgets(req,sizeof(req),fc) == NULL ){
						sv1log("C> EOF in IDLE\n");
						goto EXIT;
					}
					Verbose("C> %s",req);
					fputs(req,ts);
					fflush(ts);
				}
				if( rds[1] <= 0 )
					continue;
			}
			if( fgetsTIMEOUT(resp,sizeof(resp),fs) == NULL ){
				sv1log("S: EOF\n");
				break;
			}
			dp = wordScan(resp,rtag);
			dp = wordScan(dp,rstat);
			fputs(resp,tc);
			if( qtag[0] == 0 || strcmp(qtag,rtag) == 0 )
				break;
			Verbose("S> %s",resp);
		}
		sv1log("S: %s",resp);
		fflush(tc);
		if( strcaseeq(qcmd,"LOGOUT") && strcaseeq(rstat,"OK")
		 || feof(fs) )
			break;

		if( strcaseeq(qcmd,"LOGIN") )
		if( !strcaseeq(rstat,"OK") ){
			fprintf(ts,"X LOGOUT\r\n");
			fclose(ts);
			fclose(fs);
			ts = fs = NULL;
			ToS = FromS = -1;
			sv1log(">>>> IMAP connection to the server closed.\n");
			/* must clear FSV,FTOSV,FFROMSV if exists */
		}
		if( strcaseeq(qcmd,"LOGIN") )
			imaplog(Conn,qcmd,qarg);
	}
EXIT:
	return;
}
