/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-2000 Yutaka Sato and ETL,AIST,MITI
Copyright (c) 2001 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use, copy, and distribute (via publically accessible
on-line media) this material for any purpose and without fee is hereby
granted, provided that the above copyright notice and this permission
notice appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	http.c (HTTP/1.0 proxy)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940316	created
	99Aug	restructured
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "http.h"
extern FILE *TMPFILE();
extern char *Sprintf();
extern char *file_hostpath();
extern FILE *openFilter();

service_http(Conn)
	Connection *Conn;
{
	service_httpX(Conn);
}
service_https(Conn)
	Connection *Conn;
{
	if( 0 <= ToS )
		relay_svcl(Conn,FromC,ToC,FromS,ToS);
	else	service_http(Conn);
}

static sendHttpResponse(Conn,in,out,req)
	Connection *Conn;
	FILE *in,*out;
	char *req;
{	char myhost[128];
	int myport;

	if( DONT_REWRITE ){
		strcpy(myhost,MYSELF);
		myport = 0;
	}else{	
		myport = ClientIF_H(Conn,myhost);
	}
	ImResponseFilter = 1;
	CONN_DONE = CONN_START = Time();
	HTTP_relay_response(Conn,0,CLNT_PROTO,myhost,myport,req,NULL,0,
		in,out,NULL,NULL,0);
}
FILE *openHttpResponseFilter(Conn,tc)
	Connection *Conn;
	FILE *tc;
{
	sv1log("## openHttpResponseFilter: clnt=%d will=%d chunk=%d\n",
		ClntKeepAlive,WillKeepAlive,ClntAccChunk);
	if( !ClntAccChunk ){
		/* URLs (in /-/ page for example) may be rewriten in the filter
		 * without correcting Content-Length
		 */
		HTTP_clntClose(Conn,"x:response filter");
	}
	Conn->fi_builtin = 1;
	return openFilter(Conn,"HttpResponseFilter",sendHttpResponse,tc,OREQ);
}
HTTP_relayThru(Conn)
	Connection *Conn;
{
	return DONT_REWRITE
		&& !CTX_cur_codeconvCL(Conn,NULL) && !CCXactive(CCX_TOCL);
}
service_file(Conn)
	Connection *Conn;
{
	sv1log("access to file ... \n");
}

FILE * CTX_URLget(OrigConn,origctx,url,reload,out)
	Connection *OrigConn;
	char *url;
	FILE *out;
{	Connection ConnBuf,*Conn = &ConnBuf;
	char req[1024],*rp,resp[1024];
	char genauth[512];
	int io[2];
	FILE *aout;
	HttpResponse resx;

	aout = out;
	if( out == NULL )
		out = TMPFILE("CTX_URLget");

	if( strncasecmp(url,"file:",5) == 0 )
	if( !isExecutableURL(url) ){
		FILE *fp;
		char host[128],*path;

		path = file_hostpath(url,NULL,host);
		nonxalpha_unescape(path,path,1);
		if( *path == '/' && isFullpath(path+1) )
			path++;

		if( fp = fopen(path,"r") ){
			copyfile1(fp,out);
			fclose(fp);
			fflush(out);
			Ftruncate(out,0,1);
			fseek(out,0,0);
			return out;
		}
		if( aout == NULL && out != NULL )
			fclose(out);
		return NULL;
	}
	if( strncasecmp(url,"data:",5) == 0 ){
		HTTP_putData(OrigConn,out,0,url+5);
		fflush(out);
		Ftruncate(out,0,1);
		fseek(out,0,0);
		return out;
	}
	if( strncasecmp(url,"builtin:",8) == 0 ){
		extern char *getMssg();
		char *data;
		int leng;

		sprintf(req,"builtin/%s",url+8);
		data = getMssg(req,&leng);
		if( data == NULL )
			return NULL;
/*
 * eval. if with ".dhtml" extension.
 * on each request based on conditional info.
 */
		fwrite(data,1,leng,out);
		fflush(out);
		Ftruncate(out,0,1);
		fseek(out,0,0);
		return out;
	}

	if( OrigConn && origctx ){
		ConnCopy(Conn,OrigConn);
		ClntKeepAlive = 0;
		WillKeepAlive = 0;
		ToMyself = 0;
		Conn->sv_dflt = OrigConn->sv_dfltsav;
		bzero(&Conn->sv,sizeof(Conn->sv));
		ToS = ToSX = -1;
	}else{
		ConnInit(Conn);
		Conn->from_myself = 1;
	}
	ACT_SPECIALIST = 1;

	if( OrigConn ){
		ClientSock = OrigConn->cl_sockFd;
		/*
		Conn->oc_isset = 1;
		Conn->oc_norewrite = OrigConn->oc_norewrite;
		strcpy(Conn->oc_proxy,OrigConn->oc_proxy);
		strcpy(Conn->oc_proto,OrigConn->oc_proto);
		*/
	}

	Socketpair(io);
	FromC = io[0];
	ToC = dup(fileno(out));

	rp = Sprintf(req,"GET %s HTTP/1.0\r\n",url);
	rp = Sprintf(rp,"User-Agent: DeleGate/%s\r\n",DELEGATE_ver());
	if( reload )
		rp = Sprintf(rp,"Pragma: no-cache\r\n");
	if( makeAuthorization(Conn,genauth,0) ){
		sv1log("## GEN Authorization...\n");
		rp = Sprintf(rp,"Authorization: %s\r\n",genauth);
	}
	strcpy(rp,"\r\n");

	DDI_pushCbuf(Conn,req,strlen(req));
	service_http(Conn);

	fflush(out);
	Ftruncate(out,0,1);
	fseek(out,0,0);

	if( fgets(resp,sizeof(resp),out) != NULL ){
		if( strncmp(resp,F_HTTPVER,F_HTTPVERLEN) == 0 ){
			if( decomp_http_status(resp,&resx) != 200 ){
				Ftruncate(out,0,0);
				fseek(out,0,0);
				fgetc(out); /* set EOF to indicate error */
				sv1log("error: %s",resp);
			}else{
				while( fgets(resp,sizeof(resp),out) != NULL )
					if( resp[0] == '\r' || resp[0] == '\n' )
						break;
			}
		}else{
			fseek(out,0,0);
		}
	}

	close(io[0]);
	close(io[1]);

	return out;
}
FILE * URLget(url,reload,out)
	char *url;
	FILE *out;
{
	return CTX_URLget(NULL,0,url,reload,out);
}

extern char *TIMEFORM_RFC822;
putFileInHTTP(tc,path,file)
	FILE *tc;
	char *path,*file;
{	FILE *fp;
	int size,mtime;
	char sdate[1024];

	fp = fopen(path,"r");
	if( fp == NULL ){
		fprintf(tc,"HTTP/1.0 404 not found\r\n");
		return;
	}
	size = file_size(fileno(fp));
	mtime = file_mtime(fileno(fp));
	StrftimeGMT(sdate,sizeof(sdate),TIMEFORM_RFC822,mtime);

	fprintf(tc,"HTTP/1.0 200 OK\r\n");
	fprintf(tc,"MIME-Version: 1.0\r\n");
	fprintf(tc,"Content-Type: application/octet-stream\r\n");
	fprintf(tc,"Content-Transfer-Encoding: base64\r\n");
	fprintf(tc,"Content-Length: %d\r\n",size);
	fprintf(tc,"Last-Modified: %s\r\n",sdate);
	fprintf(tc,"\r\n");
	MIME_to64(fp,tc);
	fclose(fp);
}

HTTP_delayReject(Conn,req,stat,self)
	Connection *Conn;
	char *req,*stat;
{	char *method,*url;
	HttpRequest reqx;
	char path[URLSZ],referer[URLSZ];
	char shost[256];
	int sport;

	decomp_http_request(req,&reqx);
	method = reqx.hq_method;
	url = reqx.hq_url;

	path[0] = 0;
	decomp_absurl(url,NULL,NULL,path,sizeof(path));
	HTTP_getRequestField(Conn,"Referer",referer,sizeof(referer));

	self |= DO_DELEGATE || IsMounted || IAM_GATEWAY;
	sport = getClientHostPort(Conn,shost);
	logReject(Conn,self,shost,sport);
	delayReject(Conn,self,method,DFLT_PROTO,shost,sport,path,referer,stat);
}
HTTP_delayCantConn(Conn,req,stat,self)
	Connection *Conn;
	char *req,*stat;
{	char method[64];
	char shost[256];
	int sport;

	wordScan(req,method);

	self |= DO_DELEGATE || IsMounted || IAM_GATEWAY;
	sport = getClientHostPort(Conn,shost);
	delayReject(Conn,self,method,DFLT_PROTO,shost,sport,"","",stat);
}
