/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997-1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1997-1999 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	httphead.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970708	extracted from httpd.c
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "http.h"
#include "ystring.h"
#include "filter.h"
#include <ctype.h>

extern char *CCXcharset();
extern char *findField();
extern char *findFieldValue();
extern char *fgetsHeaderField();
extern char *HTTP_getRequestField();
extern char *CTX_mount_url_to();
extern char *URL_toMyself();
extern char *paramscanX();

#define FPRINTF		leng += Fprintf

extern int START_TIME1;

typedef struct {
	char *m_name;
} Method;
static Method validMethods[] = {
	{"OPTIONS"	},
	{"GET"		},
	{"HEAD"		},
	{"POST"		},
	{"PUT"		},
	{"DELETE"	},
	{"TRACE"	},
	{"PATCH"	},
	{"LINK"		},
	{"UNLINK"	},
	{"CONNECT"	},
	{"X-CACHE-GET"	},
	{0}
};
static Method *allowMethodV;

/* TODO: HTTPCONF=methods:*,!M1,!M2" or "methods:!M1,!M2" should be supported.
 *       Should be declarable if a method has a {request/response} body or not
 */ 
static int allowAnyMethods;
static acceptableRequest(req)
	char *req;
{	int maj,min;

	if( allowAnyMethods )
	if( sscanf(req,"%*[a-zA-Z] %*[a-zA-Z]://%*[^ ] HTTP/%d.%d",
		&maj,&min) == 2 )
			return 1;
	return 0;
}

char *CTX_reqstr(Conn)
	Connection *Conn;
{
	if( Conn == NULL )
		return 0;
	if( CurEnv )
		return REQ_FIELDS;
	else	return 0;
}

static putMimeHeader(tc,type,encoding,size)
	FILE *tc;
	char *type,*encoding;
{	int leng = 0;

	FPRINTF(tc,"MIME-Version: %s\r\n",MY_MIMEVER);
	FPRINTF(tc,"Content-Type: %s\r\n",type);
	if( encoding != ME_7bit )
	FPRINTF(tc,"Content-Transfer-Encoding: %s\r\n",encoding);
	if( 0 < size )
	FPRINTF(tc,"Content-Length: %d\r\n",size);
	return leng;
}
static makeDeleGateHeader(head,iscache)
	char *head;
{
	sprintf(head,"DeleGate-Ver: %s (delay=%d)",
		DELEGATE_ver(),time(0)-START_TIME1);
	if( iscache )
		strcat(head," (from-cache)");
}
HTTP_putDeleGateHeader(Conn,tc,iscache)
	Connection *Conn;
	FILE *tc;
{	int leng = 0;
	char head[256];

	makeDeleGateHeader(head,iscache);
	if( !HTTP_head2kill(head,KH_OUT|KH_RES) )
	FPRINTF(tc,"%s\r\n",head);
	leng += HTTP_echoRequestHeader(Conn,tc);
	return leng;
}

putHEAD(Conn,tc,code,reason,server,ctype,ccode,csize,mtime,expire)
	Connection *Conn;
	FILE *tc;
	char *reason,*server,*ctype,*ccode;
{	int leng;
	char date[128],serverb[128];
	int tobeclosed;
	int tobechunked;
	char *myver;

	if( ctype == NULL ) ctype = "text/html";
	if( ccode == NULL ) ccode = ME_7bit;
	StrftimeGMT(date,sizeof(date),TIMEFORM_RFC822,time(0));
	if( server == NULL ){
		server = serverb;
		sprintf(server,"DeleGate/%s",DELEGATE_ver());
	}

	tobeclosed = 0;
	tobechunked = 0;
	if( csize <= 0 ){
		if( ClntAccChunk ){
			tobechunked = 1;
			/* Content-Length filed is not necessary */
		}else
		if( code == 304 /* || method == HEAD */ ){
			/* message is without body */
		}else{
			/* lacking necessary Content-Length info. to make
			 * connection be Keep-Alive
			 */
			tobeclosed = 1;
		}
	}

	myver = MY_HTTPVER;
	/* HTTP/1.1 response must not be closed without "Connection: close".
	 * Currenty this can occur for requests from HTTP/1.0 client
	 * without "Connection: keep-alive".
	 */
	if( !ClntAccChunk ) /* non-HTTP/1.1 client */
	if( !WillKeepAlive || tobeclosed )
	if( strcmp(myver,"1.0") != 0 )
		myver = "1.0";

	leng = 0;
	FPRINTF(tc,"HTTP/%s %d %s\r\n",myver,code,reason);
	leng += FPRINTF(tc,"Date: %s\r\n",date);
	leng += FPRINTF(tc,"Server: %s\r\n",server);
	leng += HTTP_putDeleGateHeader(Conn,tc,NULL);
	leng += putMimeHeader(tc,ctype,ccode,csize);
	if( genETag[0] ){
		leng += FPRINTF(tc,"ETag: %s\r\n",genETag);
		genETag[0] = 0;
	}

	if( mtime != -1 && mtime != 0 ){
		StrftimeGMT(date,sizeof(date),TIMEFORM_RFC822,mtime);
		FPRINTF(tc,"Last-Modified: %s\r\n",date);
	}
	if( expire != -1 && expire != 0 ){
		StrftimeGMT(date,sizeof(date),TIMEFORM_RFC822,expire);
		FPRINTF(tc,"Expires: %s\r\n",date);
	}

	if( tobeclosed ){
		HTTP_clntClose(Conn,"U:unknown size internal response");
	}
	HTTP_modifyConnection(Conn,csize);
	leng += putKeepAlive(Conn,tc);

	if( tobechunked && WillKeepAlive && RespWithBody ){
		sv1log("## MUST USE CHNUNKED ENCODING: HTTP/%s %d %s ##\n",
			myver,code,reason);
		FPRINTF(tc,"Transfer-Encoding: chunked\r\n");
	}
	return leng;
}
genHEADX(Conn,tc,code,reason,cleng)
	Connection *Conn;
	FILE *tc;
	char *reason;
{	int leng;
	int expire;

	expire = -1;
	switch( code ){
	case 301:
		expire = time(0) + 60*60;
		break;
	case 302:
		expire = time(0) + 60;
		break;
	case 305:
	case 306:
		expire = time(0) + 60*60;
		break;
	}
	leng = putHEAD(Conn,tc,code,reason, NULL,NULL,NULL,cleng,-1,expire);
	return leng;
}

putHttpHeader1X(Conn,tc,vno,server,type,encoding,size,mtime,expire,status)
	Connection *Conn;
	FILE *tc;
	char *server,*type,*encoding;
	char *status;
{	int leng = 0;
	int code;
	char *sp,reason[2048];

	if( vno < 100 )
		return 0;

	code = 200;
	strcpy(reason,"OK");
	if( status != NULL ){
		sp = scanint(status,&code);
		lineScan(sp,reason);
	}

leng = putHEAD(Conn,tc,code,reason,server,type,encoding,size,mtime,expire);

	FPRINTF(tc,"\r\n");
	return leng;
}
putHttpHeader1(Conn,tc,server,type,encoding,size,expire)
	Connection *Conn;
	FILE *tc;
	char *server,*type,*encoding;
{
return
putHttpHeader1X(Conn,tc,100,server,type,encoding,size, -1,     expire,NULL);
}
putHttpHeaderV(Conn,tc,vno,server,type,encoding,size,lastmod,expire)
	Connection *Conn;
	FILE *tc;
	char *server,*type,*encoding;
{
return
putHttpHeader1X(Conn,tc,vno,server,type,encoding,size,lastmod, expire,NULL);
}
HTTP_putHeader(Conn,tc,vno,type,size,mtime)
	Connection *Conn;
	FILE *tc;
	char *type;
{	int lastmod;

	if( vno < 100 ){
		sv1log("No header put: client is HTTP %d.%d\n",
			vno/100,vno%100);
		return 0;
	}
	if( 0 < mtime )
		lastmod = mtime;
	else
	if( mtime == 0 )
		lastmod = get_builtin_MADE_TIME();
	else	lastmod = 0;

return
putHttpHeader1X(Conn,tc,vno,NULL,  type,ME_7bit, size, lastmod, 0,     NULL);
}


setKeepAlive(Conn,timeout)
	Connection *Conn;
{
	if( 1 < CKA_RemAlive )
		sprintf(httpConn,"keep-alive, timeout=%d, maxreq=%d",
			timeout,CKA_RemAlive);
	else	strcpy(httpConn,"close");
}
HTTP_clntClose(Conn,fmt,a,b,c,d,e,f,g)
	Connection *Conn;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{
	WillKeepAlive = 0;
	sprintf(WhyClosed,fmt,a,b,c,d,e,f,g);
	Verbose("HCKA:[%d] %s\n",RequestSerno,WhyClosed);
}
putKeepAlive(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	int leng;
	char buff[256];

	if( leng = getKeepAlive(Conn,buff) )
		fputs(buff,tc);
	return leng;
}
getKeepAlive(Conn,KA)
	Connection *Conn;
	char *KA;
{
	KA[0] = 0;
	if( Conn != NULL && ClntKeepAlive ){
		if( WillKeepAlive ){
			/* HTTP/1.1 does not require explicit keep-alive ... */
			sprintf(KA,"%s: %s\r\n",ConnFname,httpConn);
		}else	sprintf(KA,"%s: close\r\n",ConnFname);
		SentKeepAlive = WillKeepAlive;
		return strlen(KA);
	}else	return 0;
}

static char *getHost(head,host,size)
	char *head,*host;
{	char *ohpp,ohpb[256],*hp,hc;

	if( ohpp = findFieldValue(head,"Host") ){
		RFC822_valuescan(ohpp,ohpb,sizeof(ohpb));
		for( hp = ohpb; hc = *hp; hp++ ){
			if( (hc & 0x80) || hc <= 0x20 ){
				sv1log("##ERROR: ignored malformed Host: %s\n",
					ohpb);
				return 0;
			}
		}
		wordscanX(ohpb,host,size);
		return ohpp;
	}
	return 0;
}
HTTP_setHost(Conn,fields)
	Connection *Conn;
	char *fields;
{	char *ohpp,ohpb[256],genhost[256],hostfield[256];

	if( GEN_VHOST[0] )
	{
		if( streq(GEN_VHOST,"-thru") ){
			genhost[0] = 0;
			getHost(fields,genhost,sizeof(genhost));
		}else
		strcpy(genhost,GEN_VHOST);
	}
	else	HostPort(genhost,DST_PROTO,DST_HOST,DST_PORT);

	if( (ohpp = getHost(fields,ohpb,sizeof(ohpb))) == NULL ){
		sprintf(hostfield,"Host: %s\r\n",genhost);
		RFC822_addHeaderField(fields,hostfield);
	}else{
		/* replace it ... */
		/* if the request is for proxy (DONT_REWRITE, with full-URL) or
		 * if the field may be rewritten by MOUNT.
		 * (PointCast2.X clients send request including "Host: proxy")
		 */
		if( DONT_REWRITE || DO_DELEGATE || IsMounted ){
			if( strcmp(genhost,ohpb) != 0 ){
				sv1log("XHost: (%d,%d,%d) %s <= %s\n",
					DONT_REWRITE,DO_DELEGATE,IsMounted,
					genhost,ohpb);
if( strchr(genhost,'%') ){
	sv1log("## unescape host-name in Host: %s\n",genhost);
	nonxalpha_unescape(genhost,genhost,0);
}
				replace_line(ohpp,genhost);
			}else	Verbose("Host: %s <= %s\n",genhost,ohpb);
		}
	}
}
static save_VHOST(Conn,url)
	Connection *Conn;
	char *url;
{	char ohpb[256],myhost[256];
	int myport;

	OREQ_VHOST[0] = 0;

	if( url[0] == '/' )
	if( getHost(OREQ_MSG,ohpb,sizeof(ohpb)) )
	if( (myport = scan_Hostport1(ohpb,myhost)) || *myhost )
	if( !ImMaster || IsMyself(myhost) ) /* req. directed to myself */
	{
		if( myport == 0 )
			myport = serviceport(CLNT_PROTO);
		IsVhost = !Ismyself(Conn,CLNT_PROTO,myhost,myport);
		if( IsVhost && sizeof(OREQ_VHOST)/2-8 < strlen(myhost) ){
			sv1log("Truncated long virtual hostname: %s\n",myhost);
			myhost[sizeof(OREQ_VHOST)/2-8] = 0;
		}
		sprintf(OREQ_VHOST,"%s:%d",myhost,myport);
		return 1;
	}
	return 0;
}
HTTP_getHost(Conn,request,fields)
	Connection *Conn;
	char *request,*fields;
{	char *url,ohpb[256],host[256];
	int port;
	char *myproto;

	if( getHost(fields,ohpb,sizeof(ohpb)) ){
		myproto = CLNT_PROTO;
		port = scan_Hostport1p(myproto,ohpb,host);
		set_realsite(Conn,myproto,host,port);

		if( url = strpbrk(request," \t") ){
			while( *url == ' ' || *url == '\t' )
				url++;
			if( url[0] == '/' || url[0] == '*' )
				Verbose("Host: %s:%d\n",host,port);
		}
	}
}

/*
 * Replace "-.-" wich my real hostname.
 * The result will be sent to the server in Referer field.
 * The hostname of client's side socket should be used semantically, but
 * it might be hidden interface to the server. So instead use the hostname
 * of server's side socket.
 */
static substRealname(Conn,url)
	Connection *Conn;
	char *url;
{	char *proto;
	int plen;
	char tmp[URLSZ],me[256];
	int port;

	proto = CLNT_PROTO;
	plen = strlen(proto);

	if( 0 <= ToS )
	if( strncmp(url,proto,plen) == 0 )
	if( strncmp(url+plen,"://-.-",6) == 0 ){
		lineScan(url+plen+6,tmp);
		getservsideNAME(Conn,me);
		port = sockPort(ClientSock);
		if( port != serviceport(proto) )
			sprintf(me+strlen(me),":%d",port);
		sprintf(url,"%s://%s%s",proto,me,tmp);
		return 1;
	}
	return 0;
}

static stripDeleGate(Conn,durl)
	Connection *Conn;
	char *durl;
{	char upath[URLSZ],*up,mods[256],flags[256];
	char *proto;
	char rproto[64],rhost[256],rhostport[256];
	char mupath[URLSZ];
	int rport;
	int rewritten = 0;

	while( *durl == ' ' || *durl == '\t' )
		durl++;

	if( *durl == '0' || *durl == '\r' || *durl == '\n' )
		return 0;

	if( (up = URL_toMyself(Conn,durl)) == 0 )
		return 0;

	strcpy(upath,up);
	if( upath[0] == 0 )
		strcpy(upath,"/");

	proto = CLNT_PROTO;
	strcpy(rproto,proto);
	if( CTX_url_derefer(Conn,proto,upath,mods,flags,rproto,rhost,&rport) ){
		HostPort(rhostport,rproto,rhost,rport);
		sprintf(durl,"%s://%s%s",rproto,rhostport,upath);
		Verbose("STRIPPED: %s\n",durl);
		rewritten = 1;
	}else{
		decomp_absurl(durl,rproto,rhostport,NULL,0);
		rport = scan_hostport(rproto,rhostport,rhost);
	}


	if( !Ismyself(Conn,rproto,rhost,rport) )
		return rewritten;

	strcpy(mupath,upath);
	/*
	 * send real URL with real host name in the Referer field to the server
	 * (ie. not in virtual URL on DeleGate) if the server is that in the
	 * Referer field, so that the server can recognize that the Referer
	 * field refers to itself.
	 */
	if( CTX_mount_url_to(Conn,Conn->cl_myhp,REQ_METHOD,mupath) ){
		decomp_absurl(mupath,rproto,rhostport,NULL,0);
		rport = scan_hostport(rproto,rhostport,rhost);
		if( rport != DST_PORT )
			return;
		if( strcmp(rproto,DST_PROTO) != 0 )
			return;
		if( hostcmp(rhost,DST_HOST) != 0 )
			return;
		strcpy(durl,mupath);
		Verbose("MOUNTED: %s\n",durl);
		rewritten = 1;
	}
	return rewritten;
}

/*
 * Referer URL should be rewritten to the real URL when it is relayed
 * to the server of the URL, so that it can be recognized at the server.
 * This is neccearry to let work some "URL access counters" embedded in 
 * a html text, which use the Referer as the target of the counter.
 */
MountReferer(Conn,fields)
	Connection *Conn;
	char *fields;
{	char *val,url[URLSZ];

	if( val = findFieldValue(fields,"Referer") ){
		RFC822_valuescan(val,url,sizeof(url));

		if( substRealname(Conn,url) ){
			replace_line(val,url);
		}
		if( stripDeleGate(Conn,url) ){
			sv1log("rewritten Referer: %s\n",url);
			replace_line(val,url);
		}
	}
}

/* strip redundant http://myHost:myPort/ for rewriting in MOUNT */
static stripMyself(Conn,url)
	Connection *Conn;
	char *url;
{	char uc[2],*up,*upath;

	if( url[0] != '/' )
	if( up = URL_toMyself(Conn,url) ){
		uc[0] = *up; uc[1] = 0;
		*up = 0;
		if( uc[0] )
			upath = up + 1;
		else	upath = "";
		sv1log("##stripped before MOUNT [%s]%s%s%s",url,uc,
			upath,strtailchr(upath)!='\n'?"\n":"");
		*up = uc[0];
		if( uc[0] != '/' )
			*url++ = '/';
		strcpy(url,up);
	}
}
/*
 * using VHOST for pages in ToInternal is desirable
 * but not desirable if with forced DELEGATE or BASEURL parameter
 */
HTTP_ClientIF_H(Conn,host)
	Connection *Conn;
	char *host;
{
	int port;
	if( port = forcedIF_H(Conn,host) )
		return port;
	/*
	if( CurEnv && (DO_DELEGATE||IsMounted) && OREQ_VHOST[0] )
	*/
	if( CurEnv && (DO_DELEGATE||IsMounted||ToInternal) && OREQ_VHOST[0] )
		return scan_hostport(DFLT_PROTO,OREQ_VHOST,host);
	else	return ClientIF_H(Conn,host);
}
HTTP_ClientIF_HP(Conn,hostport)
	Connection *Conn;
	char *hostport;
{
	if( forcedIF_HP(Conn,hostport) )
		return;
	/*
	if( CurEnv && (DO_DELEGATE||IsMounted) && OREQ_VHOST[0] )
	*/
	if( CurEnv && (DO_DELEGATE||IsMounted||ToInternal) && OREQ_VHOST[0] )
		strcpy(hostport,OREQ_VHOST);
	else	ClientIF_HP(Conn,hostport);
}
extern char *baseURL();
static char *HTTP_baseURL(Conn)
	Connection *Conn;
{
	/*
	 * cl_baseurl is set when the DeleGate is invoked as a CGI program
	 * with SCRIPT_NAME which is the virtual URL of the root path of
	 * CGI-DeleGate in the client view.  It is not a full-URL but such
	 * a relative-URL without site part seems enough and desirable...
	 * When the parent HTTP server is also DeleGate, /-/builtin/icons/*
	 * of the parent can be used for efficiency, but maybe it shold be
	 * controlled in general way, maybe with some MOUNT extension ...
	 */
	if( Conn->cl_baseurl[0] )
		return Conn->cl_baseurl;

	if( CurEnv && (DO_DELEGATE||IsMounted) && OREQ_VHOST[0] ){
		sprintf(Conn->iconbase,"%s://%s",CLNT_PROTO,OREQ_VHOST);
		return Conn->iconbase;
	}else	return baseURL(Conn);
}
HTTP_baseURLrelative(Conn,path,url)
	Connection *Conn;
	char *path,*url;
{
	strcpy(url,HTTP_baseURL(Conn));
	if( strtailchr(url) != '/' && *path )
		strcat(url,"/");
	if( *path == '/' )
		path++;
	strcat(url,path);
}

static char *vmount(Conn,url)
	Connection *Conn;
	char *url;
{	char *opts;
	char xvhost[256];

	opts = NULL;
	if( OREQ_VHOST[0] ){
		xvhost[0] = '-';
		wordscanX(OREQ_VHOST,xvhost+1,sizeof(xvhost)-1);
		opts = CTX_mount_url_to(Conn,xvhost,REQ_METHOD,url);
	}
	stripMyself(Conn,url);
	if( opts == NULL ){
		opts = CTX_mount_url_to(Conn,Conn->cl_myhp,REQ_METHOD,url);
	}
	return opts;
}
static vmount_moved(Conn,url)
	Connection *Conn;
	char *url;
{	char xvhost[256];
	int rcode;

	rcode = 0;
	if( OREQ_VHOST[0] ){
		xvhost[0] = '-';
		wordscanX(OREQ_VHOST,xvhost+1,sizeof(xvhost)-1);
		rcode = CTX_moved_url_to(Conn,xvhost,REQ_METHOD,url);
	}
	if( rcode == 0 ){
		rcode = CTX_moved_url_to(Conn,Conn->cl_myhp,REQ_METHOD,url);
	}
	if( rcode == non_MOVED() ){
		/* matched non_MOVED */
		return 0;
	}
	return rcode;
}
/*
 * Maybe this functionn is obsolete covered/generalized by
 * MountSpecialResponse() with rcode=xxx:
 *   moved --- rcode=302
 *   useproxy --- rcode=305
 */
MountMoved(Conn,tc,req,req_url)
	Connection *Conn;
	FILE *tc;
	char *req,*req_url;
{	char moved_url[URLSZ];
	char proxy[128];
	int totalc;
	char *query,me[128],realurl[URLSZ];
	int rcode;

	nonxalpha_unescape(req_url,moved_url,0);
	stripMyself(Conn,moved_url);

	if( query = strstr(moved_url,"?-.-=") ){
		if( strncmp(moved_url,"/-_-",4) == 0 ){
			ClientIF_HP(Conn,me);
			sprintf(realurl,"%s://%s/-_-%s",CLNT_PROTO,me,query+5);
		}else	strcpy(realurl,query+5);
		sv1log("REDIRECT %s -> %s\n",moved_url,realurl);
		totalc = putMovedTo(Conn,tc,realurl);
		http_Log(Conn,302,CS_INTERNAL,req,totalc);
		return 1;
	}

	save_VHOST(Conn,moved_url);
/*
	if( OREQ_VHOST[0]
	 && (rcode = CTX_moved_url_to(Conn,OREQ_VHOST,   REQ_METHOD,moved_url))
	 || (rcode = CTX_moved_url_to(Conn,Conn->cl_myhp,REQ_METHOD,moved_url))
	)
*/
	rcode = vmount_moved(Conn,moved_url);
	if( rcode )
	if( !streq(moved_url,req_url) ){
		totalc = putMovedToX(Conn,tc,rcode,moved_url);
		http_Log(Conn,rcode,CS_INTERNAL,req,totalc);
		return 1;
	}

	/*
	 * check change-proxy based only on the real interface name
	 * but not on the virtual host name (seems enough).
	 */
	if( CTX_changeproxy_url(Conn,Conn->cl_myhp,REQ_METHOD,moved_url,proxy)){
		totalc = putChangeProxy(Conn,tc,moved_url,proxy);
		http_Log(Conn,305,CS_INTERNAL,req,totalc);
		sv1log("RETURNED 305 for: %s",req);
		HTTP_delayReject(Conn,req,"",1);
		return 1;
	}
	return 0;
}
MountSpecialResponse(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char url[URLSZ],*opts,*rp,proto[256],host[256];
	int rcode,totalc,port;

	strcpy(url,REQ_URL);
	save_VHOST(Conn,url);
	stripMyself(Conn,url);
	opts = vmount(Conn,url);
/*
	if( save_VHOST(Conn,url) )
		opts = CTX_mount_url_to(Conn,OREQ_VHOST,REQ_METHOD,url);
	else	opts = CTX_mount_url_to(Conn,Conn->cl_myhp,REQ_METHOD,url);
*/

	if( opts ){
		if( isinList(opts,"forbidden") )
			opts = "rcode=403";
		else
		if( isinList(opts,"unknown") )
			opts = "rcode=404";
	}

	if( opts )
	if( rp = strstr(opts,"rcode=") )
	if( rcode = atoi(rp+6) ){
		port = ClientIF_H(Conn,host);
		set_realserver(Conn,DFLT_PROTO,host,port);
		switch( rcode ){
		case 300:
		case 301:
		case 302:
		case 303:
			totalc = putMovedToX(Conn,tc,rcode,url);
			http_Log(Conn,rcode,CS_INTERNAL,REQ,totalc);
			return 1;
		case 304:
			totalc = putHttpNotModified(Conn,tc);
			http_Log(Conn,rcode,CS_INTERNAL,REQ,totalc);
			return 1;
		case 305:
		case 306:
			totalc = putChangeProxy(Conn,tc,url,"");
			http_Log(Conn,rcode,CS_INTERNAL,REQ,totalc);
			return 1;
		case 403:
			{
			char how[64];
			sprintf(how,"reject in MOUNT[%d]",mount_lastforw());
			HTTP_reject(Conn,"URL rejected",how);
			}
			totalc = putHttpRejectmsg(Conn,tc,"","",0,REQ);
			http_Log(Conn,rcode,CS_AUTHERR,REQ,totalc);
			/* if( strchr(opts,"delay") ) HTTP_delayReject(); */
			return 1;
		case 404:
			totalc = putUnknownMsg(Conn,tc,REQ);
			http_Log(Conn,rcode,CS_AUTHERR,REQ,totalc);
			return 1;
		}
	}
	return 0;
}
URL_withUpath(url)
	char *url;
{	int len;

	if( strncasecmp(url,"file" ,len=4) == 0
	 || strncasecmp(url,"cgi"  ,len=3) == 0
	 || strncasecmp(url,"ftp"  ,len=3) == 0
	 || strncasecmp(url,"http" ,len=4) == 0
	 || strncasecmp(url,"https",len=5) == 0 )
	if( url[len] == ':' )
		return len;
	return 0;
}
MountRequestURL(Conn,ourl)
	Connection *Conn;
	char *ourl;
{	char xurl[URLSZ],*opts;

	Verbose("ImMaster? %d <%s://%s:%d> <%s://%s:%d/>\n",
		ImMaster,
		DFLT_PROTO,DFLT_HOST,DFLT_PORT,
		REAL_PROTO,REAL_HOST,REAL_PORT);

	if( ImMaster && !Ismyself(Conn,DFLT_PROTO,DFLT_HOST,DFLT_PORT)){
		Verbose("DON'T MOUNT (ImMaster) %s://%s:%d%s",
			DFLT_PROTO,DFLT_HOST,DFLT_PORT,ourl);
		return 0;
	}

	save_VHOST(Conn,ourl);
	stripMyself(Conn,ourl);
	strcpy(xurl,ourl);

	/*
	opts = NULL;
	if( OREQ_VHOST[0] ){
		char xvhost[512];
		xvhost[0] = '-';
		strcpy(xvhost+1,OREQ_VHOST);
		opts = CTX_mount_url_to(Conn,xvhost,REQ_METHOD,xurl);
	}
	stripMyself(Conn,xurl);
	if( opts == NULL )
		opts = CTX_mount_url_to(Conn,Conn->cl_myhp,REQ_METHOD,xurl);
	*/
	opts = vmount(Conn,xurl);

	if( opts == NULL )
		return 0;

	/*
	 * don't rewrite /robots.txt for non-directory stile target servers
	 * even when root is MOUNTed ...
	 */
	if( strncmp(ourl,"/robots.txt",11) == 0 )
	if( streq(CLNT_PROTO,"http")||streq(CLNT_PROTO,"https") )
	if( URL_withUpath(xurl) == 0 )
		return 0;

	IsMounted = 1;
	strcpy(ourl,xurl);
	sv1log("REQUEST +M %s",ourl);
	eval_mountOptions(Conn,opts);
	{	char *dp,urlesc[128];
		if( dp = strcasestr(opts,"urlesc=") ){
			wordscanY(dp+7,urlesc,sizeof(urlesc),"^,");
			nonxalpha_unescape(urlesc,urlesc,1);
			url_unescape(ourl,ourl,URLSZ,urlesc,"");
			url_escapeX(ourl,ourl,URLSZ,urlesc," \t\r\n");
		}
	}
	MountOptions = opts;
	Conn->no_dstcheck_proto = url_serviceport(xurl);
	return 1;
}

replace_line(oval,val)
	char *oval,*val;
{	char *tp,tc,*sp,sc,*dp;

	for( tp = oval; tc = *tp; tp++ )
		if( tc == ';' || tc == '\r' || tc == '\n' )
			break;
	dp = oval;
	for( sp = val; sc = *sp; sp++ ){
		if( tp <= dp ){
			Strins(dp,sp);
			dp = NULL;
			break;
		}
		*dp++ = sc;
	}
	if( dp != NULL ){
		for( sp = tp; sc = *sp; sp++ )
			*dp++ = sc;
		*dp = 0;
	}
}

static getsetDomPath(value,domain,path,set)
	char *value,*domain,*path;
{	char *vp;
	int domset,pathset;

	if( !set )
		*domain = *path = 0;

	domset = pathset = 0;
	for( vp = value; *vp; vp++ ){
		if( strncasecmp(vp,"DOMAIN=",7) == 0 ){
			domset = 1;
			if( set )
				replace_line(vp+7,domain);
			else	paramscanX(vp+7,";",domain,256);
		}else
		if( strncasecmp(vp,"PATH=",5) == 0 ){
			pathset = 1;
			if( set )
				replace_line(vp+5,path);
			else	paramscanX(vp+5,";",path,1024);
		}
	}
	return domset || pathset;
}
static rewriteCookie(value,url)
	char *value,*url;
{	char *dp,proto[128],login[1024],path[1024],opath[1024];
	char valb[256];

	decomp_absurl(url,proto,login,path,sizeof(path));
	if( dp = strchr(login,':') )
		*dp = 0;
	sprintf(opath,"/%s",path);
	getsetDomPath(value,login,opath,1);

	lineScan(value,valb);
	sv1log("rewriten-Cookie> %s\n",valb);
}
MountCookieRequest(Conn,request,value)
	Connection *Conn;
	char *request,*value;
{	char proto[128],login[1024],domain[1024],path[1024],*dp;
	char opath[1024],url[URLSZ];
	char valb[256];

	lineScan(value,valb);
	sv1log("Cookie: %s\n",valb);

#ifdef RWCOOKIEREQ
	HTTP_originalURLPath(Conn,opath);
	if( !getsetDomPath(value,domain,opath,0) )
		return;

	strcpy(url,opath);
	if( CTX_mount_url_to(Conn,Conn->cl_myhp,REQ_METHOD,url) )
		rewriteCookie(value,url);
#endif
}
MountCookieResponse(Conn,request,value)
	Connection *Conn;
	char *request,*value;
{	char dom[1024],proto[128],login[1024],myhp[1024];
	char opath[1024],url[URLSZ];
	char valb[256];

	lineScan(value,valb);
	sv1log("Set-Cookie: %s\n",valb);

	HTTP_originalURLPath(Conn,opath);
	if( !getsetDomPath(value,dom,opath,0) )
		return;

	HTTP_ClientIF_HP(Conn,myhp);
	HostPort(login,DST_PROTO,DST_HOST,DST_PORT);
	if( opath[0] == '/' )
		ovstrcpy(opath,opath+1);

	if( DO_DELEGATE ){
		sprintf(url,"%s://%s/-_-%s://%s/%s",
			CLNT_PROTO,myhp,DST_PROTO,login,opath);
		rewriteCookie(value,url);
	}else
	if( CTX_mount_url_fromL(Conn,url,DST_PROTO,login,opath,NULL,CLNT_PROTO,myhp) )
		rewriteCookie(value,url);
}
char *URL_toMyself(Conn,url)
	Connection *Conn;
	char *url;
{	int len,port,ux;
	unsigned char uc;
	char host[256];

	if( *url == '/' )
		return url;

	ux = 0;
	len = strlen(CLNT_PROTO);
	if( strncasecmp(&url[ux],CLNT_PROTO,len) != 0 )
		return 0;
	ux = len;
	if( url[ux++] != ':' ) return 0;
	if( url[ux++] != '/' ) return 0;
	if( url[ux++] != '/' ) return 0;

	port = scan_Hostport1p(CLNT_PROTO,&url[ux],host);
	if( !Ismyself(Conn,CLNT_PROTO,host,port) )
		return 0;

	for(; uc = url[ux]; ux++ )
		if( uc == '/' || uc == '?' || isspace(uc) )
			break;

	return &url[ux];
}
HTTP_reqToMyself(Conn)
	Connection *Conn;
{	HttpRequest reqx;

	if( OREQ[0] ){
		decomp_http_request(OREQ,&reqx);
		return URL_toMyself(Conn,reqx.hq_url) != NULL;
	}
	return 0;
}
url_deproxy(Conn,req,url,Rproto,Rhost,Rportp)
	Connection *Conn;
	char *req,*url,*Rproto,*Rhost;
	int *Rportp;
{	char *dp,*tp;
	char rproto[256],rsite[256],upath[URLSZ],rhost[256];
	int rport;

	if( url[0] == '/' )
		return 0;

	/*
	 * get "rproto","rsite" and strip them out from "url"
	 */
	if( 2 <= strip_urlhead(url,rproto,rsite) ){
		if( strcaseeq(rproto,"opher") ){
			/* might be generated in buggy Mosaic ;-) */
			sv1log("Repaired-PROTO: %s to gopher\n",rproto);
			strcpy(rproto,"gopher");
		}
	}else{
		scan_namebody(url,rproto,sizeof(rproto),":",upath,sizeof(upath),NULL);
		if( localPathProto(rproto) ){
			strcpy(rsite,"localhost");
			strcpy(url,upath);
		}else	return 0;
	}

	/*
	 * decompose "rsite" into "rhost" : "rport"
	 */
	rport = 0;
	if( dp = strchr(rsite,'@') ){
		dp = paramscanX(rsite,"@",rhost,sizeof(rhost));
		if( *rhost == 0 )
			strcpy(rhost,"(empty-username)");
		tp = rhost + strlen(rhost);
		dp = paramscanX(dp,":",tp,sizeof(rhost)-(tp-rhost));
		if( *tp == '@' && tp[1] == 0 )
			strcpy(tp+1,"(empty-hostname)");
		if( *dp == ':' )
			rport = atoi(dp+1);
	}else{
		rport = scan_Hostport1(rsite,rhost);
	}
	if( rport == 0 )
		rport = serviceport(rproto);


	/*
	 * obsolete operations...
	 */
	if( url[0]==' ' && url[1]=='/' ){
		/* might be generated in buggy Mosaic ;-) */
		strcpy(url,url+1);
		sv1log("Repaired-URL: %s",req);
	}
	if( strcaseeq(rproto,"gopher") ){
		if( req[0] == '/' && req[1] != '\r' ){
			char tmp[32];
			sprintf(tmp,"(:%c:)",req[1]);
			strcpy(req,req+2);
			Strins(req,tmp);
		}
	}
	if( strcaseeq(rproto,CLNT_PROTO) ){
		if( Ismyself(Conn,rproto,rhost,rport) ){
			set_realsite(Conn,rproto,rhost,rport);
			sv1log("##strip myself [%s:%d]\n",rhost,rport);
			ToMyself = 1;
			return 0;
		}
	}
	if( Rhost[0] != 0 ){
		sprintf(upath,"%s://%s:%d",Rproto,Rhost,*Rportp);
		Strins(url,upath);
		strcpy(REMOTE_PROTO,Rproto);
		strcpy(REMOTE_HOST,Rhost);
		REMOTE_PORT = *Rportp;
		HostPort(upath,"http",rhost,rport);
		scan_DELEGATE(Conn,upath);
		DONT_REWRITE = 0;
	}

	strcpy(Rproto,rproto);
	strcpy(Rhost,rhost);
	*Rportp = rport;

	if( localPathProto(rproto) )
		if( streq(rhost,"localhost") || rhost[0] == 0 )
			ToMyself = 1;

	return 1;
}

HTTP_genVia(Conn,isreq,via)
	Connection *Conn;
	char *via;
{	char host[256],uname[256],myid[256];

	makeVia(Conn,host);
	if( *host == 0 ){
		*via = 0;
		return 0;
	}
	sprintf(myid,"DeleGate/%s",DELEGATE_ver());

	if( Uname(uname) == 0 )
	if( NotifyPlatform(Conn,isreq) )
		sprintf(myid+strlen(myid)," on %s",uname);
	sprintf(via,"%s %s (%s)",MY_HTTPVER,host,myid);
	return 1;
}
FTPHTTP_genPass(pass)
	char *pass;
{
	sprintf(pass,"%s(FTP/HTTP-DeleGate/%s)",
		DELEGATE_ADMIN,DELEGATE_ver());
}

HTTP_selfExpired(cachefp)
	FILE *cachefp;
{	int expired;
	char *found,sdate[256];
	char pragma[256];
	int expires,now;
	char stat[32];
	int statcode;

	if( cachefp == NULL )
		return 0;

	expired = 0;
	found = fgetsHeaderField(cachefp,"Pragma",pragma,sizeof(pragma));
	if( found != NULL && strstr(pragma,"no-cache") ){
		sv1log("EXPIRES: Pragma: %s\n",pragma);
		return 1;
	}

	found = fgetsHeaderField(cachefp,"Expires",sdate,sizeof(sdate));
	expires = 0;
	if( found != NULL ){
		now = time(0);
		expires = scanHTTPtime(sdate);
		if( expires <= now )
			expired = 1;
		sv1log("EXPIRES: %d > %d ? %s\n",now,expires,sdate);
	}

	if( expired )
		return expired;

	stat[0] = 0;
	fgets(stat,sizeof(stat),cachefp);
	fseek(cachefp,0,0);
	statcode = 0;
	sscanf(stat,"%*s %d",&statcode);

	if( (HTTP_cacheopt & CACHE_302) == 0 )
	if( expires == 0 && statcode == 302 ){
		/* regard 302 without Expires: as beeing expired */
		return 1;
	}

	return expired;
}
HTTP_ContLengOk(cachefp)
	FILE *cachefp;
{	char Leng[128];
	int ok,off,leng,hsize,bsize;

	if( cachefp == NULL )
		return 0;

	ok = 0;
	off = ftell(cachefp);
	if( fgetsHeaderField(cachefp,"Content-Length",Leng,sizeof(Leng)) ){
		leng = atoi(Leng);
		RFC821_skipheader(cachefp,NULL,NULL);
		hsize = ftell(cachefp);
		fseek(cachefp,0,2);
		bsize = ftell(cachefp) - hsize;
		if( bsize == leng )
			ok = 1;
		else	sv1log("#### wrong Content-Length: %d -> %d\n",
				leng,bsize);
	}
	fseek(cachefp,off,0);
	return ok;
}
HTTP_getLastModInCache(scdate,size,cachefp,cpath)
	char *scdate;
	FILE *cachefp;
	char *cpath;
{	FILE *hfp;
	int off;
	char *found;

	off = -1;

	if( cachefp ){
		off = ftell(cachefp);
		fseek(cachefp,0,0);
		hfp = cachefp;
	}else	hfp = fopen(cpath,"r");

	if( hfp != NULL ){
		found = fgetsHeaderField(hfp,"Last-Modified",scdate,size);
		if( hfp == cachefp )
			fseek(cachefp,off,0);
		else	fclose(hfp);

		if( found != NULL ){
			Verbose("original Last-Modified: %s\n",scdate);
			return scanHTTPtime(scdate);
		}
	}
	return 0;
}
HTTP_genLastMod(scdate,size,cachefp,cpath)
	char *scdate;
	FILE *cachefp;
	char *cpath;
{	int ncdate;

	if( cachefp )
		ncdate = file_mtime(fileno(cachefp));
	else	ncdate = File_mtime(cpath);

	StrftimeGMT(scdate,size,TIMEFORM_RFC822,ncdate);
	sv1log("generated Last-Modified[%x]: %s\n",cachefp,scdate);
	return ncdate;
}
HTTP_getLastMod(scdate,size,cachefp,cpath)
	char *scdate;
	FILE *cachefp;
	char *cpath;
{	int ncdate;

	if( ncdate = HTTP_getLastModInCache(scdate,size,cachefp,cpath) )
		return ncdate;
	else	return HTTP_genLastMod(scdate,size,cachefp,cpath);
}

extern char *HTTP_passesc;
HTTP_decompAuth(auth,atype,atsiz,aval,avsiz)
	char *auth,*atype,*aval;
{	char *cp,xaval[1024];
	char authb[1024];
	int nesc;

	*atype = *aval = 0;
	RFC822_valuescan(auth,authb,sizeof(authb));
	auth = authb;
	cp = wordscanX(auth,atype,atsiz);
	if( *cp == 0 ){
		if( *atype == 0 )
			return 0;
		else	return 1;
	}
	wordscanX(cp,xaval,sizeof(xaval));
	str_from64(xaval,strlen(xaval),aval,avsiz);
	if( strcasecmp(atype,"basic") == 0 ){
		if( url_escapeX(aval,aval,avsiz,"%S\"'<>","^:") ){
			wordscanY(aval,xaval,sizeof(xaval),"^:");
			sv1log("WARNING: escaped Authorization [%s]\n",xaval);
		}
		if( HTTP_passesc )
		if( nesc = url_escapeX(aval,aval,avsiz,HTTP_passesc,"") ){
			sv1log("WARNING: escaped Authorization (%d) by %s:%s\n",
				nesc,"HTTPCONF=passesc",HTTP_passesc);
		}
	}
	return 2;
}
HTTP_getAuthorization(Conn,proxy,ident,decomp)
	Connection *Conn;
	AuthInfo *ident;
{	char *field,*dp;
	char atype[128],auth[1024],dauth[1024];

	bzero(ident,sizeof(AuthInfo));
	auth[0] = 0;
	if( proxy )
		field = "Proxy-Authorization";
	else	field = "Authorization";
	HTTP_getRequestField(Conn,field,auth,sizeof(auth));

	if( auth[0] != 0
	 && 2 <= HTTP_decompAuth(auth,atype,sizeof(atype),dauth,sizeof(dauth))){
		scan_namebody(dauth,
			ident->i_user,sizeof(ident->i_user),":",
			ident->i_pass,sizeof(ident->i_pass),"\r\n");

		if( decomp ){
			if( dp = strrchr(ident->i_user,'@') ){
				*dp = 0;
				wordScan(dp+1,ident->i_Host);
			}
		}
		return 1;
	}
/*
	if( ClientAuth.i_stat == AUTH_SET ){
		*ident = ClientAuth;
	}
*/
	return 0;
}
HTTP_getAuthorization2(Conn,ident,decomp)
	Connection *Conn;
	AuthInfo *ident;
{	int ratype;

	ratype = 0;
	if( HTTP_getAuthorization(Conn,0,ident,decomp) )
		ratype = 1;
	else
	if( HTTP_getAuthorization(Conn,1,ident,decomp) )
		ratype = 2;
	return ratype;
}
HTTP_authuserpass(Conn,auth,size)
	Connection *Conn;
	char *auth;
{	AuthInfo ident;
	int ratype;

	auth[0] = 0;
	if( ratype = HTTP_getAuthorization2(Conn,&ident,0) )
		sprintf(auth,"%s:%s",ident.i_user,ident.i_pass);
	return ratype;
}
HTTP_forgedAuthorization(Conn,fields)
	Connection *Conn;
	char *fields;
{	char *auth,atype[128],aval[256],*dp,host[256];

	auth = findFieldValue(fields,"Authorization");
	if( auth == 0 )
		return 0;

	HTTP_decompAuth(auth,atype,sizeof(atype),aval,sizeof(aval));

	if( dp = strrchr(aval,'/') ){
		gethostname(host,sizeof(host));
		if( strcmp(dp+1,host) == 0 ){
			sv1log("!!!! FORGED Authorization !!!!! [%s]\n",aval);
			return 1;
		}
	}

	return 0;
}
HTTP_proxyAuthorized(Conn,req,fields,pauth,tc)
	Connection *Conn;
	char *req,*fields;
	FILE *tc;
{	AuthInfo ident;
	int vno,totalc;
	char *host,*user,*pass;

	if( HTTP_getAuthorization(Conn,pauth,&ident,0) ){
		int rcode;
		if( rcode = doAuth(Conn,&ident) ){
			if( 0 < rcode ){
				ClientAuth = ident;
				if( service_permitted2(Conn,DST_PROTO,1) )
					return 1;
				ClientAuthUser[0] = 0;
			}
			return 0;
		}
	}
	if( HTTP_getAuthorization(Conn,pauth,&ident,1) ){
		host = ident.i_Host;
		user = ident.i_user;
		pass = ident.i_pass;
		if( user[0] != 0 ){
			if( host[0] == 0 )
				strcpy(host,"localhost");
			ClientAuth = ident;
			if( service_permitted2(Conn,DST_PROTO,1) ){
				if( 0 <= Authenticate(Conn,host,user,pass,"/") )
					return 1;
			}
			ClientAuthUser[0] = 0;
		}
		sv1log("Not Authorized: user=[%s]@[%s]\n",user,host);
	}else	sv1log("No Authorization\n");
	return 0;
}


ClientIfModClock(Conn)
	Connection *Conn;
{
	return	ClntIfModClock;
}

char *HTTP_originalRequest(Conn,req)
	Connection *Conn;
	char *req;
{
	if( OREQ[0] )
		paramscanX(OREQ,"",req,URLSZ);
	else	req[0] = 0;
	return req;
}
HTTP_originalURLx(Conn,url,siz)
	Connection *Conn;
	char *url;
{	HttpRequest reqx;

	if( OREQ[0] ){
		decomp_http_request(OREQ,&reqx);
		Strncpy(url,reqx.hq_url,siz);
		return reqx.hq_vno;
	}else	return 0;
}
HTTP_originalURLPath(Conn,path)
	Connection *Conn;
	char *path;
{	char url[URLSZ];

	if( HTTP_originalURLx(Conn,url,sizeof(url)) ){
		if( url[0] != '/' )
			strip_urlhead(url,NULL,NULL);

/*
		if( url[0] == '/' && url[1] != '/' ){
This originalURLPath() function is introduced in 2.8.14 just for NNTP/HTTP
(thus URLpath starting with "//" can be bad ?) which is removed at 2.8.19.
So this restriction seems be meaningless and harmful.
*/
		if( url[0] == '/' ){
			wordscanX(url,path,1024);
			return 1;
		}
	}
	path[0] = 0;
	return 0;
}
HTTP_originalURLmatch(Conn,urlc)
	Connection *Conn;
	char *urlc;
{	char *url,*up;
	int leng;

	if( OREQ[0] ){
		leng = strlen(urlc);
		if( url = strpbrk(OREQ," \t") ){
			while( *url == ' ' || *url == '\t' )
				url++;

			if( up = URL_toMyself(Conn,url) )
				url = up;
			if( up = URL_toMyself(Conn,urlc) )
				urlc = up;

			if( strncmp(url,urlc,leng) == 0 )
			if( url[leng] == 0 || strchr(" \t\r\n",url[leng]) )
				return 1;
		}
	}
	return 0;
}
static getModifier(Conn,mod)
	Connection *Conn;
	char *mod;
{	
	if( mod )
		strcpy(mod,Modifier);
	return strlen(Modifier);
}
HTTP_echoRequestHeader(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char *sp,ch;
	int leng = 0;
	char modifiers[512];

	if( !EchoRequest )
		return 0;
	if( !CurEnv )
		return 0;
	if( !HTTP_reqWithHeader(Conn,REQ) )
		return 0;

	fputs("X-Request-Original: ",tc);
	fputs(OREQ,tc);
	if( strstr(OREQ,"\n") == NULL )
		fputs("\r\n",tc);

	if( getModifier(Conn,modifiers) )
		fprintf(tc,"X-Modifier: %s\r\n",modifiers);

	fputs("X-Request: ",tc);
	fputs(REQ,tc);
	leng += strlen("X-Request: ") + strlen(REQ);

	sp = REQ_FIELDS;
	while( ch = *sp ){
		if( ch == '\r' || ch == '\n' )
			break;
		fputs("X-Request-",tc);
		leng += strlen("X-Request-");

		while( ch = *sp ){
			sp++;
			putc(ch,tc);
			leng++;
			if( ch == '\n' && !(*sp == ' ' || *sp == '\t') )
				break;
		}
	}
	return leng;
}
originalHost(Conn,host)
	char *host;
{
}
char *HTTP_originalRequestField(Conn,fname,buff,bsize)
	Connection *Conn;
	char *fname,*buff;
{	char *ffname,*ffbody;

	buff[0] = 0;
	if( CurEnv ){
		if( ffname = findField(OREQ_MSG,fname,&ffbody) ){
			RFC822_valuescan(ffbody,buff,bsize);
			return buff;
		}
	}
	return 0;
}
char *HTTP_getRequestField(Conn,fname,buff,bsize)
	Connection *Conn;
	char *fname,*buff;
{	char *ffname,*ffbody;

	buff[0] = 0;
	if( CurEnv == 0 )
		return 0;

	if( strcmp(fname,"*") == 0 ){
		Strncpy(buff,CurEnv->r_fields,bsize);
		return buff;
	}
	if( CurEnv->r_lastFname ){
		char *lfname;
		int fnlen;
		lfname = CurEnv->r_lastFname;
		fnlen = strlen(fname);

		/* BUG: this header cache should be cleared when
		 * the header buffer is modified ...
		 */
		if( strncasecmp(lfname,fname,fnlen) == 0 )
		if( lfname[fnlen] == ':' && lfname[fnlen+1] == ' ' )
		if( &lfname[fnlen+2] == CurEnv->r_lastFbody ){
			linescanX(CurEnv->r_lastFbody,buff,bsize);
			return buff;
		}
	}
	if( ffname = findField(CurEnv->r_fields,fname,&ffbody) ){
		RFC822_valuescan(ffbody,buff,bsize);
		CurEnv->r_lastFname = ffname;
		CurEnv->r_lastFbody = ffbody;
		return buff;
	}
	return 0;
}
HTTP_delRequestField(Conn,fname)
	Connection *Conn;
	char *fname;
{
	rmField(REQ_FIELDS,fname);
	CurEnv->r_lastFname = NULL;
}
HTTP_putRequest(Conn,fp)
	Connection *Conn;
	FILE *fp;
{	int len = 0;

	if( CurEnv == 0 )
		return 0;

	len += strlen(CurEnv->r_req);
	fputs(CurEnv->r_req,fp);
	len += strlen(CurEnv->r_fields);
	fputs(CurEnv->r_fields,fp);
	return len;
}
HTTP_scanAcceptCharcode(Conn,field)
	Connection *Conn;
	char *field;
{	char *value,*pp,*vp,*dp;
	char code[256],buff[256],param[32],orgval[256],remmark[256];

	remmark[0] = 0;

	if( value = strchr(field,':') ){
		value++;
		while( *value == ' ' || *value == '\t' )
			value++;
		if( *value == 0 || *value == '\r' || *value == '\n' )
			return;
	}else	return;

	orgval[0] = 0;
	lineScan(value,orgval);

	while( pp = strstr(value,"(pragma=") ){
		strcat(remmark,"#"); /* indicate stuff removed */
		vp = pp + 8;
		if( strstr(vp,"thru)") == vp )
			RelayTHRU = 1;
		else
		if( strstr(vp,"no-cache)") == vp ){
			DontReadCache = 1;
			DontWriteCache = 1;
		}
		if( dp = strchr(pp,')') )
			strcpy(pp,dp+1);
		else	break;
	}

	if( (pp = strstr(value,"charcode="))
	 || (pp = strstr(value,"charset="))
	 || (pp = strstr(value,"charconv-")) ){
/*
		UTag *uv[3],ub[4];
*/
		UTag *uv[4],ub[3];
		char del[4];
		strcat(remmark,"#"); /* indicate stuff removed */
		uvinit(uv,ub,3);
		uvfromsf(pp,0,"%[a-zA-Z]%[-=]%[-0-9a-zA-Z_/]",uv);
		Utos(uv[0],param);
		Utos(uv[1],del);
		Utos(uv[2],code);
		sv1log("HTTP %s%s%s\n",param,del,code);
		CCXcreate("*",code,CCX_TOCL);
		Conn->cl_setccx = 1;
		dp = pp+strlen(param)+strlen(del)+strlen(code);
		if( *dp == ';' )
			dp++;
		strcpy(pp,dp);
	}
	while( pp = strstr(value,"()") )
		strcpy(pp,pp+2);
	if( strncmp(value,"()",2) == 0 )
		value += 2;

	if( *value == 0 || *value == '\r' || *value == '\n' )
		*field = 0;

	if( AcceptLanguages ){
		if( AcceptLanguages[0] != 0 ) 
			strcat(AcceptLanguages,", ");
		strcat(AcceptLanguages,orgval);
		if( remmark[0] )
			strcat(AcceptLanguages,remmark);
	}
}

static add_method1(method,methodv)
	char *method;
	Method *methodv;
{	int mi,del;
	char *m1;

	if( methodv == NULL )
		return;

	if( *method == '-' ){
		method++;
		del = 1;
	}else	del = 0;
	for( mi = 0; m1 = methodv[mi].m_name; mi++ ){
		if( strcaseeq(method,m1) ){
			if( del ){
				for(;;mi++){
					methodv[mi] = methodv[mi+1];
					if( methodv[mi].m_name == NULL )
						break;
				}
			}
			goto EXIT;
		}
	}
	if( !del ){
		methodv[mi].m_name = method;
		methodv[mi+1].m_name = 0;
	}
EXIT:
	return 0;
}
static getMethods(Conn,methodv,methods)
	void *Conn;
	Method *methodv;
	char *methods;
{	char *mp,*m1;
	int mi;

	mp = methods;
	if( methodv != NULL ){
	for( mi = 0; m1 = methodv[mi].m_name; mi++ ){
		if( mp != methods )
			*mp++ = ',';
		strcpy(mp,m1);
		mp += strlen(mp);
	}
	}
	*mp = 0;
}
HTTP_allowMethods(Conn,methods)
	void *Conn;
	char *methods;
{
	return getMethods(Conn,allowMethodV,methods);
}
HTTP_setMethods(methods)
	char *methods;
{	char methodb[1024];
	int mi;

	if( strcmp(methods,"*") == 0 ){
		allowAnyMethods = 1;
		return;
	}

	allowMethodV = (Method*)StructAlloc(sizeof(Method)*32);
	for( mi = 0; validMethods[mi].m_name; mi++ )
		allowMethodV[mi] = validMethods[mi];
	allowMethodV[mi].m_name = 0;

	if( methods[0] == '+' && methods[1] == ',' ){
		methods += 2;
	}else
	if( methods[0] == '+' && methods[1] == 0 ){
		methods += 1;
	}else
	if( methods[0] == '-' ){
	}else{
		allowMethodV[0].m_name = 0;
	}
	scan_commaList(methods,1,add_method1,allowMethodV);
	getMethods(NULL,allowMethodV,methodb);
	sv1log("HTTPCONF=methods:%s\n",methodb);
}
static isMethod(methodv,method)
	Method *methodv;
	char *method;
{	int mi;
	char *m1,*mp,mc;

	for( mi = 0; m1 = methodv[mi].m_name; mi++ ){
		mp = method;
		while( *m1 && *mp == *m1 ){
			mp++;
			m1++;
		}
		if( *m1 == 0 ){
			mc = *mp;
			if( mc==0||mc==' '||mc=='\t'||mc=='\r'||mc=='\n' )
				return 1;
		}
	}
	return 0;
}
HTTP_isMethod(method)
	char *method;
{
	if( allowMethodV && isMethod(allowMethodV,method) )
		return 1;
	else	return isMethod(validMethods,method);
}
HTTP_allowMethod1(Conn,req)
	Connection *Conn;
	char *req;
{	int ok;

	if( allowMethodV )
		ok = isMethod(allowMethodV,req);
	else	ok = isMethod(validMethods,req);
	if( !ok ){
		if( acceptableRequest(req) )
			ok = 1;
	}
	return ok;
}

HTTP_methodWithoutBody(method)
	char *method;
{
	return strcasecmp(method,"GET")==0 || strcasecmp(method,"HEAD")==0;
}
HTTP_methodWithBody(method)
	char *method;
{
	return !HTTP_methodWithoutBody(method);
}
HTTP_methodWithoutRespBody(method)
	char *method;
{
	return strcasecmp(method,"HEAD")==0;
}

setHTTPenv(Conn,he)
	Connection *Conn;
	HTTP_env *he;
{
	Conn->cl_reqbuf = (void*)he;
	if( he == NULL )
		return;
	Conn->cl_reqbufsize = sizeof(HTTP_env);

	resetHTTPenv(Conn,he);

	he->r_reqx.hq_method[0] = 0;
	he->r_httpConn[0] = 0;
	he->r_get_cache = 0;
	he->r_iconBase[0] = 0;
}
resetHTTPenv(Conn,he)
	Connection *Conn;
	HTTP_env *he;
{
	he->r_oreqmsg[0] = 0;
	he->r_oreqlen = 0;
	he->r_oreq[0] = 0;
	he->r_ohost.ut_addr[0] = 0;
	he->r_oport = 0;
	he->r_vhost[0] = 0;

	he->r_req[0] = 0;
	he->r_reqx.hq_url[0] = 0;
	he->r_reqx.hq_ver[0] = 0;
	he->r_reqx.hq_vno = 0;

	he->r_fields[0] = 0;
	he->r_lastFname = 0;
	he->r_lastFbody = 0;

	he->r_acclangs.ut_addr[0] = 0;

	he->r_clntIfmod[0] = 0;
	he->r_clntIfmodClock = 0;

	he->r_flushhead = 0;
	he->r_flushsmall = 0;

	he->r_withCookie = 0;
	he->r_appletFilter = 0;
	he->r_dgCookie[0] = 0;
	he->r_clntAccChunk = 0;

	he->r_resp.r_code = 0;
	he->r_resp.r_sav = 0;
	he->r_resp.r_msg.ut_addr[0] = 0;
	he->r_resp.r_len = 0;
	he->r_resp.r_msgfp = 0;
	he->r_doUnzip = 0;
	he->r_doZip = 0;

	he->r_NOJAVA = 0;
}
HTTP_decompRequest(Conn)
	Connection *Conn;
{
	REQ_VNO = decomp_http_request(REQ,&REQX);
	RespWithBody = !HTTP_methodWithoutRespBody(REQ_METHOD);
	return REQ_VNO;
}
decomp_http_request(req,reqx)
	char *req;
	HttpRequest *reqx;
{	char *dp;
	int vmaj,vmin;

	reqx->hq_method[0] = 0;
	reqx->hq_url[0] = 0;
	reqx->hq_ver[0] = 0;
	reqx->hq_vno = 0;

	if( strpbrk(req," \t") == NULL )
		return 0;

	if( !HTTP_isMethod(req) )
	if( !acceptableRequest(req) )
		return 0;

	dp = wordScan(req,reqx->hq_method);
	dp = wordScan(dp,reqx->hq_url);

	vmaj = 0;
	vmin = 9;

	while( *dp == ' ' || *dp == '\t' )
		dp++;
	if( strncmp(dp,"HTTP/",5) == 0 )
		sscanf(dp+5,"%d.%d",&vmaj,&vmin);

	sprintf(reqx->hq_ver,"%d.%d",vmaj,vmin);
	reqx->hq_vno = vmaj*100 + vmin;
	return reqx->hq_vno;
}
HTTP_reqIsHTTP(Conn,req)
	Connection *Conn;
	char *req;
{	HttpRequest reqx;

	if( CurEnv == NULL || req != REQ )
		return HTTP_isMethod(req);
	else
	if( REQ_VNO != 0 )
		return REQ_VNO;
	else	return REQ_VNO = decomp_http_request(req,&reqx);
}
HTTP_reqWithHeader(Conn,req)
	Connection *Conn;
	char *req;
{	HttpRequest reqx;

	if( CurEnv == NULL || req != REQ )
		return 100 <= decomp_http_request(req,&reqx);
	else	return 100 <= HTTP_reqIsHTTP(Conn,REQ);
}

static forwardUserinfo(Conn,hostport)
	Connection *Conn;
	char *hostport;
{	char *dp,user[64],pass[64],userpass[256];
	char b64[256],auth[256],server[256];

	if( strchr(REAL_SITE,'@') == 0 )
		return;

	dp = wordscanY(REAL_SITE,user,sizeof(user),"^:@");
	if( *user == 0 )
		return;

	sprintf(server,"%s@%s",user,hostport);
	strcpy(hostport,server);

	if( *dp == ':' ){
		wordscanY(dp+1,pass,sizeof(pass),"^@");
		sprintf(userpass,"%s:%s",user,pass);
		str_to64(userpass,strlen(userpass),b64,sizeof(b64),1);
		sprintf(auth,"Authorization: Basic %s\r\n",b64);
		RFC822_addHeaderField(REQ_FIELDS,auth);
	}
}
makeProxyRequest(Conn)
	Connection *Conn;
{	HttpRequest reqx;
	char hostport[256];

	decomp_http_request(REQ,&reqx);
	if( reqx.hq_url[0] == '/' ){
		HostPort(hostport,DST_PROTO,DST_HOST,DST_PORT);
		forwardUserinfo(Conn,hostport);
		sprintf(REQ,"%s %s://%s%s HTTP/%s\r\n",reqx.hq_method,
			DST_PROTO,hostport,reqx.hq_url,reqx.hq_ver);
		sv1log("#PROXY REQUEST = %s",REQ);
	}
}

isMovedToSelf(Conn,line)
	Connection *Conn;
	char *line;
{	char base[URLSZ],movedto[URLSZ];

	lineScan(line,movedto);
	if( HTTP_originalURLx(Conn,base,sizeof(base)) && strstr(base,":") ){
		if( streq(base,movedto) )
			return 1;

		/* should check IP-address and HOST-name matching ... */
	}
	return 0;
}
isMovedToAnotherServer(Conn,line)
	Connection *Conn;
	char *line;
{	char movedto[URLSZ];
	char proto[128],hostport[256],host[256];
	int port;

	lineScan(line,movedto);
	decomp_absurl(movedto,proto,hostport,NULL,0);
	port = scan_Hostport1p(proto,hostport,host);

	if( strcasecmp(proto,DST_PROTO) == 0
	 && port == DST_PORT
	 && hostcmp(host,DST_HOST) == 0 )
		return 0;

	sv1log("Moved to another server [%s://%s:%d] -> [%s://%s:%d]\n",
		DST_PROTO,DST_HOST,DST_PORT,proto,host,port);
	return 1;
}

HTTP_getICPurl(Conn,url)
	Connection *Conn;
	char *url;
{	char hostport[256],*upath;
	int ulen;

	if( strcmp(CLNT_PROTO,"http") != 0 )
		return -1;

	if( strncasecmp(REQ,"GET ",4) != 0
	 /* && strncasecmp(REQ,"HEAD ",5) != 0 */ )
	{
		return -1;
	}

	upath = strchr(REQ,' ');
	if( upath == NULL ){
		return -1;
	}
	if( 256 < strlen(upath) ){
		return -1;
	}
	if( strchr(REQ,'?') ){
		return -1;
	}

	upath++;
	if( *upath == '/' || strchr(" \t\r\n",*upath) ){
		upath++;
		HostPort(hostport,DST_PROTO,DST_HOST,DST_PORT);
		sprintf(url,"%s://%s/",DST_PROTO,hostport);
		if( strchr(" \t\r\n",*upath) == NULL ){
			ulen = strlen(url);
			wordscanX(upath,url+ulen,256);
		}
	}else{
		wordscanX(upath,url,256);
	}
	return 0;
}

HTTP_fprintmsg(Conn,fp,fmt)
	Connection *Conn;
	FILE *fp;
	char *fmt;
{	char *mp,*np,line[1024],name[1024],type[1024];
	char *msg;
	int fnlen;

	if( streq(fmt,"om") )
		msg = OREQ_MSG;
	else
	if( streq(fmt,"ol") )
		msg = OREQ;
	else	msg = "";

	for( mp = msg; *mp; mp = np ){
		lineScan(mp,line);
		if( strncasecmp(mp,"Proxy-Authorization:",fnlen=20)==0
		 || strncasecmp(mp,"Authorization:",      fnlen=14)==0 ){
			strcpy(line+fnlen," ******");
		}
		HTML_put1s(fp,"%s\r\n",line);
		if( np = strchr(mp,'\n') )
			np++;
		else	break;
	}
}
HTTP_editResponseHeader(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char *rhead,name[256],body[256];

	if( IsMounted && MountOptions ){
		if( rhead = strstr(MountOptions,"rhead=+") ){
			scan_namebody(rhead+7,name,sizeof(name),":",body,sizeof(body),",");
			fprintf(tc,"%s: %s\r\n",name,body);
		}
	}
}
decomp_http_status(stat,resx)
	char *stat;
	HttpResponse *resx;
{	char *sp;
	int rcode;

	resx->hr_ver[0] = 0;
	resx->hr_reason[0] = 0;

	if( !STRH(stat,F_HTTPVER) ){
		rcode = 1200;
	}else{
		sp = wordScan(stat,resx->hr_ver);
		if( *sp == ' ' ) sp++;
		if( sp = scanint(sp,&rcode) ){
			lineScan(sp,resx->hr_reason);
			if( rcode <= 0 )
				rcode = R_BROKEN_RESPONSE;
		}else{
			sv1log("ERROR: BROKEN STATUS LINE: %s",stat);
			rcode = R_BROKEN_RESPONSE;
		}
	}
EXIT:
	resx->hr_rcode = rcode;
	return rcode;
}

char *HTTP_outCharset(Conn)
	Connection *Conn;
{	char *xcharset;

	xcharset = 0;
	if( CCXactive(CCX_TOCL) )
		xcharset = CCXcharset(CCX_TOCL);
	else	CTX_codeconv_get(Conn,NULL,&xcharset,NULL);
	return xcharset;
}

/* The following stuff is for Mozillas older than 3.0.
 * Either flushHead or Keep-Alive:close is necessary to let their Keep-Alive
 * work properly.
 * - Keep-Alive:close is preferable because their performance by Keep-Alive
 *   with flushHead isn't so good.
 * - But flushHead is preferable when RTT is long...
 */
HTTP_modifyConnection(Conn,rlength)
	Connection *Conn;
{
	if( FlushIfSmall )
	if( rlength < 1024 )
		HTTP_clntClose(Conn,"o:old Mozilla");

	if( WillKeepAlive )
	if( Conn->xf_filters & (XF_FCL|XF_FTOCL) )
		HTTP_clntClose(Conn,"x:external filter");
}
