/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	httpd.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941009	extracted from http.c
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "ystring.h"
#include "http.h"
extern char *CTX_mount_url_fromL();

#define ME_7bit		((char*)0)
#define ME_binary	"binary"

static char *home_page = "/-/";
static char *admin_base = "/-/admin/";
static char *cgi_base = "/-/cgi/";
static char *icon_base = "/-/builtin/icons/";
static char *mssg_base = "/-/builtin/mssgs/";
static char *conf_base = "/-/builtin/config/";
static char *dproxy_base = "/-/nonCERNproxy";
static char *bench_base = "/-/bench/";
static char *data_base = "/-/data:";
#define icon_relative	(icon_base+3)
#define FPRINTF		leng += Fprintf

extern int DHTML_printConn();
#define printConn	DHTML_printConn

extern int ClientIfModClock();	/* -1 if not specified */
extern FILE *openHttpResponseFilter();
extern char *HTTP_getRequestField();
extern FILE *TMPFILE();
extern char *HTTP_originalRequest();

localPathProto(proto)
	char *proto;
{
	if( streq(proto,"file") ) return 1;
	if( streq(proto,"proc") ) return 1;
	if( streq(proto,"cgi" ) ) return 1;
	if( streq(proto,"cfi" ) ) return 1;
	return 0;
}
isURN(urn)
	char *urn;
{
	if( strncmp(urn,"news:",  5) == 0 && urn[5] != '/' ) return 4;
	if( strncmp(urn,"mailto:",7) == 0 && urn[7] != '/' ) return 6;
	return 0;
}

static toMyself(Conn)
	Connection *Conn;
{
	if( localPathProto(DST_PROTO) )
		if( strcmp(DST_HOST,"localhost") == 0 )
			return 1;
	return 0;
}

char *HTTP_getIconBase(Conn)
	Connection *Conn;
{	char base[1024];

	HTTP_baseURLrelative(Conn,icon_base,base);
	wordScan(base,iconBase);
	return iconBase;
}
static putFrogInline(Conn,tc,align,trans,body)
	Connection *Conn;
	FILE *tc;
	char *align;
{	char *icon;
	char iurl[1024];

	if( body )
		if( trans )
			icon = "ysato/frogTrans.gif";
		else	icon = "ysato/frog.gif";
	else	icon = "ysato/frogHead.gif";

	sprintf(iurl,"%s%s",HTTP_getIconBase(Conn),icon);
	return Fprintf(tc,"<IMG ALT=\"@_@\" ALIGN=%s BORDER=0 SRC=%s>",
		align,iurl);
}
putDeleGateInline(Conn,tc,align)
	Connection *Conn;
	FILE *tc;
	char *align;
{
	return Fprintf(tc,"<IMG ALT=\"@_@\" ALIGN=%s SRC=%s%s>",
		align,HTTP_getIconBase(Conn),"ysato/DeleGateLogoTrans.gif");
}

char *getCERNiconBase(Conn,base)
	Connection *Conn;
	char *base;
{
	sprintf(base,"%s%s",HTTP_getIconBase(Conn),"cern/");
	return base;
}

static flushLinger(tc)
	FILE *tc;
{
	fflush(tc);
	set_linger(fileno(tc),DELEGATE_LINGER);
}

static putIcon(Conn,tc,vno,icon)
	Connection *Conn;
	FILE *tc;
	char *icon;
{	char *data,*getIcon(),*ctype;
	int size;
	int leng = 0;

	if( (data = getIcon(icon,&size)) == 0 )
		return 0;

	if( strstr(icon,".xbm") != 0 )
		ctype = "image/x-xbitmap";
	else	ctype = "image/gif";
	leng += HTTP_putHeader(Conn,tc,vno,ctype,size,0);
	leng += fwrite(data,1,size,tc);
	flushLinger(tc);
	return leng;
}
static put1(name,data,size,buf,iconhp)
	char *name,*data;
	char *buf;
	char *iconhp;
{	char path[256],file[1024];

	sprintf(path,"%s%s",home_page,name);
	sprintf(file,"<IMG SRC=%s%s> <A HREF=%s%s>%s</A> (%d bytes)<BR>\n",
		iconhp,path, iconhp,path, name,size);
	strcat(buf,file);
}
static putIconList(Conn,tc,vno,iconhp)
	Connection *Conn;
	FILE *tc;
	char *iconhp;
{	char buf[0x10000];
	int leng = 0;

	buf[0] = 0;
	leng += HTTP_putHeader(Conn,tc,vno,"text/html",0,0);
	FPRINTF(tc,"<TITLE> Built-in images </TITLE>");
	FPRINTF(tc,"<H1> Images built into the DeleGate </H1>");
	FPRINTF(tc,"<MENU>\n");
		scanIcons(icon_relative,put1,buf,iconhp);
	fputs(buf,tc);
	leng += strlen(buf);
	FPRINTF(tc,"</MENU>\n");
	flushLinger(tc);
	return leng;
}

/*
FPRINTF(tc,"<LI> Display response header <ISINDEX>\n");
*/

static putUnknownPage(Conn,tc,vno,req)
	Connection *Conn;
	FILE *tc;
	char *req;
{	int hleng,cleng;
	FILE *tmp;
	char mssg[0x10000];

	delayUnknown(Conn,1,req);

	tmp = TMPFILE("NotFound");
	putBuiltinHTML(Conn,tmp,"NotFound","404-notfound.dhtml","",NULL);
	putFrogVer(Conn,tmp);
	fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);
	if( 0 < (cleng = fread(mssg,1,sizeof(mssg)-1,tmp)) )
		mssg[cleng] = 0;
	else	mssg[0] = 0;
	fclose(tmp);

	hleng = putHttpNotFound(Conn,tc,mssg);
	flushLinger(tc);
	return hleng + cleng;
}
putUnknownMsg(Conn,tc,req)
	Connection *Conn;
	FILE *tc;
	char *req;
{	int vno;
	HttpRequest reqx;
	vno = decomp_http_request(req,&reqx);
	return putUnknownPage(Conn,tc,vno,req);
}
static putBench(Conn,tc,vno,what)
	Connection *Conn;
	FILE *tc;
	char *what;
{	int leng,bi;

	leng = atoi(what);
	HTTP_putHeader(Conn,tc,vno,"text/plain",leng,-1);
	for( bi = 0; bi < leng-2; bi++ )
		putc('*',tc);
	fputs("\r\n",tc);
	return leng;
}

#define	cbuf	databuf[cbi%2]
HTTP_putData(Conn,tc,vno,dataspec)
	Connection *Conn;
	FILE *tc;
	char *dataspec;
{	char *dp,*data,ctype[64],encode[64],databuf[2][0x8000];
	int cbi,leng;

	ctype[0] = encode[0] = 0;
	data = "";
	leng = 0;

	dp = strpbrk(dataspec,";,");
	if( dp == NULL || 64 <= (dp - dataspec) )
		goto EXIT;

	scan_namebody(dataspec,ctype,sizeof(ctype),";",encode,sizeof(encode),",");
	if( data = strchr(dataspec,',') ){
		cbi = 0;
		Strncpy(cbuf,data+1,sizeof(cbuf));
		leng = strlen(cbuf);
		data = cbuf;

		if( strchr(data,'%') ){
			cbi++;
			nonxalpha_unescape(data,cbuf,1);
			leng = strlen(cbuf);
			data = cbuf;
		}
		if( strcasecmp(encode,"base64") == 0 ){
			cbi++;
			leng = str_from64(data,leng,cbuf,sizeof(cbuf));
			data = cbuf;
		}
	}
EXIT:
	if( vno != 0 )
		HTTP_putHeader(Conn,tc,vno,*ctype?ctype:"text/plain",leng,-1);
	if( data )
		fwrite(data,1,leng,tc);
	return leng;
}

#define ISMYSELF(Conn) \
	(!Conn->co_nointernal && Ismyself(Conn,DST_PROTO,DST_HOST,DST_PORT))

HttpToMyself(Conn,req,head,fc,tc,stcodep)
	Connection *Conn;
	char *req,*head;
	FILE *fc,*tc;
	int *stcodep;
{	char *method,*path;
	int vno;
	HttpRequest reqx;
	int nlen;
	int leng = 0;
	int ismyself;
	int blen;

	ismyself = ISMYSELF(Conn);
	if( ismyself )
		setToInternal();

	sv1log("checking delegate-internal: self=%d %s",ismyself,req);
	if( (vno = decomp_http_request(req,&reqx)) == 0 )
		return 0;
	method = reqx.hq_method;
	path = reqx.hq_url;

	if( ismyself ){
		char upath[URLSZ];

		if( streq(path,"/") ){
			if( do_RELAY(Conn,RELAY_DELEGATE) )
				return putMovedTo(Conn,tc,dproxy_base);
			else	return putMovedTo(Conn,tc,home_page);
		}
		if( strncmp(path,dproxy_base,nlen=strlen(dproxy_base)) == 0 
		 || strncmp(path,"/",nlen=strlen("/")) == 0 )
		if( path[nlen] == '?' ){
			char durl[URLSZ],myhost[128];
			int myport;

			nlen++;
			nonxalpha_unescape(path+nlen,upath,0);
			if( DONT_REWRITE ){
				return putMovedTo(Conn,tc,upath);
			}else{
				myport = ClientIF_H(Conn,myhost);
				CTX_url_rurl(Conn,upath,durl,CLNT_PROTO,myhost,myport,"",1);
				return putMovedTo(Conn,tc,durl);
			}
		}
		/* hard mount from dproxy_base to nonCERNproxy ... */
		if( strncmp(path,dproxy_base,nlen=strlen(dproxy_base)) == 0 ){
			strcpy(upath,path);
			strcpy(path,"/-/builtin/mssgs/nonCERNproxy.dhtml");
			strcat(path,upath+nlen);
		}
	}

	if( strncmp(path,data_base,strlen(data_base)) == 0 )
	{
		/*
		return HTTP_putData(Conn,tc,vno,path+strlen(data_base));
		*/
		leng = HTTP_putData(Conn,tc,vno,path+strlen(data_base));
		if( 0 < leng )
			return leng;
		goto UNKNOWN;
	}

	if( streq(path,home_page) ){
		if( DONT_REWRITE ){
			leng = DHTML_putDeleGatePage(Conn,req,tc,vno);
			flushLinger(tc);
		}else{
			FILE *tcx;
			IsMounted = 1; /* IMG URL may be rewriten, so invoke
					* Content-Length correction in the
					* ResponseFilter process
					*/
			tcx = openHttpResponseFilter(Conn,tc);
			leng = DHTML_putDeleGatePage(Conn,req,tcx,vno);
			flushLinger(tcx);
			fclose(tcx);
			wait(0);
		}
		return leng;
	}
	blen = 0;
	if( strncmp(path,admin_base,blen=strlen(admin_base)) == 0
	 || strstr(path,"?-_-") ){
		leng = DHTML_putControl(Conn,req,fc,tc,vno,path+blen,stcodep);
		flushLinger(tc);
		return leng;
	}

	nlen = strlen(mssg_base);
	if( strncmp(path,mssg_base,nlen) == 0 ){
		leng = putBuiltinMssg(Conn,tc,path+nlen);
		if( leng == 0 ){
			/*
			*stcodep = 404;
			return putUnknownPage(Conn,tc,vno,req);
			*/
			goto UNKNOWN;
		}
		return leng;
	}

	nlen = strlen(conf_base);
	if( strncmp(path,conf_base,nlen) == 0 )
	if( strtailstr(path,".ico") )
/* as config data can include non-public info,it should be admin only.  */
	{
		leng = putBuiltinConfig(Conn,tc,vno,path+nlen);
		if( leng == 0 ){
			/*
			*stcodep = 404;
			return putUnknownPage(Conn,tc,vno,req);
			*/
			goto UNKNOWN;
		}
		return leng;
	}

	nlen = strlen(icon_base);
	if( strncmp(path,icon_base,nlen) == 0 ){
		char icon[URLSZ];
		sprintf(icon,"%s%s",icon_relative,path+nlen);
		if( path[nlen] == 0 ){
			char base[1024];
			HTTP_baseURLrelative(Conn,"",base);
			leng = putIconList(Conn,tc,vno,base);
		}else	leng = putIcon(Conn,tc,vno,icon);

		if( 0 < leng ){
			IsInternal = 1;
			return leng;
		}
		if( ismyself ){
			goto UNKNOWN;
		}
	}else{
		if( strncmp(path,bench_base,strlen(bench_base)) == 0 ){
			return putBench(Conn,tc,vno,path+strlen(bench_base));
		}
		if( ismyself ){
			if( leng = putRobotsTxt(Conn,tc,NULL,0) )
				return leng;
			sv1log("ERROR: Unknown internal: %s",req);
			/*
			*stcodep = 404;
			return putUnknownPage(Conn,tc,vno,req);
			*/
			goto UNKNOWN;
		}
	}
	/* it could be inline images in the customized Forbidden message */
	{	char opath[URLSZ];
		HTTP_originalURLPath(Conn,opath);
		if( strncmp(opath,icon_base,nlen) == 0 )
		{
			Conn->from_myself = 1;
		}
	}

	if( leng = putLocal(Conn,vno,method,req,head,path,fc,tc,stcodep) )
	{
		httpStat = CS_LOCAL;
		return leng;
	}
	if( ismyself ){
		goto UNKNOWN;
	}

	/* V8.0.1 RELAY=novhost by default */
	if( IsVhost && do_RELAY(Conn,RELAY_VHOST) ){
		sv1log("forwarding by RELAY=vhost [%s:%d]\n",DST_HOST,DST_PORT);

	return 0;
	}

UNKNOWN:
	sv1log("Unknown internal: [%s:%d] %s\n",DST_HOST,DST_PORT,path);
	*stcodep = 404;
	return putUnknownPage(Conn,tc,vno,req);
}

static putDeleGateAnchor(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char url[1024];

	HTTP_baseURLrelative(Conn,home_page,url);
	return Fprintf(tc,"<A HREF=%s>",url);
}

static putBuiltinConfig(Conn,tc,vno,path)
	Connection *Conn;
	FILE *tc;
	char *path;
{	int leng,cleng;
	char url[URLSZ],rurl[URLSZ],buf[0x4000];
	FILE *tmp;
	char *ctype;
	int ci,isbin;

	sprintf(url,"/-/builtin/config/%s",path);
	leng = getBuiltinData(Conn,"BuiltinData",url,buf,sizeof(buf),rurl);
	if( leng <= 0 )
		return 0;
	tmp = TMPFILE("BuiltinData");
	fwrite(buf,1,leng,tmp);
	fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);

	isbin = 0;
	for( ci = 0; ci < leng; ci++ ){
		if( buf[ci] == 0 ){
			isbin = 1;
			break;
		}
	}
	if( isbin )
		ctype = "application/octet-stream";
	else	ctype = "text/plain";
	putHttpHeader1X(Conn,tc,vno,NULL,ctype,ME_7bit,cleng,-1,0,NULL);
	if( RespWithBody ) copyfile1(tmp,tc);
	fclose(tmp);
	return cleng;
}
static putBuiltinMssg(Conn,tc,path)
	Connection *Conn;
	FILE *tc;
	char *path;
{	FILE *tmp;
	int leng,cleng;

	tmp = TMPFILE("Builtin");
	leng = putBuiltinHTML(Conn,tmp,"builtin-mssg",path,NULL,printConn,NULL);
	if( leng <= 0 ){
		fclose(tmp);
		return 0;
	}
	fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);
	putHttpHeader1(Conn,tc,NULL,"text/html",ME_7bit,cleng,0);
	if( RespWithBody ) copyfile1(tmp,tc);
	fclose(tmp);
	return cleng;
}
putChangeProxy(Conn,tc,url,proxy)
	Connection *Conn;
	FILE *tc;
	char *url,*proxy;
{	int leng,cleng;
	FILE *tmp;

	tmp = TMPFILE("ChangeProxy");
	putBuiltinHTML(Conn,tmp,"UseProxy-message",
		"305-useproxy.dhtml",NULL,printConn,NULL);
	putFrogVer(Conn,tmp);
	fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);

	leng = genHEADX(Conn,tc,305,"Use Proxy",cleng);
	if( *proxy == 0 || strcasecmp(proxy,"direct") == 0 ){
		FPRINTF(tc,"Set-Proxy: DIRECT\r\n",url);
	}else{
		FPRINTF(tc,"Set-Proxy: SET; proxyURI=\"%s\"\r\n",proxy);
		FPRINTF(tc,"Location: %s\r\n",proxy);
	}
	FPRINTF(tc,"\r\n");
	if( RespWithBody ) copyfile1(tmp,tc);
	fclose(tmp);
	flushLinger(tc);
	return cleng;
}
putMovedTo(Conn,tc,url)
	Connection *Conn;
	FILE *tc;
	char *url;
{
	return putMovedToX(Conn,tc,302,url);
}
putMovedToX(Conn,tc,code,url)
	Connection *Conn;
	FILE *tc;
	char *url;
{	int leng,cleng;
	char *dp;
	char myhp[256],fullurl[URLSZ];
	FILE *tmp;

	if( url[0] == '/' ){
		char *proto;
		if( proto = Conn->my_vbase.u_proto ){
			HTTP_ClientIF_HP(Conn,myhp);
			sprintf(fullurl,"%s://%s%s",proto,myhp,url);
		}else{
		HTTP_ClientIF_HP(Conn,myhp);
		sprintf(fullurl,"%s://%s%s",CLNT_PROTO,myhp,url);
		}
		url = fullurl;
	}
	if( !URL_toMyself(Conn,url) ){
		HTTP_clntClose(Conn,"m:moved to another server");
		sv1log("Moved to another server [%s]\n",url);
	}

	tmp = TMPFILE("MovedTo");
	putBuiltinHTML(Conn,tmp,"Moved-message",
		"302-moved.dhtml",NULL,printConn,url);
	putFrogVer(Conn,tmp);
	fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);

	leng = genHEADX(Conn,tc,code,"Moved",cleng);
	if( getenv("DG_useURI") ){
		if( strncmp(url,"http://",7) == 0 )
			if( dp = strchr(url+7,'/') )
				url = dp;
		FPRINTF(tc,"URI: <%s>\r\n",url);
		sv1log("####### URI: <%s>\r\n",url);
	}else{
		FPRINTF(tc,"Location: %s\r\n",url);
		sv1log("####### Location: %s\r\n",url);
	}
	FPRINTF(tc,"\r\n");

	if( RespWithBody ) copyfile1(tmp,tc);
	fclose(tmp);
	flushLinger(tc);
	return cleng;
}
putHttpNotModified(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	int leng;

	leng = genHEADX(Conn,tc,304,"Not modified",0);
	FPRINTF(tc,"\r\n");
	return leng;
}
putHttpNotFound(Conn,tc,mssg)
	Connection *Conn;
	FILE *tc;
	char *mssg;
{	int leng,cleng;

	cleng = strlen(mssg);
	leng = genHEADX(Conn,tc,404,"Not found",cleng);
	fputs("\r\n",tc);
	if( RespWithBody ) fputs(mssg,tc);
	return cleng;
}
putHttpNotAvailable(Conn,tc,mssg)
	Connection *Conn;
	FILE *tc;
	char *mssg;
{	int leng = 0;

	leng = genHEADX(Conn,tc,503,"Service Unavailable",0);
	FPRINTF(tc,"\r\n");
	return leng;
}
putNotAuthorized(Conn,tc,req,proxy,realm,mssg)
	Connection *Conn;
	FILE *tc;
	char *req,*realm,*mssg;
{	int leng,cleng;
	HttpRequest reqx;
	char xrealm[1024];
	char *mid,*desc;
	FILE *tmp;
	int code;
	char *fname,*reason;

	if( proxy ){
		code = 407;
		mid = "407-unauthproxy.dhtml";
		reason = "Proxy Authentication Required";
		fname = "Proxy-Authenticate";

		/* for CONNECT with Keep-Alive by MSIE */
		if( strstr(REQ_UA,"MSIE ") )
		HTTP_clntClose(Conn,"a:proxy authentication required");
	}else{
		code = 401;
		mid = "401-unauth.dhtml";
		reason = "Unauthorized";
		fname = "WWW-Authenticate";
	}
	Conn->from_myself = 1;
	tmp = TMPFILE("NotAuthorized");
	putBuiltinHTML(Conn,tmp,"NotAuth",mid,NULL,printConn,NULL);
	fputs(mssg,tmp);
	fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);

	if( realm == NULL ){
		decomp_http_request(req,&reqx);
		sprintf(xrealm,"<%s>",reqx.hq_url);
		realm = xrealm;
	}
	Verbose("REALM: %s\n",realm);
	leng = genHEADX(Conn,tc,code,reason,cleng);
	FPRINTF(tc,"%s: Basic Realm=%s\r\n",fname,realm);
	FPRINTF(tc,"\r\n");

	if( RespWithBody ) copyfile1(tmp,tc);
	fclose(tmp);
	Conn->statcode = code;
	return leng + cleng;
}

putFrogVer(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	int leng = 0;

	FPRINTF(tc,"<HR>\n");
	FPRINTF(tc,"<ADDRESS> Proxy HTTP Server %s \n", DELEGATE_Ver());
	leng += putFrogForDeleGate(Conn,tc,"");
	FPRINTF(tc,"</ADDRESS>\n");
	return leng;
}

putHttpRejectmsg(Conn,tc,proto,server,iport,req)
	Connection *Conn;
	FILE *tc;
	char *proto,*server,*req;
{	int leng,cleng;
	int mleng;
	char *mid;
	FILE *tmp;

	HTTP_originalRequest(Conn,req);
	mid = "403-forbidden.dhtml";
	tmp = TMPFILE("Forbidden");
	Conn->from_myself = 1;
	putBuiltinHTML(Conn,tmp,"Forbidden-Message",mid,"",NULL);
	putFrogVer(Conn,tmp);
	fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);

	leng = 0;
	if( HTTP_reqIsHTTP(Conn,req) ){
		leng = genHEADX(Conn,tc,403,"Forbidden",cleng);
		FPRINTF(tc,"\r\n");
	}
	if( RespWithBody ) copyfile1(tmp,tc);
	fclose(tmp);
	flushLinger(tc);

	Conn->statcode = 403;
	return leng + cleng;
}

putHttpCantConnmsg(Conn,tc,proto,server,iport,req)
	Connection *Conn;
	FILE *tc;
	char *proto,*server,*req;
{	int leng,cleng;
	char *mid,desc[1024];
	FILE *tmp;

	tmp = TMPFILE("CantConn");
	if( Conn->co_nonet ){
		mid = "502-offline.dhtml";
		sprintf(desc,"<B>Not in Cache</B>");
	}else{
		mid = "502-cantconnect.dhtml";
		sprintf(desc,"<B>Cannot Connect</B>");
	}
	putBuiltinHTML(Conn,tmp,"CantConn-Message",mid,desc,printConn,NULL);
	putFrogVer(Conn,tmp);
	fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);

	leng = 0;
	if( HTTP_reqIsHTTP(Conn,req) ){
		leng = genHEADX(Conn,tc,502,"Cannot Connect",cleng);
		FPRINTF(tc,"\r\n");
	}
	if( RespWithBody ) copyfile1(tmp,tc);
	fclose(tmp);
	flushLinger(tc);
	return leng;
}

httpfinger(Conn,sv,server,iport,path,vno)
	Connection *Conn;
	char *server,*path;
{	FILE *ts,*fs,*tc;
	char resp[1024];
	int lines;
	int leng = 0;

	if( sv == -1 )
		return;
	ts = fdopen(dup(sv),"w");
	fs = fdopen(dup(sv),"r");
	tc = fdopen(dup(ToC),"w");

	if( *path == '/' )
		path++;
	if( *path == '?' )
		path++;

	fprintf(ts,"%s\r\n",path);
	fflush(ts);

	leng += HTTP_putHeader(Conn,tc,vno,"text/html",0,-1);
	FPRINTF(tc,"<TITLE> Finger on %s </TITLE>\n",server);
	FPRINTF(tc,"<H1> Finger on %s </H1>\n",server);
	FPRINTF(tc,"<ISINDEX>\n");
	FPRINTF(tc,"<PRE>\n");

	lines = 0;
	while( fgets(resp,sizeof(resp),fs) != NULL ){
		fputs(resp,tc);
		leng += strlen(resp);
		lines++;
	}
	FPRINTF(tc,"</PRE>\n");
	FPRINTF(tc,"<HR>\n");
	leng += putFrogForDeleGate(Conn,tc,"[%d lines]\n",lines);

	flushLinger(tc);
	fclose(ts);
	fclose(fs);
	fclose(tc);
	return leng;
}

putFrogForDeleGate(Conn,dst,fmt,a,b,c,d,e,f,g,h,i,j)
	Connection *Conn;
	FILE *dst;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j;
{	int leng = 0;

	FPRINTF(dst,fmt,a,b,c,d,e,f,g,h,i,j);
	leng += putDeleGateAnchor(Conn,dst);
	leng += putFrogInline(Conn,dst,"BOTTOM",1,0);
	FPRINTF(dst,"V</A>\n");
	return leng;
}

extern char *file_hostpath();
extern char *filename2ctype();
extern char *filename2icon();

static off_limit(url,upath)
	char *url,*upath;
{	char *rpath,apath[URLSZ];

	if( rpath = strstr(url,"://") ){
		rpath += 3;
		if( rpath = strchr(rpath,'/') ) /* skip server part */
			rpath += 1;
	}else
	if( rpath = strstr(url,":/") )
		rpath += 2;

	if( rpath ){
		strcpy(apath,"-/-");
		while( *rpath == '/' )
			rpath++;
		chdir_cwd(apath,rpath,0);
		if( strncmp(apath,"-/-",3) != 0 )
			return 1; /* intruded off limit by ".." */

		/* should copy &apath[2] ? */
		strcpy(upath,rpath);
	}

	return 0;
}


/*
 * as a search script ?
 *
 *	/path/of/dir?ls-options
 *
 */
static char DIR_CGI[16] = "-dir.cgi";
static dir_CGI(Conn,path,upath,fp)
	Connection *Conn;
	char *path,*upath;
	FILE *fp;
{
}

static char DIR_HTML[16] = "-dir.html";

static char *http_search_script;
static char *tab_indexurls[16] = {
	"welcome.dgp",
	"welcome.shtml",
	"welcome.html",
	"welcome.cgi",
	"index.dgp",
	"index.shtml",
	"index.html",
	"index.cgi",
	DIR_HTML,
	NULL
};
#define indexurls tab_indexurls

extern double Scan_period();
char *HTTP_MAX_REQHEAD_sym = "max-reqhead";
char *HTTP_MAX_REQLINE_sym = "max-reqline";
char *HTTP_GW_MAX_REQLINE_sym = "max-gw-reqline";
int HTTP_ftpXferlog;
extern int HTTP_CKA_CFI;
char *HTTP_urlesc;
char *HTTP_passesc = "%%%C"; /* no default, escape control char. */
extern int HTTP_noXLocking;
extern char *HTTP_accEncoding;
extern char *HTTP_genEncoding;
extern int HTTP_MAX_BUFF_REQBODY;
extern int url_unify_ports;
int HTTP_opts;
static char *ProxyControlMARK;

static settout(what,value,conf)
	char *what,*value,*conf;
{	double secs;

	secs = Scan_period(value,'s',(double)0);
	if( streq(what,"tout-cka") )	    HTTP_TOUT_CKA = secs; else
	if( streq(what,"tout-ckamg") )	    HTTP_TOUT_CKA_MARGIN = secs; else
	if( streq(what,"tout-reqbody"))	    HTTP_TOUT_QBODY = secs; else
	if( streq(what,"tout-wait-badsv") ) HTTP_WAIT_BADSERV = secs; else
	if( streq(what,"tout-wait-reqbody"))HTTP_WAIT_REQBODY = secs; else
	if( streq(what,"tout-in-reqbody") ) HTTP_TOUT_IN_REQBODY = secs; else
	if( streq(what,"tout-buff-reqbody"))HTTP_TOUT_BUFF_REQBODY = secs; else
	if( streq(what,"tout-resp") )       HTTP_TOUT_RESPLINE = secs; else
	syslog_ERROR("ERROR: unknonw HTTPCONF=%s\n",conf);
}
static setmax(what,value,conf)
	char *what,*value,*conf;
{	int maxi;

	maxi = kmxatoi(value);
	if( streq(what,"max-hops") )	HTTP_MAXHOPS = maxi; else
	if( streq(what,"max-cka") )	HTTP_CKA_MAXREQ = maxi; else
	if( streq(what,"max-ckapch") )	HTTP_CKA_PERCLIENT = maxi; else
	if( streq(what,"max-buff-reqbody") ) HTTP_MAX_BUFF_REQBODY = maxi; else
	if( streq(what,HTTP_MAX_REQHEAD_sym) ) HTTP_MAX_REQHEAD = maxi; else
	if( streq(what,HTTP_MAX_REQLINE_sym) ) HTTP_MAX_REQLINE = maxi; else
	if( streq(what,HTTP_GW_MAX_REQLINE_sym) ) HTTP_GW_MAX_REQLINE = maxi;
	else
	syslog_ERROR("ERROR: unknown HTTPCONF=%s\n",conf);
}

typedef struct {
	int	 k_what;
	char	*k_pat;
	int	 k_len;
	int	 k_rem;
} KillPat;
static KillPat killpats[32];
static int killpatx;
static kill1(pat,what)
	char *pat;
{	KillPat *kp;
	char *dp;

	kp = &killpats[killpatx++];
	kp->k_what = what | (KH_IN|KH_OUT);
	kp->k_pat = stralloc(pat);
	nonxalpha_unescape(kp->k_pat,kp->k_pat,1);
/*
	if( dp = strchr(pat,'*') ){
*/
	if( dp = strchr(kp->k_pat,'*') ){
		*dp = 0;
		kp->k_rem = 1;
	}
	kp->k_len = strlen(kp->k_pat);
	return 0;
}
static addKill(pat,what)
	char *pat;
{
	scan_commaList(pat,0,kill1,what);
}
HTTP_head2kill(head,what)
	char *head;
{	int ki,killed;
	KillPat *kp;

	killed = 0;
	for( ki = 0; ki < killpatx; ki++ ){
		kp = &killpats[ki];
		if( (kp->k_what & what) == what )
		if( strncasecmp(head,kp->k_pat,kp->k_len) == 0 ){
			if( kp->k_rem || head[kp->k_len] == ':' ){
				killed++;
				break;
			}
		}
	}
	return killed;
}
HTTP_killhead(head,what)
	char *head;
{	int killed;
	char *hp,*np;

	killed = 0;
	if( 0 < killpatx ){
		for( hp = head; hp && *hp; hp = np ){
			if( np = strpbrk(hp,"\r\n") ){
				while( *np == '\r' )
					np++;
				if( *np == '\n' )
					np++;
			}
			if( HTTP_head2kill(hp,what) ){
				killed++;
				strcpy(hp,np);
				np = hp;
			}
		}
	}
	return killed;
}

typedef struct {
	int	 g_what; /* request or response */
	int	 g_how;	 /* append or replace */
	char	*g_fmt;
} GenFormat;
static GenFormat genFormat[32];
static int genFormatX;
static addGen(fspec,what,how)
	char *fspec;
{	char buf[256],*dp;
	GenFormat *gf;

	lineScan(fspec,buf);
	if( dp = strchr(buf,':') ){
		if( dp[1] != 0 && dp[1] != ' ' )
			Strins(&dp[1]," ");
	}
	strcat(buf,"\r\n");
	gf = &genFormat[genFormatX++];
	gf->g_what = what | (KH_IN|KH_OUT);
	gf->g_fmt = stralloc(buf);
}

static genhead1(Conn,head,field)
	Connection *Conn;
	char *head,*field;
{	char fmt[512],buf[4096],dc;

	dc = *field++;
	if( dc != ':' ) /* MOUNT="vURL rURL   add-[qr]head:x:y" */
	if( dc != '=' ) /* ProxyControl URL?_?add-[qr]head=x:y */
		return 0;

	if( dc == '=' )
		wordscanY(field,fmt,sizeof(fmt),"^,+"); /* necessary ? */
	else	wordscanY(field,fmt,sizeof(fmt),"^,");
	strfConn(Conn,fmt,buf);
	buf[512] = 0;
	if( strtailchr(buf) != '\n' )
		strcat(buf,"\r\n");
	RFC822_addHeaderField(head,buf);
	return 1;
}
static genheads(Conn,head,what,list)
	Connection *Conn;
	char *head,*list;
{	char *mo,*ot;
	int gen = 0;

	if( (what & KH_REQ) && (mo=strstr(list,ot="add-qhead")) )
		gen += genhead1(Conn,head,mo+strlen(ot));

	if( (what & KH_RES) && (mo=strstr(list,ot="add-rhead")) )
		gen += genhead1(Conn,head,mo+strlen(ot));

	if( mo = strstr(list,ot="add-head") )
		gen += genhead1(Conn,head,mo+strlen(ot));

	return gen;
}
HTTP_genhead(Conn,head,what)
	Connection *Conn;
	char *head;
{	int fi,gen;
	GenFormat *gf;
	char buf[4096];

	gen = 0;
	for( fi = 0; fi < genFormatX; fi++ ){
		gf = &genFormat[fi];
		if( (gf->g_what & what) == what ){
			strfConn(Conn,gf->g_fmt,buf);
			buf[512] = 0;
			RFC822_addHeaderField(head,buf);
			gen++;
		}
	}
	if( MountOptions && strstr(MountOptions,"add-") != 0 ){
		gen += genheads(Conn,head,what,MountOptions);
	}
	if( ProxyControls[0] && strstr(ProxyControls,"add-") != 0 ){
		gen += genheads(Conn,head,what,ProxyControls);
	}
	return gen;
}

static char pathExt[32];
setpathExt(ext)
	char *ext;
{
	xmem_push(pathExt,strlen(pathExt)+1,"pathExt",NULL);
	wordScan(ext,pathExt);
}

static setbugs(value)
	char *value;
{
	if( streq(value,"kill-contleng") )
		HTTP_opts |= HTTP_DELWRONGCONTLENG;
	else
	if( streq(value,"pass-contleng") )
		HTTP_opts &= ~HTTP_DELWRONGCONTLENG;
	else
	if( streq(value,"no-chunked") )
		HTTP_opts |= HTTP_NOCHUNKED;
	else
	if( streq(value,"less-chunked") )
		HTTP_opts |= HTTP_SUPPCHUNKED;
	else
	if( streq(value,"flush-chunk") )
		HTTP_opts |= HTTP_FLUSHCHUNK;
	else
	if( streq(value,"no-keepalive") )
		HTTP_opts |= HTTP_NOKEEPALIVE;
	else
	if( streq(value,"no-methodcheck") )
		HTTP_opts |= HTTP_NOMETHODCHECK;
	else
	if( streq(value,"no-gzip") )
		HTTP_opts |= HTTP_NOGZIP;

	return 0;
}

scan_HTTPCONF(Conn,conf)
	Connection *Conn;
	char *conf;
{	char what[128],value[2048];

	what[0] = value[0] = 0;
	sscanf(conf,"%[^:]:%s",what,value);
	if( strncmp(what,"tout-",5) == 0 ){
		settout(what,value,conf);
	}else
	if( strncasecmp(what,"max-",4) == 0 ){
		setmax(what,value,conf);
	}else
	if( strncasecmp(what,"kill-",5) == 0 ){
		strtolower(value,value);
		if( streq(what+5,"qhead") || streq(what+5,"head") ){
			if( isinList(value,"x-locking") )
				HTTP_noXLocking = 1;
		}
		if( streq(what+5,"qhead") ) addKill(value,KH_REQ); else
		if( streq(what+5,"rhead") ) addKill(value,KH_RES); else
		if( streq(what+5,"head")  ) addKill(value,KH_BOTH); else
		if( streq(what+5,"tag") ) setKillTags(value);
	}else
	if( strncasecmp(what,"add-",4) == 0 ){
		if( streq(what+4,"qhead") ) addGen(value,KH_REQ,0); else
		if( streq(what+4,"rhead") ) addGen(value,KH_RES,0); else
		if( streq(what+4,"head") ) addGen(value,KH_BOTH,0);
	}else
	if( strncasecmp(what,"acc-",4) == 0 ){
		if( streq(what+4,"encoding") ){
			HTTP_accEncoding = stralloc(value);
			if( strstr(value,"gzip") )
				check_gzip();
		}
	}else
	if( strncasecmp(what,"gen-",4) == 0 ){
		if( streq(what+4,"encoding") ){
			HTTP_genEncoding = stralloc(value);
			if( strstr(value,"gzip") )
				check_gzip();
		}
	}else
	if( streq(what,"cka-cfi") ){
		HTTP_CKA_CFI = 1;
	}else
	if( streq(what,"methods") ){
		HTTP_setMethods(value);
	}else
	if( streq(what,"rvers") ){
		HTTP_setRespVers(value);
	}else
	if( streq(what,"search") ){
		http_search_script = stralloc(value);
		sv1log("HTTP SearchScript=%s\n",value);
	}else
	if( streq(what,"welcome") ){
		int wc,wi;
		char *wv[16];

		wc = stoV(value,15,wv,',');
		for( wi = 0; wi < wc; wi++ ){
			Verbose("HTTP-Welcome[%d] %s\n",wi,wv[wi]);
			indexurls[wi] = stralloc(wv[wi]);
		}
		indexurls[wc] = NULL;
	}
	if( streq(what,"pathext") ){
		setpathExt(value);
	}
	else
	if( streq(what,"modwatch") || streq(what,"watchmod") ){
		HTTP_setModwatch(Conn,value);
	}
	else
	if( streq(what,"ver") ){
		if( strcmp(value,"1.0") == 0 )
		{
			HTTP11_toserver = 0;
			HTTP11_toclient = 0;
		}
	}
	else
	if( streq(what,"svver") ){
		if( strcmp(value,"1.0") == 0 )
			HTTP11_toserver = 0;
	}
	else
	if( streq(what,"clver") ){
		if( strcmp(value,"1.0") == 0 )
			HTTP11_toclient = 0;
		else
		if( strcmp(value,"0.9rej") == 0 )
			HTTP09_reject = 1;
	}
	else
	if( streq(what,"ignif") ){
		HTTP_ignoreIf = 1;
	}
	else
	if( streq(what,"applet") ){
		if( streq(value,"warn") )
			HTTP_warnApplet = 1;
	}
	else
	if( streq(what,"badhead") ){
		if( streq(value,"rej") )
			HTTP_rejectBadHeader = 1;
	}
	else
	if( streq(what,"urlesc") ){
		if( *value == 0 )
			strcpy(value,"<>");
		nonxalpha_unescape(value,value,1);
		Strins(value,"%%"); /* url is already encoded */
		HTTP_urlesc = stralloc(value);
	}
	else
	if( streq(what,"passesc") ){
		nonxalpha_unescape(value,value,1);
		Strins(value,"%%"); /* no default encoding */
		HTTP_passesc = stralloc(value);
	}
	else
	if( streq(what,"xferlog") ){
		if( streq(value,"ftp") )
			HTTP_ftpXferlog = 1;
	}
	else
	if( streq(what,"urlunifyports") ){
		url_unify_ports = 1;
	}
	else
	if( streq(what,"proxycontrol") ){
		if( *value==0 || strcaseeq(value,"on")||strcaseeq(value,"yes") )
			ProxyControlMARK = "?_?";
		else
		if( strcaseeq(value,"off") || strcaseeq(value,"no") )
			ProxyControlMARK = 0;
		else	ProxyControlMARK = stralloc(value);
	}
	else
	if( streq(what,"cache") ){
		if( streq(value,"any") ){
			HTTP_cacheopt = 0xFFFFFFFF;
		}
		if( isinList(value,"nolastmod") )
			HTTP_cacheopt |= CACHE_NOLASTMOD;
		if( isinList(value,"302") )
			HTTP_cacheopt |= CACHE_302;
	}
	else
	if( streq(what,"nomenu") ){
		extern int HTTP_putmenu;
		HTTP_putmenu = 0;
	}
	else
	if( streq(what,"bugs") ){
		scan_commaList(value,0,setbugs,Conn);
	}
}

/*
 * HTTPCONF="modwatch:notifyto,approver" equals to
 * HTTPCONF="modwatch:notifyto=${ADMIN},approver=*:.localnet"
 */
static modwatch1(spec,Conn)
	char *spec;
	Connection *Conn;
{	char name[64],val[64],map[256];

	name[0] = val[0] = 0;
	sscanf(spec,"%[^=]=%s",name,val);
	sv1log("HTTPCONF=modwatch:%s=%s\n",name,val);
	if( strcmp(name,"notifyto") == 0 ){
		modwatch_notify = stralloc(val);
		/* should verify the address here ... */
	}else
	if( strcmp(name,"approver") == 0 ){
		modwatch_approver = 1;
		if( val[0] == 0 )
			sprintf(map,"approve:*:%s","*:.localnet");
		else	sprintf(map,"approve:*:%s",val);
		scan_CMAP2(Conn,CMAP_APPROVER,map);
	}
	return 0;
}
HTTP_setModwatch(Conn,spec)
	Connection *Conn;
	char *spec;
{
	modwatch_enable = 1;
	scan_commaListL(spec,0,modwatch1,Conn);
}


#define S_DATA	1
#define S_EXECI	2
#define S_EXECX	4
#define S_EXEC	(S_EXECI|S_EXECX)

isExecutableURL(url)
	char *url;
{
	if( strtailchr(url) == '/' ) return 1;
	if( strchr(url,'?') ) return 2;
	if( strtailstr(url,".dgp") ) return 3;
	if( strtailstr(url,".cgi") ) return 4;
	if( strtailstr(url,".html") ) return 5;
	if( strtailstr(url,".shtml") ) return 6;
	return 0;
}

/*
 *  dir           -> dir-ext
 *  dir/          -> dir-ext/
 *  dir/path      -> dir/path-ext
 *  dir/path.type -> dir/path-ext.type
 */
char *getpathext(path,pathext,xpath,xsize)
	char *path,*pathext,*xpath;
{	char *dp,*xp,ext[256];
	int len,siz;

	if( pathext[0] ){
		xp = path + strlen(path);
		if( path < xp ){
			dp = xp - 1;
			if( *dp == '/' )
				xp = dp;
			else
			for(; path <= dp; dp-- ){
				if( *dp == '/' ){
					xp = dp + strlen(dp);
					break;
				}
				if( *dp == '.' ){
					xp = dp;
					break;
				}
			}
		}
		linescanX(pathext,ext,sizeof(ext));
		linescanX(xp,ext+strlen(ext),sizeof(ext)-strlen(ext));
		len = strlen(path) - strlen(xp);
		siz = xsize - strlen(ext);
		if( siz < len )
			len = siz;
		linescanX(path,xpath,len+1);
		strcat(xpath,ext);
		return xpath;
	}
	return 0;
}
FILE *extfopen(path,mode)
	char *path,*mode;
{	char xpath[URLSZ];
	FILE *fp;

	if( getpathext(path,pathExt,xpath,sizeof(xpath)) ){
		if( fp = fopen(xpath,mode) ){
			sv1log("pathExt[%s] %s\n",pathExt,xpath);
			return fp;
		}
	}
	return fopen(path,mode);
}

static FILE *openIndex(Conn,path,upath,ipath,what,mtimep)
	Connection *Conn;
	char *path,*upath,*ipath;
	int *mtimep;
{	FILE *fp;
	int ii;
	char *sp,sc,*ip,*file;

	*mtimep = -1;

	ip = ipath;
	if( path[0] ){
		for( sp = path; sc = *sp; sp++ )
			*ip++ = sc;
		if( ip[-1] != '/' )
			*ip++ = '/';
	}

	for( ii = 0; file = indexurls[ii]; ii++ ){
		if( streq(file,DIR_HTML) ){
			if( (what & S_EXECI) == 0 ) continue;
		}else
		if( strtailstr(file,".cgi")
		 || strtailstr(file,".dgp")
		 || strtailstr(file,".shtml")
		){
			if( (what & S_EXECX) == 0 ) continue;
		}else{
			if( (what & S_DATA) == 0 ) continue;
		}

		strcpy(ip,file);
		if( strcmp(file,DIR_HTML) == 0 ){
			fp = TMPFILE("ls2html");
			putDirPage(Conn,path,upath,fp);
			fflush(fp);
			fseek(fp,0,0);
			*mtimep = File_mtime(path);
			return fp;
		}else{
			/*
			if( fp = fopen(ipath,"r") )
			*/
			if( fp = extfopen(ipath,"r") )
				return fp;
		}
	}
	return NULL;
}

extern char *TIMEFORM_LS;
static putDir(Conn,dirpath,tmp,fp,eol)
	Connection *Conn;
	char *dirpath;
	FILE *tmp,*fp;
	char *eol;
{	char line[1024];
	char file[2048];
	char iconbase[1024],*iconsrc,*iconalt;
	char pfile[2048];
	char path[1024];
	int size,time,isdir;
	char atime[128];

	getCERNiconBase(Conn,iconbase);
	while( fgets(line,sizeof(line),tmp) != NULL ){
		lineScan(line,file);
		strcpy(pfile,file);
		if( file[0] == '.' && file[1] != '.' )
			continue;

		strcpy(path,dirpath);
		if( strtailchr(path) != '/' )
			strcat(path,"/");
		strcat(path,file);
		File_stat(path,&size,&time,&isdir);
		StrftimeLocal(atime,sizeof(atime),TIMEFORM_LS,time);
		fprintf(fp,"%8d %s ",size,atime);

		if( strcmp(file,"..") == 0 ){
			sprintf(pfile,"<IMG ALIGN=TOP SRC=%s%s>",
				iconbase,"back.gif");
		}else
		if( isdir )
			strcat(file,"/");
		iconsrc = filename2icon(file,&iconalt);
		fprintf(fp,"<IMG ALT=\"[%s]\" ALIGN=TOP SRC=\"%s%s\">",
			iconalt,iconbase,iconsrc);

		nonxalpha_escapeX(file,file,sizeof(file));
		fprintf(fp," <A HREF=\"%s\"><B>%s</B></A>%s",
			file,pfile,eol);
	}
}
static putDirPage(Conn,path,upath,fp)
	Connection *Conn;
	char *path,*upath;
	FILE *fp;
{	FILE *tmp;

	tmp = TMPFILE("dir2ls");
	dir2ls(path,NULL,NULL,"%N",tmp);
	fflush(tmp);
	fseek(tmp,0,0);

	fprintf(fp,"<TITLE> Index of /%s </TITLE>\n",upath);
	fprintf(fp,"<B>/%s</B>\n",upath);
	fprintf(fp,"<PRE>\n",path);

	putDir(Conn,path,tmp,fp,"\r\n");

	fclose(tmp);
	fprintf(fp,"<HR>\n",path);
	fprintf(fp,"</PRE>\n",path);
}

service_cgi(Conn)
	Connection *Conn;
{
}
service_cfi(Conn)
	Connection *Conn;
{
}

static strip_extrapath(Conn,method,surl,durl,dupath,extrapath)
	Connection *Conn;
	char *method,*surl,*durl,*dupath,*extrapath;
{	char durlbuf[URLSZ],search[URLSZ];
	char surlb[URLSZ],durlb[URLSZ],*dp;
	int script_namlen;

	dp = strrchr(surl,'/');
	if( dp == 0 || dp == surl )
		return 0;

	if( durl == NULL )
		durl = durlbuf;

	strcpy(surlb,surl);
	if( dp = strchr(surlb,'?') ){
		strcpy(search,dp);
		*dp = 0;
	}else	search[0] = 0;

	strcpy(durlb,surlb);
	if( CTX_mount_url_to(Conn,NULL,method,durlb) == 0 )
		return 0;
	strcpy(durl,durlb);

	for(;;){
		if( dp = strrchr(surlb,'/') )
			*dp = 0;
		else	break;

		strcpy(durlb,surlb);
		if( CTX_mount_url_to(Conn,NULL,method,durlb)==0 || strstr(durl,durlb)==0 ){
			*dp = '/';
			break;
		}
		strcpy(durl,durlb);
	}
	if( script_namlen = strlen(surlb) ){
		strcpy(extrapath,surl+script_namlen);
		if( dp = strchr(extrapath,'?') )
			*dp = 0;
		decomp_absurl(durl,NULL,NULL,dupath,1024);
		sv1log("### stripped CGI extra PATH [%s]=[/%s%s]+[%s]\n",
			surl,dupath,search,extrapath);
		strcpy(surl+script_namlen,search);
		strcat(durl,search);
		return 1;
	}
	return 0;
}

/*
 * check if the given path is a file-path which is in MOUNT
 */
static on_limit(Conn,path)
	Connection *Conn;
	char *path;
{	char *mok,vurl[URLSZ];

	mok = CTX_mount_url_fromL(Conn,vurl,"file","localhost",
		path[0]=='/'?path+1:path,
		NULL,"http","-");
	return mok != NULL;
}

/*
 * Test if the path name is composed of "/SCRIPT_NAME/PATH_INFO" where
 * /SCRIPT_NAME is a name of CGI script, including the case where there are
 * hidden CGIs as "/SCRIPT_NAME/{welcome,index}.{shtml,cgi}"
 */
static FILE *searchExecUpward(Conn,script,upath,expath,pathp,ctypep,iexecpath,mtimep)
	Connection *Conn;
	char *script;
	char *upath;
	char *expath;
	char **pathp;
	char **ctypep;
	char *iexecpath;
	int *mtimep;
{	char ipath[URLSZ],*dp;
	FILE *fp;
	int isdir;
	char *xp;

	fp = NULL;
	strcpy(ipath,*pathp);
	while( dp = strrchr(ipath,'/') ){
		dp[1] = 0;
		isdir = fileIsdir(ipath);

		if( !on_limit(Conn,ipath) )
			break;

		if( isdir )
		if( fp = openIndex(Conn,ipath,upath,iexecpath,S_EXECX,mtimep) ){
			strcpy(expath,*pathp+(dp-ipath));
			if( xp = strtailstr(script,expath) )
				*xp = 0;
			*pathp = iexecpath;
			*ctypep = filename2ctype(iexecpath);
			break;
		}
		dp[0] = 0;

		if( !isdir )
		/*
		if( fp = fopen(ipath,"r") )
		*/
		if( fp = extfopen(ipath,"r") )
		/* and if it is a DGP, SSI or CGI script file ... */
		{
			strcpy(expath,*pathp+(dp-ipath));
			if( xp = strtailstr(script,expath) )
				*xp = 0;
			strcpy(iexecpath,ipath);
			*pathp = iexecpath;
			*ctypep = filename2ctype(iexecpath);
			break;
		}
	}
	return fp;
}
deltailslash(fpath)
	char *fpath;
{	char *tp;

	for( tp = fpath+strlen(fpath)-1; fpath < tp; ){
		if( *tp == '/' )
			*tp-- = 0;
		else	break;
	}
}
deldupslash(path)
	char *path;
{	char *sp,*dp;
	int inpath;

	inpath = 1;
	for( sp = dp = path; *sp; sp++ ){
		if( inpath && sp[0] == '/' && sp[1] == '/' ){
			/* ignore redundant slash */
		}else{
			if( *sp == '?' )
				inpath = 0;
			if( sp == dp )
				dp++;
			else	*dp++ = *sp;
		}
	}
	if( sp != dp ){
		*dp = 0;
		return sp - dp;
	}else	return 0;
}

putLocal(Conn,vno,method,req,head,url,fc,tc,stcodep)
	Connection *Conn;
	char *method,*req,*head,*url;
	FILE *fc,*tc;
	int *stcodep;
{	FILE *fp;
	char *ctype = NULL;
	char *encoding = ME_7bit;
	int size = 0;
	int lastmod = 0;
	int mtime = -1;
	int expire = 0;
	char server[256];
	int leng;
	int notMod = 0;
	int CGIonly = 0;
	char *mok;
	char *myproto,dstproto[256],hostport[256];
	char proto[1024],host[256],*pp,vurl[URLSZ];
	char *path,upath[URLSZ],ourl[URLSZ],apath[URLSZ],dpath[URLSZ];
	char *execpath,*datapath; /* path of script.exe and data.html */
	char iexecpath[URLSZ],idatapath[URLSZ]; /* index.html extended */
	char *search,*Search,search_script[URLSZ];
	char script[URLSZ],expath[URLSZ],nupath[URLSZ];
	char texurl[URLSZ],texpath[URLSZ]; /* translated expath */

	HTTP_originalURLPath(Conn,ourl);
	expath[0] = 0;

	Search = http_search_script;
	if( MountOptions ){
		char *dp;
		if( dp = strcasestr(MountOptions,"search:") ){
			search_script[0] = 0;
			sscanf(dp+7,"%[^, ]",search_script);
			if( search_script[0] && strcmp(search_script,"-") != 0 )
				Search = search_script;
			else	Search = NULL;
		}
	}

	if( strcasecmp(DST_PROTO,"cgi") == 0){
		CGIonly = 1;
		if( strip_extrapath(Conn,REQ_METHOD,ourl,NULL,nupath,expath) )
			url = nupath;
	}
	lineScan(ourl,script);
	if( search = strchr(script,'?') )
		*search = 0;

	if( streq(method,"POST") || streq(method,"PUT") ){
		CGIonly = 1;
		lineScan(ourl,expath);
		script[0] = 0;
	}

	strcpy(dstproto,DST_PROTO);
	if( localPathProto(dstproto) ){
		strcpy(proto,DST_PROTO);
		strcpy(host,DST_HOST);
		path = url;
	}else{
		path = file_hostpath(url,proto,host);
	}
	if( path == NULL )
		return 0;
	IsLocal = 1;

	if( search = strchr(url,'?') )
		*search++ = 0;

	sprintf(server,"DeleGate/%s",DELEGATE_ver());
	set_realserver(Conn,proto,host,0);

	if( !service_permitted(Conn,proto) ){
		sv1log("REJECT 1\n");
		*stcodep = 403;
		return putHttpRejectmsg(Conn,tc,proto,server,0,req);
	}
	if( !Conn->from_myself && !IsMounted ){
		sv1log("REJECT 2\n");
		*stcodep = 403;
		return putHttpRejectmsg(Conn,tc,proto,server,0,req);
	}

	/*
	 * if the path is not in absolute form, then make it so ...
	 */
	Verbose("## PATH=[%s]\n",path);
	if( *path != '/' ){
		sprintf(apath,"/%s",path);
		path = apath;
	}
	lineScan(path,upath);

	HTTP_ClientIF_HP(Conn,hostport);

	mok = 0;
	myproto = CLNT_PROTO;

	vurl[0] = 0;
	if( path[0] == '/' )
	mok = CTX_mount_url_fromL(Conn,vurl,proto,host,path+1,NULL,myproto,hostport);
	if( !mok )
	mok = CTX_mount_url_fromL(Conn,vurl,proto,host,path,  NULL,myproto,hostport);

	if( mok == 0 ){
		/* not likely to be in normal situation...  since this
		 * function is called when the requested URL is mounted.
		 */
		sv1log("REJECT 4 -- NOT MOUNTED[%s]\n",url);
		*stcodep = 403;
		return putHttpRejectmsg(Conn,tc,proto,server,0,req);
	}

	Verbose("## URL=[%s]\n",vurl);

	if( localPathProto(dstproto) )
	if( off_limit(vurl,upath) ){
		sv1log("REJECT 3\n");
		*stcodep = 403;
		return putHttpRejectmsg(Conn,tc,proto,server,0,req);
	}

	nonxalpha_unescape(path,dpath,1);
	path = dpath;
	/*
	 * Duplicate slash like Q://RedHat is not accepted by Win95/98.
	 * It can be generated by a request URL like "//RedHat"
	 * for MOUNT="/* file:Q:/*"
	 * Stripping duplicate slash should have been done at the
	 * requested URL parsing phase, or it should be resolved to
	 * 302 MovedTo response...
	 */
	deldupslash(path);
	if( *path == '/' && isFullpath(path+1) ){
		path += 1;
		Verbose("## PATH=/[%s]\n",path);
	}

	Verbose("## UPATH=[%s]\n",upath);
	if( search && Search || CGIonly ){
		if( CGIonly )
			execpath = path;
		else	execpath = Search;
		if( strtailchr(execpath) == '/' ){
			if( fp = openIndex(Conn,execpath,upath,iexecpath,S_EXEC,&mtime) ){
				execpath = iexecpath;
				fclose(fp);
			}
		}
		if( CGIonly ){
			if( expath[0] ){
				lineScan(expath,texurl);
				datapath = expath;
				if( CTX_mount_url_to(Conn,NULL,method,texurl) ){
					strcpy(texpath,"/");
					decomp_absurl(texurl,NULL,NULL,texpath+1,sizeof(texpath)-1);
					datapath = texpath;
				}
			}else	datapath = execpath;
		}else{
			lineScan(ourl,expath);
			if( search = strchr(expath,'?') )
				*search = 0;
			datapath = path;
			script[0] = 0;
			sv1log("Search-Script: %s %s %s\n",execpath,datapath,expath);
		}
		if( strtailchr(datapath) == '/' ){
			if( fp = openIndex(Conn,datapath,upath,idatapath,S_DATA,&mtime) ){
				datapath = idatapath;
				fclose(fp);
			}
		}
		IsLocal = 0; /* some side effect might remain ... ? */
		leng = exec_cgi(Conn,req,head,execpath,datapath,vurl,ourl,script,expath,fc,tc,stcodep);
		return leng;
	}

	fp = NULL;
	if( !fileIsdir(path) ){
		if( strtailchr(path) == '/' ){
			char fpath[URLSZ];
			/* A plain file is refered as if it's a directory.
			 * It must be treated as "404 Not Found" or it may be
			 * a CGI SCRIPT_NAME postfixed with a PATH_INFO
			 */
			lineScan(path,fpath);
			deltailslash(fpath);

			if( strtailchr(vurl) == '/' )
			if( File_isreg(fpath) )
			if( !strtailstr(fpath,".cgi") )
			if( !strtailstr(fpath,".dgp") )
			if( !strtailstr(fpath,".shtml") )
			{
				deltailslash(vurl);
				*stcodep = 301;
				return putMovedToX(Conn,tc,301,vurl);
			}
		}else
		/*
		fp = fopen(path,"r");
		*/
		fp = extfopen(path,"r");
/* peep CACHE as if it's a normal page...
		if( fp != NULL && strstr(mok,"iscache") ){
			cachepath_to_url(path,vurl);
			*stcodep = 302;
			return putMovedTo(Conn,tc,vurl);
		}
*/
	}else
	if( strtailchr(path) != '/' ){
		strcat(vurl,"/");
		*stcodep = 301;
		return putMovedToX(Conn,tc,301,vurl);
	}

	if( leng = putRobotsTxt(Conn,tc,fp,0) ){
		if( fp != NULL )
			fclose(fp);
		return leng;
	}

	if( fp == NULL ){
		if( fp == NULL )
		/* search local welcome.html before upper welcome.cgi */
		if( fileIsdir(path) && strtailchr(path) == '/' ){
			fp = openIndex(Conn,path,upath,idatapath,S_EXEC|S_DATA,&mtime);
			if( fp != NULL ){
				path = idatapath;
				ctype = filename2ctype(idatapath);
			}
		}
		if( fp == NULL )
		fp = searchExecUpward(Conn,script,upath,expath,&path,&ctype,
			iexecpath,&mtime);

		if( fp == NULL ){
			sv1log("Unknown local %s: %s\n",path,proto);
			delayUnknown(Conn,1,req);
			*stcodep = 404;
			/*
			return putHttpNotFound(Conn,tc,
				"No such file or directory\r\n");
			*/
			return putUnknownPage(Conn,tc,vno,req);
		}
	}

	if( strtailstr(path,".dgp") )
		return exec_delegate(Conn,req,head,script,expath,path,fp,fc,tc);

	if( strtailstr(path,".cgi") ) /* if( executable ) */
	{
		leng = exec_cgi(Conn,req,head,path,path,vurl,ourl,script,expath,fc,tc,stcodep);
		if( 0 <= leng ){
			fclose(fp);
			IsLocal = 0; /* some side effect might remain ... ? */
			return leng;
		}
	}

	if( strtailstr(path,".shtml") ){
		char conninfo[4096],*av[32],*ev[128],eb[4096];
		char myhp[256];
		StrVec Env;
		FILE *tcx;

		randenv();
		make_conninfo(Conn,conninfo,NULL);
		SVinit(&Env,"putLocal",ev,128,eb,sizeof(eb));
		cgi_makeEnv(conninfo,req,head,vurl,ourl,path,script,expath,av,&Env);
		if( !HTTP_relayThru(Conn) )
			tcx = openHttpResponseFilter(Conn,tc);
		else	tcx = tc;
		leng = exec_metassi(Conn,av,ev,fc,tcx,fp);
		if( tcx != tc ){
			fclose(tcx);
			wait(0);
		}
		if( 0 <= leng ){
			fclose(fp);
			return leng;
		}
	}

	if( ctype == NULL )
		ctype = filename2ctype(path);
	if( ctype == NULL ){
		int ch;
		ctype = "text/plain";
		while( (ch = getc(fp)) != EOF )
			if( ch & 0x80 ){
				ctype = "application/octet-stream";
				encoding = ME_binary;
				break;
			}
		if( ch == EOF )
			clearerr(fp);
		fseek(fp,0,0);
	}
	size = file_size(fileno(fp));
	if( 0 < mtime )
		lastmod = mtime;
	else	lastmod = file_mtime(fileno(fp));

	{
	int clIfMod;
	clIfMod = ClientIfModClock(Conn);
	if( 0 < clIfMod ){
		if( lastmod <= clIfMod ){
			notMod = 1;
			sv1log("Not Modified: %s\n",path);
		}
	}
	}

	if( pp = strstr(path,".dhtml") )
	if( pp[6] == 0 ){
		char *msg;
		msg = (char*)malloc(size+1);
		msg[0] = 0;
		fread(msg,1,size,fp);
		msg[size] = 0;
		leng = put_eval_dhtml(Conn,ourl,tc,msg);
		free(msg);
		return leng;
	}

if( search ) /* don't clear ?_?partname=... */
	setPartfilter(Conn,search);

	if( strcasecmp(method,"HEAD") == 0 ){
		if( vno < 100 )
			vno = 100;
leng = 
putData1(Conn,NULL,tc,req,vno,server,ctype,encoding,size,lastmod,expire,NULL);
	}else
	if( CCXactive(CCX_TOCL) || CTX_check_codeconv(Conn,1) ){
leng =
putData1(Conn,fp,  tc,req,vno,server,ctype,encoding,size,lastmod,expire,NULL);
	}else
	if( notMod ){
leng = 
putData1(Conn,NULL,tc,req,vno,server,ctype,encoding,size,lastmod,expire,
"304 Not modified");
		*stcodep = 304;
	}else{
leng =
putData1(Conn,fp,  tc,req,vno,server,ctype,encoding,size,lastmod,expire,NULL);
	}
	fclose(fp);
	return leng;
}
static putData1(Conn,fp,tc,req,vno,serv,ctype,cenc,size,mtime,exp,stat)
	Connection *Conn;
	FILE *fp,*tc;
	char *req,*serv,*ctype,*cenc,*stat;
{	FILE *tcx;
	int leng;
	int rewrite;

	rewrite = strcmp(ctype,"text/html") == 0;
	if( rewrite ){
/*
possibly this was necessary to suppress some undesirable rewriting, but
it is harmful for necessary rewriting of, partializing icon URLs, or
reverse MOUNT of URLs in local HTML documents...
DONT_REWRITE = 1;
*/
		fflush(tc);
		tcx = openHttpResponseFilter(Conn,tc);
	}else	tcx = tc;

	leng = putHttpMssg(Conn,tcx,fp,req,vno,serv,ctype,cenc,size,mtime,exp,stat);
	if( rewrite ){
		fclose(tcx);
		wait(0);
	}
	return leng;
}
extern char *HTTP_outCharset();
putHttpMssg(Conn,dst,src,req,vno,serv,ctype,cenc,leng,mtime,exp,stat)
	Connection *Conn;
	FILE *dst,*src;
	char *req,*serv,*ctype,*cenc,*stat;
{	int hlen,blen;
	char *xcharset,xctype[256];

	if( Conn->fi_builtin == 0 /* codeconv will be done in the filter */
	 && strncasecmp(ctype,"text/",5) == 0 )
		xcharset = HTTP_outCharset(Conn);
	else	xcharset = 0;
	if( xcharset ){
		strcpy(xctype,ctype);
		replace_charset_value(xctype,xcharset,1);
		ctype = xctype;
	}

	hlen = putHttpHeader1X(Conn,dst,vno,serv,ctype,cenc,leng,mtime,exp,stat);

	blen = 0;
	if( src != NULL && strncasecmp(req,"HEAD ",5) != 0 ){
		if( xcharset )
			blen = CCV_relay_text(Conn,src,dst,NULL);
		else	blen = copyfile1(src,dst);
	}

	/* return length including header length because some caller function
	 * needs non-zero value to judge the success...
	 */
	return hlen + blen;
}

/* Return true if the request is for "/robots.txt" from a client which
 * regards this DeleGate as an origin HTTP server.  In this case, the
 * original form of the request is like "GET /robots.txt HTTP/1.0".
 * In HTTP/1.1 or later, the existence of "Host: server" field might be
 * considered also ... ?
 */
static norobot1(fp,url,proto,user,pass,host,port,path,opts)
	FILE *fp;
	char *url,*proto,*user,*host,*path,*opts;
{	int disable;

	if( strstr(opts,"robots=ok") )
		disable = 0;
	else
	if( strstr(opts,"robots=no") )
		disable = 1;
	else
	if( streq(proto,"nntp") || streq(proto,"ftp") )
		disable = 1;
	else	disable = 0;

	if( disable )
		fprintf(fp,"Disallow: %s\r\n",url);
}
DHTML_printNoRobots(Conn,fp,fmt,name,arg,value)
	Connection *Conn;
	FILE *fp;
	char *fmt,*name,*arg,*value;
{
	/* if( streq(arg,"mount") ) */
		CTX_scan_mtab(Conn,norobot1,fp);
}
reqRobotsTxt(Conn)
        Connection *Conn;
{
	return HTTP_originalURLmatch(Conn,"/robots.txt");
}
putRobotsTxt(Conn,tc,afp,ismsg)
	Connection *Conn;
	FILE *tc;
	FILE *afp;
{	int leng,cleng;
	FILE *org,*gen,*tmp;
	char line[1024];

	if( !reqRobotsTxt(Conn) )
		return 0;

	sv1log("#### Generate /robots.txt\n");
	if( afp == NULL ){
		tmp = TMPFILE("RobotsTxt");
		fprintf(tmp,"#### Generated by a proxy - %s\r\n",
			DELEGATE_version());
		putBuiltinHTML(Conn,tmp,"/robots.txt","robots.dhtml",
			NULL,printConn,NULL);
		fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);

		putHttpHeader1(Conn,tc,NULL,"text/plain",ME_7bit,cleng,0);
		if( RespWithBody ) copyfile1(tmp,tc);
		fclose(tmp);
		return cleng;
	}

	if( ismsg ){
		int rcode = 0;
		if( fgets(line,sizeof(line),afp) != NULL )
			sscanf(line,"%*s %d",&rcode);
		if( rcode != 200 )
			return putRobotsTxt(Conn,tc,NULL,ismsg);

		while( fgets(line,sizeof(line),afp) ){
			Verbose("SKIP HEADER %s",line);
			if( *line == '\r' || *line == '\n' )
				break;
		}
	}

	tmp = TMPFILE("RobotsTxt++");
	org = TMPFILE("RobotsTxt-1");
	copyfile1(afp,org);
	fflush(org);
	fseek(org,0,0);

	gen = TMPFILE("RobotsTxt-2");
	putBuiltinHTML(Conn,gen,"/robots.txt","robots.dhtml",
		NULL,printConn,NULL);
	fflush(gen);
	fseek(gen,0,0);

	leng = mergeRobotsTxts(org,gen,tmp);
	fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);
	putHttpHeader1(Conn,tc,NULL,"text/plain",ME_7bit,cleng,0);
	if( RespWithBody ) copyfile1(tmp,tc);
	fclose(tmp);

	fclose(org);
	fclose(gen);
	return leng;
}

extern char *freadfile();
mergeRobotsTxts(rtf1,rtf2,out)
	FILE *rtf1,*rtf2,*out;
{	int leng,len,tx,ti,out2;
	char *rts[2],ch,*sp,*np;
	char *records[2][1024],fn[256],val[256],*rs1,*rs2;
	char *wildua[2];
	int wildrec[2];
	char msg[1024];

	len = 0; rts[0] = freadfile(rtf1,&len);
	len = 0; rts[1] = freadfile(rtf2,&len);

	for( ti = 0; ti < 2; ti++ ){
		tx = 0;
		records[ti][tx++] = rts[ti];
		wildrec[ti] = -1;
		wildua[ti] = 0;
		for( sp = rts[ti]; sp && *sp; sp = np ){
			if( wildua[ti] == NULL ){
				scan_field1(sp,fn,sizeof(fn),val,sizeof(val));
				if( strcasecmp(fn,"User-Agent") == 0 )
				if( strcmp(val,"*") == 0 ){
					wildua[ti] = sp;
					wildrec[ti] = tx - 1;;
				}
			}
			if( *sp == '\r' || *sp == '\n' )
				records[ti][tx++] = sp;
			if( np = strchr(sp,'\n') )
				np++;

			if( 1000 < tx ){
				sv1log("#### Too large /robots.txt\n");
				break;
			}
		}
		records[ti][tx++] = rts[ti] + strlen(rts[ti]);
		records[ti][tx] = 0;
	}

	leng = 0;
	for( tx = 0; (rs1 = records[0][tx]) && *rs1; tx++ ){
		leng += len = records[0][tx+1] - rs1;
		fwrite(rs1,1,len,out);
		if( tx == wildrec[0] && 0 <= (ti = wildrec[1]) ){
			sprintf(msg,"#### Appended by a proxy - %s\r\n",
				DELEGATE_version());
			leng += strlen(msg);
			fwrite(msg,1,strlen(msg),out);

			rs2 = records[1][ti];
			leng += len = wildua[1] - rs2;
			fwrite(rs2,1,len,out);

			fwrite("#",1,1,out);
			leng++;
			leng += len = records[1][ti+1] - wildua[1];
			fwrite(wildua[1],1,len,out);
		}
	}

	out2 = 0;
	for( ti = 0; (rs2 = records[1][ti]) && *rs2; ti++ )
	if( ti != wildrec[1] ){
		if( out2++ == 0 ){
			sprintf(msg,"\r\n");
			sprintf(msg,"#### Generated by a proxy - %s\r\n",
				DELEGATE_version());
			leng += strlen(msg);
			fwrite(msg,1,strlen(msg),out);
		}
		leng += len = records[1][ti+1] - rs2;
		fwrite(rs2,1,len,out);
	}
	return leng;
}

extern int DELEGATE_EXTOVW;
extern int BREAK_STICKY;
static int exec_loop;
static char *exec_path;
int MAX_DGP_LOOP = 1;
exec_delegate(Conn,req,head,script,expath,path,pfp,fc,tc)
	Connection *Conn;
	char *req,*head;
	char *script,*expath,*path;
	FILE *pfp,*fc,*tc;
{	char  buf[1024];
	char ibuf[0x10000],*ibp;
	int rcc;
	Connection NewConnBuf, *NewConn = &NewConnBuf;

	if( MAX_DGP_LOOP < exec_loop
	 || exec_path != NULL && strcmp(exec_path,path) == 0){
		sv1log("## break DGP loop [%d] %s\n",exec_loop,path);
		Finish(0);
	}
	exec_loop++;
	exec_path = stralloc(path);

	sv1log("DeleGate[%s][%s][%s]\n",path,script,expath);
	ibp = ibuf;
	if( *expath == 0 )
		expath = "/";
	sprintf(ibp,"%s %s HTTP/%s\r\n",REQ_METHOD,expath,REQ_VER);
	ibp += strlen(ibp);
	strcpy(ibp,head);
	ibp += strlen(ibp);
	while( 0 < (rcc = fgetBuffered(ibp,1024,fc)) )
		ibp += rcc;
	*ibp = 0;

	clear_mtab();

	DELEGATE_clearEnv();
	DELEGATE_EXTOVW = 1;

/* access control about source by RELIABLE is done in putLocal */
/* access control in this DeleGate must not be overwritten.
 * table for REMITTABLE,REACHABLE,RELIABLE,PERMIT should be able to
 * be pushed onto some "STACK"...
 * With such stack, REMITTABLE,REACHABLE,RELIABLE will be replaced
 * by "upper-level PERMIT"
 */
	load_script(NULL,NULL,path);
	DELEGATE_EXTOVW = 0;

	ConnCopy(NewConn,Conn);
	DELEGATE_configx(NewConn,1);
	DDI_pushCbuf(NewConn,ibuf,ibp-ibuf);

	Conn = NewConn;
	strcpy(DFLT_PROTO,"http");
	DFLT_HOST[0] = 0;
	DFLT_PORT = 0;
	ACT_SPECIALIST = 1;

	BREAK_STICKY = 1;
	DontKeepAlive = 1;
	execSpecialist(NewConn,fileno(fc),tc,-1);
	Finish(0);
}

getProxyControlPart(Conn,url)
	Connection *Conn;
	char *url;
{	char *pxp,*pxe,pxc[1024];

	if( ProxyControlMARK == 0 || *ProxyControlMARK == 0 )
		return;

	if( pxp = strstr(url,ProxyControlMARK) ){
		wordScan(pxp+strlen(ProxyControlMARK),ProxyControls);
		pxe = wordScan(pxp+3,pxc);
		strcpy(pxp,pxe);
sv1log("#### PXC[%s]\n",pxc);
		if( strncmp(pxc,"partname=",9) == 0 ){
			setPartfilter(Conn,pxc+9);
		}
	}
}
setPartfilter(Conn,query)
	Connection *Conn;
	char *query;
{
	if( query ){
		wordScan(query,Conn->dg_putpart);
sv1log("################ PART[%s]\n",Conn->dg_putpart);
	}else	Conn->dg_putpart[0] = 0;
}
clearPartfilter(Pf)
	Partf *Pf;
{
	Pf->p_Isin = 0;
	Pf->p_Type[0] = 0;
	Pf->p_Asis = 0;
	Pf->p_Indexing = 0;
	Pf->p_BaseSet = 0;
	Pf->p_Base[0] = 0;
	Pf->p_Title[0] = 0;
}
static getTitle(lp,title,size)
	char *lp,*title;
{	char *tp,tbuff[256];

	title[0] = 0;
	wordscanY(lp,tbuff,sizeof(tbuff),"^>");
	if( tp = strcasestr(tbuff,"TITLE=") ){
		valuescanX(tp+6,title,size);
	}
}
Partfilter(Conn,Pf,line,size)
	Connection *Conn;
	Partf *Pf;
	char *line;
{	char *lp,*dp,*tag,*attr,name[32],*tail;
	char buff[0x10000];
	char type[256],title[256],indent[32],*mark;

	if( strncmp(ProxyControls,"partname=",9) == 0 )
		mark = "?_?partname=";
	else	mark = "?";

	if( dp = strcasestr(line,"<TITLE>") ){
		wordscanY(dp+7,Pf->p_Title,128,"^<");
	}
	title[0] = 0;
	if( Pf->p_Isin == 0 ){
		lp = line;
		if( streq(Conn->dg_putpart,".parts") ){
			Pf->p_Isin = 100;
			/* convert .html#name to .html?name */
		}else
		if( streq(Conn->dg_putpart,".skeleton")
		 || streq(Conn->dg_putpart,".index") ){
			Pf->p_Isin = 10;
			Pf->p_Indexing = 1;
		}else
		while( tag = strcasestr(lp,"<A NAME=") ){
			getTitle(tag,title,sizeof(title));
			attr = tag + strlen("<A NAME=");
			valuescanX(attr,name,sizeof(name));

			if( streq(name,Conn->dg_putpart) ){
				wordscanY(tag,type,sizeof(type),"^>");
				if( strcasestr(type,"TYPE=HIDDEN") ){
					Pf->p_Asis = 1;
				}

				if( lp = strchr(tag,'>') )
					ovstrcpy(line,lp+1);
				else	ovstrcpy(line,tag);
				Pf->p_Isin = 1;
				break;
			}
			lp = attr;
		}
	}
	if( Pf->p_Isin == 0 )
		return 0;

	if( Pf->p_BaseSet == 0 ){
		char all[256];
		Pf->p_BaseSet = 1;
		wordScan(REQ_URL,Pf->p_Base);
		if( dp = strchr(Pf->p_Base,'?') )
			*dp = 0;
		if( dp = strrchr(Pf->p_Base,'/') )
			ovstrcpy(Pf->p_Base,dp+1);
sv1log("################ Base: %s\n",Pf->p_Base);
		if( Pf->p_Isin < 100 ){

sprintf(all,"<TITLE>%s / %s</TITLE>\r\n",Pf->p_Title,
title[0]?title:Conn->dg_putpart);

			if( !Pf->p_Asis ){
sprintf(all+strlen(all),"<A HREF=\"./%s#%s\">[CTX]</A>\r\n",Pf->p_Base,Conn->dg_putpart);
sprintf(all+strlen(all),"<A HREF=%s%s%s>[ALL]</A>\r\n",Pf->p_Base,mark,".parts");
sprintf(all+strlen(all),"%s\r\n",title[0]?title:"");
sprintf(all+strlen(all),"<HR>\r\n");
sv1log("################\n%s\n",all);
			}
			Strins(line,all);
		}
	}

	tail = buff;
	buff[0] = 0;
	for( lp = line; *lp; lp++ ){
		if( strncaseeq(lp,"<A ",3) ){
			Pf->p_Isin++;

			if( strncaseeq(lp,"<A NAME=",8) ){
				getTitle(lp,title,sizeof(title));
				attr = lp + strlen("<A NAME=");
				valuescanX(attr,name,sizeof(name));

				if( Pf->p_Indexing ){
					wordscanY(lp,type,sizeof(type),"^>");
					if( strcasestr(type,"TYPE=HIDDEN") ){
					}else{
					if( 12 < Pf->p_Isin )
						sprintf(indent," ...... ");
					else
					if( 11 < Pf->p_Isin )
						sprintf(indent," ... ");
					else	indent[0] = 0;
sprintf(tail,"<LI>%s<A HREF=\"./%s%s%s\">%s</A>\r\n",
indent,Pf->p_Base,mark,name,title[0]?title:name);
					tail += strlen(tail);
					}
				}else
				if( 100 <= Pf->p_Isin ){
sprintf(tail,"<P>--<A HREF=\"./%s%s%s\">%s</A>--<P>\r\n",
Pf->p_Base,mark,name, name);
					Strins(lp,tail);
					lp += strlen(tail) + 1;
					*tail = 0;
					continue;
				}
			}

			if( tag = strcasestr(lp,"<A HREF=") ){
				attr = tag + strlen("<A HREF=");
				if( *attr == '"' )
					attr++;
				if( *attr == '#' ){
					*attr = '?';
					Strins(attr,Pf->p_Base);
				}
			}
		}else
		if( strncaseeq(lp,"</A>",4) ){
			Pf->p_Isin--;
			if( Pf->p_Isin <= 0  ){
				Pf->p_Isin = 0;
				if( Pf->p_Asis )
					strcpy(lp,"\r\n");
				else	strcpy(lp,"\r\n<HR>\r\n");
				break;
			}
		}
	}
	if( Pf->p_Indexing )
		strcpy(line,buff);
	return 1;
}
