/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	http.h
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970708	extracted from httpd.c
//////////////////////////////////////////////////////////////////////#*/

#include "url.h"

#define OBUFSIZE	URLSZ
#define IBUFSIZE	URLSZ
#define SOCKBUFSIZE	URLSZ
#define RESP_LINEBUFSZ	(URLSZ*4)

#define MY_HTTPVER	"1.1"
#define MY_MIMEVER	"1.0"

#define ME_7bit		((char*)0)
#define ME_binary	"binary"

#define R_EMPTY_RESPONSE	-10001
#define R_UNSATISFIED		-10002
#define R_UNSATISFIED_TEXT	-10003
#define R_NONTEXT_INTEXT	-10004
#define R_GENERATED		-10005
#define R_MOVED_LOOP		-10006
#define R_BROKEN_RESPONSE	-10007

/*
 * result status in the logfile
 */
#define CS_AUTHERR	'A'
#define CS_CONNERR	'C'
#define CS_ERROR	'E'
#define CS_HITCACHE	'H'
#define CS_INTERNAL	'I'
#define CS_LOCAL	'L'	/* local file (or CGI,SSI) */
#define CS_KILLED	'K'
#define CS_MAKESHIFT	'M'	/* connection failed and make shift */
#define CS_EOF		'P'
#define CS_NEW		'N'	/* got first (not found) */
#define CS_OBSOLETE	'O'	/* obsolete (modified) */
#define CS_RELOAD	'R'	/* reload (Pragma: no-cache) */
#define CS_STABLE	'S'	/* stable (not modified) */
#define CS_WITHOUTC	'W'	/* without cache */
#define CS_BADREQUEST	'B'	/* illegal request */

typedef struct _HttpRequest {
	char	hq_method[32];
	char	hq_url[URLSZ];
	char	hq_ver[32];
	int	hq_vno;
} HttpRequest;

typedef struct {
	char	hr_ver[256];		/* HTTP version */
	int	hr_rcode;		/* status code */
	char	hr_reason[256];		/* reason */
	char	hr_isHTTP09;		/* before HTTP/1.0 */
} HttpResponse;

typedef struct {
	int	r_code;
	int	r_sav; /* if true, save the response message into r_msg[] */
	UTag	r_msg;
	int	r_len;
	FILE   *r_msgfp; /* if the response message is larger than r_msg */
} HtResp;

typedef struct {
	char	r_oreqmsg[0x8000]; /* original request message */
	int	r_oreqlen;

	char    r_oreq[URLSZ];	/* original request line */
	UTag	r_ohost;	/* original server host */
	int	r_oport;	/* original server port */
	char	r_vhost[256];	/* original Host: field */
	char	r_UserAgent[256];

	int	r_badRequest;
	int	r_normalized;
	int	r_checkServ;
	int	r_waitServ;
	int	r_badServ;
	char	r_badServResponse[128];
	char	r_badServDetected[32];
	char	r_req[URLSZ];	/* HTTP request possibly rewritten */
 HttpRequest	r_reqx;		/* decomposed r_req */

	char	r_fields[0x8000];
	char   *r_lastFname;	/* cache for getRequestField */
	char   *r_lastFbody;	/* (pointers into f_fields) */

	UTag	r_acclangs;	/* merged list of Accept-Language for log */

	char	r_clntIfmod[256]; /* If-Mod-Since from the  client */
	int	r_clntIfmodClock; /* its value in int */

	int	r_flushhead;
	int	r_flushsmall;

	int	r_withCookie;
	char	r_dgCookie[256]; /* Proxy-Cookie */
	int	r_appletFilter;

	int	r_clntAccChunk;
	char	r_httpConn[128];
	int	r_get_cache;
	char	r_iconBase[256];	
	HtResp	r_resp;
	int	r_doUnzip;
	int	r_doZip;

	int	r_NOJAVA;

	UTag	r_o_buff; /* for stdio */
	UTag	r_i_buff;
	UTag	r_savConn;
} HTTP_env;

#define CurEnv		((HTTP_env*)Conn->cl_reqbuf)

#define OREQ_MSG	CurEnv->r_oreqmsg
#define OREQ_LEN	CurEnv->r_oreqlen

#define OREQ		CurEnv->r_oreq
#define OREQ_HOST	CurEnv->r_ohost.ut_addr
#define OREQ_PORT	CurEnv->r_oport
#define OREQ_VHOST	CurEnv->r_vhost
#define REQ_UA		CurEnv->r_UserAgent

#define REQ		CurEnv->r_req
#define REQ_FIELDS	CurEnv->r_fields
#define REQX		CurEnv->r_reqx
#define REQ_METHOD	CurEnv->r_reqx.hq_method
#define REQ_URL		CurEnv->r_reqx.hq_url
#define REQ_VER		CurEnv->r_reqx.hq_ver
#define REQ_VNO		CurEnv->r_reqx.hq_vno

#define BadRequest	CurEnv->r_badRequest
#define Normalized	CurEnv->r_normalized
#define CheckServ	CurEnv->r_checkServ
#define WaitServ	CurEnv->r_waitServ
#define BadServ		CurEnv->r_badServ
#define BadServResponse	CurEnv->r_badServResponse
#define BadServDetected	CurEnv->r_badServDetected

#define AcceptLanguages	CurEnv->r_acclangs.ut_addr

#define FlushHead	CurEnv->r_flushhead
#define FlushIfSmall	CurEnv->r_flushsmall

#define ClntIfMod	CurEnv->r_clntIfmod
#define ClntIfModClock	CurEnv->r_clntIfmodClock

#define withCookie	CurEnv->r_withCookie
#define appletFilter	CurEnv->r_appletFilter
#define proxyCookie	CurEnv->r_dgCookie

#define iconBase	CurEnv->r_iconBase
#define GET_CACHE	CurEnv->r_get_cache
#define ClntAccChunk	CurEnv->r_clntAccChunk
#define httpConn	CurEnv->r_httpConn

#define RespCode	CurEnv->r_resp.r_code
#define RESP_SAV	CurEnv->r_resp.r_sav
#define RESP_MSG	CurEnv->r_resp.r_msg.ut_addr
#define RESP_SIZ	CurEnv->r_resp.r_msg.ut_size
#define RESP_LEN	CurEnv->r_resp.r_len
#define RESP_MSGFP	CurEnv->r_resp.r_msgfp
#define RESP_DoUNZIP	CurEnv->r_doUnzip
#define RESP_DoZIP	CurEnv->r_doZip

#define NOJAVA		CurEnv->r_NOJAVA

#define F_HTTPVER	"HTTP/"
#define F_HTTPVERLEN	sizeof(F_HTTPVER)-1
#define F_DGVer		"DeleGate-Ver:"
#define F_ContType	"Content-Type:"
#define F_CtypeText	"Content-Type: text"
#define F_CtypePlain	"Content-Type: text/plain"
#define F_CtypeHTML	"Content-Type: text/html"
#define F_ContEncode	"Content-Encoding:"
#define F_TransEncode	"Transfer-Encoding:"
#define F_ContLeng	"Content-Length:"
#define F_ContRange	"Content-Range:"
#define F_Range		"Range:"
#define F_Location	"Location:"
#define F_SetProxy	"Set-Proxy:"
#define F_LastMod	"Last-Modified:"
#define F_Etag		"Etag:"
#define F_Server	"Server:"
#define F_Cookie	"Cookie:"
#define F_SetCookie	"Set-Cookie:"
#define F_Connection	"Connection:"
#define F_PConnection	"Proxy-Connection:"
#define F_CacheControl	"Cache-Control:"
#define F_Pragma	"Pragma:"
#define F_KeepAlive	"Keep-Alive:"
#define F_Via		"Via:"
#define F_Vary		"Vary:"
#define F_AccEncode	"Accept-Encoding:"

#define STRH(field,fname) \
	(strncasecmp(field,fname,sizeof(fname)-1)==0?sizeof(fname)-1:0)

#define STRH_Connection(field) ( \
	  STRH(field,F_Connection) ? STRH(field,F_Connection) \
	: STRH(field,F_PConnection) )

extern int HTTP11_toserver;
extern int HTTP11_toclient;
extern int HTTP09_reject;
extern int HTTP_ignoreIf;
extern int HTTP_warnApplet;
extern int HTTP_rejectBadHeader;
extern int HTTP_CKA_MAXREQ;
extern int HTTP_CKA_PERCLIENT;
extern int HTTP_MAXHOPS;
extern int HTTP_MAX_REQLINE;
extern int HTTP_MAX_REQHEAD;
extern int HTTP_GW_MAX_REQLINE;
extern char *HTTP_MAX_REQLINE_sym;
extern char *HTTP_MAX_REQHEAD_sym;
extern char *HTTP_GW_MAX_REQLINE_sym;
extern char *HTTP_urlesc;

extern double HTTP_TOUT_QBODY;
extern double HTTP_WAIT_REQBODY;
extern double HTTP_TOUT_IN_REQBODY;
extern double HTTP_TOUT_BUFF_REQBODY;
extern double HTTP_TOUT_CKA;
extern double HTTP_TOUT_CKA_MARGIN;
extern double HTTP_TOUT_RESPLINE;
extern double HTTP_WAIT_BADSERV;

#define CMAP_APPROVER "Approver"
extern int modwatch_enable;
extern char *modwatch_notify;
extern int modwatch_approver;

#define KH_REQ	1
#define KH_RES	2
#define KH_BOTH	3
#define KH_IN	0x10
#define KH_OUT	0x20

extern int HTTP_cacheopt;
#define CACHE_NOLASTMOD	0x0001
#define CACHE_NOCACHE	0x0002
#define CACHE_302	0x0004

extern int HTTP_opts;
#define HTTP_DELWRONGCONTLENG	1
#define HTTP_NOCHUNKED		2
#define HTTP_SUPPCHUNKED	4
#define HTTP_FLUSHCHUNK		8
#define HTTP_NOKEEPALIVE	0x10
#define HTTP_NOMETHODCHECK	0x20
#define HTTP_NOGZIP		0x40


typedef struct {
	int	p_Isin;	/* isin xxx.html?part */
	char	p_Type[32];
	int	p_Asis;
	int	p_Indexing;
	int	p_BaseSet;
	char	p_Base[256];
	char	p_Title[256];
} Partf;

