/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996-1999 Yutaka Sato
Copyright (c) 1996-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	htmlgen.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960126	extracted from httpd.c
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "url.h"

static char *home_page = "/-/";

extern char *Sprintf();
extern char *getMssg();
static char *msg_not_found = "\
<TITLE> Builtin Message %s Not Found </TITLE>\n\
Builtin message %s not found.\n\
";

typedef struct {
	int	 when;
	char	*url;
	char	*rurl;
	int	 size;
	int	 time;
	char	 data[1];
} Cache;

#define NUMCACHE	128
typedef struct {
	Cache  *he_caches[NUMCACHE];
	int	he_cachex;
} HtmlGenEnv;
static HtmlGenEnv *htmlGenEnv;
#define caches	htmlGenEnv->he_caches
#define cachex	htmlGenEnv->he_cachex
minit_htmlgen()
{
	if( htmlGenEnv == 0 ){
		htmlGenEnv = NewStruct(HtmlGenEnv);
	}
}

static putCache(url,rurl,data,size)
	char *url,*rurl,*data;
{	Cache *cp,*ocp;
	int cx;

	minit_htmlgen();

	if( NUMCACHE <= cachex )
		return -1;

	cp = (Cache*)malloc(sizeof(Cache)+size-1);
	cp->when = MySeqNum();
	cp->url = stralloc(url);
	cp->rurl = stralloc(rurl);
	cp->size = size;
	cp->time = time(0);
	bcopy(data,cp->data,size);

	for( cx = 0; cx < cachex; cx++ ){
	    ocp = caches[cx];
	    if( streq(url,ocp->url) ){
		free(ocp->url);
		free(ocp->rurl);
		free(ocp);
		break;
	    }
	}
	caches[cx] = cp;
	if( cx == cachex )
		cachex++;
	else	sv1log("####[%d][reloaded] %s\n",cx,url);
	return cx;
}
static getCache(url,rurl,data,size,reload)
	char *url,*rurl,*data;
{	int cx,rcc;
	Cache *cp;

	minit_htmlgen();

	for( cx = 0; cx < cachex; cx++ ){
	    cp = caches[cx];
	    if( streq(url,cp->url) || streq(url,cp->rurl) ){
		if( reload && cp->when != MySeqNum() ){
			sv1log("####[%d][to be reloaded] %s\n",cx,url);
			break;
		}
		if( size < cp->size )
			rcc = size;
		else	rcc = cp->size;
		strcpy(rurl,cp->rurl);
		bcopy(cp->data,data,rcc);
		return rcc;
	    }
	}
	return -1;
}
getBuiltinData(Conn,what,aurl,buf,size,rurl)
	Connection *Conn;
	char *what,*aurl,*buf,*rurl;
{	int rcc;
	FILE *mfp;
	char murl[1024],*iurl;
	char *data;

	if( 0 <= (rcc = getCache(aurl,rurl,buf,size,DontReadCache)) ){
		Verbose("####[reuse] %s\n",rurl);
		buf[rcc] = 0;
		return rcc;
	}

	rurl[0] = 0;
	strcpy(murl,aurl);
	CTX_mount_url_to(Conn,NULL,"GET",murl);

	if( strstr(murl,"://") != NULL ){
		mfp = (FILE*)TMPFILE("MountedBuiltinData");
		CTX_URLget(Conn,0,murl,0,mfp);
		rcc = fread(buf,1,size,mfp);
		fclose(mfp);
		sv1log("%s (%d bytes) MOUNTED: %s\n",what,rcc,murl);
		if( 0 < rcc ){
			sv1log("####[loaded] %s\n",murl);
			putCache(aurl,murl,buf,rcc);
			buf[rcc] = 0;
			strcpy(rurl,murl);
			return rcc;
		}
	}

	rcc = 0;
	if( strncmp(aurl,home_page,strlen(home_page)) == 0 ){
		iurl = aurl+strlen(home_page);
		if( data = getMssg(iurl,&rcc) ){
			Verbose("####[builtin] %s\n",aurl);
			bcopy(data,buf,rcc);
			buf[rcc] = 0;
			putCache(aurl,aurl,buf,rcc);
		}
	}
	return rcc;
}

putBuiltinHTML(Conn,tc,what,purl,desc,func,arg)
	Connection *Conn;
	FILE *tc;
	char *what,*purl,*desc;
	int (*func)();
	char *arg;
{	int leng;
	char buf1[0x10000],buf2[0x10000],*bp,*buf;
	char murl[256],*curl,curlb[1024];
	int exitlev;

	if( purl[0] == '/' || strstr(purl,"://") != 0 )
		curl = purl;
	else{
		sprintf(curlb,"%s%s%s",home_page,"builtin/mssgs/",purl);
		curl = curlb;
	}

	murl[0] = 0;
	leng = getBuiltinData(Conn,what,curl,buf1,sizeof(buf1),murl);
	if( leng == 0 ){
		if( desc == NULL )
			return 0;
		sprintf(buf1,msg_not_found,purl,purl);
		leng = strlen(buf1);
	}

	if( murl[0] && strcmp(murl,curl) != 0 && desc != NULL ){
		char proto[64],server[256];
		char dmurl[256];
		char myhp[128];
		int port;

		bp = buf2;
		proto[0] = server[0] = 0;
		port = 0;
		sscanf(murl,"%[^:]://%[^:/]:%d",proto,server,&port);

		if( !DONT_REWRITE ){
			ClientIF_HP(Conn,myhp);
			/*
			sprintf(dmurl,"http://%s/-_-%s",myhp,murl);
			*/
			sprintf(dmurl,"%s://%s/-_-%s",CLNT_PROTO,myhp,murl);
			strcpy(murl,dmurl);
		}
/*
sv1log("##### clear DONT_REWRITE:%d %s\n",DONT_REWRITE,murl);
DONT_REWRITE = 0;
*/

		bp = Sprintf(bp, "<HEAD><BASE HREF=\"%s\"></HEAD>\n",murl);
		bp = Sprintf(bp,"%s<HR>\n",desc);
		bp = Sprintf(bp,  "<!-- begin redirected %s -->\n\n",what);
		HTTP_redirect_HTML0(Conn,proto,server,port,"",buf1,bp);
		bp += strlen(bp);
		bp = Sprintf(bp,"\n<!-- end redirected %s -->\n",what);
		buf = buf2;
	}else	buf = buf1;

	if( murl[0] )
		curl = murl;
	exitlev = 0;

	if( func == NULL ){
		extern DHTML_printConn();
		func = DHTML_printConn;
		arg = NULL;
	}
	leng = eval_DHTML(Conn,curl,tc,buf,func,arg,&exitlev);
	return leng;
}

static int ENCODE_ENT1;
#define put1s	HTML_put1s

static put_host(Conn,fp,what) Connection *Conn; FILE *fp; char *what; {
	char host[256];

	if( streq(what,"W=MYSELF") ) gethostName(ClientSock,host,PN_HOST); else
	if( streq(what,"W=CLIENT") ) getpeerName(ClientSock,host,PN_HOST); else
	if( streq(what,"W=SERVER") ) sprintf(host,"%s",DST_HOST); else
		return -1;

	put1s(fp,"%s",host);
	return strlen(host);
}
static put_hostport(Conn,fp,what) Connection *Conn; FILE *fp; char *what; {
	char hp[512];

	if( streq(what,"W=MYSELF") )gethostName(ClientSock,hp,PN_HOSTPORT); else
	if( streq(what,"W=CLIENT") )getpeerName(ClientSock,hp,PN_HOSTPORT); else
	if( streq(what,"W=SERVER") ){
		if( REAL_HOST[0] )
			sprintf(hp,"%s:%d",REAL_HOST,REAL_PORT);
		else	sprintf(hp,"%s:%d",DFLT_HOST,DFLT_PORT);
	}
	else return -1;

	put1s(fp,"%s",hp);
	return strlen(hp);
}
static put_protocol(Conn,fp,what) Connection *Conn; FILE *fp; char *what; {
	char *proto;
	if( streq(what,"W=CLIENT") ) proto = "http"; else
	if( streq(what,"W=SERVER") ){
		if( REAL_PROTO[0] )
			proto = REAL_PROTO;
		else	proto = DFLT_PROTO;
	}
	else return -1;

	put1s(fp,"%s",proto);
	return strlen(proto);
}
static put_logomark(Conn,fp,align) Connection *Conn; FILE *fp; char *align; {
	if( strncasecmp(align,"A=",2) == 0 )
		align += 2;
	else	align = "BOTTOM";
	return putDeleGateInline(Conn,fp,align);
}
static put_frog_ver(Conn,fp,form) Connection *Conn; FILE *fp; char *form; {
	return putFrogVer(Conn,fp);
}
put_manager(Conn,fp) Connection *Conn; FILE *fp; {
	fputs(DELEGATE_ADMIN,fp);
	return strlen(DELEGATE_ADMIN);
}
static put_icon(Conn,fp,icon) Connection *Conn; FILE *fp; char *icon; {
	fprintf(fp,"<IMG SRC=%s>",icon);
}

typedef struct {
	char	*tag;
	int	(*func)();
} DTag;
static DTag dhtml_tags[] = {
	{"T=LOGOMARK",	put_logomark},
	{"T=FROG_VER",	put_frog_ver},
	{"T=HOSTPORT",	put_hostport},
	{"T=HOST",	put_host},
	{"T=PROTOCOL",	put_protocol},
	{"T=ADMIN",	put_manager},
	{"T=MANAGER",	put_manager},
	{"T=ICON",	put_icon},
	0
};

static char *scanitem(str)
	char *str;
{	char *sp;
	int lev;

	lev = 1;
	for( sp = str; *sp; sp++ ){
		if( *sp == '{' )
			lev++;
		else
		if( *sp == '}' ){
			if( --lev == 0 )
				return sp;
		}
	}
	return NULL;
}

#define RESERVED_CH(c) (c=='$'||c=='{'||c=='?'||c==':'||c=='}'||c=='"'||c=='\\')

static char *scanchr(str,chr,dstr)
	char *str,*dstr;
{	char *sp,*dp,ch,nch;
	int lev;
	int lit;

	dstr[0] = 0;
	dp = dstr;
	lev = 0;
	lit = 0;
	for( sp = str; ch = *sp; sp++ ){
		if( ch == '"' && lit == 0 ){
			lit = 1;
		}else
		if( ch == '"' && lit == 1 ){
			lit = 0;
		}else
		if( ch == '{' )
			lev++;
		else
		if( ch == '}' )
			lev--;

		if( lit == 0 )
		if( ch == '\\' && (nch = sp[1]) && RESERVED_CH(nch) ){
		}else
		if( lev < 0 || lev == 0 && ch == chr ){
			*dp = 0;
			return sp + 1;
		}

		*dp++ = ch;
	}
	*dp = 0;
	return NULL;
}

static scanatom(itemexp,name,param)
	char *itemexp,*name,*param;
{	char *p;

	name[0] = param[0] = 0;
	if( p = scanchr(itemexp,':',name) )
		scanchr(p,'\0',param);
}

HTML_put1s(fp,fmt,val)
	FILE *fp;
	char *fmt,*val;
{	char buf[4096];

	if( fp != NULL ){
		if( ENCODE_ENT1 ){
			encodeEntitiesX(val,buf,sizeof(buf));
			val = buf;
		}
		if( fmt[0] == '%' && fmt[1] == 's' && fmt[2] == 0 )
			fputs(val,fp);
		else	fprintf(fp,fmt,val);
	}
	return val[0];
}
HTML_put1d(fp,fmt,iv)
	FILE *fp;
	char *fmt;
{	char buf[32];
	char fmt1[8];

	if( fp != NULL ){
		if( fmt[0]=='%' && fmt[1]=='0' && isdigit(fmt[2]) ){
			sprintf(fmt1,"%%0%dd",atoi(&fmt[2]));
			sprintf(buf,fmt1,iv);
		}else	sprintf(buf,"%d",iv);
		put1s(fp,fmt,buf);
	}
	return iv;
}
static call_func(Conn,curl,outfp,item,func,arg)
	Connection *Conn;
	char *curl;
	FILE *outfp;
	char *item;
	int (*func)();
	char *arg;
{	char name[1024],*param,*fmt,fmtb[128];
	int fi;
	int rcode;

	if( item[0] == '=' ){
		fputs(item+1,outfp);
		return strlen(item+1);
	}

	param = scanchr(item,':',name);
	if( streq(name,"include") || streq(name,"include.silent") ){
		char ncurl[1024],what[128],*dp;
		int leng;

		sprintf(what,"eval:%s",param);
		strcpy(ncurl,curl);
		curl = ncurl;
		if( dp = strrchr(curl,'/') )
			dp[0] = 0;
		chdir_cwd(curl,param,0);

		leng = putBuiltinHTML(Conn,outfp,what,curl,NULL,func,arg);
		if( leng <= 0 )
		if( streq(name,"include") )
			fprintf(outfp,"(cannot include %s, %s)",param,curl);
		return 0 < leng;
	}

	param = scanchr(item,'.',name);
	if( param == 0 )
		param = "";

	if( name[0] == '%' ){
		fmt = fmtb;
		fmt[0] = '%';
		for( fi = 1; ;fi++ ){
			if( name[fi] < '0' || '9' < name[fi] )
				break;
			fmt[fi] = name[fi];
		}
		fmt[fi] = 's';
		fmt[fi+1] = 0;
		ovstrcpy(name,name+fi);
	}else{
		fmt = "%s";
	}

	if( name[0] == '_' ){
		ENCODE_ENT1 = 1;
		ovstrcpy(name,name+1);
	}else	ENCODE_ENT1 = 0;

	rcode = (*func)(Conn,outfp,fmt,name,param,arg);

	ENCODE_ENT1 = 0;
	return rcode;
}

static scancond(condexp,conds,trues,falses)
	char *condexp,*conds,*trues,*falses;
{	char *p;

	conds[0] = trues[0] = falses[0] = 0;
	if( p = scanchr(condexp,'?',conds) )
	if( p = scanchr(p,':',trues) )
		scanchr(p,'\0',falses);
}
static scanexp2(exp,dch,left,right)
	char *exp,*left,*right;
{	char *p;

	left[0] = right[0] = 0;
	if( p = scanchr(exp,dch,left) )
		scanchr(p,'\0',right);
}
static cond1(Conn,curl,outfp,conds,func,arg)
	Connection *Conn;
	char *curl;
	FILE *outfp;
	char *conds;
	int (*func)();
	char *arg;
{	char *dp,dch;
	char val1s[1024],val2s[1024];
	int val1,val2;

	if( dp = strpbrk(conds,"<=") ){
		dch = *dp;
		scanexp2(conds,dch,val1s,val2s);
		if( isdigits(val1s) )
			val1 = atoi(val1s);
		else	val1 = call_func(Conn,curl,NULL,val1s,func,arg);
		if( isdigits(val2s) )
			val2 = atoi(val2s);
		else	val2 = call_func(Conn,curl,NULL,val2s,func,arg);
		switch( dch ){
			case '<': return val1 < val2;
			case '=': return val1 == val2;
		}
		return 0;
	}else	return call_func(Conn,curl,NULL,conds,func,arg);
}

static eval1(Conn,curl,outfp,item,func,arg,exitlevp)
	Connection *Conn;
	char *curl;
	FILE *outfp;
	char *item;
	int (*func)();
	char *arg;
	int *exitlevp;
{	char *dp;
	char conds[4096],trues[4096],falses[4096];

	if( dp = strchr(item,'?') ){
		scancond(item,conds,trues,falses);
		if( cond1(Conn,curl,outfp,conds,func,arg) )
			eval_DHTML(Conn,curl,outfp,trues,func,arg,exitlevp);
		else	eval_DHTML(Conn,curl,outfp,falses,func,arg,exitlevp);
	}else{
		return call_func(Conn,curl,outfp,item,func,arg,exitlevp);
	}
}

eval_DHTML(Conn,curl,outfp,str,func,farg,exitlevp)
	Connection *Conn;
	char *curl;
	FILE *outfp;
	char *str;
	int (*func)();
	char *farg;
	int *exitlevp;
{	char *sp,*dp,*ctag;
	int pch,ch;
	int leng = 0;
	int col;
	int tlen,len1;
	DTag *dt;
	char *arg = "";
	char argb[0x8000];

	col = 0;
	pch = 0;
	for( sp = str; ch = *sp; sp++ ){
		if( col == 0 && ch == '#' ){
			for( sp++; sp[1]; sp++ ){
				ch = *sp;
				if( ch == '\n' )
					break;
				if( ch == '\r' && sp[1] == '\n' ){
					sp++;
					break;
				}
			}
			continue;
		}
		col++;

		if( ch == '\\' && RESERVED_CH(sp[1]) ){
			ch = sp[1];
			sp += 1;
			goto PUT1;
		}else
		if( ch == '\\' && sp[1] == '\n' ){
			sp += 1;
			continue;
		}else
		if( ch == '\\' && sp[1] == '\r' && sp[2] == '\n' ){
			sp += 2;
			continue;
		}else
		if( ch == '$' && sp[1] == '{' ){
		    if( strncmp(sp,"${exit}",7) == 0 ){
			*exitlevp = 1;
			break;
		    }else
		    if( strncmp(sp,"${NL}",5) == 0 ){
			ch = '\n';
			sp += 4;
		    }else
		    if( dp = scanitem(sp+2) ){
			*dp = 0;
			if( func != NULL ){
				eval1(Conn,curl,outfp,sp+2,func,farg,exitlevp);
				if( 0 < *exitlevp ){
					*exitlevp -= 1;
					break;
				}
			}
			sp = dp;
			continue;
		    }
		}else
		if( ch == '<' && strncasecmp(sp+1,"X-D ",4) == 0 ){
		    ctag = sp+5;
		    if( dp = strchr(ctag,'>') ){
			int ti; char *tag;
			for( ti = 0; tag = dhtml_tags[ti].tag; ti++ ){
				tlen = strlen(tag);
				if( strncasecmp(ctag,tag,tlen) == 0 ){
					arg = ctag+tlen;
					while( *arg == ' ' )
						*arg++;
					strncpy(argb,arg,dp-arg);
					argb[dp-arg] = 0;
					break;
				}
			}
			if( tag ){
				dt = &dhtml_tags[ti];
				ENCODE_ENT1 = 1;
				len1 = (*dt->func)(Conn,outfp,argb);
				ENCODE_ENT1 = 0;
				if( 0 <= len1 ){
					leng += len1;
					sp = dp;
					continue;
				}
			}
		    }
		}
		if( ch == '\n' && pch != '\r' ){
			putc('\r',outfp);
			leng += 1;
			col = 0;
		}
PUT1:
		putc(ch,outfp);
		pch = ch;
		leng += 1;
	}
	return leng;
}


extern int TOTAL_SERVED;
extern char *HTTP_getIconBase();
extern char *start_time();
extern char *DELEGATE_Distribution();
extern char *VA_getOriginatorIdent();

DHTML_printConn(Conn,fp,fmt,name,arg,value)
        Connection *Conn;
        FILE *fp;
        char *fmt,*name,*arg;
	char *value;
{	char hostport[256],stime[128];
	char url[URLSZ];

	if( streq(name,"no-robots") ){
		DHTML_printNoRobots(Conn,fp,fmt,name,arg,value);
	}else
	if( streq(name,"services") ){
		prservices(fp);
	}else
	if( streq(name,"mtab") ){
		return DHTML_printMount(Conn,fp,fmt,name,arg,value);
	}else
	if( streq(name,"auth") ){
		return DHTML_printAuth(Conn,fp,fmt,name,arg,value);
	}else
	if( streq(name,"client") ){
		if( streq(arg,"host") ){
			getpeerName(ClientSock,hostport,PN_HOST);
			fputs(hostport,fp);
		}else
		if( streq(arg,"ident") ){
			char *ouser;
			AuthInfo ident;
			if( ouser = VA_getOriginatorIdent(Conn,&ident) )
				fputs(ouser,fp);
		}else
		if( streq(arg,"ifhp") ){
			ClientIF_HPname(Conn,hostport);
			fputs(hostport,fp);
		}else
		if( streq(arg,"peersessions") ){
			fprintf(fp,"%d",Conn->cl_count);
		}else
		if( streq(arg,"requestserno") ){
			fprintf(fp,"%d",RequestSerno);
		}else
		if( streq(arg,"useragent") ){
			char *dp;
			HTTP_getRequestField(Conn,"User-Agent",url,sizeof(url));
			if( dp = strstr(url,"MSIE ") )
			if( dp != url ){
				strcpy(url,dp);
				if( dp = strrchr(url,')') )
					*dp = 0;
			}
			fputs(url,fp);
		}
	}else
	if( streq(name,"moved") ){ /* printMoved */
		if( streq(arg,"url") )
			if( value != NULL )
				fputs(value,fp);
	}else
	if( streq(name,"ver") ){
		fputs(DELEGATE_ver(),fp);
	}else
	if( streq(name,"verdate") ){
		fprintf(fp,"%s",DELEGATE_verdate());
	}else
	if( streq(name,"Version") ){
		fputs(DELEGATE_Version(),fp);
	}else
	if( streq(name,"copyright") ){
		fputs(DELEGATE_copyright(),fp);
	}else
	if( streq(name,"homepage") ){
		fputs(DELEGATE_homepage(),fp);
	}else
	if( streq(name,"icon") ){
		if( streq(arg,"delegate") )
			fprintf(fp,"%s%s",HTTP_getIconBase(Conn),
				"ysato/DeleGateLogoTrans.gif");
		else
		if( streq(arg,"frog") )
			fprintf(fp,"%s%s",HTTP_getIconBase(Conn),
				"ysato/frog.gif");
		else
		if( streq(arg,"froghead") )
			fprintf(fp,"%s%s",HTTP_getIconBase(Conn),
				"ysato/frogHead.gif");
		else{
			fprintf(fp,"%sysato/%s.gif",HTTP_getIconBase(Conn),arg);
		}
	}else
	if( streq(name,"time") ){
		if( streq(arg,"now") ){
			StrftimeLocal(stime,sizeof(stime),
				TIMEFORM_HTTPD,time(0));
			fputs(stime,fp);
		}else
		if( streq(arg,"start") )
			fputs(start_time(),fp);
	}else
	if( streq(name,"load") ){
		if( streq(arg,"total") )
			strfLoadStat(url,128,"%L",time(NULL));
		else
		if( streq(arg,"recent") )
			strfLoadStat(url,128,"%l",time(NULL));
		else	url[0] = 0;
		fputs(url,fp);
	}else
	if( streq(name,"num") ){
		if( streq(arg,"serno") )
			fprintf(fp,"%d",SERNO());
		else
		if( streq(arg,"peers") )
			fprintf(fp,"%d",alive_peers());
		else
		if( streq(arg,"served") )
			fprintf(fp,"%d",TOTAL_SERVED);
	}else
	if( streq(name,"host") ){
		if( streq(arg,"clif") ){
			ClientIF_name(Conn,FromC,hostport);
			fputs(hostport,fp);
		}
	}else
	if( streq(name,"hostport") ){
		if( streq(arg,"client") ){
/*
			getpeerName(ClientSock,hostport,PN_HOSTPORT);
*/
			strfConn(Conn,"%h:%p",hostport);
			fputs(hostport,fp);
		}else
		if( streq(arg,"clif") ){
			ClientIF_HPname(Conn,hostport);
			fputs(hostport,fp);
		}
	}else
	if( streq(name,"request") ){
		if( streq(arg,"mssg") )
			HTTP_fprintmsg(Conn,fp,"om");
		else
		if( streq(arg,"line") )
			HTTP_fprintmsg(Conn,fp,"ol");
		else
		if( streq(arg,"url") ){
			HTTP_originalURLx(Conn,url,sizeof(url));
			if( strncmp(url,"/-_-",4) == 0 )
				put1s(fp,"%s",url+4);
			else	put1s(fp,"%s",url);
		}
	}else
	if( streq(name,"server") ){
		char *server;
		server = D_SERVER;
		if( streq(arg,"name") )
			put1s(fp,"%s",server);
		else
		if( streq(arg,"host") )
			put1s(fp,"%s",DST_HOST);
		else
		if( streq(arg,"port") )
			fprintf(fp,"%d",DST_PORT);
		else
		if( streq(arg,"url") ){
			redirect_url(Conn,server,url);
			put1s(fp,"%s",url);
		}
	}else
	if( streq(name,"expire") )
		fprintf(fp,"%d",http_EXPIRE(Conn));
	else
	if( streq(name,"getccx") ){
		char code[128];
		if( CTX_cur_codeconvCL(Conn,code) )
			return 1;
		else	return 0;
	}else
	if( streq(name,"setccx") ){
		char code[128],stat[128];
		if( CTX_cur_codeconvCL(Conn,code) ){
			global_setCCX(Conn,code,stat);
			fprintf(fp,"\"%s\" %s",code,stat);
		}
	}else
	if( streq(name,"codeconv") ){
		char cvenv[128];
		CTX_cur_codeconvCL(Conn,cvenv);
		fprintf(fp,"%s",cvenv);
	}else
	if( streq(name,"ADMIN") )
		fprintf(fp,"%s",DELEGATE_ADMIN);
	else
	if( streq(name,"forbidden") ){
		if( streq(arg,"reason") ){
			fprintf(fp,"%s",Conn->reject_reason);
		}
	}else
	if( streq(name,"cantconn") ){
		if( streq(arg,"rejected") )
			return ConnError & CO_REJECTED;
		if( streq(arg,"unknown") )
			return ConnError & CO_CANTRESOLV;
		if( streq(arg,"timeout") )
			return ConnError & CO_TIMEOUT;
		if( streq(arg,"refused") )
			return ConnError & CO_REFUSED;
		if( streq(arg,"unreach") )
			return ConnError & CO_UNREACH;
		if( streq(arg,"noroute") )
			return ConnError & CO_NOROUTE;
		return 0;
	}
	else
	if( streq(name,"delegate") ){
		if( streq(arg,"icons") ){
			redirect_url(Conn,HTTP_getIconBase(Conn),url);
			fputs(url,fp);
		}else
		if( streq(arg,"home") ){
			fputs(DELEGATE_homepage(),fp);
		}else
		if( streq(arg,"homeurl") ){
			redirect_url(Conn,DELEGATE_homepage(),url);
			fputs(url,fp);
		}else
		if( streq(arg,"ftp") ){
			fputs(DELEGATE_Distribution(),fp);
		}else
		if( streq(arg,"ftpurl") ){
			redirect_url(Conn,DELEGATE_Distribution(),url);
			fputs(url,fp);
		}
	}
}
put_eval_dhtml(Conn,url,outfp,instr)
	Connection *Conn;
	char *url;
	FILE *outfp;
	char *instr;
{	int exitlev;

	exitlev = 0;
	return eval_DHTML(Conn,url,outfp,instr,DHTML_printConn,NULL,&exitlev);
}
