/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	filetype.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950707	extracted from ftpgw.c
//////////////////////////////////////////////////////////////////////#*/
#include "ystring.h"

typedef struct {
	char	*suffix;
	char	 gtype;
	char	*ialt;
	char	*icon;
	char	*ctype;
} Filetype;

typedef struct {
	Filetype *fe_filetypes[128];
	int	fe_filetypex;
	char	fe_iconbuf[128];
	int	fe_initdone;
} FiletypeEnv;
static FiletypeEnv *filetypeEnv;
#define filetypes	filetypeEnv->fe_filetypes
#define filetypex	filetypeEnv->fe_filetypex
#define iconbuf		filetypeEnv->fe_iconbuf
#define initdone	filetypeEnv->fe_initdone
minit_filetype()
{
	if( filetypeEnv == 0 )
		filetypeEnv = NewStruct(FiletypeEnv);
}

static char *dflt_filetypes[] = {
	".txt    :0 :TXT :text       :text/plain",
	".c      :0 :TXT :text       :text/plain",
	".curl   :0 :TXT :text       :text/vnd.curl",
	".cur    :0 :TXT :text       :text/vnd.curl",
	".h      :0 :TXT :text       :text/plain",
	".doc    :0 :TXT :text       :application/octet-stream",
	".html   :0 :HTM :text       :text/html",
	".dhtml  :0 :HTM :text       :text/html",
	".htm    :0 :HTM :text       :text/html",
	".ps     :0 :PS  :document   :application/postscript",
	".ppt    :I :PPT :document   :application/vnd.ms-powerpoint",
	".ico    :I :ICO :image      :image/x-icon",
	".xbm    :I :XBM :image      :image/x-xbitmap",
	".gif    :g :GIF :image      :image/gif", 
	".png    :I :PNG :image      :image/png",
	".jpg    :I :JPG :image      :image/jpeg",
	".mpg    :I :MPG :movie      :video/mpeg",
	".mov    :I :MOV :movie      :video/quicktime",
	".avi    :I :MOV :movie      :video/avi",
	".au     :9 :AUD :sound      :audio/basic",
	".tar    :9 :TAR :tar        :application/octet-stream",
	".uu     :6 :UUE :uu         :application/octet-stream",
	".gz     :9 :ZIP :gzip       :application/octet-stream",
	".Z      :9 :CMP :compressed :application/octet-stream",
	".hqx    :4 :HQX :binhex     :application/mac-binhex40",
	".bat    :0 :BAT :text       :text/plain",
	".exe    :9 :EXE :binary     :application/octet-stream",
	".dll    :9 :DLL :binary     :application/octet-stream",
	".pac    :0 :PAC :text       :application/x-ns-proxy-autoconfig",
	"README  :0 :TXT :text       :text/plain",
	"INDEX   :0 :TXT :text       :text/plain",
	"HELP    :0 :TXT :text       :text/plain",
	"/       :1 :DIR :directory  :text/html",
	0
};

scan_FILETYPE(_,filetype)
	char *_;
	char *filetype;
{	char suffix[64],gtype[64],alt[64],icon[64],ctype[64],str[64];
	int nitem;
	Filetype *ft;

	nitem = sscanf(filetype,"%[^:]:%[^:]:%[^:]:%[^:]:%[^:]",
		suffix,gtype,alt,icon,ctype);
	if( 5 <= nitem ){
		ft = NewStruct(Filetype);
		filetypes[filetypex++] = ft;
		wordScan(suffix,str); ft->suffix = StrAlloc(str);
		wordScan(gtype,str);  ft->gtype  = str[0];
		wordScan(alt,str);    ft->ialt   = StrAlloc(str);
		wordScan(icon,str);   ft->icon   = StrAlloc(str);
		wordScan(ctype,str);  ft->ctype  = StrAlloc(str);
	}else{
		printf("??FILETYPE=\"%s\"??\n",filetype);
	}
	return 0;
}

static init_types()
{	int fx;
	char *filetype;

	if( initdone++ != 0 )
		return;

	for( fx = 0; filetype = dflt_filetypes[fx]; fx++ )
		scan_FILETYPE(0L,filetype);
}
static suffix(path,sfx)
	char *path,*sfx;
{	char *sp;
	int len;

	if( sp = strcasestr(path,sfx) ){
		len = strlen(sfx);
		if( sp[len] == 0 ) return 1;
		if( sp[len] == '~' && sp[len+1] == 0 ) return 1;
	}
	return 0;
}
char *filename2ctype(path)
	char *path;
{	int ci;
	Filetype *ft;

	init_types();
	for( ci = 0; ft = filetypes[ci]; ci++ ){
		if( suffix(path,ft->suffix) )
			return ft->ctype;
	}
	return 0;
}
filename2gtype(name)
	char *name;
{	int ci;
	Filetype *ft;

	init_types();
	for( ci = 0; ft = filetypes[ci]; ci++ ){
		if( suffix(name,ft->suffix) )
			return ft->gtype;
	}
	return '9';
}
char *filename2icon(path,ialt)
	char *path,**ialt;
{	int ci;
	Filetype *ft;

	init_types();
	for( ci = 0; ft = filetypes[ci]; ci++ ){
		if( suffix(path,ft->suffix) ){
			if( ialt ) *ialt = ft->ialt;
			strcpy(iconbuf,ft->icon);
			goto EXIT;
		}
	}
	if( path[0] == 0
	 || path[strlen(path)-1] == '/'
	 || strcmp(path,".") == 0
	 || strcmp(path,"..") == 0
	){
		if( ialt ) *ialt = "DIR";
		strcpy(iconbuf,"directory");
	}else{
		if( ialt ) *ialt = "UNK";
		strcpy(iconbuf,"unknown");
	}
EXIT:
	strcat(iconbuf,".gif");
	return iconbuf;
}

fileMaybeText(path)
	char *path;
{	char *ctype;

	if( ctype = filename2ctype(path,0L) )
		if( strncasecmp(ctype,"text/",5) != 0 )
			return 0;
	return 1;
}
