/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997-1999 Yutaka Sato
Copyright (c) 1997-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	env.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970814	extracted from delegated.c
//////////////////////////////////////////////////////////////////////#*/
#include "config.h"
#include "param.h"
#include "delegate.h"

extern char **environ;
extern char *getenv();
extern char *getv();

int  main_argc;
char **main_argv;

typedef struct {
	int   ee_ext_argc;
	char *ee_ext_argv[MAX_ARGC];
	int   ee_extovw_argc;
	char *ee_extovw_argv[MAX_ARGC];
	int   ee_gen_envx;
	char *ee_gen_environ[32];
	char *ee_ext_environ[MAX_ARGC];
} Envs;
static Envs *envs;
#define ext_argc	envs->ee_ext_argc
#define ext_argv	envs->ee_ext_argv
#define extovw_argc	envs->ee_extovw_argc
#define extovw_argv	envs->ee_extovw_argv
#define gen_envx	envs->ee_gen_envx
#define gen_environ	envs->ee_gen_environ
#define ext_environ	envs->ee_ext_environ
minit_envs(){
	if( envs == 0 )
		envs = NewStruct(Envs);
}

int DELEGATE_EXTOVW;
DELEGATE_clearEnv()
{
	extovw_argc = 0;
}
char *DELEGATE_getEnv(name)
	char *name;
{	char *value;

	if( value = getv(gen_environ,name) )
		return value;
	if( value = getv(extovw_argv,name) )
		return value;
	if( value = getv(main_argv,name) )
		return value;
	if( value = getv(ext_argv,name) )
		return value;
	return getenv(name);
}
DELEGATE_copyEnv(av,ac,path,abuff)
	char *av[],*path,*abuff;
{	int ai;
	char hosts[0x4000],port[256];
	char *ap;

	ap = abuff;

	if( lVERB() ){
		av[ac++] = "-vv";
	}
	else{
		printServPort(port,"",0);
/*
		sprintf(ap,"%s=%s++",P_LOGFILE,port);
*/
		sprintf(ap,"%s=%s",P_LOGFILE,port);
		av[ac++] = ap;  ap += strlen(ap) + 1;
	}

	sprintf(ap,"%s=%s",P_EXEC_PATH,path);
	av[ac++] = ap; ap += strlen(ap) + 1;

	for( ai = 0; ai < ext_argc; ai++ )
		av[ac++] = ext_argv[ai];

	for( ai = 1; ai < main_argc; ai++ )
		if( main_argv[ai] )
			av[ac++] = main_argv[ai];

	for( ai = 0; ai < extovw_argc; ai++ )
		av[ac++] = extovw_argv[ai];

	for( ai = 0; ai < gen_envx; ai++ )
		av[ac++] = gen_environ[ai];

	if( dump_HOSTS(hosts) ){
		sprintf(ap,"%s=%s",P_HOSTS,hosts);
		Verbose("%s\n",ap);
		av[ac++] = ap; ap += strlen(ap) + 1;
	}
	return ac;
}
DELEGATE_copyEnvPM(dav,name)
	char *dav[],*name;
{	int ac;

	ac = 0;
	ac += copy_param(name,&dav[ac],environ);
	ac += copy_param(name,&dav[ac],ext_argv);
	ac += copy_param(name,&dav[ac],&main_argv[1]);
	ac += copy_param(name,&dav[ac],gen_environ);
	return ac;
}

dump_main(ac,av)
	char *av[];
{	int ai;
	char *nam,*val,valb[256];

	for( ai = 1; ai < ac; ai++ ){
		nam = av[ai];
		if( strcmp(nam,"DGROOT") == 0 ){
			val = DELEGATE_DGROOT;
		}else
		if( strcmp(nam,"OWNER") == 0 ){
			sprintf(valb,"#%d/#%d",getuid(),getgid());
			val = valb;
		}else{
			val = DELEGATE_getEnv(nam);
		}
		printf("%s\n",val?val:"(none)");
	}
	exit(0);
}

/*
static char *getEnvT(name)
	char *name;
{	char *body;
	if( body = getEnv(name) )
		if( body[-1] == '=' )
			return body - strlen(name) - 1;
		else	return body - strlen(name);
	return 0;
}
*/

DELEGATE_addEnvExt(env)
	char *env;
{
	if( lVERB() || lARGDUMP() ){
		if( DELEGATE_EXTOVW )
			fprintf(stderr,"<%d> %s\n",extovw_argc,env);
		else	fprintf(stderr,"<%d> %s\n",ext_argc,env);
	}
	if( DELEGATE_EXTOVW )
		extovw_argv[extovw_argc++] = StrAlloc(env);
	else	ext_argv[ext_argc++] = StrAlloc(env);
}
DELEGATE_pushEnv(name,value)
	char *name,*value;
{	char env[1024];

	sprintf(env,"%s=%s",name,value);
	gen_environ[gen_envx++] = StrAlloc(env);
}
typedef struct {
	Connection *sv_Conn;
	int	(*sv_func)();
	char	*sv_arg;
	int	sv_ign_include;
} SvArg;
static scanenv1(sva,val)
	SvArg *sva;
	char *val;
{
	if( strncmp(val,INC_SYM,INC_SYM_LEN) == 0 )
		return 0;
	if( strstr(val,":+=") || strstr(val,",+=") )
		return 0;
	else	return (*sva->sv_func)(sva->sv_Conn,val,sva->sv_arg);
}
DELEGATE_scanEnv(Conn,name,func,arg)
	Connection *Conn;
	char *name;
	int (*func)();
	char *arg;
{	int nhit;
	SvArg sva;

	nhit = 0;
	sva.sv_Conn = Conn;
	sva.sv_func = func;
	sva.sv_arg = arg;
	nhit += scanv(environ,name,scanenv1,&sva);
	nhit += scanv(ext_argv,name,scanenv1,&sva);
	nhit += scanv(main_argv,name,scanenv1,&sva);
	nhit += scanv(extovw_argv,name,scanenv1,&sva);
	nhit += scanv(gen_environ,name,scanenv1,&sva);
	return nhit;
}

#define CFput(fp,fmt,ai,msg) {\
	if( fp != NULL ) fprintf(fp,fmt,ai,msg); else sv0log(fmt,ai,msg); \
	leng += strlen(msg); \
}
DELEGATE_dumpEnv(fp,genalso,imPM)
	FILE *fp;
{	int ai;
	char *env;
	int leng = 0;

	if( fp != NULL && !imPM ){
		char port[128];
		printServPort(port,"-P",genalso);
		fprintf(fp,"%s\n",port);
	}

	for( ai = 0; env = environ[ai]; ai++ )
	if( 0 <= check_param(env,0) )
		CFput(fp,"env[%d] %s\n",ai,env);

	for( ai = 0; ai < ext_argc; ai++ )
		CFput(fp,"ext[%d] %s\n",ai,ext_argv[ai]);

	for( ai = 1; ai < main_argc; ai++ )
	if( 0 <= check_param(main_argv[ai],0) )
		CFput(fp,"arg[%d] %s\n",ai,main_argv[ai]);

	if( genalso )
	for( ai = 0; gen_environ[ai]; ai++ )
		CFput(fp,"gen[%d] %s\n",ai,gen_environ[ai]);

	return leng;
}


/*
 * inporting configuration parameters
 */
int param_file = -1;
int param_mtime = 0;

new_param_file(path)
	char *path;
{	FILE *fp,*TMPFILE();

	if( 0 <= param_file )
		return;
	fp = TMPFILE("PARAM_FILE");
	/*
	 * it should be a visible file under ETCDIR or ADMDIR ...
	 */
	param_file = dup(fileno(fp));
	fclose(fp);
	param_mtime = file_mtime(param_file);
}
add_params(Conn,tc,command)
	Connection *Conn;
	FILE *tc;
	char *command;
{	FILE *fp;
	int pid;
	char com[1024],param[1024];

	/*
	 * must check accees right here...
	 */

	if( param_file < 0 ){
		fprintf(tc,"500 no parameter file\r\n");
		return -1;
	}

	com[0] = param[0] = 0;
	sscanf(command,"%s %[^\r\n]",com,param);

	/*
	 * param may be +=URL
	 */

	if( com[0] == 0 || param[0] == 0 ){
		fp = fdopen(dup(param_file),"r");
		fseek(fp,0,0);
		fputs("200 list of inported parameters follows:\r\n",tc);
		copyfile1(fp,tc);
		fputs(".\r\n",tc);
		fclose(fp);
		return 0;
	}
	if( check_param(param,0) < 0 ){
		fprintf(tc,"500 unknown parameter: %s\r\n",param);
		return -1;
	}
	if( lock_exclusiveTO(param_file,2000,NULL) != 0 ){
		fprintf(tc,"500 cannot lock parameter file\r\n");
		return -1;
	}
	pid = getpid();
	fp = fdopen(dup(param_file),"w");
	fprintf(fp,"%d %s\r\n",pid,param);
	fclose(fp);

	sv1log("#### PARAM INPORTED: %d %s\n",pid,param);
	fprintf(tc,"200 ok.\r\n");
	return 0;
}
load_params(Conn)
	Connection *Conn;
{	FILE *fp;
	char line[1024],param[1024];
	int mtime,pid;

	if( param_file < 0 )
		return;
	mtime = file_mtime(param_file);
	if( mtime == param_mtime )
		return;
	param_mtime = mtime;
	sv1log("#### PARAM updated\n");

	fp = fdopen(dup(param_file),"r");
	fseek(fp,0,0);
	while( fgets(line,sizeof(line),fp) ){
		sscanf(line,"%d %[^\r\n]",&pid,param);
		sv1log("#### %d %s\n",pid,param);
		if( strncmp(param,"MOUNT=",6) == 0 ){
			scan_MOUNT(Conn,param+6);
			init_mtab();
		}
	}
	fclose(fp);
}


extern int DELAY_REJECT_S;
extern int DELAY_UNKNOWN_S;
extern int DELAY_REJECT_P;
extern int DELAY_UNKNOWN_P;
extern int DELAY_ERROR;

static delay1(dspec)
	char *dspec;
{	char what[128];
	int delay;
	int *iaddr;

	delay = 0;
	sscanf(dspec,"%[^:]:%d",what,&delay);

	iaddr = 0;
	if( strcaseeq(what,"reject")    ) iaddr = &DELAY_REJECT_S; else
	if( strcaseeq(what,"unknown")   ) iaddr = &DELAY_UNKNOWN_S; else
	if( strcaseeq(what,"reject_p")  ) iaddr = &DELAY_REJECT_P; else
	if( strcaseeq(what,"unknown_p") ) iaddr = &DELAY_UNKNOWN_P; else
	if( strcaseeq(what,"error")     ) iaddr = &DELAY_ERROR; else
	{
		sv1tlog("ERROR: unknown DELAY=%s\n",what);
	}
	if( iaddr ){
		xmem_push(iaddr,sizeof(int),"DELAY",NULL);
		*iaddr = delay;
	}
	return 0;
}
scan_DELAY(Conn,sdelay)
	Connection *Conn;
	char *sdelay;
{
	scan_commaList(sdelay,0,delay1);
}

extern int MAX_ERESTART;
extern int MAX_DELEGATE;
extern int MAX_SERVICE;
extern int STANDBY_MAX;
extern int FDSET_MAX;
extern int HTTP_CKA_MAXREQ;
extern int HTTP_CKA_PERCLIENT;
extern int MAX_CC;
extern int MAXCONN_PCH;
extern int MAX_BUFF_SOCKRECV;
extern int MAX_BUFF_SOCKSEND;
extern int RANDSTACK_RANGE;
extern int RANDSTACK_UNIT;
extern int RANDFD_RANGE;
extern int RANDENV_RANGE;
extern int UDPRELAY_MAXASSOC;
extern int WIN_MTU;

static maxima1(maxima)
	char *maxima;
{	char name[128];
	int num;
	int *addr;

	if( sscanf(maxima,"%[^:]:%d",name,&num) != 2 ){
		ERRMSG("DeleGate/%s: ERROR syntax MAXIMA=%s\n",
			DELEGATE_ver(),maxima);
		return 0;
	}

	addr = 0;
	if( streq(name,"erestart") )	addr = &MAX_ERESTART; else
	if( streq(name,"randstack") )	addr = &RANDSTACK_RANGE; else
	if( streq(name,"randfd") )	addr = &RANDFD_RANGE; else
	if( streq(name,"randenv") )	addr = &RANDENV_RANGE; else
	if( streq(name,"fdset") )	addr = &FDSET_MAX; else
	if( streq(name,"delegated") )	addr = &MAX_DELEGATE; else
	if( streq(name,"standby") )     addr = &STANDBY_MAX; else
	if( streq(name,"ftpcc") )	addr = &MAX_CC; else
	if( streq(name,"nntpcc") )	addr = &MAX_CC; else
	if( streq(name,"svcc") )	addr = &MAX_CC; else
	if( streq(name,"listen") )	addr = &DELEGATE_LISTEN; else
	if( streq(name,"sockrecv") )	addr = &MAX_BUFF_SOCKRECV; else
	if( streq(name,"socksend") )	addr = &MAX_BUFF_SOCKSEND; else
	if( streq(name,"winmtu") )	addr = &WIN_MTU; else
	if( streq(name,"service") )	addr = &MAX_SERVICE; else
	if( streq(name,"conpch") )	addr = &MAXCONN_PCH; else
	if( streq(name,"http-cka") )	addr = &HTTP_CKA_MAXREQ; else
	if( streq(name,"http-ckapch") )	addr = &HTTP_CKA_PERCLIENT; else
	if( streq(name,"udprelay") )	addr = &UDPRELAY_MAXASSOC; else
	{

		ERRMSG("DeleGate/%s: ERROR unknown MAXIMA=%s\n",
			DELEGATE_ver(),maxima);
	}

	if( addr ){
		xmem_push(addr,sizeof(int),"MAXIMA",NULL);
		*addr = num;
	}
	return 0;
}
scan_MAXIMA(Conn,maxima)
	Connection *Conn;
	char *maxima;
{
	scan_commaList(maxima,0,maxima1);
}

extern int SHUTOUT_TIMEOUT;
extern int DNS_TIMEOUT;
extern int ACC_TIMEOUT;
extern int CON_TIMEOUT;
extern int LIN_TIMEOUT;
extern int IO_TIMEOUT;
extern int CC_TIMEOUT_FTP;
extern int CC_TIMEOUT_NNTP;
extern int CACHE_TAKEOVER;
extern int RSLV_INV_TIMEOUT;
extern int SILENCE_TIMEOUT; /* no transmission from server or client */
extern int HELLO_TIMEOUT;
extern int VSAP_TIMEOUT;
extern int ERROR_RESTART;
extern int SERVER_RESTART;
extern int SERVER_TIMEOUT;
extern int STANDBY_TIMEOUT;
extern double HTTP_WAIT_REQBODY;
extern double HTTP_TOUT_IN_REQBODY;
extern double HTTP_TOUT_CKA;
extern double HTTP_TOUT_CKA_MARGIN;
extern double SVHELLO_TIMEOUT;
extern double IDENT_TIMEOUT;
extern double CFISTAT_TIMEOUT;

extern double Scan_period();
static timeout1(to)
	char *to;
{	char name[128],period[128];
	double secs;
	double *daddr;
	int *iaddr;

	if( sscanf(to,"%[^:]:%s",name,period) == 2 ){
		secs = Scan_period(period,'s',(double)0);
		daddr = 0;
		iaddr = 0;

		if( streq(name,"shutout"))   iaddr = &SHUTOUT_TIMEOUT; else
		if( streq(name,"hello"))     iaddr = &HELLO_TIMEOUT; else
		if( streq(name,"login"))     iaddr = &LOGIN_TIMEOUT; else
		if( streq(name,"dns") )	     iaddr = &DNS_TIMEOUT; else
		if( streq(name,"dnsinv") )   iaddr = &RSLV_INV_TIMEOUT; else
		if( streq(name,"vsapacc"))   iaddr = &VSAP_TIMEOUT; else
		if( streq(name,"acc") )	     iaddr = &ACC_TIMEOUT; else
		if( streq(name,"con") )	     iaddr = &CON_TIMEOUT; else
		if( streq(name,"lin") )	     iaddr = &LIN_TIMEOUT; else
		if( streq(name,"greeting"))  daddr = &SVHELLO_TIMEOUT; else
		if( streq(name,"ident"))     daddr = &IDENT_TIMEOUT; else
		if( streq(name,"rident"))    daddr = &RIDENT_TIMEOUT; else
		if( streq(name,"cfistat"))   daddr = &CFISTAT_TIMEOUT; else
		if( streq(name,"silence"))   iaddr = &SILENCE_TIMEOUT; else
		if( streq(name,"io") )	     iaddr = &IO_TIMEOUT; else
		if( streq(name,"idle"))	     iaddr = &IO_TIMEOUT; else
		if( streq(name,"restart"))   iaddr = &SERVER_RESTART; else
		if( streq(name,"erestart"))  iaddr = &ERROR_RESTART; else
		if( streq(name,"daemon"))    iaddr = &SERVER_TIMEOUT; else
		if( streq(name,"standby")  ) iaddr = &STANDBY_TIMEOUT; else
		if( streq(name,"takeover"))  iaddr = &CACHE_TAKEOVER; else
		if( streq(name,"ftpcc"))     iaddr = &CC_TIMEOUT_FTP; else
		if( streq(name,"nntpcc"))    iaddr = &CC_TIMEOUT_NNTP; else

	if( streq(name,"http-wait-qbody"))   daddr = &HTTP_WAIT_REQBODY; else
	if( streq(name,"http-poll-qbody"))   daddr = &HTTP_TOUT_IN_REQBODY; else
	if( streq(name,"http-cka"))          daddr = &HTTP_TOUT_CKA; else
	if( streq(name,"http-ckamg"))        daddr = &HTTP_TOUT_CKA_MARGIN; else
		{
			sv1tlog("ERROR: unknown TIMEOUT=%s\n",name);
		}

		if( daddr ){
			xmem_push(daddr,sizeof(double),"TIMEOUT",NULL);
			*daddr = secs;
		}
		if( iaddr ){
			xmem_push(iaddr,sizeof(int),"TIMEOUT",NULL);
			*iaddr = secs;
		}
	}
	if( SERVER_TIMEOUT )
	if( SERVER_TIMEOUT < ACC_TIMEOUT || ACC_TIMEOUT == 0 )
		ACC_TIMEOUT = SERVER_TIMEOUT;

	return 0;
}
scan_TIMEOUT(Conn,timeouts)
	Connection *Conn;
	char *timeouts;
{
	scan_commaList(timeouts,0,timeout1);
}

typedef int (*IFUNC)();
typedef struct {
	char	*m_addr;
	int	 m_size;
	char	*m_save;
	char	*m_what;
	IFUNC	 m_func;
} Memory;

#define MAXLEV 8
typedef struct {
	Memory	*s_mem;
	int	 s_siz;
	int	 s_top;
} Stack;

static Stack mstack[MAXLEV];

extern char *realloc();
extern char *calloc();
extern char *malloc();

#define mdebug	!lMEMPUSH() ? 0 : putLog0

mem_push(lev,addr,size,what,func)
	char *addr;
	char *what;
	IFUNC func;
{	Stack *St;
	Memory *Me;
	int siz,top,mi;

	St = &mstack[lev];
	if( St->s_siz <= St->s_top ){
		siz = St->s_siz = St->s_siz + 32;
		if( St->s_siz ){
			St->s_mem = (Memory*)realloc(St->s_mem,siz*sizeof(Memory));
			for( mi = St->s_top; mi < siz; mi++ )
				St->s_mem[mi].m_save = 0;
		}else	St->s_mem = (Memory*)calloc(siz,sizeof(Memory));
	}
	top = St->s_top++;
	Me = &St->s_mem[top];
	if( Me->m_save != 0 ){
		if( Me->m_size < size ){
			free(Me->m_save);
			Me->m_save = 0;
		}
	}
	if( Me->m_save == 0 )
		Me->m_save = malloc(size);
	Me->m_addr = addr;
	Me->m_size = size;
	Me->m_what = what;
	Me->m_func = func;
	bcopy(addr,Me->m_save,size);

	mdebug("{m} PUSH[%d][%d] %X -> %X (%d) %s\n",lev,top,
		Me->m_addr,Me->m_save,Me->m_size,Me->m_what);
	return top;
}
mem_pop1(lev)
{	Stack *St;
	Memory *Me;
	int mi;
	int (*func)();
	int diff;

	St = &mstack[lev];
	for( mi = St->s_top-1; 0 <= mi; mi-- ){
		Me = &St->s_mem[mi];
		diff = bcmp(Me->m_save,Me->m_addr,Me->m_size);
		if( func = Me->m_func )
			(*func)(Me->m_save,Me->m_addr,Me->m_size,Me->m_what);
		else	bcopy(Me->m_save,Me->m_addr,Me->m_size);

		mdebug("{m} POP%s[%d][%d] %X <- %X (%d) %s\n",diff?"!":"=",
			lev,mi,Me->m_addr,Me->m_save,Me->m_size,Me->m_what);
	}
	St->s_top = 0;
}
mem_pops(lev)
{	int li;

	mdebug("{m} POPS[%d]\n",lev);
	for( li = MAXLEV-1; lev <= li; li-- ){
		mem_pop1(li);
	}
}

/*
 * "(" [srcHostList] [":"[dstHostList] [":"[protList]]] ")"argument
 * AMAP=[srcHostList]:[dstHostList]:[protoList]:argument
 * conditional argument
 */

char *skip_argcond(arg)
	char *arg;
{
	if( strncmp(arg,"(",1) == 0 ){
		if( arg = strstr(arg,")") )
			arg++;
	}
	return arg;
}

typedef struct {
	char	*ca_cond;
	char	*ca_arg;
	int    (*ca_scan)(); /* function to interpret the argument */
	int	 ca_src;
	int	 ca_dst;
} CondArg;
static CondArg condArg[32];
static int condArgX;
extern IFUNC param_scanner();

add_condarg(arg)
	char *arg;
{	char *dp,cond[1024];
	int cai;
	CondArg *Cp;

	if( *arg != '(' )
		return 0;
	dp = wordscanY(arg+1,cond,sizeof(cond),"^)");
	if( *dp++ != ')' )
		return 0;
	if( *dp == 0 )
		return 0;
	cai = condArgX++;
	Cp = &condArg[cai];
	Cp->ca_cond = stralloc(cond);
	Cp->ca_src = makePathList("condarg",cond);
	Cp->ca_arg = stralloc(dp);
	Cp->ca_scan = param_scanner(dp);

	mdebug("{m} INIT[%s](%d) %s\n",cond,Cp->ca_src,dp);
	return 1;
}

extern int DGLEV;
extern int BREAK_STICKY;
extern int (*evalarg_func)();
static Connection *evalarg_Conn;

static exec_condarg(base,arg,func)
	IFUNC func;
	char *base,*arg;
{	char *dp;

	if( func ){
		if( dp = strchr(arg,'=') ){
			(*func)(evalarg_Conn,dp+1);
		}
		return 1;
	}else
	if( strneq(arg,"-v",2)
	 || strneq(arg,"-d",2)
	 || strneq(arg,"-W",2)
	){
		xmem_push(&LOG_type,sizeof(LOG_type),"-vX",NULL);
		xmem_push(&LOG_VERBOSE,sizeof(LOG_VERBOSE),"-vv",NULL);
		scan_arg1(NULL,arg);
		return 1;
	}
	return 0;
}
static scan1(base,arg)
	char *base,*arg;
{	IFUNC func;

	func = param_scanner(arg);
	exec_condarg(base,arg,func);
}
scan_condargs(Conn)
	Connection *Conn;
{	CondArg *Cp;
	char *arg;
	int cai;
	int match;

	match = 0;
	for( cai = 0; cai < condArgX; cai++ ){
		Cp = &condArg[cai];
		arg = Cp->ca_arg;
		if( Cp->ca_src )
		if( !matchPath1(Cp->ca_src,"-",Client_Host,Client_Port) )
			continue;

		if( strneq(arg,"+=",2) ){
			evalarg_func = scan1;
			evalarg_Conn = Conn;
			load_script(NULL,NULL,arg+2);
			evalarg_func = 0; 
			continue;
		}

		if( match == 0 ){
			char **sp;
			xmem_push(&extovw_argc,sizeof(int),"ext_argc",NULL);
			sp = &extovw_argv[extovw_argc]; /* end of array */
			xmem_push(sp,sizeof(char*),"ext_argv",NULL);
		}
		mdebug("{m} [%d]MATCH [%s]%s\n",extovw_argc,Client_Host,arg);
		match++;
		extovw_argv[extovw_argc++] = arg;

		if( exec_condarg(NULL,arg,Cp->ca_scan) ){
		}else{
			sv1log("{m} Not supported (%s)%s\n",
				Cp->ca_cond,Cp->ca_arg);
			BREAK_STICKY = 1;
		}
	}
}
