/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996-1999 Yutaka Sato
Copyright (c) 1996-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	enews.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960624	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "ystring.h"
extern FILE *dirfopen();
extern char *fgetsHeaderField();

#define LINESIZE	4095
#define MYSELF	"-.-"
/*
#define GPREFIX	"-."
*/
#define GPREFIX	""
#define ACTIVE_DIR	"groups"
#define HISTORY_DIR	"history"

#define EOM(line)	(line[0]=='.' && (line[1]=='\r'||line[1]=='\n'))
#define EOH(line)	(line[0] == '\r' || line[0] == '\n')

extern char *TIMEFORM_USENET;

#define FGPREFIX "+FILE-"

static file2group(gname,gpath)
	char *gname,*gpath;
{	char *pp,pc,*gp;

	gp = gpath;
	strcpy(gp,FGPREFIX);
	gp += strlen(gp);
	for( pp = gname; pc = *pp; pp++ ){
		switch( pc ){
			case '\\':
			case '/': *gp++ = '.'; break;
			case ':': sprintf(gp,"%%%02x",pc); gp += 3; break;
			default: *gp++ = pc; break;
		}
	} 
	*gp = 0;
}

static FILE *fopen_active(group,mode1,mode2)
	char *group,*mode1,*mode2;
{	char actpath1[LINESIZE],apath[LINESIZE];
	FILE *actfp;
	char filegroup[1024];

	if( isFullpath(group) ){
		file2group(group,filegroup);
		group = filegroup;
	}

	sprintf(actpath1,"%s/%s",ACTIVE_DIR,group);
	NewsLibdir(apath,actpath1);
	sv1vlog("ACTIVEFILE[%s]\n",apath);
	actfp = fopen(apath,mode1);
	if( actfp == NULL && mode2 != NULL )
		actfp = dirfopen("ACTIVE",apath,mode2);
	return actfp;
}
static default_spool(dir,group)
	char *dir,*group;
{	char artpath1[LINESIZE];
	char *lp;

	sprintf(artpath1,"spool/%s",group);
	for( lp = artpath1; *lp; lp++ )
		if( *lp == '.' )
			*lp = '/';
	cache_path("nntp",MYSELF,119,artpath1,dir);
}
static FILE *open_history(msgid,create)
	char *msgid;
{	char histpath[256],hpath[256],path[1024];
	FILE *hfp;

	if( msgid[0] == 0 ){
		return NULL;
	}
	strip_msgid(msgid,msgid);
	NNTP_midpath(histpath,msgid);
	sprintf(hpath,"%s/%s",HISTORY_DIR,histpath);
	NewsLibdir(path,hpath);

	if( create ){
		if( hfp = dirfopen("ART-HISTORY",path,"r+") )
			return hfp;
		else	return dirfopen("ART-HISTORY",path,"w+");
	}else{
		return dirfopen("ART-HISTORY",path,"r");
	}
}
static put_history(msgid,group,anum,artpath)
	char *msgid,*group,*artpath;
{	FILE *hfp;
	char idline[256],line[256],*dp,*sp,sc;
	int found;

	if( (hfp = open_history(msgid,1)) == NULL )
		return;

	found = 0;
	dp = idline;
	for( sp = group; sc = *sp; sp++ ){
		if( sc == '.' )
			*dp++ = '/';
		else	*dp++ = sc;
	}
	sprintf(dp,"/%d %s",anum,artpath);
	while( fgets(line,sizeof(line),hfp) ){
		if( dp = strpbrk(line,"\r\n") )
			*dp = 0;
		if( strcmp(line,idline) == 0 ){
			found = 1;
			break;
		}
	}
	if( found == 0 ){
		sv1log("#### added HISTORY [%s]\n",idline);
		fprintf(hfp,"%s\r\n",idline);
	}
	fclose(hfp);
}
static get_history(msgid,artpath,all,abspath)
	char *msgid,*artpath;
{	char histpath[256];
	FILE *hfp;
	char *lp,line[256],*dp,vpath[256],apath[256];

	if( (hfp = open_history(msgid,0)) == NULL )
		return 0;

	lp = artpath;
	*lp = 0;
	while( fgets(line,sizeof(line),hfp) ){
		if( dp = strpbrk(line,"\r\n") )
			*dp = 0;
		if( lp != artpath )
			*lp++ = ' ';
		if( sscanf(line,"%s %s",vpath,apath) != 2 )
			continue;
		if( abspath )
			strcpy(lp,apath);
		else	strcpy(lp,vpath);
		lp += strlen(lp);
		if( !all )
			break;
	}
	fclose(hfp);
	return 1;
}
ENEWS_path(msgid,artpath,is_filegroup)
	char *msgid,*artpath;
{
	if( get_history(msgid,artpath,1,is_filegroup) )
		return 1;
	else	return 0;
}
static FILE *fopen_article(msgid,group,anum,mode,artpath)
	char *msgid,*group,*mode,*artpath;
{	FILE *actfp,*artfp;
	char grppath[LINESIZE];
	char *artfmt;
	int min,max;
	char msgidbuf[256];

	if( msgid ){
		if( get_history(msgid,artpath,0,1) )
			return fopen(artpath,"r");
		return NULL;
	}

	artpath[0] = 0;
	actfp = fopen_active(group,"r",NULL);
	if( actfp == NULL )
		return NULL;

	grppath[0] = 0;
	fscanf(actfp,"%d %d %*d %*d %s",&min,&max,grppath);
	fclose(actfp);

	if( grppath[0] != '/' )
		return NULL;

	if( artfmt = strchr(grppath,':') )
		*artfmt++ = 0;

	if( artfmt != NULL )
		sprintf(artpath,"%s/%03d/%02d",grppath,anum/100,anum%100);
	else	sprintf(artpath,"%s/%d",grppath,anum);

	if( mode[0] == 'r' && mode[1] == 0 )
		artfp = fopen(artpath,mode);
	else	artfp = dirfopen("SPOOL-ARTICLE",artpath,mode);

	if( artfp == NULL )
		return NULL;

	fgetsHeaderField(artfp,"Message-ID",msgidbuf,sizeof(msgidbuf));
	put_history(msgidbuf,group,anum,artpath);

	return artfp;
}
FILE *ENEWS_article(msgid,group,anum)
	char *msgid,*group;
{	char artpath[LINESIZE];
	FILE *afp;
	char line[256];
	int off;

	if( afp = fopen_article(msgid,group,anum,"r",artpath) ){
		off = ftell(afp);
		if( fgets(line,sizeof(line),afp) != NULL )
		if( strncmp(line,"From ",5) != 0 )
			fseek(afp,off,0);
	}
	return afp;
}
static getSeqno(afp)
	FILE *afp;
{	char seqno[512];

	if( fgetsHeaderField(afp,"X-Seqno",   seqno,sizeof(seqno))
	||  fgetsHeaderField(afp,"X-Sequence",seqno,sizeof(seqno))
	||  fgetsHeaderField(afp,"X-Ml-Count",seqno,sizeof(seqno))
	||  fgetsHeaderField(afp,"Mail-Count",seqno,sizeof(seqno))
	)
		return atoi(seqno);
	return 0;
}

ENEWS_post(stat,afp,agroup,asubj,afrom)
	char *stat;
	FILE *afp;
	char *agroup,*asubj,*afrom;
{	char UnixFrom[LINESIZE];
	char group[LINESIZE],From[LINESIZE],Subj[LINESIZE];
	char msgid[LINESIZE],localid[512];
	char host[LINESIZE];
	int now,Lines,Bytes,Sum,Xor,xorx;
	char Date[128];
	char line[LINESIZE],eoh[LINESIZE];
	FILE *actfp,*artfp;
	char lactpath[LINESIZE],*lp; /* layered active file */
	int min,max,cdate,mdate,anum,ctime;
	char artpath[LINESIZE],dir[LINESIZE];
char lkpath[LINESIZE];
int lkfd;

	anum = ctime = 0;
	UnixFrom[0] = 0;
	fgetsHeaderField(afp,"UNIX-From",UnixFrom,sizeof(UnixFrom));
	fgets(line,sizeof(line),afp);
	if( strncmp(line,"From ",5) == 0 )
		lineScan(line+5,UnixFrom);
	else	fseek(afp,0,0);

	if( UnixFrom[0] ){
		From[0] = Date[0] = 0;
		sscanf(UnixFrom,"%s %[^\r\n]",From,Date);
		ctime = scanUNIXFROMtime(Date);
		anum = getSeqno(afp);
		sv1log("POSTed with UNIX-From: %s\n",UnixFrom);
		sv1log("From:%s,Date:%s(%d),Anum:%d\n",From,Date,ctime,anum);
	}

	if( agroup[0] )
		strcpy(group,agroup);
	else	fgetsHeaderField(afp,"Newsgroups",group,sizeof(group));
	strip_spaces(group);
	if( group[0] == 0 ){
	    strcpy(stat,"441 Required \"Newsgroups\" header is missing.\r\n");
		return -1;
	}
	if( strncmp(group,GPREFIX,strlen(GPREFIX)) != 0 )
		return 0;
	strcpy(group,group+strlen(GPREFIX));

	if( afrom[0] )
		strcpy(From,afrom);
	else	fgetsHeaderField(afp,"From",From,sizeof(From));
	if( From[0] == 0 ){
	    strcpy(stat,"441 Required \"From\" header is missing.\r\n");
		return -1;
	}
	if( asubj[0] )
		strcpy(Subj,asubj);
	else	fgetsHeaderField(afp,"Subject",Subj,sizeof(Subj));
	if( Subj[0] == 0 ){
	    strcpy(stat,"441 Required \"Subject\" header is missing.\r\n");
		return -1;
	}
	now = time(0);
	StrftimeGMT(Date,sizeof(Date),TIMEFORM_USENET,now);

	actfp = fopen_active(group,"r+","w+");
	if( actfp == NULL ){
		sprintf(stat,"441 POST failed (no active).\r\n");
		return 1;
	}

NewsLibdir(dir,ACTIVE_DIR);
sprintf(dir+strlen(dir),"/%s",group);
lkfd = getLocalLock(actfp,"/tmp",dir,lkpath);
if( 0 <= lkfd ){
	sv1log("NFS-locallock[%d] %s\n",lkfd,lkpath);
	lock_exclusive(lkfd);
}else
	lock_exclusive(fileno(actfp));

	max = min = cdate = mdate = 0;
	dir[0] = 0;
	fscanf(actfp,"%d %d %d %d %s",&min,&max,&cdate,&mdate,dir);
	fseek(actfp,0,0);
	if( dir[0] != '/' )
		default_spool(dir,group);

	if( 0 < anum ){
		if( anum < min ) min = anum;
		if( max < anum ) max = anum;
	}else{
		max++;
		anum = max;
	}
	if( min == 0 )
		min = max;

	fprintf(actfp,"%05d %05d %d %d %s\n",min,max,cdate,mdate,dir);
	fclose(actfp);

if( 0 <= lkfd )
	close(lkfd);

	sv1log("ACTIVE[%s %d %d] %d %d %s\n",group,max,min,cdate,mdate,dir);

	if( artfp = fopen_article(NULL,group,anum,"r",artpath) ){
		fclose(artfp);
		sprintf(stat,"441 don't overwrite existing article (%d)\r\n",
			anum);
		return -1;
	}
	artfp = fopen_article(NULL,group,anum,"w+",artpath);
	if( artfp == NULL ){
		sv1log("CAN'T SPOOL POSTED ARTICLE: %s\n",artpath);
		sprintf(stat,"441 can't create article file (%d)\r\n",anum);
		return -1;
	}
	sv1log("SPOOL POSTED ARTICLE: %s\n",artpath);

	fgetsHeaderField(afp,"Message-ID",msgid,sizeof(msgid));
	gethostFQDN(host,sizeof(host));

	strip_msgid(msgid,msgid);
	if( msgid[0] == 0 ){
		StrftimeLocal(localid,sizeof(localid),"%H%M%S.%y%m%d",now);
		sprintf(msgid,"%s@%s",localid,host);
	}

	copyheader(afp,NULL,NULL);
	Bytes = Sum = Xor = xorx = 0;
	for( Lines = 0; fgets(line,sizeof(line),afp) != NULL; Lines++ ){
		if( EOM(line) )
			break;
		for( lp = line; *lp; lp++ ){
			Sum += *lp;
			Xor ^= *lp << (xorx*8);
			if( 4 <= ++xorx )
				xorx = 0;
		}
		Bytes += strlen(line);
	}

	fprintf(artfp,"Xref: %s %s:%d\r\n",host,group,anum);
	fprintf(artfp,"Subject: %s\r\n",Subj);
	fprintf(artfp,"From: %s\r\n",From);
	fprintf(artfp,"Date: %s\r\n",Date);
	fprintf(artfp,"Message-ID: <%s>\r\n",msgid);
	fprintf(artfp,"Lines: %d\r\n",Lines);
	fprintf(artfp,"X-CheckSum: %d %d %x\r\n",Bytes,Sum,Xor);
	fprintf(artfp,"Newsgroups: %s\r\n",group);

	fseek(afp,0,0);
	copyheader(afp,artfp,eoh);
	if( eoh[0] == '\r' || eoh[0] == '\n' )
		fputs(eoh,artfp);

	RFC821_skipbody(afp,artfp,NULL,0);
	fflush(artfp);
	fseek(artfp,0,0);

	put_history(msgid,group,anum,artpath);

	linkArticle(artfp,group,anum,artpath,msgid,host);
	fclose(artfp);
	set_utimes(artpath,0,ctime);

	sprintf(stat,"240 Article posted locally (%d)<%s>.\r\n",anum,msgid);
	return 1;
}

copyheader(in,out,eoh)
	FILE *in,*out;
	char *eoh;
{	char line[LINESIZE],fname[LINESIZE];
	int putit;

	putit = 1;
	if( eoh != NULL )
		eoh[0] = 0;

	while( fgets(line,sizeof(line),in) != NULL ){
		if( EOM(line) )
			break;
		if( EOH(line) ){
			if( eoh != NULL )
				strcpy(eoh,line);
			break;
		}
		if( line[0] == ' ' || line[0] == '\t' ){
			if( !putit )
				continue;
		}else{
			sscanf(line,"%[^:]",fname);
			if( strcasecmp(fname,"Xref") == 0
			 || strcasecmp(fname,"Subject") == 0
			 || strcasecmp(fname,"From") == 0
			 || strcasecmp(fname,"Date") == 0
			 || strcasecmp(fname,"Message-ID") == 0
			 || strcasecmp(fname,"Lines") == 0
			 || strcasecmp(fname,"Newsgroups") == 0
			){
				putit = 0;
				continue;
			}else	putit = 1;
		}
		if( out != NULL )
			fputs(line,out);
	}
}
static strip_msgid(src,dst)
	char *src,*dst;
{	char *dp;

	if( src[0] == '<' ){
		strcpy(dst,src+1);
		if( dp = strchr(dst,'>') )
			*dp = 0;
	}else
	if( src != dst )
		strcpy(dst,src);
}

static minmax(file,dir,min,max)
	char *file;
	int *min,*max;
{	int num;

	num = atoi(file);
	if( 0 < num || file[0] == '0' ){
		if( *min < 0 || num < *min )
			*min = num;
		if( *max < 0 || *max < num )
			*max = num;
	}
	return 0;
}
static make_active(group,max,min,cdate,mdate,dir)
	char *group;
	int *max,*min,*cdate,*mdate;
	char *dir;
{	char artpath1[1024];
	char dirpath[1024],artfmt[32];
	char sdir[1024];
	int xmin,xmax;

	*max = *min = -1;
	*mdate = 0;
	if( dir[0] != '/' )
		default_spool(dir,group);

	artfmt[0] = 0;
	sscanf(dir,"%[^:]:%s",dirpath,artfmt);

	*mdate = File_mtime(dirpath);
	if( *cdate <= 0 )
		*cdate = *mdate;

	Scandir(dirpath,minmax,dirpath,min,max);
	if( artfmt[0] && 0 <= *min && 0 <= *max ){
		xmin = xmax = -1;
		sprintf(sdir,"%s/%03d",dirpath,*min);
		Scandir(sdir,minmax,sdir,&xmin,&xmax);
		*min = *min * 100 + xmin;
		/* should treat the case where the directory is empty ... */

		xmin = xmax = -1;
		sprintf(sdir,"%s/%03d",dirpath,*max);
		Scandir(sdir,minmax,sdir,&xmin,&xmax);
		*max = *max * 100 + xmax;
		/* should treat the case where the directory is empty ... */
	}
	if( *max < 0 ) *max = 0;
	if( *min < 0 ) *min = 0;
	return 1;
}
static addgroup(actdir,group,max,min,cdate,mdate,dir)
	char *actdir,*group;
	int *max,*min,*cdate,*mdate;
	char *dir;
{	int ok;
	FILE *afp;
	char actpath[1024],dirbuf[1024],dirpath[1024];

	sprintf(actpath,"%s/%s",actdir,group);

	ok = 0;
	if( afp = fopen(actpath,"r") ){
		dirbuf[0] = 0;
		if( fscanf(afp,"%d %d %d %d %s",min,max,cdate,mdate,dirbuf)
		 == 5 ){
			sscanf(dirbuf,"%[^:]",dirpath);
			if( dir[0] && strcmp(dir,dirbuf) != 0 )
				syslog_ERROR("#### spool moved ? %s -> %s\n",
					dirbuf,dir);
			else{
				if( dir[0] == 0 )
					strcpy(dir,dirbuf);
				if( File_mtime(dirpath) == *mdate )
					ok = 1;
			}
		}
		fclose(afp);
	}

	if( ok == 0 )
	if( ok = make_active(group,max,min,cdate,mdate,dir) )
	if( afp = dirfopen("ACTIVE-FILE1",actpath,"w") ){
		fprintf(afp,"%05d %05d %d %d %s\n",*min,*max,*cdate,*mdate,dir);
		fclose(afp);
	}
	return ok;
}
ENEWS_addspool(dir,recursive)
	char *dir;
{	int max,min,cdate,mdate;
	char dirbuf[1024],group[1024],actdir[1024];

	strcpy(dirbuf,dir);
	NewsLibdir(actdir,ACTIVE_DIR);
	file2group(dir,group);
	addgroup(actdir,group,&max,&min,&cdate,&mdate,dirbuf);
}

typedef struct {
	char	*dir;
	FILE	*out;
	int	 wcc;
	int	 is_filegroup;
	int	 date;
} Lista;

static list1(file,larg)
	char *file;
	Lista *larg;
{	char act1[LINESIZE],dir[LINESIZE];
	int max,min,cdate,mdate,ok;
	FILE *afp;
	char group[LINESIZE];

	if( file[0] == '.' )
		return 0;
	if( strncmp(file,FGPREFIX,strlen(FGPREFIX))==0 )
	if( !larg->is_filegroup )
		return 0;

	cdate = 0;
	dir[0] = 0;
	ok = addgroup(larg->dir,file,&max,&min,&cdate,&mdate,dir);

	if( ok )
	if( larg->date < cdate )
	{
		if( max < 0 ) max = 0;
		if( min < 0 ) min = 0;
		if( strncmp(file,FGPREFIX,strlen(FGPREFIX))==0 )
			strcpy(group,dir);
		else	sprintf(group,"%s%s",GPREFIX,file);
		sprintf(act1,"%s %d %d y\r\n",group,max,min);
		fputs(act1,larg->out);
		larg->wcc += strlen(act1);
	}
	return 0;
}

ENEWS_listX(out,is_filegroup,date)
	FILE *out;
{	Lista larg;
	char actdir[LINESIZE];

	NewsLibdir(actdir,ACTIVE_DIR);
	sv1log("NEWSLIB-ACTIVE: %s\n",actdir);

	larg.out = out;
	larg.dir = actdir;
	larg.wcc = 0;
	larg.is_filegroup = is_filegroup;
	larg.date = date;

	Scandir(actdir,list1,&larg);
	return larg.wcc;
}
ENEWS_list(out,is_filegroup)
	FILE *out;
{
	return ENEWS_listX(out,is_filegroup,0);
}

ENEWS_group(group,total,min,max)
	char *group;
	int *total,*min,*max;
{	FILE *afp;

	if( strncmp(group,GPREFIX,strlen(GPREFIX)) )
		return 0;

	if( afp = fopen_active(group,"r",NULL) ){
		*total = *min = *max = 0;
		fscanf(afp,"%d %d",min,max);
		fclose(afp);
		*total = *max - *min;
		if( *total < 0 || (*min == 0 && *max == 0) )
			*total = 0;
		else	*total += 1;
		return 1;
	}
	return 0;
}

fbsearch(group,min,max,date)
	char *group;
{	int mean,mdate;
	char apath[1024];
	FILE *afp;

	if( max == min )
		return max;
	mean = (max + min) / 2;
	if( mean == max || mean == min )
		return mean;

	if( afp = fopen_article(NULL,group,mean,"r",apath) ){
		mdate = File_mtime(apath);
		fclose(afp);
	}else{
		mdate = 0;
	}
	if( mdate == date )
		return mean;
	if( mdate < date )
		return fbsearch(group,mean,max,date);
	else	return fbsearch(group,min,mean,date);
}

ENEWS_newnews(out,group,date)
	FILE *out;
	char *group;
{	int total,min,max,hit,mi;
	FILE *afp;
	char msgid[1024];

	ENEWS_group(group,&total,&min,&max);
	hit = fbsearch(group,min,max,date);
	for( mi = hit; mi <= max; mi++ ){
		if( afp = ENEWS_article(NULL,group,mi) ){
			fgetsHeaderField(afp,"Message-ID",msgid,sizeof(msgid));
			fprintf(out,"%s\r\n",msgid);
			fclose(afp);
		}
	}
}
