/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-2000 Yutaka Sato and ETL,AIST,MITI
Copyright (c) 2001-2002 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use this material for evaluation, copy this material for
your own use, and distribute the copies via publically accessible on-line
media, without fee, is hereby granted provided that the above copyright
notice and this permission notice appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	delegated (DeleGate Server)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940303	created
//////////////////////////////////////////////////////////////////////#*/
#include "config.h"
#include "param.h"
#include "vsignal.h"
#include "yselect.h" /* FD_SETSIZE */
#include "delegate.h"
#include "ystring.h"
#include <errno.h>
#define SIGHUPTERM	(0 < SIGHUP ? SIGHUP : SIGTERM)
extern int RAND_TRACE;
DeleGateEnv *deleGateEnv;

int DGLEV = SB_PROC;

extern int CHILD_SERNO;
extern int CHILD_SERNO_MULTI;
extern int CHILD_SERNO_SINGLE;

extern int SERVER_RESTART;
extern int SERVER_TIMEOUT;
extern int VSAP_TIMEOUT;
extern int TOTAL_SERVED;
extern int NUM_CHILDREN;
extern int NUM_PEERS;
extern int START_TIME;
extern int PEEK_CLIENT_REQUEST;
extern int RES_localdns;
extern int RESOLV_UNKNOWN;
extern int SCRIPT_UNKNOWN;
extern int ERROR_RESTART;

typedef struct {
	short	p_stat;
	short	p_pid;	/* process id on Unix, process handle on Win32 */
	int	p_xid;	/* zero on Unix, process id on Win32 */
} Proc;

typedef struct {
	int	me_NUM_HUPS;
	int	me_ServerPID;
	int	me_myPrivateMASTER;
	int	me_MASTERisPrivate;
	int	me_IamPrivateMASTER;
	int	me_restartPrivateMASTER;
	int	me_IamCGI;

	int	me_TeleportPID;
	char	me_PrivateMasterOwnerPort[64];
	char   *me_workFiles[16];
	int	me_workFileX;
	jmp_buf me_exec_env;
	int	me_idle_timer;

	int	me_inINITIALIZATION;
	int	me_INTERRUPT_STICKY;
	int	me_StickyMAX_PARA;/* max. parallel Stickies */
	int	me_StickyMAX_LIFE;/* max. services by a Sticky */
	int	me_StickyTIMEOUT; /* standby seconds. (users' click interval) */
	int	me_StickyTIMEOUT1;
	/*
	int    *me_StickyProcs;
	*/
	Proc   *me_StickyProcs;
	int	me_StickyActive;
	int	me_StickyReport[2];
	int	me_StickyLastAccept;
	int	me_StickyNaccepted;
	int	me_StickyNserved;
	int	me_StickyDone;
	int	me_ACC_BYMAIN_INTERVAL; /* retry after blocked by Stickies */
	int	me_ACC_REJECTED;
	int	me_MainLastAccept;
	int	me_MainNaccepted;
	int	me_MainNserved;
	char   *me_originWD;

	/*
	int	me_MAX_SERVICE;
	*/
	int	me_gotSIGTERM;
	int	me_terminating;
	int	me_doSIGCHLDpid;
	int	me_numSIGCHLD;
	int	me_LOG_type_got;
	int	me_include_next;
	int	me_dont_check_param;
    Connection *me_mainConn;
	int	me_CLsock;
	char   *me_execSPECIAL;
	char   *me_serverurl0;
	char   *me_servermount_proto;
	int	me_mount_done;
	char  **me_direnv_environ;
	int	me_scannedGlobal;
	int	me_scanDirDefsX;
	char   *me_hostid_PATH;
	int	me_IDLE_TIMEOUT;
	char   *me_ABMwhere;
	Efd    *me_clientSocks;
	int	me_ACC_NONE_TIMEOUT;
	int	me_lockedoutN;
	int	me_lockedoutT;
	int	me_lastserveN;
	int	me_lastdoneN;
	int	me_Ntimeout;
	char   *me__workdir;
	int	me_init_HOSTS;

	char	*me_PrivateMasterOwner;
	char	*me_DeleGate1;
	char	*me_FuncFunc;
	int	 me_isFuncFunc;
	char	*me_FuncSTICKY;
	char	*me_FuncFILTER;
	int	 me_Fopt;	/* arg[Fopt] == "-F..." */
	int	 me_isFunc;

	int	 me_restart;
	/*
	int	 me_maxerestart;
	*/
	char	 me_src_socks[128];

} MainEnv;

static MainEnv *mainEnv;
#define ME mainEnv[0]
#define NUM_HUPS	ME.me_NUM_HUPS
/*
#define MAX_ERESTART	ME.me_maxerestart
*/
#define ServerPID	ME.me_ServerPID
#define myPrivateMASTER	ME.me_myPrivateMASTER
#define MASTERisPrivate	ME.me_MASTERisPrivate
#define IamPrivateMASTER	ME.me_IamPrivateMASTER
#define restartPrivateMASTER	ME.me_restartPrivateMASTER
#define IamCGI		ME.me_IamCGI

#define TeleportPID	ME.me_TeleportPID
#define PrivateMasterOwnerPort	ME.me_PrivateMasterOwnerPort
#define workFiles	ME.me_workFiles
#define workFileX	ME.me_workFileX
#define exec_env	ME.me_exec_env
#define idle_timer	ME.me_idle_timer

#define inINITIALIZATION	ME.me_inINITIALIZATION
#define INTERRUPT_STICKY	ME.me_INTERRUPT_STICKY
#define StickyMAX_PARA	ME.me_StickyMAX_PARA
#define StickyMAX_LIFE	ME.me_StickyMAX_LIFE
#define StickyTIMEOUT	ME.me_StickyTIMEOUT
#define StickyTIMEOUT1	ME.me_StickyTIMEOUT1
#define StickyProcs	ME.me_StickyProcs
#define StickyActive	ME.me_StickyActive
#define StickyReport	ME.me_StickyReport
#define StickyLastAccept	ME.me_StickyLastAccept
#define StickyNaccepted	ME.me_StickyNaccepted
#define StickyNserved	ME.me_StickyNserved
#define StickyDone	ME.me_StickyDone
#define ACC_BYMAIN_INTERVAL	ME.me_ACC_BYMAIN_INTERVAL
#define ACC_REJECTED	ME.me_ACC_REJECTED
#define MainLastAccept	ME.me_MainLastAccept
#define MainNaccepted	ME.me_MainNaccepted
#define MainNserved	ME.me_MainNserved
#define originWD	ME.me_originWD

/*
#define MAX_SERVICE	ME.me_MAX_SERVICE
*/
#define gotSIGTERM	ME.me_gotSIGTERM
#define terminating	ME.me_terminating
#define doSIGCHLDpid	ME.me_doSIGCHLDpid
#define numSIGCHLD	ME.me_numSIGCHLD
#define LOG_type_got	ME.me_LOG_type_got
#define include_next	ME.me_include_next
#define dont_check_param	ME.me_dont_check_param
#define mainConn	ME.me_mainConn
#define CLsock		ME.me_CLsock
#define execSPECIAL	ME.me_execSPECIAL
#define serverurl0	ME.me_serverurl0
#define servermount_proto	ME.me_servermount_proto
#define mount_done	ME.me_mount_done
#define direnv_environ	ME.me_direnv_environ
#define scannedGlobal	ME.me_scannedGlobal
#define scanDirDefsX	ME.me_scanDirDefsX
#define hostid_PATH	ME.me_hostid_PATH
#define IDLE_TIMEOUT	ME.me_IDLE_TIMEOUT
#define ABMwhere	ME.me_ABMwhere
#define clientSocks	ME.me_clientSocks
#define ACC_NONE_TIMEOUT	ME.me_ACC_NONE_TIMEOUT
#define lockedoutN	ME.me_lockedoutN
#define lockedoutT	ME.me_lockedoutT
#define lastserveN	ME.me_lastserveN
#define lastdoneN	ME.me_lastdoneN
#define Ntimeout	ME.me_Ntimeout
#define _workdir	ME.me__workdir
#define init_HOSTS	ME.me_init_HOSTS

#define PrivateMasterOwner	ME.me_PrivateMasterOwner
#define DeleGate1	ME.me_DeleGate1
#define FuncFunc	ME.me_FuncFunc
#define isFuncFunc	ME.me_isFuncFunc
#define FuncSTICKY	ME.me_FuncSTICKY
#define FuncFILTER	ME.me_FuncFILTER
#define Fopt		ME.me_Fopt
#define isFunc		ME.me_isFunc

int MAX_ERESTART = 1;
int MAX_SERVICE;
minit_main()
{
	if( mainEnv == 0 ){
		mainEnv = NewStruct(MainEnv);

		ACC_BYMAIN_INTERVAL = 200;
		ACC_NONE_TIMEOUT = 60;
		IDLE_TIMEOUT = 10*60;
		StickyTIMEOUT1 = 10;
		/*
		MAX_ERESTART = 1;
		*/

		CLsock = -1;
		StickyReport[0] = StickyReport[1] = -1;

		ABMwhere = "";
		PrivateMasterOwner = "(private-MASTER for ";
		DeleGate1	= "DeleGate";
		FuncFunc	= "(Function)";
		FuncSTICKY	= "(Sticky)";
		FuncFILTER	= "(Filter)";

		deleGateEnv = NewStruct(DeleGateEnv);
		clientSocks = NewStruct(Efd);
	}
}

extern int STANDBY_MAX;
extern int STANDBY_TIMEOUT;
extern int FDSET_MAX;
extern double Time();
extern int BREAK_STICKY;

int DELEGATE_PAUSE;

#define ST_ACC	0
#define ST_DONE	1

extern int   LOG_sockio[2];
extern int   LOG_sock_enable;
extern char *DELEGATE_LOGCENTER;
extern int   LOG_center;
extern char *DELEGATE_ERRORLOG;
extern char *DELEGATE_TRACELOG;
extern int   MAX_DELEGATE;
extern int   DELEGATE_LastModified;

extern char *getcwd();
extern char *gethostaddr();
extern char **dupv();
extern char *getClientUser();
extern char *getClientUserC();
extern int   DELEGATE_pushEnv();
extern FILE *LOG_openLogFile();
extern FILE *TMPFILE();

extern char **environ;
extern int  main_argc;
extern char **main_argv;
extern int  param_file;

#define getEnv(name)		DELEGATE_getEnv(name)
#define scanEnv(Conn,name,func)	DELEGATE_scanEnv(Conn,name,func)
#define pushEnv(name,value)	DELEGATE_pushEnv(name,value)

#define cronExit	DELEGATE_cronExit
#define sched_execute	DELEGATE_sched_execute
#define sched_action	DELEGATE_sched_action
extern int sched_action();

compatV5info(fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char msg[1024];

	sprintf(msg,fmt,a,b,c,d,e,f,g);
	Verbose("##DeleGate/6.X: %s will make it compatible with former versions.\n",
		msg);
}

iamServer(){ return getpid() == ServerPID; }

static setLastModified()
{	FILE *tmp,*fp;
	char *form;
	int modified;

	tmp = TMPFILE("setLastModified");
	DELEGATE_dumpEnv(tmp,0,IamPrivateMASTER);
	fflush(tmp);
	fseek(tmp,0,0);

	modified = 1;
	form = DELEGATE_PARAMFILE;
	if( fp = LOG_openLogFile(form,"r") ){
		if( fcompare(tmp,fp) == 0 ){
			modified = 0;
			DELEGATE_LastModified = file_mtime(fileno(fp));
		}
		fclose(fp);
	}
	if( modified ){
		DELEGATE_LastModified = time(0);
		if( fp = LOG_openLogFile(form,"w") ){
			copy_file(tmp,fp,NULL);
			fclose(fp);
		}
	}
	fclose(tmp);
	sv0log("DELEGATE_Modified[%d]: %x\n",modified,DELEGATE_LastModified);
}

static void sigPIPE(sig){
	sv0log("abort: caught SIGPIPE\n");
	Finish(-1);
}
static void sigURG(sig){
	sv0log("abort: caught SIGURG\n");
	Finish(-1);
}
void DELEGATE_sigFATAL(sig){
	char cwd[1024];
	signal(sig,SIG_IGN);
	daemonlog("F","E-A: ABORT: caught SIG%s [%d]\n",sigsym(sig),sig);
	ClientCountDown();
	AbortLog();
	getcwd(cwd,sizeof(cwd));
	daemonlog("F","E-A: core will be at %s\n",cwd);
	abort();
}
#define sigFATAL DELEGATE_sigFATAL

static void sigTERM(sig)
{
	gotSIGTERM = sig;
	signal(SIGTERM,SIG_IGN);
	sv0log("DeleGate SERVER EXITS: caught SIG%s [%d]\n",sigsym(sig),sig);
	if( getpid() != ServerPID ){
		fprintf(stderr,"\nDeleGate[%d] got SIGTERM(%d) for server=%d\n",
			getpid(),sig,ServerPID);
		Finish(-1);
		_exit(-1);
	}
	closeServPorts();
	Killpg(getpid(),SIGTERM);
	signal(SIGTERM,SIG_DFL);

	LOG_deletePortFile();
	deleteWORKDIR();

	cleanup_zombis(0);
	if( NUM_CHILDREN )
		sv0log("Left children: %d\n",NUM_CHILDREN);

	sv0log("FINISH.\n");
	notify_ADMIN(NULL,"stop");
	Finish(0);
	fprintf(stderr,"*** exit() on SIGTERM(%d) failed.1\n",sig);
	_exit(0);
}
static void sigTERM1(sig)
{
	Finish(0);
	fprintf(stderr,"*** exit() on SIGTERM(%d) failed.2\n",sig);
	_exit(0);
}


typedef struct {
	short	s_stat;
	short	s_done;
	int	s_pid;
} SReport;
#define SR_STICKY	1
#define SR_ACCEPT	2
#define SR_DETACH	4
#define SR_FINISH	8

extern int LastCpid;
static StickyAdd(pid)
{
	/*
	StickyProcs[StickyActive++] = pid;
	*/
	StickyProcs[StickyActive].p_stat = SR_STICKY;
	StickyProcs[StickyActive].p_xid = LastCpid;
	StickyProcs[StickyActive++].p_pid = pid;
}
static getStickyReports()
{	unsigned char nserv;
	SReport SR;
	int rcc;

	/*
	while( readTimeoutBlocked(StickyReport[0],&nserv,1,1) == 1 ){
	*/
	for(;;){
		rcc = readTimeoutBlocked(StickyReport[0],&SR,sizeof(SR),1);
		if( rcc != sizeof(SR) ){
			break;
		}
		nserv = SR.s_done;

		if( nserv == 0 ){
			StickyNaccepted += 1;
			putLoadStat(ST_ACC,1);
			StickyLastAccept = time(NULL);
			Verbose("## getStickyReport: GOT ACCEPT REPORT #%d (+%d)\n",
				StickyNaccepted,MainNaccepted);
		}else{
			StickyNserved += nserv;
			putLoadStat(ST_DONE,nserv);
		}
		if( SR.s_stat & SR_DETACH ){
			int si;
			for( si = 0; si < StickyActive; si++ ){
				if( StickyProcs[si].p_pid == SR.s_pid
				 || StickyProcs[si].p_xid == SR.s_pid ){
					StickyProcs[si].p_stat = SR_DETACH;
				}
			}
		}
	}
}
static StickyDel(pid)
{	int si;

	for( si = 0; si < StickyActive; si++ ){
		/*
		if( StickyProcs[si] == pid ){
		}*/
		if( StickyProcs[si].p_pid == pid ){
			for(; si < StickyActive; si++)
				StickyProcs[si] = StickyProcs[si+1];
			StickyActive--;
			StickyDone++;
			break;
		}
	}
	getStickyReports();
}
static StickyKill(sig)
{	int si,pid,rcode;
	int nkill;

	nkill = 0;
	for( si = 0; si < StickyActive; si++ ){
		if( StickyProcs[si].p_stat & SR_DETACH )
			continue; 
		/*
		pid = StickyProcs[si];
		*/
		pid = StickyProcs[si].p_pid;
		rcode = Kill(pid,sig);
		if( rcode == 0 )
			nkill++;
	}
	sv1log("StickyKill(%d): %d/%d killed\n",sig,nkill,StickyActive);
	return nkill;
}

static dec_nproc(pid)
{
	if( pid == myPrivateMASTER ){
		myPrivateMASTER = 0;
		sv1log("#### privateMASTER[%d] dead\n",pid);
		if( getpid() == ServerPID )
			restartPrivateMASTER = 1;
		else	BREAK_STICKY = 1;
	} else
	if( pid == TeleportPID ){
		sv1log("Teleport Closed.\n");
		sigTERM(SIGTERM);
	}else
	if( cronExit(pid) ){
	}else{
		StickyDel(pid);
		del_CC(pid,"byWait");
		if( 0 < NUM_CHILDREN )
			NUM_CHILDREN--;
		else{
			sv1log("previous server's child ? %d\n",pid);
			TraceLog("grand child ? %d\n",pid);
		}
		Verbose("(%d) process [%d] dead\n",NUM_CHILDREN,pid);
	}
}

extern int doTracePid;
extern int TraceLog();
extern int (*doTraceLog)();
static void sigCHLD(sig)
{
	if( getpid() != doSIGCHLDpid ){
		TraceLog("#### received unexpected SIGCHLD (1)\n");
		signal(SIGCHLD,SIG_DFL);
		return;
	}
	if( lSIGCHLD() == 0 ){
		TraceLog("#### received unexpected SIGCHLD (2)\n");
		signal(SIGCHLD,SIG_DFL);
		return;
	}
	++numSIGCHLD;
	if( lTRVERB() )
		TraceLog("SIGCHLD*%d\n",numSIGCHLD);
	cleanup_zombis(0);
	signalRESTART(SIGCHLD,sigCHLD);
}
setWatchChild()
{	int size;

	if( lTRACE() ){
		doTracePid = getpid();
		doTraceLog = TraceLog;
		/*
		 * expand fdset for OS like Slaris which read child process's
		 * status via file like "/proc/*"
		 */
		size = expand_fdset(FDSET_MAX+MAX_DELEGATE*3);
		TraceLog("START tracing children, FD_SETSIZE=%d\n",size);
	}
	if( lSIGCHLD() ){
		doSIGCHLDpid = getpid();
		sigblock(sigmask(SIGCHLD));
		signalRESTART(SIGCHLD,sigCHLD);
		TraceLog("START accepting SIGCHLD\n");
	}
}
setNoExec()
{	int rcode;

	if( lTRACE() == 0 )
		return;
	rcode = ptraceTraceMe();
	if( rcode == 0 )
		signal(SIGTRAP,SIG_IGN);
}
static logChild(what,inc)
	char *what;
{
	if( lTRACE() == 0 || lTRTERSE() )
		return;
	TraceLog("= %d (%s%d:%s)\n",
		NUM_CHILDREN,0<inc?"+":"",inc,what);
}

cleanup_zombis(log)
{	int pid;
	int ndead;

	ndead = 0;
	while( 0 < (pid = NoHangWait()) ){
		ndead++;
		dec_nproc(pid);
	}
	if( MAX_DELEGATE && MAX_DELEGATE + num_CC() <= NUM_CHILDREN ){
		int start = time(0);

		sv1tlog("MAX_DELEGATE: %d + %d <= %d\n",
			MAX_DELEGATE,num_CC(),NUM_CHILDREN);
		TraceLog("MAX_DELEGATE=%d < children=%d+%d\n",
			MAX_DELEGATE,NUM_CHILDREN,num_CC());

		while( MAX_DELEGATE + num_CC() <= NUM_CHILDREN ){
			if( 0 < (pid = NoHangWait()) ){
				ndead++;
				dec_nproc(pid);
			}else{
				if( gotSIGTERM )
					break;
				sleep(1);
			}
		}
		sv1tlog("MAX_DELEGATE: %d < %d + %d (%d seconds) finished=%d\n",
			NUM_CHILDREN,MAX_DELEGATE,num_CC(),time(0)-start, pid);
	}
	if( ndead )
		logChild("cleanup",-ndead);
	return ndead;
}


/*
 *	temporary argument to be removed after got
 */
#define TMP_SYM		"++"
#define TMP_SYM_LEN	(sizeof(TMP_SYM)-1)

static killChildren()
{	int nproc;

	nproc = 0;
	if( 0 < myPrivateMASTER ){
		if( Kill(myPrivateMASTER,SIGTERM) == 0 ){
			svlog("Killed private-MASTER [%d]\n",myPrivateMASTER);
			myPrivateMASTER = 0;
			++nproc;
		}
	}
	return nproc;
}

static int inSIGHUP;
static void sigHUPX(sig,execpath,argv)
	char *execpath;
	char *argv[];
{	char *nargv[256];
	char *arg,path[1024],port[128],nchild[32],wd[1024];
	int ai,ac,portset;
	int nproc;
	char orig_av0[1024];

if( execpath == NULL ){
	strcpy(path,EXEC_PATH);
	wordScan(main_argv[0],orig_av0);/*av[0] may be expanded for ps_title*/
}

	if( getpid() != ServerPID ){
		fprintf(stderr,"\nDeleGate[%d] got SIGHUP(%d) for server=%d\n",
			getpid(),sig,ServerPID);
		exit(1);
	}

	signal(SIGHUP,SIG_IGN);
	alarm(0);
	sigsetmask(0);
	LOG_sock_enable = 1;

{
char lpath[1024],host[256];
FILE *logfp;
int port;
int lsock;

sprintf(lpath,"/tmp/delegate/restart/%d",getpid());
if( logfp = fopen(lpath,"r") ){
	if( fscanf(logfp,"%[^:]:%d",host,&port) == 2 ){
		fclose(logfp);
		lsock = client_open("LOG","http",host,port);
		fprintf(stderr,"#### %s : %d [%d]\n",host,port);
		write(lsock,"(^_^)\n",6);
		sleep(5);
		close(lsock);
	}
}
}

	sv0log("DeleGate SERVER RESTART: %s\n",
		sig==0?"timeout":"caught SIGHUP");

{
int fd;
fd = openNull(0);
sv0log("NUM_HUPS=%d FD=[%d]\n",NUM_HUPS+1,fd);
if( 0 < fd )
close(fd);
}

	printServPort(port,"-P",1);

	if( sig == -1 ){
		sv0log("REOPEN PORT: %s\n",port);
		printServPort(port,"-P",0);
		closeServPorts();
	}

	if( !INHERENT_fork() ){ /* try not to kill active Sticky ... */
		sv1log("## StickyActive=%d\n",StickyActive);
		if( 0 < StickyActive ){
			int ti,tx;
			int shlock,rcode,etime;
			tx = 15;
			shlock = PortLockFd();
			if( 0 <= shlock ){
				/* block new request to be accepted by Sticky */
				rcode = lock_exclusiveTO(shlock,tx*1000,&etime);
				sv1log("## StickyActive lockout=%d (%d)\n",
					rcode,etime);
			}
			for( ti = 0; 0 < StickyActive && ti < tx; ti++ ){
				cleanup_zombis(0);
				sv1log("## StickyActive=%d %d/%d\n",
					StickyActive,ti+1,tx);
				sleep(1);
			}
		}
		/* ServPorts should be passed (duplicated) to the restarted
		 * DeleGate keeping the backlog...
		 */
		printServPort(port,"-P",-1);
		/*
		closeServPorts();
		*/
	}

	nproc = killChildren();
	StickyKill(SIGHUPTERM);

	LOG_deletePortFile();
	deleteWORKDIR();
	if( originWD ) chdir(originWD);

	LOG_checkAged(1);
	sv0log("DeleGate SERVER RESTART in progress...\n");
	strcpy(wd,"?");
	getcwd(wd,sizeof(wd));
	sv0log("PWD: %s\n",wd);
if( execpath == NULL )
	sv0log("EXEC: %s\n",path);
	LOG_closeall();

	close(StickyReport[0]); StickyReport[0] = -1;
	close(StickyReport[1]); StickyReport[0] = -1;

	if( 0 < nproc || NUM_CHILDREN )
		msleep(100);
	cleanup_zombis(0);
/*
	sprintf(nchild,"%s%d/%d/%d/%d",TMP_SYM,++NUM_HUPS,NUM_CHILDREN,
		LOG_sockio[0],LOG_sockio[1]);
*/
	sprintf(nchild,"HUPENV=%d/%d/%d/%d",++NUM_HUPS,NUM_CHILDREN,
		LOG_sockio[0],LOG_sockio[1]);

if( execpath != NULL ){
	char *ppid,dgpid[32],dgargs[1024];
	/* maybe restarting DeleGate via shell script or so.  */
	ppid = getenv("DELEGATE_PID");
	sv1log("#### parent DELEGATE_PID=%s\n",ppid?ppid:"NULL");
	if( ppid == NULL || atoi(ppid) != getpid() ){
		/* the shell (parent) process may be waiting exit code
		 * from this process rathar than "exec" this process.
		 */
		if( INHERENT_fork() ){
			if( Fork("execmain") != 0 )
				exit(0);
		}
	}
	sprintf(dgpid,"DELEGATE_PID=%d",getpid());
	putenv(dgpid);
	sprintf(dgargs,"DELEGATE_ARGS=%s %s",port,nchild);
	putenv(dgargs);
	sv1log("#### %s %s\n",dgpid,dgargs);
	Execvp("execmain",execpath,argv);
	Finish(-1);
}

	nargv[0] = orig_av0;
	ac = 1;
	portset = 0;

	if( getEnv(P_DGROOT) == 0 ){
		char dgroot[1024];
		sprintf(dgroot,"DGROOT=%s",DELEGATE_DGROOT);
		nargv[ac++] = dgroot;
		sv1log("## set %s\n",dgroot);
	}

	for( ai = 1; ai < main_argc; ai++ ){
		arg = main_argv[ai];
		if( arg[0]=='-' && arg[1]=='-' )
			continue;
		if( strncmp(arg,TMP_SYM,TMP_SYM_LEN) == 0 )
			continue;
		if( strncmp(arg,"HUPENV=",7) == 0 )
			continue;
		if( arg[0]=='-' && arg[1]=='P' ){
			if( !portset ){
				portset = 1;
				nargv[ac] = port;
			}
		}else	nargv[ac] = arg;
		ac++;
	}
	if( !portset )
		nargv[ac++] = port;
	nargv[ac++] = nchild;
	nargv[ac] = 0;

	if( !INHERENT_fork() ){
/*
		sprintf(nchild,"%s%d/%d/%d/%d",TMP_SYM,NUM_HUPS,NUM_CHILDREN,
			-1,-1);
*/
		sprintf(nchild,"HUPENV=%d/%d/%d/%d",NUM_HUPS,NUM_CHILDREN,
			-1,-1);

		if( isatty(fileno(stdin)) ){
			int fd,logfd,ssfd,rcode;
			int bgpid,pid,si;
			printf("NUM_HUPS=%d FD=[%d]\n",NUM_HUPS+1,
				dup(fileno(stderr)));

			logfd = curLogFd();
			ssfd = SessionFd();
			si = 0;
/*
			for( fd = 0; fd < 256; fd++ ){
*/
			for( fd = 0; fd < FD_SETSIZE; fd++ ){
				if( fd == logfd
				 || fd == ssfd
				 || fd == fileno(stdin)
				 || fd == fileno(stdout)
				 || fd == fileno(stderr) )
					continue;
				if( isServSock(fd) ){
					setrsvdsock(si++,fd);
					continue;
				}
				/*
				rcode = setCloseOnExec(fd);
				*/
				rcode = close(fd);
			}
			if( logfd != fileno(stdout) )
			if( logfd != fileno(stderr) )
				close(logfd);

			/*
			setserversock(ServSock());
			*/
			bgpid = Spawnvp("HUP",path,nargv);
			closeServPorts();
			if( NUM_HUPS <= 1 ){
				signal(SIGHUP,sigHUPX);
				while( pid = wait(0) ){
					if( pid == bgpid ){
						break;
					}
				}
			}else{
				/* wait chld to get environment ? */
				sleep(5);
			}
			/*
			Execvp("HUP",path,nargv);
			*/
		}else{
			int pid;
			extern int LastCpid;

			ac = 0;
			nargv[ac++] = "-Fsleep"; /* to hold socket */
			nargv[ac++] = "10";
			nargv[ac] = 0;
			pid = spawnv_self(ac,nargv);
			sprintf(nchild,"HUPENV=%d/%d/%d/%d/",
				NUM_HUPS,NUM_CHILDREN,-1,-1);
			send_socks(nchild+strlen(nchild),LastCpid);

			/*
			nargv[0] = "-Fkill-hup";
			nargv[1] = port;
			nargv[2] = 0;
			spawnv_self(2,nargv);
			*/
			inSIGHUP = 1;
			ac = 0;
			nargv[ac++] = "-Fkill-hup";
			nargv[ac++] = port;
			nargv[ac++] = nchild;
			nargv[ac] = 0;

			sv1log("RESTART %s ...\n",port);
			spawnv_self(ac,nargv);
			sv1log("RESTART WAITING to be STOPPED ...\n");
			sleep(15);
			sv1log("RESTART ERROR: not have been STOPPED\n");
		}
		Finish(0);
	}

	Execvp("sigHUP",path,nargv);
}
static recv_socks(){
	int pid,si,sock,fd;
	char *dp,num[32];

	if( ME.me_src_socks[0] == 0 )
		return;

	sv1log("#### %s\n",ME.me_src_socks);
	dp = ME.me_src_socks;
	dp = wordscanY(dp,num,sizeof(num),"^,");
	if( *dp == ',' )
		dp++;
	pid = atoi(num);

	for( si = 0; *dp; si++ ){
		dp = wordscanY(dp,num,sizeof(num),"^,");
		if( *dp == ',' )
			dp++;
		sock = atoi(num);
		if( sock <= 0 )
			break;
		fd = recv_sock(pid,sock,1);
		sv1log("#### recv_sock(pid=%d,fd=%d) port=%d\n",
			pid,sock,sockPort(fd));
	}
	ME.me_src_socks[0] = 0;
}
static send_socks(socks,cpid)
	char *socks;
{	char *dp;
	int fd,sock;

	dp = socks;
	sprintf(dp,"%d",cpid);
	dp += strlen(dp);

	for( fd = 0; fd < FD_SETSIZE; fd++ ){
		if( !isServSock(fd) )
			continue;
		sock = send_sock(cpid,fd,1);
		sprintf(dp,",%d",sock);
		dp += strlen(dp);
		sv1log("#### send_sock(pid=%d,fd=%d) port=%d\n",
			cpid,sock,sockPort(fd));
	}
	sv1log("#### %s\n",socks);
}
static void sigHUP(sig)
{
	sigHUPX(sig,NULL,NULL);
}
DELEGATE_execmain(command)
	char *command;
{	char argb[1024],*av[128];
	int ac;

	ac = decomp_args(av,128,command,argb);
	sigHUPX(0,av[0],av);
}

extern int  AF_UNIX_DISABLE;

static setupForSolaris()
{
	/* LOG_type is given by the parent in private-MASTER in the av[] */
	if( LOG_type_got )
		return;

	if( acceptExclusive() ){
		Verbose("ACCEPT EXCLUSION is ON by default.\n");
		if( (LOG_type & (L_FORK|L_EXEC)) == 0 ){
			if( LOG_type & L_LOCK )
				LOG_type &= ~L_LOCK;
			else	LOG_type |=  L_LOCK;
		}
	}
}
/*
 *	This function should be called after the process's real OWNER
 *	is set so that the directry is writable for the process itself.
 */
static mkdirForSolaris()
{
	if( IsSolaris() )
		AF_UNIX_DISABLE = 1;
}

#define LOAD_SYM	"-="
#define LOAD_SYM_LEN	(sizeof(LOAD_SYM)-1)

extern int DEBUG_FILE;
extern FILE *openPurl();


static subst_argurl(base,url,arg,xarg)
	char *arg,*base,*url,*xarg;
{	char aurl[1024],path[1024],param[1024];
	FILE *sfp,*dfp;
	int size;

	sfp = openPurl(base,url,aurl);
	if( sfp == NULL ){
		ERRMSG("Cannot load: %s\n",url);
		return -1;
	}

	param[0] = 0;
	sscanf(arg,"%[^=]",param);
	makeWorkFile(path,"mirror",param);

	dfp = dirfopen(param,path,"w");
	if( dfp == NULL ){
		ERRMSG("Cannot create: %s\n",path);
		fclose(sfp);
		return -1;
	}

	copyfile1(sfp,dfp);
	fclose(sfp);
	fflush(dfp);
	size = file_size(fileno(dfp));
	fclose(dfp);

	sprintf(xarg,"%s=%s",param,path);
	/*fprintf(stderr,"Argument substituted [%s] -> [%s](%dbytes)\n",
		arg,xarg,size);*/
	return 0;
}

char *scan_arg1(ext_base,arg)
	char *ext_base,*arg;
{	char *list,*val;
	int num;
	char *as;
	char *dp,xarg[1024];

	if( dp = strchr(arg,'=') ){
		dp++;
		if( strncmp(dp,LOAD_SYM,LOAD_SYM_LEN) == 0 ){
			dp += LOAD_SYM_LEN;
			if( subst_argurl(ext_base,dp,arg,xarg) == 0 )
				arg = stralloc(xarg);
		}
	}

	/* inherited on SIGHUP */
	if( strncmp(arg,"HUPENV=",7) == 0 ){
		sscanf(arg+7,"%d/%d/%d/%d/%s",&NUM_HUPS,&NUM_CHILDREN,
			&LOG_sockio[0],&LOG_sockio[1],ME.me_src_socks);
	}else
/*
	if( strncmp(arg,TMP_SYM,TMP_SYM_LEN) == 0 && arg[TMP_SYM_LEN] != 0 ){
		sscanf(arg+2,"%d/%d/%d/%d",&NUM_HUPS,&NUM_CHILDREN,
			&LOG_sockio[0],&LOG_sockio[1]);
	}else
*/
	if( include_next ){
		include_next = 0;
		load_script(NULL,ext_base,arg);
	}else
	if( strncmp(arg,INC_SYM,INC_SYM_LEN) == 0 ){
		if( arg[INC_SYM_LEN] == 0 )
			include_next = 1;
		else	load_script(NULL,ext_base,arg+INC_SYM_LEN);
	}else
	if( strncmp(arg,"-e",2) == 0 ){
		putenv(StrAlloc(arg+2));
	}else
	if( list = strchr(arg,'=') ){
		if( !dont_check_param ){
		check_param(arg,1);
		}

		list++;
		if( strncmp(list,INC_SYM,INC_SYM_LEN) != 0 )
		if( dp = strstr(arg,":+=") )
			list = dp+1;
		else
		if( dp = strstr(arg,",+=") )
			list = dp+1;

		if( strncmp(list,INC_SYM,INC_SYM_LEN) == 0 ){
			char name[128];
			extern int SCRIPT_ASIS;
			int asis;

			Strncpy(name,arg,list-arg+1);
			asis = SCRIPT_ASIS;
			SCRIPT_ASIS = script_asis(name);
			load_script(name,ext_base,list+INC_SYM_LEN);
			SCRIPT_ASIS = asis;
		}else
		if( ext_base != NULL )
			DELEGATE_addEnvExt(arg);
	}else
	if( strncmp(arg,PrivateMasterOwner,strlen(PrivateMasterOwner)) == 0 ){
		PrivateMasterOwnerPort[0] = 0;
		sscanf(arg+strlen(PrivateMasterOwner),"%[^)]",
			PrivateMasterOwnerPort);
	}else
	switch( arg[0] ){
	    case '-':
	    val = &arg[2];
	    switch( arg[1] ){
		case 'F':
			/* function selector */
			break;

		case 'P': /* server port */
			svlog("PORT> %s\n",arg);

			{   int sock;
			    if( 0 < (sock = getserversock()) ){
				char *dp;
				arg = strcpy((char*)malloc(strlen(arg)+16),arg);
				val = &arg[2];
				if( (dp = strchr(arg,'/')) == 0 )
					dp = &arg[strlen(arg)];
				sprintf(dp,"/%d",sock);
			    }
			}
			if( strncmp(arg,"-P0/",4) == 0 )
				IamPrivateMASTER = getppid();
			scanServPort(val);
			break;

		case 'c':
			switch( arg[2] ){
			    case 'e': pushEnv(P_CHARCODE,"EUC"); break;
			    case 'j': pushEnv(P_CHARCODE,"JIS"); break;
			    case 's': pushEnv(P_CHARCODE,"SJIS"); break;
			}
			break;

		case 'C':
			DELEGATE_CONFIG = stralloc(val);
			break;

		case 'L':
			LOG_type_got = 1;
			sscanf(val,"0x%x",&LOG_type);
			break;

		case 'd':
			switch( arg[2] ){
			case 'f': LOG_type |= L_FILETRACE; break;
			case 'h': LOG_type |= L_HOSTMATCH; break;
			case 'm': LOG_type |= L_MEMPUSH; break;
			case 's': LOG_type |= L_SOCKET; break;
			case 'M': LOG_type |= L_MOUNT; break;
			default:
			LOG_type |= L_ARGDUMP;
			}
			break;

		case 'l':
			LOG_type |= L_LOCK;
			break;
		case 'p':
			PEEK_CLIENT_REQUEST = 1;
			break;

		case 'f':
			LOG_type |= L_FG;
			break;
		case '1':
			LOG_type |= L_SYNC | L_TTY;
			break;
		case 't':
			LOG_type |= L_TTY;
			break;
		case 's':
			LOG_type |= L_FORK;
			break;
		case 'x':
			LOG_type |= L_EXEC;
			break;

		case 'R':
			RAND_TRACE = 1;
			break;

		case 'S':
			if( SIGCHLD < 0 ){
				fprintf(stderr,"#### -S NOT SUPPORTED: %s\n",
					"SIGCHLD signal is not available");
				break;
			}
			LOG_type |= L_SIGCHLD;
			break;
		case 'T': /* trace / trap */
			if( !INHERENT_ptrace() ){
				fprintf(stderr,"#### -T NOT SUPPORTED: %s\n",
					"ptrace system call is not available");
				break;
			}
			LOG_type |= L_TRACE | L_SIGCHLD;
			for( as = arg+2; *as; as++ ){
			    switch( *as ){
				case 'x': LOG_type |= L_NOEXEC; break;
				case 's': LOG_type &= ~L_SIGCHLD; break;
				case 't': LOG_type |= L_TRTERSE; break;
				case 'd': LOG_type |= L_TRVERB; break;
			    }
			}
			break;

		case 'v':
			if( arg[2] == 0 ){
				LOG_type |= L_FG|L_TTY;
			}else
			for( as = arg+2; *as; as++ ){
			    switch( *as ){
				case  's': LOG_type |= L_SILENT; break;
				case  't': LOG_type |= L_TERSE; break;
				case  'u': /* usual */
					LOG_type &= ~(L_SILENT|L_TERSE|L_VERB);
					LOG_VERBOSE = 0;
					break;
				case  'v': LOG_type |= L_FG|L_TTY|L_VERB; break;
				case  'd': LOG_type |= L_VERB; break;
				case  'a': LOG_type |= L_VERBABORT; break;
				case  'm': LOG_type |= L_MEMPUSH; break;
			    }
			}
			break;
		case 'w':
			if( arg[2] == 0 )
				LOG_type |= 1;
			else
			if( arg[2] == 'H' ){
				PollIn_HUP(0);
				fprintf(stderr,"POLLHUP disabled\n");
			}else
			if( '0' <= arg[2] && arg[2] <= '9' )
				LOG_type = (LOG_type & ~0xF) | (arg[2]-'0');
			break;

		case 'r':
			ME.me_restart = 1;
			break;
		case 'i':
			LOG_type |= L_REINIT;
			break;
		}
		break;
	}
	LOG_VERBOSE = lVERB() ? 1 : 0;
	return arg;
}
#define scan_args(ac,av)	DELEGATE_scan_args(ac,av)

static scanopt1(arg)
	char *arg;
{
	scan_arg1(NULL,arg);
	return 0;
}
scan_DGOPTS(Conn,arg)
	Connection *Conn;
	char *arg;
{
	scan_ListL(arg,';',1,scanopt1);
}
scan_args(ac,av)
	char *av[];
{	int ai;
	int dgopt;
	char *arg;

	if( lVERB() || lARGDUMP() ){
		for( ai = 0; ai < ac; ai++ )
			fprintf(stderr,"[%d] %s\n",ai,av[ai]);
	}

	dgopt = 0;
	for( ai = 0; ai < ac; ai++ )
	{	arg = av[ai];

		if( add_condarg(arg) )
			continue;

		/* ignoring options for -Ffunction */
		if( Fopt && ai < Fopt ){
			/* delegated -dgopt -dgopt ... -Ffunc -fopt -fopt ... */
		}else
		if( Fopt || isFunc ){
			/* ... -fopt -fopt -- -dgopt -dgopt ... */
			if( strcmp(arg,TMP_SYM) == 0 ){
				dgopt = 1;
				continue;
			}
			if( dgopt == 0 && arg[0] == '-' ){
				if( strchr("P",arg[1]) == 0 )
					continue;
			}else
			if( strchr(arg,'=') == 0 ){
				continue;
			}
		}
		av[ai] = scan_arg1(NULL,av[ai]);
	}

	if( lVERB() )
		LOG_VERBOSE = 1;

	setupForSolaris();
	return ac;
}

extern char *getADMIN1();
static beDaemon(Conn)
	Connection *Conn;
{	char *av[MAX_ARGC],port[128],param[128];
	int ac,ai;
	char *admin,admbuff[128],parambuff[128];
	char logtype[32];

	if( !INHERENT_spawn() ){
		if( Fork("daemon") != 0 )
			_Finish(0);
		setsid();
		return;
	}

	ac = 0;	
	av[ac++] = EXEC_PATH;
	ac += copy_param(NULL,&av[ac],environ);
	ac += copy_param("*+",&av[ac],&main_argv[1]);
	printServPort(port,"",1);
	sprintf(param,"-P%s",port);
	av[ac++] = param;
	sprintf(logtype,"-L0x%x",LOG_type);
	av[ac++] = logtype;
	for( ai = 0; ai < main_argc; ai++ ){
		if( streq(main_argv[ai],"-SERVICE") ){
			av[ac++] = "-SERVICE";
			break;
		}
		if( strncmp(main_argv[ai],"-W",2) == 0 ){
			av[ac++] = main_argv[ai];
		}
		if( strncmp(main_argv[ai],"-d",2) == 0 )
			av[ac++] = main_argv[ai];
	}
	av[ac] = 0;

	put_identification(stdout);
	admin = getADMIN1();
	fprintf(stderr,"DGROOT=%s\r\n",DELEGATE_DGROOT);
	fprintf(stderr,"ADMIN=%s\r\n",admin?admin:"");

	if( admin == NULL || *admin == 0 ){
		printf("CAUTION: ADMIN is not specified.\r\n");
		printf("You must declare your E-mail address.\r\n");

		admbuff[0] = 0;
		if( askADMIN(stdout,stdin,admbuff,sizeof(admbuff)) != 0 )
			Finish(0);
		if( admbuff[0] == 0 ){
			printf("EXIT: You must declare ADMIN\r\n");
			Finish(0);
		}
		sprintf(parambuff,"ADMIN=%s",admbuff);
		av[ac++] = parambuff;
		av[ac] = NULL;
	}
	ScanFileDefs(Conn);
	if( checkCACHEDIR(Conn) != 0 )
		Finish(-1);

	if( create_service(ac,av,port) )
		exit(0);

	sv1log("#### DO NOT FORK TO BE DAEMON\n");
}


extern int START_TIME1;
extern char *hostmatch_withauth;

/*
static scan_serverspec(serverspec,url,hostlist)
*/
static scan_serverspec(Conn,serverspec,url,hostlist)
	Connection *Conn;
	char *serverspec,*url,*hostlist;
{	char *hl;
	char map[256],type[16],*op;

	/*
	 * strip "URI[:-:srcList]" postfix first
	 */
	if( hl = strstr(serverspec,":-:") ){
		strcpy(url,serverspec);
		hl = strstr(url,":-:");
		*hl = 0;
		strcpy(hostlist,hl+3);
	}else{
		strcpy(url,serverspec);
		strcpy(hostlist,"");
	}
	if( strchr(url,':') == NULL )
	{
		if( op = strstr(url,",-") ){
			/* SERVER=telnet,-in -> SERVER=telnet://-/,-in */
			Strins(op,"://-/");
		}else
		strcat(url,"://-/");
	}

	/* ex. SERVER=telnet://host,-in */
	if( op = strstr(url,",-") ){
		wordscanY(op+2,type,sizeof(type),"^,(:");
		/*
		sprintf(hostlist+strlen(hostlist),",%s",hostmatch_withauth);
		*/
		if( hostlist[0] )
			strcat(hostlist,",");
		strcat(hostlist,hostmatch_withauth);
		sprintf(map,"{%s}:vp_%s:*:%s",url,type,hostlist);
		sv1log("XSERVER: %s\n",map);
		scan_CMAP2(Conn,"XSERVER",map);
	}

	/* ex. SERVER=sockmux:commin@/tmp/com1 */
	if( strstr(url,"://") == 0 )
	if( op = strstr(url,":") ){
		char *dp =
		wordscanY(op+1,type,sizeof(type),"^@:/?");
		if( *dp == '@' )
		if( type[0] ){
			sprintf(map,"{%s}:vp_%s:*:%s",url,type,hostlist);
			sv1log("XSERVER: %s\n",map);
			scan_CMAP2(Conn,"XSERVER",map);
			/*
			Strins(op+1,"//-");
			*/
			Strins(op+1,"//-/");
			/* sockmux://-/commin@/tmp/...  */
		}
	}
}

static server2(Conn,serverspec,serverurl)
	Connection *Conn;
	char *serverspec,*serverurl;
{	char hostlist[1024];
	char chost[256],ihost[256];
	int cport,iport;
	int match;
	char *user;

	/*
	scan_serverspec(serverspec,serverurl,hostlist);
	*/
	scan_serverspec(Conn,serverspec,serverurl,hostlist);
	if( hostlist[0] == 0 ){
		strcpy(serverurl0,serverurl);
		return 0;
	}
	if( !Conn->cl.p_connected )
		return 0;

	iport = gethostNAME(ClientSock,ihost);
	cport = getClientHostPort(Conn,chost);
	user = getClientUser(Conn);
	if( user == NULL )
		user = "-";

	/* to setup for matching SERVER=url:-:-Pxxxx */
	HL_setClientIF(ihost,iport,0);

	match = CTX_evalMountCond(Conn,hostlist,user,chost,cport,ihost,iport);

	if( match ){
		Verbose("OK [%s] [%s][%s]\n",serverurl,chost,hostlist);
		scan_SERVER(Conn,serverurl);
		Conn->cl.p_bound = 1;
		return 1;
	}else{
		Verbose("NO [%s] [%s][%s]\n",serverurl,chost,hostlist);
		return 0;
	}
}

static server1(Conn,serverspec)
	Connection *Conn;
	char *serverspec;
{	char serverurl[1024];

	if( Conn->cl.p_bound )
		return 1;

	if( server2(Conn,serverspec,serverurl) )
		return 1;

	return 0;
}

static char *Scan_SERVER(Conn)
	Connection *Conn;
{	char *proto;
	char url[1024];

	serverurl0 = url;
	serverurl0[0] = 0;
	scanEnv(Conn,P_SERVER,server1);

	if( !Conn->cl.p_bound && serverurl0[0] )
		if( scan_SERVER(Conn,serverurl0) == 0 )
			Exit(-1,"ERROR: %s=%s\n",P_SERVER,serverurl0);

	/* V8.0.1 SERVER=http by default and SERVER=delegate to be Generalist */
	/* V8.0.4 SERVER=delegate with REMITTABLE={http*} by default */
	if( strcmp(DFLT_PROTO,"delegate") == 0 ){
		DFLT_PROTO[0] = 0;
		DFLT_HOST[0] = 0;
	}else
	if( getEnv(P_SERVER) == NULL ){
		/*
		scan_SERVER(Conn,"http");
		*/
	}

	if( DFLT_PROTO[0] ){
		BORN_SPECIALIST = 1;
		proto = DFLT_PROTO;
		if( !REUSE_ENV() )
		Verbose("SPECIALIST: %s\n",proto);
	}else{
		Verbose("GENERALIST\n");
		BORN_SPECIALIST = 0;
		proto = "delegate";
	}
	return proto;
}

isHTTP(proto)
	char *proto;
{
	return strcaseeq(proto,"http") || strcaseeq(proto,"https");
}
static servermount1(Conn,serverspec)
	Connection *Conn;
	char *serverspec;
{	char serverurl[1024],hostlist[1024],mountopt[1024];
	char mount[1024];
char *proto;
proto = servermount_proto;

	/*
	scan_serverspec(serverspec,serverurl,hostlist);
	*/
	scan_serverspec(Conn,serverspec,serverurl,hostlist);
	if( hostlist[0] )
		if( strchr(hostlist,'=') )
			sprintf(mountopt,"%s",hostlist);
		else	sprintf(mountopt,"via=%s",hostlist);
	else	strcpy(mountopt,"");

	/* V8.0.0 forbid non-RELIABLE hosts to access internal pages */
	set_MOUNT_ifndef(Conn,"/-/builtin/icons/*","=","default");
	set_MOUNT_ifndef(Conn,"/-/*","=","forbidden,from=!.RELIABLE,default");

	if( isHTTP(proto) ){
		/* if SERVER=http://server then this should be "%s/*" */
		sprintf(mount,"%s*",serverurl);
		set_MOUNT_ifndef(Conn,"/-*","=",mountopt);
		set_MOUNT_ifndef(Conn,"/=*","=",mountopt);

		if( strstr(serverspec,"://") )
		set_MOUNT_ifndef(Conn,"/*",mount,mountopt);
		else{
			/* MOUNT="/* //-/*" causes virtual hosting,
			 * "//-" in right hand is interpreted so ... */
		}
	}
	if( streq(proto,"nntp") || streq(proto,"news") ){
		sprintf(mount,"%s*",serverurl);
		set_MOUNT_ifndef(Conn,"=",mount,mountopt);
	}
	if( streq(proto,"ftp") ){
		set_MOUNT_ifndef(Conn,"//*","=",mountopt);
		if( !isMYSELF(DFLT_HOST) )
		if( getEnv(P_MOUNT) != NULL || strchr(serverurl,'@') ){
			sprintf(mount,"%s*",serverurl);
			set_MOUNT_ifndef(Conn,"/*",mount,mountopt);
		}
	}
	if( streq(proto,"pop") || streq(proto,"imap") )
		set_MOUNT_ifndef(Conn,"//*","=",mountopt);
}

static mount_all(Conn,proto)
	Connection *Conn;
	char *proto;
{	char *env;

	if( mount_done )
		return;
	mount_done = 1;

	scanEnv(Conn,P_MOUNT,scan_MOUNT);

servermount_proto = proto;
	scanEnv(Conn,P_SERVER,servermount1);

	init_mtab();
}

static char *defaultPERMIT(Conn)
	Connection *Conn;
{	char remitable[128];

	if( BORN_SPECIALIST ){
		if( streq(DFLT_PROTO,"telnet") )
		if( iSERVER_PORT != 0 ){
			sprintf(remitable,"%s/%d",iSERVER_PROTO,iSERVER_PORT);
			sv1log("REMITTABLE bound by SERVER: %s\n",remitable);
			return stralloc(remitable);
		}
		if( streq(DFLT_PROTO,"tunnel1") )
			return DELEGATE_G_PERMIT;

		if( isHTTP(DFLT_PROTO) || streq(DFLT_PROTO,"icp") )
			return DELEGATE_HTTP_PERMIT;
		else
		if( streq(DFLT_PROTO,"socks") )
			return DELEGATE_SOCKS_PERMIT;
		else
		if( streq(DFLT_PROTO,"telnet") )
			return DELEGATE_TELNET_PERMIT;
		else	return DELEGATE_S_PERMIT;
/*
	}else	return DELEGATE_G_PERMIT;
*/
	}else{
		/* V8.0.4 SERVER=delegate with REMITTABLE={http*} by default */
		if( getEnv(P_SERVER) == 0 )
			return DELEGATE_HTTP_PERMIT;
		else	return DELEGATE_G_PERMIT;
	}
}
static scan_PERMITX(Conn,proto)
	Connection *Conn;
	char *proto;
{	char extproto[1024];

	if( num_ListElems(proto,':') == 1 ){
		PERMIT_GLOBAL++;
		if( *proto == '+' ){
			sprintf(extproto,"%s%s",defaultPERMIT(Conn),proto+1);
			proto = extproto;
		}
	}else{
		if( PERMIT_GLOBAL == 0 ){
			scan_PERMIT(Conn,defaultPERMIT(Conn));
			PERMIT_GLOBAL++;
		}
	}
	scan_PERMIT(Conn,proto);
	return 0;
}

httplog_head(Conn,time,fp)
	Connection *Conn;
	FILE *fp;
{	char host[256],*user,date[64];

	strcpy(host,"-");
	getClientHostPort(Conn,host);
	if( (user = getClientUserC(Conn)) == NULL )
		user = "-";
	StrftimeLocal(date,sizeof(date),TIMEFORM_HTTPD,time);
	fprintf(fp,"%s %s %s [%s] ",host,user,"-",date);
}

extern Logfile *LOG_which();
fputLog(Conn,filter,fmt,a,b,c,d,e,f,g)
	Connection *Conn;
	char *filter;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char date[64];
	Logfile *Log;

	if( Log = LOG_which(DFLT_PROTO,filter,0) ){
		StrftimeLocal(date,sizeof(date),TIMEFORM_HTTPD,time(0));
		LOG_printf(Log,"[%s]{%d+%d} %s: ",
			date,CHILD_SERNO,CHILD_SERNO_MULTI,filter);
		LOG_printf(Log,fmt,a,b,c,d,e,f,g);
		return 1;
	}
	return 0;
}
scan_LOG(Conn,log)
	void *Conn;
	char *log;
{	char proto[64],filters[256],logform[256],pathform[1024];
	int ni;

	proto[0] = filters[0] = logform[0] = pathform[0] = 0;
	ni = sscanf(log,"%[^:]:%[^:]:%[^:]:%s",proto,filters,logform,pathform);
	if( ni != 4 ){
		ERRMSG("ERROR LOG=%s\n",log);
		return 0;
	}
	LOG_create(proto,filters,logform,pathform,"a",0);
	return 0;
}
static char *logfile()
{	char *logfile;

	if( (logfile = getEnv(P_LOGFILE)) == 0 )
		logfile = DELEGATE_LOGFILE;
	return logfile;
}

static char *primaryPort(port)
	char *port;
{
	if( IamPrivateMASTER )
		sprintf(port,"%s++",PrivateMasterOwnerPort);
	else	printPrimaryPort(port);
	return port;
}
static strsubstDE(spath,path,root,var)
	char *spath,*path,*root,*var;
{
	strcpy(spath,path);
	strsubstDirEnv(spath,root,var);
}
#define substfile DELEGATE_substfile
int substfile(file,proto,rvardir,rlogdir,ractdir)
	char *file,*proto,*rvardir,*rlogdir,*ractdir;
{	char port[256],pid[64],*vardir,*etcdir,*admdir,*logdir,*actdir;
	char *TMPDIR,*WORKDIR,*CACHEDIR;
	char *dgroot;
	char *libdir;
	char alogdir[1024];

	if( (dgroot = getEnv(P_DGROOT)) == 0 ) dgroot = DELEGATE_DGROOT;
	if( (libdir = getEnv(P_LIBDIR)) == 0 ) libdir = DELEGATE_LIBDIR;
	if( (vardir = getEnv(P_VARDIR)) == 0 ) vardir = DELEGATE_VARDIR;
	if( (etcdir = getEnv(P_ETCDIR)) == 0 ) etcdir = DELEGATE_ETCDIR;
	if( (admdir = getEnv(P_ADMDIR)) == 0 ) admdir = DELEGATE_ADMDIR;
	if( (logdir = getEnv(P_LOGDIR)) == 0 ) logdir = DELEGATE_LOGDIR;
	if( (actdir = getEnv(P_ACTDIR)) == 0 ) actdir = DELEGATE_ACTDIR;
	if( (TMPDIR = getEnv(P_TMPDIR)) == 0 ) TMPDIR = DELEGATE_TMPDIR;
	if( (WORKDIR = getEnv(P_WORKDIR)) == 0 ) WORKDIR = DELEGATE_WORKDIR;
	if( (CACHEDIR = getEnv(P_CACHEDIR)) == 0 ) CACHEDIR = DELEGATE_CACHEDIR;

	primaryPort(port);
	sprintf(pid,"%d",getpid());

	if( !isBoundpath(logdir) ){
		strcpy(alogdir,logdir);
		strsubstDirEnv(alogdir,dgroot,vardir);
		if( !isBoundpath(alogdir) )
			sprintf(alogdir,"%s/%s",vardir,logdir);
		logdir = alogdir;
	}

	/*
	if( lARGDUMP() )
	*/
	if( lFILETRACE() )
		fprintf(stderr,"[%d]< %s\n",getpid(),file);

	if( strstr(file,"${STARTDIR}") ){
		char *startdir;
		if( startdir = getenv("STARTDIR") )
			strsubst(file,"${STARTDIR}",startdir);
	}
	if( strstr(file,"${EXECDIR}") ){
		char execdir[1024],*dp;
/*
		if( 0 < readlink(EXEC_PATH,execdir,sizeof(execdir)) ){
			char cwd[1024];
			if( !isFullpath(execdir) ){
				getcwd(cwd,sizeof(cwd));
				chdir_cwd(cwd,execdir,0);
				strcpy(execdir,cwd);
			}
		}else
*/
		strcpy(execdir,EXEC_PATH);
		if( (dp= strrchr(execdir,'/')) || (dp= strrchr(execdir,'\\')) )
			*dp = 0;
		else	strcpy(execdir,".");
		strsubst(file,"${EXECDIR}",execdir);
	}

	strsubst(file,"${LIBDIR}",libdir);
	strsubst(file,"${ETCDIR}",etcdir);
	strsubst(file,"${ADMDIR}",admdir);
	strsubst(file,"${LOGDIR}",logdir);
	strsubst(file,"${ACTDIR}",actdir);
	strsubst(file,"${TMPDIR}",TMPDIR);
	strsubst(file,"${WORKDIR}",WORKDIR);
	strsubst(file,"${CACHEDIR}",CACHEDIR);

	strsubstDirEnv(file,dgroot,vardir);
	strsubst(file,"${PROTO}",proto);
	strsubst(file,"${PORT}",port);
	strsubst(file,"${PID}",pid);

	{
		Connection *Conn = mainConn;
		if( Conn ){
			if( Client_Host[0] )
				strsubst(file,"${CLIENTHOST}",Client_Host);
			else	strsubst(file,"${CLIENTHOST}","");
		}
	}

	/*
	if( lARGDUMP() )
	*/
	if( lFILETRACE() )
		fprintf(stderr,"[%d]> %s\n",getpid(),file);

	if( rvardir != NULL ) strsubstDE(rvardir,vardir,dgroot,vardir);
	if( rlogdir != NULL ) strsubstDE(rlogdir,logdir,dgroot,vardir);
	if( ractdir != NULL ) strsubstDE(ractdir,actdir,dgroot,vardir);
}
extern int setSHARE();
static shared1(pathpat)
	char *pathpat;
{	char xpathpat1[1024],xpathpat2[1024];

	if( !isBoundpath(pathpat) ){
		strcpy(xpathpat1,pathpat);
		substfile(xpathpat1,"",NULL,NULL,NULL);
		if( isBoundpath(xpathpat1) )
			pathpat = xpathpat1;
		else{
			sprintf(xpathpat2,"${DGROOT}/%s",pathpat);
			substfile(xpathpat2,"",NULL,NULL,NULL);
			if( isBoundpath(xpathpat2) )
				pathpat = xpathpat2;
		}
	}
	if( isBoundpath(pathpat) )
		setSHARE(pathpat);
	else	ERRMSG("Not absolute path: SHARE=%s\n",pathpat);
	return 0;
}
scan_SHARE(_,pathpats)
	void *_;
	char *pathpats;
{
	if( *pathpats == 0 )
		setSHARE("*");
	else	scan_commaList(pathpats,0,shared1);
}
static _setTMPDIR(dir)
	char *dir;
{	char tmpdir[1024];

	if( dir == NULL )
		dir = DELEGATE_TMPDIR;
	if( dir == NULL || *dir == 0 )
		return;

	strcpy(tmpdir,dir);
	substfile(tmpdir,"",NULL,NULL,NULL);
	if( !fileIsdir(tmpdir) )
		mkdirRX(tmpdir);
	setTMPDIR(tmpdir);
}

static char *putDirEnv1(buf,name)
	char *buf;
	char *name;
{	char param[32];
	char *ep;

	if( getEnv(name) == NULL )
		return 0;

	ep = buf;
	sprintf(ep,"%s=",name);
	ep += strlen(ep);
	sprintf(param,"${%s}",name);
	strcpy(ep,param);
	substfile(ep,"",NULL,NULL,NULL);
	if( strcmp(param,ep) == 0 )
		return 0;

	return ep + strlen(ep) + 1;
}
static char *direnvs[] = {
	P_DGROOT,
	P_ACTDIR,
	P_ADMDIR,
	P_ETCDIR,
	P_TMPDIR,
	P_LOGDIR,
	P_VARDIR,
	P_WORKDIR,
	P_CACHEDIR,
	0
};
static insenv(ev,estr)
	char **ev,*estr;
{	int ei,len;
	char ec,*env1;

	for( len = 0; ec = estr[len]; len++ ){
		if( ec == '=' ){ 
			len++;
			break;
		}
	}
	for( ei = 0; env1 = ev[ei]; ei++ ){
		if( strncmp(env1,estr,len) == 0 )
			break;
	}
	ev[ei] = estr;
	return ei;
}
char **addDirEnv(oenv)
	char **oenv;
{	char *env,*nenv[256],nenvb[4096],*ep,*xp;
	char *name;
	int ei,ej,di;

	ej = 0;
	for( ei = 0; env = oenv[ei]; ei++ )
		nenv[ej++] = env;

	ep = nenvb;
	for( di = 0; name = direnvs[di]; di++ ){
		if( xp = putDirEnv1(ep,name) ){
			nenv[ej++] = ep;
			ep = xp;
		}
	}

	sprintf(ep,"%s=%s",P_LIBPATH,DELEGATE_LIBPATH);
	substfile(ep,"",NULL,NULL,NULL);
	nenv[ej] = 0;
	if( insenv(nenv,ep) == ej )
		ej++;

	nenv[ej] = 0;
	return dupv(nenv,0);
}
ExecSpawnvpDirenv(what,execpath,av,spawn)
	char *what,*execpath,**av;
{	int pid;
	char **oenv;
	char *tmpenv[1024],*e1;
	int ei,ec;

	/*
	if( direnv_environ == 0 )
		direnv_environ = addDirEnv(environ);
	*/
	if( direnv_environ == 0 ){
		tmpenv[0] = 0;
		direnv_environ = addDirEnv(tmpenv);
	}
	ec = 0;
	for( ei = 0; e1 = environ[ei]; ei++ )
		tmpenv[ec++] = e1;
	for( ei = 0; e1 = direnv_environ[ei]; ei++ )
	{
		/*
		tmpenv[ec++] = e1;
		*/
		tmpenv[ec] = 0;
		if( insenv(tmpenv,e1) == ec )
			ec++;
	}
	tmpenv[ec] = 0;
	oenv = environ;
	environ = tmpenv;
	/*
	oenv = environ;
	environ = direnv_environ;
	*/

	if( spawn ){
		pid = Spawnvp(what,execpath,av);
		environ = oenv;
		return pid;
	}else{
		Execvp(what,execpath,av);
	}
}
ExecvpDirenv(what,execpath,av)
	char *what,*execpath,**av;
{
	return ExecSpawnvpDirenv(what,execpath,av,0);
}
SpawnvpDirenv(what,execpath,av)
	char *what,*execpath,**av;
{	
	return ExecSpawnvpDirenv(what,execpath,av,1);
}

static char *logfmtpart(path)
	char *path;
{	char *dp;

	if( dp = strrchr(path,':') )
		if( strchr(dp,'%') )
			return dp;
	return NULL;
}

extern int HTTP_ftpXferlog;
static set_PROTOLOG(Conn,proto)
	Connection *Conn;
	char *proto;
{	char *env,logspec[1024],*path,*fmt,tmp[1024],*dp;

	if( ( env = getEnv(P_PROTOLOG)) == 0 )
		env = DELEGATE_PROTOLOG;

	/*
	 *   PROTOLOG=[//host:port][/path][:format]
	 */

	strcpy(logspec,env);
	path = logspec;

	if( fmt = logfmtpart(logspec) ){
		*fmt++ = 0;
		if( path[0] == 0 ){
			strcpy(tmp,DELEGATE_PROTOLOG);
			path = tmp;
			if( dp = logfmtpart(path) )
				*dp = 0;
		}
	}else	fmt = "";

	if( !BORN_SPECIALIST || isHTTP(proto) )
		LOG_create("http",LF_PROTOLOG,fmt,path,"a",1);
	if( !BORN_SPECIALIST || streq(proto,"ftp") || HTTP_ftpXferlog )
		LOG_create("ftp", LF_PROTOLOG,"-",path,"a",1);
}
static ScanLogs(Conn,proto)
	Connection *Conn;
	char *proto;
{	char *env;

	_setTMPDIR(getEnv(P_TMPDIR));

	if( env = getEnv(P_SYSLOG) )
		open_syslog(env);

	if( ( env = getEnv(P_LOGFILE) ) == 0 )
		env = DELEGATE_LOGFILE;
	LOG_create("delegate",LF_LOGFILE,"-",env,"a",0);

	if( ( env = getEnv(P_ERRORLOG) ) == 0 )
		env = DELEGATE_ERRORLOG;
	LOG_create(LP_NOTTY,LF_ERRORLOG,"-",env,"a",0);

	if( lTRACE() ){
		if( ( env = getEnv(P_TRACELOG) ) == 0 )
			env = DELEGATE_TRACELOG;
		LOG_create(LP_NOTTY,LF_TRACELOG,"-",env,"a",0);
	}

	if( ( env = getEnv(P_ABORTLOG) ) == 0 )
		env = DELEGATE_ABORTLOG;
	setAbortLog(env);

	if( !IamPrivateMASTER && execSPECIAL == 0 ){
		set_PROTOLOG(Conn,proto);
		scanEnv(Conn,P_LOG,scan_LOG);
	}
	LOG_openall();
}

int MAXCONN_PCH;

extern char *DELEGATE_SMTPGATE;
int rescanGlobal;

#define ScanGlobal(Conn,proto) DELEGATE_ScanGlobal(Conn,proto)
ScanGlobal(Conn,proto)
	Connection *Conn;
	char *proto;
{	char *env;

	if( scannedGlobal && !rescanGlobal )
		return;
	rescanGlobal = 0;
	scannedGlobal = 1;

	if( env = getEnv(P_ADMIN ) )
		DELEGATE_ADMIN = env;
	else
	if( env = getEnv(P_MANAGER) ){
		sv1log("##DeleGate/6.X: %s should not be used. Use %s instead.\n",
			P_MANAGER,P_ADMIN);
		DELEGATE_ADMIN = env;
	}

	scanEnv(Conn,P_HOSTLIST,scan_HOSTLIST);

	scanEnv(Conn,P_TIMEOUT, scan_TIMEOUT);
	scanEnv(Conn,P_MAXIMA,  scan_MAXIMA);
	scanEnv(Conn,P_CHARCODE,scan_CHARCODE);
	scanEnv(Conn,P_CHARSET,scan_CHARCODE);

	if( env = getEnv(P_MIMECONV) )
		scan_MIMECONV(env);
	else
	if( getEnv(P_CHARCODE) == 0 ){
		scan_MIMECONV("thru");
		compatV5info("MIMECONV=thru is set by default. MIMECONV=\"\"");
	}

	scanEnv(Conn,P_PORT,  scan_PORT);
	scanEnv(Conn,P_VSAP,  scan_VSAP);

	scanEnv(Conn,P_SERVICE, scan_SERVICE);
	scanEnv(Conn,P_CMAP,  scan_CMAP);
	ScanLogs(Conn,proto);
	scanEnv(Conn,P_ROUTE, scan_ROUTE);
	scanEnv(Conn,P_FORWARD,scan_FORWARD);
	scanEnv(Conn,P_MASTER,scan_MASTER);
	scanEnv(Conn,P_PROXY, scan_PROXY);
	scanEnv(Conn,P_FTPTUNNEL, scan_FTPTUNNEL);
	if( env = getEnv(P_SSLTUNNEL) )
		scan_SSLTUNNEL(env);
	scanEnv(Conn,P_ICPCONF,scan_ICPCONF);
	scanEnv(Conn,P_ICP,   scan_ICP);

	if( env = getEnv(P_SMTPSERVER) )
		scan_SMTPSERVER(env);

	NotifyPltfrmHosts(); /* initialize Notify-Platform table */
	scanEnv(Conn,P_OWNER, scan_OWNER);
	scanEnv(Conn,P_AUTH,scan_AUTH);
	scanEnv(Conn,P_AUTHORIZER,scan_AUTHORIZER);
	scanEnv(Conn,P_MYAUTH,scan_MYAUTH);
	scanEnv(Conn,P_PGP, scan_PGP);

	if( env = getEnv(P_REMITTABLE) )
		scanEnv(Conn,P_REMITTABLE,scan_PERMITX);
	if( env = getEnv(P_PERMIT) )
		scanEnv(Conn,P_PERMIT,scan_PERMITX);
	if( getEnv(P_REMITTABLE) == NULL && getEnv(P_PERMIT) == NULL )
		scan_PERMIT(Conn,defaultPERMIT(Conn));
	scanEnv(Conn,P_REJECT,scan_REJECT);

	if( getEnv(P_RELIABLE) )
		scanEnv(Conn,P_RELIABLE,scan_RELIABLE);
	else{
		if( PERMIT_withSrc() == 0 )
			scan_RELIABLE(Conn,DELEGATE_RELIABLE);
		/* Allow expanding permission by PERMIT=proto:dst:extraSrcList
		 * without adding RELIABLE=extraSrcList.
		 * The default DELEGATE_RELIABLE is added to PERMIT without
		 * srcHostList.
		 * Like REMITTABLE is expanded for dstHost of MOUNT, RELIABLE
		 * could be expanded for the any srcHost in PERMIT...
		 */
	}
	scanEnv(Conn,P_REACHABLE,scan_REACHABLE);

	if( env = getEnv(P_RELAY) )
		scanEnv(Conn,P_RELAY,scan_RELAY);
	else	scan_RELAY(Conn,DELEGATE_RELAY);

	scanEnv(Conn,P_FILETYPE,scan_FILETYPE);
	scanEnv(Conn,P_HTTPCONF,scan_HTTPCONF);
	if( HTTP_ftpXferlog ){
		set_PROTOLOG(Conn,proto);
		LOG_openall();
	}
	scanEnv(Conn,P_NNTPCONF,scan_NNTPCONF);
	scanEnv(Conn,P_FTPCONF, scan_FTPCONF);
	scanEnv(Conn,P_DNSCONF, scan_DNSCONF);

	scanEnv(Conn,P_SMTPCONF,scan_SMTPCONF);
	if( strcaseeq(proto,"smtp") ){
		if( env = getEnv(P_SMTPGATE) )
			scan_SMTPGATE(Conn,env);
		else	scan_SMTPGATE(Conn,DELEGATE_SMTPGATE);
	}

	if( env = getEnv(P_CGIENV) )
		scan_CGIENV(Conn,env);

	if( env = getEnv(P_DELAY) )
		scanEnv(Conn,P_DELAY,scan_DELAY);

	scan_FILTERS(Conn);
	scanEnv(Conn,P_HTMLCONV,scan_HTMLCONV);
	scanEnv(Conn,P_URICONV,scan_URICONV);
	setURICONVdefault(0); /* initialize URICONV table if not set */

	if( env = getEnv(P_OVERRIDE) )	scan_OVERRIDE(Conn,env);
	scanEnv(Conn,P_CRON,scan_CRON);
	scanEnv(Conn,P_CRONS,scan_CRONS);
}

static scan_HOSTS0(Conn)
	Connection *Conn;
{	char hosts[0x10000];
	extern char *VSA_hostlocal(),*VSA_hostlocaladdr();

	if( init_HOSTS == 0 ){
		init_HOSTS = 1;
/*
		scan_HOSTS(Conn,"localhost/127.0.0.1");
*/
		scanEnv(Conn,P_HOSTS,scan_HOSTS);
		scan_HOSTS(Conn,"localhost/127.0.0.1");
		sprintf(hosts,"%s/%s",VSA_hostlocal(),VSA_hostlocaladdr());
		scan_HOSTS(Conn,hosts);
		dump_HOSTS(hosts);
		Verbose("scanned HOSTS=%s\n",hosts);
	}
}

static ScanEachConn(Conn)
	Connection *Conn;
{	char *env;

	HAS_MASTER = getEnv(P_PROXY) || getEnv(P_MASTER) || getEnv(P_TUNNEL);

	if( env = getEnv(P_BASEURL) )
		set_BASEURL(Conn,env);

	if( env = getEnv(P_DELEGATE) )
		scan_DELEGATE(Conn,env);
}

static ScanDirDefs(Conn)
	Connection *Conn;
{	char *env;
	int created;
	int scanX = inINITIALIZATION ? scanDirDefsX++ : 0;

	created = setDGROOT();
	if( getEnv(P_SHARE) )
		scanEnv(Conn,P_SHARE,scan_SHARE);
	else
	if( inINITIALIZATION && scanX == 0 )
		compatV5info("created directory/file will be non-sharable. SHARE=\"\"");

	if( created )
		chmodShared(DELEGATE_DGROOT);
	if( env = getEnv(P_LIBPATH) )
		DELEGATE_LIBPATH = stralloc(env);
	if( env = getEnv(P_DATAPATH) )
		DELEGATE_DATAPATH = stralloc(env);

	if( env = getEnv(P_VARDIR)   )	DELEGATE_VARDIR = stralloc(env);
	if( env = getEnv(P_LOGFILE)  )	DELEGATE_LOGFILE = stralloc(env);
	if( env = getEnv(P_ERRORLOG) )	DELEGATE_ERRORLOG = stralloc(env);
	if( env = getEnv(P_TRACELOG) )	DELEGATE_TRACELOG = stralloc(env);
	if( env = getEnv(P_PIDFILE)  )  DELEGATE_PIDFILE = stralloc(env);
	if( env = getEnv(P_PROTOLOG) ){
		char logspec[1024],*fmt;
		if( env[0] == ':' ){
			/* PROTOLOG="[Path]:Form" - Path part is omitted */
			strcpy(logspec,DELEGATE_PROTOLOG);
			if( fmt = logfmtpart(logspec) )
				*fmt = 0;
			strcat(logspec,env);
			env = logspec;
		}
		DELEGATE_PROTOLOG = stralloc(env);
	}
}
static ScanFileDefs(Conn)
	Connection *Conn;
{	char *env;

	ScanDirDefs(Conn);
	if( env = getEnv("IMAGEDIR") )	DELEGATE_IMAGEDIR = stralloc(env);

	if( env = getEnv(P_CACHEDIR) )	scan_CACHEDIR(stralloc(env));
	if( env = getEnv(P_CACHEFILE))	scan_CACHEFILE(stralloc(env));
	if( env = getEnv(P_CACHE)    )	scan_CACHE(Conn,env);

	if( scannedGlobal )
	/* Resolvy must be used after it is initialized,
	 * and after socket initialization in DO_INITIALIZE in Win32
	 */
	{
	if( env = getEnv(P_EXPIRE)   )  scanEnv(Conn,P_EXPIRE,scan_EXPIRE);
	}
}

static REUSE_ENV()
{
	return (1 < CHILD_SERNO_MULTI);
}
#define config(Conn,csock)	DELEGATE_config(Conn,csock)
config(Conn,csock)
	Connection *Conn;
{
	if( REUSE_ENV() || lSYNC() ){
		Scan_SERVER(Conn);
		ScanEachConn(Conn);
		return;
	}
/*
if( env = getEnv(P_EXPIRE) )	scanEnv(Conn,P_EXPIRE,scan_EXPIRE);
- should clear dynamically added CMAP (using peak index of static CMAPs ?)
*/
	DELEGATE_configx(Conn,0);
}
DELEGATE_configx(Conn,force)
	Connection *Conn;
{	char *proto;
	char *env;

	if( force ){
		mount_done = 0;
	}

	scan_HOSTS0(Conn);
	proto = Scan_SERVER(Conn);

	scanEnv(Conn,P_CONNECT,scan_CONNECT);
	ScanGlobal(Conn,proto);
	ScanEachConn(Conn);
	ScanFileDefs(Conn);
	mount_all(Conn,proto);
}

static PutPortFile(stayopen)
{	char *file;

	if( (file = getEnv(P_PIDFILE)) == 0 )
		file = DELEGATE_PIDFILE;
	if( LOG_createPortFile(file,stayopen) != 0 ){
		if( lLOCK() ){
			char path[1024];
			strcpy(path,file);
			substfile(path,"",NULL,NULL,NULL);
			fprintf(stderr,"DeleGate: could not create lock.\n");
fprintf(stderr,"DeleGate could not start because it failed creating '%s'\n",
path);
			Finish(-1);
		}
	}
}
static killServer(killspec,warn)
	char *killspec;
{	char signame[64];
	char *file,path[1024];
	FILE *fp;
	int sig,pid,rcode;

	if( (file = getEnv(P_PIDFILE)) == 0 )
		file = DELEGATE_PIDFILE;
	strcpy(path,file);
	substfile(path,"",NULL,NULL,NULL);
	if( (fp = fopen(path,"r")) == NULL ){
		if( warn )
		fprintf(stderr,"\"%s\": no active server on the port.\n",path);
		return -1;
	}

	signame[0] = 0;
	sscanf(killspec,"-%s",signame);
	if( strcaseeq(signame,"HUP") ) sig = SIGHUP; else
	if( strcaseeq(signame,"INT") ) sig = SIGINT; else
	sig = SIGTERM;

	pid = 0;
	fscanf(fp,"%d",&pid);
	fclose(fp);
	printf("\"%s\": kill(%d,SIG%s) = ",path,pid,sigsym(sig));
	fflush(stdout);

	if( 1 < pid ){
		errno = 0;
		rcode = Kill(pid,sig);
		if( rcode == 0 )
			printf("%d (%d) ** OK **",rcode,errno);
		else	printf("%d (%d) ** ERROR **",rcode,errno);
	}
	printf("\n");
	return rcode;
}
static kill_predecessor(ac,av,sigtype,warn)
	char *av[],*sigtype;
{	char port[128];
	char *hav[2],hab[128],*env;
	int hac;

	if( env = getEnv("HUPENV") ){
		hac = 1;
		hav[0] = hab;
		hav[1] = 0;
		sprintf(hab,"HUPENV=%s",env);
	}else{
		hav[0] = 0;
		hac = 0;
	}

	printServPort(port,"",1);
	if( !INHERENT_fork() && strcmp(sigtype,"-hup") == 0
/*
	 && restart_service(port) ){
*/
	 && restart_service(port,hac,hav) ){
		printf("restarted service: %s\n",port);
	}else
	if( delete_service(ac,av,port,sigtype) ){
		printf("stopped service: %s\n",port);
		sleep(1); /* make sure the deletion from service DB -_-; */
	}else{
		killServer(sigtype,warn);
	}
}

extern int CACHE_READONLY;

static initConn(Conn,csock)
	Connection *Conn;
{
	ConnInit(Conn);
	Conn->cl.p_connected = 1;
	ClientSock = csock;
	CLsock = csock;
	Conn->ma_private = myPrivateMASTER | MASTERisPrivate;
	clear_DGconn(Conn);

	if( 0 <= csock ){
	CLIF_PORT = VA_HostPortIFclnt(Conn,csock,CLIF_HOST,NULL,NULL);
	sprintf(CLIF_HOSTPORT,"%s:%d",CLIF_HOST,CLIF_PORT);
	}else{
		/* maybe just cleaning ... */
	}

	if( CACHE_READONLY )
		DontWriteCache = 1;
}

extern char *DELEGATE_HOSTID;
HostId(addr)
	char *addr;
{	char path[2048];

	if( hostid_PATH == NULL ){
		strcpy(path,DELEGATE_HOSTID);
		substfile(path,"",NULL,NULL,NULL);
		hostid_PATH = stralloc(path);
	}
	return ipno(hostid_PATH,addr);
}

static put_publiclog(addr)
	char *addr;
{	char route[256];

	/*sprintf(route,"%d/%d",HostId(myaddr),HostId(addr));*/
	sprintf(route,"%d",HostId(addr));
	flush_publiclog(route);
}

static setClientInfo(Conn,clSock,addr,clntinfo)
	Connection *Conn;
	Efd *clSock;
	char *addr,*clntinfo;
{	int port;
	char host[256],*user;

	if( VA_getClientAddr(Conn) ){
		if( (user = getClientUserC(Conn)) == NULL )
			user = "-";
		strcpy(host,Client_Host);
		VA_inetNtoah(Client_VAddr,addr);
		port = Client_Port;
		Conn->cl_count = ClientCountUp(user,host,addr,port);
		HL_setClientInfo(Client_VAddr);
	}else{
		user = "-";
		strcpy(host,"-");
		strcpy(addr,"0.0.0.0");
		port = 0;
		Conn->cl_count = 0;
	}
	sprintf(clntinfo,"%s@[%s]%s:%d",user,addr,host,port);

	if( clSock->_remote ){
		setOriginIdent(Conn,SocknameOf(clSock),PeernameOf(clSock));
	}
	if( TeleportHost[0] )
		sprintf(clntinfo+strlen(clntinfo),".-.%s:%d",
			TeleportHost,TeleportPort);

	daemonlog("E","(%d) accepted [%d] %s (%5.3fs)(%d)\n",
		NUM_PEERS+NUM_CHILDREN,
		getEfd(clSock),clntinfo, Time()-ACCEPT_TIME,Conn->cl_count);

	if( set_OWNER(Conn,host,port,user) < 0 )
		return -1;

	return 0;
}
xmem_push(addr,size,what,func)
	char *addr,*what;
	int (*func)();
{
	if( SB_PROC < DGLEV ){
		mem_push(DGLEV,addr,size,what,func);
	}
}
static call_client1(Conn,clSock)
	Connection *Conn;
	Efd *clSock;
{	int clsock = getEfd(clSock);
	char addr[512];
	char clntinfo[512];
	int count;

	if( *PeernameOf(clSock) == 0 ){
		int remote;
		char sockname[512],peername[512];

		remote = RIDENT_recv(clsock,sockname,peername);
		if( remote < 0 ){
			close(clsock);
			return;
		}
		setEfd(clSock,clsock,sockname,peername,remote);
	}

	if( execSPECIAL )
	sv1log(">>>>>>>> %s\n",execSPECIAL);

DGLEV = SB_CONN;
	beginGeneralist(Conn,clsock);

	ACC_REJECTED = 0;
	if( setClientInfo(Conn,clSock,addr,clntinfo) == 0 ){
scan_condargs(Conn);
		if( 0 < MAXCONN_PCH && MAXCONN_PCH < Conn->cl_count ){
			ACC_REJECTED = 1;
			sv1log("Too many connections(%d) %s\n",
				Conn->cl_count,clntinfo);
		}else	ExecGeneralist(Conn,clsock,clsock);
		count = ClientCountDown();
	}else	count = -1;
mem_pops(SB_CONN);
DGLEV = SB_PROC;

	daemonlog("E","disconnected [%d] %s (%5.3fs)(%d)\n",
		clsock,clntinfo, Time()-ACCEPT_TIME,count);

	/*
	 * wait children to die if possible
	 * This seems be necessary to make the TCP connections to client
	 * be normally closed on Windows95/98 ...
	 */
	if( Conn->xf_filters ){
		int pid,wi,done;
		int nch,mask;

		close_filterctls(Conn);

		nch = 0;
		for( mask = 0; mask < 32; mask++ )
			if( (1 << mask) & Conn->xf_filters )
				nch++;

		done = 0;
		if( IsWindows95() )
		for( wi = 0; done < nch && wi < 5; wi++ ){
			while( 0 < (pid = NoHangWait()) ){
				done++;
				sv1log("CFI process [%d] done (%d/%d BEF-%d)\n",
					pid,done,nch,wi);
			}
			if( done < nch )
				msleep(100);
		}
		closeEfd(clSock);
		if( done < nch )
		for( wi = 0; done < nch && wi < 10; wi++ ){
			while( 0 < (pid = NoHangWait()) ){
				done++;
				sv1log("CFI process [%d] done (%d/%d AFT-%d)\n",
					pid,done,nch,wi);
			}
			if( done < nch )
				msleep(100);
		}
		if( done < nch )
			sv1log("CFI process remaining (%d/%d)\n",
				nch-done,nch);
	}

/* when `clsock' is closed in execGeneralist(), LOG_flushall() will reuse
 * the fd slot, then the slot will be closed in main as `clsock'.
 * Therefore call closeEfd() to avoid it... X-<
 */
	closeEfd(clSock);
	LOG_flushall();

	if( 0 <= LOG_center )
	if( have_publiclog() )
		put_publiclog(addr);
}

beginGeneralist(Conn,clsock)
	Connection *Conn;
{
	START_TIME1 = time(0);
	initConn(Conn,clsock);
	if( func_inetd(Conn,clsock) )
		rescanGlobal = 1;
	config(Conn,clsock);
	if( BORN_SPECIALIST )
		set_USER(Conn,clsock);
}
initDelegate1(Conn,fromC,toC)
	Connection *Conn;
{
	START_TIME1 = time(0);
	initConn(Conn,fromC);
	config(Conn,fromC);
}

callDelegate1(clsock,imsg,telehost,teleport)
	char *imsg,*telehost;
{	Connection ConnBuf, *Conn = &ConnBuf;

	initConn(Conn,clsock);
	config(Conn,clsock);
	DFLT_HOST[0] = 0; /* be Generalist ;-) */

	strcpy(TeleportHost,telehost);
	TeleportPort = teleport;

	if( imsg != NULL )
		DDI_pushCbuf(Conn,imsg,strlen(imsg));

	ExecGeneralist(Conn,clsock,clsock);
}

callSelf(clsock)
{	Connection ConnBuf, *Conn = &ConnBuf;

	initConn(Conn,clsock);
	config(Conn,clsock);
	Conn->from_myself = 1;
	return execGeneralist(Conn,clsock,clsock,-1);
}

static ExecGeneralist(Conn,fromC,toC)
	Connection *Conn;
{	int fpid;
	int mypid;
	int rcode;

	mypid = getpid();
	fpid = insert_FCLIENTS(Conn,&fromC,&toC);
	rcode = execGeneralist(Conn,fromC,toC,-1);
	if( 0 < fpid ){
		if( mypid == getpid() )
			Kill(fpid,SIGTERM);
		else{
			/* can be a NNTPCC process with FFROMCL ... */
			sv1log("NNTPCC ? PID=(%d -> %d) XF=%x\n",mypid,getpid(),
				Conn->xf_filters);
			Conn->xf_filters = 0;
		}
		NoHangWait();
	}
	return rcode;
}

static env2str(seqno,svsock,clSock)
	char *seqno;
	Efd *clSock;
{	int logfd;
	char svhost[256];
	int statfd;

	gethostnameIFIF(svhost,sizeof(svhost));

	logfd = curLogFd();

	/* statdata as a TMPFILE may not inherited to grand child on Win32 */
	if( iamServer() )
		statfd = put_svstat();
	else	statfd = -1;

sprintf(seqno,"%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%s/%s/%s/%d",
		SERVER_PORT(),
		IamPrivateMASTER,
		svsock,
		param_file,
		clSock->_fd,
		TOTAL_SERVED,
		SERNO(),
		NUM_CHILDREN,
		StickyReport[1],
		DELEGATE_LINGER,
		logfd,
		LOG_type,
		statfd,
		myPrivateMASTER,
		AF_UNIX_DISABLE,
		RES_localdns,
		svhost,
		SocknameOf(clSock),
		PeernameOf(clSock),
		clSock->_remote
	);
}
static EXEC_client1(Conn,path,func,svsock,clSock)
	Connection *Conn;
	char *path,*func;
	Efd *clSock;
{	int clsock = getEfd(clSock);
	char from[1024];
	char seqno[128];
	char stime[32];
	char alive[32];
	char abuff[MAX_ARGB];
	char *av[MAX_ARGC];
	char logtype[32];
	int ac,ai;
	int port;
	int rcode;
	char *cpath;
	int pid;
	int pass_svsock;

	pass_svsock = func != NULL &&
		(  streq(func,FuncSTICKY) && !ViaVSAPassociator(-1)
		|| streq(func,FuncFunc) );

	env2str(seqno,svsock,clSock);
	sendReservedPorts();
	Verbose("SEQNO: %s\n",seqno);

	ac = 0;
	av[ac++] = DeleGate1;
	av[ac++] = seqno;
	if( func != NULL ){
		av[ac++] = func;
	}else{
		scan_HOSTS0(Conn);
		strcpy(from,"src=");

/* getpeerName(clsock,from+4,PN_HOSTPORT); */
Conn->cl.p_connected = 1;
ClientSock = clsock;
if( port = getClientHostPort(Conn,from+4) )
sprintf(from+strlen(from),":%d",port);

		Verbose("%s\n",from);
		av[ac++] = from;
	}

	sprintf(stime,"%s=%d",P_START_TIME,START_TIME);
	av[ac++] = stime;
	sprintf(alive,"%s=%d",P_ALIVE_PEERS,NUM_CHILDREN);
	av[ac++] = alive;
	ac = DELEGATE_copyEnv(av,ac,path,abuff);
	sprintf(logtype,"-L0x%x/%d",LOG_type,curLogFd());
	av[ac++] = logtype;
	av[ac] = 0;

	if( func != NULL && streq(func,FuncFunc) ){
		for( ai = 0; ai < ac; ai++ ){
			if( strncmp(av[ai],"-F",2) == 0 ){
				ac = ai;
				av[ac] = 0;
				break;
			}
		}
	}

	if( !INHERENT_fork() ){
		setclientsock(clsock);
		if( pass_svsock )
			setserversock(svsock);
		return Spawnvp("EXEC_client1",path,av);
	}else{
		if( !pass_svsock )
			closeServPorts();
		Execvp("EXEC_client1",path,av);
	}
}

static idleTIMEOUT()
{
	longjmp(exec_env,-1);
}
setTimeout()
{
	setTimer(idle_timer,IDLE_TIMEOUT);
}
static EXEC_client(Conn,path,func,clSock)
	Connection *Conn;
	char *path,*func;
	Efd *clSock;
{
	idle_timer = pushTimer("EXEC_client",idleTIMEOUT,0);
	if( setjmp(exec_env) == 0 ){
		if( lSYNC() ){
			call_client1(Conn,clSock);
		}else
		if( !lEXEC() && func == NULL ){
			call_client1(Conn,clSock);
		}else	EXEC_client1(Conn,path,func,-1,clSock);
		closedups(0);
	}else{
		sv1log("TIMEOUT of idling.\n");
	}
	popTimer(idle_timer);
}

/*
 *	fork private MASTER if MASTER is not specified.
 *	this will be used for caching on {Gopher,FTP}/HTTP,
 *	and Connection Cache.
 */
static fork_MASTER(hostport,frominetd)
	char *hostport;
{	int svsock;
	int svport;
	char svhost[256];
	char *av[MAX_ARGC];
	int ai,ac;
	register int pid;
	char *env,logtype[32],logfile[1024],port[128],oport[128];
	char what[128],master[1024];
	char permit[128];
	char *name,epath[1024];
	int closestdIO;

	svhost[0] = 0;
	svport = 0;
	sscanf(hostport,"%[^:]:%d",svhost,&svport);
	if( svhost[0] == 0 )
		GetHostname(svhost,sizeof(svhost));
	svsock = server_open("delegate",svhost,svport,1);
	if( svsock < 0 )
		return -1;

	svport = sockPort(svsock);
	sprintf(hostport,"%s:%d",svhost,svport);

	printServPort(oport,"",0);

	ac = 0;
	if( name = strrpbrk(EXEC_PATH,"/\\") )
		name = name + 1;
	else	name = EXEC_PATH;
	av[ac++] = name;

	sprintf(what,"%s%s)",PrivateMasterOwner,oport);
	av[ac++] = what;
	sprintf(port,"-P0/%d",svsock);
	av[ac++] = port; 

	sprintf(logtype,"-L0x%x",LOG_type);
	av[ac++] = logtype;
	sprintf(logfile,"%s=%s++",P_LOGFILE,oport);
	av[ac++] = logfile; 

	ac += DELEGATE_copyEnvPM(&av[ac],NULL);

	if( getEnv(P_MASTERP) )
		ac += DELEGATE_copyEnvPM(&av[ac],P_MASTER);

	sprintf(permit,"%s=*:*:{.,localhost}",P_PERMIT);
	av[ac++] = permit;
	sprintf(epath,"%s=%s",P_EXEC_PATH,EXEC_PATH);
	av[ac++] = epath;
	av[ac] = 0;

	if( closestdIO = frominetd || IamCGI ){
		sv1log("## private-MASTER: frominetd=%d IamCGI=%d (%d,%d,%d)\n",
			frominetd,IamCGI,
			fileno(stdin),fileno(stdout),fileno(stderr));
	}

	if( !INHERENT_fork() ){
		if( closestdIO ){
			av[ac++] = "CLOSE-STDIO";
			av[ac] = 0;
		}
		setserversock(svsock);
		pid = Spawnvp("fork_MASTER",EXEC_PATH,av);
	}else{
		pid = Fork("private-MASTER");
		if( pid == 0 ){
			LOG_closeall();
			if( closestdIO ){
				fclose(stdin);
				fclose(stdout);
				fclose(stderr);
			}
			closeServPorts();
			Execvp("fork_MASTER",EXEC_PATH,av);
		}
	}
	close(svsock);
	return pid;
}

static unsetEnv(dav,sav,what)
	char *dav[],*sav[],*what;
{	char *arg;
	int len,ai,ac;

	len = strlen(what);
	ac = 0;
	for( ai = 0; sav[ai]; ai++ ){
		arg = sav[ai];
		if( strncmp(arg,what,len) == 0 )
			if( arg[len] == '=' || arg[len] == 0 )
				continue;
		dav[ac++] = arg;
	}
	dav[ac] = 0;
	return ac;
}

/*
 * Using private-MASTER even when connecting to HTTP might be
 * useful to control connection cache and keep-alive...
 */
static filterEnv(dav,sav)
	char *dav[],*sav[];
{	char *arg;
	int ai,ac;

	ac = 0;
	for( ai = 0; sav[ai]; ai++ ){
		arg = sav[ai];
		/* CONNECT and MASTER must be used in the private-MASTER. */
		if( strncmp(arg,"CONNECT=",8) == 0 ) continue;
		if( strncmp(arg,"MASTER=",7) == 0 ) continue;
		/* not to repeat execWithPrivateMASTER() */
		if( strncmp(arg,"MASTERP=",8) == 0 ) continue;
		/* -P with socket fd is set */
		if( strncmp(arg,"-P",2) == 0 ) continue;
		dav[ac++] = sav[ai];
	}
	dav[ac] = 0;
	return ac;
}
static execWithPrivateMaster(Conn,MasterP,frominetd)
	Connection *Conn;
	char *MasterP;
{	char *av[MAX_ARGC],port[128],master[128],masterp[128];
	char hostport[256];
	int ac;

	strcpy(hostport,MasterP);
	myPrivateMASTER = fork_MASTER(hostport,frominetd);
	if( myPrivateMASTER == 0 )
		return;

	ac = 0;
	if( 1 <= main_argc )
		av[ac++] = main_argv[0];
	av[ac++] = port; printServPort(port,"-P",1);
	av[ac++] = master; sprintf(master,"%s=%s",P_MASTER,hostport);
	av[ac++] = masterp; sprintf(masterp,"_masterp=%d",myPrivateMASTER);

	filterEnv(&av[ac],&main_argv[1]);
	filterEnv(environ,environ);

	if( !INHERENT_fork() ){
		setserversock(ServSock());
		Spawnvp("with-private-MASTER",EXEC_PATH,av);
		ServerPID = 0;
		closeServPorts();
		wait(0);
	}else{
		Execvp("with-private-MASTER",EXEC_PATH,av);
	}
	sv1log("private-MASTER forked: %s [%d]\n",hostport,myPrivateMASTER);
}

static finalize()
{
	killChildren();
	StickyKill(SIGHUPTERM);
	kill_CC();
	deleteWORKDIR();
}
/*
int (*DELEGATE_TERMINATE)() = finalize;
*/
static _TERMINATE()
{
	terminating = 1;
	sv1log("TERMINATE...\n");
	closeServPorts();
	finalize();
	LOG_deletePortFile();
	cleanup_zombis(0);
	sv1log("TERMINATED.\n");
}
int (*DELEGATE_TERMINATE)() = _TERMINATE;

#define ACC_FAILED	-1
#define ACC_TIMEOUTED	-2

/*
static _main();
int (*DELEGATE_MAIN)() = _main;
*/
static _start(ac,av)
	char *av[];
{
	_main(ac,av);
	sv1log("_main() done\n");
}
int (*DELEGATE_MAIN)() = _start;

static void sigALRM(sig)
{
	sv1log("AcceptByMain: Frozen (%s) ? try restart...\n",ABMwhere);
	sigHUP(0);
	Finish(-1);
}

/* do substitution for ${xxx} like ${VARDIR} ? */
char *absPathParam(param,prefix)
	char *param,*prefix;
{	char name[128],*vp,*rpath,apath[2048],*dp;
	char xparam[2048];
	int nonexist;

	if( (vp = strchr(param,'=')) == 0 )
		return 0;
	sscanf(param,"%[^=]",name);
	rpath = vp + 1;
	if( *rpath == 0 )
		return 0;

	if( isFullpath(rpath) )
		return 0;

	{	char cwd[1024];
		char *PATHSEP = "/";
		getcwd(cwd,sizeof(cwd));
		sprintf(apath,"%s%s%s",cwd,PATHSEP,rpath);
	}

	sprintf(xparam,"%s%s=%s",prefix,name,apath);
	if( nonexist = !File_is(apath) ){
		if( dp = strpbrk(apath," \t") ){
			*dp = 0;
			nonexist = !File_is(apath);
		}
		if( nonexist )
			fprintf(stderr,"CAUTION: nonexistent \"%s\"\n",xparam);
	}
	return stralloc(xparam);
}
substArgvAbstpath(ac,av)
	char *av[];
{	int ai;
	char *a1,*xa;

	for( ai = 0; ai < ac; ai++ ){
		a1 = av[ai];
		if( strchr(a1,'=') == 0 )
			continue;
		xa = 0;
		if( strncmp(a1,  "+/",2) == 0 ) xa = absPathParam(a1+2,""); else
		if( strncmp(a1,"-e+/",4) == 0 ) xa = absPathParam(a1+4,"-e");
		if( xa )
			av[ai] = xa;
	}
}
static setSTARTDIR()
{	char cwd[1024];

	if( getenv("STARTDIR") )
		return;

	*cwd = 0;
	getcwd(cwd,sizeof(cwd));
	if( *cwd != 0 )
		PutEnv("STARTDIR",cwd);
}
static setLIBPATH()
{	char libpath[1024];

	if( getenv(P_LIBPATH) )
		return;

	lineScan(DELEGATE_LIBPATH,libpath);
	substfile(libpath,"",NULL,NULL,NULL);
	PutEnv(P_LIBPATH,libpath);
}
static noargs()
{	char yn[128];
	char dgmsg[1024];

	put_identification(stderr);

	setDGROOT();
	putDGROOT(dgmsg);
	fprintf(stderr,"--\r\n%s",dgmsg);

	fprintf(stderr,"Do configuration ? y / [n] : ");
	fflush(stderr);
	fgets(yn,sizeof(yn),stdin);
	if( yn[0] != 'y' && yn[0] != 'Y' )
		exit(0);

	fprintf(stderr,"-------------------------\n");
	fprintf(stderr,"INTERACTIVE CONFIGURATION\n");
	fprintf(stderr,"-------------------------\n");
	fprintf(stderr,"## see http://www.delegate.org/delegate/tutorial/\n");
}
static scan_DELEGATE_ARGS()
{	char *dgargs,*dgav[128],dgargb[1024];
	int dgac,dgai;

	if( dgargs = getenv("DELEGATE_ARGS") ){
		sv1log("DELEGATE_ARGS=%s\n",dgargs);
		dgac = decomp_args(dgav,128,dgargs,dgargb);
		scan_args(dgac,dgav);
	}
}
static set_eRESTART(rtime){
	char reason[128],*rp;

	reason[0] = 0;
	rp = reason;
	if( RESOLV_UNKNOWN ){
		sprintf(rp,"(%d unknown host)",RESOLV_UNKNOWN);
		rp += strlen(rp);
	}
	if( SCRIPT_UNKNOWN ){
		sprintf(rp,"(%d unknown script)",SCRIPT_UNKNOWN);
		rp += strlen(rp);
	}
	sv1log("eRESTART in %d sec %s config err.\n",rtime,reason);
}

copyFileAndStat(src,dst)
	char *src,*dst;
{	FILE *sfp,*dfp;

	if( sfp = fopen(src,"r") ){
		if( dfp = fopen(dst,"w") ){
			copyfile1(sfp,dfp);
			file_copymod(fileno(sfp),fileno(dfp));
			fclose(dfp);
		}
		fclose(sfp);
	}
}
Chroot(rootpath,ac,av)
	char *rootpath,*av[];
{	int rcode,off,ai,nac;
	char *nav[MAX_ARGC];
	char xcompath[1024],dgrpath[1024],dgpath[1024],sdgpath[1024];
	char chrootok[1024];
	char *env;
	int withDGROOT,setDGROOT;
	int ei,ec;

	setDGROOT = 0;
	if( *rootpath == 0 || strcmp(rootpath,"/") == 0 ){
		/* DGROOT=/path + CHROOT=/ -> CHROOT=/path + DGROOT=/ */
		rootpath = DELEGATE_DGROOT;
		setDGROOT = 1;
	}

	for( ai = 0; ai < ac; ai++ ){
		if( strncmp(av[ai],"--CHROOT.",9) == 0 ){
			goto CHROOT_OK;
		}
	}
	rcode = chroot(rootpath);
	if( rcode == 0 )
		goto CHROOT_OK;

	if( fullpathSUCOM("dgchroot","r",xcompath) == 0 ){
		fprintf(stderr,"ERROR: %s not found\n","dgchroot");
		exit(-1);
	}

	sprintf(dgrpath,"subin/%s",av[0]);
	sprintf(dgpath,"%s/%s",rootpath,dgrpath);
	if( File_is(dgpath) == 0 ){
		if( fullpathLIB(av[0],"r",sdgpath) == 0 )
		if( fullpathCOM(av[0],"r",sdgpath) == 0 ){
			fprintf(stderr,"ERROR: %s not found\n",av[0]);
			exit(-1);
		}
		copyFileAndStat(sdgpath,dgpath);
	}

	withDGROOT = 0;
	nac = 0;
	nav[nac++] = xcompath;
	nav[nac++] = rootpath;
	nav[nac++] = dgrpath;
	for( ai = 0; ai < ac; ai++ ){
		if( strncmp(av[ai],"CHROOT=",7) == 0 ){
			continue;
		}
		if( strncmp(av[ai],"DGROOT=",7) == 0 ){
			if( setDGROOT ){
fprintf(stderr,"#### ignore original DGROOT\n");
				continue;
			}
			withDGROOT = 1;
		}
		nav[nac++] = av[ai];
	}
	if( withDGROOT == 0 ){
		nav[nac++] = "DGROOT=/";
	}
	sprintf(chrootok,"--CHROOT.%s",rootpath);
	nav[nac++] = chrootok;
	nav[nac] = 0;

	ec = 0;
	for( ei = 0; env = environ[ei]; ei++ ){
		if( strncmp(env,"CHROOT=",7) == 0 ){
			continue;
		}
		if( ei != ec ){
			environ[ec] = environ[ei];
		}
		ec++;
	}
	if( ei != ec )
		environ[ec] = 0;

	execvp(xcompath,nav);
	fprintf(stderr,"ERROR: failed %s for CHROOT=%s, errno=%d\n",
		xcompath,rootpath,errno);
	exit(-1);

CHROOT_OK:
	if( setDGROOT ){
		DELEGATE_DGROOT = "/";
	}
	return 0;
}

static delegate_main(ac,av)
	char *av[];
{	Connection MainConn;
	int code;
	char *root;

	minits();
	mainConn = &MainConn; set_textconvCTX(mainConn);

	setSTARTDIR();

	main_argc = ac;
	main_argv = dupv(av,0);
	LOG_stdlogfile = logfile;
	LOG_substfile  = substfile;
	syslog_init();

	if( streq(av[0],DeleGate1) )
	/* setup the logging environment inherited via spawn() */
	{	int lfd;
		char *env;
		if( 1 < ac && strncmp(av[ac-1],"-L0x",4) == 0 ){
			sscanf(&av[ac-1][4],"%x/%d",&LOG_type,&lfd);
			fdopenLogFile(lfd);
		}
		LOG_type |= L_ISCHILD;
		if( env = getEnv(P_RES_DEBUG) )
			RES_debug(env);
	}
	DO_STARTUP(ac,av); /* setup sessionfd() and WSAstartup() on Win32.
	 * It must be done as immediate as possible after invocation,
	 * not to let wait the parent DeleGate to finish spawn procedure, and
	 * not to use DNS (which may take seconds, use socket)
	 * before it is initizlied...
	 */

	substArgvAbstpath(ac,av);
	ScanFileDefs(mainConn);

	if( root = getEnv(P_CHROOT) ){
		/*
		if( chroot(root) != 0 ){
		*/
		if( Chroot(root,ac,av) != 0 ){
			fprintf(stderr,"DeleGate: chroot(%s) failed.\n",root);
			exit(-1);
		}
	}

	DO_INITIALIZE(ac,av);
	code = (*DELEGATE_MAIN)(ac,av);
	Finish(code);
}

static _main(ac,av)
	char *av[];
{	FILE *fp;
	int clsock;
	Efd *clSock = clientSocks;
	register int pid;
	char *name,*func,*ext;
	char *env;
	char *proto;
	Connection *Conn = mainConn;
	int xcode;
	int frominetd,isafilter,isteleportd;
	int issockmux;
	int istunnel1;
	int cnt;
	int restart;
	int reinit = 0;
	int IamServer;
	int ai;

	if( main_argc == 1 && 1 < ac ){
		/* started as a service on Windows, main() receives no
		 * arguments, then _main() receives real arguments via
		 * the ServiceStart. Thus DGROOT which was initialized
		 * in delegate_main() must be reinitialized here after. 
		 */
		DELEGATE_DGROOT = "";
	}
	main_argc = ac;
	main_argv = dupv(av,0);

	ACCEPT_TIME = Time();
	signal(SIGHUP,SIG_IGN);

	if( isFullpath(av[0]) )
		strcpy(EXEC_PATH,av[0]);
	else	wordscanX(av[0],EXEC_PATH,1024);

	/* set LIBPATH for library.a (ex. JIS.c)
	 * this must be done after EXEC_PATH is set.
	 */
	setLIBPATH();

	if( name = strrpbrk(EXEC_PATH,"/\\") )
		name = name + 1;
	else	name = EXEC_PATH;

	istunnel1 = 0;
	if( (func = getEnv(P_FUNC)) == 0 )
		func = name;
	for( ai = 1; ai < ac; ai++ ){
		if( strncmp(av[ai],"-F",2) == 0 ){
			func = &av[ai][2];
			Fopt = ai;
		}else
		if( strncmp(av[ai],"SERVER=tunnel1",14) == 0 ){
			istunnel1 = 1;
		}
	}

	if( (ext = strcasestr(func,".exe")) && ext[4] == 0 ){
		func = StrAlloc(func);
		*strcasestr(func,".exe") = 0;
	}

	if( strstr(func,"cgi") )
		IamCGI = 1;

	START_TIME1 = time(0);

	if( strncmp(func,"kill",4) == 0 ){
		scan_args(ac,av);
		kill_predecessor(ac,av,func+4,1);
		Finish(0);
	}

	ConnInit(Conn); /* set RPORTsock=-1 before -Ffunc */
	dont_check_param = 1;
	isFunc = DELEGATE_subfunc(Conn,ac,av,func,Fopt,0);
	dont_check_param = 0;

	frominetd = fromInetd();
	isafilter = 0;
	isteleportd = streq(func,"teleportd");
	issockmux = strcaseeq(func,"sockmux");
	IamPrivateMASTER = 0;

	if( !isFunc && !isteleportd )
	if( ac < 2 && !frominetd && !IamCGI ){
		noargs();
		editconf1(&ac,&av,stdin,stderr);
	}

	if( IamCGI ){
		setEXEC_PATH();
		if( env = getEnv(P_DGPATH) )
			DELEGATE_DGPATH = env;
		scan_DGPATH(DELEGATE_DGPATH);
		ac = scan_args(ac,av);
	}

	/*
	if( !isFunc || isteleportd )
	*/
	if( !isFunc || isteleportd || issockmux )
	if( !IamCGI )
	if( !streq(EXEC_PATH,DeleGate1) ) /* is the parent delegated */
	{
		ERROR_RESTART = 0;

		setEXEC_PATH();
		if( env = getEnv(P_DGPATH) )
			DELEGATE_DGPATH = env;
		scan_DGPATH(DELEGATE_DGPATH);

		ac = scan_args(ac,av);
		scan_DELEGATE_ARGS();

		if( ME.me_restart ){
			kill_predecessor(ac,av,"",0);
			ME.me_restart = 0;
		}

		reopenLogFile(); /* reopen LOGFILE with a proper PORT number */

		_setTMPDIR(getEnv(P_TMPDIR));
		if( !IamPrivateMASTER ){
			new_shared();
			if( env = getEnv(P_INPARAM) )
				new_param_file(env);

			if( !frominetd ){
				if( fromRsh() ){
					if( authRsh() != 0 )
						Finish(-1);
				}
			}
			if( istunnel1 ){
				setTeleportMASTER(Conn);
			}
			if( frominetd ){
				isafilter = 1;
				inetdServPort();
			}
		}
	}
	scanEnv(Conn,P_DGOPTS,scan_DGOPTS);

	if( getEnv(P_INETD) ){
		scanEnv(Conn,P_INETD,scan_INETD);
		/* "port stream tcp nowait owner SERVER=exec XFIL=... */
		/* "port stream tcp nowait owner SERVER=exec XCOM=... */
		/* "port stream tcp wait owner SERVER=... */
		/* PollIns(ports) */
		/* wait -- don't accept, just exec */
		/* nowait -- accept and exec */
	}

/*
	set_LOCKFILE();
*/
	scan_HOSTS0(Conn); /* gethostname() and "localhost" for init_myname() */
	init_resolv(getEnv(P_RESOLV),
		getEnv(P_RES_CONF),getEnv(P_RES_NS),getEnv(P_RES_VRFY),
		getEnv(P_RES_RR),getEnv(P_RES_DEBUG),getEnv(P_RES_LOG));
	scanEnv(Conn,P_SOCKOPT,scan_SOCKOPT);
	scanEnv(Conn,P_SOCKS,scan_SOCKS);
	scanEnv(Conn,P_SRCIF,scan_SRCIF);
	/*
	scan_RIDENT(getEnv(P_RIDENT));
	*/
	scan_RIDENT(Conn,getEnv(P_RIDENT));
	isFunc = DELEGATE_subfunc(Conn,ac,av,func,Fopt,1);

	if( streq(EXEC_PATH,DeleGate1) )
	{
		_setTMPDIR(getEnv(P_TMPDIR));/* for Resolvy cache originally */
		signal(SIGTERM,sigTERM1);
		signal(SIGINT, sigTERM1);
		signal(SIGHUP, sigTERM1);
		Exec_client(Conn,ac,av);
		Finish(0);
		fprintf(stderr,"\n[%d] DeleGate: exit from DeleGate1 failed.\n",
			getpid());
		return;
	}

	notify_ADMIN(Conn,"start");

	if( LOG_sockio[0] < 0 ){
		Socketpair(LOG_sockio);
		setNonblockingIO(LOG_sockio[1],1);
		expsockbuf(LOG_sockio[1],0,MAX_ARGB*2);
	}

	LOG_sock_enable = 1;
	inINITIALIZATION = 1;
	putSTART(frominetd);

	START_TIME = time(0);

	scan_HOSTS0(Conn);
	if( env = getEnv(P_TIMEOUT)) scanEnv(Conn,P_TIMEOUT,scan_TIMEOUT);
	if( env = getEnv(P_MAXIMA))  scanEnv(Conn,P_MAXIMA,scan_MAXIMA);

/* check UDP before mkEntrance */
proto = Scan_SERVER(Conn);
if( streq(proto,"cuseeme") ) DELEGATE_LISTEN = -1;
if( streq(proto,"udprelay") ) DELEGATE_LISTEN = -1;
if( streq(proto,"icp") ) DELEGATE_LISTEN = -1;
if( streq(proto,"dns") ) DELEGATE_LISTEN = -1;
if( streq(proto,"teleport") ) isteleportd = 1;

	if( !isteleportd )
	if( env = getEnv(P_LOGCENTER) )
		setLOGCENTER(env);

	/* 940930 beDaemon() moved before the TUNNEL_open to let
	 *        PGID of TUNNEL processes to be that of delegated.
	 */
	if( !lFG() && !lSYNC() )
	if( !IamPrivateMASTER )
	if( !istunnel1 )
	if( !issockmux )
	if( !IamCGI )
	if( activeServPort() == 0 )
		beDaemon(Conn);

	if( SERVER_PORT() == 0 )
	{
		if( isteleportd ){
			/* for compatibility with "teleportd" program */
			setSERVER_PORT("",8000,-1);
		}
	}

	if( streq(proto,"udprelay1") ){
		extern int IO_TIMEOUT;
		IO_TIMEOUT = 60;
		if( getEnv(P_CONNECT) == NULL )
			scan_CONNECT(Conn,"udp");
		setServUDP();
	}

	/*
	 * makeEntrance() is here to, may be(-_-;, to avoid giving
	 * SVsock to TUNNEL processes.
	 */
	scanEnv(Conn,P_VSAP,scan_VSAP);
	if( !ViaVSAPassociator(-1) ) /* NOT to accept at remote associator */
	if( !IamCGI )
	if( getEnv("_masterp") == 0 )/* NOT in execWithPrivateMASTER() */
	{
		recv_socks();
		makeEntrance();
		putREADY(isafilter,istunnel1);
	}
	RES_isself(ServSock());

	/*
	 * makeEntrance() should be before set_Owner() to use privireged port.
	 */
	if( set_Owner(1,getEnv(P_OWNER),curLogFd()) < 0 )
		Finish(-1);
	mkdirForSolaris(); /* should be after set_Owner() */
	proto = Scan_SERVER(Conn);

	/* These should be done after "SERVER" scanned
	 * (to use DFLT_PROTO in defaultPERMIT() ?)
	 */
	ScanGlobal(Conn,proto);
	if( !IamPrivateMASTER ){
		checkADMIN(Conn,proto);
		ScanFileDefs(Conn);
		if( checkCACHEDIR(Conn) != 0 )
			Finish(-1);
	}

	if( env = getEnv("LINGER") ) DELEGATE_LINGER = atoi(env);
	ServerPID = getpid();
	gotoWORKDIR();
	mount_all(Conn,proto);


	if( env = getEnv(P_TUNNEL) ){
		sv1log("SET TUNNEL AS MASTER: %s\n",env);
		scan_MASTER(Conn,"tty7:0/teleport");
	}

	if( IamPrivateMASTER ){
		int ai;
		for( ai = 0; ai < ac; ai++ )
			svlog("> arg[%d] %s\n",ai,av[ai]);
		/*
		somthing wrong (accept lock failure?)(at NNTP/HTTP proxy?)
		3.0.59: YES. lLOCK() was turned off in setupForSolaris()
		*/
		setStickyParams(Conn,proto);

	}else{
		if( env = getEnv("_masterp") ){
			myPrivateMASTER = atoi(env);
		}else
		if( env = getEnv(P_MASTERP) ){
			execWithPrivateMaster(Conn,env,frominetd);
		}else
		if( streq(proto,"http") ){
			compatV5info("No default private-MASTER. MASTERP=\"\"");
		}

		if( !lFORK() )
			setStickyParams(Conn,proto);

		ScanFileDefs(Conn);
		ScanEachConn(Conn);
		/*load_resources(Conn);*/
	}

	if( !isteleportd )
	if( IamPrivateMASTER || myPrivateMASTER == 0 )
		TeleportPID = TeleportServer(getEnv(P_TUNNEL),getEnv(P_INVITE));

	if( istunnel1 ){
		sv1log("TeleportPID = %d\n",TeleportPID);
		while( 0 < (pid = wait(0)) ){
			sv1log("child dead: pid=%d\n",pid);
			if( pid == TeleportPID )
				break;
		}
		goto EXIT;
	}

	if( !streq(proto,"http") )
		PEEK_CLIENT_REQUEST = 0;

	if( 0 < StickyMAX_PARA )
		PutPortFile(1);
	else	PutPortFile(0);

	signal(SIGURG, sigURG);
	signal(SIGBUS, sigFATAL);
	signal(SIGSEGV,sigFATAL);
	signal(SIGILL, sigFATAL);
	signal(SIGPIPE,sigPIPE);
	signal(SIGTERM,sigTERM);
	signal(SIGINT, sigTERM);
	if( istunnel1 )
		signal(SIGHUP, sigTERM);
	else	signal(SIGHUP, sigHUP);
	setWatchChild();

	if( StickyReport[0] < 0 || StickyReport[1] < 0 )
		Socketpair(StickyReport);

	pid = 0;
	DELEGATE_dumpEnv(NULL,1,IamPrivateMASTER);
	setLastModified();

	Verbose("Accept-LOCK: %d\n",LOG_type & L_LOCK);
	StickyProcs = (Proc*)StructAlloc((StickyMAX_PARA+1)*sizeof(Proc));

	sv0log("--INITIALIZATION DONE--\n");
	LOG_sock_enable = 0;
	inINITIALIZATION = 0;

	if( streq(proto,"cuseeme") ){
		service_cuseeme(Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	if( streq(proto,"icp") ){
		service_icp(Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	if( streq(proto,"dns") ){
		dns_init(SERVER_PORT());
		service_domain(Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	if( streq(proto,"sockmux") ){
		sox_main(ac,av,Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	isFunc = DELEGATE_subfunc(Conn,ac,av,func,Fopt,2);
	if( DELEGATE_LISTEN <= 0 ){
		int fdc,fdv[64];
		fdc = getServPorts(64,fdv);
		udp_relayX(Conn,fdc,fdv);
		goto EXIT;
	}

	if( isafilter )
	if(!istunnel1 ){
		if( execOnetimeFilter(Conn,clSock) == 0 )
			goto EXIT;
	}

	if( !IamPrivateMASTER && getpid() == ServerPID ){
		if( myPrivateMASTER ){
			/* wait the private-MASTER ready */
		}
		if( fromRsh() && SERVER_PORT() != 0 ){
			RshWatcher(NUM_HUPS,SERVER_PORT());
		}
	}

	MainLastAccept = time(0);

	/*
	if( ERROR_RESTART )
	*/
	if( 0 < MAX_ERESTART )
	if( RESOLV_UNKNOWN || SCRIPT_UNKNOWN ){
		/*
		SERVER_RESTART = (NUM_HUPS+1)*(NUM_HUPS+1)*ERROR_RESTART;
		sv1log("SERVER_RESTART=%d (%d)\n",SERVER_RESTART,NUM_HUPS);
		*/
		if( NUM_HUPS <  MAX_ERESTART && 0 < ERROR_RESTART ){
		SERVER_RESTART = ERROR_RESTART;
		set_eRESTART(ERROR_RESTART);
		}
		if( NUM_HUPS == MAX_ERESTART && 0 < ERROR_RESTART
		 || NUM_HUPS == 0 && ERROR_RESTART == 0
		){
			sv1log("#### restarting is set on config err.\n");
			reinit = 1;
		}
	}
	if( SERVER_RESTART ){
		int now;
		char date[64];

		now = time(0);
		if( 3600*24 <= SERVER_RESTART )
			restart = timeBaseDayLocal(now) + SERVER_RESTART;
		else	restart = ((now/SERVER_RESTART)+1) * SERVER_RESTART;
		StrftimeLocal(date,sizeof(date),TIMEFORM_HTTPD,restart);
		sv1log("RESTART at %s\n",date);
	}

	IamServer = (getpid() == ServerPID);
	if( IamServer ){
		set_CC();
	}

	if( frominetd ){
		/* NDELAY may be left ON by former user of the socket */
		SetNonblockingIO("svsock",ServSock(),0);
		/*
		repetitive listen() is fatail at least in Solaris2.6
		set_listenX(ServSock(),DELEGATE_LISTEN);
		*/
	}

	if( IamServer && LOG_VERBOSE && getEnv(P_URICONV) ) dumpHTMLCONV();

	signal(SIGALRM,sigALRM);

	/*
	if( LOG_type & L_REINIT && NUM_HUPS == 0 ){
	*/
	if( ViaVSAPassociator(-1) == 0 ) /* no local connect with -Pxxx@vsap */
	if( reinit || (LOG_type & L_REINIT) && NUM_HUPS == 0 ){
		int nready,sockv[FD_SETSIZE],udpv[FD_SETSIZE];
		sv1log("#### wait the first contact...\n");
		nready = pollServPort(0,sockv,udpv,NULL);
		sv1log("#### got the first contact\n");
		sigHUP(0);
	}

	for(cnt = 1;;cnt++){
		int idle,timeout,logtimeout,svsock;
		int now,sched_next;

		cleanup_zombis(0);
		if( restartPrivateMASTER ){
			restartPrivateMASTER = 0;
			if( IamServer ){
				sigHUP(0);
				break;
			}
		}

		load_params(Conn);

		TOTAL_SERVED = CHILD_SERNO_SINGLE + StickyNserved; 

		if( IamPrivateMASTER && getppid() != IamPrivateMASTER ){
			sv1log("private-MASTER DONE: OWNER seems dead. %d/%d\n",
				getppid(),IamPrivateMASTER);
			break;
		}

		if( MAX_SERVICE ){
			if( MAX_SERVICE <= TOTAL_SERVED ){
				sv1log("MAX_SERVICE done: %d\n",MAX_SERVICE);
				break;
			}
		}

		now = time(0);
		if( SERVER_TIMEOUT ){
			idle = now - MainLastAccept;
			if(  SERVER_TIMEOUT < idle ){
				sv1log("SERVER_TIMEOUT: %d seconds.\n",idle);
				break;
			}
		}

		mainProcTitle(Conn);
		logtimeout = logTimeout();
		if( 0 < NUM_CHILDREN || IamPrivateMASTER ){
			timeout = 60;
			if( logtimeout != 0 && logtimeout < timeout )
				timeout = logtimeout;
		}else{
			timeout = logtimeout;
			if( timeout <= 0 )
				timeout = 0;
		}

		if( SERVER_RESTART ){
			int rstimeout;

			rstimeout = restart - now;
			if( timeout == 0 || rstimeout < timeout ){
				timeout = rstimeout;
				if( timeout <= 0 ){
					sigHUP(0);
					break;
				}
			}
		}

		if( SERVER_TIMEOUT )
		if( timeout == 0 || SERVER_TIMEOUT < timeout )
			timeout = SERVER_TIMEOUT;

if( !IamPrivateMASTER && IamServer )
if( timeout <= 0 || 15 < timeout )
timeout = 15;

sched_next = sched_execute(now,sched_action,Conn);
if( now < sched_next && sched_next-now < timeout )
	timeout = sched_next-now;

if( RESTART_NOW ){
	RESTART_NOW = 0;
	sigHUP(0);
	break;
}

		/*putStatus("Accept(%d,1,%d): nch=%d\n",ServSock(),timeout,
			NUM_CHILDREN);*/

		if( DELEGATE_PAUSE ){
			sleep(10);
			continue;
		}

		if( 0 < SIGALRM ) alarm(300);
		clsock = AcceptByMain(Conn,timeout,&svsock,clSock);
		if( 0 < SIGALRM ) alarm(0);

		if( clsock < 0 ){
			if( terminating ){
				sv1log("main loop break on TERMINATE.\n");
				return;
			}
			/*putStatus("TIMEOUT\n");*/
			LOG_checkAged(0);
			if( clsock != ACC_TIMEOUTED )
				msleep(ACC_BYMAIN_INTERVAL);
			continue;
		}else{
			putLoadStat(ST_ACC,1);
			MainNaccepted++;
			if( lSYNC() ){ 
				CHILD_SERNO_MULTI++;
			}else	CHILD_SERNO++;
		}

		MainLastAccept = time(0);
		/*putStatus("Accepted[%d]\n",CHILD_SERNO);*/

		if( lSYNC() ){
			StickyNserved++;
			EXEC_client(Conn,EXEC_PATH,NULL,clSock);
			initConn(Conn,-1);
		}else
		if( !lEXEC() && StickyActive < StickyMAX_PARA ){
			pid = forkStickyServer(Conn,svsock,clSock);
/*
if( pid <= 0 ){
	sv1tlog("CANNOT FORK Sequential, (%d children)\n",StickyActive);
	cleanup_zombis(0);
	pid = forkStickyServer(Conn,svsock,clSock);
and set MAXIMA=delegated automatically temporalily ?
}
*/
			if( pid <= 0 ){
				TraceLog("? cannot fork Sticky (%d)\n",errno);
				sv1tlog("CANNOT FORK Sequential (%d)\n",errno);
			}else{
				StickyAdd(pid);
				NUM_CHILDREN++;
				logChild("StickyServer",1);
			}
		}else{
			pid = forkOnetimeServer(Conn,svsock,clSock,isafilter);
			if( pid == -1 ){
				TraceLog("? cannot fork Onetime (%d)\n",errno);
				sv1tlog("CANNOT FORK Onetime (%d)\n",errno);
			}else{
				NUM_CHILDREN++;
				logChild("OntimeServer",1);
				CHILD_SERNO_SINGLE++;
				putLoadStat(ST_DONE,1);
				MainNserved++; /* must be done at wait() ... */ 
			}
			if( pid == -1 ){
				sleep(10);
			}
		}
		closeEfd(clSock);
	}

EXIT:
	if( 0 < StickyActive )
		WaitX(0);
	finalize();
	notify_ADMIN(Conn,"stop");
	Exit(0,"");
}

forkStickyServer(Conn,svsock,clSock)
	Connection *Conn;
	Efd *clSock;
{	int clsock = getEfd(clSock);
	int pid;

	if( !INHERENT_fork() ){
		setcontrolsock(StickyReport[1]);
		pid = EXEC_client1(Conn,EXEC_PATH,FuncSTICKY,svsock,clSock);
		return pid;
	}

	if( pid = Fork("SequentialServer") )
		return pid;
	setNoExec();

	close(StickyReport[0]); StickyReport[0] = -1;
	NUM_PEERS = NUM_CHILDREN;
	StickyServer(Conn,clSock,StickyMAX_LIFE);
	Finish(0);
}
forkOnetimeServer(Conn,svsock,clSock,isafilter)
	Connection *Conn;
	Efd *clSock;
{	int clsock = getEfd(clSock);
	int pid;

	if( !INHERENT_fork() ){
		pid = EXEC_client1(Conn,EXEC_PATH,NULL,-1,clSock);
		return pid;
	}

	if( pid = Fork("OnetimeServer") )
		return pid;
	setNoExec();

	if( !isafilter )
		closeServPorts();
	close(StickyReport[0]); StickyReport[0] = -1;
	setProcTitleHead(DeleGate1,main_argc,main_argv);
	NUM_PEERS = NUM_CHILDREN;
	EXEC_client(Conn,EXEC_PATH,NULL,clSock);
	Finish(0);
}

putSTART(frominetd)
{	char uname[128];
	char inetd[128],rsh[128];

	Uname(uname);
	if( frominetd )
		sprintf(inetd,"[viaInetd]");
	else	inetd[0] = 0;
	if( fromRsh() )
		sprintf(rsh,"[viaRsh]");
	else	rsh[0] = 0;

	sv0log("--INITIALIZATION START: %s on %s--%s%s\n",
		DELEGATE_ver(),uname,inetd,rsh);
}
static putDGROOT(dgmsg)
	char *dgmsg;
{	char *dgroot;

	dgmsg[0] = 0;
	dgroot = getEnv(P_DGROOT);
	if( *DELEGATE_DGROOT ){
		if( dgroot == 0 ){
		compatV5info("DGROOT=%s is set automatically. DGROOT=\"\"",
				DELEGATE_DGROOT);
		}
		if( dgroot && strcmp(dgroot,DELEGATE_DGROOT) != 0 )
			sprintf(dgmsg,"NOT-USED DGROOT=%s\n",dgroot);
		sprintf(dgmsg+strlen(dgmsg),"DGROOT=%s\r\n",DELEGATE_DGROOT);
	}else{
		if( dgroot != 0 )
			sprintf(dgmsg,"FAILED DGROOT=%s\n",dgroot);
		else	sprintf(dgmsg,"FATAL!!!! NO DGROOT !!!!\n");
	}
}
static putREADY(isafilter,istunnel1)
{	char msg[1024],port[128];
	char dgmsg[1024];
	char *admin;

	putDGROOT(dgmsg);
	if( *dgmsg )
		sv1log("%s",dgmsg);
	admin = getADMIN1();
	sprintf(dgmsg+strlen(dgmsg),"ADMIN=%s\r\n",admin?admin:"");

	printServPort(port,"-P",0);
	sprintf(msg,"<%s> [%d] %s READY\r\n",DELEGATE_version(),
		getpid(),port);
	svlog("%s",msg);
	if( istunnel1 ){
		fputs(msg,stdout);
		fflush(stdout);
	}else
	if( !isafilter )/* suppress the banner if from inetd */
	if( isatty(fileno(stderr)) || fromRsh() ){
		fputs(msg,stderr);
		fputs(dgmsg,stderr);
		fprintf(stderr,"%s\r\n",DELEGATE_copyright());
	}

	printServPort(port,"",1);
	if( istunnel1 )
		sv1log("PORT= 0 TeleportTunnel dummy=%s\n",port);
	else{
		char ftpport[64];
		int porti;
		if( (porti = atoi(port)) == 0 )
			sscanf(port,"%*[^:]:%d",&porti);
		sprintf(ftpport,"%d,%d",porti/256,porti%256);
		sv1log("PORT= %s (%s)\n",port,ftpport);
	}
}
service_tunnel1(Conn)
	Connection *Conn;
{
	sv1log("#### service_tunnel\n");
}
setEXEC_PATH()
{	char *env;

	if( env = getEnv(P_EXEC_PATH) )
		strcpy(EXEC_PATH,env);
	else	FullpathOfExe(EXEC_PATH);
}
setLOGCENTER(center)
	char *center;
{	char host[256],ifhost[256],hostport[256];
	int port;

	if( *center == 0 )
		center = DELEGATE_LOGCENTER;
	port = 8000;
	sscanf(center,"%[^:]:%d",host,&port);
	gethostnameIFIF(ifhost,sizeof(ifhost));
	LOG_center = UDP_client_open1("frog","frog",host,port,
			ifhost,SERVER_PORT());
	setCloseOnExec(LOG_center);

	/*
	gethostName(LOG_center,hostport,PN_ADDRPORT);
	put_publiclog("I","DeleGate.Start %s\n",hostport);
	*/
}
execOnetimeFilter(Conn,clSock)
	Connection *Conn;
	Efd *clSock;
{	char hostn[256];
	int port;
	int clsock,fds[3];
	int pid,xpid;

	port = getpeerNAME(0,hostn);
	if( port <= 0 )
		return -1;

	/* connected, in nowait mode from inetd */

	if( lTRACE() ){
		if( pid = Fork("FilterTrace") ){
			TraceLog("tracing OnetimeFilter... %d\n",pid);
			xpid = WaitX(0);
			TraceLog("tracing OnetimeFilter DONE: %d\n",xpid);
			return 0;
		}
		setNoExec();
	}

	clsock = randfd(0);
	fds[0] = fds[1] = fds[2] = -1;
	if( 0 < clsock ){ fds[0] = open("/dev/null",0); }
	if( peerPort(1) == port ){ fds[1] = dup2(curLogFd(),1); }
	if( peerPort(2) == port ){ fds[2] = dup2(curLogFd(),2); }
	svlog("ONE-TIME SERVER(in nowait from inetd)[%d]%d,%d,%d\n",
		clsock,fds[0],fds[1],fds[2]);
	setEfd(clSock,clsock,"","",0);
	EXEC_client(Conn,EXEC_PATH,NULL,clSock);
	if( lTRACE() )
		Finish(0);
	else	return 0;
}
setTeleportMASTER(Conn)
	Connection *Conn;
{	char master[256];

	sprintf(master,"tty7:0/teleport:!*");
	scan_MASTER(Conn,master);
	pushEnv(P_INVITE,"*");
}

static breakStickies(shlock)
{	int idle;
	int timeout;
	int ndead;

	if( ndead = cleanup_zombis(1) )
	sv1log("AcceptByMain: Sticky*%d/%d cleared before trying ex-lock\n",
		ndead,StickyActive);

	ABMwhere = "breaking";
	timeout = StickyTIMEOUT;
	if( timeout < 10 ) timeout = 10; else
	if( 60 < timeout ) timeout = 60;
/*
 * timeout *= 1000;
 * because timeout in lock_exclusiveTO() is in milli-seconds.
 */

	sv1log("AcceptByMain: Wait Frozen Sticky*%d become active ...\n",
			StickyActive);

	if( lock_exclusiveTO(shlock,timeout,NULL) == 0 ){
		lock_unlock(shlock);
		idle = time(0) - lockedoutT;
		sv1log("AcceptByMain: Frozen Sticky*%d become active (%ds)\n",
			StickyActive,idle);
		return;
	}

	/* Try normal termination first.  Sending SIGHUP is not harmful
	 * for Stickies because they are blocking the signal during
	 * the execution of its service for a client.
	 */
	if( ndead = cleanup_zombis(1) )
	sv1log("AcceptByMain: Sticky*%d/%d cleared before sending SIGHUP\n",
		ndead,StickyActive);

	if( StickyKill(SIGHUP) ){
		sleep(5);
		while( 0 < (ndead = cleanup_zombis(1)) ){
			sv1log("AcceptByMain: Sticky*%d/%d cleaned by SIGHUP\n",
				ndead,StickyActive);
			sleep(1);
		}
	}

	sv1log("AcceptByMain: Wait Frozen Sticky*%d cleaned by SIGHUP ...\n",
		StickyActive);

	if( lock_exclusiveTO(shlock,timeout,NULL) == 0 ){
		lock_unlock(shlock);
		idle = time(0) - lockedoutT;
		sv1log("AcceptByMain: Frozen Sticky*%d were cleaned (%ds)\n",
			StickyActive,idle);
		return;
	}

	idle = time(0) - lockedoutT;
	sv1log("AcceptByMain: KILL Frozen Sticky*%d (%ds) %d/%d\n",
		StickyActive, idle, StickyNserved,StickyDone);

	daemonlog("F","E-F: kill Frozen Sticky*%d (%ds)\n",StickyActive,idle);
	if( StickyKill(SIGKILL) ){
		sleep(5);
		cleanup_zombis(1);
	}

	idle = time(0) - lockedoutT;
	if( lock_exclusiveTO(shlock,timeout,NULL) == 0 ){
		sv1log("AcceptByMain: Frozen Sticky*%d were KILLED (%ds)\n",
			StickyActive,idle);
	}else{
		sv1log("AcceptByMain: couldn't KILL Frozen Sticky*%d (%ds)\n",
			StickyActive,idle);
		sv1log("AcceptByMain: #### restarting may fail... ####\n");
	}

	if( fromInetd() )
		sigTERM(0);
	else	sigHUP(0);
	Finish(-1);
}
static locked_out(shlock)
{	int now,idle,nserved,ndone,reset;
	int (*LF)(),svlog(),svvlog();

	now = time(0);
	reset = 0;
	if( ndone = StickyDone - lastdoneN ){
		lastdoneN = StickyDone;
		lockedoutT = now;
		reset = 1;
	}
	if( nserved = StickyNserved - lastserveN ){
		lastserveN = StickyNserved;
		lockedoutT = now;
		reset = 1;
	}
	if( lockedoutN == 0 ){
		lockedoutT = now;
		reset = 1;
	}
	if( lockedoutT < StickyLastAccept ){
		sv1log("## lockedoutT:%d < StickyLastAccept:%d\n",
			lockedoutT,StickyLastAccept);
		lockedoutT = StickyLastAccept;
	}

	idle = now - lockedoutT;
	if( ++lockedoutN % 10 == 0 || reset )
		LF = svlog;
	else	LF = svvlog;
	(*LF)("AcceptByMain: locked out*%d/%d by Sticky*%d %d/%d\n",
		lockedoutN,idle,StickyActive,nserved,ndone);

	/*
	 * A Sticky server possibly frozen in accept() ...
	 * Kill them and restart emulating SIGHUP.
	 */
	if( ACC_NONE_TIMEOUT < idle ){
		breakStickies(shlock);
		lockedoutT = time(0);
	}
}

AcceptByMain1(timeout,exlock,svsock,sockname)
	char *sockname;
{	int clsock;
	int shlock;
	int ocsock,nvfd;
	char vfd[2048];

	shlock = PortLockFd();

	if( 0 < StickyActive && 0 <= shlock ){
		ABMwhere = "locking";
		if( lock_exclusiveNB(shlock) != 0 ){
			locked_out(shlock);
			return ACC_FAILED;
		}
		lockedoutN = 0;

		if( PollIn(svsock,1) <= 0 ){
			sv1log("AcceptByMain: yielded to a Sticky (%d)\n",
				StickyActive);
			lock_unlock(shlock);
			return ACC_FAILED;
		}
	}

	ABMwhere = "accepting1";
	clsock = ACCEPT1(svsock,1,exlock,1,sockname);
	ocsock = clsock;
	clsock = randfd(clsock);
	if( lTRVERB() ){
		nvfd = valid_fdl(vfd);
		TraceLog("accepted %d -> %d (%d child, %d act-fds)\n",
			ocsock,clsock,NUM_CHILDREN,nvfd);
	}
	ACCEPT_TIME = Time();
	if( clsock < 0 )
		sv1log("AcceptByMain[%d]: taken by a Sticky (%d)?\n",svsock,
			StickyActive);

	if( StickyActive && 0 <= shlock )
		lock_unlock(shlock);

	return clsock;
}
static int pollServPortAndSticky(timeout,sockv,udpv)
	int *sockv,*udpv;
{	int rtimeout;
	int optv[2],nready,si,sock1;
	double Start;

	optv[0] = StickyReport[0];
	optv[1] = -1;

	for( rtimeout = timeout; ; rtimeout -= 1000*(Time()-Start) ){
		if( rtimeout <= 0 ){
			sv1log("AcceptByMain: polling timeout = %d / %d\n",
				rtimeout,timeout);
			break;
		}
		Start = Time();
		nready = pollServPort(rtimeout,sockv,udpv,optv);
		if( nready <= 0 )
			break;
		for( si = 0; si < nready; si++ ){
			sock1 = sockv[si];
			if( sock1 == StickyReport[0] ){
Verbose("AcceptByMain: got Sticky REPORT 1/%d\n",nready);
				getStickyReports();
				cleanup_zombis(0);
				sockv[si] = -1;
				nready--;
			}
		}
		if( 0 < nready )
			break;
	}
	return nready;
}
static AcceptByMain(Conn,timeout,svsockp,clSock)
	Connection *Conn;
	int *svsockp;
	Efd *clSock;
{	int clsock;
	int sx,nready,sockv[FD_SETSIZE],udpv[FD_SETSIZE];
	int exlock,sock1;
	char primport[256];
	char sockname[256],peername[256];
	int remote;

	if( ViaVSAPassociator(-1) ){
		if( VSAP_TIMEOUT ) timeout = VSAP_TIMEOUT;
		ABMwhere = "VSAPbind-accept";
		clsock = CTX_VSAPbindaccept(Conn,timeout,1,sockname,peername);
		if( 0 <= clsock ){
			setEfd(clSock,clsock,sockname,peername,1);
		sv1log("AcceptByMain: VSAP[%s<-%s]\n",sockname,peername);
			return clsock;
		}
		ABMwhere = "VSAPbind-accept-failed";
		sleep(5);
		return -1;
	}

	ABMwhere = "polling";
	gotSIGTERM = 0;
	if( lSIGCHLD() ){
		int rtimeout,ntry;
		double Start,Elps;

		Start = Time();
		rtimeout = timeout * 1000;
		sigsetmask(sigblock(0) & ~sigmask(SIGCHLD));
		for( ntry = 0;; ntry++ ){
			errno = 0;
			nready = pollServPortAndSticky(rtimeout,sockv,udpv);
			Elps = Time() - Start;
			rtimeout = timeout*1000 - Elps*1000;
			if( lTRVERB() ){
TraceLog("AcceptByMain: poll*%d nready=%d errno=%d ELP=%d %d/%d\n",
				ntry,nready,errno,
				(int)(Elps*1000),rtimeout,timeout*1000);
			}
			if( 0 < nready || errno != EINTR || rtimeout <= 0 )
				break;
			mainProcTitle(Conn);
			if( lTRVERB() ){
TraceLog("AcceptByMain: retry poll*%d nready=%d timeout=%d/%d\n",
				ntry,nready,rtimeout,timeout);
			}
		}
		sigsetmask(sigblock(0) |  sigmask(SIGCHLD));
		if( lTRVERB() ){
TraceLog("AcceptByMain: poll SIGCHLD END SD=%d,LD=%d,SN=%d,LN=%d,LO=%d\n",
				StickyDone,lastdoneN,
				StickyNserved,lastserveN,lockedoutN);
		}
	}else{
		nready = pollServPortAndSticky(timeout*1000,sockv,udpv);
	}
	if( nready <= 0 ){
		if( terminating ){
			sv1log("AcceptByMain: break on TERMINATE.\n");
			return ACC_FAILED;
		}
		if( getpid() == ServerPID ){
			int port;

			port = sockPort(ServSock());
			if( port <= 1 ){
				sv1log("RESTART ON RESUME ? -P%d SIGTERM=%d\n",
					port,gotSIGTERM);
				if( gotSIGTERM )
					return ACC_FAILED;
				sleep(1);
				sigHUP(-1);
			}
		}
		if( Ntimeout == 0 )
		svvlog("AcceptByMain: TIMEOUT(children=%d, timeout=%d)\n",
			NUM_CHILDREN,timeout);
		Ntimeout++;
		return ACC_TIMEOUTED;
	}
	Ntimeout = 0;

	ABMwhere = "accepting";
	primaryPort(primport);
	for( sx = 0; sx < nready; sx++ ){
/*
if connected, then it is from VSAP server
 */
		sock1 = sockv[sx];
		if( lLOCK() )
			exlock = PortLocks(primport,0,NULL);
		else	exlock = -1;

		if( udpv[sx] ){
			clsock = UDPaccept(sock1,exlock,timeout);
			/* parallel accept of UDP does not work without
			 * SO_REUSEPORT.  So it must not inherited to
			 * StickyProcess...
			 */
			StickyMAX_PARA = 0;
		}else	clsock = AcceptByMain1(timeout,exlock,sock1,sockname);
		if( 0 <= clsock ){
			setEfd(clSock,clsock,sockname,"",0);
			*svsockp = sockv[sx];
			return clsock;
		}
	}

	return ACC_FAILED;
}
static AcceptBySticky1(Conn,timeout,shlock,exlock,clSock)
	Connection *Conn;
	Efd *clSock;
{	int clsock = -1;
	int sx,nready,sockv[FD_SETSIZE],udpv[FD_SETSIZE];
	char sockname[256],peername[256];
	int remote;

	if( ViaVSAPassociator(-1) ){
		if( VSAP_TIMEOUT ) timeout = VSAP_TIMEOUT;
		clsock = CTX_VSAPbindaccept(Conn,timeout,0,sockname,peername);
		if( 0 <= clsock ){
			setEfd(clSock,clsock,sockname,peername,1);
		sv1log("AcceptBySticky: VSAP[%s<-%s]\n",sockname,peername);
			return clsock;
		}
		sleep(5);
		return -1;
	}

	if( 0 <= shlock )
	if( lock_sharedTO(shlock,timeout*1000,NULL) != 0 ){
		sv1log("AcceptBySticky: lock timeout\n");
		return -1;
	}

	/*
	 * can poll with StickyReport[1] to check if closed on
	 * the death of the parent ...
	 */
	nready = pollServPort(timeout*1000,sockv,udpv,NULL);

	if( nready <= 0 )
		goto EXIT;

	for( sx = 0; sx < nready; sx++ ){
		if( udpv[sx] )
			clsock = UDPaccept(sockv[sx],exlock,timeout);
		else	clsock = ACCEPT(sockv[sx],1,exlock,timeout);
		if( 0 <= clsock )
			break;
	}
	clsock = randfd(clsock);
	ACCEPT_TIME = Time();
EXIT:
	if( 0 <= shlock )
		lock_unlock(shlock);

	if( 0 <= clsock ){
		remote = RIDENT_recv(clsock,sockname,peername);
		if( remote < 0 ){
			close(clsock);
			clsock = -1;
		}else{
			setEfd(clSock,clsock,sockname,peername,remote);
		}
	}
	return clsock;
}
static AcceptBySticky(Conn,timeout,shlock,exlock,clSock)
	Connection *Conn;
	Efd *clSock;
{	int clsock;
	int timeout1,rtimeout;

	Verbose("StickyServer: start accept()\n");
	for( rtimeout = timeout; 0 < rtimeout; rtimeout -= timeout1 ){
		ProcTitle(Conn,"*standby=%ds",rtimeout);
		if( StickyTIMEOUT1 < rtimeout )
			timeout1 = StickyTIMEOUT1;
		else	timeout1 = rtimeout;
		clsock = AcceptBySticky1(Conn,timeout1,shlock,exlock,clSock);
		if( 0 < clsock )
			break;
	}
	if( 0 <= clsock ){
		char accReport[1];
		SReport SR;
		Verbose("## AcceptBySticky: SEND ACCEPT REPORT\n");
		/*
		accReport[0] = 0;
		write(StickyReport[1],accReport,1);
		*/
		SR.s_stat = SR_ACCEPT;
		SR.s_done = 0;
		SR.s_pid = getpid();
		write(StickyReport[1],&SR,sizeof(SR));
	}
	return clsock;
}

static int start0;
static int nreq;
static reportNserv(stat,start,nreq)
	char *stat;
{	char nconn;
	void (*osig)();
	SReport SR;

	if( StickyReport[1] < 0 )
		return;

	/* might get SIGALRM in accept(), free accept lock immediately */
	if( PortLockFd() != -1 )
		close(PortLockFd());

	nconn = CHILD_SERNO_MULTI + nreq;

	SR.s_stat = SR_FINISH;
	if( BREAK_STICKY & SR_DETACH )
		SR.s_stat |= SR_DETACH;
	SR.s_done = nconn;
	SR.s_pid = getpid();

	osig =
	signal(SIGPIPE,SIG_IGN);
	/*
	write(StickyReport[1],&nconn,1);
	*/
	write(StickyReport[1],&SR,sizeof(SR));
	close(StickyReport[1]);
	StickyReport[1] = -1;
	signal(SIGPIPE,osig);

	sv1log("StickyServer done [%s] %d req / %d conn / %d sec\n",
		stat,CHILD_SERNO_MULTI+nreq,CHILD_SERNO_MULTI,time(0)-start);
	/*
	Finish(0);
	*/
}
stopStickyServer(why)
	char *why;
{
	BREAK_STICKY = SR_DETACH;
	reportNserv(why,start0,nreq+1);
}
static void sigHUPforAbort(sig){
	closeServPorts();
	sv1log("StickyServer SIGHUPed after %d services.\n",CHILD_SERNO_MULTI);
	Finish(0);
}
static isStickyProto(Conn)
	Connection *Conn;
{	int nntps,otimeout;
	char *proto;

	if( IsInternal ) return 1;

	proto = DFLT_PROTO;
	if( strcaseeq(iSERVER_PROTO,"socks") )  return 1;
	if( strcaseeq(proto,"vsap") )  return 1;
	if( strcaseeq(proto,"http") )	return 1;
	if( strcaseeq(proto,"gopher") )	return 1;
	if( strcaseeq(proto,"ftp") && IsAnonymous ) return 1;

	if( localPathProto(proto) && IsLocal )
	if( streq(iSERVER_PROTO,"http") )
		return 1;

	if( strcaseeq(proto,"nntp") || strcaseeq(proto,"ftp") )
	if( streq(iSERVER_PROTO,"http") && !ACT_GENERALIST )
		 return 1;

	return 0;
}
setStickyParams(Conn,proto)
	Connection *Conn;
	char *proto;
{
	if( 0 < STANDBY_MAX )
	if( streq(proto,"http")
/*	 || streq(proto,"https") */ /* should be enabled ... */
	 || streq(proto,"vsap")
	 || streq(proto,"socks")
	 || BORN_SPECIALIST == 0 ){
		StickyMAX_PARA = MAX_DELEGATE;
		StickyMAX_LIFE = STANDBY_MAX * 4;
		StickyTIMEOUT  = STANDBY_TIMEOUT;
	}
}

StickyServer(Conn,clSock,max)
	Connection *Conn;
	Efd *clSock;
{	int clsock;
	int omask;
	int timer;
	int mypid,ppid,ouid,ogid;
	char *stat;
	int shlock,exlock,madelock;
	/*
	int start0,start,now;
	int nreq;
	*/
	int start,now;
	int sx;
	char tmp[512];

	mypid = getpid();
	ppid = getppid();
	ouid = getuid();
	ogid = getgid();

	signal(SIGHUP,sigHUPforAbort);
	NUM_CHILDREN = 0;
	nreq = 0;

	start = start0 = time(0);
	omask = sigblock(sigmask(SIGHUP));
	{
		CHILD_SERNO_MULTI = 1;
		setProcTitleHead(DeleGate1,main_argc,main_argv);
		setCloseOnTimeout(StickyTIMEOUT);
		EXEC_client(Conn,EXEC_PATH,NULL,clSock);
		closeEfd(clSock);
	}
	sigsetmask(omask);

	madelock = 0;
	for(;;){
		if( 0 < REQUEST_SERNO ){
			nreq += REQUEST_SERNO - 1;
			REQUEST_SERNO = 0;
		}
		if( max <= CHILD_SERNO_MULTI ){
			stat = "natural";
			break;
		}
		if( INTERRUPT_STICKY ){
			stat = "interrupted";
			break;
		}
		if( BREAK_STICKY ){
			stat = "broken";
			break;
		}
		if( !ACC_REJECTED && !isStickyProto(Conn) ){ /* generalist */
			stat = "nonStickyProtocol";
			sprintf(tmp,"%s(%s:%s:%s)",stat,
				iSERVER_PROTO,DFLT_PROTO,DST_PROTO);
			stat = tmp;
			break;
		}
		if( getpid() != mypid ){
			/* may be forkd in sendDistribution() */
			sv1log("#### not the Sticky server process, EXIT.\n");
			Finish(0);
		}
		if( getppid() != ppid || getuid() != ouid || getgid() != ogid ){
			stat = "parentChanged";
			break;
		}
		if( !ViaVSAPassociator(-1) )
		if( activeServPort() == 0 ){
			stat = "serverSocketClosed";
			break;
		}

		now = time(0);
		if( 120 < (now - start) ){
			stat = "lifeSpan1";
			break;
		}
		start = now;

		initConn(Conn,-1);
		if( !madelock ){
			madelock = 1;
			shlock = PortLockReopen();
			if( lLOCK() )
				exlock = PortLocks(primaryPort(tmp),0,NULL);
			else	exlock = -1;
		}
		clsock=AcceptBySticky(Conn,StickyTIMEOUT,shlock,exlock,clSock); 

		if( clsock < 0 ){
			stat = "acceptFailed";
			break;
		}

		omask = sigblock(sigmask(SIGHUP));
		{
			CHILD_SERNO_MULTI++;
			setCloseOnTimeout(StickyTIMEOUT);
			EXEC_client(Conn,EXEC_PATH,NULL,clSock);
			closeEfd(clSock);
			cleanup_zombis(1);
		}
		sigsetmask(omask);
	}
	reportNserv(stat,start0,nreq);
	Finish(0);
}

static str2env(seqno,svsockp,clSock,lfdp)
	char *seqno;
	int *svsockp;
	Efd *clSock;
	int *lfdp;
{	int ac,port;
	int isock;
	int clsock;
	char svhost[256];
	char sockname[256],peername[256];
	int remote;
	int statfd;

	clsock = -1;
	*svsockp = -1;
	svhost[0] = 0;
	sockname[0] = peername[0] = 0;
	ac =
sscanf( seqno,"%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%[^/]/%[^/]/%[^/]/%d",
		&port,
		&IamPrivateMASTER,
		svsockp,
		&param_file,
		&clsock,
		&TOTAL_SERVED,
		&CHILD_SERNO,
		&NUM_PEERS,
		&StickyReport[1],
		&DELEGATE_LINGER,
		lfdp,
		&LOG_type,
		&statfd,
		&MASTERisPrivate,
		&AF_UNIX_DISABLE,
		&RES_localdns,
		svhost,
		sockname,
		peername,
		&remote
	);
	LOG_type |= L_ISCHILD;
	get_svstat(statfd);

	if( lVERB() )
		LOG_VERBOSE = 1;

	if( 0 < (isock = getclientsock()) )
		clsock = isock;
	if( 0 <= clsock )
	setEfd(clSock,clsock,sockname,peername,remote);

	if( 0 < (isock = getserversock()) )
		*svsockp = isock;

	if( 0 < (isock = getcontrolsock()) )
		StickyReport[1] = isock;

	if( isFuncFunc ){
		/* passed svsock is not the socket to accept client
		 * but a socket connected to the server
		 */
		setSERVER_PORT(svhost,port,-1);
	}else
	/*
	 * svhost derived from -Phostname:port is necessary to be set as
	 * the PrimayPort to generate ${PORT}, "Location:", etc.
	 */
	setSERVER_PORT(svhost,port,*svsockp);

	return ac;
}

static recvEnv(Conn,ac,av,svsockp,clSock)
	Connection *Conn;
	char *av[];
	int *svsockp;
	Efd *clSock;
{	int av1ac;
	int lfd;
	char *env;

	lfd = -1;
	if( (av1ac = str2env(av[1],svsockp,clSock,&lfd)) < 3 ){
		if( env = getEnv(P_EXEC_ENV) )
			av1ac = str2env(env,svsockp,clSock,&lfd);
		else	av1ac = 0;
	}
	if( 0 <= lfd )
	fdopenLogFile(lfd);
	return av1ac;
}

Exec_client(Conn,ac,av)
	Connection *Conn;
	char *av[];
{	int av1ac;
	int svsock;
	Efd *clSock = clientSocks;
	char *env;

	if( 2 < ac ){
		if( streq(av[2],FuncFunc) ) isFuncFunc = 1;
	}
	av1ac = recvEnv(Conn,ac,av,&svsock,clSock);

	if( env = getEnv(P_EXEC_PATH)  ) strcpy(EXEC_PATH,env);
	if( env = getEnv(P_START_TIME) ) START_TIME = atoi(env);
	if( env = getEnv(P_ALIVE_PEERS)) NUM_CHILDREN = atoi(env);

	if( 1 < ac ){
	  if( streq(av[1],FuncFILTER) )    Finish(callFilter(Conn,ac,av));
	  if( streq(av[2],FuncSTICKY) ){
		scanEnv(Conn,P_MAXIMA,  scan_MAXIMA);
		setStickyParams(Conn,DFLT_PROTO);
		StickyServer(Conn,clSock,StickyMAX_LIFE);
		closeEfd(clSock);
		Finish(0);
	  }
	  if( streq(av[2],FuncFunc)) Finish(callFunc(Conn,ac,av,clSock,svsock));
	}

	if( av1ac < 3 )
		Exit(-1,"cannot get socket argument.\n");
	else{
		call_client1(Conn,clSock);
		closeEfd(clSock);
	}
}

gotoWORKDIR()
{	char *wd;
	char *pp,wdir[1024],cwd[1024],var[1024],tmp[1024];
	FILE *fp;

	wd = (char*)getEnv(P_WORKDIR);
	if( wd == 0 ){
		if( lFG() || lSYNC() )
			return;
		else	wd = DELEGATE_WORKDIR;
	}
	strcpy(wdir,wd);
	substfile(wdir,"PROTOCOL",var,NULL,NULL);

	if( !isBoundpath(wdir) ){
		strcpy(tmp,wdir);
		sprintf(wdir,"%s/%s",var,tmp);
		/*
		if( lARGDUMP() )
		*/
		if( lFILETRACE() )
			fprintf(stderr,"WORKDIR=%s\n",wdir);
	}

	path_escchar(wdir);
	mkdirRX(wdir);
	getcwd(cwd,sizeof(cwd));
	originWD = StrAlloc(cwd);

	if( chdir(wdir) == 0 ){
		char pid[64];

		sv1log("%s=%s\n",P_WORKDIR,wdir);
		_workdir = stralloc(wdir);
		sprintf(pid,"%d",getpid());
		if( fp = dirfopen("WORKFILE",pid,"w") )
			fclose(fp);
	}else{
		sv1log("ERROR can't goto %s=%s\n",P_WORKDIR,wdir);
	}
}
makeWorkFile(path,type,file)
	char *path,*type,*file;
{
	sprintf(path,"${ACTDIR}/%s/%d.%s",type,getpid(),file);
	substfile(path,"",NULL,NULL,NULL);
	workFiles[workFileX++] = stralloc(path);
}
deleteWORKDIR()
{	int pid;
	char pidfile[1024],*workfile,*dp;
	int tx;

	pid = getpid();
	if( _workdir ){
		sprintf(pidfile,"%s/%d",_workdir,pid);
		if( unlink(pidfile) == 0 ){
			sv1log("unlinked %s\n",pidfile);
			chdir("..");
			if( rmdir(_workdir) == 0 )
				sv1log("removed %s/\n",_workdir);
			else	sv1log("remove failed, errno=%d, %s\n",
					errno,_workdir);
		}
		_workdir = NULL;
	}
	for( tx = 0; workfile = workFiles[tx]; tx++ ){
		if( dp = strrpbrk(workfile,"/\\") )
			if( atoi(dp+1) == pid )
				unlink(workfile);
	}
}

extern FILE *openStatusFile();
putStatus(fmt,a,b,c,d,e,f,g,h)
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h;
{	char *file;
	FILE *fp;

	if( file = getEnv("STATFILE") )
	if( fp = openStatusFile(file) ){
		/* fseek(fp,0,0); */
		fprintf(fp,"%d ",time(0));
		fprintf(fp,fmt,a,b,c,d,e,f,g,h);
		fflush(fp);
		/* Ftruncate(fp,0,1); */
	}
}

static printXdisplay(pxdisplay,pxhost,pxport,scrnum)
	char *pxdisplay,*pxhost;
{	char *pxaddr;

	if( pxaddr = gethostaddr(pxhost) )
		sprintf(pxdisplay,"%s:%d.%d",pxaddr,pxport-6000,scrnum);
	else	sprintf(pxdisplay,"%s:%d.%d",pxhost,pxport-6000,scrnum);
	sv1log("Xproxy -- %s:%d.%d -- %s\n",pxhost,pxport,scrnum,pxdisplay);
}
makeXproxy(Conn,pxdisplay,display,pxhost,relhost,me,timeo)
	Connection *Conn;
	char *pxdisplay,*display,*pxhost,*relhost,*me;
{	char *av[32];
	char port[256],timeout[256],server[256],permit[256],desc[256],*env;
	char connect[256];
	char vardir[1024],logdir[1024],logfile[1024];
	char disphost[128];
	int dispport,dispsock;
	int pxsock,pxport;
	int ac;
	int pid;
	int dispnum,scrnum;
	char cachepath[2048];
	FILE *cachefp;
	char hosts[0x4000];
	char clientid[256];

	dispnum = scrnum = 0;
	sscanf(display,"%[^:]:%d.%d",disphost,&dispnum,&scrnum);
	dispport = 6000+dispnum;

	sprintf(clientid,"pid-port-%s",relhost);
	if( CTX_cache_path(Conn,"X",disphost,dispnum,clientid,cachepath) ){
		char line[256];

		sv1log("##[%s][%s] %s\n",display,relhost,cachepath);
		if( cachefp = fopen(cachepath,"r+") ){
			fgets(line,sizeof(line),cachefp);
			fclose(cachefp);

			/* cleanup zombis of previous X-proxy to make kill()==0
			 * work to sense the existence of the process */
			while( 0 < NoHangWait() )
				;

			if( sscanf(line,"%d %d",&pid,&pxport) == 2 )
			if( Kill(pid,SIGHUP) == 0 )
			{
				sv1log("REUSE X-PROXY for %s: port=%d pid=%d\n",
					relhost,pxport,pid);
				printXdisplay(pxdisplay,pxhost,pxport,scrnum);
				return pid;
			}
			/* should add "xhost" */
		}
	}

	pxsock = -1;
	for( pxport = 6010; pxport < 6100; pxport++ ){
		pxsock = server_open("Xpxdisplay",pxhost,pxport,1);
/*
DEBUG: bind with wildcard interface
		pxsock = server_open("Xpxdisplay","",pxport,1);
*/
		if( 0 < pxsock )
			break;
	}
	if( pxsock < 0 )
		return 0;

	pxport = sockPort(pxsock);

	if( (pid = Fork("Xpxdisplay")) != 0 ){
		close(pxsock);
		printXdisplay(pxdisplay,pxhost,pxport,scrnum);
		return pid;
	}

	if( cachepath[0] ){
		if( cachefp = dirfopen("X-Proxy",cachepath,"w") ){
			fprintf(cachefp,"%d %d\n",getpid(),pxport);
			fclose(cachefp);
		}
		/* should read "xhost" and set it to PERMIT */
	}

	if( fromInetd() ){
		close(0);
		close(1);
	}
	closeServPorts();
	close(ToS);
	close(FromS);
	close(ToC);
	close(FromC);

	ac = 0;
	av[ac++] = EXEC_PATH;

	sprintf(port,"-P%d/%d",pxport,pxsock);
	av[ac++] = port;

	sscanf(display,"%[^:]:%d",disphost,&dispport);
	sprintf(server,"%s=X://%s:%d/",P_SERVER,disphost,6000+dispport);
	av[ac++] = server;

	if( timeo ){
		sprintf(timeout,"%s=daemon:%ds",P_TIMEOUT,timeo);
		av[ac++] = timeout;
	}

	unsetEnv(environ,environ,P_PERMIT);
	unsetEnv(environ,environ,P_RELIABLE);
	unsetEnv(environ,environ,P_REACHABLE);
	sprintf(permit,"%s=X:%s:%s",P_PERMIT,disphost,relhost);
/*
DEBUG: don't check X-client host
	sprintf(permit,"%s=X:%s:*",P_PERMIT,disphost);
*/
	av[ac++] = permit;

	if( env = getEnv(P_CONNECT) ){
		sprintf(connect,"%s=%s",P_CONNECT,env);
		av[ac++] = connect;
	}

	if( lVERB() )
		av[ac++] = "-vv";
	if( env = getEnv(P_VARDIR) ){
		sprintf(vardir,"%s=%s",P_VARDIR,env);
		av[ac++] = vardir;
	}
	if( env = getEnv(P_LOGDIR) ){
		sprintf(logdir,"%s=%s",P_LOGDIR,env);
		av[ac++] = logdir;
	}
	if( env = getEnv(P_LOGFILE) ){
		sprintf(logfile,"%s=%s",P_LOGFILE,env);
		av[ac++] = logfile;
	}

	sprintf(desc,"(X proxy for %s)",me);
	av[ac++] = desc;

	strcpy(hosts,"HOSTS=");
	dump_HOSTS(hosts+strlen(hosts));
	av[ac++] = hosts;

	av[ac] = 0;
	Execvp("Xproxy",EXEC_PATH,av);
	Finish(0);
}



fdcheck(msg,waits)
	char *msg;
{	char fds[256],*fdp;
	int fd;

	fdp = fds;
	for( fd = 0; fd < 64; fd++ ){
		if( 0 <= file_uid(fd) ){
			sprintf(fdp,"[%2d]",fd);
			fdp += strlen(fdp);
		}
	}
	*fdp = 0;
	fprintf(stderr,"####[%d]%s ACTIVE FD: %s\n",getpid(),msg,fds);

	if( waits ){
		signal(SIGHUP, sigHUP);
		fprintf(stderr,"#### (%s) SLEEPING\n",msg);
		sleep(waits);
	}
}

static callFunc(Conn,ac,av,clSock,svsock)
	Connection *Conn;
	char *av[];
	Efd *clSock;
{	char *env;
	int (*func)();
	char *funcenv,*arg;
	int clsock;

	clsock = getEfd(clSock);
	config(Conn,clsock);

	funcenv = getenv("FUNCADDR");
	sscanf(funcenv,"%x",&func);
	arg = getenv("FUNCARG");
	Verbose("EXEC START: %d %d func=%x arg[%s]\n",
		clsock,svsock,func,arg);
	(*func)(Conn,clsock,svsock,ac,av,arg);
	Finish(0);
}
execFunc(Conn,clsock,svsock,func,arg)
	Connection *Conn;
	int (*func)();
	char *arg;
{	Efd clSockb,*clSock = &clSockb;
	char funcenv[32],argenv[4098];
	int pid;

	if( INHERENT_fork() )
		if( pid = fork() )
			return pid;

	if( Conn == NULL )
		Conn = mainConn;

	sprintf(funcenv,"FUNCADDR=%x",func); putenv(funcenv);
	sprintf(argenv,"FUNCARG=%s",arg); putenv(argenv);

	Verbose("START EXEC: %d %d func=%x arg[%s]\n",
		clsock,svsock,func,arg);

	setEfd(clSock,clsock,"","",0);

	if( 0 <= clsock ) setclientsock(clsock);
	if( 0 <= svsock ) setserversock(svsock);
	pid = EXEC_client1(Conn,EXEC_PATH,FuncFunc,svsock,clSock);
	return pid;
}

extern char *Sprintf();
extern char *mainProcTitleFmt;
mainProcTitle(Conn)
	Connection *Conn;
{	char stat[256];

	strfLoadStat(stat,sizeof(stat),mainProcTitleFmt,time(NULL));
	ProcTitle(Conn,stat);
}

#define PSTITLE_END "--"
extern char *pstitle_area;
extern int   pstitle_size;
extern int   pstitle_lengmax;
extern int   pstitle_leng; /* length of original arguments */
static char *pstitle_head;
static char *pstitle_tail;
static int   pstitle_tailleng;

setProcTitleHead(arg0,ac,av)
	char *arg0,*av[];
{	char buff[1024];
	char *arg;
	int ai,bi,len,dispend;

	if( lEXEC() ){
		/* don't show internal parameters for internal exec (-x) */
		return;
	}
	wordScan(arg0,buff);
	Strdup(&pstitle_head,buff);

	bi = 0;
	dispend = 0;
	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		len = strlen(arg);
		if( strncmp(arg,PSTITLE_END,strlen(PSTITLE_END)) == 0 ){
			dispend = ai;
			break;
		}
		if( sizeof(buff) <= bi + len )
			break;
		buff[bi++] = ' ';
		strcpy(buff+bi,arg);
		bi += len;
	}
	if( dispend == 0 )
		bi = 0;
	buff[bi] = 0;
	pstitle_tailleng = bi;
	Strdup(&pstitle_tail,buff);
}
ProcTitle(Conn,fmt,a,b,c,d,e,f,g,h)
	Connection *Conn;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h;
{	char buff[4096],*sp,*tail;
	int bsize,minleng;

	if( Conn == NULL )
		return;
	if( pstitle_head == NULL )
		return;

	/*
	 * ps-title string set as argv[0] should be long enough
	 * so that possibly cached argv[1-] string is not shown
	 */
	minleng = 80;

	bsize = pstitle_lengmax;
	if( sizeof(buff) < bsize )
		bsize = sizeof(buff);
	if( bsize < minleng )
		minleng = bsize;

	sp = buff;
	sp = Sprintf(sp,"%s -{",pstitle_head);
	if( Getpid() != ServerPID ){
		sp = Sprintf(sp,"%03d+%02d",CHILD_SERNO,CHILD_SERNO_MULTI);
		if( RequestSerno || ServReqSerno )
			sp = Sprintf(sp,"/%03d",RequestSerno);
		if( ServReqSerno )
			sp = Sprintf(sp,"/%03d",ServReqSerno);
	}else{
		sp = Sprintf(sp,"%03d",CHILD_SERNO);
		if( StickyDone || CHILD_SERNO_SINGLE )
			sp = Sprintf(sp,":");
		if( 0 < StickyDone )
			sp = Sprintf(sp,"%03d/%03d",StickyNserved,StickyDone);
		if( 0 < CHILD_SERNO_SINGLE )
			sp = Sprintf(sp,"+%03d",CHILD_SERNO_SINGLE);
	}
	if( 0 < ClientSock ){
		sp = Sprintf(sp,":");
		if( getClientHostPort(Conn,sp) )
			sp += strlen(sp);
	}

	sp = Sprintf(sp,"}[");
	sp = Sprintf(sp,fmt,a,b,c,d,e,f,g,h);
	sp = Sprintf(sp,"]-P");
	primaryPort(sp);
	sp += strlen(sp);
	sp = Sprintf(sp,pstitle_tail);
	sp = Sprintf(sp," -- ");

	if( sp - buff < minleng ){
		tail = buff + minleng -1;
		while( sp < tail )
			*sp++ = '-';
		*sp++ = 0;
	}

	if( bsize <= sp-buff){
		sv1tlog("ProcTitle overflow: %d\n",sp-buff);
		buff[bsize-1] = 0;
		sv1tlog("ProcTitle overflow: %s\n",buff);
		Finish(-1);
	}
	proc_title("%s",buff);
}
LOG_makeTime(MemF,now,usec)
	void *MemF;
{	char tms[1024];

	StrftimeLocal(tms,sizeof(tms),TIMEFORM_mdHMS,now);
	str_sprintf(MemF,"%s.%02d [%d] %d+%d",
		tms,usec/10000,Getpid(),SERNO(),SERNO_MINOR());
	if( REQUEST_SERNO || SERVREQ_SERNO )
		str_sprintf(MemF,"/%d",REQUEST_SERNO);
	if( SERVREQ_SERNO )
		str_sprintf(MemF,"/%d",SERVREQ_SERNO);
	str_sprintf(MemF,": ");
}
LOG_putTime(fp)
	FILE *fp;
{	int now,usec;
	char tms[1024];

	now = Gettimeofday(&usec);
	StrftimeLocal(tms,sizeof(tms),TIMEFORM_mdHMS,now);
	fprintf(fp,"%s.%02d [%d] %d+%d",
		tms,usec/10000,getpid(),SERNO(),SERNO_MINOR());
	if( REQUEST_SERNO )
		fprintf(fp,"/%d",REQUEST_SERNO);
	fputs(": ",fp);
}
incRequestSerno(Conn)
	Connection *Conn;
{
	return REQUEST_SERNO = ++RequestSerno;
}
incServReqSerno(Conn)
	Connection *Conn;
{
	return SERVREQ_SERNO = ++ServReqSerno;
}


minits(){
	minit_logs();
	minit_main();

	minit_resconf();
	minit_tmpfile();
	minit_html();
	minit_timer();
	minit_socks5();
	minit_hostlist();
	minit_ports();
	minit_inets();
	minit_access();
	minit_mount();
	minit_loadstat();
	minit_envs();
	minit_script();
	minit_socks();
	minit_ccache();
	minit_filetype();
	minit_textconv();
	minit_cron();
	minit_ftp();
	minit_smtp();
	minit_vsapcl();
}

extern char **move_envarg();
extern int RANDSTACK_RANGE;
extern int RANDSTACK_UNIT;
mainX(ac,av)
	char *av[];
{	int ai;
	char *arg;
	char *areap;
	int areal,areas;

	for( ai = 0; ai < ac; ai++ ){
		arg = av[ai];
		if( *arg == '-' && arg[1] == 'R' )
			RAND_TRACE = 1;
	}
	areap = 0;
	av = move_envarg(ac,av,&areap,&areal,&areas);
	if( areap ){
		pstitle_leng = areal;
		pstitle_area = areap;
		pstitle_size = areas;
	}
	setProcTitleHead(av[0],ac,av);
	if( INHERENT_alloca() ){
		RANDSTACK_RANGE = 1024;
		RANDSTACK_UNIT = 96;
	}
	randstack_call(SB_PROC,delegate_main,ac,av);
	/* do not return to possibly mushed stack */
	exit(-1);
}
