/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-2000 Yutaka Sato
Copyright (c) 1994-2000 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute (via publically accessible
on-line media) this material for any purpose and without fee is hereby
granted, provided that the above copyright notice and this permission
notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	delegate.h
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	May1994	created
//////////////////////////////////////////////////////////////////////#*/
#ifndef _DELEGATE_H_
#define _DELEGATE_H_

#include "ystring.h"
#include <stdio.h>
#include "ysocket.h"
#include "vaddr.h"
#include "log.h"

extern char *MYSELF;	/* -.- */

extern char *DELEGATE_CONFIG;
extern char *DELEGATE_ADMIN_DFLT; /* ADMIN at compile time */
extern char *DELEGATE_ADMIN;
extern char *DELEGATE_ADMINPASS;
extern char *builtin_ADMINPASS;
extern char *DELEGATE_OWNER;
extern char *DELEGATE_G_PERMIT;
extern char *DELEGATE_S_PERMIT;
extern char *DELEGATE_HTTP_PERMIT;
extern char *DELEGATE_SOCKS_PERMIT;
extern char *DELEGATE_TELNET_PERMIT;
extern char *DELEGATE_RELAY;
extern char *DELEGATE_RELIABLE;
extern char *DELEGATE_DGPATH;

extern char SERV_HTTP[];

#define DELEGATE_LINGER LIN_TIMEOUT
extern int   DELEGATE_LINGER;
extern char *DELEGATE_DGROOT;
extern char *DELEGATE_LIBDIR;
extern char *DELEGATE_LIBPATH;
extern char *DELEGATE_DATAPATH;
extern char *DELEGATE_WORKDIR;
extern char *DELEGATE_VARDIR;
extern char *DELEGATE_LOGDIR;
extern char *DELEGATE_ADMDIR;
extern char *DELEGATE_ETCDIR;
extern char *DELEGATE_UASFILE;
extern char *DELEGATE_LOGFILE;
extern char *DELEGATE_EXPIRELOG;
extern char *DELEGATE_ABORTLOG;
extern char *DELEGATE_PROTOLOG;
extern char *DELEGATE_PARAMFILE;
extern char *DELEGATE_ACTDIR;
extern char *DELEGATE_TMPDIR;
extern char *DELEGATE_PIDFILE;
extern char *DELEGATE_STATFILE;
extern int   DELEGATE_syncro;
extern char *DELEGATE_IMAGEDIR;
extern int   GOPHER_ON_HTTP;

extern char *TIMEFORM_mdHMS;
extern char *TIMEFORM_HTTPD;
extern char *TIMEFORM_GOPHER;
extern char *TIMEFORM_RFC822;

extern int   ENCODE_HTML_ENTITIES;
extern int   DECODE_HTML_ENTITIES;

extern char *DELEGATE_CACHEDIR;
extern int   CACHE_RDRETRY_INTERVAL;
extern int   CACHE_WRRETRY_INTERVAL;

extern char D_SERVICE_BYPORT[];

extern char *my_HOSTPORT();

typedef struct {
	char	de_EXEC_PATH[1024];
	struct {
		char	PROTO[64];
		char	HOST[256];
		int	PORT;
	} de_iSERVER;
	double	de_ACCEPT_TIME;
	int	de_RESTART_NOW;
	int	de_REQUEST_SERNO;
	int	de_SERVREQ_SERNO;
} DeleGateEnv;
extern DeleGateEnv *deleGateEnv;
#define EXEC_PATH	deleGateEnv->de_EXEC_PATH
#define iSERVER_PROTO	deleGateEnv->de_iSERVER.PROTO
#define iSERVER_HOST	deleGateEnv->de_iSERVER.HOST
#define iSERVER_PORT	deleGateEnv->de_iSERVER.PORT
#define ACCEPT_TIME	deleGateEnv->de_ACCEPT_TIME
#define RESTART_NOW	deleGateEnv->de_RESTART_NOW
#define REQUEST_SERNO	deleGateEnv->de_REQUEST_SERNO
#define SERVREQ_SERNO	deleGateEnv->de_SERVREQ_SERNO

typedef struct {
	int	_closed;
	int	_fd;
	int	_remote;
	char	_sockname[256];
	char	_peername[256];
} Efd;
#define setEfd(efd,fd,sockname,peername,remote) \
	(efd==NULL?-1:((efd->_closed=0),(efd->_fd=fd),\
		strcpy(efd->_sockname,sockname), \
		strcpy(efd->_peername,peername), (efd->_remote=remote)))
#define getEfd(efd) \
	(efd==NULL?-1:(efd->_closed?-1: efd->_fd))
#define closeEfd(efd) \
	(efd==NULL?-1:(efd->_closed?-1:((efd->_closed=1),close(efd->_fd))))
#define SocknameOf(efd)	(efd->_sockname)
#define PeernameOf(efd)	(efd->_peername)

typedef struct {
	char   *u_method;
	char   *u_proto;
	char   *u_host;
	int	u_port;
	char   *u_path;
	char   *u_hostport;
	char   *u_base;
} Urlx;
typedef struct {
	Urlx	r_sv;	/* URL of target */
	Urlx	r_my;	/* real URL of me (DeleGate) */
	Urlx	r_vb;	/* virtual base URL of me for client */
	char   *r_altbuf;
} Referer;

typedef struct {
	int	p_reqserno; /* serial number of requests on the connetion */
	int	p_bound;
	int	p_connected;
	int	p_closed;
	double	p_connTime;
	int	p_connType; /* the type of current CONNECTION {c,m,p,d,v,s,...} */
	int	p_connError;
	int	p_viaCc;	/* via a connection cache proxy */
	int	p_viaVSAP;
	int	p_viaSocks;
	int	p_viaProxy;
	int	p_viaMaster;
	int	p_dontKeepAlive;
	int	p_wantKeepAlive;
	int	p_willKeepAlive;
	int	p_sentKeepAlive;
	int	p_port;
	int	p_anonymous;
	int	p_flags;
	int	p_fd[8];
	char	p_sstring[4][64];
	char	p_lstring[4][256];
} Port;

#define	p_sock	p_fd[0] /* directly connected with the peer{client,server,proxy,..} */
#define p_rfd	p_fd[2]
#define p_wfd	p_fd[3]
#define p_rfdx	p_fd[4] /* escaped when FFROMXX filter inserted */
#define p_wfdx	p_fd[5]	/* escaped when FTOXX filter inserted */

#define p_connFname	p_sstring[0] /* Connection or Proxy-Connection */
#define p_proto		p_sstring[1]
#define p_viaMasterVer	p_sstring[2]
#define p_ccxbuf	p_sstring[3]

#define p_site		p_lstring[0] /* [user [:pass] @] host [:port] */
#define p_host		p_lstring[1]
#define p_user		p_lstring[2]
#define p_whyclosed	p_lstring[3]

#define DG_MAXHEAD	32
#define DG_MAXCLIN	16

typedef struct {
	char	cx_where[32];	/* something describes the "caller" */
	Port	sv;
	Port	sv_dflt;	/* default server */
	Port	sv_dfltsav;
	int	sv_portmap;	/* relative to incoming port: 0<N:inc N<0:dec */
	Port	sv_remote;	/* http://H:P/...=@=Rp:RH:RP */
	int	me_iamgw;
	int	me_norelay;
	FILE   *sv_toServ;
	int	sv_imCC;	/* server connection holder */
	int	sv_imResponseFilter;
	int	sv_imMaster;
	int	sv_imProxy;
	int	sv_mounted;
	int	sv_isvhost;
	int	sv_proxyOnly;

	int	sv_reusing;
	int	sv_ka_timeout;
	int	sv_ka_remalive;

	int	ma_private;
	char	ma_sayhello;
	char	ma_saidhello;
	char	ma_doack;	/* return ACK */
	char	ma_noack;	/* don't return ACK */
	char	cl_nosync;	/* don't flush DeleGate-HELLO */
	char	cl_noflush;
	char	rident_sockhost[256];
	int	rident_sockport;
	char	rident_peerhost[256];
	char	rident_peeraddr[64];
	int	rident_peerport;
	int	rp_sock;	/* RPORT: socket for response connection */
	int	rp_udp;

	Port	cl;
	char   *cl_user;
	VAddr	cl_peerAddr;	/* cache for getpeername(ClientSock) */
       AuthInfo	cl_Ident;	/* cache for Ident */
	int	cl_count;
	int	xf_filters;
	int	xf_filtersCFI;	/* inserted filter is CFIscript */
	int	xf_clprocs;	/* spawned process with client-side socket */
	int	xf_mounted;
	int	xf_isremote;
	int	xf_echoreq;
	int	xf_stderr2out;
	FILE   *xf_fp[16];
	int	xf_codes[16];
	void   *cl_reqbuf;
	int	cl_reqbufsize;

       AuthInfo cl_certauth;
       AuthInfo sv_certauth;
	char 	cl_cert[256];
	char	sv_cert[256];

	char    cl_myhp[128];	/* client side interface */
	int	cl_tcCLOSED;
	VAddr	cl_sockHOST;	/* cache for getsockname(), DeleGate side IP */
	char	cl_nocache;
	char	cl_expire[128]; /* EXPIRE specified at client side */
	char	cl_baseurl[128];/* base of referer's url-path */
	Urlx	my_vbase; /* decomposed cl_baseurl when it is full-URL */

	char	dg_pxcontrols[256]; /* URL?_?proxyControl */
	char	dg_modifier[256];
	char	dg_putpart[32];
	char	iconbase[128];	/* maybe obsoleted by BASEURL and MOUNT=/-/builtin/icons */
	char	cl_rport[256];	/* RPORT specified by the client DeleGate */

	int	oc_isset;
	int	oc_norewrite;	/* the client seems to expect proxy server */
	int	oc_bydelegate;	/* accessed by /-_-URL notation */
	char	oc_proto[64];	/* that of the real originator client, */
	char	oc_proxy[128];	/* which is not proxy */

	char   *cl_FromCbuff;
	int	cl_FromCfill;
	int	cl_FromCpeak;
	int	cl_FromCread;

	int	dg_HOPS;
	int	dg_FTPHOPS;

	char	ma_SERVER[256];
	UTag	ma_REQUESTtag;
	char   *cl_headerB[DG_MAXHEAD];
	int	cl_headerX;
	char   *cl_inputsB[DG_MAXCLIN];
	int	cl_inputsX;

       AuthInfo	cl_auth; /* for password authentication */
	int	cl_noauth;
	int	cl_proxyAuth;	/* use Proxy-Auth in non-HTTP/HTTP gw. */

	Port	gw;
	char   *gw_path;

	char   *ca_objbuff;
	int	ca_objsize;

	int	ca_dontuse;
	int	ca_dontread;
	int	ca_dontwait;
	int	ca_dontwrite;
	int	ca_readonly;
	int	ca_only;
	int	ca_mtime;
	int	ca_lastmod;
	int	ca_reqwithcookie;
	int	ca_respwithcookie;

	int	ca_distsock;
	int	ca_distsock_open;
	int	ca_curoff;
	int	ca_receptorN;
	int	ca_receptors[64]; /* should be FD_SETSIZE */
	int	ca_putoff[64];

	int	co_setup;
	int	co_routex;
	int	co_nonet;
	int	co_nointernal;
	int	co_internal;
	int	co_local;
	int	co_mask; /* CONN_NOPROXY, CONN_NOMASTER, ... */
	double	co_start;
	double	co_done;
	double	co_delay;

	int	born_specialist;
	int	act_generalist;
	int	meta_specialist;
	int	act_specialist;
	int	act_translator;
	int	relay_thru;
	int	path_added;
	Port	dl; /* born as GENERALIST but act as SPECIALIST */

	int	resp_with_body;
	int	body_only;	/* for HTTP ... */
	int	from_myself;
	int	from_client;	/* the request is issued by a client */
	int	no_authcheck;
	int	no_dstcheck;
	int	no_dstcheck_proto; /* destination protocol when MOUNTed */
	int	no_permission; 	/* error code ... */
	int	auth_check;
	int	permitGlobal;
	int	toMyself;
	int	statcode;

	int	ht_PadCRLF;
	int	ht_SimpleContType;
	char   *ht_LockedByClient;
	char	ht_stat;
	char	ht_statx;
	char	ht_genETag[64];
	char	ht_flags[128];

	char   *mo_options;	/* MOUNTed, its options */
	Port	mo_master;	/* MASTER just for current MOUNT point */
	Port	mo_proxy;	/* PROXY just for current MOUNT point */
	char	mo_authorizer[64];

	int	(*fi_func)();
	int	fi_arglen;
	int	fi_iomode;	/* 0:input-filter, 1:output filter */
	short	fi_topeer;	/* the peer side connection (socket or pipe) */
	short	fi_issock;	/* fi_topeer is socket */
	short	fi_dupclsock;	/* do copy fi_topeer to cl_sockFd */
	short	fi_logfd;

	char	fi_what[32];
	short	fi_isresp;

	int	fi_builtin;	/* with builtin-filter (openHttpResponse) */

	void	*cc_conv[2];	/* CCX context */
	int	cl_setccx;	/* CCX is set by client */

	char	dd_from[256];
	char	dd_user[256];
	char	dd_gtype[2];
	char	dd_selector[1024];
	char	dd_path[512];
	char	dd_rport[128];
	char	dd_override[256];

	char	sv_hasmaster;
	char	cl_modifiers[256];
	char	cl_if_hostport[256];
	char	cl_if_host[256];
	int	cl_if_port;
	char	sv_genhost[256];	/* Host: field to be forwarded */
	int	cl_auth_stat;

	int	forreject; /* on:REJECT off:PERMIT */
	char	reject_reason[256];
} Connection;

#define ClientAuth	Conn->cl_auth
#define ClientAuthUser	Conn->cl_auth.i_user
#define ClientAuthHost	Conn->cl_auth.i_addr.a_name
#define ClientAuthPort	Conn->cl_auth.i_addr.a_port
#define AuthStat	Conn->cl_auth_stat
#define GEN_VHOST	Conn->sv_genhost
#define D_FROM		Conn->dd_from
#define D_USER		Conn->dd_user
#define D_SELECTOR	Conn->dd_selector
#define D_GTYPE		Conn->dd_gtype
#define D_PATH		Conn->dd_path
#define D_RPORT		Conn->dd_rport
#define D_OVERRIDE	Conn->dd_override

#define HAS_MASTER	Conn->sv_hasmaster
#define MODIFIERS	Conn->cl_modifiers
#define CLIF_HOSTPORT	Conn->cl_if_hostport
#define CLIF_HOST	Conn->cl_if_host
#define CLIF_PORT	Conn->cl_if_port

#define CCX		(Conn->cc_conv[0])
#define CCX_TOCL	(Conn->cl.p_ccxbuf)
#define CCX_TOSV	(Conn->sv.p_ccxbuf)

#define ToMyself	(Conn->toMyself)
#define ToInternal	(Conn->toMyself & 2)
#define setToInternal()	(Conn->toMyself |= 2)
#define CLIENTS_PROXY	(Conn->oc_proxy)
#define CLIENTS_PROTO	(Conn->oc_proto)
#define DONT_REWRITE	(Conn->oc_norewrite)
#define DO_DELEGATE	(Conn->oc_bydelegate)
#define IAM_GATEWAY	(Conn->me_iamgw)
#define RelayForbidden	(Conn->me_norelay)
#define RPORTsock	(Conn->rp_sock)
#define RPORTudp	(Conn->rp_udp)
#define TelesockHost	(Conn->rident_sockhost)
#define TelesockPort	(Conn->rident_sockport)
#define TeleportHost	(Conn->rident_peerhost)
#define TeleportAddr	(Conn->rident_peeraddr)
#define TeleportPort	(Conn->rident_peerport)
#define RespNOSYNC	(Conn->cl_nosync)
#define RespNOFLUSH	(Conn->cl_noflush)

#define ProxyControls	(Conn->dg_pxcontrols)
#define Modifier	(Conn->dg_modifier)
#define	D_HOPS		(Conn->dg_HOPS)
#define	D_FTPHOPS	(Conn->dg_FTPHOPS)

#define	FromCbuff	(Conn->cl_FromCbuff)
#define	FromCfill	(Conn->cl_FromCfill)
#define	FromCpeak	(Conn->cl_FromCpeak)
#define	FromCread	(Conn->cl_FromCread)

#define headerB		(Conn->cl_headerB)
#define headerX		(Conn->cl_headerX)
#define inputsB		(Conn->cl_inputsB)
#define inputsX		(Conn->cl_inputsX)
#define D_SERVER	(Conn->ma_SERVER)
#define D_REQUESTtag	(Conn->ma_REQUESTtag)
#define D_EXPIRE	(Conn->cl_expire)
#define PragmaNoCache	(Conn->cl_nocache)
#define D_RPORTX	(Conn->cl_rport)

#define ToServ		(Conn->sv_toServ)
#define FromSX		(Conn->sv.p_rfdx)
#define ToSX		(Conn->sv.p_wfdx)
#define FromS		(Conn->sv.p_rfd)
#define ToS		(Conn->sv.p_wfd)
#define FromC		(Conn->cl.p_rfd)
#define ToC		(Conn->cl.p_wfd)
#define ImResponseFilter (Conn->sv_imResponseFilter)
#define IsMounted	(Conn->sv_mounted)
#define IsVhost		(Conn->sv_isvhost)
#define ImCC		(Conn->sv_imCC)

#define tryProxyOnly	(Conn->sv_proxyOnly)
#define toProxy		(Conn->sv.p_viaProxy)
#define toMaster	(Conn->sv.p_viaMaster)
#define MediatorVer	(Conn->sv.p_viaMasterVer)
#define	MasterIsPrivate	(Conn->ma_private)
#define ImProxy		(Conn->sv_imProxy)

#define ServViaCc	(Conn->sv.p_viaCc)
#define ServViaSocks	(Conn->sv.p_viaSocks)
#define ServViaVSAP	(Conn->sv.p_viaVSAP)

#define ImMaster	(Conn->sv_imMaster)
#define ClientVER	(Conn->cl.p_viaMasterVer) /* client DeleGate version if ImMaster */
#define SayHello	(Conn->ma_sayhello)
#define SaidHello	(Conn->ma_saidhello)
#define ReturnACK	(Conn->ma_doack)
#define NoACK		(Conn->ma_noack)

#define GatewayProto	(Conn->gw.p_proto)
#define GatewayHost	(Conn->gw.p_host)
#define GatewayPort	(Conn->gw.p_port)
#define GatewayPath	(Conn->gw_path)

#define NoAuth		(Conn->cl_noauth)
#define ProxyAuth	(Conn->cl_proxyAuth)

#define DontUseCache	(Conn->ca_dontuse)
#define DontReadCache	(Conn->ca_dontread)
#define DontWaitCache	(Conn->ca_dontwait)
#define DontWriteCache	(Conn->ca_dontwrite)
#define CacheReadOnly	(Conn->ca_readonly)
#define CacheOnly	(Conn->ca_only)
#define CacheMtime	(Conn->ca_mtime)
#define CacheLastMod	(Conn->ca_lastmod)
#define ReqWithCookie	(Conn->ca_reqwithcookie)
#define RespWithCookie	(Conn->ca_respwithcookie)

#define ServConnTime	(Conn->sv.p_connTime)
#define ClntConnTime	(Conn->cl.p_connTime)

extern int BORN_SPECIALIST; /* communicates with a real client */

#define ACT_GENERALIST	(Conn->act_generalist)
#define META_SPECIALIST	(Conn->meta_specialist)
#define	ACT_SPECIALIST	(Conn->act_specialist)
#define	DELEGATE_LHOST	(Conn->dl.p_host)/* specialist directly interface with client */
#define RelayTHRU	(Conn->relay_thru)
#define	DELEGATE_LPORT	(Conn->dl.p_port)
#define ACT_TRANSLATOR	(Conn->act_translator)

#define ClientEOF	(Conn->cl.p_closed)
#define tcCLOSED	(Conn->cl_tcCLOSED)
#define cl_sockFd	cl.p_sock	
#define ClientSock	(Conn->cl_sockFd)
#define CLNT_PROTO	(Conn->cl.p_proto)
#define CLNT_HOST	(Conn->cl.p_host)
#define CLNT_PORT	(Conn->cl.p_port)

#define ClientFlags	(Conn->cl.p_flags)
#define ServerFlags	(Conn->sv.p_flags)
#define PF_RIDENT	0x0001
#define PF_RIDENT_SENT	0x0002
#define PF_RIDENT_OFF	0x0004

#define ConnFname	(Conn->cl.p_connFname)
#define DontKeepAlive	(Conn->cl.p_dontKeepAlive)
#define ClntKeepAlive	(Conn->cl.p_wantKeepAlive)
#define WillKeepAlive	(Conn->cl.p_willKeepAlive)
#define SentKeepAlive	(Conn->cl.p_sentKeepAlive)
#define WhyClosed	(Conn->cl.p_whyclosed)
#define ServKeepAlive	(Conn->sv.p_sentKeepAlive)

#define EchoRequest	(Conn->xf_echoreq)
#define CLNT_USER	(Conn->cl_user)

#define Client_VAddr	(&Conn->cl_peerAddr)
#define Client_Host	(Conn->cl_peerAddr.a_name)
#define Client_Port	(Conn->cl_peerAddr.a_port)
#define Client_Ident	(Conn->cl_Ident)

#define RequestSerno	(Conn->cl.p_reqserno)
#define ServReqSerno	(Conn->sv.p_reqserno)
#define CKA_Timeout	(Conn->sv_ka_timeout)
#define CKA_RemAlive	(Conn->sv_ka_remalive)

#define DFLT_PROTO	(Conn->sv_dflt.p_proto)
#define DFLT_HOST	(Conn->sv_dflt.p_host)
#define DFLT_PORT	(Conn->sv_dflt.p_port)
#define DFLT_SITE	(Conn->sv_dflt.p_site)
#define DFLT_PORTMAP	(Conn->sv_portmap)

#define REAL_PROTO	(Conn->sv.p_proto)
#define REAL_HOST	(Conn->sv.p_host)
#define REAL_PORT	(Conn->sv.p_port)
#define REAL_USER	(Conn->sv.p_user)
#define REAL_SITE	(Conn->sv.p_site)
#define DST_USER	(REAL_USER[0] ? REAL_USER : NULL)
#define IsAnonymous	(Conn->sv.p_anonymous)

#define DST_PROTO	(REAL_HOST[0] ? REAL_PROTO : DFLT_PROTO)
#define DST_HOST	(REAL_HOST[0] ? REAL_HOST  : DFLT_HOST)
#define DST_PORT	(REAL_HOST[0] ? REAL_PORT  : DFLT_PORT)

#define REMOTE_PROTO	(Conn->sv_remote.p_proto)
#define REMOTE_HOST	(Conn->sv_remote.p_host)
#define REMOTE_PORT	(Conn->sv_remote.p_port)

#define ConnType	(Conn->sv.p_connType)
#define ConnError	(Conn->sv.p_connError)
#define IsInternal	(Conn->co_internal)
#define IsLocal		(Conn->co_local)
#define CONN_START	(Conn->co_start)
#define CONN_DONE	(Conn->co_done)
#define ConnDelay	(Conn->co_delay)
#define PERMIT_GLOBAL	(Conn->permitGlobal)

#define PadCRLF		(Conn->ht_PadCRLF)
#define SimpleContType	(Conn->ht_SimpleContType)
#define LockedByClient	(Conn->ht_LockedByClient)
#define httpStat	(Conn->ht_stat)
#define httpStatX	(Conn->ht_statx)
#define genETag		(Conn->ht_genETag)
#define DELEGATE_FLAGS	(Conn->ht_flags)
#define RespWithBody	(Conn->resp_with_body)

#define CO_REJECTED	1
#define CO_CANTRESOLV	2
#define CO_CANTCONN	4
#define CO_TIMEOUT	8
#define CO_REFUSED	0x10
#define CO_UNREACH	0x20
#define CO_NOROUTE	0x40 /* no available route in CONNECT */
#define CO_CLOSED	0x100 /* logically closed (eg. by QUIT command) */

#define MountOptions	(Conn->mo_options)
#define MO_MasterHost	(Conn->mo_master.p_host)
#define MO_MasterPort	(Conn->mo_master.p_port)
#define MO_ProxyHost	(Conn->mo_proxy.p_host)
#define MO_ProxyPort	(Conn->mo_proxy.p_port)
#define MO_Authorizer	(Conn->mo_authorizer)
#define withTmpProxy()	(MO_ProxyHost[0] && MO_ProxyPort)
#define withTmpMaster()	(MO_MasterHost[0] && MO_MasterPort)

/*
 *	GOPHER delegater
 */
extern int   GOPHER_EXPIRE;
extern char *GOPHER_CACHE_ITEM;

/*
 *	HTTP
 */
extern int   HTTP_EXPIRE;

/*
 *	FTP
 */
extern int FTP_ACCEPT_TIMEOUT;

/*
 *	Proxy Telnet/FTP
 */
extern int LOGIN_TIMEOUT;

extern FILE *dirfopen();
extern FILE *expfopen();
extern char *cachedir();
extern char *getenv();

extern char *DELEGATE_ver();
extern char *DELEGATE_version();
extern char *DELEGATE_Ver();
extern char *DELEGATE_Version();
extern char *DELEGATE_verdate();
extern char *DELEGATE_copyright();
extern char *DELEGATE_homepage();

extern char *fgetsTIMEOUT();

extern char *mount_url_to();
extern char *mount_url_from();

#define PN_LONG		"host=%A (%H); port=%P;"
#define PN_ADDRHOSTPORT	"%A %H %P"
#define PN_HOSTPORT	"%H:%P"
#define PN_ADDRPORT	"%A:%P"
#define PN_HOST		"%H"
#define PN_PORT		"%P"
#define PN_ADDR		"%A"

extern int   DELEGATE_LISTEN;

extern char *fgetsFromCbuf();
extern double Time();
extern double StartTime;

extern int LOG_GENERIC;

extern char *CCV_TOCL;
extern char *CCV_TOSV;


/*
 *
 */
#define RELAY_NO	0x0000 /* no relay (work as an orignal server) */
#define RELAY_PROXY	0x0001 /* by CERN (full URL) */
#define RELAY_DELEGATE	0x0006 /* by DELEGATE */
#define RELAY_DELEGATE1	0x0002 /* by /=@=URL rewriting (obsolete) */
#define RELAY_DELEGATE2	0x0004 /* by /-_-URL rewriting */
#define RELAY_SELF	0x0010 /* rewrite request only */
#define RELAY_INLINE	0x0020 /* rewrite inline images in response */
#define RELAY_PROTO	0x0030 /* rewrite URLs of the same protocols */
#define RELAY_SERVER	0x0040 /* rewrite URLS of the same saver */
#define RELAY_ANY	0x0050
#define RELAY_APPLET	0x0100 /* relay <APPLET> */
#define RELAY_OBJECT	0x0200 /* relay <OBJECT> and <EMBED> */
#define RELAY_JAVA	0x0300 /* relay <APPLET> <OBJECT> and <EMBED> */
#define RELAY_ORIGIN	0x0400 /* origin server */
#define RELAY_VHOST	0x0800 /* relay to host in Host: field */


#define STR_VOLA	0
#define STR_ALLOC	1
#define STR_OVWR	2

#define CONN_NOPROXY	1
#define CONN_NOMASTER	2
#define CONN_NOSOCKS	4

#endif
